#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Murder Mystery Machine
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250803.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='murder-mystery-machine'
GAME_NAME='Murder Mystery Machine'

ARCHIVE_BASE_1_NAME='setup_murder_mystery_machine_1.0.3_(67137).exe'
ARCHIVE_BASE_1_MD5='da0f831f7fba786c49478e67edca4db9'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='2721341'
ARCHIVE_BASE_1_VERSION='1.0.3-gog67137'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/murder_mystery_machine'

ARCHIVE_BASE_0_NAME='setup_murder_mystery_machine_1.0.3_(52168).exe'
ARCHIVE_BASE_0_MD5='69ded10c35ef888f13823fe5ebc8d2ac'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='2800000'
ARCHIVE_BASE_0_VERSION='1.0.3-gog52168'

UNITY3D_NAME='murdermysterymachine'

CONTENT_PATH_DEFAULT='.'

WINE_DIRECT3D_RENDERER='dxvk'
WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/Blazing Griffin/Murder Mystery Machine'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up temporary files.

working_directory_cleanup

exit 0
