#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Darkest Dungeon
# send your bug reports to vv221@dotslashplay.it
###

script_version=20250721.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='darkest-dungeon'
GAME_NAME='Darkest Dungeon'

## This build is the one provided by GOG since 2025-05-29,
## but it is an old build from 2018.
ARCHIVE_BASE_OLD_8_NAME='darkest_dungeon_24788_82473.sh'
ARCHIVE_BASE_OLD_8_MD5='875d36d3beca80c350c8848dc0e421c0'
ARCHIVE_BASE_OLD_8_SIZE='2269724'
ARCHIVE_BASE_OLD_8_VERSION='24788-gog82473'
ARCHIVE_BASE_OLD_8_URL='https://www.gog.com/game/darkest_dungeon'

## This build comes with a broken installer for The Crimson Court expansion.
ARCHIVE_BASE_0_NAME='darkest_dungeon_26186_81633.sh'
ARCHIVE_BASE_0_MD5='5d63601a7640cc359b960be054eb294e'
ARCHIVE_BASE_0_SIZE='2294082'
ARCHIVE_BASE_0_VERSION='26186-gog81633'

ARCHIVE_BASE_OLD_7_NAME='darkest_dungeon_24839_28859.sh'
ARCHIVE_BASE_OLD_7_MD5='2a04beb04b3129b4bd68b4dd9023e82d'
ARCHIVE_BASE_OLD_7_SIZE='2300000'
ARCHIVE_BASE_OLD_7_VERSION='24839-gog28859'

ARCHIVE_BASE_OLD_6_NAME='darkest_dungeon_24788_26004.sh'
ARCHIVE_BASE_OLD_6_MD5='be838bdc8e7c971e4d412f833fd348ac'
ARCHIVE_BASE_OLD_6_SIZE='2300000'
ARCHIVE_BASE_OLD_6_VERSION='24788-gog26004'

ARCHIVE_BASE_OLD_5_NAME='darkest_dungeon_en_24358_23005.sh'
ARCHIVE_BASE_OLD_5_MD5='3d7dc739665003d48589cdbe6cc472ef'
ARCHIVE_BASE_OLD_5_SIZE='2300000'
ARCHIVE_BASE_OLD_5_VERSION='24358-gog23005'

ARCHIVE_BASE_OLD_4_NAME='darkest_dungeon_en_24154_22522.sh'
ARCHIVE_BASE_OLD_4_MD5='361d3e7b117725e8ce3982d183d4810a'
ARCHIVE_BASE_OLD_4_SIZE='2300000'
ARCHIVE_BASE_OLD_4_VERSION='24154-gog22522'

ARCHIVE_BASE_OLD_3_NAME='darkest_dungeon_en_23904_21681.sh'
ARCHIVE_BASE_OLD_3_MD5='9ddb131060d0995c4ceb56dd9c846b8f'
ARCHIVE_BASE_OLD_3_SIZE='2300000'
ARCHIVE_BASE_OLD_3_VERSION='23904-gog21681'

ARCHIVE_BASE_OLD_2_NAME='darkest_dungeon_en_23885_21662.sh'
ARCHIVE_BASE_OLD_2_MD5='ff449de9cfcdf97fa1a27d1073139463'
ARCHIVE_BASE_OLD_2_SIZE='2300000'
ARCHIVE_BASE_OLD_2_VERSION='23885-gog21662'

ARCHIVE_BASE_OLD_1_NAME='darkest_dungeon_en_21142_16140.sh'
ARCHIVE_BASE_OLD_1_MD5='4b43065624dbab74d794c56809170588'
ARCHIVE_BASE_OLD_1_SIZE='2200000'
ARCHIVE_BASE_OLD_1_VERSION='21142-gog16140'

ARCHIVE_BASE_OLD_0_NAME='darkest_dungeon_en_21096_16066.sh'
ARCHIVE_BASE_OLD_0_MD5='435905fe6edd911a8645d4feaf94ec34'
ARCHIVE_BASE_OLD_0_SIZE='2200000'
ARCHIVE_BASE_OLD_0_VERSION='21096-gog16066'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_LIBS_BIN_FILES='
libfmod.so.9
libfmodstudio.so.9'
CONTENT_LIBS_BIN64_RELATIVE_PATH='_linuxnosteam/lib64'
CONTENT_LIBS_BIN64_RELATIVE_PATH_OLD='lib64'
CONTENT_LIBS_BIN64_FILES="$CONTENT_LIBS_BIN_FILES"
CONTENT_LIBS_BIN32_RELATIVE_PATH='_linuxnosteam/lib'
CONTENT_LIBS_BIN32_RELATIVE_PATH_OLD='lib'
CONTENT_LIBS_BIN32_FILES="$CONTENT_LIBS_BIN_FILES"
CONTENT_GAME_BIN64_FILES='
_linuxnosteam/darkest.bin.x86_64'
CONTENT_GAME_BIN64_FILES_OLD='
darkest.bin.x86_64'
CONTENT_GAME_BIN32_FILES='
_linuxnosteam/darkest.bin.x86'
CONTENT_GAME_BIN32_FILES_OLD='
darkest.bin.x86'
CONTENT_GAME_DATA_FILES='
activity_log
audio
__build
campaign
colours
curios
cursors
dlc
dungeons
effects
fe_flow
fonts
fx
game_over
heroes
inventory
_linuxnosteam
loading_screen
localization
loot
maps
modes
mods
monsters
overlays
panels
props
raid
raid_results
scripts
scrolls
shaders
shaders_ps4
shaders_psv
shared
trinkets
upgrades
user_information
video
video_ps4
video_psv
pin
Icon.bmp
steam_appid.txt
svn_revision.txt'
CONTENT_DOC_DATA_RELATIVE_PATH='_linuxnosteam'
CONTENT_DOC_DATA_RELATIVE_PATH_OLD='.'
CONTENT_DOC_DATA_FILES='
README.linux'

APP_MAIN_EXE_BIN64='_linuxnosteam/darkest.bin.x86_64'
APP_MAIN_EXE_BIN64_OLD='darkest.bin.x86_64'
APP_MAIN_EXE_BIN32='_linuxnosteam/darkest.bin.x86'
APP_MAIN_EXE_BIN32_OLD='darkest.bin.x86'
APP_MAIN_ICON='_linuxnosteam/Icon.bmp'
APP_MAIN_ICON_OLD='Icon.bmp'
## Using the wayland backend of SDL triggers a floating point exception,
## with the following trace:
##
## #0  0x00000000013d1887 in _glewHashListExists ()
## #1  0x00000000013d1c5c in glxewContextInit ()
## #2  0x0000000000ed273a in InternalMain(int, char**, SDL_GLprofile) ()
## #3  0x0000000000ed3b61 in main ()
APP_MAIN_PRERUN='
# Prevent a game crash when using the Wayland video backend of SDL
if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
	unset SDL_VIDEODRIVER
fi
'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libssl.so.1.0.0
libstdc++.so.6'
PKG_BIN_DEPENDENCIES_LIBRARIES_OLD='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libstdc++.so.6'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Fix icon background transparency

REQUIREMENTS_LIST="${REQUIREMENTS_LIST:-}
convert"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Fix icon background transparency
	icon_path=$(icon_path 'APP_MAIN_ICON')
	convert "$icon_path" \
		-transparent "#008080" \
		-transparent "#006e6e" \
		"${icon_path%.bmp}_fixed.bmp"
	mv "${icon_path%.bmp}_fixed.bmp" "$icon_path"
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## These values rely on both package context and archive context.
APP_MAIN_EXE_BIN64=$(context_value 'APP_MAIN_EXE_BIN64')
APP_MAIN_EXE_BIN32=$(context_value 'APP_MAIN_EXE_BIN32')

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
