/*
 * Autogenerated by $Id: bsd-spec-analyze.py $
 * from the open source v9Ap6-A specs, build 406 (5e0a212688c6bd7aee92394b6f5e491b4d0fee1d)
 * dated Sun Dec 15 22:18:44 2024 UTC.
 *
 * Do not edit!
 */

/*
 * Copyright (C) 2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */


#ifndef VMM_INCLUDED_SRC_VMMR3_target_armv8_CPUMAllCpuIdArmV8_cpp_h
#define VMM_INCLUDED_SRC_VMMR3_target_armv8_CPUMAllCpuIdArmV8_cpp_h
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif



/**
 * Explodes ARMv8+ features from an array of system register values.
 *
 * @returns VBox status code
 * @param   paSysRegs   The system registers and their values.
 * @param   cSysRegs    Number of system register values.
 * @param   pFeatures   The structure to explode the features into.
 */
VMMDECL(int) CPUMCpuIdExplodeFeaturesArmV8(PCSUPARMSYSREGVAL paSysRegs, uint32_t cSysRegs,
                                           CPUMFEATURESARMV8 *pFeatures)
{
    RT_ZERO(*pFeatures);


    uint64_t const uAArch64_CTR_EL0 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_CTR_EL0);
    pFeatures->fIvipt                 = (((uAArch64_CTR_EL0 >> 14) & 0x3 /*L1Ip*/) == 2 || ((uAArch64_CTR_EL0 >> 14) & 0x3 /*L1Ip*/) == 3); /* FEAT_IVIPT */
    pFeatures->fVpipt                 = (uint32_t)(((uAArch64_CTR_EL0 >> 14) & 0x3 /*L1Ip*/)) == 2;                  /* FEAT_VPIPT */

    uint64_t const uAArch64_ID_AA64DFR0_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ID_AA64DFR0_EL1);
    pFeatures->fBrbe                  = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >> 52) & 0xf /*BRBE*/)) >= 1;          /* FEAT_BRBE */
    pFeatures->fBrbeV1p1              = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >> 52) & 0xf /*BRBE*/)) >= 2;          /* FEAT_BRBEv1p1 */
    pFeatures->fDebugV8p1             = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  0) & 0xf /*DebugVer*/)) >= 7;      /* FEAT_Debugv8p1 */
    pFeatures->fDebugV8p2             = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  0) & 0xf /*DebugVer*/)) >= 8;      /* FEAT_Debugv8p2 */
    pFeatures->fDebugV8p4             = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  0) & 0xf /*DebugVer*/)) >= 9;      /* FEAT_Debugv8p4 */
    pFeatures->fDebugV8p8             = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  0) & 0xf /*DebugVer*/)) >= 0xa;    /* FEAT_Debugv8p8 */
    pFeatures->fDebugV8p9             = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  0) & 0xf /*DebugVer*/)) >= 0xb;    /* FEAT_Debugv8p9 */
    pFeatures->fDoubleLock            = ((int32_t)((uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >> 36) & 0xf /*DoubleLock*/)) << 28) >> 28) >= 0; /* FEAT_DoubleLock */
    pFeatures->fEte                   = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  4) & 0xf /*TraceVer*/)) >= 1;      /* FEAT_ETE */
    pFeatures->fHpmn0                 = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >> 60) & 0xf /*HPMN0*/)) >= 1;         /* FEAT_HPMN0 */
    pFeatures->fMtPmu                 = ((int32_t)((uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >> 48) & 0xf /*MTPMU*/)) << 28) >> 28) >= 1; /* FEAT_MTPMU */
    pFeatures->fPmuV3                 = ((uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  8) & 0xf /*PMUVer*/)) >= 1) && ((uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  8) & 0xf /*PMUVer*/)) < 0xf); /* FEAT_PMUv3 */
    pFeatures->fPmuV3Ss               = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >> 16) & 0xf /*PMSS*/)) >= 1;          /* FEAT_PMUv3_SS */
    pFeatures->fPmuV3p1               = ((uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  8) & 0xf /*PMUVer*/)) >= 4) && ((uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  8) & 0xf /*PMUVer*/)) < 0xf); /* FEAT_PMUv3p1 */
    pFeatures->fPmuV3p4               = ((uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  8) & 0xf /*PMUVer*/)) >= 5) && ((uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  8) & 0xf /*PMUVer*/)) < 0xf); /* FEAT_PMUv3p4 */
    pFeatures->fPmuV3p5               = ((uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  8) & 0xf /*PMUVer*/)) >= 6) && ((uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  8) & 0xf /*PMUVer*/)) < 0xf); /* FEAT_PMUv3p5 */
    pFeatures->fPmuV3p7               = ((uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  8) & 0xf /*PMUVer*/)) >= 7) && ((uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  8) & 0xf /*PMUVer*/)) < 0xf); /* FEAT_PMUv3p7 */
    pFeatures->fPmuV3p8               = ((uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  8) & 0xf /*PMUVer*/)) >= 8) && ((uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  8) & 0xf /*PMUVer*/)) < 0xf); /* FEAT_PMUv3p8 */
    pFeatures->fPmuV3p9               = ((uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  8) & 0xf /*PMUVer*/)) >= 9) && ((uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  8) & 0xf /*PMUVer*/)) < 0xf); /* FEAT_PMUv3p9 */
    pFeatures->fSebep                 = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >> 24) & 0xf /*SEBEP*/)) >= 1;         /* FEAT_SEBEP */
    pFeatures->fSpe                   = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >> 32) & 0xf /*PMSVer*/)) >= 1;        /* FEAT_SPE */
    pFeatures->fSpeV1p1               = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >> 32) & 0xf /*PMSVer*/)) >= 2;        /* FEAT_SPEv1p1 */
    pFeatures->fSpeV1p2               = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >> 32) & 0xf /*PMSVer*/)) >= 3;        /* FEAT_SPEv1p2 */
    pFeatures->fSpeV1p3               = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >> 32) & 0xf /*PMSVer*/)) >= 4;        /* FEAT_SPEv1p3 */
    pFeatures->fSpeV1p4               = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >> 32) & 0xf /*PMSVer*/)) >= 5;        /* FEAT_SPEv1p4 */
    pFeatures->fSpev1p5               = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >> 32) & 0xf /*PMSVer*/)) >= 6;        /* FEAT_SPEv1p5 */
    pFeatures->fTrbe                  = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >> 44) & 0xf /*TraceBuffer*/)) >= 1;   /* FEAT_TRBE */
    pFeatures->fTrbeExt               = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >> 56) & 0xf /*ExtTrcBuff*/)) >= 1;    /* FEAT_TRBE_EXT */
    pFeatures->fTrbev1p1              = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >> 44) & 0xf /*TraceBuffer*/)) >= 2;   /* FEAT_TRBEv1p1 */
    pFeatures->fTrcSr                 = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >>  4) & 0xf /*TraceVer*/)) >= 1;      /* FEAT_TRC_SR */
    pFeatures->fTrf                   = (uint32_t)(((uAArch64_ID_AA64DFR0_EL1 >> 40) & 0xf /*TraceFilt*/)) >= 1;     /* FEAT_TRF */

    uint64_t const uAArch64_ID_AA64DFR1_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ID_AA64DFR1_EL1);
    pFeatures->fAble                  = (uint32_t)(((uAArch64_ID_AA64DFR1_EL1 >> 40) & 0xf /*ABLE*/)) >= 1;          /* FEAT_ABLE */
    pFeatures->fEbep                  = (uint32_t)(((uAArch64_ID_AA64DFR1_EL1 >> 48) & 0xf /*EBEP*/)) >= 1;          /* FEAT_EBEP */
    pFeatures->fIte                   = (uint32_t)(((uAArch64_ID_AA64DFR1_EL1 >> 44) & 0xf /*ITE*/)) >= 1;           /* FEAT_ITE */
    pFeatures->fPmuV3Icntr            = (uint32_t)(((uAArch64_ID_AA64DFR1_EL1 >> 36) & 0xf /*PMICNTR*/)) >= 1;       /* FEAT_PMUv3_ICNTR */
    pFeatures->fSpeDpfzs              = (uint32_t)(((uAArch64_ID_AA64DFR1_EL1 >> 52) & 0xf /*DPFZS*/)) >= 1;         /* FEAT_SPE_DPFZS */
    pFeatures->fSpmu                  = (uint32_t)(((uAArch64_ID_AA64DFR1_EL1 >> 32) & 0xf /*SPMU*/)) >= 1;          /* FEAT_SPMU */
    pFeatures->fSpmu2                 = (uint32_t)(((uAArch64_ID_AA64DFR1_EL1 >> 32) & 0xf /*SPMU*/)) >= 2;          /* FEAT_SPMU2 */

    uint64_t const uAArch64_ID_AA64DFR2_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ID_AA64DFR2_EL1);
    pFeatures->fBwe                   = (uint32_t)(((uAArch64_ID_AA64DFR2_EL1 >>  4) & 0xf /*BWE*/)) >= 1;           /* FEAT_BWE */
    pFeatures->fBwe2                  = (uint32_t)(((uAArch64_ID_AA64DFR2_EL1 >>  4) & 0xf /*BWE*/)) >= 2;           /* FEAT_BWE2 */
    pFeatures->fSpeExc                = (uint32_t)(((uAArch64_ID_AA64DFR2_EL1 >> 16) & 0xf /*SPE_EXC*/)) >= 1;       /* FEAT_SPE_EXC */
    pFeatures->fSpeNvm                = (uint32_t)(((uAArch64_ID_AA64DFR2_EL1 >> 20) & 0xf /*SPE_nVM*/)) >= 1;       /* FEAT_SPE_nVM */
    pFeatures->fStep2                 = (uint32_t)(((uAArch64_ID_AA64DFR2_EL1 >>  0) & 0xf /*STEP*/)) >= 1;          /* FEAT_STEP2 */
    pFeatures->fTrbeExc               = (uint32_t)(((uAArch64_ID_AA64DFR2_EL1 >> 24) & 0xf /*TRBE_EXC*/)) >= 1;      /* FEAT_TRBE_EXC */

    uint64_t const uAArch64_ID_AA64FPFR0_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ID_AA64FPFR0_EL1);
    pFeatures->fF8F16mm               = ((uAArch64_ID_AA64FPFR0_EL1 >> 26) & 0x1 /*F8MM4*/);                         /* FEAT_F8F16MM */
    pFeatures->fF8F32mm               = ((uAArch64_ID_AA64FPFR0_EL1 >> 27) & 0x1 /*F8MM8*/);                         /* FEAT_F8F32MM */
    pFeatures->fFp8                   = (uint32_t)(((uAArch64_ID_AA64FPFR0_EL1 >> 31) & 0x1 /*F8CVT*/)) >= 1;        /* FEAT_FP8 */
    pFeatures->fFp8Dot2               = (uint32_t)(((uAArch64_ID_AA64FPFR0_EL1 >> 28) & 0x1 /*F8DP2*/)) >= 1;        /* FEAT_FP8DOT2 */
    pFeatures->fFp8Dot4               = (uint32_t)(((uAArch64_ID_AA64FPFR0_EL1 >> 29) & 0x1 /*F8DP4*/)) >= 1;        /* FEAT_FP8DOT4 */
    pFeatures->fFp8Fma                = (uint32_t)(((uAArch64_ID_AA64FPFR0_EL1 >> 30) & 0x1 /*F8FMA*/)) >= 1;        /* FEAT_FP8FMA */

    uint64_t const uAArch64_ID_AA64ISAR0_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ID_AA64ISAR0_EL1);
    pFeatures->fAes                   = (uint32_t)(((uAArch64_ID_AA64ISAR0_EL1 >>  4) & 0xf /*AES*/)) >= 1;          /* FEAT_AES */
    pFeatures->fCrc32                 = (uint32_t)(((uAArch64_ID_AA64ISAR0_EL1 >> 16) & 0xf /*CRC32*/)) >= 1;        /* FEAT_CRC32 */
    pFeatures->fDotProd               = (uint32_t)(((uAArch64_ID_AA64ISAR0_EL1 >> 44) & 0xf /*DP*/)) >= 1;           /* FEAT_DotProd */
    pFeatures->fFhm                   = (uint32_t)(((uAArch64_ID_AA64ISAR0_EL1 >> 48) & 0xf /*FHM*/)) >= 1;          /* FEAT_FHM */
    pFeatures->fFlagM                 = (uint32_t)(((uAArch64_ID_AA64ISAR0_EL1 >> 52) & 0xf /*TS*/)) >= 1;           /* FEAT_FlagM */
    pFeatures->fFlagM2                = (uint32_t)(((uAArch64_ID_AA64ISAR0_EL1 >> 52) & 0xf /*TS*/)) >= 2;           /* FEAT_FlagM2 */
    pFeatures->fLse                   = (uint32_t)(((uAArch64_ID_AA64ISAR0_EL1 >> 20) & 0xf /*Atomic*/)) >= 2;       /* FEAT_LSE */
    pFeatures->fLse128                = (uint32_t)(((uAArch64_ID_AA64ISAR0_EL1 >> 20) & 0xf /*Atomic*/)) >= 3;       /* FEAT_LSE128 */
    pFeatures->fPmull                 = (uint32_t)(((uAArch64_ID_AA64ISAR0_EL1 >>  4) & 0xf /*AES*/)) >= 2;          /* FEAT_PMULL */
    pFeatures->fRdm                   = (uint32_t)(((uAArch64_ID_AA64ISAR0_EL1 >> 28) & 0xf /*RDM*/)) >= 1;          /* FEAT_RDM */
    pFeatures->fRng                   = (uint32_t)(((uAArch64_ID_AA64ISAR0_EL1 >> 60) & 0xf /*RNDR*/)) >= 1;         /* FEAT_RNG */
    pFeatures->fSha1                  = (uint32_t)(((uAArch64_ID_AA64ISAR0_EL1 >>  8) & 0xf /*SHA1*/)) >= 1;         /* FEAT_SHA1 */
    pFeatures->fSha256                = (uint32_t)(((uAArch64_ID_AA64ISAR0_EL1 >> 12) & 0xf /*SHA2*/)) >= 1;         /* FEAT_SHA256 */
    pFeatures->fSha3                  = (uint32_t)(((uAArch64_ID_AA64ISAR0_EL1 >> 32) & 0xf /*SHA3*/)) >= 1;         /* FEAT_SHA3 */
    pFeatures->fSha512                = (uint32_t)(((uAArch64_ID_AA64ISAR0_EL1 >> 12) & 0xf /*SHA2*/)) >= 2;         /* FEAT_SHA512 */
    pFeatures->fSm3                   = (uint32_t)(((uAArch64_ID_AA64ISAR0_EL1 >> 36) & 0xf /*SM3*/)) >= 1;          /* FEAT_SM3 */
    pFeatures->fSm4                   = (uint32_t)(((uAArch64_ID_AA64ISAR0_EL1 >> 40) & 0xf /*SM4*/)) >= 1;          /* FEAT_SM4 */
    pFeatures->fTlbios                = (uint32_t)(((uAArch64_ID_AA64ISAR0_EL1 >> 56) & 0xf /*TLB*/)) >= 1;          /* FEAT_TLBIOS */
    pFeatures->fTlbirange             = (uint32_t)(((uAArch64_ID_AA64ISAR0_EL1 >> 56) & 0xf /*TLB*/)) >= 2;          /* FEAT_TLBIRANGE */
    pFeatures->fTme                   = (uint32_t)(((uAArch64_ID_AA64ISAR0_EL1 >> 24) & 0xf /*TME*/)) >= 1;          /* FEAT_TME */

    uint64_t const uAArch64_ID_AA64ISAR1_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ID_AA64ISAR1_EL1);
    pFeatures->fBf16                  = (uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >> 44) & 0xf /*BF16*/)) >= 1;         /* FEAT_BF16 */
    pFeatures->fDgh                   = (uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >> 48) & 0xf /*DGH*/)) >= 1;          /* FEAT_DGH */
    pFeatures->fDpb                   = (uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >>  0) & 0xf /*DPB*/)) >= 1;          /* FEAT_DPB */
    pFeatures->fDpb2                  = (uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >>  0) & 0xf /*DPB*/)) >= 2;          /* FEAT_DPB2 */
    pFeatures->fEbf16                 = (uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >> 44) & 0xf /*BF16*/)) >= 2;         /* FEAT_EBF16 */
    pFeatures->fFcma                  = (uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >> 16) & 0xf /*FCMA*/)) >= 1;         /* FEAT_FCMA */
    pFeatures->fFrintts               = (uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >> 32) & 0xf /*FRINTTS*/)) >= 1;      /* FEAT_FRINTTS */
    pFeatures->fI8mm                  = (uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >> 52) & 0xf /*I8MM*/)) >= 1;         /* FEAT_I8MM */
    pFeatures->fJscvt                 = (uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >> 12) & 0xf /*JSCVT*/)) >= 1;        /* FEAT_JSCVT */
    pFeatures->fLrcpc                 = (uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >> 20) & 0xf /*LRCPC*/)) >= 1;        /* FEAT_LRCPC */
    pFeatures->fLrcpc2                = (uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >> 20) & 0xf /*LRCPC*/)) >= 2;        /* FEAT_LRCPC2 */
    pFeatures->fLrcpc3                = (uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >> 20) & 0xf /*LRCPC*/)) >= 3;        /* FEAT_LRCPC3 */
    pFeatures->fLs64                  = (uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >> 60) & 0xf /*LS64*/)) >= 1;         /* FEAT_LS64 */
    pFeatures->fLs64WB                = (uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >> 60) & 0xf /*LS64*/)) >= 4;         /* FEAT_LS64WB */
    pFeatures->fLs64Accdata           = (uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >> 60) & 0xf /*LS64*/)) >= 3;         /* FEAT_LS64_ACCDATA */
    pFeatures->fLs64V                 = (uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >> 60) & 0xf /*LS64*/)) >= 2;         /* FEAT_LS64_V */
    pFeatures->fPacImp                = ((uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >> 28) & 0xf /*GPI*/)) >= 1) && ((uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >>  8) & 0xf /*API*/)) >= 1); /* FEAT_PACIMP */
    pFeatures->fPacQarma5             = ((uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >> 24) & 0xf /*GPA*/)) >= 1) && ((uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >>  4) & 0xf /*APA*/)) >= 1); /* FEAT_PACQARMA5 */
    pFeatures->fSb                    = ((int32_t)((uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >> 36) & 0xf /*SB*/)) << 28) >> 28) >= 1; /* FEAT_SB */
    pFeatures->fSpecres               = (uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >> 40) & 0xf /*SPECRES*/)) >= 1;      /* FEAT_SPECRES */
    pFeatures->fSpecres2              = (uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >> 40) & 0xf /*SPECRES*/)) >= 2;      /* FEAT_SPECRES2 */
    pFeatures->fXs                    = (uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >> 56) & 0xf /*XS*/)) >= 1;           /* FEAT_XS */

    uint64_t const uAArch64_ID_AA64ISAR2_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ID_AA64ISAR2_EL1);
    pFeatures->fATs1a                 = (uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >> 60) & 0xf /*ATS1A*/)) >= 1;        /* FEAT_ATS1A */
    pFeatures->fClrBhb                = (uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >> 28) & 0xf /*CLRBHB*/)) >= 1;       /* FEAT_CLRBHB */
    pFeatures->fCmpBr                 = (uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >> 52) & 0xf /*CSSC*/)) >= 2;         /* FEAT_CMPBR */
    pFeatures->fConstPacField         = (uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >> 24) & 0xf /*PAC_frac*/)) == 1;     /* FEAT_CONSTPACFIELD */
    pFeatures->fCssc                  = (uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >> 52) & 0xf /*CSSC*/)) >= 1;         /* FEAT_CSSC */
    pFeatures->fHbc                   = (uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >> 20) & 0xf /*BC*/)) >= 1;           /* FEAT_HBC */
    pFeatures->fLut                   = (uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >> 56) & 0xf /*LUT*/)) >= 1;          /* FEAT_LUT */
    pFeatures->fMops                  = (uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >> 16) & 0xf /*MOPS*/)) >= 1;         /* FEAT_MOPS */
    pFeatures->fPacQarma3             = ((uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >>  8) & 0xf /*GPA3*/)) >= 1) && ((uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >> 12) & 0xf /*APA3*/)) >= 1); /* FEAT_PACQARMA3 */
    pFeatures->fPCDPHint              = (uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >> 44) & 0xf /*PCDPHINT*/)) >= 1;     /* FEAT_PCDPHINT */
    pFeatures->fPrfmSlc               = (uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >> 40) & 0xf /*PRFMSLC*/)) >= 1;      /* FEAT_PRFMSLC */
    pFeatures->fRpres                 = (uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >>  4) & 0xf /*RPRES*/)) >= 1;        /* FEAT_RPRES */
    pFeatures->fRprfm                 = (uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >> 48) & 0xf /*RPRFM*/)) >= 1;        /* FEAT_RPRFM */
    pFeatures->fSysInstr128           = (uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >> 36) & 0xf /*SYSINSTR_128*/)) >= 1; /* FEAT_SYSINSTR128 */
    pFeatures->fSysReg128             = (uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >> 32) & 0xf /*SYSREG_128*/)) >= 1;   /* FEAT_SYSREG128 */
    pFeatures->fWfxt                  = (uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >>  0) & 0xf /*WFxT*/)) >= 2;         /* FEAT_WFxT */

    uint64_t const uAArch64_ID_AA64ISAR3_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ID_AA64ISAR3_EL1);
    pFeatures->fCpa                   = (uint32_t)(((uAArch64_ID_AA64ISAR3_EL1 >>  0) & 0xf /*CPA*/)) >= 1;          /* FEAT_CPA */
    pFeatures->fCpa2                  = (uint32_t)(((uAArch64_ID_AA64ISAR3_EL1 >>  0) & 0xf /*CPA*/)) >= 2;          /* FEAT_CPA2 */
    pFeatures->fFaMinMax              = (uint32_t)(((uAArch64_ID_AA64ISAR3_EL1 >>  4) & 0xf /*FAMINMAX*/)) >= 1;     /* FEAT_FAMINMAX */
    pFeatures->fFpRcvt                = (uint32_t)(((uAArch64_ID_AA64ISAR3_EL1 >> 28) & 0xf /*FPRCVT*/)) >= 1;       /* FEAT_FPRCVT */
    pFeatures->fLsfe                  = (uint32_t)(((uAArch64_ID_AA64ISAR3_EL1 >> 16) & 0xf /*LSFE*/)) >= 1;         /* FEAT_LSFE */
    pFeatures->fLsui                  = (uint32_t)(((uAArch64_ID_AA64ISAR3_EL1 >> 24) & 0xf /*LSUI*/)) >= 1;         /* FEAT_LSUI */
    pFeatures->fOccmo                 = (uint32_t)(((uAArch64_ID_AA64ISAR3_EL1 >> 20) & 0xf /*OCCMO*/)) >= 1;        /* FEAT_OCCMO */
    pFeatures->fTlbiW                 = (uint32_t)(((uAArch64_ID_AA64ISAR3_EL1 >>  8) & 0xf /*TLBIW*/)) >= 1;        /* FEAT_TLBIW */

    uint64_t const uAArch64_ID_AA64MMFR0_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ID_AA64MMFR0_EL1);
    pFeatures->fAsid16                = (uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >>  4) & 0xf /*ASIDBits*/)) >= 2;     /* FEAT_ASID16 */
    pFeatures->fEcv                   = (uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >> 60) & 0xf /*ECV*/)) >= 1;          /* FEAT_ECV */
    pFeatures->fEcvPOff               = (uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >> 60) & 0xf /*ECV*/)) >= 2;          /* FEAT_ECV_POFF */
    pFeatures->fExs                   = (uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >> 44) & 0xf /*ExS*/)) >= 1;          /* FEAT_ExS */
    pFeatures->fFgt                   = (uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >> 56) & 0xf /*FGT*/)) >= 1;          /* FEAT_FGT */
    pFeatures->fFgt2                  = (uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >> 56) & 0xf /*FGT*/)) >= 2;          /* FEAT_FGT2 */
    pFeatures->fGtg                   = (uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >> 32) & 0xf /*TGran16_2*/)) >= 1;    /* FEAT_GTG */
    pFeatures->fLpa                   = (uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >>  0) & 0xf /*PARange*/)) >= 6;      /* FEAT_LPA */
    pFeatures->fLpa2                  = ((uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >> 28) & 0xf /*TGran4*/)) >= 1) || ((uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >> 20) & 0xf /*TGran16*/)) >= 2) || ((uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >> 40) & 0xf /*TGran4_2*/)) >= 3) || ((uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >> 32) & 0xf /*TGran16_2*/)) >= 3); /* FEAT_LPA2 */
    pFeatures->fMixedEnd              = (uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >>  8) & 0xf /*BigEnd*/)) >= 1;       /* FEAT_MixedEnd */
    pFeatures->fMixedEndEl0           = ((uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >> 16) & 0xf /*BigEndEL0*/)) >= 1) || ((uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >>  8) & 0xf /*BigEnd*/)) >= 1); /* FEAT_MixedEndEL0 */
    pFeatures->fTGran16K              = (uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >> 20) & 0xf /*TGran16*/)) >= 1;      /* FEAT_TGran16K */
    pFeatures->fTGran4K               = ((int32_t)((uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >> 28) & 0xf /*TGran4*/)) << 28) >> 28) >= 0; /* FEAT_TGran4K */
    pFeatures->fTGran64K              = ((int32_t)((uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >> 24) & 0xf /*TGran64*/)) << 28) >> 28) >= 0; /* FEAT_TGran64K */

    uint64_t const uAArch64_ID_AA64MMFR1_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ID_AA64MMFR1_EL1);
    pFeatures->fAfp                   = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >> 44) & 0xf /*AFP*/)) >= 1;          /* FEAT_AFP */
    pFeatures->fCmow                  = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >> 56) & 0xf /*CMOW*/)) >= 1;         /* FEAT_CMOW */
    pFeatures->fEcBhb                 = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >> 60) & 0xf /*ECBHB*/)) >= 1;        /* FEAT_ECBHB */
    pFeatures->fEts2                  = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >> 36) & 0xf /*ETS*/)) >= 2;          /* FEAT_ETS2 */
    pFeatures->fEts3                  = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >> 36) & 0xf /*ETS*/)) >= 3;          /* FEAT_ETS3 */
    pFeatures->fHafdbs                = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >>  0) & 0xf /*HAFDBS*/)) >= 1;       /* FEAT_HAFDBS */
    pFeatures->fHaft                  = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >>  0) & 0xf /*HAFDBS*/)) >= 3;       /* FEAT_HAFT */
    pFeatures->fHcx                   = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >> 40) & 0xf /*HCX*/)) >= 1;          /* FEAT_HCX */
    pFeatures->fHdbss                 = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >>  0) & 0xf /*HAFDBS*/)) >= 4;       /* FEAT_HDBSS */
    pFeatures->fHpds                  = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >> 12) & 0xf /*HPDS*/)) >= 1;         /* FEAT_HPDS */
    pFeatures->fHpds2                 = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >> 12) & 0xf /*HPDS*/)) >= 2;         /* FEAT_HPDS2 */
    pFeatures->fLor                   = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >> 16) & 0xf /*LO*/)) >= 1;           /* FEAT_LOR */
    pFeatures->fPan                   = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >> 20) & 0xf /*PAN*/)) >= 1;          /* FEAT_PAN */
    pFeatures->fPan2                  = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >> 20) & 0xf /*PAN*/)) >= 2;          /* FEAT_PAN2 */
    pFeatures->fPan3                  = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >> 20) & 0xf /*PAN*/)) >= 3;          /* FEAT_PAN3 */
    pFeatures->fSpecSei               = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >> 24) & 0xf /*SpecSEI*/)) >= 1;      /* FEAT_SpecSEI */
    pFeatures->fTidcp1                = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >> 52) & 0xf /*TIDCP1*/)) >= 1;       /* FEAT_TIDCP1 */
    pFeatures->fTwed                  = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >> 32) & 0xf /*TWED*/)) >= 1;         /* FEAT_TWED */
    pFeatures->fVhe                   = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >>  8) & 0xf /*VH*/)) >= 1;           /* FEAT_VHE */
    pFeatures->fVmid16                = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >>  4) & 0xf /*VMIDBits*/)) >= 2;     /* FEAT_VMID16 */
    pFeatures->fXnx                   = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >> 28) & 0xf /*XNX*/)) >= 1;          /* FEAT_XNX */
    pFeatures->fNTlbpa                = (uint32_t)(((uAArch64_ID_AA64MMFR1_EL1 >> 48) & 0xf /*nTLBPA*/)) >= 1;       /* FEAT_nTLBPA */

    uint64_t const uAArch64_ID_AA64MMFR2_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ID_AA64MMFR2_EL1);
    pFeatures->fCcidx                 = (uint32_t)(((uAArch64_ID_AA64MMFR2_EL1 >> 20) & 0xf /*CCIDX*/)) >= 1;        /* FEAT_CCIDX */
    pFeatures->fE0Pd                  = (uint32_t)(((uAArch64_ID_AA64MMFR2_EL1 >> 60) & 0xf /*E0PD*/)) >= 1;         /* FEAT_E0PD */
    pFeatures->fEvt                   = (uint32_t)(((uAArch64_ID_AA64MMFR2_EL1 >> 56) & 0xf /*EVT*/)) >= 1;          /* FEAT_EVT */
    pFeatures->fIdst                  = (uint32_t)(((uAArch64_ID_AA64MMFR2_EL1 >> 36) & 0xf /*IDS*/)) >= 1;          /* FEAT_IDST */
    pFeatures->fIdte3                 = (uint32_t)(((uAArch64_ID_AA64MMFR2_EL1 >> 36) & 0xf /*IDS*/)) >= 2;          /* FEAT_IDTE3 */
    pFeatures->fIesb                  = (uint32_t)(((uAArch64_ID_AA64MMFR2_EL1 >> 12) & 0xf /*IESB*/)) >= 1;         /* FEAT_IESB */
    pFeatures->fLse2                  = (uint32_t)(((uAArch64_ID_AA64MMFR2_EL1 >> 32) & 0xf /*AT*/)) >= 1;           /* FEAT_LSE2 */
    pFeatures->fLsmaoc                = (uint32_t)(((uAArch64_ID_AA64MMFR2_EL1 >>  8) & 0xf /*LSM*/)) >= 1;          /* FEAT_LSMAOC */
    pFeatures->fLva                   = (uint32_t)(((uAArch64_ID_AA64MMFR2_EL1 >> 16) & 0xf /*VARange*/)) >= 1;      /* FEAT_LVA */
    pFeatures->fLva3                  = (uint32_t)(((uAArch64_ID_AA64MMFR2_EL1 >> 16) & 0xf /*VARange*/)) >= 2;      /* FEAT_LVA3 */
    pFeatures->fS2Fwb                 = (uint32_t)(((uAArch64_ID_AA64MMFR2_EL1 >> 40) & 0xf /*FWB*/)) >= 1;          /* FEAT_S2FWB */
    pFeatures->fTtcnp                 = (uint32_t)(((uAArch64_ID_AA64MMFR2_EL1 >>  0) & 0xf /*CnP*/)) >= 1;          /* FEAT_TTCNP */
    pFeatures->fTtl                   = (uint32_t)(((uAArch64_ID_AA64MMFR2_EL1 >> 48) & 0xf /*TTL*/)) >= 1;          /* FEAT_TTL */
    pFeatures->fTtst                  = (uint32_t)(((uAArch64_ID_AA64MMFR2_EL1 >> 28) & 0xf /*ST*/)) >= 1;           /* FEAT_TTST */
    pFeatures->fUao                   = (uint32_t)(((uAArch64_ID_AA64MMFR2_EL1 >>  4) & 0xf /*UAO*/)) >= 1;          /* FEAT_UAO */

    uint64_t const uAArch64_ID_AA64MMFR3_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ID_AA64MMFR3_EL1);
    pFeatures->fAderr                 = (uint32_t)(((uAArch64_ID_AA64MMFR3_EL1 >> 56) & 0xf /*ADERR*/)) >= 2;        /* FEAT_ADERR */
    pFeatures->fAie                   = (uint32_t)(((uAArch64_ID_AA64MMFR3_EL1 >> 24) & 0xf /*AIE*/)) >= 1;          /* FEAT_AIE */
    pFeatures->fAnerr                 = (uint32_t)(((uAArch64_ID_AA64MMFR3_EL1 >> 44) & 0xf /*ANERR*/)) >= 2;        /* FEAT_ANERR */
    pFeatures->fD128                  = (uint32_t)(((uAArch64_ID_AA64MMFR3_EL1 >> 32) & 0xf /*D128*/)) >= 1;         /* FEAT_D128 */
    pFeatures->fFpaccSpec             = (uint32_t)(((uAArch64_ID_AA64MMFR3_EL1 >> 60) & 0xf /*Spec_FPACC*/)) >= 1;   /* FEAT_FPACC_SPEC */
    pFeatures->fMec                   = (uint32_t)(((uAArch64_ID_AA64MMFR3_EL1 >> 28) & 0xf /*MEC*/)) >= 1;          /* FEAT_MEC */
    pFeatures->fS1Pie                 = (uint32_t)(((uAArch64_ID_AA64MMFR3_EL1 >>  8) & 0xf /*S1PIE*/)) >= 1;        /* FEAT_S1PIE */
    pFeatures->fS1Poe                 = (uint32_t)(((uAArch64_ID_AA64MMFR3_EL1 >> 16) & 0xf /*S1POE*/)) >= 1;        /* FEAT_S1POE */
    pFeatures->fS2Pie                 = (uint32_t)(((uAArch64_ID_AA64MMFR3_EL1 >> 12) & 0xf /*S2PIE*/)) >= 1;        /* FEAT_S2PIE */
    pFeatures->fS2Poe                 = (uint32_t)(((uAArch64_ID_AA64MMFR3_EL1 >> 20) & 0xf /*S2POE*/)) >= 1;        /* FEAT_S2POE */
    pFeatures->fSctlr2                = (uint32_t)(((uAArch64_ID_AA64MMFR3_EL1 >>  4) & 0xf /*SCTLRX*/)) >= 1;       /* FEAT_SCTLR2 */
    pFeatures->fTcr2                  = (uint32_t)(((uAArch64_ID_AA64MMFR3_EL1 >>  0) & 0xf /*TCRX*/)) >= 1;         /* FEAT_TCR2 */

    uint64_t const uAArch64_ID_AA64MMFR4_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ID_AA64MMFR4_EL1);
    pFeatures->fAsid2                 = (uint32_t)(((uAArch64_ID_AA64MMFR4_EL1 >>  8) & 0xf /*ASID2*/)) >= 1;        /* FEAT_ASID2 */
    pFeatures->fE2H0                  = ((int32_t)((uint32_t)(((uAArch64_ID_AA64MMFR4_EL1 >> 24) & 0xf /*E2H0*/)) << 28) >> 28) >= 0; /* FEAT_E2H0 */
    pFeatures->fE3Dse                 = (uint32_t)(((uAArch64_ID_AA64MMFR4_EL1 >> 36) & 0xf /*E3DSE*/)) >= 1;        /* FEAT_E3DSE */
    pFeatures->fFgwtE3                = (uint32_t)(((uAArch64_ID_AA64MMFR4_EL1 >> 16) & 0xf /*FGWTE3*/)) >= 1;       /* FEAT_FGWTE3 */
    pFeatures->fHacdbs                = (uint32_t)(((uAArch64_ID_AA64MMFR4_EL1 >> 12) & 0xf /*HACDBS*/)) >= 1;       /* FEAT_HACDBS */
    pFeatures->fNV2p1                 = (uint32_t)(((uAArch64_ID_AA64MMFR4_EL1 >> 20) & 0xf /*NV_frac*/)) >= 2;      /* FEAT_NV2p1 */
    pFeatures->fRmeGdi                = (uint32_t)(((uAArch64_ID_AA64MMFR4_EL1 >> 28) & 0xf /*RMEGDI*/)) >= 1;       /* FEAT_RME_GDI */

    uint64_t const uAArch64_ID_AA64PFR0_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ID_AA64PFR0_EL1);
    pFeatures->fAa32                  = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >>  0) & 0xf /*EL0*/)) == 2;           /* FEAT_AA32 */
    pFeatures->fAa32El0               = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >>  0) & 0xf /*EL0*/)) == 2;           /* FEAT_AA32EL0 */
    pFeatures->fAa32El1               = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >>  4) & 0xf /*EL1*/)) == 2;           /* FEAT_AA32EL1 */
    pFeatures->fAa32El2               = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >>  8) & 0xf /*EL2*/)) == 2;           /* FEAT_AA32EL2 */
    pFeatures->fAa32El3               = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 12) & 0xf /*EL3*/)) == 2;           /* FEAT_AA32EL3 */
    pFeatures->fAa64El0               = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >>  0) & 0xf /*EL0*/)) >= 1;           /* FEAT_AA64EL0 */
    pFeatures->fAa64El1               = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >>  4) & 0xf /*EL1*/)) >= 1;           /* FEAT_AA64EL1 */
    pFeatures->fAa64El2               = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >>  8) & 0xf /*EL2*/)) >= 1;           /* FEAT_AA64EL2 */
    pFeatures->fAa64El3               = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >>  8) & 0xf /*EL2*/)) >= 1;           /* FEAT_AA64EL3 */
    pFeatures->fAmuV1                 = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 44) & 0xf /*AMU*/)) >= 1;           /* FEAT_AMUv1 */
    pFeatures->fAmuV1p1               = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 44) & 0xf /*AMU*/)) >= 2;           /* FEAT_AMUv1p1 */
    pFeatures->fAdvSimd               = ((int32_t)((uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 20) & 0xf /*AdvSIMD*/)) << 28) >> 28) >= 0; /* FEAT_AdvSIMD */
    pFeatures->fCsv2                  = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 56) & 0xf /*CSV2*/)) >= 1;          /* FEAT_CSV2 */
    pFeatures->fCvs2_2                = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 56) & 0xf /*CSV2*/)) >= 2;          /* FEAT_CSV2_2 */
    pFeatures->fCsv2v3                = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 56) & 0xf /*CSV2*/)) >= 3;          /* FEAT_CSV2_3 */
    pFeatures->fCsv3                  = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 60) & 0xf /*CSV3*/)) >= 1;          /* FEAT_CSV3 */
    pFeatures->fDit                   = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 48) & 0xf /*DIT*/)) >= 1;           /* FEAT_DIT */
    pFeatures->fDoubleFault           = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 28) & 0xf /*RAS*/)) >= 2;           /* FEAT_DoubleFault */
    pFeatures->fFp                    = ((int32_t)((uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 16) & 0xf /*FP*/)) << 28) >> 28) >= 0; /* FEAT_FP */
    pFeatures->fFp16                  = ((int32_t)((uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 20) & 0xf /*AdvSIMD*/)) << 28) >> 28) >= 1; /* FEAT_FP16 */
    pFeatures->fGicV3                 = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 24) & 0xf /*GIC*/)) >= 1;           /* FEAT_GICv3 */
    pFeatures->fGicV3p1               = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 24) & 0xf /*GIC*/)) >= 1;           /* FEAT_GICv3p1 */
    pFeatures->fGicV4                 = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 24) & 0xf /*GIC*/)) >= 1;           /* FEAT_GICv4 */
    pFeatures->fGicV4p1               = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 24) & 0xf /*GIC*/)) >= 3;           /* FEAT_GICv4p1 */
    pFeatures->fMpam                  = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 40) & 0xf /*MPAM*/)) >= 1;          /* FEAT_MPAM */
    pFeatures->fRas                   = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 28) & 0xf /*RAS*/)) >= 1;           /* FEAT_RAS */
    pFeatures->fRasV2                 = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 28) & 0xf /*RAS*/)) >= 3;           /* FEAT_RASv2 */
    pFeatures->fRme                   = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 52) & 0xf /*RME*/)) >= 1;           /* FEAT_RME */
    pFeatures->fRmeGpc2               = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 52) & 0xf /*RME*/)) >= 2;           /* FEAT_RME_GPC2 */
    pFeatures->fRmeGpc3               = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 52) & 0xf /*RME*/)) >= 3;           /* FEAT_RME_GPC3 */
    pFeatures->fSecEl2                = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 36) & 0xf /*SEL2*/)) >= 1;          /* FEAT_SEL2 */
    pFeatures->fSve                   = (uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 32) & 0xf /*SVE*/)) >= 1;           /* FEAT_SVE */

    uint64_t const uAArch64_ID_AA64PFR1_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ID_AA64PFR1_EL1);
    pFeatures->fBti                   = (uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >>  0) & 0xf /*BT*/)) >= 1;            /* FEAT_BTI */
    pFeatures->fDoubleFault2          = (uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >> 56) & 0xf /*DF2*/)) >= 1;           /* FEAT_DoubleFault2 */
    pFeatures->fGcs                   = (uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >> 44) & 0xf /*GCS*/)) >= 1;           /* FEAT_GCS */
    pFeatures->fMte                   = (uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >>  8) & 0xf /*MTE*/)) >= 1;           /* FEAT_MTE */
    pFeatures->fMte2                  = (uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >>  8) & 0xf /*MTE*/)) >= 2;           /* FEAT_MTE2 */
    pFeatures->fMte3                  = (uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >>  8) & 0xf /*MTE*/)) >= 3;           /* FEAT_MTE3 */
    pFeatures->fMteAsymFault          = (uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >>  8) & 0xf /*MTE*/)) >= 3;           /* FEAT_MTE_ASYM_FAULT */
    pFeatures->fMteAsync              = ((int32_t)((uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >> 40) & 0xf /*MTE_frac*/)) << 28) >> 28) >= 0; /* FEAT_MTE_ASYNC */
    pFeatures->fMteCanonicalTags      = (uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >> 52) & 0xf /*MTEX*/)) >= 1;          /* FEAT_MTE_CANONICAL_TAGS */
    pFeatures->fMteNoAddressTags      = (uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >> 52) & 0xf /*MTEX*/)) >= 1;          /* FEAT_MTE_NO_ADDRESS_TAGS */
    pFeatures->fNmi                   = (uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >> 36) & 0xf /*NMI*/)) >= 1;           /* FEAT_NMI */
    pFeatures->fPfar                  = (uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >> 60) & 0xf /*PFAR*/)) >= 1;          /* FEAT_PFAR */
    pFeatures->fRngTrap               = (uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >> 28) & 0xf /*RNDR_trap*/)) >= 1;     /* FEAT_RNG_TRAP */
    pFeatures->fSme                   = (uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >> 24) & 0xf /*SME*/)) >= 1;           /* FEAT_SME */
    pFeatures->fSme2                  = (uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >> 24) & 0xf /*SME*/)) >= 2;           /* FEAT_SME2 */
    pFeatures->fSsbs                  = (uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >>  4) & 0xf /*SSBS*/)) >= 1;          /* FEAT_SSBS */
    pFeatures->fSsbs2                 = (uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >>  4) & 0xf /*SSBS*/)) >= 2;          /* FEAT_SSBS2 */
    pFeatures->fThe                   = (uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >> 48) & 0xf /*THE*/)) >= 1;           /* FEAT_THE */

    uint64_t const uAArch64_ID_AA64PFR2_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ID_AA64PFR2_EL1);
    pFeatures->fFpmr                  = (uint32_t)(((uAArch64_ID_AA64PFR2_EL1 >> 32) & 0xf /*FPMR*/)) >= 1;          /* FEAT_FPMR */
    pFeatures->fMtePerm               = (uint32_t)(((uAArch64_ID_AA64PFR2_EL1 >>  0) & 0xf /*MTEPERM*/)) >= 1;       /* FEAT_MTE_PERM */
    pFeatures->fMteStoreOnly          = (uint32_t)(((uAArch64_ID_AA64PFR2_EL1 >>  4) & 0xf /*MTESTOREONLY*/)) >= 1;  /* FEAT_MTE_STORE_ONLY */
    pFeatures->fMteTaggedFar          = (uint32_t)(((uAArch64_ID_AA64PFR2_EL1 >>  8) & 0xf /*MTEFAR*/)) >= 1;        /* FEAT_MTE_TAGGED_FAR */
    pFeatures->fUinj                  = (uint32_t)(((uAArch64_ID_AA64PFR2_EL1 >> 16) & 0xf /*UINJ*/)) >= 1;          /* FEAT_UINJ */

    uint64_t const uAArch64_ID_AA64SMFR0_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ID_AA64SMFR0_EL1);
    pFeatures->fSme2p1                = (uint32_t)(((uAArch64_ID_AA64SMFR0_EL1 >> 56) & 0xf /*SMEver*/)) >= 2;       /* FEAT_SME2p1 */
    pFeatures->fSmeB16B16             = (uint32_t)(((uAArch64_ID_AA64SMFR0_EL1 >> 43) & 0x1 /*B16B16*/)) >= 1;       /* FEAT_SME_B16B16 */
    pFeatures->fSmeF16F16             = (uint32_t)(((uAArch64_ID_AA64SMFR0_EL1 >> 42) & 0x1 /*F16F16*/)) >= 1;       /* FEAT_SME_F16F16 */
    pFeatures->fSmeF64F64             = (uint32_t)(((uAArch64_ID_AA64SMFR0_EL1 >> 48) & 0x1 /*F64F64*/)) >= 1;       /* FEAT_SME_F64F64 */
    pFeatures->fSmeF8F16              = (uint32_t)(((uAArch64_ID_AA64SMFR0_EL1 >> 41) & 0x1 /*F8F16*/)) >= 1;        /* FEAT_SME_F8F16 */
    pFeatures->fSmeF8F32              = (uint32_t)(((uAArch64_ID_AA64SMFR0_EL1 >> 40) & 0x1 /*F8F32*/)) >= 1;        /* FEAT_SME_F8F32 */
    pFeatures->fSmeFA64               = (uint32_t)(((uAArch64_ID_AA64SMFR0_EL1 >> 63) & 0x1 /*FA64*/)) >= 1;         /* FEAT_SME_FA64 */
    pFeatures->fSmeI16I64             = (uint32_t)(((uAArch64_ID_AA64SMFR0_EL1 >> 52) & 0xf /*I16I64*/)) == 0xf;     /* FEAT_SME_I16I64 */
    pFeatures->fSmeLutv2              = (uint32_t)(((uAArch64_ID_AA64SMFR0_EL1 >> 60) & 0x1 /*LUTv2*/)) >= 1;        /* FEAT_SME_LUTv2 */
    pFeatures->fSmeMop4               = (uint32_t)(((uAArch64_ID_AA64SMFR0_EL1 >>  0) & 0x1 /*SMOP4*/)) >= 1;        /* FEAT_SME_MOP4 */
    pFeatures->fSmeTmop               = (uint32_t)(((uAArch64_ID_AA64SMFR0_EL1 >> 16) & 0x1 /*STMOP*/)) >= 1;        /* FEAT_SME_TMOP */
    pFeatures->fSsveAes               = (uint32_t)(((uAArch64_ID_AA64SMFR0_EL1 >> 24) & 0x1 /*AES*/)) >= 1;          /* FEAT_SSVE_AES */
    pFeatures->fSsveBitPerm           = (uint32_t)(((uAArch64_ID_AA64SMFR0_EL1 >> 25) & 0x1 /*SBitPerm*/)) >= 1;     /* FEAT_SSVE_BitPerm */
    pFeatures->fSsveFexpa             = ((uAArch64_ID_AA64SMFR0_EL1 >> 23) & 0x1 /*SFEXPA*/);                        /* FEAT_SSVE_FEXPA */
    pFeatures->fSsveFp8Dot2           = (uint32_t)(((uAArch64_ID_AA64SMFR0_EL1 >> 28) & 0x1 /*SF8DP2*/)) >= 1;       /* FEAT_SSVE_FP8DOT2 */
    pFeatures->fSsveFp8Dot4           = (uint32_t)(((uAArch64_ID_AA64SMFR0_EL1 >> 29) & 0x1 /*SF8DP4*/)) >= 1;       /* FEAT_SSVE_FP8DOT4 */
    pFeatures->fSsveFp8Fma            = (uint32_t)(((uAArch64_ID_AA64SMFR0_EL1 >> 30) & 0x1 /*SF8FMA*/)) >= 1;       /* FEAT_SSVE_FP8FMA */

    uint64_t const uAArch64_ID_AA64ZFR0_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ID_AA64ZFR0_EL1);
    pFeatures->fF32mm                 = (uint32_t)(((uAArch64_ID_AA64ZFR0_EL1 >> 52) & 0xf /*F32MM*/)) >= 1;         /* FEAT_F32MM */
    pFeatures->fF64mm                 = (uint32_t)(((uAArch64_ID_AA64ZFR0_EL1 >> 56) & 0xf /*F64MM*/)) >= 1;         /* FEAT_F64MM */
    pFeatures->fSve2                  = (uint32_t)(((uAArch64_ID_AA64ZFR0_EL1 >>  0) & 0xf /*SVEver*/)) >= 1;        /* FEAT_SVE2 */
    pFeatures->fSve2p1                = (uint32_t)(((uAArch64_ID_AA64ZFR0_EL1 >>  0) & 0xf /*SVEver*/)) >= 2;        /* FEAT_SVE2p1 */
    pFeatures->fSve2p2                = (uint32_t)(((uAArch64_ID_AA64ZFR0_EL1 >>  0) & 0xf /*SVEver*/)) >= 3;        /* FEAT_SVE2p2 */
    pFeatures->fSveAes                = (uint32_t)(((uAArch64_ID_AA64ZFR0_EL1 >>  4) & 0xf /*AES*/)) >= 1;           /* FEAT_SVE_AES */
    pFeatures->fSveAes2               = (uint32_t)(((uAArch64_ID_AA64ZFR0_EL1 >>  4) & 0xf /*AES*/)) >= 3;           /* FEAT_SVE_AES2 */
    pFeatures->fSveB16B16             = (uint32_t)(((uAArch64_ID_AA64ZFR0_EL1 >> 24) & 0xf /*B16B16*/)) >= 1;        /* FEAT_SVE_B16B16 */
    pFeatures->fSveBfscale            = (uint32_t)(((uAArch64_ID_AA64ZFR0_EL1 >> 24) & 0xf /*B16B16*/)) >= 2;        /* FEAT_SVE_BFSCALE */
    pFeatures->fSveBitPerm            = (uint32_t)(((uAArch64_ID_AA64ZFR0_EL1 >> 16) & 0xf /*BitPerm*/)) >= 1;       /* FEAT_SVE_BitPerm */
    pFeatures->fSveF16F32mm           = (uint32_t)(((uAArch64_ID_AA64ZFR0_EL1 >> 48) & 0xf /*F16MM*/)) >= 1;         /* FEAT_SVE_F16F32MM */
    pFeatures->fSvePmull128           = (uint32_t)(((uAArch64_ID_AA64ZFR0_EL1 >>  4) & 0xf /*AES*/)) >= 2;           /* FEAT_SVE_PMULL128 */
    pFeatures->fSveSha3               = (uint32_t)(((uAArch64_ID_AA64ZFR0_EL1 >> 32) & 0xf /*SHA3*/)) >= 1;          /* FEAT_SVE_SHA3 */
    pFeatures->fSveSm4                = (uint32_t)(((uAArch64_ID_AA64ZFR0_EL1 >> 40) & 0xf /*SM4*/)) >= 1;           /* FEAT_SVE_SM4 */

    uint64_t const uAArch64_ID_ISAR6_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ID_ISAR6_EL1);
    pFeatures->fAa32Bf16              = (uint32_t)(((uAArch64_ID_ISAR6_EL1 >> 20) & 0xf /*BF16*/)) >= 1;             /* FEAT_AA32BF16 */
    pFeatures->fAa32I8mm              = (uint32_t)(((uAArch64_ID_ISAR6_EL1 >> 24) & 0xf /*I8MM*/)) >= 1;             /* FEAT_AA32I8MM */

    uint64_t const uAArch64_ID_MMFR4_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ID_MMFR4_EL1);
    pFeatures->fAa32Hpd               = (uint32_t)(((uAArch64_ID_MMFR4_EL1 >> 16) & 0xf /*HPDS*/)) >= 1;             /* FEAT_AA32HPD */

    uint64_t const uAArch64_MPAMIDR_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_MPAMIDR_EL1);
    pFeatures->fMpamPeBwCtrl          = (uint32_t)(((uAArch64_MPAMIDR_EL1 >> 56) & 0x1 /*HAS_BW_CTRL*/)) >= 1;       /* FEAT_MPAM_PE_BW_CTRL */

    uint64_t const uAArch64_PMMIR_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_PMMIR_EL1);
    pFeatures->fPmuV3Edge             = (uint32_t)(((uAArch64_PMMIR_EL1 >> 24) & 0xf /*EDGE*/)) >= 1;                /* FEAT_PMUv3_EDGE */
    pFeatures->fPmuV3Sme              = (uint32_t)(((uAArch64_PMMIR_EL1 >> 28) & 0x1 /*SME*/)) >= 1;                 /* FEAT_PMUv3_SME */
    pFeatures->fPmuV3Th               = (uint32_t)(((uAArch64_PMMIR_EL1 >> 20) & 0xf /*THWIDTH*/)) >= 1;             /* FEAT_PMUv3_TH */
    pFeatures->fPmuV3Th2              = (uint32_t)(((uAArch64_PMMIR_EL1 >> 24) & 0xf /*EDGE*/)) >= 2;                /* FEAT_PMUv3_TH2 */

    uint64_t const uAArch64_PMSIDR_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_PMSIDR_EL1);
    pFeatures->fSpeAltClk             = (uint32_t)(((uAArch64_PMSIDR_EL1 >> 28) & 0xf /*ALTCLK*/)) >= 1;             /* FEAT_SPE_ALTCLK */
    pFeatures->fSpeCrr                = (uint32_t)(((uAArch64_PMSIDR_EL1 >> 25) & 0x1 /*CRR*/)) >= 1;                /* FEAT_SPE_CRR */
    pFeatures->fSpeEft                = (uint32_t)(((uAArch64_PMSIDR_EL1 >> 26) & 0x1 /*EFT*/)) >= 1;                /* FEAT_SPE_EFT */
    pFeatures->fSpeFds                = (uint32_t)(((uAArch64_PMSIDR_EL1 >>  7) & 0x1 /*FDS*/)) >= 1;                /* FEAT_SPE_FDS */
    pFeatures->fSpeFpf                = (uint32_t)(((uAArch64_PMSIDR_EL1 >> 27) & 0x1 /*FPF*/)) >= 1;                /* FEAT_SPE_FPF */
    pFeatures->fSpeFnE                = (uint32_t)(((uAArch64_PMSIDR_EL1 >>  6) & 0x1 /*FnE*/)) >= 1;                /* FEAT_SPE_FnE */
    pFeatures->fSpePbt                = (uint32_t)(((uAArch64_PMSIDR_EL1 >> 24) & 0x1 /*PBT*/)) >= 1;                /* FEAT_SPE_PBT */
    pFeatures->fSpeSme                = (uint32_t)(((uAArch64_PMSIDR_EL1 >> 32) & 0x1 /*SME*/)) >= 1;                /* FEAT_SPE_SME */

    uint64_t const uAArch64_TRBIDR_EL1 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_TRBIDR_EL1);
    pFeatures->fTrbeMpam              = (uint32_t)(((uAArch64_TRBIDR_EL1 >> 12) & 0xf /*MPAM*/)) >= 2;               /* FEAT_TRBE_MPAM */
    pFeatures->fChk                   = pFeatures->fGcs;                                                             /* FEAT_CHK */

    uint64_t const uAArch64_ICH_VTR_EL2 = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_ICH_VTR_EL2);
    pFeatures->fGicV3Tdir             = pFeatures->fGicV3 && ((uAArch64_ICH_VTR_EL2 >> 19) & 0x1 /*TDS*/);           /* FEAT_GICv3_TDIR */
    pFeatures->fEpac                  = ((uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >>  4) & 0xf /*APA*/)) == 2) || ((uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >>  8) & 0xf /*API*/)) == 2) || ((uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >> 12) & 0xf /*APA3*/)) == 2); /* FEAT_EPAC */
    pFeatures->fFpac                  = ((uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >>  4) & 0xf /*APA*/)) >= 4) || ((uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >>  8) & 0xf /*API*/)) >= 4) || ((uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >> 12) & 0xf /*APA3*/)) >= 4); /* FEAT_FPAC */
    pFeatures->fFpacCombine           = ((uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >>  4) & 0xf /*APA*/)) >= 5) || ((uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >>  8) & 0xf /*API*/)) >= 5) || ((uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >> 12) & 0xf /*APA3*/)) >= 5); /* FEAT_FPACCOMBINE */
    pFeatures->fPAuth                 = ((uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >>  8) & 0xf /*API*/)) >= 1) || ((uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >>  4) & 0xf /*APA*/)) >= 1) || ((uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >> 12) & 0xf /*APA3*/)) >= 1); /* FEAT_PAuth */
    pFeatures->fPAuth2                = ((uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >>  4) & 0xf /*APA*/)) >= 3) || ((uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >>  8) & 0xf /*API*/)) >= 3) || ((uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >> 12) & 0xf /*APA3*/)) >= 3); /* FEAT_PAuth2 */
    pFeatures->fPAuthLR               = ((uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >>  4) & 0xf /*APA*/)) >= 6) || ((uint32_t)(((uAArch64_ID_AA64ISAR1_EL1 >>  8) & 0xf /*API*/)) >= 6) || ((uint32_t)(((uAArch64_ID_AA64ISAR2_EL1 >> 12) & 0xf /*APA3*/)) >= 6); /* FEAT_PAuth_LR */
    pFeatures->fS2TGran16K            = (((uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >> 32) & 0xf /*TGran16_2*/)) == 0) && pFeatures->fTGran16K) || ((uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >> 32) & 0xf /*TGran16_2*/)) >= 2); /* FEAT_S2TGran16K */
    pFeatures->fS2TGran4K             = (((uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >> 40) & 0xf /*TGran4_2*/)) == 0) && pFeatures->fTGran4K) || ((uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >> 40) & 0xf /*TGran4_2*/)) >= 2); /* FEAT_S2TGran4K */
    pFeatures->fS2TGran64K            = (((uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >> 36) & 0xf /*TGran64_2*/)) == 0) && pFeatures->fTGran64K) || ((uint32_t)(((uAArch64_ID_AA64MMFR0_EL1 >> 36) & 0xf /*TGran64_2*/)) >= 2); /* FEAT_S2TGran64K */
    pFeatures->fNv                    = (((uint32_t)(((uAArch64_ID_AA64MMFR4_EL1 >> 20) & 0xf /*NV_frac*/)) >= 1) && ((uint32_t)(((uAArch64_ID_AA64MMFR2_EL1 >> 24) & 0xf /*NV*/)) == 0)) || ((uint32_t)(((uAArch64_ID_AA64MMFR2_EL1 >> 24) & 0xf /*NV*/)) >= 1); /* FEAT_NV */
    pFeatures->fNv2                   = (((uint32_t)(((uAArch64_ID_AA64MMFR4_EL1 >> 20) & 0xf /*NV_frac*/)) >= 1) && ((uint32_t)(((uAArch64_ID_AA64MMFR2_EL1 >> 24) & 0xf /*NV*/)) == 0)) || ((uint32_t)(((uAArch64_ID_AA64MMFR2_EL1 >> 24) & 0xf /*NV*/)) >= 2); /* FEAT_NV2 */
    pFeatures->fBbm                   = ((uint32_t)(((uAArch64_ID_AA64MMFR2_EL1 >> 52) & 0xf /*BBM*/)) >= 1) || false; /* FEAT_BBM */
    pFeatures->fCsv21p1               = ((uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >> 32) & 0xf /*CSV2_frac*/)) >= 1) && ((uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 56) & 0xf /*CSV2*/)) == 1); /* FEAT_CSV2_1p1 */
    pFeatures->fCsv21p2               = ((uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >> 32) & 0xf /*CSV2_frac*/)) >= 2) && ((uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 56) & 0xf /*CSV2*/)) == 1); /* FEAT_CSV2_1p2 */
    pFeatures->fMpamV0p1              = ((uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 40) & 0xf /*MPAM*/)) == 0) && ((uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >> 16) & 0xf /*MPAM_frac*/)) == 1); /* FEAT_MPAMv0p1 */
    pFeatures->fMpamV1p1              = ((uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 40) & 0xf /*MPAM*/)) >= 1) && ((uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >> 16) & 0xf /*MPAM_frac*/)) >= 1); /* FEAT_MPAMv1p1 */
    pFeatures->fRasV1p1               = ((uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 28) & 0xf /*RAS*/)) >= 2) || (((uint32_t)(((uAArch64_ID_AA64PFR0_EL1 >> 28) & 0xf /*RAS*/)) == 1) && ((uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >> 12) & 0xf /*RAS_frac*/)) >= 1)); /* FEAT_RASv1p1 */
    pFeatures->fMte4                  = ((uint32_t)(((uAArch64_ID_AA64PFR1_EL1 >> 52) & 0xf /*MTEX*/)) >= 1) && ((uint32_t)(((uAArch64_ID_AA64PFR2_EL1 >>  4) & 0xf /*MTESTOREONLY*/)) >= 1) && ((uint32_t)(((uAArch64_ID_AA64PFR2_EL1 >>  8) & 0xf /*MTEFAR*/)) >= 1); /* FEAT_MTE4 */

    uint64_t const uAArch64_TRCDEVARCH = cpumCpuIdLookupSysReg(paSysRegs, cSysRegs, ARMV8_AARCH64_SYSREG_TRCDEVARCH);
    pFeatures->fEteV1p1               = pFeatures->fEte && ((uint32_t)(((uAArch64_TRCDEVARCH >> 16) & 0xf /*REVISION*/)) >= 1); /* FEAT_ETEv1p1 */
    pFeatures->fEteV1p2               = pFeatures->fEte && ((uint32_t)(((uAArch64_TRCDEVARCH >> 16) & 0xf /*REVISION*/)) >= 2); /* FEAT_ETEv1p2 */
    pFeatures->fEteV1p3               = pFeatures->fEte && ((uint32_t)(((uAArch64_TRCDEVARCH >> 16) & 0xf /*REVISION*/)) >= 3); /* FEAT_ETEv1p3 */
    pFeatures->fEtmV4                 = pFeatures->fEte && ((uint32_t)(((uAArch64_TRCDEVARCH >> 20) & 0x1 /*PRESENT*/)) == 1) && ((uint32_t)(((uAArch64_TRCDEVARCH >> 21) & 0x7ff /*ARCHITECT*/)) == 0x23b) && ((uint32_t)(((uAArch64_TRCDEVARCH >> 12) & 0xf /*ARCHVER*/)) == 4) && ((uint32_t)(((uAArch64_TRCDEVARCH >>  0) & 0xfff /*ARCHPART*/)) == 0xa13); /* FEAT_ETMv4 */
    pFeatures->fEtmV4p1               = pFeatures->fEtmV4 && ((uint32_t)(((uAArch64_TRCDEVARCH >> 16) & 0xf /*REVISION*/)) >= 1); /* FEAT_ETMv4p1 */
    pFeatures->fEtmV4p2               = pFeatures->fEtmV4 && ((uint32_t)(((uAArch64_TRCDEVARCH >> 16) & 0xf /*REVISION*/)) >= 2); /* FEAT_ETMv4p2 */
    pFeatures->fEtmV4p3               = pFeatures->fEtmV4 && ((uint32_t)(((uAArch64_TRCDEVARCH >> 16) & 0xf /*REVISION*/)) >= 3); /* FEAT_ETMv4p3 */
    pFeatures->fEtmV4p4               = pFeatures->fEtmV4 && ((uint32_t)(((uAArch64_TRCDEVARCH >> 16) & 0xf /*REVISION*/)) >= 4); /* FEAT_ETMv4p4 */
    pFeatures->fEtmV4p5               = pFeatures->fEtmV4 && ((uint32_t)(((uAArch64_TRCDEVARCH >> 16) & 0xf /*REVISION*/)) >= 5); /* FEAT_ETMv4p5 */
    pFeatures->fEtmV4p6               = pFeatures->fEtmV4 && ((uint32_t)(((uAArch64_TRCDEVARCH >> 16) & 0xf /*REVISION*/)) >= 6); /* FEAT_ETMv4p6 */
    pFeatures->fGicV3Nmi              = pFeatures->fGicV3 && pFeatures->fNmi;                                        /* FEAT_GICv3_NMI */
    pFeatures->fSme2p2                = pFeatures->fSme && pFeatures->fSve2p2;                                       /* FEAT_SME2p2 */
    pFeatures->fAa64                  = pFeatures->fAa64El0 || pFeatures->fAa64El1 || pFeatures->fAa64El2 || pFeatures->fAa64El3; /* FEAT_AA64 */

    return cpumCpuIdExplodeFeaturesArmV8Handcoded(paSysRegs, cSysRegs, pFeatures);
}

#ifdef IN_RING3

# include <VBox/vmm/dbgf.h> /* DBGFINFOHLP */

/**
 * Prints the ARMv8+ features in @a pFeatures.
 *
 * @param   pHlp            The output callback helper.
 * @param   cchOutput       The width of the output (for multiple columns).
 *                          Zero is taken to mean a single column.
 * @param   pFeatures       The features to dump
 * @param   pszLabel        The label.
 * @param   pSecondary      Optional secondary feature set to compare with.
 * @param   pszSecondary    The label for the secondary feature set.
 */
VMMR3DECL(void) CPUMR3CpuIdPrintArmV8Features(PCDBGFINFOHLP pHlp, uint32_t cchOutput,
                                              CPUMFEATURESARMV8 const *pFeatures, const char *pszLabel,
                                              CPUMFEATURESARMV8 const *pSecondary, const char *pszSecondary)
{
    unsigned const cchLabel  = (unsigned)strlen(pszLabel);
    unsigned const cchLabel2 = pszSecondary ? (unsigned)strlen(pszSecondary) : 0;
    unsigned const cchPad    = cchLabel - 1 + cchLabel2 - !!cchLabel2;
    unsigned const cchColumn = 2 + 24 + 3 + cchLabel + (pSecondary ? 3 + cchLabel2 : 0);
    unsigned const cColumns  = cchOutput < cchColumn ? 1 : cchOutput / cchColumn;
    if (pSecondary)
        for (unsigned iColumn = 0; iColumn < cColumns; iColumn++)
            pHlp->pfnPrintf(pHlp, "  %24s = %s (%s)", "Features", pszLabel, pszSecondary);
    else
        for (unsigned iColumn = 0; iColumn < cColumns; iColumn++)
            pHlp->pfnPrintf(pHlp, "  %24s = %s", "Features", pszLabel);
    pHlp->pfnPrintf(pHlp, "\n");

    unsigned iColumn = 0;
#define PRINT_FEATURE(a_Name, a_Member) do { \
            if (pSecondary) \
                pHlp->pfnPrintf(pHlp, "%*s  %24s = %u (%u)", \
                                iColumn ? cchPad : 0, "", #a_Name, pFeatures->a_Member, pSecondary->a_Member); \
            else \
                pHlp->pfnPrintf(pHlp, "%*s  %24s = %u", \
                                iColumn ? cchPad : 0, "", #a_Name, pFeatures->a_Member); \
            iColumn += 1; \
            if (iColumn >= cColumns) \
            { \
                pHlp->pfnPrintf(pHlp, "\n"); \
                iColumn = 0; \
            } \
        } while (0)
    PRINT_FEATURE(FEAT_AA32,                fAa32);
    PRINT_FEATURE(FEAT_AA32BF16,            fAa32Bf16);
    PRINT_FEATURE(FEAT_AA32EL0,             fAa32El0);
    PRINT_FEATURE(FEAT_AA32EL1,             fAa32El1);
    PRINT_FEATURE(FEAT_AA32EL2,             fAa32El2);
    PRINT_FEATURE(FEAT_AA32EL3,             fAa32El3);
    PRINT_FEATURE(FEAT_AA32HPD,             fAa32Hpd);
    PRINT_FEATURE(FEAT_AA32I8MM,            fAa32I8mm);
    PRINT_FEATURE(FEAT_AA64,                fAa64);
    PRINT_FEATURE(FEAT_AA64EL0,             fAa64El0);
    PRINT_FEATURE(FEAT_AA64EL1,             fAa64El1);
    PRINT_FEATURE(FEAT_AA64EL2,             fAa64El2);
    PRINT_FEATURE(FEAT_AA64EL3,             fAa64El3);
    PRINT_FEATURE(FEAT_ABLE,                fAble);
    PRINT_FEATURE(FEAT_ADERR,               fAderr);
    PRINT_FEATURE(FEAT_AES,                 fAes);
    PRINT_FEATURE(FEAT_AFP,                 fAfp);
    PRINT_FEATURE(FEAT_AIE,                 fAie);
    PRINT_FEATURE(FEAT_AMUv1,               fAmuV1);
    PRINT_FEATURE(FEAT_AMUv1p1,             fAmuV1p1);
    PRINT_FEATURE(FEAT_ANERR,               fAnerr);
    PRINT_FEATURE(FEAT_ASID16,              fAsid16);
    PRINT_FEATURE(FEAT_ASID2,               fAsid2);
    PRINT_FEATURE(FEAT_ATS1A,               fATs1a);
    PRINT_FEATURE(FEAT_AdvSIMD,             fAdvSimd);
    PRINT_FEATURE(FEAT_BBM,                 fBbm);
    PRINT_FEATURE(FEAT_BF16,                fBf16);
    PRINT_FEATURE(FEAT_BRBE,                fBrbe);
    PRINT_FEATURE(FEAT_BRBEv1p1,            fBrbeV1p1);
    PRINT_FEATURE(FEAT_BTI,                 fBti);
    PRINT_FEATURE(FEAT_BWE,                 fBwe);
    PRINT_FEATURE(FEAT_BWE2,                fBwe2);
    PRINT_FEATURE(FEAT_CCIDX,               fCcidx);
    PRINT_FEATURE(FEAT_CHK,                 fChk);
    PRINT_FEATURE(FEAT_CLRBHB,              fClrBhb);
    PRINT_FEATURE(FEAT_CMOW,                fCmow);
    PRINT_FEATURE(FEAT_CMPBR,               fCmpBr);
    PRINT_FEATURE(FEAT_CONSTPACFIELD,       fConstPacField);
    PRINT_FEATURE(FEAT_CPA,                 fCpa);
    PRINT_FEATURE(FEAT_CPA2,                fCpa2);
    PRINT_FEATURE(FEAT_CRC32,               fCrc32);
    PRINT_FEATURE(FEAT_CSSC,                fCssc);
    PRINT_FEATURE(FEAT_CSV2,                fCsv2);
    PRINT_FEATURE(FEAT_CSV2_1p1,            fCsv21p1);
    PRINT_FEATURE(FEAT_CSV2_1p2,            fCsv21p2);
    PRINT_FEATURE(FEAT_CSV2_2,              fCvs2_2);
    PRINT_FEATURE(FEAT_CSV2_3,              fCsv2v3);
    PRINT_FEATURE(FEAT_CSV3,                fCsv3);
    PRINT_FEATURE(FEAT_D128,                fD128);
    PRINT_FEATURE(FEAT_DGH,                 fDgh);
    PRINT_FEATURE(FEAT_DIT,                 fDit);
    PRINT_FEATURE(FEAT_DPB,                 fDpb);
    PRINT_FEATURE(FEAT_DPB2,                fDpb2);
    PRINT_FEATURE(FEAT_Debugv8p1,           fDebugV8p1);
    PRINT_FEATURE(FEAT_Debugv8p2,           fDebugV8p2);
    PRINT_FEATURE(FEAT_Debugv8p4,           fDebugV8p4);
    PRINT_FEATURE(FEAT_Debugv8p8,           fDebugV8p8);
    PRINT_FEATURE(FEAT_Debugv8p9,           fDebugV8p9);
    PRINT_FEATURE(FEAT_DotProd,             fDotProd);
    PRINT_FEATURE(FEAT_DoubleFault,         fDoubleFault);
    PRINT_FEATURE(FEAT_DoubleFault2,        fDoubleFault2);
    PRINT_FEATURE(FEAT_DoubleLock,          fDoubleLock);
    PRINT_FEATURE(FEAT_E0PD,                fE0Pd);
    PRINT_FEATURE(FEAT_E2H0,                fE2H0);
    PRINT_FEATURE(FEAT_E3DSE,               fE3Dse);
    PRINT_FEATURE(FEAT_EBEP,                fEbep);
    PRINT_FEATURE(FEAT_EBF16,               fEbf16);
    PRINT_FEATURE(FEAT_ECBHB,               fEcBhb);
    PRINT_FEATURE(FEAT_ECV,                 fEcv);
    PRINT_FEATURE(FEAT_ECV_POFF,            fEcvPOff);
    PRINT_FEATURE(FEAT_EPAC,                fEpac);
    PRINT_FEATURE(FEAT_ETE,                 fEte);
    PRINT_FEATURE(FEAT_ETEv1p1,             fEteV1p1);
    PRINT_FEATURE(FEAT_ETEv1p2,             fEteV1p2);
    PRINT_FEATURE(FEAT_ETEv1p3,             fEteV1p3);
    PRINT_FEATURE(FEAT_ETMv4,               fEtmV4);
    PRINT_FEATURE(FEAT_ETMv4p1,             fEtmV4p1);
    PRINT_FEATURE(FEAT_ETMv4p2,             fEtmV4p2);
    PRINT_FEATURE(FEAT_ETMv4p3,             fEtmV4p3);
    PRINT_FEATURE(FEAT_ETMv4p4,             fEtmV4p4);
    PRINT_FEATURE(FEAT_ETMv4p5,             fEtmV4p5);
    PRINT_FEATURE(FEAT_ETMv4p6,             fEtmV4p6);
    PRINT_FEATURE(FEAT_ETS2,                fEts2);
    PRINT_FEATURE(FEAT_ETS3,                fEts3);
    PRINT_FEATURE(FEAT_EVT,                 fEvt);
    PRINT_FEATURE(FEAT_ExS,                 fExs);
    PRINT_FEATURE(FEAT_F32MM,               fF32mm);
    PRINT_FEATURE(FEAT_F64MM,               fF64mm);
    PRINT_FEATURE(FEAT_F8F16MM,             fF8F16mm);
    PRINT_FEATURE(FEAT_F8F32MM,             fF8F32mm);
    PRINT_FEATURE(FEAT_FAMINMAX,            fFaMinMax);
    PRINT_FEATURE(FEAT_FCMA,                fFcma);
    PRINT_FEATURE(FEAT_FGT,                 fFgt);
    PRINT_FEATURE(FEAT_FGT2,                fFgt2);
    PRINT_FEATURE(FEAT_FGWTE3,              fFgwtE3);
    PRINT_FEATURE(FEAT_FHM,                 fFhm);
    PRINT_FEATURE(FEAT_FP,                  fFp);
    PRINT_FEATURE(FEAT_FP16,                fFp16);
    PRINT_FEATURE(FEAT_FP8,                 fFp8);
    PRINT_FEATURE(FEAT_FP8DOT2,             fFp8Dot2);
    PRINT_FEATURE(FEAT_FP8DOT4,             fFp8Dot4);
    PRINT_FEATURE(FEAT_FP8FMA,              fFp8Fma);
    PRINT_FEATURE(FEAT_FPAC,                fFpac);
    PRINT_FEATURE(FEAT_FPACCOMBINE,         fFpacCombine);
    PRINT_FEATURE(FEAT_FPACC_SPEC,          fFpaccSpec);
    PRINT_FEATURE(FEAT_FPMR,                fFpmr);
    PRINT_FEATURE(FEAT_FPRCVT,              fFpRcvt);
    PRINT_FEATURE(FEAT_FRINTTS,             fFrintts);
    PRINT_FEATURE(FEAT_FlagM,               fFlagM);
    PRINT_FEATURE(FEAT_FlagM2,              fFlagM2);
    PRINT_FEATURE(FEAT_GCS,                 fGcs);
    PRINT_FEATURE(FEAT_GICv3,               fGicV3);
    PRINT_FEATURE(FEAT_GICv3_NMI,           fGicV3Nmi);
    PRINT_FEATURE(FEAT_GICv3_TDIR,          fGicV3Tdir);
    PRINT_FEATURE(FEAT_GICv3p1,             fGicV3p1);
    PRINT_FEATURE(FEAT_GICv4,               fGicV4);
    PRINT_FEATURE(FEAT_GICv4p1,             fGicV4p1);
    PRINT_FEATURE(FEAT_GTG,                 fGtg);
    PRINT_FEATURE(FEAT_HACDBS,              fHacdbs);
    PRINT_FEATURE(FEAT_HAFDBS,              fHafdbs);
    PRINT_FEATURE(FEAT_HAFT,                fHaft);
    PRINT_FEATURE(FEAT_HBC,                 fHbc);
    PRINT_FEATURE(FEAT_HCX,                 fHcx);
    PRINT_FEATURE(FEAT_HDBSS,               fHdbss);
    PRINT_FEATURE(FEAT_HPDS,                fHpds);
    PRINT_FEATURE(FEAT_HPDS2,               fHpds2);
    PRINT_FEATURE(FEAT_HPMN0,               fHpmn0);
    PRINT_FEATURE(FEAT_I8MM,                fI8mm);
    PRINT_FEATURE(FEAT_IDST,                fIdst);
    PRINT_FEATURE(FEAT_IDTE3,               fIdte3);
    PRINT_FEATURE(FEAT_IESB,                fIesb);
    PRINT_FEATURE(FEAT_ITE,                 fIte);
    PRINT_FEATURE(FEAT_IVIPT,               fIvipt);
    PRINT_FEATURE(FEAT_JSCVT,               fJscvt);
    PRINT_FEATURE(FEAT_LOR,                 fLor);
    PRINT_FEATURE(FEAT_LPA,                 fLpa);
    PRINT_FEATURE(FEAT_LPA2,                fLpa2);
    PRINT_FEATURE(FEAT_LRCPC,               fLrcpc);
    PRINT_FEATURE(FEAT_LRCPC2,              fLrcpc2);
    PRINT_FEATURE(FEAT_LRCPC3,              fLrcpc3);
    PRINT_FEATURE(FEAT_LS64,                fLs64);
    PRINT_FEATURE(FEAT_LS64WB,              fLs64WB);
    PRINT_FEATURE(FEAT_LS64_ACCDATA,        fLs64Accdata);
    PRINT_FEATURE(FEAT_LS64_V,              fLs64V);
    PRINT_FEATURE(FEAT_LSE,                 fLse);
    PRINT_FEATURE(FEAT_LSE128,              fLse128);
    PRINT_FEATURE(FEAT_LSE2,                fLse2);
    PRINT_FEATURE(FEAT_LSFE,                fLsfe);
    PRINT_FEATURE(FEAT_LSMAOC,              fLsmaoc);
    PRINT_FEATURE(FEAT_LSUI,                fLsui);
    PRINT_FEATURE(FEAT_LUT,                 fLut);
    PRINT_FEATURE(FEAT_LVA,                 fLva);
    PRINT_FEATURE(FEAT_LVA3,                fLva3);
    PRINT_FEATURE(FEAT_MEC,                 fMec);
    PRINT_FEATURE(FEAT_MOPS,                fMops);
    PRINT_FEATURE(FEAT_MPAM,                fMpam);
    PRINT_FEATURE(FEAT_MPAM_PE_BW_CTRL,     fMpamPeBwCtrl);
    PRINT_FEATURE(FEAT_MPAMv0p1,            fMpamV0p1);
    PRINT_FEATURE(FEAT_MPAMv1p1,            fMpamV1p1);
    PRINT_FEATURE(FEAT_MTE,                 fMte);
    PRINT_FEATURE(FEAT_MTE2,                fMte2);
    PRINT_FEATURE(FEAT_MTE3,                fMte3);
    PRINT_FEATURE(FEAT_MTE4,                fMte4);
    PRINT_FEATURE(FEAT_MTE_ASYM_FAULT,      fMteAsymFault);
    PRINT_FEATURE(FEAT_MTE_ASYNC,           fMteAsync);
    PRINT_FEATURE(FEAT_MTE_CANONICAL_TAGS,  fMteCanonicalTags);
    PRINT_FEATURE(FEAT_MTE_NO_ADDRESS_TAGS, fMteNoAddressTags);
    PRINT_FEATURE(FEAT_MTE_PERM,            fMtePerm);
    PRINT_FEATURE(FEAT_MTE_STORE_ONLY,      fMteStoreOnly);
    PRINT_FEATURE(FEAT_MTE_TAGGED_FAR,      fMteTaggedFar);
    PRINT_FEATURE(FEAT_MTPMU,               fMtPmu);
    PRINT_FEATURE(FEAT_MixedEnd,            fMixedEnd);
    PRINT_FEATURE(FEAT_MixedEndEL0,         fMixedEndEl0);
    PRINT_FEATURE(FEAT_NMI,                 fNmi);
    PRINT_FEATURE(FEAT_NV,                  fNv);
    PRINT_FEATURE(FEAT_NV2,                 fNv2);
    PRINT_FEATURE(FEAT_NV2p1,               fNV2p1);
    PRINT_FEATURE(FEAT_OCCMO,               fOccmo);
    PRINT_FEATURE(FEAT_PACIMP,              fPacImp);
    PRINT_FEATURE(FEAT_PACQARMA3,           fPacQarma3);
    PRINT_FEATURE(FEAT_PACQARMA5,           fPacQarma5);
    PRINT_FEATURE(FEAT_PAN,                 fPan);
    PRINT_FEATURE(FEAT_PAN2,                fPan2);
    PRINT_FEATURE(FEAT_PAN3,                fPan3);
    PRINT_FEATURE(FEAT_PAuth,               fPAuth);
    PRINT_FEATURE(FEAT_PAuth2,              fPAuth2);
    PRINT_FEATURE(FEAT_PAuth_LR,            fPAuthLR);
    PRINT_FEATURE(FEAT_PCDPHINT,            fPCDPHint);
    PRINT_FEATURE(FEAT_PFAR,                fPfar);
    PRINT_FEATURE(FEAT_PMULL,               fPmull);
    PRINT_FEATURE(FEAT_PMUv3,               fPmuV3);
    PRINT_FEATURE(FEAT_PMUv3_EDGE,          fPmuV3Edge);
    PRINT_FEATURE(FEAT_PMUv3_ICNTR,         fPmuV3Icntr);
    PRINT_FEATURE(FEAT_PMUv3_SME,           fPmuV3Sme);
    PRINT_FEATURE(FEAT_PMUv3_SS,            fPmuV3Ss);
    PRINT_FEATURE(FEAT_PMUv3_TH,            fPmuV3Th);
    PRINT_FEATURE(FEAT_PMUv3_TH2,           fPmuV3Th2);
    PRINT_FEATURE(FEAT_PMUv3p1,             fPmuV3p1);
    PRINT_FEATURE(FEAT_PMUv3p4,             fPmuV3p4);
    PRINT_FEATURE(FEAT_PMUv3p5,             fPmuV3p5);
    PRINT_FEATURE(FEAT_PMUv3p7,             fPmuV3p7);
    PRINT_FEATURE(FEAT_PMUv3p8,             fPmuV3p8);
    PRINT_FEATURE(FEAT_PMUv3p9,             fPmuV3p9);
    PRINT_FEATURE(FEAT_PRFMSLC,             fPrfmSlc);
    PRINT_FEATURE(FEAT_RAS,                 fRas);
    PRINT_FEATURE(FEAT_RASv1p1,             fRasV1p1);
    PRINT_FEATURE(FEAT_RASv2,               fRasV2);
    PRINT_FEATURE(FEAT_RDM,                 fRdm);
    PRINT_FEATURE(FEAT_RME,                 fRme);
    PRINT_FEATURE(FEAT_RME_GDI,             fRmeGdi);
    PRINT_FEATURE(FEAT_RME_GPC2,            fRmeGpc2);
    PRINT_FEATURE(FEAT_RME_GPC3,            fRmeGpc3);
    PRINT_FEATURE(FEAT_RNG,                 fRng);
    PRINT_FEATURE(FEAT_RNG_TRAP,            fRngTrap);
    PRINT_FEATURE(FEAT_RPRES,               fRpres);
    PRINT_FEATURE(FEAT_RPRFM,               fRprfm);
    PRINT_FEATURE(FEAT_S1PIE,               fS1Pie);
    PRINT_FEATURE(FEAT_S1POE,               fS1Poe);
    PRINT_FEATURE(FEAT_S2FWB,               fS2Fwb);
    PRINT_FEATURE(FEAT_S2PIE,               fS2Pie);
    PRINT_FEATURE(FEAT_S2POE,               fS2Poe);
    PRINT_FEATURE(FEAT_S2TGran16K,          fS2TGran16K);
    PRINT_FEATURE(FEAT_S2TGran4K,           fS2TGran4K);
    PRINT_FEATURE(FEAT_S2TGran64K,          fS2TGran64K);
    PRINT_FEATURE(FEAT_SB,                  fSb);
    PRINT_FEATURE(FEAT_SCTLR2,              fSctlr2);
    PRINT_FEATURE(FEAT_SEBEP,               fSebep);
    PRINT_FEATURE(FEAT_SEL2,                fSecEl2);
    PRINT_FEATURE(FEAT_SHA1,                fSha1);
    PRINT_FEATURE(FEAT_SHA256,              fSha256);
    PRINT_FEATURE(FEAT_SHA3,                fSha3);
    PRINT_FEATURE(FEAT_SHA512,              fSha512);
    PRINT_FEATURE(FEAT_SM3,                 fSm3);
    PRINT_FEATURE(FEAT_SM4,                 fSm4);
    PRINT_FEATURE(FEAT_SME,                 fSme);
    PRINT_FEATURE(FEAT_SME2,                fSme2);
    PRINT_FEATURE(FEAT_SME2p1,              fSme2p1);
    PRINT_FEATURE(FEAT_SME2p2,              fSme2p2);
    PRINT_FEATURE(FEAT_SME_B16B16,          fSmeB16B16);
    PRINT_FEATURE(FEAT_SME_F16F16,          fSmeF16F16);
    PRINT_FEATURE(FEAT_SME_F64F64,          fSmeF64F64);
    PRINT_FEATURE(FEAT_SME_F8F16,           fSmeF8F16);
    PRINT_FEATURE(FEAT_SME_F8F32,           fSmeF8F32);
    PRINT_FEATURE(FEAT_SME_FA64,            fSmeFA64);
    PRINT_FEATURE(FEAT_SME_I16I64,          fSmeI16I64);
    PRINT_FEATURE(FEAT_SME_LUTv2,           fSmeLutv2);
    PRINT_FEATURE(FEAT_SME_MOP4,            fSmeMop4);
    PRINT_FEATURE(FEAT_SME_TMOP,            fSmeTmop);
    PRINT_FEATURE(FEAT_SPE,                 fSpe);
    PRINT_FEATURE(FEAT_SPECRES,             fSpecres);
    PRINT_FEATURE(FEAT_SPECRES2,            fSpecres2);
    PRINT_FEATURE(FEAT_SPE_ALTCLK,          fSpeAltClk);
    PRINT_FEATURE(FEAT_SPE_CRR,             fSpeCrr);
    PRINT_FEATURE(FEAT_SPE_DPFZS,           fSpeDpfzs);
    PRINT_FEATURE(FEAT_SPE_EFT,             fSpeEft);
    PRINT_FEATURE(FEAT_SPE_EXC,             fSpeExc);
    PRINT_FEATURE(FEAT_SPE_FDS,             fSpeFds);
    PRINT_FEATURE(FEAT_SPE_FPF,             fSpeFpf);
    PRINT_FEATURE(FEAT_SPE_FnE,             fSpeFnE);
    PRINT_FEATURE(FEAT_SPE_PBT,             fSpePbt);
    PRINT_FEATURE(FEAT_SPE_SME,             fSpeSme);
    PRINT_FEATURE(FEAT_SPE_nVM,             fSpeNvm);
    PRINT_FEATURE(FEAT_SPEv1p1,             fSpeV1p1);
    PRINT_FEATURE(FEAT_SPEv1p2,             fSpeV1p2);
    PRINT_FEATURE(FEAT_SPEv1p3,             fSpeV1p3);
    PRINT_FEATURE(FEAT_SPEv1p4,             fSpeV1p4);
    PRINT_FEATURE(FEAT_SPEv1p5,             fSpev1p5);
    PRINT_FEATURE(FEAT_SPMU,                fSpmu);
    PRINT_FEATURE(FEAT_SPMU2,               fSpmu2);
    PRINT_FEATURE(FEAT_SSBS,                fSsbs);
    PRINT_FEATURE(FEAT_SSBS2,               fSsbs2);
    PRINT_FEATURE(FEAT_SSVE_AES,            fSsveAes);
    PRINT_FEATURE(FEAT_SSVE_BitPerm,        fSsveBitPerm);
    PRINT_FEATURE(FEAT_SSVE_FEXPA,          fSsveFexpa);
    PRINT_FEATURE(FEAT_SSVE_FP8DOT2,        fSsveFp8Dot2);
    PRINT_FEATURE(FEAT_SSVE_FP8DOT4,        fSsveFp8Dot4);
    PRINT_FEATURE(FEAT_SSVE_FP8FMA,         fSsveFp8Fma);
    PRINT_FEATURE(FEAT_STEP2,               fStep2);
    PRINT_FEATURE(FEAT_SVE,                 fSve);
    PRINT_FEATURE(FEAT_SVE2,                fSve2);
    PRINT_FEATURE(FEAT_SVE2p1,              fSve2p1);
    PRINT_FEATURE(FEAT_SVE2p2,              fSve2p2);
    PRINT_FEATURE(FEAT_SVE_AES,             fSveAes);
    PRINT_FEATURE(FEAT_SVE_AES2,            fSveAes2);
    PRINT_FEATURE(FEAT_SVE_B16B16,          fSveB16B16);
    PRINT_FEATURE(FEAT_SVE_BFSCALE,         fSveBfscale);
    PRINT_FEATURE(FEAT_SVE_BitPerm,         fSveBitPerm);
    PRINT_FEATURE(FEAT_SVE_F16F32MM,        fSveF16F32mm);
    PRINT_FEATURE(FEAT_SVE_PMULL128,        fSvePmull128);
    PRINT_FEATURE(FEAT_SVE_SHA3,            fSveSha3);
    PRINT_FEATURE(FEAT_SVE_SM4,             fSveSm4);
    PRINT_FEATURE(FEAT_SYSINSTR128,         fSysInstr128);
    PRINT_FEATURE(FEAT_SYSREG128,           fSysReg128);
    PRINT_FEATURE(FEAT_SpecSEI,             fSpecSei);
    PRINT_FEATURE(FEAT_TCR2,                fTcr2);
    PRINT_FEATURE(FEAT_TGran16K,            fTGran16K);
    PRINT_FEATURE(FEAT_TGran4K,             fTGran4K);
    PRINT_FEATURE(FEAT_TGran64K,            fTGran64K);
    PRINT_FEATURE(FEAT_THE,                 fThe);
    PRINT_FEATURE(FEAT_TIDCP1,              fTidcp1);
    PRINT_FEATURE(FEAT_TLBIOS,              fTlbios);
    PRINT_FEATURE(FEAT_TLBIRANGE,           fTlbirange);
    PRINT_FEATURE(FEAT_TLBIW,               fTlbiW);
    PRINT_FEATURE(FEAT_TME,                 fTme);
    PRINT_FEATURE(FEAT_TRBE,                fTrbe);
    PRINT_FEATURE(FEAT_TRBE_EXC,            fTrbeExc);
    PRINT_FEATURE(FEAT_TRBE_EXT,            fTrbeExt);
    PRINT_FEATURE(FEAT_TRBE_MPAM,           fTrbeMpam);
    PRINT_FEATURE(FEAT_TRBEv1p1,            fTrbev1p1);
    PRINT_FEATURE(FEAT_TRC_SR,              fTrcSr);
    PRINT_FEATURE(FEAT_TRF,                 fTrf);
    PRINT_FEATURE(FEAT_TTCNP,               fTtcnp);
    PRINT_FEATURE(FEAT_TTL,                 fTtl);
    PRINT_FEATURE(FEAT_TTST,                fTtst);
    PRINT_FEATURE(FEAT_TWED,                fTwed);
    PRINT_FEATURE(FEAT_UAO,                 fUao);
    PRINT_FEATURE(FEAT_UINJ,                fUinj);
    PRINT_FEATURE(FEAT_VHE,                 fVhe);
    PRINT_FEATURE(FEAT_VMID16,              fVmid16);
    PRINT_FEATURE(FEAT_VPIPT,               fVpipt);
    PRINT_FEATURE(FEAT_WFxT,                fWfxt);
    PRINT_FEATURE(FEAT_XNX,                 fXnx);
    PRINT_FEATURE(FEAT_XS,                  fXs);
    PRINT_FEATURE(FEAT_nTLBPA,              fNTlbpa);
}
#endif /* IN_RING3 */

#endif /* !VMM_INCLUDED_SRC_VMMR3_target_armv8_CPUMAllCpuIdArmV8_cpp_h */
