// Copyright 2025 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/specterops/bloodhound/src/api (interfaces: Authenticator)
//
// Generated by this command:
//
//	mockgen -copyright_file=../../../../LICENSE.header -destination=./mocks/authenticator.go -package=mocks . Authenticator
//

// Package mocks is a generated GoMock package.
package mocks

import (
	context "context"
	http "net/http"
	reflect "reflect"
	time "time"

	uuid "github.com/gofrs/uuid"
	api "github.com/specterops/bloodhound/src/api"
	auth "github.com/specterops/bloodhound/src/auth"
	model "github.com/specterops/bloodhound/src/model"
	gomock "go.uber.org/mock/gomock"
)

// MockAuthenticator is a mock of Authenticator interface.
type MockAuthenticator struct {
	ctrl     *gomock.Controller
	recorder *MockAuthenticatorMockRecorder
	isgomock struct{}
}

// MockAuthenticatorMockRecorder is the mock recorder for MockAuthenticator.
type MockAuthenticatorMockRecorder struct {
	mock *MockAuthenticator
}

// NewMockAuthenticator creates a new mock instance.
func NewMockAuthenticator(ctrl *gomock.Controller) *MockAuthenticator {
	mock := &MockAuthenticator{ctrl: ctrl}
	mock.recorder = &MockAuthenticatorMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockAuthenticator) EXPECT() *MockAuthenticatorMockRecorder {
	return m.recorder
}

// CreateSSOSession mocks base method.
func (m *MockAuthenticator) CreateSSOSession(request *http.Request, response http.ResponseWriter, principalNameOrEmail string, ssoProvider model.SSOProvider) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "CreateSSOSession", request, response, principalNameOrEmail, ssoProvider)
}

// CreateSSOSession indicates an expected call of CreateSSOSession.
func (mr *MockAuthenticatorMockRecorder) CreateSSOSession(request, response, principalNameOrEmail, ssoProvider any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSSOSession", reflect.TypeOf((*MockAuthenticator)(nil).CreateSSOSession), request, response, principalNameOrEmail, ssoProvider)
}

// CreateSession mocks base method.
func (m *MockAuthenticator) CreateSession(ctx context.Context, user model.User, authProvider any) (string, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateSession", ctx, user, authProvider)
	ret0, _ := ret[0].(string)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateSession indicates an expected call of CreateSession.
func (mr *MockAuthenticatorMockRecorder) CreateSession(ctx, user, authProvider any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSession", reflect.TypeOf((*MockAuthenticator)(nil).CreateSession), ctx, user, authProvider)
}

// LoginWithSecret mocks base method.
func (m *MockAuthenticator) LoginWithSecret(ctx context.Context, loginRequest api.LoginRequest) (api.LoginDetails, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LoginWithSecret", ctx, loginRequest)
	ret0, _ := ret[0].(api.LoginDetails)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// LoginWithSecret indicates an expected call of LoginWithSecret.
func (mr *MockAuthenticatorMockRecorder) LoginWithSecret(ctx, loginRequest any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LoginWithSecret", reflect.TypeOf((*MockAuthenticator)(nil).LoginWithSecret), ctx, loginRequest)
}

// Logout mocks base method.
func (m *MockAuthenticator) Logout(ctx context.Context, userSession model.UserSession) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Logout", ctx, userSession)
}

// Logout indicates an expected call of Logout.
func (mr *MockAuthenticatorMockRecorder) Logout(ctx, userSession any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Logout", reflect.TypeOf((*MockAuthenticator)(nil).Logout), ctx, userSession)
}

// ValidateRequestSignature mocks base method.
func (m *MockAuthenticator) ValidateRequestSignature(tokenID uuid.UUID, request *http.Request, serverTime time.Time) (auth.Context, int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ValidateRequestSignature", tokenID, request, serverTime)
	ret0, _ := ret[0].(auth.Context)
	ret1, _ := ret[1].(int)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// ValidateRequestSignature indicates an expected call of ValidateRequestSignature.
func (mr *MockAuthenticatorMockRecorder) ValidateRequestSignature(tokenID, request, serverTime any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ValidateRequestSignature", reflect.TypeOf((*MockAuthenticator)(nil).ValidateRequestSignature), tokenID, request, serverTime)
}

// ValidateSecret mocks base method.
func (m *MockAuthenticator) ValidateSecret(ctx context.Context, secret string, authSecret model.AuthSecret) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ValidateSecret", ctx, secret, authSecret)
	ret0, _ := ret[0].(error)
	return ret0
}

// ValidateSecret indicates an expected call of ValidateSecret.
func (mr *MockAuthenticatorMockRecorder) ValidateSecret(ctx, secret, authSecret any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ValidateSecret", reflect.TypeOf((*MockAuthenticator)(nil).ValidateSecret), ctx, secret, authSecret)
}

// ValidateSession mocks base method.
func (m *MockAuthenticator) ValidateSession(ctx context.Context, jwtTokenString string) (auth.Context, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ValidateSession", ctx, jwtTokenString)
	ret0, _ := ret[0].(auth.Context)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ValidateSession indicates an expected call of ValidateSession.
func (mr *MockAuthenticatorMockRecorder) ValidateSession(ctx, jwtTokenString any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ValidateSession", reflect.TypeOf((*MockAuthenticator)(nil).ValidateSession), ctx, jwtTokenString)
}
