// Copyright 2023 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

package fixtures

import (
	"github.com/specterops/bloodhound/dawgs/graph"
	"github.com/specterops/bloodhound/dawgs/query"
	"github.com/specterops/bloodhound/ein"
	"github.com/specterops/bloodhound/graphschema/ad"
	"github.com/specterops/bloodhound/graphschema/common"
	"github.com/specterops/bloodhound/src/test"
	"github.com/stretchr/testify/require"
)

var (
	relationshipCriteria = []graph.Criteria{
		// The commands for generating these criteria from the json will be at the top of each criteria block

		//AIACA ContainedBy
		//cat bhce/cmd/api/src/test/fixtures/fixtures/v6/all/aiacas.json | jq -r '.data | .[] | select(.ContainedBy.ObjectIdentifier != null) | (.ContainedBy.ObjectIdentifier | ascii_upcase) as $containerId | ("ad." + .ContainedBy.ObjectType) as $containerType | "query.And(query.Kind(query.Start(), \($containerType)), query.Equals(query.StartProperty(common.ObjectID.String()), \"" + $containerId + "\"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.AIACA), query.Equals(query.EndProperty(common.ObjectID.String()), \"\(.ObjectIdentifier)\")),"'

		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "D44AC8AF-C24E-489B-B0BB-E832A5E3C91A"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.AIACA), query.Equals(query.EndProperty(common.ObjectID.String()), "6345151F-D854-4D83-B7D0-D94E10CFBAF2")),

		//AIACA ACE Rels
		//cat bhce/cmd/api/src/test/fixtures/fixtures/v6/all/aiacas.json | jq -r '.data | map(.)[] | .ObjectIdentifier as $targetId | .Aces[] | (.PrincipalSID | ascii_upcase) as $sourceId | ("ad." + .PrincipalType) as $sourceType | ("ad." + .RightName) as $relType |"query.And(query.Kind(query.Start(), \($sourceType)), query.Equals(query.StartProperty(common.ObjectID.String()), \"" + $sourceId + "\"), query.Kind(query.Relationship(), \($relType)), query.Kind(query.End(), ad.AIACA), query.Equals(query.EndProperty(common.ObjectID.String()), \"\($targetId)\")),"'

		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.AIACA), query.Equals(query.EndProperty(common.ObjectID.String()), "6345151F-D854-4D83-B7D0-D94E10CFBAF2")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "ESC1.LOCAL-S-1-5-32-544"), query.Kind(query.Relationship(), ad.GenericAll), query.Kind(query.End(), ad.AIACA), query.Equals(query.EndProperty(common.ObjectID.String()), "6345151F-D854-4D83-B7D0-D94E10CFBAF2")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.GenericAll), query.Kind(query.End(), ad.AIACA), query.Equals(query.EndProperty(common.ObjectID.String()), "6345151F-D854-4D83-B7D0-D94E10CFBAF2")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.GenericAll), query.Kind(query.End(), ad.AIACA), query.Equals(query.EndProperty(common.ObjectID.String()), "6345151F-D854-4D83-B7D0-D94E10CFBAF2")),
		query.And(query.Kind(query.Start(), ad.Computer), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1000"), query.Kind(query.Relationship(), ad.GenericAll), query.Kind(query.End(), ad.AIACA), query.Equals(query.EndProperty(common.ObjectID.String()), "6345151F-D854-4D83-B7D0-D94E10CFBAF2")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.GenericAll), query.Kind(query.End(), ad.AIACA), query.Equals(query.EndProperty(common.ObjectID.String()), "6345151F-D854-4D83-B7D0-D94E10CFBAF2")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.AIACA), query.Equals(query.EndProperty(common.ObjectID.String()), "6345151F-D854-4D83-B7D0-D94E10CFBAF2")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.AIACA), query.Equals(query.EndProperty(common.ObjectID.String()), "6345151F-D854-4D83-B7D0-D94E10CFBAF2")),

		//CertTemplates ContainedBy
		//cat bhce/cmd/api/src/test/fixtures/fixtures/v6/all/certtemplates.json | jq -r '.data | map(.)[] | select(.ContainedBy.ObjectIdentifier != null) | (.ContainedBy.ObjectIdentifier | ascii_upcase) as $containerId | ("ad." + .ContainedBy.ObjectType) as $containerType | "query.And(query.Kind(query.Start(), \($containerType)), query.Equals(query.StartProperty(common.ObjectID.String()), \"" + $containerId + "\"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), \"\(.ObjectIdentifier)\")),"'

		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "72F15D5F-C7B4-4FD9-ADCE-302F0D3DC91A")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "01BCD578-1031-400B-ADBA-0B8AEAB95929")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "251BB763-E8FE-4B7A-9E61-1EDE247847E1")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "E928FF44-D63B-4C60-B20A-94B72B782E38")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "E249A350-93EA-4290-9E28-CFC9A5718C86")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "F951BBAA-F10A-4A70-9507-BCD8F188D70B")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "CDDAE05D-4623-464C-AB48-AE38BC7EC8BA")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "43616DDD-A336-439F-8A08-088CC0AA85C1")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "C6DC9FD9-2A52-4064-9D8E-ED9BBA52FD51")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "39E1A53E-3D9E-4341-A3E8-8F297FEB34CD")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "63FB126D-499F-48DA-A707-A134B92764BD")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "621424AD-1DD5-487C-B38D-12D094A38153")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "091BE19E-A0D3-4920-A967-5673A2214268")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "441D7EAE-CF79-4B97-83A2-B770C231E4DA")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "AACF5D02-3165-4AC7-9AA9-BD604F95011F")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "4DC38500-E84C-4A92-9354-AE4665CCC80A")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "99679751-132B-4732-89EE-E21F0A1B1B30")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "89486D6B-D221-4435-9544-9CDC8B4E6933")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "3F2F49C7-53C2-4AFB-8DA2-306C2CD1DDCA")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "08FA76AA-B3B1-480E-81E2-48CC2AF009B5")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "2D3B649A-50E0-485B-AEF3-6C8ED9DB0A2A")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "A938AA1C-1A2E-4636-9926-43EE00945106")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "1467B8A3-2ACD-4A8B-9CF1-E9333110A00C")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "55BCF264-BBB0-4D50-ACC0-69235586DFC9")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "75957C42-9FFB-4D75-A297-7CDB8B11D74F")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "EDB16956-50D9-4E16-B448-441EFC1D1FB8")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "3C412345-7109-47BC-B33E-D765B14BBE99")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "8426B1B2-6678-4223-BB03-0EBA065D8976")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "64AC5BD1-1DE3-46D4-9796-5C9D98E4B0F7")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "DEBC8BEB-40AF-48B5-940F-AAFAFE961B26")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "9F29EC9F-1DF5-4505-82FB-3DB8B952FDE3")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "176D3356-0094-4E80-868A-00E74B651CC0")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "4376BA2D-B316-41E1-96DF-A0CB1EA0667F")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "95D1A36E-7782-4CC5-823C-F5994359DDC0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "67CE0FEC-166C-4E5E-BF87-6FBAF0E9C8A8")),

		//CertTemplate ACE Rels
		//cat bhce/cmd/api/src/test/fixtures/fixtures/v6/all/certtemplates.json | jq -r '.data | map(.)[] | .ObjectIdentifier as $targetId | .Aces[] | (.PrincipalSID | ascii_upcase) as $sourceId | ("ad." + .PrincipalType) as $sourceType | ("ad." + .RightName) as $relType |"query.And(query.Kind(query.Start(), \($sourceType)), query.Equals(query.StartProperty(common.ObjectID.String()), \"" + $sourceId + "\"), query.Kind(query.Relationship(), \($relType)), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), \"\($targetId)\")),"'

		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "72F15D5F-C7B4-4FD9-ADCE-302F0D3DC91A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "72F15D5F-C7B4-4FD9-ADCE-302F0D3DC91A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "72F15D5F-C7B4-4FD9-ADCE-302F0D3DC91A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "72F15D5F-C7B4-4FD9-ADCE-302F0D3DC91A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "72F15D5F-C7B4-4FD9-ADCE-302F0D3DC91A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "72F15D5F-C7B4-4FD9-ADCE-302F0D3DC91A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-513"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "72F15D5F-C7B4-4FD9-ADCE-302F0D3DC91A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "72F15D5F-C7B4-4FD9-ADCE-302F0D3DC91A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "01BCD578-1031-400B-ADBA-0B8AEAB95929")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "01BCD578-1031-400B-ADBA-0B8AEAB95929")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "01BCD578-1031-400B-ADBA-0B8AEAB95929")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "01BCD578-1031-400B-ADBA-0B8AEAB95929")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "01BCD578-1031-400B-ADBA-0B8AEAB95929")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "01BCD578-1031-400B-ADBA-0B8AEAB95929")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "01BCD578-1031-400B-ADBA-0B8AEAB95929")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "251BB763-E8FE-4B7A-9E61-1EDE247847E1")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "251BB763-E8FE-4B7A-9E61-1EDE247847E1")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "251BB763-E8FE-4B7A-9E61-1EDE247847E1")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "251BB763-E8FE-4B7A-9E61-1EDE247847E1")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "251BB763-E8FE-4B7A-9E61-1EDE247847E1")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "251BB763-E8FE-4B7A-9E61-1EDE247847E1")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "251BB763-E8FE-4B7A-9E61-1EDE247847E1")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "E928FF44-D63B-4C60-B20A-94B72B782E38")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "E928FF44-D63B-4C60-B20A-94B72B782E38")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "E928FF44-D63B-4C60-B20A-94B72B782E38")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "E928FF44-D63B-4C60-B20A-94B72B782E38")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "E928FF44-D63B-4C60-B20A-94B72B782E38")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "E928FF44-D63B-4C60-B20A-94B72B782E38")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "E928FF44-D63B-4C60-B20A-94B72B782E38")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "E249A350-93EA-4290-9E28-CFC9A5718C86")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "E249A350-93EA-4290-9E28-CFC9A5718C86")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "E249A350-93EA-4290-9E28-CFC9A5718C86")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "E249A350-93EA-4290-9E28-CFC9A5718C86")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "E249A350-93EA-4290-9E28-CFC9A5718C86")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "E249A350-93EA-4290-9E28-CFC9A5718C86")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "E249A350-93EA-4290-9E28-CFC9A5718C86")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "F951BBAA-F10A-4A70-9507-BCD8F188D70B")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "F951BBAA-F10A-4A70-9507-BCD8F188D70B")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "F951BBAA-F10A-4A70-9507-BCD8F188D70B")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "F951BBAA-F10A-4A70-9507-BCD8F188D70B")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "F951BBAA-F10A-4A70-9507-BCD8F188D70B")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "F951BBAA-F10A-4A70-9507-BCD8F188D70B")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "F951BBAA-F10A-4A70-9507-BCD8F188D70B")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "CDDAE05D-4623-464C-AB48-AE38BC7EC8BA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "CDDAE05D-4623-464C-AB48-AE38BC7EC8BA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "CDDAE05D-4623-464C-AB48-AE38BC7EC8BA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "CDDAE05D-4623-464C-AB48-AE38BC7EC8BA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "CDDAE05D-4623-464C-AB48-AE38BC7EC8BA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "CDDAE05D-4623-464C-AB48-AE38BC7EC8BA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "CDDAE05D-4623-464C-AB48-AE38BC7EC8BA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "43616DDD-A336-439F-8A08-088CC0AA85C1")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "43616DDD-A336-439F-8A08-088CC0AA85C1")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "43616DDD-A336-439F-8A08-088CC0AA85C1")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "43616DDD-A336-439F-8A08-088CC0AA85C1")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "43616DDD-A336-439F-8A08-088CC0AA85C1")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "43616DDD-A336-439F-8A08-088CC0AA85C1")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "43616DDD-A336-439F-8A08-088CC0AA85C1")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "C6DC9FD9-2A52-4064-9D8E-ED9BBA52FD51")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "C6DC9FD9-2A52-4064-9D8E-ED9BBA52FD51")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "C6DC9FD9-2A52-4064-9D8E-ED9BBA52FD51")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "C6DC9FD9-2A52-4064-9D8E-ED9BBA52FD51")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "C6DC9FD9-2A52-4064-9D8E-ED9BBA52FD51")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "C6DC9FD9-2A52-4064-9D8E-ED9BBA52FD51")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-515"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "C6DC9FD9-2A52-4064-9D8E-ED9BBA52FD51")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "C6DC9FD9-2A52-4064-9D8E-ED9BBA52FD51")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "39E1A53E-3D9E-4341-A3E8-8F297FEB34CD")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "39E1A53E-3D9E-4341-A3E8-8F297FEB34CD")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "39E1A53E-3D9E-4341-A3E8-8F297FEB34CD")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "39E1A53E-3D9E-4341-A3E8-8F297FEB34CD")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "39E1A53E-3D9E-4341-A3E8-8F297FEB34CD")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "39E1A53E-3D9E-4341-A3E8-8F297FEB34CD")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "39E1A53E-3D9E-4341-A3E8-8F297FEB34CD")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "63FB126D-499F-48DA-A707-A134B92764BD")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "63FB126D-499F-48DA-A707-A134B92764BD")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "63FB126D-499F-48DA-A707-A134B92764BD")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "63FB126D-499F-48DA-A707-A134B92764BD")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "63FB126D-499F-48DA-A707-A134B92764BD")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "ESC1.LOCAL-S-1-5-9"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "63FB126D-499F-48DA-A707-A134B92764BD")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-498"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "63FB126D-499F-48DA-A707-A134B92764BD")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "63FB126D-499F-48DA-A707-A134B92764BD")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-516"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "63FB126D-499F-48DA-A707-A134B92764BD")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "63FB126D-499F-48DA-A707-A134B92764BD")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "621424AD-1DD5-487C-B38D-12D094A38153")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "621424AD-1DD5-487C-B38D-12D094A38153")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "621424AD-1DD5-487C-B38D-12D094A38153")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "621424AD-1DD5-487C-B38D-12D094A38153")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "621424AD-1DD5-487C-B38D-12D094A38153")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "621424AD-1DD5-487C-B38D-12D094A38153")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "621424AD-1DD5-487C-B38D-12D094A38153")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "091BE19E-A0D3-4920-A967-5673A2214268")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "091BE19E-A0D3-4920-A967-5673A2214268")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "091BE19E-A0D3-4920-A967-5673A2214268")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "091BE19E-A0D3-4920-A967-5673A2214268")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "091BE19E-A0D3-4920-A967-5673A2214268")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "091BE19E-A0D3-4920-A967-5673A2214268")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "091BE19E-A0D3-4920-A967-5673A2214268")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "441D7EAE-CF79-4B97-83A2-B770C231E4DA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "441D7EAE-CF79-4B97-83A2-B770C231E4DA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "441D7EAE-CF79-4B97-83A2-B770C231E4DA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "441D7EAE-CF79-4B97-83A2-B770C231E4DA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "441D7EAE-CF79-4B97-83A2-B770C231E4DA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "441D7EAE-CF79-4B97-83A2-B770C231E4DA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "441D7EAE-CF79-4B97-83A2-B770C231E4DA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "AACF5D02-3165-4AC7-9AA9-BD604F95011F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "AACF5D02-3165-4AC7-9AA9-BD604F95011F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "AACF5D02-3165-4AC7-9AA9-BD604F95011F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "AACF5D02-3165-4AC7-9AA9-BD604F95011F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "AACF5D02-3165-4AC7-9AA9-BD604F95011F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "AACF5D02-3165-4AC7-9AA9-BD604F95011F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-515"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "AACF5D02-3165-4AC7-9AA9-BD604F95011F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-516"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "AACF5D02-3165-4AC7-9AA9-BD604F95011F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "AACF5D02-3165-4AC7-9AA9-BD604F95011F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "4DC38500-E84C-4A92-9354-AE4665CCC80A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "4DC38500-E84C-4A92-9354-AE4665CCC80A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "4DC38500-E84C-4A92-9354-AE4665CCC80A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "4DC38500-E84C-4A92-9354-AE4665CCC80A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "4DC38500-E84C-4A92-9354-AE4665CCC80A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "4DC38500-E84C-4A92-9354-AE4665CCC80A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "4DC38500-E84C-4A92-9354-AE4665CCC80A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "99679751-132B-4732-89EE-E21F0A1B1B30")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "99679751-132B-4732-89EE-E21F0A1B1B30")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "99679751-132B-4732-89EE-E21F0A1B1B30")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "99679751-132B-4732-89EE-E21F0A1B1B30")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "99679751-132B-4732-89EE-E21F0A1B1B30")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "99679751-132B-4732-89EE-E21F0A1B1B30")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "99679751-132B-4732-89EE-E21F0A1B1B30")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "89486D6B-D221-4435-9544-9CDC8B4E6933")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "89486D6B-D221-4435-9544-9CDC8B4E6933")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "89486D6B-D221-4435-9544-9CDC8B4E6933")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "89486D6B-D221-4435-9544-9CDC8B4E6933")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "89486D6B-D221-4435-9544-9CDC8B4E6933")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "89486D6B-D221-4435-9544-9CDC8B4E6933")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "89486D6B-D221-4435-9544-9CDC8B4E6933")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "3F2F49C7-53C2-4AFB-8DA2-306C2CD1DDCA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "3F2F49C7-53C2-4AFB-8DA2-306C2CD1DDCA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "3F2F49C7-53C2-4AFB-8DA2-306C2CD1DDCA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "3F2F49C7-53C2-4AFB-8DA2-306C2CD1DDCA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "3F2F49C7-53C2-4AFB-8DA2-306C2CD1DDCA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "3F2F49C7-53C2-4AFB-8DA2-306C2CD1DDCA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "3F2F49C7-53C2-4AFB-8DA2-306C2CD1DDCA")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "08FA76AA-B3B1-480E-81E2-48CC2AF009B5")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "08FA76AA-B3B1-480E-81E2-48CC2AF009B5")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "08FA76AA-B3B1-480E-81E2-48CC2AF009B5")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "08FA76AA-B3B1-480E-81E2-48CC2AF009B5")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "08FA76AA-B3B1-480E-81E2-48CC2AF009B5")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "08FA76AA-B3B1-480E-81E2-48CC2AF009B5")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "08FA76AA-B3B1-480E-81E2-48CC2AF009B5")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "2D3B649A-50E0-485B-AEF3-6C8ED9DB0A2A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "2D3B649A-50E0-485B-AEF3-6C8ED9DB0A2A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "2D3B649A-50E0-485B-AEF3-6C8ED9DB0A2A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "2D3B649A-50E0-485B-AEF3-6C8ED9DB0A2A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "2D3B649A-50E0-485B-AEF3-6C8ED9DB0A2A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "2D3B649A-50E0-485B-AEF3-6C8ED9DB0A2A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "2D3B649A-50E0-485B-AEF3-6C8ED9DB0A2A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "A938AA1C-1A2E-4636-9926-43EE00945106")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "A938AA1C-1A2E-4636-9926-43EE00945106")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "A938AA1C-1A2E-4636-9926-43EE00945106")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "A938AA1C-1A2E-4636-9926-43EE00945106")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "A938AA1C-1A2E-4636-9926-43EE00945106")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "A938AA1C-1A2E-4636-9926-43EE00945106")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "A938AA1C-1A2E-4636-9926-43EE00945106")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "1467B8A3-2ACD-4A8B-9CF1-E9333110A00C")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "1467B8A3-2ACD-4A8B-9CF1-E9333110A00C")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "1467B8A3-2ACD-4A8B-9CF1-E9333110A00C")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "1467B8A3-2ACD-4A8B-9CF1-E9333110A00C")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "1467B8A3-2ACD-4A8B-9CF1-E9333110A00C")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "1467B8A3-2ACD-4A8B-9CF1-E9333110A00C")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "1467B8A3-2ACD-4A8B-9CF1-E9333110A00C")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "55BCF264-BBB0-4D50-ACC0-69235586DFC9")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "55BCF264-BBB0-4D50-ACC0-69235586DFC9")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "55BCF264-BBB0-4D50-ACC0-69235586DFC9")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "55BCF264-BBB0-4D50-ACC0-69235586DFC9")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "55BCF264-BBB0-4D50-ACC0-69235586DFC9")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "ESC1.LOCAL-S-1-5-9"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "55BCF264-BBB0-4D50-ACC0-69235586DFC9")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-498"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "55BCF264-BBB0-4D50-ACC0-69235586DFC9")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "55BCF264-BBB0-4D50-ACC0-69235586DFC9")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-516"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "55BCF264-BBB0-4D50-ACC0-69235586DFC9")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "55BCF264-BBB0-4D50-ACC0-69235586DFC9")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "75957C42-9FFB-4D75-A297-7CDB8B11D74F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "75957C42-9FFB-4D75-A297-7CDB8B11D74F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "75957C42-9FFB-4D75-A297-7CDB8B11D74F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "75957C42-9FFB-4D75-A297-7CDB8B11D74F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "75957C42-9FFB-4D75-A297-7CDB8B11D74F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "ESC1.LOCAL-S-1-5-9"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "75957C42-9FFB-4D75-A297-7CDB8B11D74F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-498"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "75957C42-9FFB-4D75-A297-7CDB8B11D74F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "75957C42-9FFB-4D75-A297-7CDB8B11D74F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-516"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "75957C42-9FFB-4D75-A297-7CDB8B11D74F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "75957C42-9FFB-4D75-A297-7CDB8B11D74F")),
		query.And(query.Kind(query.Start(), ad.User), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1105"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "75957C42-9FFB-4D75-A297-7CDB8B11D74F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1106"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "75957C42-9FFB-4D75-A297-7CDB8B11D74F")),
		query.And(query.Kind(query.Start(), ad.User), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1110"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "75957C42-9FFB-4D75-A297-7CDB8B11D74F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "EDB16956-50D9-4E16-B448-441EFC1D1FB8")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "EDB16956-50D9-4E16-B448-441EFC1D1FB8")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "EDB16956-50D9-4E16-B448-441EFC1D1FB8")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "EDB16956-50D9-4E16-B448-441EFC1D1FB8")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "EDB16956-50D9-4E16-B448-441EFC1D1FB8")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "EDB16956-50D9-4E16-B448-441EFC1D1FB8")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-513"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "EDB16956-50D9-4E16-B448-441EFC1D1FB8")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "EDB16956-50D9-4E16-B448-441EFC1D1FB8")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "3C412345-7109-47BC-B33E-D765B14BBE99")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "3C412345-7109-47BC-B33E-D765B14BBE99")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "3C412345-7109-47BC-B33E-D765B14BBE99")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "3C412345-7109-47BC-B33E-D765B14BBE99")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "3C412345-7109-47BC-B33E-D765B14BBE99")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "3C412345-7109-47BC-B33E-D765B14BBE99")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-515"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "3C412345-7109-47BC-B33E-D765B14BBE99")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "3C412345-7109-47BC-B33E-D765B14BBE99")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "8426B1B2-6678-4223-BB03-0EBA065D8976")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "8426B1B2-6678-4223-BB03-0EBA065D8976")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "8426B1B2-6678-4223-BB03-0EBA065D8976")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "8426B1B2-6678-4223-BB03-0EBA065D8976")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "8426B1B2-6678-4223-BB03-0EBA065D8976")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "8426B1B2-6678-4223-BB03-0EBA065D8976")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "8426B1B2-6678-4223-BB03-0EBA065D8976")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-553"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "8426B1B2-6678-4223-BB03-0EBA065D8976")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "64AC5BD1-1DE3-46D4-9796-5C9D98E4B0F7")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "64AC5BD1-1DE3-46D4-9796-5C9D98E4B0F7")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "64AC5BD1-1DE3-46D4-9796-5C9D98E4B0F7")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "64AC5BD1-1DE3-46D4-9796-5C9D98E4B0F7")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "64AC5BD1-1DE3-46D4-9796-5C9D98E4B0F7")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "ESC1.LOCAL-S-1-5-9"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "64AC5BD1-1DE3-46D4-9796-5C9D98E4B0F7")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-498"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "64AC5BD1-1DE3-46D4-9796-5C9D98E4B0F7")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "64AC5BD1-1DE3-46D4-9796-5C9D98E4B0F7")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-516"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "64AC5BD1-1DE3-46D4-9796-5C9D98E4B0F7")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "64AC5BD1-1DE3-46D4-9796-5C9D98E4B0F7")),
		query.And(query.Kind(query.Start(), ad.User), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-500"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "DEBC8BEB-40AF-48B5-940F-AAFAFE961B26")),
		query.And(query.Kind(query.Start(), ad.User), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-500"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "DEBC8BEB-40AF-48B5-940F-AAFAFE961B26")),
		query.And(query.Kind(query.Start(), ad.User), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-500"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "DEBC8BEB-40AF-48B5-940F-AAFAFE961B26")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "DEBC8BEB-40AF-48B5-940F-AAFAFE961B26")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "DEBC8BEB-40AF-48B5-940F-AAFAFE961B26")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "DEBC8BEB-40AF-48B5-940F-AAFAFE961B26")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "DEBC8BEB-40AF-48B5-940F-AAFAFE961B26")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "DEBC8BEB-40AF-48B5-940F-AAFAFE961B26")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "DEBC8BEB-40AF-48B5-940F-AAFAFE961B26")),
		query.And(query.Kind(query.Start(), ad.User), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1105"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "DEBC8BEB-40AF-48B5-940F-AAFAFE961B26")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1106"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "DEBC8BEB-40AF-48B5-940F-AAFAFE961B26")),
		query.And(query.Kind(query.Start(), ad.User), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1110"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "DEBC8BEB-40AF-48B5-940F-AAFAFE961B26")),
		query.And(query.Kind(query.Start(), ad.User), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1112"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "DEBC8BEB-40AF-48B5-940F-AAFAFE961B26")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "9F29EC9F-1DF5-4505-82FB-3DB8B952FDE3")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "9F29EC9F-1DF5-4505-82FB-3DB8B952FDE3")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "9F29EC9F-1DF5-4505-82FB-3DB8B952FDE3")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "9F29EC9F-1DF5-4505-82FB-3DB8B952FDE3")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "9F29EC9F-1DF5-4505-82FB-3DB8B952FDE3")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "9F29EC9F-1DF5-4505-82FB-3DB8B952FDE3")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "9F29EC9F-1DF5-4505-82FB-3DB8B952FDE3")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "176D3356-0094-4E80-868A-00E74B651CC0")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "176D3356-0094-4E80-868A-00E74B651CC0")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "176D3356-0094-4E80-868A-00E74B651CC0")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "176D3356-0094-4E80-868A-00E74B651CC0")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "176D3356-0094-4E80-868A-00E74B651CC0")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "176D3356-0094-4E80-868A-00E74B651CC0")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-513"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "176D3356-0094-4E80-868A-00E74B651CC0")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "176D3356-0094-4E80-868A-00E74B651CC0")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "4376BA2D-B316-41E1-96DF-A0CB1EA0667F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "4376BA2D-B316-41E1-96DF-A0CB1EA0667F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "4376BA2D-B316-41E1-96DF-A0CB1EA0667F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "4376BA2D-B316-41E1-96DF-A0CB1EA0667F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "4376BA2D-B316-41E1-96DF-A0CB1EA0667F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "4376BA2D-B316-41E1-96DF-A0CB1EA0667F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "4376BA2D-B316-41E1-96DF-A0CB1EA0667F")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "67CE0FEC-166C-4E5E-BF87-6FBAF0E9C8A8")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "67CE0FEC-166C-4E5E-BF87-6FBAF0E9C8A8")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "67CE0FEC-166C-4E5E-BF87-6FBAF0E9C8A8")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "67CE0FEC-166C-4E5E-BF87-6FBAF0E9C8A8")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "67CE0FEC-166C-4E5E-BF87-6FBAF0E9C8A8")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "67CE0FEC-166C-4E5E-BF87-6FBAF0E9C8A8")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-513"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "67CE0FEC-166C-4E5E-BF87-6FBAF0E9C8A8")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "67CE0FEC-166C-4E5E-BF87-6FBAF0E9C8A8")),

		//Computer ContainedBy
		//cat bhce/cmd/api/src/test/fixtures/fixtures/v6/all/computers.json | jq -r '.data | map(.)[] | select(.ContainedBy.ObjectIdentifier != null) | (.ContainedBy.ObjectIdentifier | ascii_upcase) as $containerId | ("ad." + .ContainedBy.ObjectType) as $containerType | "query.And(query.Kind(query.Start(), \($containerType)), query.Equals(query.StartProperty(common.ObjectID.String()), \"" + $containerId + "\"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), \"\(.ObjectIdentifier)\")),"'

		query.And(query.Kind(query.Start(), ad.OU), query.Equals(query.StartProperty(common.ObjectID.String()), "1AEEE963-F4C8-49DA-BBE6-A6107F42CAF0"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1000")),
		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "CC7D845D-04FF-470C-8E6B-8C810AB1B4FB"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1103")),

		//Computer ACE Rels
		//cat bhce/cmd/api/src/test/fixtures/fixtures/v6/all/computers.json | jq -r '.data | map(.)[] | .ObjectIdentifier as $targetId | .Aces[] | (.PrincipalSID | ascii_upcase) as $sourceId | ("ad." + .PrincipalType) as $sourceType | ("ad." + .RightName) as $relType |"query.And(query.Kind(query.Start(), \($sourceType)), query.Equals(query.StartProperty(common.ObjectID.String()), \"" + $sourceId + "\"), query.Kind(query.Relationship(), \($relType)), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), \"\($targetId)\")),"'

		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1000")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.GenericAll), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1000")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-526"), query.Kind(query.Relationship(), ad.AddKeyCredentialLink), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1000")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-527"), query.Kind(query.Relationship(), ad.AddKeyCredentialLink), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1000")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.GenericAll), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1000")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "ESC1.LOCAL-S-1-5-32-544"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1000")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "ESC1.LOCAL-S-1-5-32-544"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1000")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "ESC1.LOCAL-S-1-5-32-544"), query.Kind(query.Relationship(), ad.GenericWrite), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1000")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1103")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "ESC1.LOCAL-S-1-5-32-548"), query.Kind(query.Relationship(), ad.GenericAll), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1103")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.GenericAll), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1103")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-526"), query.Kind(query.Relationship(), ad.AddKeyCredentialLink), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1103")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-527"), query.Kind(query.Relationship(), ad.AddKeyCredentialLink), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1103")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.GenericAll), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1103")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "ESC1.LOCAL-S-1-5-32-544"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1103")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "ESC1.LOCAL-S-1-5-32-544"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1103")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "ESC1.LOCAL-S-1-5-32-544"), query.Kind(query.Relationship(), ad.GenericWrite), query.Kind(query.End(), ad.Computer), query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1103")),

		//EnterpriseCAs ContainedBy
		//cat bhce/cmd/api/src/test/fixtures/fixtures/v6/all/enterprisecas.json | jq -r '.data | map(.)[] | select(.ContainedBy.ObjectIdentifier != null) | (.ContainedBy.ObjectIdentifier | ascii_upcase) as $containerId | ("ad." + .ContainedBy.ObjectType) as $containerType | "query.And(query.Kind(query.Start(), \($containerType)), query.Equals(query.StartProperty(common.ObjectID.String()), \"" + $containerId + "\"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), \"\(.ObjectIdentifier)\")),"'

		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "22F8BB5D-B81E-4856-96A9-A6448386EB23"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),

		//EnterpriseCAs PublishedTo Rels
		//cat bhce/cmd/api/src/test/fixtures/fixtures/v6/all/enterprisecas.json | jq -r '.data | map(.)[] | .ObjectIdentifier as $targetId | .EnabledCertTemplates[] | (.ObjectIdentifier | ascii_upcase) as $sourceId |"query.And(query.Kind(query.Start(), ad.CertTemplate), query.Equals(query.StartProperty(common.ObjectID.String()), \"" + $sourceId + "\"), query.Kind(query.Relationship(), ad.PublishedTo), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), \"\($targetId)\")),"'

		query.And(query.Kind(query.Start(), ad.CertTemplate), query.Equals(query.StartProperty(common.ObjectID.String()), "DEBC8BEB-40AF-48B5-940F-AAFAFE961B26"), query.Kind(query.Relationship(), ad.PublishedTo), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.CertTemplate), query.Equals(query.StartProperty(common.ObjectID.String()), "55BCF264-BBB0-4D50-ACC0-69235586DFC9"), query.Kind(query.Relationship(), ad.PublishedTo), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.CertTemplate), query.Equals(query.StartProperty(common.ObjectID.String()), "75957C42-9FFB-4D75-A297-7CDB8B11D74F"), query.Kind(query.Relationship(), ad.PublishedTo), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.CertTemplate), query.Equals(query.StartProperty(common.ObjectID.String()), "64AC5BD1-1DE3-46D4-9796-5C9D98E4B0F7"), query.Kind(query.Relationship(), ad.PublishedTo), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.CertTemplate), query.Equals(query.StartProperty(common.ObjectID.String()), "E249A350-93EA-4290-9E28-CFC9A5718C86"), query.Kind(query.Relationship(), ad.PublishedTo), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.CertTemplate), query.Equals(query.StartProperty(common.ObjectID.String()), "EDB16956-50D9-4E16-B448-441EFC1D1FB8"), query.Kind(query.Relationship(), ad.PublishedTo), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.CertTemplate), query.Equals(query.StartProperty(common.ObjectID.String()), "63FB126D-499F-48DA-A707-A134B92764BD"), query.Kind(query.Relationship(), ad.PublishedTo), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.CertTemplate), query.Equals(query.StartProperty(common.ObjectID.String()), "621424AD-1DD5-487C-B38D-12D094A38153"), query.Kind(query.Relationship(), ad.PublishedTo), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.CertTemplate), query.Equals(query.StartProperty(common.ObjectID.String()), "C6DC9FD9-2A52-4064-9D8E-ED9BBA52FD51"), query.Kind(query.Relationship(), ad.PublishedTo), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.CertTemplate), query.Equals(query.StartProperty(common.ObjectID.String()), "72F15D5F-C7B4-4FD9-ADCE-302F0D3DC91A"), query.Kind(query.Relationship(), ad.PublishedTo), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.CertTemplate), query.Equals(query.StartProperty(common.ObjectID.String()), "441D7EAE-CF79-4B97-83A2-B770C231E4DA"), query.Kind(query.Relationship(), ad.PublishedTo), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.CertTemplate), query.Equals(query.StartProperty(common.ObjectID.String()), "251BB763-E8FE-4B7A-9E61-1EDE247847E1"), query.Kind(query.Relationship(), ad.PublishedTo), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),

		//EnterpriseCAs Hosting Computer
		query.And(query.Kind(query.Start(), ad.Computer), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1000"), query.Kind(query.Relationship(), ad.HostsCAService), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),

		//EnterpriseCAs DelegatedEnrollmentAgent
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-513"), query.Kind(query.Relationship(), ad.DelegatedEnrollmentAgent), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "DEBC8BEB-40AF-48B5-940F-AAFAFE961B26")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-513"), query.Kind(query.Relationship(), ad.DelegatedEnrollmentAgent), query.Kind(query.End(), ad.CertTemplate), query.Equals(query.EndProperty(common.ObjectID.String()), "55BCF264-BBB0-4D50-ACC0-69235586DFC9")),

		//EnterpriseCAs ACE Rels
		//cat bhce/cmd/api/src/test/fixtures/fixtures/v6/all/enterprisecas.json | jq -r '.data | map(.)[] | .ObjectIdentifier as $targetId | .Aces[] | (.PrincipalSID | ascii_upcase) as $sourceId | ("ad." + .PrincipalType) as $sourceType | ("ad." + .RightName) as $relType |"query.And(query.Kind(query.Start(), \($sourceType)), query.Equals(query.StartProperty(common.ObjectID.String()), \"" + $sourceId + "\"), query.Kind(query.Relationship(), \($relType)), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), \"\($targetId)\")),"'
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.ManageCA), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.ManageCertificates), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.Computer), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1000"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.Computer), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1000"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.Computer), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1000"), query.Kind(query.Relationship(), ad.ManageCA), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.Computer), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1000"), query.Kind(query.Relationship(), ad.ManageCertificates), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.User), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1105"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1108"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.User), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1111"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.User), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1113"), query.Kind(query.Relationship(), ad.Enroll), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.GenericAll), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.ManageCA), query.Kind(query.End(), ad.EnterpriseCA), query.Equals(query.EndProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A")),

		//NTAuthStores ContainedBy
		//cat bhce/cmd/api/src/test/fixtures/fixtures/v6/all/ntauthstores.json | jq -r '.data | map(.)[] | select(.ContainedBy.ObjectIdentifier != null) | (.ContainedBy.ObjectIdentifier | ascii_upcase) as $containerId | ("ad." + .ContainedBy.ObjectType) as $containerType | "query.And(query.Kind(query.Start(), \($containerType)), query.Equals(query.StartProperty(common.ObjectID.String()), \"" + $containerId + "\"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.NTAuthStore), query.Equals(query.EndProperty(common.ObjectID.String()), \"\(.ObjectIdentifier)\")),"'

		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "A18A3A99-3E4C-46DD-9C90-E5542FA4EC84"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.NTAuthStore), query.Equals(query.EndProperty(common.ObjectID.String()), "722A8BB3-AEF5-49C7-9C8C-C1C97A219007")),

		//NTAuthStoreFor
		query.And(
			query.Kind(query.Start(), ad.NTAuthStore),
			query.Equals(query.StartProperty(common.ObjectID.String()), "722A8BB3-AEF5-49C7-9C8C-C1C97A219007"),
			query.Kind(query.Relationship(), ad.NTAuthStoreFor),
			query.Kind(query.End(), ad.Domain),
			query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266")),

		//NTAuthStore ACE Rels
		//cat bhce/cmd/api/src/test/fixtures/fixtures/v6/all/ntauthstores.json | jq -r '.data | map(.)[] | .ObjectIdentifier as $targetId | .Aces[] | (.PrincipalSID | ascii_upcase) as $sourceId | ("ad." + .PrincipalType) as $sourceType | ("ad." + .RightName) as $relType |"query.And(query.Kind(query.Start(), \($sourceType)), query.Equals(query.StartProperty(common.ObjectID.String()), \"" + $sourceId + "\"), query.Kind(query.Relationship(), \($relType)), query.Kind(query.End(), ad.NTAuthStore), query.Equals(query.EndProperty(common.ObjectID.String()), \"\($targetId)\")),"'

		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.NTAuthStore), query.Equals(query.EndProperty(common.ObjectID.String()), "722A8BB3-AEF5-49C7-9C8C-C1C97A219007")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "ESC1.LOCAL-S-1-5-32-544"), query.Kind(query.Relationship(), ad.GenericAll), query.Kind(query.End(), ad.NTAuthStore), query.Equals(query.EndProperty(common.ObjectID.String()), "722A8BB3-AEF5-49C7-9C8C-C1C97A219007")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.GenericAll), query.Kind(query.End(), ad.NTAuthStore), query.Equals(query.EndProperty(common.ObjectID.String()), "722A8BB3-AEF5-49C7-9C8C-C1C97A219007")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.GenericAll), query.Kind(query.End(), ad.NTAuthStore), query.Equals(query.EndProperty(common.ObjectID.String()), "722A8BB3-AEF5-49C7-9C8C-C1C97A219007")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.GenericAll), query.Kind(query.End(), ad.NTAuthStore), query.Equals(query.EndProperty(common.ObjectID.String()), "722A8BB3-AEF5-49C7-9C8C-C1C97A219007")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.NTAuthStore), query.Equals(query.EndProperty(common.ObjectID.String()), "722A8BB3-AEF5-49C7-9C8C-C1C97A219007")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.NTAuthStore), query.Equals(query.EndProperty(common.ObjectID.String()), "722A8BB3-AEF5-49C7-9C8C-C1C97A219007")),

		//RootCAs ContainedBy
		//cat bhce/cmd/api/src/test/fixtures/fixtures/v6/all/rootcas.json | jq -r '.data | map(.)[] | select(.ContainedBy.ObjectIdentifier != null) | (.ContainedBy.ObjectIdentifier | ascii_upcase) as $containerId | ("ad." + .ContainedBy.ObjectType) as $containerType | "query.And(query.Kind(query.Start(), \($containerType)), query.Equals(query.StartProperty(common.ObjectID.String()), \"" + $containerId + "\"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.RootCA), query.Equals(query.EndProperty(common.ObjectID.String()), \"\(.ObjectIdentifier)\")),"'

		query.And(query.Kind(query.Start(), ad.Container), query.Equals(query.StartProperty(common.ObjectID.String()), "242AB0E0-13D1-4517-BEB0-07E504802B6B"), query.Kind(query.Relationship(), ad.Contains), query.Kind(query.End(), ad.RootCA), query.Equals(query.EndProperty(common.ObjectID.String()), "4B5183E1-DB57-4A57-8159-3E9649F3B01C")),

		//RootCAFor
		query.And(
			query.Kind(query.Start(), ad.RootCA),
			query.Equals(query.StartProperty(common.ObjectID.String()), "4B5183E1-DB57-4A57-8159-3E9649F3B01C"),
			query.Kind(query.Relationship(), ad.RootCAFor),
			query.Kind(query.End(), ad.Domain),
			query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266")),

		//RootCAs ACE Rels
		//cat bhce/cmd/api/src/test/fixtures/fixtures/v6/all/rootcas.json | jq -r '.data | map(.)[] | .ObjectIdentifier as $targetId | .Aces[] | (.PrincipalSID | ascii_upcase) as $sourceId | ("ad." + .PrincipalType) as $sourceType | ("ad." + .RightName) as $relType |"query.And(query.Kind(query.Start(), \($sourceType)), query.Equals(query.StartProperty(common.ObjectID.String()), \"" + $sourceId + "\"), query.Kind(query.Relationship(), \($relType)), query.Kind(query.End(), ad.RootCA), query.Equals(query.EndProperty(common.ObjectID.String()), \"\($targetId)\")),"'

		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.Owns), query.Kind(query.End(), ad.RootCA), query.Equals(query.EndProperty(common.ObjectID.String()), "4B5183E1-DB57-4A57-8159-3E9649F3B01C")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "ESC1.LOCAL-S-1-5-32-544"), query.Kind(query.Relationship(), ad.GenericAll), query.Kind(query.End(), ad.RootCA), query.Equals(query.EndProperty(common.ObjectID.String()), "4B5183E1-DB57-4A57-8159-3E9649F3B01C")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.GenericAll), query.Kind(query.End(), ad.RootCA), query.Equals(query.EndProperty(common.ObjectID.String()), "4B5183E1-DB57-4A57-8159-3E9649F3B01C")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-517"), query.Kind(query.Relationship(), ad.GenericAll), query.Kind(query.End(), ad.RootCA), query.Equals(query.EndProperty(common.ObjectID.String()), "4B5183E1-DB57-4A57-8159-3E9649F3B01C")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.GenericAll), query.Kind(query.End(), ad.RootCA), query.Equals(query.EndProperty(common.ObjectID.String()), "4B5183E1-DB57-4A57-8159-3E9649F3B01C")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-519"), query.Kind(query.Relationship(), ad.GenericAll), query.Kind(query.End(), ad.RootCA), query.Equals(query.EndProperty(common.ObjectID.String()), "4B5183E1-DB57-4A57-8159-3E9649F3B01C")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteDACL), query.Kind(query.End(), ad.RootCA), query.Equals(query.EndProperty(common.ObjectID.String()), "4B5183E1-DB57-4A57-8159-3E9649F3B01C")),
		query.And(query.Kind(query.Start(), ad.Group), query.Equals(query.StartProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-512"), query.Kind(query.Relationship(), ad.WriteOwner), query.Kind(query.End(), ad.RootCA), query.Equals(query.EndProperty(common.ObjectID.String()), "4B5183E1-DB57-4A57-8159-3E9649F3B01C")),

		//IssuancePolicy
		query.And(query.Kind(query.Start(), ad.IssuancePolicy), query.Equals(query.StartProperty(common.ObjectID.String()), "8A0CF606-AED8-44B1-A336-1A3A9E37D10B"), query.Kind(query.Relationship(), ad.OIDGroupLink), query.Kind(query.End(), ad.Group), query.Equals(query.EndProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-513")),
	}

	nodeAssertionCriteria = []graph.Criteria{
		//AIACA Properties
		//cat bhce/cmd/api/src/test/fixtures/fixtures/v6/all/aiacas.json | jq -r '.data | map(.)[] | "query.And(query.Kind(query.Node(), ad.AIACA), query.Equals(query.NodeProperty(common.ObjectID.String()), \"\(.ObjectIdentifier)\"), query.Equals(query.NodeProperty(common.Name.String()), \"\(.Properties.name)\"), query.Equals(query.NodeProperty(ad.DomainSID.String()), \"\(.Properties.domainsid)\"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), \"\(.Properties.distinguishedname)\"), query.Equals(query.NodeProperty(ad.CertThumbprint.String()), \"\(.Properties.certthumbprint)\"), query.Equals(query.NodeProperty(ad.CrossCertificatePair.String()), []string{\(.Properties.crosscertificatepair | @csv)}), query.Equals(query.NodeProperty(ad.HasCrossCertificatePair.String()), \(.Properties.hascrosscertificatepair)), query.Equals(query.NodeProperty(ad.CertName.String()), \"\(.Properties.certname)\"), query.Equals(query.NodeProperty(ad.CertChain.String()), []string{\(.Properties.certchain | @csv)}), query.Equals(query.NodeProperty(ad.HasBasicConstraints.String()), \(.Properties.hasbasicconstraints)), query.Equals(query.NodeProperty(ad.BasicConstraintPathLength.String()), \(.Properties.basicconstraintpathlength))),"'

		query.And(query.Kind(query.Node(), ad.AIACA), query.Equals(query.NodeProperty(common.ObjectID.String()), "6345151F-D854-4D83-B7D0-D94E10CFBAF2"), query.Equals(query.NodeProperty(common.Name.String()), "ESC1-ESC1-DC-CA@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=ESC1-ESC1-DC-CA,CN=AIA,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.CertThumbprint.String()), "5F0143662A7EA16E8DB90E44D0F1F1FC87B1E703"), query.Equals(query.NodeProperty(ad.CrossCertificatePair.String()), []string{}), query.Equals(query.NodeProperty(ad.HasCrossCertificatePair.String()), false), query.Equals(query.NodeProperty(ad.CertName.String()), "5F0143662A7EA16E8DB90E44D0F1F1FC87B1E703"), query.Equals(query.NodeProperty(ad.CertChain.String()), []string{"5F0143662A7EA16E8DB90E44D0F1F1FC87B1E703"}), query.Equals(query.NodeProperty(ad.HasBasicConstraints.String()), false), query.Equals(query.NodeProperty(ad.BasicConstraintPathLength.String()), 0)),

		//CertTemplate Properties
		//cat bhce/cmd/api/src/test/fixtures/fixtures/v6/all/certtemplates.json | jq -r '.data | map(.)[] | "query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), \"\(.ObjectIdentifier)\"), query.Equals(query.NodeProperty(common.Name.String()), \"\(.Properties.name)\"), query.Equals(query.NodeProperty(ad.DomainSID.String()), \"\(.Properties.domainsid)\"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), \"\(.Properties.distinguishedname)\"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), \"\(.Properties.validityperiod)\"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), \"\(.Properties.renewalperiod)\"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), \(.Properties.schemaversion)), query.Equals(query.NodeProperty(ad.OID.String()), \"\(.Properties.oid)\"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), \"\(.Properties.enrollmentflag)\"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), \(.Properties.requiresmanagerapproval)), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), \(.Properties.nosecurityextension)), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), \"\(.Properties.certificatenameflag)\"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), \(.Properties.enrolleesuppliessubject)), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), \(.Properties.subjectaltrequireupn)), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{\(.Properties.ekus | @csv)}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{\(.Properties.certificateapplicationpolicy | @csv)}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), \(.Properties.authorizedsignatures)), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{\(.Properties.applicationpolicies | @csv)}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{\(.Properties.issuancepolicies | @csv)}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{\(.Properties.effectiveekus | @csv)}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), \(.Properties.authenticationenabled))),"'
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "72F15D5F-C7B4-4FD9-ADCE-302F0D3DC91A"), query.Equals(query.NodeProperty(common.Name.String()), "USER@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=USER,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "1 year"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.1"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "INCLUDE_SYMMETRIC_ALGORITHMS, PUBLISH_TO_DS, AUTO_ENROLLMENT"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_UPN, SUBJECT_ALT_REQUIRE_EMAIL, SUBJECT_REQUIRE_EMAIL, SUBJECT_REQUIRE_DIRECTORY_PATH"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), true), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.4.1.311.10.3.4", "1.3.6.1.5.5.7.3.4", "1.3.6.1.5.5.7.3.2"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.4.1.311.10.3.4", "1.3.6.1.5.5.7.3.4", "1.3.6.1.5.5.7.3.2"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), true)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "01BCD578-1031-400B-ADBA-0B8AEAB95929"), query.Equals(query.NodeProperty(common.Name.String()), "SMARTCARDLOGON@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=SMARTCARDLOGON,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "1 year"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.5"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "NONE"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_UPN, SUBJECT_REQUIRE_DIRECTORY_PATH"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), true), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.5.5.7.3.2", "1.3.6.1.4.1.311.20.2.2"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.5.5.7.3.2", "1.3.6.1.4.1.311.20.2.2"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), true)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "251BB763-E8FE-4B7A-9E61-1EDE247847E1"), query.Equals(query.NodeProperty(common.Name.String()), "ADMINISTRATOR@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=ADMINISTRATOR,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "1 year"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.7"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "INCLUDE_SYMMETRIC_ALGORITHMS, PUBLISH_TO_DS, AUTO_ENROLLMENT"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_UPN, SUBJECT_ALT_REQUIRE_EMAIL, SUBJECT_REQUIRE_EMAIL, SUBJECT_REQUIRE_DIRECTORY_PATH"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), true), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.4.1.311.10.3.1", "1.3.6.1.4.1.311.10.3.4", "1.3.6.1.5.5.7.3.4", "1.3.6.1.5.5.7.3.2"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.4.1.311.10.3.1", "1.3.6.1.4.1.311.10.3.4", "1.3.6.1.5.5.7.3.4", "1.3.6.1.5.5.7.3.2"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), true)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "E928FF44-D63B-4C60-B20A-94B72B782E38"), query.Equals(query.NodeProperty(common.Name.String()), "CODESIGNING@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=CODESIGNING,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "1 year"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.9"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "AUTO_ENROLLMENT"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_UPN, SUBJECT_REQUIRE_DIRECTORY_PATH"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), true), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.5.5.7.3.3"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.5.5.7.3.3"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), false)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "E249A350-93EA-4290-9E28-CFC9A5718C86"), query.Equals(query.NodeProperty(common.Name.String()), "EFSRECOVERY@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=EFSRECOVERY,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "5 years"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.8"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "INCLUDE_SYMMETRIC_ALGORITHMS, AUTO_ENROLLMENT"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_UPN, SUBJECT_REQUIRE_DIRECTORY_PATH"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), true), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.4.1.311.10.3.4.1"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.4.1.311.10.3.4.1"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), false)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "F951BBAA-F10A-4A70-9507-BCD8F188D70B"), query.Equals(query.NodeProperty(common.Name.String()), "CTLSIGNING@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=CTLSIGNING,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "1 year"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.10"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "AUTO_ENROLLMENT"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_UPN, SUBJECT_REQUIRE_DIRECTORY_PATH"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), true), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.4.1.311.10.3.1"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.4.1.311.10.3.1"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), false)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "CDDAE05D-4623-464C-AB48-AE38BC7EC8BA"), query.Equals(query.NodeProperty(common.Name.String()), "ENROLLMENTAGENT@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=ENROLLMENTAGENT,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "2 years"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.11"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "AUTO_ENROLLMENT"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_UPN, SUBJECT_REQUIRE_DIRECTORY_PATH"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), true), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.4.1.311.20.2.1"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.4.1.311.20.2.1"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), false)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "43616DDD-A336-439F-8A08-088CC0AA85C1"), query.Equals(query.NodeProperty(common.Name.String()), "ENROLLMENTAGENTOFFLINE@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=ENROLLMENTAGENTOFFLINE,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "2 years"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.12"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "NONE"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "ENROLLEE_SUPPLIES_SUBJECT"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), true), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.4.1.311.20.2.1"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.4.1.311.20.2.1"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), false)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "C6DC9FD9-2A52-4064-9D8E-ED9BBA52FD51"), query.Equals(query.NodeProperty(common.Name.String()), "MACHINE@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=MACHINE,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "1 year"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.14"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "AUTO_ENROLLMENT"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_DNS, SUBJECT_REQUIRE_DNS_AS_CN"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.5.5.7.3.2", "1.3.6.1.5.5.7.3.1"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.5.5.7.3.2", "1.3.6.1.5.5.7.3.1"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), true)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "39E1A53E-3D9E-4341-A3E8-8F297FEB34CD"), query.Equals(query.NodeProperty(common.Name.String()), "MACHINEENROLLMENTAGENT@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=MACHINEENROLLMENTAGENT,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "2 years"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.13"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "AUTO_ENROLLMENT"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_DNS, SUBJECT_REQUIRE_DNS_AS_CN"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.4.1.311.20.2.1"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.4.1.311.20.2.1"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), false)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "63FB126D-499F-48DA-A707-A134B92764BD"), query.Equals(query.NodeProperty(common.Name.String()), "DOMAINCONTROLLER@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=DOMAINCONTROLLER,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "1 year"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.15"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "INCLUDE_SYMMETRIC_ALGORITHMS, PUBLISH_TO_DS, AUTO_ENROLLMENT"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_DIRECTORY_GUID, SUBJECT_ALT_REQUIRE_DNS, SUBJECT_REQUIRE_DNS_AS_CN"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.5.5.7.3.2", "1.3.6.1.5.5.7.3.1"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.5.5.7.3.2", "1.3.6.1.5.5.7.3.1"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), true)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "621424AD-1DD5-487C-B38D-12D094A38153"), query.Equals(query.NodeProperty(common.Name.String()), "WEBSERVER@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=WEBSERVER,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "2 years"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.16"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "NONE"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "ENROLLEE_SUPPLIES_SUBJECT"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), true), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.5.5.7.3.1"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.5.5.7.3.1"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), false)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "091BE19E-A0D3-4920-A967-5673A2214268"), query.Equals(query.NodeProperty(common.Name.String()), "CA@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=CA,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "5 years"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.17"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "NONE"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "ENROLLEE_SUPPLIES_SUBJECT"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), true), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), true)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "441D7EAE-CF79-4B97-83A2-B770C231E4DA"), query.Equals(query.NodeProperty(common.Name.String()), "SUBCA@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=SUBCA,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "5 years"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.18"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "NONE"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "ENROLLEE_SUPPLIES_SUBJECT"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), true), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), true)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "AACF5D02-3165-4AC7-9AA9-BD604F95011F"), query.Equals(query.NodeProperty(common.Name.String()), "IPSECINTERMEDIATEONLINE@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=IPSECINTERMEDIATEONLINE,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "2 years"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.19"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "AUTO_ENROLLMENT"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_DNS, SUBJECT_REQUIRE_DNS_AS_CN"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.5.5.8.2.2"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.5.5.8.2.2"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), false)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "4DC38500-E84C-4A92-9354-AE4665CCC80A"), query.Equals(query.NodeProperty(common.Name.String()), "IPSECINTERMEDIATEOFFLINE@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=IPSECINTERMEDIATEOFFLINE,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "2 years"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.20"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "NONE"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "ENROLLEE_SUPPLIES_SUBJECT"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), true), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.5.5.8.2.2"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.5.5.8.2.2"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), false)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "99679751-132B-4732-89EE-E21F0A1B1B30"), query.Equals(query.NodeProperty(common.Name.String()), "OFFLINEROUTER@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=OFFLINEROUTER,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "2 years"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.21"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "NONE"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "ENROLLEE_SUPPLIES_SUBJECT"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), true), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.5.5.7.3.2"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.5.5.7.3.2"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), true)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "89486D6B-D221-4435-9544-9CDC8B4E6933"), query.Equals(query.NodeProperty(common.Name.String()), "CEPENCRYPTION@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=CEPENCRYPTION,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "2 years"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.22"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "NONE"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "ENROLLEE_SUPPLIES_SUBJECT"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), true), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.4.1.311.20.2.1"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.4.1.311.20.2.1"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), false)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "3F2F49C7-53C2-4AFB-8DA2-306C2CD1DDCA"), query.Equals(query.NodeProperty(common.Name.String()), "EXCHANGEUSER@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=EXCHANGEUSER,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "1 year"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.23"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "INCLUDE_SYMMETRIC_ALGORITHMS"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "ENROLLEE_SUPPLIES_SUBJECT"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), true), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.5.5.7.3.4"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.5.5.7.3.4"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), false)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "08FA76AA-B3B1-480E-81E2-48CC2AF009B5"), query.Equals(query.NodeProperty(common.Name.String()), "CROSSCA@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=CROSSCA,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "5 years"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 2), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.25"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "PUBLISH_TO_DS"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "ENROLLEE_SUPPLIES_SUBJECT"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), true), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 1), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{"1.3.6.1.4.1.311.10.3.10"}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), true)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "2D3B649A-50E0-485B-AEF3-6C8ED9DB0A2A"), query.Equals(query.NodeProperty(common.Name.String()), "CAEXCHANGE@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=CAEXCHANGE,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "1 week"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "1 day"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 2), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.26"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "INCLUDE_SYMMETRIC_ALGORITHMS"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "ENROLLEE_SUPPLIES_SUBJECT"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), true), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.4.1.311.21.5"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{"1.3.6.1.4.1.311.21.5"}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.4.1.311.21.5"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), false)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "A938AA1C-1A2E-4636-9926-43EE00945106"), query.Equals(query.NodeProperty(common.Name.String()), "EXCHANGEUSERSIGNATURE@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=EXCHANGEUSERSIGNATURE,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "1 year"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.24"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "NONE"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "ENROLLEE_SUPPLIES_SUBJECT"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), true), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.5.5.7.3.4"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.5.5.7.3.4"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), false)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "1467B8A3-2ACD-4A8B-9CF1-E9333110A00C"), query.Equals(query.NodeProperty(common.Name.String()), "KEYRECOVERYAGENT@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=KEYRECOVERYAGENT,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "2 years"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 2), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.27"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "INCLUDE_SYMMETRIC_ALGORITHMS, PEND_ALL_REQUESTS, PUBLISH_TO_KRA_CONTAINER, AUTO_ENROLLMENT"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), true), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_UPN, SUBJECT_REQUIRE_DIRECTORY_PATH"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), true), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.4.1.311.21.6"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{"1.3.6.1.4.1.311.21.6"}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.4.1.311.21.6"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), false)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "55BCF264-BBB0-4D50-ACC0-69235586DFC9"), query.Equals(query.NodeProperty(common.Name.String()), "DIRECTORYEMAILREPLICATION@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=DIRECTORYEMAILREPLICATION,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "1 year"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 2), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.29"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "INCLUDE_SYMMETRIC_ALGORITHMS, PUBLISH_TO_DS, AUTO_ENROLLMENT"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_DIRECTORY_GUID, SUBJECT_ALT_REQUIRE_DNS"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.4.1.311.21.19"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{"1.3.6.1.4.1.311.21.19"}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.4.1.311.21.19"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), false)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "75957C42-9FFB-4D75-A297-7CDB8B11D74F"), query.Equals(query.NodeProperty(common.Name.String()), "DOMAINCONTROLLERAUTHENTICATION@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=DOMAINCONTROLLERAUTHENTICATION,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "1 year"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 2), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.28"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "NONE"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "ENROLLEE_SUPPLIES_SUBJECT"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), true), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.5.5.7.3.2", "1.3.6.1.5.5.7.3.1", "1.3.6.1.4.1.311.20.2.2"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{"1.3.6.1.5.5.7.3.2", "1.3.6.1.5.5.7.3.1", "1.3.6.1.4.1.311.20.2.2"}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.5.5.7.3.2", "1.3.6.1.5.5.7.3.1", "1.3.6.1.4.1.311.20.2.2"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), true)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "EDB16956-50D9-4E16-B448-441EFC1D1FB8"), query.Equals(query.NodeProperty(common.Name.String()), "EFS@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=EFS,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "1 year"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.6"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "INCLUDE_SYMMETRIC_ALGORITHMS, PUBLISH_TO_DS, AUTO_ENROLLMENT"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_UPN, SUBJECT_REQUIRE_DIRECTORY_PATH"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), true), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.4.1.311.10.3.4"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.4.1.311.10.3.4"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), false)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "3C412345-7109-47BC-B33E-D765B14BBE99"), query.Equals(query.NodeProperty(common.Name.String()), "WORKSTATION@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=WORKSTATION,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "1 year"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 2), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.30"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "AUTO_ENROLLMENT"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_DNS"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.5.5.7.3.2"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{"1.3.6.1.5.5.7.3.2"}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.5.5.7.3.2"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), true)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "8426B1B2-6678-4223-BB03-0EBA065D8976"), query.Equals(query.NodeProperty(common.Name.String()), "RASANDIASSERVER@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=RASANDIASSERVER,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "1 year"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 2), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.31"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "AUTO_ENROLLMENT"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_DNS, SUBJECT_REQUIRE_COMMON_NAME"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.5.5.7.3.2", "1.3.6.1.5.5.7.3.1"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{"1.3.6.1.5.5.7.3.2", "1.3.6.1.5.5.7.3.1"}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.5.5.7.3.2", "1.3.6.1.5.5.7.3.1"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), true)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "64AC5BD1-1DE3-46D4-9796-5C9D98E4B0F7"), query.Equals(query.NodeProperty(common.Name.String()), "KERBEROSAUTHENTICATION@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=KERBEROSAUTHENTICATION,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "1 year"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 2), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.33"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "AUTO_ENROLLMENT"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_DOMAIN_DNS, SUBJECT_ALT_REQUIRE_DNS"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.5.5.7.3.2", "1.3.6.1.5.5.7.3.1", "1.3.6.1.4.1.311.20.2.2", "1.3.6.1.5.2.3.5"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{"1.3.6.1.5.5.7.3.2", "1.3.6.1.5.5.7.3.1", "1.3.6.1.4.1.311.20.2.2", "1.3.6.1.5.2.3.5"}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.5.5.7.3.2", "1.3.6.1.5.5.7.3.1", "1.3.6.1.4.1.311.20.2.2", "1.3.6.1.5.2.3.5"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), true)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "DEBC8BEB-40AF-48B5-940F-AAFAFE961B26"), query.Equals(query.NodeProperty(common.Name.String()), "ESC1@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=ESC1,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "1 year"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 2), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.13327915.10315889"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "INCLUDE_SYMMETRIC_ALGORITHMS, PUBLISH_TO_DS"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "ENROLLEE_SUPPLIES_SUBJECT"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), true), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.5.5.7.3.2", "1.3.6.1.5.5.7.3.4", "1.3.6.1.4.1.311.10.3.4"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{"1.3.6.1.5.5.7.3.2", "1.3.6.1.5.5.7.3.4", "1.3.6.1.4.1.311.10.3.4"}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.5.5.7.3.2", "1.3.6.1.5.5.7.3.4", "1.3.6.1.4.1.311.10.3.4"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), true)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "9F29EC9F-1DF5-4505-82FB-3DB8B952FDE3"), query.Equals(query.NodeProperty(common.Name.String()), "OCSPRESPONSESIGNING@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=OCSPRESPONSESIGNING,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "2 weeks"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "2 days"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 3), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.32"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "ADD_OCSP_NOCHECK, NOREVOCATIONINFOINISSUEDCERTS"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_DNS, SUBJECT_REQUIRE_DNS_AS_CN"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), false), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.5.5.7.3.9"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{"1.3.6.1.5.5.7.3.9"}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{"msPKI-Asymmetric-Algorithm`PZPWSTR`RSA`msPKI-Hash-Algorithm`PZPWSTR`SHA1`msPKI-Key-Security-Descriptor`PZPWSTR`D:P(A;;FA;;;BA)(A;;FA;;;SY)(A;;GR;;;S-1-5-80-3804348527-3718992918-2141599610-3686422417-2726379419)`msPKI-Key-Usage`DWORD`2`"}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.5.5.7.3.9"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), false)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "176D3356-0094-4E80-868A-00E74B651CC0"), query.Equals(query.NodeProperty(common.Name.String()), "USERSIGNATURE@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=USERSIGNATURE,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "1 year"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.2"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "AUTO_ENROLLMENT"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_UPN, SUBJECT_ALT_REQUIRE_EMAIL, SUBJECT_REQUIRE_EMAIL, SUBJECT_REQUIRE_DIRECTORY_PATH"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), true), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.5.5.7.3.4", "1.3.6.1.5.5.7.3.2"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.5.5.7.3.4", "1.3.6.1.5.5.7.3.2"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), true)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "4376BA2D-B316-41E1-96DF-A0CB1EA0667F"), query.Equals(query.NodeProperty(common.Name.String()), "SMARTCARDUSER@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=SMARTCARDUSER,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "1 year"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.3"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "INCLUDE_SYMMETRIC_ALGORITHMS, PUBLISH_TO_DS"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_UPN, SUBJECT_ALT_REQUIRE_EMAIL, SUBJECT_REQUIRE_EMAIL, SUBJECT_REQUIRE_DIRECTORY_PATH"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), true), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.5.5.7.3.4", "1.3.6.1.5.5.7.3.2", "1.3.6.1.4.1.311.20.2.2"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.5.5.7.3.4", "1.3.6.1.5.5.7.3.2", "1.3.6.1.4.1.311.20.2.2"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), true)),
		query.And(query.Kind(query.Node(), ad.CertTemplate), query.Equals(query.NodeProperty(common.ObjectID.String()), "67CE0FEC-166C-4E5E-BF87-6FBAF0E9C8A8"), query.Equals(query.NodeProperty(common.Name.String()), "CLIENTAUTH@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=CLIENTAUTH,CN=CERTIFICATE TEMPLATES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.ValidityPeriod.String()), "1 year"), query.Equals(query.NodeProperty(ad.RenewalPeriod.String()), "6 weeks"), query.Equals(query.NodeProperty(ad.SchemaVersion.String()), 1), query.Equals(query.NodeProperty(ad.OID.String()), "1.3.6.1.4.1.311.21.8.12059088.7148202.5130407.12905872.6174753.77.1.4"), query.Equals(query.NodeProperty(ad.EnrollmentFlag.String()), "AUTO_ENROLLMENT"), query.Equals(query.NodeProperty(ad.RequiresManagerApproval.String()), false), query.Equals(query.NodeProperty(ad.NoSecurityExtension.String()), false), query.Equals(query.NodeProperty(ad.CertificateNameFlag.String()), "SUBJECT_ALT_REQUIRE_UPN, SUBJECT_REQUIRE_DIRECTORY_PATH"), query.Equals(query.NodeProperty(ad.EnrolleeSuppliesSubject.String()), false), query.Equals(query.NodeProperty(ad.SubjectAltRequireUPN.String()), true), query.Equals(query.NodeProperty(ad.EKUs.String()), []string{"1.3.6.1.5.5.7.3.2"}), query.Equals(query.NodeProperty(ad.CertificateApplicationPolicy.String()), []string{}), query.Equals(query.NodeProperty(ad.AuthorizedSignatures.String()), 0), query.Equals(query.NodeProperty(ad.ApplicationPolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.IssuancePolicies.String()), []string{}), query.Equals(query.NodeProperty(ad.EffectiveEKUs.String()), []string{"1.3.6.1.5.5.7.3.2"}), query.Equals(query.NodeProperty(ad.AuthenticationEnabled.String()), true)),

		//Computer Properties
		query.And(query.Kind(query.Node(), ad.Computer), query.Equals(query.NodeProperty(common.ObjectID.String()), "S-1-5-21-909015691-3030120388-2582151266-1000"), query.Equals(query.NodeProperty(ad.StrongCertificateBindingEnforcementRaw.String()), 2), query.Equals(query.NodeProperty(ad.StrongCertificateBindingEnforcement.String()), "Full enforcement mode"), query.Equals(query.NodeProperty(ad.CertificateMappingMethods.String()), []string{"Registry value does not exist"}), query.Equals(query.NodeProperty(ad.CertificateMappingMethodsRaw.String()), ein.RegistryValueDoesNotExist)),

		//EnterpriseCA Properties
		//cat bhce/cmd/api/src/test/fixtures/fixtures/v6/all/enterprisecas.json | jq -r '.data | map(.)[] | "query.And(query.Kind(query.Node(), ad.EnterpriseCA), query.Equals(query.NodeProperty(common.ObjectID.String()), \"\(.ObjectIdentifier)\"), query.Equals(query.NodeProperty(common.Name.String()), \"\(.Properties.name)\"), query.Equals(query.NodeProperty(ad.DomainSID.String()), \"\(.Properties.domainsid)\"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), \"\(.Properties.distinguishedname)\"), query.Equals(query.NodeProperty(ad.Flags.String()), \"\(.Properties.flags)\"), query.Equals(query.NodeProperty(ad.CAName.String()), \"\(.Properties.caname)\"), query.Equals(query.NodeProperty(ad.DNSHostname.String()), \"\(.Properties.dnshostname)\"), query.Equals(query.NodeProperty(ad.CertThumbprint.String()), \"\(.Properties.certthumbprint)\"), query.Equals(query.NodeProperty(ad.CertName.String()), \"\(.Properties.certname)\"), query.Equals(query.NodeProperty(ad.CertChain.String()), []string{\(.Properties.certchain | @csv)}), query.Equals(query.NodeProperty(ad.HasBasicConstraints.String()), \(.Properties.hasbasicconstraints)), query.Equals(query.NodeProperty(ad.BasicConstraintPathLength.String()), \(.Properties.basicconstraintpathlength)), query.Equals(query.NodeProperty(ad.CASecurityCollected.String()), \(.Properties.casecuritycollected)), query.Equals(query.NodeProperty(ad.EnrollmentAgentRestrictionsCollected.String()), \(.Properties.enrollmentagentrestrictionscollected)), query.Equals(query.NodeProperty(ad.BasicConstraintPathLength.String()), \(.Properties.basicconstraintpathlength))),"'

		query.And(query.Kind(query.Node(), ad.EnterpriseCA), query.Equals(query.NodeProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A"), query.Equals(query.NodeProperty(common.Name.String()), "ESC1-ESC1-DC-CA@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=ESC1-ESC1-DC-CA,CN=ENROLLMENT SERVICES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.Flags.String()), "SUPPORTS_NT_AUTHENTICATION, CA_SERVERTYPE_ADVANCED"), query.Equals(query.NodeProperty(ad.CAName.String()), "ESC1-ESC1-DC-CA"), query.Equals(query.NodeProperty(ad.DNSHostname.String()), "ESC1-DC.ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.CertThumbprint.String()), "5F0143662A7EA16E8DB90E44D0F1F1FC87B1E703"), query.Equals(query.NodeProperty(ad.CertName.String()), "5F0143662A7EA16E8DB90E44D0F1F1FC87B1E703"), query.Equals(query.NodeProperty(ad.CertChain.String()), []string{"5F0143662A7EA16E8DB90E44D0F1F1FC87B1E703"}), query.Equals(query.NodeProperty(ad.HasBasicConstraints.String()), false), query.Equals(query.NodeProperty(ad.BasicConstraintPathLength.String()), 0), query.Equals(query.NodeProperty(ad.CASecurityCollected.String()), true), query.Equals(query.NodeProperty(ad.EnrollmentAgentRestrictionsCollected.String()), true), query.Equals(query.NodeProperty(ad.BasicConstraintPathLength.String()), 0)),

		query.And(query.Kind(query.Node(), ad.EnterpriseCA), query.Equals(query.NodeProperty(common.ObjectID.String()), "14CEE53E-4D95-4DDD-A244-BF15C73DC06A"), query.Equals(query.NodeProperty(ad.IsUserSpecifiesSanEnabled.String()), false), query.Equals(query.NodeProperty(ad.HasEnrollmentAgentRestrictions.String()), true)),

		//RootCA Properties
		//cat bhce/cmd/api/src/test/fixtures/fixtures/v6/all/rootcas.json | jq -r '.data | map(.)[] | "query.And(query.Kind(query.Node(), ad.RootCA), query.Equals(query.NodeProperty(common.ObjectID.String()), \"\(.ObjectIdentifier)\"), query.Equals(query.NodeProperty(common.Name.String()), \"\(.Properties.name)\"), query.Equals(query.NodeProperty(ad.DomainSID.String()), \"\(.Properties.domainsid)\"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), \"\(.Properties.distinguishedname)\"), query.Equals(query.NodeProperty(ad.CertThumbprint.String()), \"\(.Properties.certthumbprint)\"), query.Equals(query.NodeProperty(ad.CertName.String()), \"\(.Properties.certname)\"), query.Equals(query.NodeProperty(ad.CertChain.String()), []string{\(.Properties.certchain | @csv)}), query.Equals(query.NodeProperty(ad.HasBasicConstraints.String()), \(.Properties.hasbasicconstraints)), query.Equals(query.NodeProperty(ad.BasicConstraintPathLength.String()), \(.Properties.basicconstraintpathlength))),"'

		query.And(query.Kind(query.Node(), ad.RootCA), query.Equals(query.NodeProperty(common.ObjectID.String()), "4B5183E1-DB57-4A57-8159-3E9649F3B01C"), query.Equals(query.NodeProperty(common.Name.String()), "ESC1-ESC1-DC-CA@ESC1.LOCAL"), query.Equals(query.NodeProperty(ad.DomainSID.String()), "S-1-5-21-909015691-3030120388-2582151266"), query.Equals(query.NodeProperty(ad.DistinguishedName.String()), "CN=ESC1-ESC1-DC-CA,CN=CERTIFICATION AUTHORITIES,CN=PUBLIC KEY SERVICES,CN=SERVICES,CN=CONFIGURATION,DC=ESC1,DC=LOCAL"), query.Equals(query.NodeProperty(ad.CertThumbprint.String()), "5F0143662A7EA16E8DB90E44D0F1F1FC87B1E703"), query.Equals(query.NodeProperty(ad.CertName.String()), "5F0143662A7EA16E8DB90E44D0F1F1FC87B1E703"), query.Equals(query.NodeProperty(ad.CertChain.String()), []string{"5F0143662A7EA16E8DB90E44D0F1F1FC87B1E703"}), query.Equals(query.NodeProperty(ad.HasBasicConstraints.String()), false), query.Equals(query.NodeProperty(ad.BasicConstraintPathLength.String()), 0)),
		query.And(query.Kind(query.Node(), ad.IssuancePolicy), query.Equals(query.NodeProperty(common.ObjectID.String()), "8A0CF606-AED8-44B1-A336-1A3A9E37D10B"), query.Equals(query.NodeProperty(common.Name.String()), "LOW ASSURANCE@TESTLAB.LOCAL")),
	}
)

func IngestADCSAssertions(testCtrl test.Controller, tx graph.Transaction) {
	for _, assertionCriteria := range relationshipCriteria {
		_, err := tx.Relationships().Filter(assertionCriteria).First()
		require.Nilf(testCtrl, err, "Unable to find an expected relationship: %s", FormatQueryComponent(assertionCriteria))
	}

	for _, assertionCriteria := range nodeAssertionCriteria {
		_, err := tx.Nodes().Filter(assertionCriteria).First()
		if err != nil {
			tx.Nodes().Filter(assertionCriteria).First()
		}
		require.Nilf(testCtrl, err, "Node assertion failed: %s", FormatQueryComponent(assertionCriteria))
	}
}
