// Copyright 2023 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

// Code generated from grammar/Cypher.g4 by ANTLR 4.13.0. DO NOT EDIT.

package parser // Cypher

import (
	"fmt"
	"strconv"
	"sync"

	"github.com/antlr4-go/antlr/v4"
)

// Suppress unused import errors
var _ = fmt.Printf
var _ = strconv.Itoa
var _ = sync.Once{}

type CypherParser struct {
	*antlr.BaseParser
}

var CypherParserStaticData struct {
	once                   sync.Once
	serializedATN          []int32
	LiteralNames           []string
	SymbolicNames          []string
	RuleNames              []string
	PredictionContextCache *antlr.PredictionContextCache
	atn                    *antlr.ATN
	decisionToDFA          []*antlr.DFA
}

func cypherParserInit() {
	staticData := &CypherParserStaticData
	staticData.LiteralNames = []string{
		"", "';'", "'='", "'('", "')'", "'['", "']'", "','", "'+='", "'|'",
		"'*'", "':'", "'..'", "'<>'", "'<'", "'>'", "'<='", "'>='", "'=~'",
		"'+'", "'-'", "'/'", "'%'", "'^'", "'.'", "'{'", "'}'", "'$'", "'\\u27E8'",
		"'\\u3008'", "'\\uFE64'", "'\\uFF1C'", "'\\u27E9'", "'\\u3009'", "'\\uFE65'",
		"'\\uFF1E'", "'\\u00AD'", "'\\u2010'", "'\\u2011'", "'\\u2012'", "'\\u2013'",
		"'\\u2014'", "'\\u2015'", "'\\u2212'", "'\\uFE58'", "'\\uFE63'", "'\\uFF0D'",
		"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
		"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
		"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
		"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
		"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
		"", "'0'",
	}
	staticData.SymbolicNames = []string{
		"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
		"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
		"", "", "", "", "", "", "", "", "", "", "", "", "", "CYPHER", "EXPLAIN",
		"PROFILE", "USING", "PERIODIC", "COMMIT", "UNION", "ALL", "CREATE",
		"DROP", "INDEX", "ON", "CONSTRAINT", "ASSERT", "IS", "UNIQUE", "EXISTS",
		"LOAD", "CSV", "WITH", "HEADERS", "FROM", "AS", "FIELDTERMINATOR", "OPTIONAL",
		"MATCH", "UNWIND", "MERGE", "SET", "DETACH", "DELETE", "REMOVE", "FOREACH",
		"IN", "CALL", "YIELD", "RETURN", "DISTINCT", "ORDER", "BY", "L_SKIP",
		"LIMIT", "ASCENDING", "ASC", "DESCENDING", "DESC", "JOIN", "SCAN", "START",
		"NODE", "RELATIONSHIP", "REL", "WHERE", "SHORTESTPATH", "ALLSHORTESTPATHS",
		"OR", "XOR", "AND", "NOT", "STARTS", "ENDS", "CONTAINS", "NULL", "COUNT",
		"CASE", "ELSE", "END", "WHEN", "THEN", "FILTER", "EXTRACT", "REDUCE",
		"ANY", "NONE", "SINGLE", "TRUE", "FALSE", "HexInteger", "DecimalInteger",
		"OctalInteger", "HexLetter", "HexDigit", "Digit", "NonZeroDigit", "NonZeroOctDigit",
		"OctDigit", "ZeroDigit", "ExponentDecimalReal", "RegularDecimalReal",
		"StringLiteral", "EscapedChar", "DO", "FOR", "REQUIRE", "MANDATORY",
		"SCALAR", "OF", "ADD", "UnescapedSymbolicName", "IdentifierStart", "IdentifierPart",
		"EscapedSymbolicName", "SP", "WHITESPACE", "Comment",
	}
	staticData.RuleNames = []string{
		"oC_Cypher", "oC_QueryOptions", "oC_AnyCypherOption", "oC_CypherOption",
		"oC_VersionNumber", "oC_Explain", "oC_Profile", "oC_ConfigurationOption",
		"oC_Statement", "oC_Query", "oC_RegularQuery", "oC_BulkImportQuery",
		"oC_PeriodicCommitHint", "oC_LoadCSVQuery", "oC_Union", "oC_SingleQuery",
		"oC_SinglePartQuery", "oC_MultiPartQuery", "oC_UpdatingClause", "oC_ReadingClause",
		"oC_Command", "oC_CreateUniqueConstraint", "oC_CreateNodePropertyExistenceConstraint",
		"oC_CreateRelationshipPropertyExistenceConstraint", "oC_CreateIndex",
		"oC_DropUniqueConstraint", "oC_DropNodePropertyExistenceConstraint",
		"oC_DropRelationshipPropertyExistenceConstraint", "oC_DropIndex", "oC_Index",
		"oC_UniqueConstraint", "oC_NodePropertyExistenceConstraint", "oC_RelationshipPropertyExistenceConstraint",
		"oC_RelationshipPatternSyntax", "oC_LoadCSV", "oC_Match", "oC_Unwind",
		"oC_Merge", "oC_MergeAction", "oC_Create", "oC_CreateUnique", "oC_Set",
		"oC_SetItem", "oC_Delete", "oC_Remove", "oC_RemoveItem", "oC_Foreach",
		"oC_InQueryCall", "oC_StandaloneCall", "oC_YieldItems", "oC_YieldItem",
		"oC_With", "oC_Return", "oC_ProjectionBody", "oC_ProjectionItems", "oC_ProjectionItem",
		"oC_Order", "oC_Skip", "oC_Limit", "oC_SortItem", "oC_Hint", "oC_Start",
		"oC_StartPoint", "oC_Lookup", "oC_NodeLookup", "oC_RelationshipLookup",
		"oC_IdentifiedIndexLookup", "oC_IndexQuery", "oC_IdLookup", "oC_LiteralIds",
		"oC_Where", "oC_Pattern", "oC_PatternPart", "oC_AnonymousPatternPart",
		"oC_ShortestPathPattern", "oC_PatternElement", "oC_RelationshipsPattern",
		"oC_NodePattern", "oC_PatternElementChain", "oC_RelationshipPattern",
		"oC_RelationshipDetail", "oC_Properties", "oC_RelType", "oC_RelationshipTypes",
		"oC_NodeLabels", "oC_NodeLabel", "oC_RangeLiteral", "oC_LabelName",
		"oC_RelTypeName", "oC_PropertyExpression", "oC_Expression", "oC_OrExpression",
		"oC_XorExpression", "oC_AndExpression", "oC_NotExpression", "oC_ComparisonExpression",
		"oC_PartialComparisonExpression", "oC_StringListNullPredicateExpression",
		"oC_StringPredicateExpression", "oC_ListPredicateExpression", "oC_NullPredicateExpression",
		"oC_RegularExpression", "oC_AddOrSubtractExpression", "oC_MultiplyDivideModuloExpression",
		"oC_PowerOfExpression", "oC_UnaryAddOrSubtractExpression", "oC_NonArithmeticOperatorExpression",
		"oC_ListOperatorExpression", "oC_PropertyLookup", "oC_Atom", "oC_CaseExpression",
		"oC_CaseAlternative", "oC_ListComprehension", "oC_PatternComprehension",
		"oC_LegacyListExpression", "oC_Reduce", "oC_Quantifier", "oC_FilterExpression",
		"oC_PatternPredicate", "oC_ParenthesizedExpression", "oC_IdInColl",
		"oC_FunctionInvocation", "oC_FunctionName", "oC_ExistentialSubquery",
		"oC_ExplicitProcedureInvocation", "oC_ImplicitProcedureInvocation",
		"oC_ProcedureResultField", "oC_ProcedureName", "oC_Namespace", "oC_Variable",
		"oC_Literal", "oC_BooleanLiteral", "oC_NumberLiteral", "oC_IntegerLiteral",
		"oC_DoubleLiteral", "oC_ListLiteral", "oC_MapLiteral", "oC_PropertyKeyName",
		"oC_LegacyParameter", "oC_Parameter", "oC_SchemaName", "oC_ReservedWord",
		"oC_SymbolicName", "oC_LeftArrowHead", "oC_RightArrowHead", "oC_Dash",
	}
	staticData.PredictionContextCache = antlr.NewPredictionContextCache()
	staticData.serializedATN = []int32{
		4, 1, 151, 2193, 2, 0, 7, 0, 2, 1, 7, 1, 2, 2, 7, 2, 2, 3, 7, 3, 2, 4,
		7, 4, 2, 5, 7, 5, 2, 6, 7, 6, 2, 7, 7, 7, 2, 8, 7, 8, 2, 9, 7, 9, 2, 10,
		7, 10, 2, 11, 7, 11, 2, 12, 7, 12, 2, 13, 7, 13, 2, 14, 7, 14, 2, 15, 7,
		15, 2, 16, 7, 16, 2, 17, 7, 17, 2, 18, 7, 18, 2, 19, 7, 19, 2, 20, 7, 20,
		2, 21, 7, 21, 2, 22, 7, 22, 2, 23, 7, 23, 2, 24, 7, 24, 2, 25, 7, 25, 2,
		26, 7, 26, 2, 27, 7, 27, 2, 28, 7, 28, 2, 29, 7, 29, 2, 30, 7, 30, 2, 31,
		7, 31, 2, 32, 7, 32, 2, 33, 7, 33, 2, 34, 7, 34, 2, 35, 7, 35, 2, 36, 7,
		36, 2, 37, 7, 37, 2, 38, 7, 38, 2, 39, 7, 39, 2, 40, 7, 40, 2, 41, 7, 41,
		2, 42, 7, 42, 2, 43, 7, 43, 2, 44, 7, 44, 2, 45, 7, 45, 2, 46, 7, 46, 2,
		47, 7, 47, 2, 48, 7, 48, 2, 49, 7, 49, 2, 50, 7, 50, 2, 51, 7, 51, 2, 52,
		7, 52, 2, 53, 7, 53, 2, 54, 7, 54, 2, 55, 7, 55, 2, 56, 7, 56, 2, 57, 7,
		57, 2, 58, 7, 58, 2, 59, 7, 59, 2, 60, 7, 60, 2, 61, 7, 61, 2, 62, 7, 62,
		2, 63, 7, 63, 2, 64, 7, 64, 2, 65, 7, 65, 2, 66, 7, 66, 2, 67, 7, 67, 2,
		68, 7, 68, 2, 69, 7, 69, 2, 70, 7, 70, 2, 71, 7, 71, 2, 72, 7, 72, 2, 73,
		7, 73, 2, 74, 7, 74, 2, 75, 7, 75, 2, 76, 7, 76, 2, 77, 7, 77, 2, 78, 7,
		78, 2, 79, 7, 79, 2, 80, 7, 80, 2, 81, 7, 81, 2, 82, 7, 82, 2, 83, 7, 83,
		2, 84, 7, 84, 2, 85, 7, 85, 2, 86, 7, 86, 2, 87, 7, 87, 2, 88, 7, 88, 2,
		89, 7, 89, 2, 90, 7, 90, 2, 91, 7, 91, 2, 92, 7, 92, 2, 93, 7, 93, 2, 94,
		7, 94, 2, 95, 7, 95, 2, 96, 7, 96, 2, 97, 7, 97, 2, 98, 7, 98, 2, 99, 7,
		99, 2, 100, 7, 100, 2, 101, 7, 101, 2, 102, 7, 102, 2, 103, 7, 103, 2,
		104, 7, 104, 2, 105, 7, 105, 2, 106, 7, 106, 2, 107, 7, 107, 2, 108, 7,
		108, 2, 109, 7, 109, 2, 110, 7, 110, 2, 111, 7, 111, 2, 112, 7, 112, 2,
		113, 7, 113, 2, 114, 7, 114, 2, 115, 7, 115, 2, 116, 7, 116, 2, 117, 7,
		117, 2, 118, 7, 118, 2, 119, 7, 119, 2, 120, 7, 120, 2, 121, 7, 121, 2,
		122, 7, 122, 2, 123, 7, 123, 2, 124, 7, 124, 2, 125, 7, 125, 2, 126, 7,
		126, 2, 127, 7, 127, 2, 128, 7, 128, 2, 129, 7, 129, 2, 130, 7, 130, 2,
		131, 7, 131, 2, 132, 7, 132, 2, 133, 7, 133, 2, 134, 7, 134, 2, 135, 7,
		135, 2, 136, 7, 136, 2, 137, 7, 137, 2, 138, 7, 138, 2, 139, 7, 139, 2,
		140, 7, 140, 2, 141, 7, 141, 2, 142, 7, 142, 2, 143, 7, 143, 2, 144, 7,
		144, 2, 145, 7, 145, 1, 0, 3, 0, 294, 8, 0, 1, 0, 1, 0, 1, 0, 3, 0, 299,
		8, 0, 1, 0, 3, 0, 302, 8, 0, 1, 0, 3, 0, 305, 8, 0, 1, 0, 1, 0, 1, 1, 1,
		1, 3, 1, 311, 8, 1, 5, 1, 313, 8, 1, 10, 1, 12, 1, 316, 9, 1, 1, 2, 1,
		2, 1, 2, 3, 2, 321, 8, 2, 1, 3, 1, 3, 1, 3, 3, 3, 326, 8, 3, 1, 3, 1, 3,
		5, 3, 330, 8, 3, 10, 3, 12, 3, 333, 9, 3, 1, 4, 1, 4, 1, 5, 1, 5, 1, 6,
		1, 6, 1, 7, 1, 7, 3, 7, 343, 8, 7, 1, 7, 1, 7, 3, 7, 347, 8, 7, 1, 7, 1,
		7, 1, 8, 1, 8, 3, 8, 353, 8, 8, 1, 9, 1, 9, 1, 9, 3, 9, 358, 8, 9, 1, 10,
		1, 10, 3, 10, 362, 8, 10, 1, 10, 5, 10, 365, 8, 10, 10, 10, 12, 10, 368,
		9, 10, 1, 11, 1, 11, 3, 11, 372, 8, 11, 1, 11, 1, 11, 1, 12, 1, 12, 1,
		12, 1, 12, 1, 12, 1, 12, 1, 12, 3, 12, 383, 8, 12, 1, 13, 1, 13, 1, 13,
		1, 14, 1, 14, 1, 14, 1, 14, 3, 14, 392, 8, 14, 1, 14, 1, 14, 1, 14, 3,
		14, 397, 8, 14, 1, 14, 3, 14, 400, 8, 14, 1, 15, 1, 15, 3, 15, 404, 8,
		15, 1, 16, 1, 16, 3, 16, 408, 8, 16, 5, 16, 410, 8, 16, 10, 16, 12, 16,
		413, 9, 16, 1, 16, 1, 16, 1, 16, 3, 16, 418, 8, 16, 5, 16, 420, 8, 16,
		10, 16, 12, 16, 423, 9, 16, 1, 16, 1, 16, 3, 16, 427, 8, 16, 1, 16, 5,
		16, 430, 8, 16, 10, 16, 12, 16, 433, 9, 16, 1, 16, 3, 16, 436, 8, 16, 1,
		16, 3, 16, 439, 8, 16, 3, 16, 441, 8, 16, 1, 17, 1, 17, 3, 17, 445, 8,
		17, 5, 17, 447, 8, 17, 10, 17, 12, 17, 450, 9, 17, 1, 17, 1, 17, 3, 17,
		454, 8, 17, 5, 17, 456, 8, 17, 10, 17, 12, 17, 459, 9, 17, 1, 17, 1, 17,
		3, 17, 463, 8, 17, 4, 17, 465, 8, 17, 11, 17, 12, 17, 466, 1, 17, 1, 17,
		1, 18, 1, 18, 1, 18, 1, 18, 1, 18, 1, 18, 1, 18, 3, 18, 478, 8, 18, 1,
		19, 1, 19, 1, 19, 1, 19, 1, 19, 3, 19, 485, 8, 19, 1, 20, 1, 20, 1, 20,
		1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 3, 20, 495, 8, 20, 1, 21, 1, 21, 1,
		21, 1, 21, 1, 22, 1, 22, 1, 22, 1, 22, 1, 23, 1, 23, 1, 23, 1, 23, 1, 24,
		1, 24, 1, 24, 1, 24, 1, 25, 1, 25, 1, 25, 1, 25, 1, 26, 1, 26, 1, 26, 1,
		26, 1, 27, 1, 27, 1, 27, 1, 27, 1, 28, 1, 28, 1, 28, 1, 28, 1, 29, 1, 29,
		1, 29, 1, 29, 3, 29, 533, 8, 29, 1, 29, 1, 29, 1, 29, 1, 29, 1, 29, 1,
		30, 1, 30, 1, 30, 1, 30, 3, 30, 544, 8, 30, 1, 30, 1, 30, 1, 30, 1, 30,
		1, 30, 3, 30, 551, 8, 30, 1, 30, 1, 30, 1, 30, 1, 30, 1, 30, 1, 30, 1,
		30, 1, 30, 1, 31, 1, 31, 1, 31, 1, 31, 3, 31, 565, 8, 31, 1, 31, 1, 31,
		1, 31, 1, 31, 1, 31, 3, 31, 572, 8, 31, 1, 31, 1, 31, 1, 31, 1, 31, 3,
		31, 578, 8, 31, 1, 31, 1, 31, 1, 31, 1, 31, 1, 32, 1, 32, 1, 32, 1, 32,
		3, 32, 588, 8, 32, 1, 32, 1, 32, 3, 32, 592, 8, 32, 1, 32, 1, 32, 1, 32,
		1, 32, 3, 32, 598, 8, 32, 1, 32, 1, 32, 1, 32, 1, 32, 1, 33, 1, 33, 3,
		33, 606, 8, 33, 1, 33, 1, 33, 1, 33, 1, 33, 1, 33, 1, 33, 1, 33, 1, 33,
		1, 33, 3, 33, 617, 8, 33, 1, 33, 1, 33, 1, 33, 1, 33, 3, 33, 623, 8, 33,
		1, 33, 1, 33, 1, 33, 1, 33, 1, 33, 1, 33, 1, 33, 1, 33, 1, 33, 1, 33, 3,
		33, 635, 8, 33, 1, 33, 1, 33, 1, 33, 1, 33, 3, 33, 641, 8, 33, 1, 33, 1,
		33, 1, 33, 1, 33, 1, 33, 1, 33, 1, 33, 1, 33, 1, 33, 1, 33, 3, 33, 653,
		8, 33, 1, 33, 1, 33, 3, 33, 657, 8, 33, 1, 34, 1, 34, 1, 34, 1, 34, 1,
		34, 1, 34, 1, 34, 1, 34, 3, 34, 667, 8, 34, 1, 34, 1, 34, 1, 34, 1, 34,
		1, 34, 1, 34, 1, 34, 1, 34, 1, 34, 1, 34, 1, 34, 3, 34, 680, 8, 34, 1,
		35, 1, 35, 3, 35, 684, 8, 35, 1, 35, 1, 35, 3, 35, 688, 8, 35, 1, 35, 1,
		35, 5, 35, 692, 8, 35, 10, 35, 12, 35, 695, 9, 35, 1, 35, 3, 35, 698, 8,
		35, 1, 35, 3, 35, 701, 8, 35, 1, 36, 1, 36, 3, 36, 705, 8, 36, 1, 36, 1,
		36, 1, 36, 1, 36, 1, 36, 1, 36, 1, 37, 1, 37, 3, 37, 715, 8, 37, 1, 37,
		1, 37, 1, 37, 5, 37, 720, 8, 37, 10, 37, 12, 37, 723, 9, 37, 1, 38, 1,
		38, 1, 38, 1, 38, 1, 38, 1, 38, 1, 38, 1, 38, 1, 38, 1, 38, 3, 38, 735,
		8, 38, 1, 39, 1, 39, 3, 39, 739, 8, 39, 1, 39, 1, 39, 1, 40, 1, 40, 1,
		40, 1, 40, 3, 40, 747, 8, 40, 1, 40, 1, 40, 1, 41, 1, 41, 3, 41, 753, 8,
		41, 1, 41, 1, 41, 3, 41, 757, 8, 41, 1, 41, 1, 41, 3, 41, 761, 8, 41, 1,
		41, 5, 41, 764, 8, 41, 10, 41, 12, 41, 767, 9, 41, 1, 42, 1, 42, 3, 42,
		771, 8, 42, 1, 42, 1, 42, 3, 42, 775, 8, 42, 1, 42, 1, 42, 1, 42, 1, 42,
		3, 42, 781, 8, 42, 1, 42, 1, 42, 3, 42, 785, 8, 42, 1, 42, 1, 42, 1, 42,
		1, 42, 3, 42, 791, 8, 42, 1, 42, 1, 42, 3, 42, 795, 8, 42, 1, 42, 1, 42,
		1, 42, 1, 42, 3, 42, 801, 8, 42, 1, 42, 1, 42, 3, 42, 805, 8, 42, 1, 43,
		1, 43, 3, 43, 809, 8, 43, 1, 43, 1, 43, 3, 43, 813, 8, 43, 1, 43, 1, 43,
		3, 43, 817, 8, 43, 1, 43, 1, 43, 3, 43, 821, 8, 43, 1, 43, 5, 43, 824,
		8, 43, 10, 43, 12, 43, 827, 9, 43, 1, 44, 1, 44, 1, 44, 1, 44, 3, 44, 833,
		8, 44, 1, 44, 1, 44, 3, 44, 837, 8, 44, 1, 44, 5, 44, 840, 8, 44, 10, 44,
		12, 44, 843, 9, 44, 1, 45, 1, 45, 1, 45, 1, 45, 3, 45, 849, 8, 45, 1, 46,
		1, 46, 3, 46, 853, 8, 46, 1, 46, 1, 46, 3, 46, 857, 8, 46, 1, 46, 1, 46,
		1, 46, 1, 46, 1, 46, 1, 46, 3, 46, 865, 8, 46, 1, 46, 1, 46, 1, 46, 4,
		46, 870, 8, 46, 11, 46, 12, 46, 871, 1, 46, 3, 46, 875, 8, 46, 1, 46, 1,
		46, 1, 47, 1, 47, 1, 47, 1, 47, 3, 47, 883, 8, 47, 1, 47, 1, 47, 1, 47,
		3, 47, 888, 8, 47, 1, 48, 1, 48, 1, 48, 1, 48, 3, 48, 894, 8, 48, 1, 48,
		3, 48, 897, 8, 48, 1, 48, 1, 48, 1, 48, 1, 48, 3, 48, 903, 8, 48, 3, 48,
		905, 8, 48, 1, 49, 1, 49, 3, 49, 909, 8, 49, 1, 49, 1, 49, 3, 49, 913,
		8, 49, 1, 49, 5, 49, 916, 8, 49, 10, 49, 12, 49, 919, 9, 49, 1, 49, 3,
		49, 922, 8, 49, 1, 49, 3, 49, 925, 8, 49, 1, 50, 1, 50, 1, 50, 1, 50, 1,
		50, 3, 50, 932, 8, 50, 1, 50, 1, 50, 1, 51, 1, 51, 1, 51, 3, 51, 939, 8,
		51, 1, 51, 3, 51, 942, 8, 51, 1, 52, 1, 52, 1, 52, 1, 53, 3, 53, 948, 8,
		53, 1, 53, 3, 53, 951, 8, 53, 1, 53, 1, 53, 1, 53, 1, 53, 3, 53, 957, 8,
		53, 1, 53, 1, 53, 3, 53, 961, 8, 53, 1, 53, 1, 53, 3, 53, 965, 8, 53, 1,
		54, 1, 54, 3, 54, 969, 8, 54, 1, 54, 1, 54, 3, 54, 973, 8, 54, 1, 54, 5,
		54, 976, 8, 54, 10, 54, 12, 54, 979, 9, 54, 1, 54, 1, 54, 3, 54, 983, 8,
		54, 1, 54, 1, 54, 3, 54, 987, 8, 54, 1, 54, 5, 54, 990, 8, 54, 10, 54,
		12, 54, 993, 9, 54, 3, 54, 995, 8, 54, 1, 55, 1, 55, 1, 55, 1, 55, 1, 55,
		1, 55, 1, 55, 3, 55, 1004, 8, 55, 1, 56, 1, 56, 1, 56, 1, 56, 1, 56, 1,
		56, 1, 56, 3, 56, 1013, 8, 56, 1, 56, 5, 56, 1016, 8, 56, 10, 56, 12, 56,
		1019, 9, 56, 1, 57, 1, 57, 1, 57, 1, 57, 1, 58, 1, 58, 1, 58, 1, 58, 1,
		59, 1, 59, 3, 59, 1031, 8, 59, 1, 59, 3, 59, 1034, 8, 59, 1, 60, 3, 60,
		1037, 8, 60, 1, 60, 1, 60, 1, 60, 1, 60, 1, 60, 1, 60, 1, 60, 1, 60, 1,
		60, 1, 60, 1, 60, 1, 60, 1, 60, 1, 60, 1, 60, 1, 60, 1, 60, 1, 60, 3, 60,
		1057, 8, 60, 1, 60, 1, 60, 3, 60, 1061, 8, 60, 1, 60, 5, 60, 1064, 8, 60,
		10, 60, 12, 60, 1067, 9, 60, 1, 60, 1, 60, 1, 60, 1, 60, 1, 60, 1, 60,
		1, 60, 3, 60, 1076, 8, 60, 1, 61, 1, 61, 1, 61, 1, 61, 3, 61, 1082, 8,
		61, 1, 61, 1, 61, 3, 61, 1086, 8, 61, 1, 61, 5, 61, 1089, 8, 61, 10, 61,
		12, 61, 1092, 9, 61, 1, 61, 3, 61, 1095, 8, 61, 1, 62, 1, 62, 3, 62, 1099,
		8, 62, 1, 62, 1, 62, 3, 62, 1103, 8, 62, 1, 62, 1, 62, 1, 63, 1, 63, 3,
		63, 1109, 8, 63, 1, 64, 1, 64, 3, 64, 1113, 8, 64, 1, 64, 1, 64, 1, 64,
		3, 64, 1118, 8, 64, 1, 65, 1, 65, 1, 65, 1, 65, 3, 65, 1124, 8, 65, 1,
		66, 1, 66, 1, 66, 1, 66, 1, 66, 1, 66, 1, 66, 3, 66, 1133, 8, 66, 1, 66,
		1, 66, 1, 67, 1, 67, 1, 67, 1, 67, 1, 67, 3, 67, 1142, 8, 67, 1, 67, 1,
		67, 1, 68, 1, 68, 1, 68, 1, 68, 3, 68, 1150, 8, 68, 1, 68, 1, 68, 1, 69,
		1, 69, 3, 69, 1156, 8, 69, 1, 69, 1, 69, 3, 69, 1160, 8, 69, 1, 69, 5,
		69, 1163, 8, 69, 10, 69, 12, 69, 1166, 9, 69, 1, 70, 1, 70, 1, 70, 1, 70,
		1, 71, 1, 71, 3, 71, 1174, 8, 71, 1, 71, 1, 71, 3, 71, 1178, 8, 71, 1,
		71, 5, 71, 1181, 8, 71, 10, 71, 12, 71, 1184, 9, 71, 1, 72, 1, 72, 3, 72,
		1188, 8, 72, 1, 72, 1, 72, 3, 72, 1192, 8, 72, 1, 72, 1, 72, 1, 72, 3,
		72, 1197, 8, 72, 1, 73, 1, 73, 3, 73, 1201, 8, 73, 1, 74, 1, 74, 1, 74,
		1, 74, 1, 74, 1, 74, 1, 74, 1, 74, 1, 74, 1, 74, 3, 74, 1213, 8, 74, 1,
		75, 1, 75, 3, 75, 1217, 8, 75, 1, 75, 5, 75, 1220, 8, 75, 10, 75, 12, 75,
		1223, 9, 75, 1, 75, 1, 75, 1, 75, 1, 75, 3, 75, 1229, 8, 75, 1, 76, 1,
		76, 3, 76, 1233, 8, 76, 1, 76, 4, 76, 1236, 8, 76, 11, 76, 12, 76, 1237,
		1, 77, 1, 77, 3, 77, 1242, 8, 77, 1, 77, 1, 77, 3, 77, 1246, 8, 77, 3,
		77, 1248, 8, 77, 1, 77, 1, 77, 3, 77, 1252, 8, 77, 3, 77, 1254, 8, 77,
		1, 77, 1, 77, 3, 77, 1258, 8, 77, 3, 77, 1260, 8, 77, 1, 77, 1, 77, 1,
		78, 1, 78, 3, 78, 1266, 8, 78, 1, 78, 1, 78, 1, 79, 1, 79, 3, 79, 1272,
		8, 79, 1, 79, 1, 79, 3, 79, 1276, 8, 79, 1, 79, 3, 79, 1279, 8, 79, 1,
		79, 3, 79, 1282, 8, 79, 1, 79, 1, 79, 3, 79, 1286, 8, 79, 1, 79, 1, 79,
		1, 79, 1, 79, 3, 79, 1292, 8, 79, 1, 79, 1, 79, 3, 79, 1296, 8, 79, 1,
		79, 3, 79, 1299, 8, 79, 1, 79, 3, 79, 1302, 8, 79, 1, 79, 1, 79, 1, 79,
		1, 79, 3, 79, 1308, 8, 79, 1, 79, 3, 79, 1311, 8, 79, 1, 79, 3, 79, 1314,
		8, 79, 1, 79, 1, 79, 3, 79, 1318, 8, 79, 1, 79, 1, 79, 1, 79, 1, 79, 3,
		79, 1324, 8, 79, 1, 79, 3, 79, 1327, 8, 79, 1, 79, 3, 79, 1330, 8, 79,
		1, 79, 1, 79, 3, 79, 1334, 8, 79, 1, 80, 1, 80, 3, 80, 1338, 8, 80, 1,
		80, 1, 80, 3, 80, 1342, 8, 80, 3, 80, 1344, 8, 80, 1, 80, 1, 80, 3, 80,
		1348, 8, 80, 3, 80, 1350, 8, 80, 1, 80, 3, 80, 1353, 8, 80, 1, 80, 1, 80,
		3, 80, 1357, 8, 80, 3, 80, 1359, 8, 80, 1, 80, 1, 80, 1, 81, 1, 81, 1,
		81, 3, 81, 1366, 8, 81, 1, 82, 1, 82, 3, 82, 1370, 8, 82, 1, 82, 1, 82,
		1, 83, 1, 83, 3, 83, 1376, 8, 83, 1, 83, 1, 83, 3, 83, 1380, 8, 83, 1,
		83, 1, 83, 3, 83, 1384, 8, 83, 1, 83, 3, 83, 1387, 8, 83, 1, 83, 5, 83,
		1390, 8, 83, 10, 83, 12, 83, 1393, 9, 83, 1, 84, 1, 84, 3, 84, 1397, 8,
		84, 1, 84, 5, 84, 1400, 8, 84, 10, 84, 12, 84, 1403, 9, 84, 1, 85, 1, 85,
		3, 85, 1407, 8, 85, 1, 85, 1, 85, 1, 86, 1, 86, 3, 86, 1413, 8, 86, 1,
		86, 1, 86, 3, 86, 1417, 8, 86, 3, 86, 1419, 8, 86, 1, 86, 1, 86, 3, 86,
		1423, 8, 86, 1, 86, 1, 86, 3, 86, 1427, 8, 86, 3, 86, 1429, 8, 86, 3, 86,
		1431, 8, 86, 1, 87, 1, 87, 1, 88, 1, 88, 1, 89, 1, 89, 3, 89, 1439, 8,
		89, 1, 89, 4, 89, 1442, 8, 89, 11, 89, 12, 89, 1443, 1, 90, 1, 90, 1, 91,
		1, 91, 1, 91, 1, 91, 1, 91, 5, 91, 1453, 8, 91, 10, 91, 12, 91, 1456, 9,
		91, 1, 92, 1, 92, 1, 92, 1, 92, 1, 92, 5, 92, 1463, 8, 92, 10, 92, 12,
		92, 1466, 9, 92, 1, 93, 1, 93, 1, 93, 1, 93, 1, 93, 5, 93, 1473, 8, 93,
		10, 93, 12, 93, 1476, 9, 93, 1, 94, 1, 94, 3, 94, 1480, 8, 94, 5, 94, 1482,
		8, 94, 10, 94, 12, 94, 1485, 9, 94, 1, 94, 1, 94, 1, 95, 1, 95, 3, 95,
		1491, 8, 95, 1, 95, 5, 95, 1494, 8, 95, 10, 95, 12, 95, 1497, 9, 95, 1,
		96, 1, 96, 3, 96, 1501, 8, 96, 1, 96, 1, 96, 1, 96, 3, 96, 1506, 8, 96,
		1, 96, 1, 96, 1, 96, 3, 96, 1511, 8, 96, 1, 96, 1, 96, 1, 96, 3, 96, 1516,
		8, 96, 1, 96, 1, 96, 1, 96, 3, 96, 1521, 8, 96, 1, 96, 1, 96, 1, 96, 3,
		96, 1526, 8, 96, 1, 96, 3, 96, 1529, 8, 96, 1, 97, 1, 97, 1, 97, 1, 97,
		5, 97, 1535, 8, 97, 10, 97, 12, 97, 1538, 9, 97, 1, 98, 1, 98, 1, 98, 1,
		98, 1, 98, 1, 98, 1, 98, 1, 98, 1, 98, 1, 98, 1, 98, 3, 98, 1551, 8, 98,
		1, 98, 3, 98, 1554, 8, 98, 1, 98, 1, 98, 1, 99, 1, 99, 1, 99, 3, 99, 1561,
		8, 99, 1, 99, 1, 99, 1, 100, 1, 100, 1, 100, 1, 100, 1, 100, 1, 100, 1,
		100, 1, 100, 1, 100, 1, 100, 3, 100, 1575, 8, 100, 1, 101, 3, 101, 1578,
		8, 101, 1, 101, 1, 101, 1, 102, 1, 102, 3, 102, 1584, 8, 102, 1, 102, 1,
		102, 3, 102, 1588, 8, 102, 1, 102, 1, 102, 3, 102, 1592, 8, 102, 1, 102,
		1, 102, 3, 102, 1596, 8, 102, 1, 102, 5, 102, 1599, 8, 102, 10, 102, 12,
		102, 1602, 9, 102, 1, 103, 1, 103, 3, 103, 1606, 8, 103, 1, 103, 1, 103,
		3, 103, 1610, 8, 103, 1, 103, 1, 103, 3, 103, 1614, 8, 103, 1, 103, 1,
		103, 3, 103, 1618, 8, 103, 1, 103, 1, 103, 3, 103, 1622, 8, 103, 1, 103,
		1, 103, 3, 103, 1626, 8, 103, 1, 103, 5, 103, 1629, 8, 103, 10, 103, 12,
		103, 1632, 9, 103, 1, 104, 1, 104, 3, 104, 1636, 8, 104, 1, 104, 1, 104,
		3, 104, 1640, 8, 104, 1, 104, 5, 104, 1643, 8, 104, 10, 104, 12, 104, 1646,
		9, 104, 1, 105, 1, 105, 1, 105, 3, 105, 1651, 8, 105, 1, 105, 3, 105, 1654,
		8, 105, 1, 106, 1, 106, 3, 106, 1658, 8, 106, 1, 106, 1, 106, 3, 106, 1662,
		8, 106, 1, 106, 5, 106, 1665, 8, 106, 10, 106, 12, 106, 1668, 9, 106, 1,
		106, 3, 106, 1671, 8, 106, 1, 106, 3, 106, 1674, 8, 106, 1, 107, 1, 107,
		1, 107, 1, 107, 1, 107, 1, 107, 3, 107, 1682, 8, 107, 1, 107, 1, 107, 3,
		107, 1686, 8, 107, 1, 107, 3, 107, 1689, 8, 107, 1, 108, 1, 108, 3, 108,
		1693, 8, 108, 1, 108, 1, 108, 1, 109, 1, 109, 1, 109, 1, 109, 1, 109, 1,
		109, 3, 109, 1703, 8, 109, 1, 109, 1, 109, 3, 109, 1707, 8, 109, 1, 109,
		1, 109, 3, 109, 1711, 8, 109, 1, 109, 1, 109, 1, 109, 1, 109, 1, 109, 1,
		109, 1, 109, 1, 109, 1, 109, 1, 109, 1, 109, 1, 109, 3, 109, 1725, 8, 109,
		1, 110, 1, 110, 3, 110, 1729, 8, 110, 1, 110, 4, 110, 1732, 8, 110, 11,
		110, 12, 110, 1733, 1, 110, 1, 110, 3, 110, 1738, 8, 110, 1, 110, 1, 110,
		3, 110, 1742, 8, 110, 1, 110, 4, 110, 1745, 8, 110, 11, 110, 12, 110, 1746,
		3, 110, 1749, 8, 110, 1, 110, 3, 110, 1752, 8, 110, 1, 110, 1, 110, 3,
		110, 1756, 8, 110, 1, 110, 3, 110, 1759, 8, 110, 1, 110, 3, 110, 1762,
		8, 110, 1, 110, 1, 110, 1, 111, 1, 111, 3, 111, 1768, 8, 111, 1, 111, 1,
		111, 3, 111, 1772, 8, 111, 1, 111, 1, 111, 3, 111, 1776, 8, 111, 1, 111,
		1, 111, 1, 112, 1, 112, 3, 112, 1782, 8, 112, 1, 112, 1, 112, 3, 112, 1786,
		8, 112, 1, 112, 1, 112, 3, 112, 1790, 8, 112, 1, 112, 3, 112, 1793, 8,
		112, 1, 112, 3, 112, 1796, 8, 112, 1, 112, 1, 112, 1, 113, 1, 113, 3, 113,
		1802, 8, 113, 1, 113, 1, 113, 3, 113, 1806, 8, 113, 1, 113, 1, 113, 3,
		113, 1810, 8, 113, 3, 113, 1812, 8, 113, 1, 113, 1, 113, 3, 113, 1816,
		8, 113, 1, 113, 1, 113, 3, 113, 1820, 8, 113, 3, 113, 1822, 8, 113, 1,
		113, 1, 113, 3, 113, 1826, 8, 113, 1, 113, 1, 113, 3, 113, 1830, 8, 113,
		1, 113, 1, 113, 1, 114, 1, 114, 3, 114, 1836, 8, 114, 1, 114, 1, 114, 3,
		114, 1840, 8, 114, 1, 114, 1, 114, 3, 114, 1844, 8, 114, 1, 114, 1, 114,
		1, 114, 1, 114, 3, 114, 1850, 8, 114, 1, 114, 1, 114, 3, 114, 1854, 8,
		114, 1, 114, 1, 114, 3, 114, 1858, 8, 114, 1, 114, 3, 114, 1861, 8, 114,
		1, 114, 1, 114, 3, 114, 1865, 8, 114, 1, 114, 1, 114, 3, 114, 1869, 8,
		114, 1, 115, 1, 115, 3, 115, 1873, 8, 115, 1, 115, 1, 115, 1, 115, 1, 115,
		1, 115, 1, 115, 1, 115, 1, 115, 1, 115, 1, 115, 1, 116, 1, 116, 3, 116,
		1887, 8, 116, 1, 116, 1, 116, 3, 116, 1891, 8, 116, 1, 116, 1, 116, 3,
		116, 1895, 8, 116, 1, 116, 1, 116, 1, 116, 1, 116, 3, 116, 1901, 8, 116,
		1, 116, 1, 116, 3, 116, 1905, 8, 116, 1, 116, 1, 116, 3, 116, 1909, 8,
		116, 1, 116, 1, 116, 1, 116, 1, 116, 3, 116, 1915, 8, 116, 1, 116, 1, 116,
		3, 116, 1919, 8, 116, 1, 116, 1, 116, 3, 116, 1923, 8, 116, 1, 116, 1,
		116, 1, 116, 1, 116, 3, 116, 1929, 8, 116, 1, 116, 1, 116, 3, 116, 1933,
		8, 116, 1, 116, 1, 116, 3, 116, 1937, 8, 116, 1, 116, 1, 116, 3, 116, 1941,
		8, 116, 1, 117, 1, 117, 3, 117, 1945, 8, 117, 1, 117, 3, 117, 1948, 8,
		117, 1, 118, 1, 118, 1, 119, 1, 119, 3, 119, 1954, 8, 119, 1, 119, 1, 119,
		3, 119, 1958, 8, 119, 1, 119, 1, 119, 1, 120, 1, 120, 1, 120, 1, 120, 1,
		120, 1, 120, 1, 121, 1, 121, 3, 121, 1970, 8, 121, 1, 121, 1, 121, 3, 121,
		1974, 8, 121, 1, 121, 1, 121, 3, 121, 1978, 8, 121, 3, 121, 1980, 8, 121,
		1, 121, 1, 121, 3, 121, 1984, 8, 121, 1, 121, 1, 121, 3, 121, 1988, 8,
		121, 1, 121, 1, 121, 3, 121, 1992, 8, 121, 5, 121, 1994, 8, 121, 10, 121,
		12, 121, 1997, 9, 121, 3, 121, 1999, 8, 121, 1, 121, 1, 121, 1, 122, 1,
		122, 1, 122, 1, 123, 1, 123, 3, 123, 2008, 8, 123, 1, 123, 1, 123, 3, 123,
		2012, 8, 123, 1, 123, 1, 123, 1, 123, 3, 123, 2017, 8, 123, 1, 123, 3,
		123, 2020, 8, 123, 3, 123, 2022, 8, 123, 1, 123, 3, 123, 2025, 8, 123,
		1, 123, 1, 123, 1, 124, 1, 124, 3, 124, 2031, 8, 124, 1, 124, 1, 124, 3,
		124, 2035, 8, 124, 1, 124, 1, 124, 3, 124, 2039, 8, 124, 1, 124, 1, 124,
		3, 124, 2043, 8, 124, 1, 124, 1, 124, 3, 124, 2047, 8, 124, 5, 124, 2049,
		8, 124, 10, 124, 12, 124, 2052, 9, 124, 3, 124, 2054, 8, 124, 1, 124, 1,
		124, 1, 125, 1, 125, 1, 126, 1, 126, 1, 127, 1, 127, 1, 127, 1, 128, 1,
		128, 1, 128, 5, 128, 2068, 8, 128, 10, 128, 12, 128, 2071, 9, 128, 1, 129,
		1, 129, 1, 130, 1, 130, 1, 130, 1, 130, 1, 130, 1, 130, 3, 130, 2081, 8,
		130, 1, 131, 1, 131, 1, 132, 1, 132, 3, 132, 2087, 8, 132, 1, 133, 1, 133,
		1, 134, 1, 134, 1, 135, 1, 135, 3, 135, 2095, 8, 135, 1, 135, 1, 135, 3,
		135, 2099, 8, 135, 1, 135, 1, 135, 3, 135, 2103, 8, 135, 1, 135, 1, 135,
		3, 135, 2107, 8, 135, 5, 135, 2109, 8, 135, 10, 135, 12, 135, 2112, 9,
		135, 3, 135, 2114, 8, 135, 1, 135, 1, 135, 1, 136, 1, 136, 3, 136, 2120,
		8, 136, 1, 136, 1, 136, 3, 136, 2124, 8, 136, 1, 136, 1, 136, 3, 136, 2128,
		8, 136, 1, 136, 1, 136, 3, 136, 2132, 8, 136, 1, 136, 1, 136, 3, 136, 2136,
		8, 136, 1, 136, 1, 136, 3, 136, 2140, 8, 136, 1, 136, 1, 136, 3, 136, 2144,
		8, 136, 1, 136, 1, 136, 3, 136, 2148, 8, 136, 5, 136, 2150, 8, 136, 10,
		136, 12, 136, 2153, 9, 136, 3, 136, 2155, 8, 136, 1, 136, 1, 136, 1, 137,
		1, 137, 1, 138, 1, 138, 3, 138, 2163, 8, 138, 1, 138, 1, 138, 3, 138, 2167,
		8, 138, 1, 138, 3, 138, 2170, 8, 138, 1, 138, 1, 138, 1, 139, 1, 139, 1,
		139, 3, 139, 2177, 8, 139, 1, 140, 1, 140, 3, 140, 2181, 8, 140, 1, 141,
		1, 141, 1, 142, 1, 142, 1, 143, 1, 143, 1, 144, 1, 144, 1, 145, 1, 145,
		1, 145, 0, 0, 146, 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28,
		30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64,
		66, 68, 70, 72, 74, 76, 78, 80, 82, 84, 86, 88, 90, 92, 94, 96, 98, 100,
		102, 104, 106, 108, 110, 112, 114, 116, 118, 120, 122, 124, 126, 128, 130,
		132, 134, 136, 138, 140, 142, 144, 146, 148, 150, 152, 154, 156, 158, 160,
		162, 164, 166, 168, 170, 172, 174, 176, 178, 180, 182, 184, 186, 188, 190,
		192, 194, 196, 198, 200, 202, 204, 206, 208, 210, 212, 214, 216, 218, 220,
		222, 224, 226, 228, 230, 232, 234, 236, 238, 240, 242, 244, 246, 248, 250,
		252, 254, 256, 258, 260, 262, 264, 266, 268, 270, 272, 274, 276, 278, 280,
		282, 284, 286, 288, 290, 0, 11, 1, 0, 89, 92, 1, 0, 97, 98, 1, 0, 19, 20,
		1, 0, 122, 123, 1, 0, 124, 126, 1, 0, 134, 135, 13, 0, 53, 56, 58, 59,
		61, 63, 66, 66, 69, 69, 71, 78, 80, 80, 83, 92, 99, 99, 102, 109, 111,
		115, 122, 123, 138, 144, 6, 0, 110, 110, 116, 117, 119, 121, 127, 127,
		145, 145, 148, 148, 2, 0, 14, 14, 28, 31, 2, 0, 15, 15, 32, 35, 2, 0, 20,
		20, 36, 46, 2465, 0, 293, 1, 0, 0, 0, 2, 314, 1, 0, 0, 0, 4, 320, 1, 0,
		0, 0, 6, 322, 1, 0, 0, 0, 8, 334, 1, 0, 0, 0, 10, 336, 1, 0, 0, 0, 12,
		338, 1, 0, 0, 0, 14, 340, 1, 0, 0, 0, 16, 352, 1, 0, 0, 0, 18, 357, 1,
		0, 0, 0, 20, 359, 1, 0, 0, 0, 22, 369, 1, 0, 0, 0, 24, 375, 1, 0, 0, 0,
		26, 384, 1, 0, 0, 0, 28, 399, 1, 0, 0, 0, 30, 403, 1, 0, 0, 0, 32, 440,
		1, 0, 0, 0, 34, 464, 1, 0, 0, 0, 36, 477, 1, 0, 0, 0, 38, 484, 1, 0, 0,
		0, 40, 494, 1, 0, 0, 0, 42, 496, 1, 0, 0, 0, 44, 500, 1, 0, 0, 0, 46, 504,
		1, 0, 0, 0, 48, 508, 1, 0, 0, 0, 50, 512, 1, 0, 0, 0, 52, 516, 1, 0, 0,
		0, 54, 520, 1, 0, 0, 0, 56, 524, 1, 0, 0, 0, 58, 528, 1, 0, 0, 0, 60, 539,
		1, 0, 0, 0, 62, 560, 1, 0, 0, 0, 64, 583, 1, 0, 0, 0, 66, 656, 1, 0, 0,
		0, 68, 658, 1, 0, 0, 0, 70, 683, 1, 0, 0, 0, 72, 702, 1, 0, 0, 0, 74, 712,
		1, 0, 0, 0, 76, 734, 1, 0, 0, 0, 78, 736, 1, 0, 0, 0, 80, 742, 1, 0, 0,
		0, 82, 750, 1, 0, 0, 0, 84, 804, 1, 0, 0, 0, 86, 808, 1, 0, 0, 0, 88, 828,
		1, 0, 0, 0, 90, 848, 1, 0, 0, 0, 92, 850, 1, 0, 0, 0, 94, 878, 1, 0, 0,
		0, 96, 889, 1, 0, 0, 0, 98, 906, 1, 0, 0, 0, 100, 931, 1, 0, 0, 0, 102,
		935, 1, 0, 0, 0, 104, 943, 1, 0, 0, 0, 106, 950, 1, 0, 0, 0, 108, 994,
		1, 0, 0, 0, 110, 1003, 1, 0, 0, 0, 112, 1005, 1, 0, 0, 0, 114, 1020, 1,
		0, 0, 0, 116, 1024, 1, 0, 0, 0, 118, 1028, 1, 0, 0, 0, 120, 1036, 1, 0,
		0, 0, 122, 1077, 1, 0, 0, 0, 124, 1096, 1, 0, 0, 0, 126, 1108, 1, 0, 0,
		0, 128, 1110, 1, 0, 0, 0, 130, 1119, 1, 0, 0, 0, 132, 1125, 1, 0, 0, 0,
		134, 1136, 1, 0, 0, 0, 136, 1145, 1, 0, 0, 0, 138, 1153, 1, 0, 0, 0, 140,
		1167, 1, 0, 0, 0, 142, 1171, 1, 0, 0, 0, 144, 1196, 1, 0, 0, 0, 146, 1200,
		1, 0, 0, 0, 148, 1212, 1, 0, 0, 0, 150, 1228, 1, 0, 0, 0, 152, 1230, 1,
		0, 0, 0, 154, 1239, 1, 0, 0, 0, 156, 1263, 1, 0, 0, 0, 158, 1333, 1, 0,
		0, 0, 160, 1335, 1, 0, 0, 0, 162, 1365, 1, 0, 0, 0, 164, 1367, 1, 0, 0,
		0, 166, 1373, 1, 0, 0, 0, 168, 1394, 1, 0, 0, 0, 170, 1404, 1, 0, 0, 0,
		172, 1410, 1, 0, 0, 0, 174, 1432, 1, 0, 0, 0, 176, 1434, 1, 0, 0, 0, 178,
		1436, 1, 0, 0, 0, 180, 1445, 1, 0, 0, 0, 182, 1447, 1, 0, 0, 0, 184, 1457,
		1, 0, 0, 0, 186, 1467, 1, 0, 0, 0, 188, 1483, 1, 0, 0, 0, 190, 1488, 1,
		0, 0, 0, 192, 1528, 1, 0, 0, 0, 194, 1530, 1, 0, 0, 0, 196, 1550, 1, 0,
		0, 0, 198, 1557, 1, 0, 0, 0, 200, 1574, 1, 0, 0, 0, 202, 1577, 1, 0, 0,
		0, 204, 1581, 1, 0, 0, 0, 206, 1603, 1, 0, 0, 0, 208, 1633, 1, 0, 0, 0,
		210, 1653, 1, 0, 0, 0, 212, 1655, 1, 0, 0, 0, 214, 1688, 1, 0, 0, 0, 216,
		1690, 1, 0, 0, 0, 218, 1724, 1, 0, 0, 0, 220, 1748, 1, 0, 0, 0, 222, 1765,
		1, 0, 0, 0, 224, 1779, 1, 0, 0, 0, 226, 1799, 1, 0, 0, 0, 228, 1868, 1,
		0, 0, 0, 230, 1870, 1, 0, 0, 0, 232, 1940, 1, 0, 0, 0, 234, 1942, 1, 0,
		0, 0, 236, 1949, 1, 0, 0, 0, 238, 1951, 1, 0, 0, 0, 240, 1961, 1, 0, 0,
		0, 242, 1967, 1, 0, 0, 0, 244, 2002, 1, 0, 0, 0, 246, 2005, 1, 0, 0, 0,
		248, 2028, 1, 0, 0, 0, 250, 2057, 1, 0, 0, 0, 252, 2059, 1, 0, 0, 0, 254,
		2061, 1, 0, 0, 0, 256, 2069, 1, 0, 0, 0, 258, 2072, 1, 0, 0, 0, 260, 2080,
		1, 0, 0, 0, 262, 2082, 1, 0, 0, 0, 264, 2086, 1, 0, 0, 0, 266, 2088, 1,
		0, 0, 0, 268, 2090, 1, 0, 0, 0, 270, 2092, 1, 0, 0, 0, 272, 2117, 1, 0,
		0, 0, 274, 2158, 1, 0, 0, 0, 276, 2160, 1, 0, 0, 0, 278, 2173, 1, 0, 0,
		0, 280, 2180, 1, 0, 0, 0, 282, 2182, 1, 0, 0, 0, 284, 2184, 1, 0, 0, 0,
		286, 2186, 1, 0, 0, 0, 288, 2188, 1, 0, 0, 0, 290, 2190, 1, 0, 0, 0, 292,
		294, 5, 149, 0, 0, 293, 292, 1, 0, 0, 0, 293, 294, 1, 0, 0, 0, 294, 295,
		1, 0, 0, 0, 295, 296, 3, 2, 1, 0, 296, 301, 3, 16, 8, 0, 297, 299, 5, 149,
		0, 0, 298, 297, 1, 0, 0, 0, 298, 299, 1, 0, 0, 0, 299, 300, 1, 0, 0, 0,
		300, 302, 5, 1, 0, 0, 301, 298, 1, 0, 0, 0, 301, 302, 1, 0, 0, 0, 302,
		304, 1, 0, 0, 0, 303, 305, 5, 149, 0, 0, 304, 303, 1, 0, 0, 0, 304, 305,
		1, 0, 0, 0, 305, 306, 1, 0, 0, 0, 306, 307, 5, 0, 0, 1, 307, 1, 1, 0, 0,
		0, 308, 310, 3, 4, 2, 0, 309, 311, 5, 149, 0, 0, 310, 309, 1, 0, 0, 0,
		310, 311, 1, 0, 0, 0, 311, 313, 1, 0, 0, 0, 312, 308, 1, 0, 0, 0, 313,
		316, 1, 0, 0, 0, 314, 312, 1, 0, 0, 0, 314, 315, 1, 0, 0, 0, 315, 3, 1,
		0, 0, 0, 316, 314, 1, 0, 0, 0, 317, 321, 3, 6, 3, 0, 318, 321, 3, 10, 5,
		0, 319, 321, 3, 12, 6, 0, 320, 317, 1, 0, 0, 0, 320, 318, 1, 0, 0, 0, 320,
		319, 1, 0, 0, 0, 321, 5, 1, 0, 0, 0, 322, 325, 5, 47, 0, 0, 323, 324, 5,
		149, 0, 0, 324, 326, 3, 8, 4, 0, 325, 323, 1, 0, 0, 0, 325, 326, 1, 0,
		0, 0, 326, 331, 1, 0, 0, 0, 327, 328, 5, 149, 0, 0, 328, 330, 3, 14, 7,
		0, 329, 327, 1, 0, 0, 0, 330, 333, 1, 0, 0, 0, 331, 329, 1, 0, 0, 0, 331,
		332, 1, 0, 0, 0, 332, 7, 1, 0, 0, 0, 333, 331, 1, 0, 0, 0, 334, 335, 5,
		135, 0, 0, 335, 9, 1, 0, 0, 0, 336, 337, 5, 48, 0, 0, 337, 11, 1, 0, 0,
		0, 338, 339, 5, 49, 0, 0, 339, 13, 1, 0, 0, 0, 340, 342, 3, 284, 142, 0,
		341, 343, 5, 149, 0, 0, 342, 341, 1, 0, 0, 0, 342, 343, 1, 0, 0, 0, 343,
		344, 1, 0, 0, 0, 344, 346, 5, 2, 0, 0, 345, 347, 5, 149, 0, 0, 346, 345,
		1, 0, 0, 0, 346, 347, 1, 0, 0, 0, 347, 348, 1, 0, 0, 0, 348, 349, 3, 284,
		142, 0, 349, 15, 1, 0, 0, 0, 350, 353, 3, 40, 20, 0, 351, 353, 3, 18, 9,
		0, 352, 350, 1, 0, 0, 0, 352, 351, 1, 0, 0, 0, 353, 17, 1, 0, 0, 0, 354,
		358, 3, 20, 10, 0, 355, 358, 3, 96, 48, 0, 356, 358, 3, 22, 11, 0, 357,
		354, 1, 0, 0, 0, 357, 355, 1, 0, 0, 0, 357, 356, 1, 0, 0, 0, 358, 19, 1,
		0, 0, 0, 359, 366, 3, 30, 15, 0, 360, 362, 5, 149, 0, 0, 361, 360, 1, 0,
		0, 0, 361, 362, 1, 0, 0, 0, 362, 363, 1, 0, 0, 0, 363, 365, 3, 28, 14,
		0, 364, 361, 1, 0, 0, 0, 365, 368, 1, 0, 0, 0, 366, 364, 1, 0, 0, 0, 366,
		367, 1, 0, 0, 0, 367, 21, 1, 0, 0, 0, 368, 366, 1, 0, 0, 0, 369, 371, 3,
		24, 12, 0, 370, 372, 5, 149, 0, 0, 371, 370, 1, 0, 0, 0, 371, 372, 1, 0,
		0, 0, 372, 373, 1, 0, 0, 0, 373, 374, 3, 26, 13, 0, 374, 23, 1, 0, 0, 0,
		375, 376, 5, 50, 0, 0, 376, 377, 5, 149, 0, 0, 377, 378, 5, 51, 0, 0, 378,
		379, 5, 149, 0, 0, 379, 382, 5, 52, 0, 0, 380, 381, 5, 149, 0, 0, 381,
		383, 3, 266, 133, 0, 382, 380, 1, 0, 0, 0, 382, 383, 1, 0, 0, 0, 383, 25,
		1, 0, 0, 0, 384, 385, 3, 68, 34, 0, 385, 386, 3, 30, 15, 0, 386, 27, 1,
		0, 0, 0, 387, 388, 5, 53, 0, 0, 388, 389, 5, 149, 0, 0, 389, 391, 5, 54,
		0, 0, 390, 392, 5, 149, 0, 0, 391, 390, 1, 0, 0, 0, 391, 392, 1, 0, 0,
		0, 392, 393, 1, 0, 0, 0, 393, 400, 3, 30, 15, 0, 394, 396, 5, 53, 0, 0,
		395, 397, 5, 149, 0, 0, 396, 395, 1, 0, 0, 0, 396, 397, 1, 0, 0, 0, 397,
		398, 1, 0, 0, 0, 398, 400, 3, 30, 15, 0, 399, 387, 1, 0, 0, 0, 399, 394,
		1, 0, 0, 0, 400, 29, 1, 0, 0, 0, 401, 404, 3, 32, 16, 0, 402, 404, 3, 34,
		17, 0, 403, 401, 1, 0, 0, 0, 403, 402, 1, 0, 0, 0, 404, 31, 1, 0, 0, 0,
		405, 407, 3, 38, 19, 0, 406, 408, 5, 149, 0, 0, 407, 406, 1, 0, 0, 0, 407,
		408, 1, 0, 0, 0, 408, 410, 1, 0, 0, 0, 409, 405, 1, 0, 0, 0, 410, 413,
		1, 0, 0, 0, 411, 409, 1, 0, 0, 0, 411, 412, 1, 0, 0, 0, 412, 414, 1, 0,
		0, 0, 413, 411, 1, 0, 0, 0, 414, 441, 3, 104, 52, 0, 415, 417, 3, 38, 19,
		0, 416, 418, 5, 149, 0, 0, 417, 416, 1, 0, 0, 0, 417, 418, 1, 0, 0, 0,
		418, 420, 1, 0, 0, 0, 419, 415, 1, 0, 0, 0, 420, 423, 1, 0, 0, 0, 421,
		419, 1, 0, 0, 0, 421, 422, 1, 0, 0, 0, 422, 424, 1, 0, 0, 0, 423, 421,
		1, 0, 0, 0, 424, 431, 3, 36, 18, 0, 425, 427, 5, 149, 0, 0, 426, 425, 1,
		0, 0, 0, 426, 427, 1, 0, 0, 0, 427, 428, 1, 0, 0, 0, 428, 430, 3, 36, 18,
		0, 429, 426, 1, 0, 0, 0, 430, 433, 1, 0, 0, 0, 431, 429, 1, 0, 0, 0, 431,
		432, 1, 0, 0, 0, 432, 438, 1, 0, 0, 0, 433, 431, 1, 0, 0, 0, 434, 436,
		5, 149, 0, 0, 435, 434, 1, 0, 0, 0, 435, 436, 1, 0, 0, 0, 436, 437, 1,
		0, 0, 0, 437, 439, 3, 104, 52, 0, 438, 435, 1, 0, 0, 0, 438, 439, 1, 0,
		0, 0, 439, 441, 1, 0, 0, 0, 440, 411, 1, 0, 0, 0, 440, 421, 1, 0, 0, 0,
		441, 33, 1, 0, 0, 0, 442, 444, 3, 38, 19, 0, 443, 445, 5, 149, 0, 0, 444,
		443, 1, 0, 0, 0, 444, 445, 1, 0, 0, 0, 445, 447, 1, 0, 0, 0, 446, 442,
		1, 0, 0, 0, 447, 450, 1, 0, 0, 0, 448, 446, 1, 0, 0, 0, 448, 449, 1, 0,
		0, 0, 449, 457, 1, 0, 0, 0, 450, 448, 1, 0, 0, 0, 451, 453, 3, 36, 18,
		0, 452, 454, 5, 149, 0, 0, 453, 452, 1, 0, 0, 0, 453, 454, 1, 0, 0, 0,
		454, 456, 1, 0, 0, 0, 455, 451, 1, 0, 0, 0, 456, 459, 1, 0, 0, 0, 457,
		455, 1, 0, 0, 0, 457, 458, 1, 0, 0, 0, 458, 460, 1, 0, 0, 0, 459, 457,
		1, 0, 0, 0, 460, 462, 3, 102, 51, 0, 461, 463, 5, 149, 0, 0, 462, 461,
		1, 0, 0, 0, 462, 463, 1, 0, 0, 0, 463, 465, 1, 0, 0, 0, 464, 448, 1, 0,
		0, 0, 465, 466, 1, 0, 0, 0, 466, 464, 1, 0, 0, 0, 466, 467, 1, 0, 0, 0,
		467, 468, 1, 0, 0, 0, 468, 469, 3, 32, 16, 0, 469, 35, 1, 0, 0, 0, 470,
		478, 3, 78, 39, 0, 471, 478, 3, 74, 37, 0, 472, 478, 3, 80, 40, 0, 473,
		478, 3, 92, 46, 0, 474, 478, 3, 86, 43, 0, 475, 478, 3, 82, 41, 0, 476,
		478, 3, 88, 44, 0, 477, 470, 1, 0, 0, 0, 477, 471, 1, 0, 0, 0, 477, 472,
		1, 0, 0, 0, 477, 473, 1, 0, 0, 0, 477, 474, 1, 0, 0, 0, 477, 475, 1, 0,
		0, 0, 477, 476, 1, 0, 0, 0, 478, 37, 1, 0, 0, 0, 479, 485, 3, 68, 34, 0,
		480, 485, 3, 122, 61, 0, 481, 485, 3, 70, 35, 0, 482, 485, 3, 72, 36, 0,
		483, 485, 3, 94, 47, 0, 484, 479, 1, 0, 0, 0, 484, 480, 1, 0, 0, 0, 484,
		481, 1, 0, 0, 0, 484, 482, 1, 0, 0, 0, 484, 483, 1, 0, 0, 0, 485, 39, 1,
		0, 0, 0, 486, 495, 3, 48, 24, 0, 487, 495, 3, 56, 28, 0, 488, 495, 3, 42,
		21, 0, 489, 495, 3, 50, 25, 0, 490, 495, 3, 44, 22, 0, 491, 495, 3, 52,
		26, 0, 492, 495, 3, 46, 23, 0, 493, 495, 3, 54, 27, 0, 494, 486, 1, 0,
		0, 0, 494, 487, 1, 0, 0, 0, 494, 488, 1, 0, 0, 0, 494, 489, 1, 0, 0, 0,
		494, 490, 1, 0, 0, 0, 494, 491, 1, 0, 0, 0, 494, 492, 1, 0, 0, 0, 494,
		493, 1, 0, 0, 0, 495, 41, 1, 0, 0, 0, 496, 497, 5, 55, 0, 0, 497, 498,
		5, 149, 0, 0, 498, 499, 3, 60, 30, 0, 499, 43, 1, 0, 0, 0, 500, 501, 5,
		55, 0, 0, 501, 502, 5, 149, 0, 0, 502, 503, 3, 62, 31, 0, 503, 45, 1, 0,
		0, 0, 504, 505, 5, 55, 0, 0, 505, 506, 5, 149, 0, 0, 506, 507, 3, 64, 32,
		0, 507, 47, 1, 0, 0, 0, 508, 509, 5, 55, 0, 0, 509, 510, 5, 149, 0, 0,
		510, 511, 3, 58, 29, 0, 511, 49, 1, 0, 0, 0, 512, 513, 5, 56, 0, 0, 513,
		514, 5, 149, 0, 0, 514, 515, 3, 60, 30, 0, 515, 51, 1, 0, 0, 0, 516, 517,
		5, 56, 0, 0, 517, 518, 5, 149, 0, 0, 518, 519, 3, 62, 31, 0, 519, 53, 1,
		0, 0, 0, 520, 521, 5, 56, 0, 0, 521, 522, 5, 149, 0, 0, 522, 523, 3, 64,
		32, 0, 523, 55, 1, 0, 0, 0, 524, 525, 5, 56, 0, 0, 525, 526, 5, 149, 0,
		0, 526, 527, 3, 58, 29, 0, 527, 57, 1, 0, 0, 0, 528, 529, 5, 57, 0, 0,
		529, 530, 5, 149, 0, 0, 530, 532, 5, 58, 0, 0, 531, 533, 5, 149, 0, 0,
		532, 531, 1, 0, 0, 0, 532, 533, 1, 0, 0, 0, 533, 534, 1, 0, 0, 0, 534,
		535, 3, 170, 85, 0, 535, 536, 5, 3, 0, 0, 536, 537, 3, 274, 137, 0, 537,
		538, 5, 4, 0, 0, 538, 59, 1, 0, 0, 0, 539, 540, 5, 59, 0, 0, 540, 541,
		5, 149, 0, 0, 541, 543, 5, 58, 0, 0, 542, 544, 5, 149, 0, 0, 543, 542,
		1, 0, 0, 0, 543, 544, 1, 0, 0, 0, 544, 545, 1, 0, 0, 0, 545, 546, 5, 3,
		0, 0, 546, 547, 3, 258, 129, 0, 547, 548, 3, 170, 85, 0, 548, 550, 5, 4,
		0, 0, 549, 551, 5, 149, 0, 0, 550, 549, 1, 0, 0, 0, 550, 551, 1, 0, 0,
		0, 551, 552, 1, 0, 0, 0, 552, 553, 5, 60, 0, 0, 553, 554, 5, 149, 0, 0,
		554, 555, 3, 178, 89, 0, 555, 556, 5, 149, 0, 0, 556, 557, 5, 61, 0, 0,
		557, 558, 5, 149, 0, 0, 558, 559, 5, 62, 0, 0, 559, 61, 1, 0, 0, 0, 560,
		561, 5, 59, 0, 0, 561, 562, 5, 149, 0, 0, 562, 564, 5, 58, 0, 0, 563, 565,
		5, 149, 0, 0, 564, 563, 1, 0, 0, 0, 564, 565, 1, 0, 0, 0, 565, 566, 1,
		0, 0, 0, 566, 567, 5, 3, 0, 0, 567, 568, 3, 258, 129, 0, 568, 569, 3, 170,
		85, 0, 569, 571, 5, 4, 0, 0, 570, 572, 5, 149, 0, 0, 571, 570, 1, 0, 0,
		0, 571, 572, 1, 0, 0, 0, 572, 573, 1, 0, 0, 0, 573, 574, 5, 60, 0, 0, 574,
		575, 5, 149, 0, 0, 575, 577, 5, 63, 0, 0, 576, 578, 5, 149, 0, 0, 577,
		576, 1, 0, 0, 0, 577, 578, 1, 0, 0, 0, 578, 579, 1, 0, 0, 0, 579, 580,
		5, 3, 0, 0, 580, 581, 3, 178, 89, 0, 581, 582, 5, 4, 0, 0, 582, 63, 1,
		0, 0, 0, 583, 584, 5, 59, 0, 0, 584, 585, 5, 149, 0, 0, 585, 587, 5, 58,
		0, 0, 586, 588, 5, 149, 0, 0, 587, 586, 1, 0, 0, 0, 587, 588, 1, 0, 0,
		0, 588, 589, 1, 0, 0, 0, 589, 591, 3, 66, 33, 0, 590, 592, 5, 149, 0, 0,
		591, 590, 1, 0, 0, 0, 591, 592, 1, 0, 0, 0, 592, 593, 1, 0, 0, 0, 593,
		594, 5, 60, 0, 0, 594, 595, 5, 149, 0, 0, 595, 597, 5, 63, 0, 0, 596, 598,
		5, 149, 0, 0, 597, 596, 1, 0, 0, 0, 597, 598, 1, 0, 0, 0, 598, 599, 1,
		0, 0, 0, 599, 600, 5, 3, 0, 0, 600, 601, 3, 178, 89, 0, 601, 602, 5, 4,
		0, 0, 602, 65, 1, 0, 0, 0, 603, 605, 5, 3, 0, 0, 604, 606, 5, 149, 0, 0,
		605, 604, 1, 0, 0, 0, 605, 606, 1, 0, 0, 0, 606, 607, 1, 0, 0, 0, 607,
		608, 5, 4, 0, 0, 608, 609, 3, 290, 145, 0, 609, 610, 5, 5, 0, 0, 610, 611,
		3, 258, 129, 0, 611, 612, 3, 164, 82, 0, 612, 613, 5, 6, 0, 0, 613, 614,
		3, 290, 145, 0, 614, 616, 5, 3, 0, 0, 615, 617, 5, 149, 0, 0, 616, 615,
		1, 0, 0, 0, 616, 617, 1, 0, 0, 0, 617, 618, 1, 0, 0, 0, 618, 619, 5, 4,
		0, 0, 619, 657, 1, 0, 0, 0, 620, 622, 5, 3, 0, 0, 621, 623, 5, 149, 0,
		0, 622, 621, 1, 0, 0, 0, 622, 623, 1, 0, 0, 0, 623, 624, 1, 0, 0, 0, 624,
		625, 5, 4, 0, 0, 625, 626, 3, 290, 145, 0, 626, 627, 5, 5, 0, 0, 627, 628,
		3, 258, 129, 0, 628, 629, 3, 164, 82, 0, 629, 630, 5, 6, 0, 0, 630, 631,
		3, 290, 145, 0, 631, 632, 3, 288, 144, 0, 632, 634, 5, 3, 0, 0, 633, 635,
		5, 149, 0, 0, 634, 633, 1, 0, 0, 0, 634, 635, 1, 0, 0, 0, 635, 636, 1,
		0, 0, 0, 636, 637, 5, 4, 0, 0, 637, 657, 1, 0, 0, 0, 638, 640, 5, 3, 0,
		0, 639, 641, 5, 149, 0, 0, 640, 639, 1, 0, 0, 0, 640, 641, 1, 0, 0, 0,
		641, 642, 1, 0, 0, 0, 642, 643, 5, 4, 0, 0, 643, 644, 3, 286, 143, 0, 644,
		645, 3, 290, 145, 0, 645, 646, 5, 5, 0, 0, 646, 647, 3, 258, 129, 0, 647,
		648, 3, 164, 82, 0, 648, 649, 5, 6, 0, 0, 649, 650, 3, 290, 145, 0, 650,
		652, 5, 3, 0, 0, 651, 653, 5, 149, 0, 0, 652, 651, 1, 0, 0, 0, 652, 653,
		1, 0, 0, 0, 653, 654, 1, 0, 0, 0, 654, 655, 5, 4, 0, 0, 655, 657, 1, 0,
		0, 0, 656, 603, 1, 0, 0, 0, 656, 620, 1, 0, 0, 0, 656, 638, 1, 0, 0, 0,
		657, 67, 1, 0, 0, 0, 658, 659, 5, 64, 0, 0, 659, 660, 5, 149, 0, 0, 660,
		661, 5, 65, 0, 0, 661, 666, 5, 149, 0, 0, 662, 663, 5, 66, 0, 0, 663, 664,
		5, 149, 0, 0, 664, 665, 5, 67, 0, 0, 665, 667, 5, 149, 0, 0, 666, 662,
		1, 0, 0, 0, 666, 667, 1, 0, 0, 0, 667, 668, 1, 0, 0, 0, 668, 669, 5, 68,
		0, 0, 669, 670, 5, 149, 0, 0, 670, 671, 3, 180, 90, 0, 671, 672, 5, 149,
		0, 0, 672, 673, 5, 69, 0, 0, 673, 674, 5, 149, 0, 0, 674, 675, 3, 258,
		129, 0, 675, 679, 5, 149, 0, 0, 676, 677, 5, 70, 0, 0, 677, 678, 5, 149,
		0, 0, 678, 680, 5, 136, 0, 0, 679, 676, 1, 0, 0, 0, 679, 680, 1, 0, 0,
		0, 680, 69, 1, 0, 0, 0, 681, 682, 5, 71, 0, 0, 682, 684, 5, 149, 0, 0,
		683, 681, 1, 0, 0, 0, 683, 684, 1, 0, 0, 0, 684, 685, 1, 0, 0, 0, 685,
		687, 5, 72, 0, 0, 686, 688, 5, 149, 0, 0, 687, 686, 1, 0, 0, 0, 687, 688,
		1, 0, 0, 0, 688, 689, 1, 0, 0, 0, 689, 693, 3, 142, 71, 0, 690, 692, 3,
		120, 60, 0, 691, 690, 1, 0, 0, 0, 692, 695, 1, 0, 0, 0, 693, 691, 1, 0,
		0, 0, 693, 694, 1, 0, 0, 0, 694, 700, 1, 0, 0, 0, 695, 693, 1, 0, 0, 0,
		696, 698, 5, 149, 0, 0, 697, 696, 1, 0, 0, 0, 697, 698, 1, 0, 0, 0, 698,
		699, 1, 0, 0, 0, 699, 701, 3, 140, 70, 0, 700, 697, 1, 0, 0, 0, 700, 701,
		1, 0, 0, 0, 701, 71, 1, 0, 0, 0, 702, 704, 5, 73, 0, 0, 703, 705, 5, 149,
		0, 0, 704, 703, 1, 0, 0, 0, 704, 705, 1, 0, 0, 0, 705, 706, 1, 0, 0, 0,
		706, 707, 3, 180, 90, 0, 707, 708, 5, 149, 0, 0, 708, 709, 5, 69, 0, 0,
		709, 710, 5, 149, 0, 0, 710, 711, 3, 258, 129, 0, 711, 73, 1, 0, 0, 0,
		712, 714, 5, 74, 0, 0, 713, 715, 5, 149, 0, 0, 714, 713, 1, 0, 0, 0, 714,
		715, 1, 0, 0, 0, 715, 716, 1, 0, 0, 0, 716, 721, 3, 144, 72, 0, 717, 718,
		5, 149, 0, 0, 718, 720, 3, 76, 38, 0, 719, 717, 1, 0, 0, 0, 720, 723, 1,
		0, 0, 0, 721, 719, 1, 0, 0, 0, 721, 722, 1, 0, 0, 0, 722, 75, 1, 0, 0,
		0, 723, 721, 1, 0, 0, 0, 724, 725, 5, 58, 0, 0, 725, 726, 5, 149, 0, 0,
		726, 727, 5, 72, 0, 0, 727, 728, 5, 149, 0, 0, 728, 735, 3, 82, 41, 0,
		729, 730, 5, 58, 0, 0, 730, 731, 5, 149, 0, 0, 731, 732, 5, 55, 0, 0, 732,
		733, 5, 149, 0, 0, 733, 735, 3, 82, 41, 0, 734, 724, 1, 0, 0, 0, 734, 729,
		1, 0, 0, 0, 735, 77, 1, 0, 0, 0, 736, 738, 5, 55, 0, 0, 737, 739, 5, 149,
		0, 0, 738, 737, 1, 0, 0, 0, 738, 739, 1, 0, 0, 0, 739, 740, 1, 0, 0, 0,
		740, 741, 3, 142, 71, 0, 741, 79, 1, 0, 0, 0, 742, 743, 5, 55, 0, 0, 743,
		744, 5, 149, 0, 0, 744, 746, 5, 62, 0, 0, 745, 747, 5, 149, 0, 0, 746,
		745, 1, 0, 0, 0, 746, 747, 1, 0, 0, 0, 747, 748, 1, 0, 0, 0, 748, 749,
		3, 142, 71, 0, 749, 81, 1, 0, 0, 0, 750, 752, 5, 75, 0, 0, 751, 753, 5,
		149, 0, 0, 752, 751, 1, 0, 0, 0, 752, 753, 1, 0, 0, 0, 753, 754, 1, 0,
		0, 0, 754, 765, 3, 84, 42, 0, 755, 757, 5, 149, 0, 0, 756, 755, 1, 0, 0,
		0, 756, 757, 1, 0, 0, 0, 757, 758, 1, 0, 0, 0, 758, 760, 5, 7, 0, 0, 759,
		761, 5, 149, 0, 0, 760, 759, 1, 0, 0, 0, 760, 761, 1, 0, 0, 0, 761, 762,
		1, 0, 0, 0, 762, 764, 3, 84, 42, 0, 763, 756, 1, 0, 0, 0, 764, 767, 1,
		0, 0, 0, 765, 763, 1, 0, 0, 0, 765, 766, 1, 0, 0, 0, 766, 83, 1, 0, 0,
		0, 767, 765, 1, 0, 0, 0, 768, 770, 3, 178, 89, 0, 769, 771, 5, 149, 0,
		0, 770, 769, 1, 0, 0, 0, 770, 771, 1, 0, 0, 0, 771, 772, 1, 0, 0, 0, 772,
		774, 5, 2, 0, 0, 773, 775, 5, 149, 0, 0, 774, 773, 1, 0, 0, 0, 774, 775,
		1, 0, 0, 0, 775, 776, 1, 0, 0, 0, 776, 777, 3, 180, 90, 0, 777, 805, 1,
		0, 0, 0, 778, 780, 3, 258, 129, 0, 779, 781, 5, 149, 0, 0, 780, 779, 1,
		0, 0, 0, 780, 781, 1, 0, 0, 0, 781, 782, 1, 0, 0, 0, 782, 784, 5, 2, 0,
		0, 783, 785, 5, 149, 0, 0, 784, 783, 1, 0, 0, 0, 784, 785, 1, 0, 0, 0,
		785, 786, 1, 0, 0, 0, 786, 787, 3, 180, 90, 0, 787, 805, 1, 0, 0, 0, 788,
		790, 3, 258, 129, 0, 789, 791, 5, 149, 0, 0, 790, 789, 1, 0, 0, 0, 790,
		791, 1, 0, 0, 0, 791, 792, 1, 0, 0, 0, 792, 794, 5, 8, 0, 0, 793, 795,
		5, 149, 0, 0, 794, 793, 1, 0, 0, 0, 794, 795, 1, 0, 0, 0, 795, 796, 1,
		0, 0, 0, 796, 797, 3, 180, 90, 0, 797, 805, 1, 0, 0, 0, 798, 800, 3, 258,
		129, 0, 799, 801, 5, 149, 0, 0, 800, 799, 1, 0, 0, 0, 800, 801, 1, 0, 0,
		0, 801, 802, 1, 0, 0, 0, 802, 803, 3, 168, 84, 0, 803, 805, 1, 0, 0, 0,
		804, 768, 1, 0, 0, 0, 804, 778, 1, 0, 0, 0, 804, 788, 1, 0, 0, 0, 804,
		798, 1, 0, 0, 0, 805, 85, 1, 0, 0, 0, 806, 807, 5, 76, 0, 0, 807, 809,
		5, 149, 0, 0, 808, 806, 1, 0, 0, 0, 808, 809, 1, 0, 0, 0, 809, 810, 1,
		0, 0, 0, 810, 812, 5, 77, 0, 0, 811, 813, 5, 149, 0, 0, 812, 811, 1, 0,
		0, 0, 812, 813, 1, 0, 0, 0, 813, 814, 1, 0, 0, 0, 814, 825, 3, 180, 90,
		0, 815, 817, 5, 149, 0, 0, 816, 815, 1, 0, 0, 0, 816, 817, 1, 0, 0, 0,
		817, 818, 1, 0, 0, 0, 818, 820, 5, 7, 0, 0, 819, 821, 5, 149, 0, 0, 820,
		819, 1, 0, 0, 0, 820, 821, 1, 0, 0, 0, 821, 822, 1, 0, 0, 0, 822, 824,
		3, 180, 90, 0, 823, 816, 1, 0, 0, 0, 824, 827, 1, 0, 0, 0, 825, 823, 1,
		0, 0, 0, 825, 826, 1, 0, 0, 0, 826, 87, 1, 0, 0, 0, 827, 825, 1, 0, 0,
		0, 828, 829, 5, 78, 0, 0, 829, 830, 5, 149, 0, 0, 830, 841, 3, 90, 45,
		0, 831, 833, 5, 149, 0, 0, 832, 831, 1, 0, 0, 0, 832, 833, 1, 0, 0, 0,
		833, 834, 1, 0, 0, 0, 834, 836, 5, 7, 0, 0, 835, 837, 5, 149, 0, 0, 836,
		835, 1, 0, 0, 0, 836, 837, 1, 0, 0, 0, 837, 838, 1, 0, 0, 0, 838, 840,
		3, 90, 45, 0, 839, 832, 1, 0, 0, 0, 840, 843, 1, 0, 0, 0, 841, 839, 1,
		0, 0, 0, 841, 842, 1, 0, 0, 0, 842, 89, 1, 0, 0, 0, 843, 841, 1, 0, 0,
		0, 844, 845, 3, 258, 129, 0, 845, 846, 3, 168, 84, 0, 846, 849, 1, 0, 0,
		0, 847, 849, 3, 178, 89, 0, 848, 844, 1, 0, 0, 0, 848, 847, 1, 0, 0, 0,
		849, 91, 1, 0, 0, 0, 850, 852, 5, 79, 0, 0, 851, 853, 5, 149, 0, 0, 852,
		851, 1, 0, 0, 0, 852, 853, 1, 0, 0, 0, 853, 854, 1, 0, 0, 0, 854, 856,
		5, 3, 0, 0, 855, 857, 5, 149, 0, 0, 856, 855, 1, 0, 0, 0, 856, 857, 1,
		0, 0, 0, 857, 858, 1, 0, 0, 0, 858, 859, 3, 258, 129, 0, 859, 860, 5, 149,
		0, 0, 860, 861, 5, 80, 0, 0, 861, 862, 5, 149, 0, 0, 862, 864, 3, 180,
		90, 0, 863, 865, 5, 149, 0, 0, 864, 863, 1, 0, 0, 0, 864, 865, 1, 0, 0,
		0, 865, 866, 1, 0, 0, 0, 866, 869, 5, 9, 0, 0, 867, 868, 5, 149, 0, 0,
		868, 870, 3, 36, 18, 0, 869, 867, 1, 0, 0, 0, 870, 871, 1, 0, 0, 0, 871,
		869, 1, 0, 0, 0, 871, 872, 1, 0, 0, 0, 872, 874, 1, 0, 0, 0, 873, 875,
		5, 149, 0, 0, 874, 873, 1, 0, 0, 0, 874, 875, 1, 0, 0, 0, 875, 876, 1,
		0, 0, 0, 876, 877, 5, 4, 0, 0, 877, 93, 1, 0, 0, 0, 878, 879, 5, 81, 0,
		0, 879, 880, 5, 149, 0, 0, 880, 887, 3, 248, 124, 0, 881, 883, 5, 149,
		0, 0, 882, 881, 1, 0, 0, 0, 882, 883, 1, 0, 0, 0, 883, 884, 1, 0, 0, 0,
		884, 885, 5, 82, 0, 0, 885, 886, 5, 149, 0, 0, 886, 888, 3, 98, 49, 0,
		887, 882, 1, 0, 0, 0, 887, 888, 1, 0, 0, 0, 888, 95, 1, 0, 0, 0, 889, 890,
		5, 81, 0, 0, 890, 893, 5, 149, 0, 0, 891, 894, 3, 248, 124, 0, 892, 894,
		3, 250, 125, 0, 893, 891, 1, 0, 0, 0, 893, 892, 1, 0, 0, 0, 894, 904, 1,
		0, 0, 0, 895, 897, 5, 149, 0, 0, 896, 895, 1, 0, 0, 0, 896, 897, 1, 0,
		0, 0, 897, 898, 1, 0, 0, 0, 898, 899, 5, 82, 0, 0, 899, 902, 5, 149, 0,
		0, 900, 903, 5, 10, 0, 0, 901, 903, 3, 98, 49, 0, 902, 900, 1, 0, 0, 0,
		902, 901, 1, 0, 0, 0, 903, 905, 1, 0, 0, 0, 904, 896, 1, 0, 0, 0, 904,
		905, 1, 0, 0, 0, 905, 97, 1, 0, 0, 0, 906, 917, 3, 100, 50, 0, 907, 909,
		5, 149, 0, 0, 908, 907, 1, 0, 0, 0, 908, 909, 1, 0, 0, 0, 909, 910, 1,
		0, 0, 0, 910, 912, 5, 7, 0, 0, 911, 913, 5, 149, 0, 0, 912, 911, 1, 0,
		0, 0, 912, 913, 1, 0, 0, 0, 913, 914, 1, 0, 0, 0, 914, 916, 3, 100, 50,
		0, 915, 908, 1, 0, 0, 0, 916, 919, 1, 0, 0, 0, 917, 915, 1, 0, 0, 0, 917,
		918, 1, 0, 0, 0, 918, 924, 1, 0, 0, 0, 919, 917, 1, 0, 0, 0, 920, 922,
		5, 149, 0, 0, 921, 920, 1, 0, 0, 0, 921, 922, 1, 0, 0, 0, 922, 923, 1,
		0, 0, 0, 923, 925, 3, 140, 70, 0, 924, 921, 1, 0, 0, 0, 924, 925, 1, 0,
		0, 0, 925, 99, 1, 0, 0, 0, 926, 927, 3, 252, 126, 0, 927, 928, 5, 149,
		0, 0, 928, 929, 5, 69, 0, 0, 929, 930, 5, 149, 0, 0, 930, 932, 1, 0, 0,
		0, 931, 926, 1, 0, 0, 0, 931, 932, 1, 0, 0, 0, 932, 933, 1, 0, 0, 0, 933,
		934, 3, 258, 129, 0, 934, 101, 1, 0, 0, 0, 935, 936, 5, 66, 0, 0, 936,
		941, 3, 106, 53, 0, 937, 939, 5, 149, 0, 0, 938, 937, 1, 0, 0, 0, 938,
		939, 1, 0, 0, 0, 939, 940, 1, 0, 0, 0, 940, 942, 3, 140, 70, 0, 941, 938,
		1, 0, 0, 0, 941, 942, 1, 0, 0, 0, 942, 103, 1, 0, 0, 0, 943, 944, 5, 83,
		0, 0, 944, 945, 3, 106, 53, 0, 945, 105, 1, 0, 0, 0, 946, 948, 5, 149,
		0, 0, 947, 946, 1, 0, 0, 0, 947, 948, 1, 0, 0, 0, 948, 949, 1, 0, 0, 0,
		949, 951, 5, 84, 0, 0, 950, 947, 1, 0, 0, 0, 950, 951, 1, 0, 0, 0, 951,
		952, 1, 0, 0, 0, 952, 953, 5, 149, 0, 0, 953, 956, 3, 108, 54, 0, 954,
		955, 5, 149, 0, 0, 955, 957, 3, 112, 56, 0, 956, 954, 1, 0, 0, 0, 956,
		957, 1, 0, 0, 0, 957, 960, 1, 0, 0, 0, 958, 959, 5, 149, 0, 0, 959, 961,
		3, 114, 57, 0, 960, 958, 1, 0, 0, 0, 960, 961, 1, 0, 0, 0, 961, 964, 1,
		0, 0, 0, 962, 963, 5, 149, 0, 0, 963, 965, 3, 116, 58, 0, 964, 962, 1,
		0, 0, 0, 964, 965, 1, 0, 0, 0, 965, 107, 1, 0, 0, 0, 966, 977, 5, 10, 0,
		0, 967, 969, 5, 149, 0, 0, 968, 967, 1, 0, 0, 0, 968, 969, 1, 0, 0, 0,
		969, 970, 1, 0, 0, 0, 970, 972, 5, 7, 0, 0, 971, 973, 5, 149, 0, 0, 972,
		971, 1, 0, 0, 0, 972, 973, 1, 0, 0, 0, 973, 974, 1, 0, 0, 0, 974, 976,
		3, 110, 55, 0, 975, 968, 1, 0, 0, 0, 976, 979, 1, 0, 0, 0, 977, 975, 1,
		0, 0, 0, 977, 978, 1, 0, 0, 0, 978, 995, 1, 0, 0, 0, 979, 977, 1, 0, 0,
		0, 980, 991, 3, 110, 55, 0, 981, 983, 5, 149, 0, 0, 982, 981, 1, 0, 0,
		0, 982, 983, 1, 0, 0, 0, 983, 984, 1, 0, 0, 0, 984, 986, 5, 7, 0, 0, 985,
		987, 5, 149, 0, 0, 986, 985, 1, 0, 0, 0, 986, 987, 1, 0, 0, 0, 987, 988,
		1, 0, 0, 0, 988, 990, 3, 110, 55, 0, 989, 982, 1, 0, 0, 0, 990, 993, 1,
		0, 0, 0, 991, 989, 1, 0, 0, 0, 991, 992, 1, 0, 0, 0, 992, 995, 1, 0, 0,
		0, 993, 991, 1, 0, 0, 0, 994, 966, 1, 0, 0, 0, 994, 980, 1, 0, 0, 0, 995,
		109, 1, 0, 0, 0, 996, 997, 3, 180, 90, 0, 997, 998, 5, 149, 0, 0, 998,
		999, 5, 69, 0, 0, 999, 1000, 5, 149, 0, 0, 1000, 1001, 3, 258, 129, 0,
		1001, 1004, 1, 0, 0, 0, 1002, 1004, 3, 180, 90, 0, 1003, 996, 1, 0, 0,
		0, 1003, 1002, 1, 0, 0, 0, 1004, 111, 1, 0, 0, 0, 1005, 1006, 5, 85, 0,
		0, 1006, 1007, 5, 149, 0, 0, 1007, 1008, 5, 86, 0, 0, 1008, 1009, 5, 149,
		0, 0, 1009, 1017, 3, 118, 59, 0, 1010, 1012, 5, 7, 0, 0, 1011, 1013, 5,
		149, 0, 0, 1012, 1011, 1, 0, 0, 0, 1012, 1013, 1, 0, 0, 0, 1013, 1014,
		1, 0, 0, 0, 1014, 1016, 3, 118, 59, 0, 1015, 1010, 1, 0, 0, 0, 1016, 1019,
		1, 0, 0, 0, 1017, 1015, 1, 0, 0, 0, 1017, 1018, 1, 0, 0, 0, 1018, 113,
		1, 0, 0, 0, 1019, 1017, 1, 0, 0, 0, 1020, 1021, 5, 87, 0, 0, 1021, 1022,
		5, 149, 0, 0, 1022, 1023, 3, 180, 90, 0, 1023, 115, 1, 0, 0, 0, 1024, 1025,
		5, 88, 0, 0, 1025, 1026, 5, 149, 0, 0, 1026, 1027, 3, 180, 90, 0, 1027,
		117, 1, 0, 0, 0, 1028, 1033, 3, 180, 90, 0, 1029, 1031, 5, 149, 0, 0, 1030,
		1029, 1, 0, 0, 0, 1030, 1031, 1, 0, 0, 0, 1031, 1032, 1, 0, 0, 0, 1032,
		1034, 7, 0, 0, 0, 1033, 1030, 1, 0, 0, 0, 1033, 1034, 1, 0, 0, 0, 1034,
		119, 1, 0, 0, 0, 1035, 1037, 5, 149, 0, 0, 1036, 1035, 1, 0, 0, 0, 1036,
		1037, 1, 0, 0, 0, 1037, 1075, 1, 0, 0, 0, 1038, 1039, 5, 50, 0, 0, 1039,
		1040, 5, 149, 0, 0, 1040, 1041, 5, 57, 0, 0, 1041, 1042, 5, 149, 0, 0,
		1042, 1043, 3, 258, 129, 0, 1043, 1044, 3, 170, 85, 0, 1044, 1045, 5, 3,
		0, 0, 1045, 1046, 3, 274, 137, 0, 1046, 1047, 5, 4, 0, 0, 1047, 1076, 1,
		0, 0, 0, 1048, 1049, 5, 50, 0, 0, 1049, 1050, 5, 149, 0, 0, 1050, 1051,
		5, 93, 0, 0, 1051, 1052, 5, 149, 0, 0, 1052, 1053, 5, 58, 0, 0, 1053, 1054,
		5, 149, 0, 0, 1054, 1065, 3, 258, 129, 0, 1055, 1057, 5, 149, 0, 0, 1056,
		1055, 1, 0, 0, 0, 1056, 1057, 1, 0, 0, 0, 1057, 1058, 1, 0, 0, 0, 1058,
		1060, 5, 7, 0, 0, 1059, 1061, 5, 149, 0, 0, 1060, 1059, 1, 0, 0, 0, 1060,
		1061, 1, 0, 0, 0, 1061, 1062, 1, 0, 0, 0, 1062, 1064, 3, 258, 129, 0, 1063,
		1056, 1, 0, 0, 0, 1064, 1067, 1, 0, 0, 0, 1065, 1063, 1, 0, 0, 0, 1065,
		1066, 1, 0, 0, 0, 1066, 1076, 1, 0, 0, 0, 1067, 1065, 1, 0, 0, 0, 1068,
		1069, 5, 50, 0, 0, 1069, 1070, 5, 149, 0, 0, 1070, 1071, 5, 94, 0, 0, 1071,
		1072, 5, 149, 0, 0, 1072, 1073, 3, 258, 129, 0, 1073, 1074, 3, 170, 85,
		0, 1074, 1076, 1, 0, 0, 0, 1075, 1038, 1, 0, 0, 0, 1075, 1048, 1, 0, 0,
		0, 1075, 1068, 1, 0, 0, 0, 1076, 121, 1, 0, 0, 0, 1077, 1078, 5, 95, 0,
		0, 1078, 1079, 5, 149, 0, 0, 1079, 1090, 3, 124, 62, 0, 1080, 1082, 5,
		149, 0, 0, 1081, 1080, 1, 0, 0, 0, 1081, 1082, 1, 0, 0, 0, 1082, 1083,
		1, 0, 0, 0, 1083, 1085, 5, 7, 0, 0, 1084, 1086, 5, 149, 0, 0, 1085, 1084,
		1, 0, 0, 0, 1085, 1086, 1, 0, 0, 0, 1086, 1087, 1, 0, 0, 0, 1087, 1089,
		3, 124, 62, 0, 1088, 1081, 1, 0, 0, 0, 1089, 1092, 1, 0, 0, 0, 1090, 1088,
		1, 0, 0, 0, 1090, 1091, 1, 0, 0, 0, 1091, 1094, 1, 0, 0, 0, 1092, 1090,
		1, 0, 0, 0, 1093, 1095, 3, 140, 70, 0, 1094, 1093, 1, 0, 0, 0, 1094, 1095,
		1, 0, 0, 0, 1095, 123, 1, 0, 0, 0, 1096, 1098, 3, 258, 129, 0, 1097, 1099,
		5, 149, 0, 0, 1098, 1097, 1, 0, 0, 0, 1098, 1099, 1, 0, 0, 0, 1099, 1100,
		1, 0, 0, 0, 1100, 1102, 5, 2, 0, 0, 1101, 1103, 5, 149, 0, 0, 1102, 1101,
		1, 0, 0, 0, 1102, 1103, 1, 0, 0, 0, 1103, 1104, 1, 0, 0, 0, 1104, 1105,
		3, 126, 63, 0, 1105, 125, 1, 0, 0, 0, 1106, 1109, 3, 128, 64, 0, 1107,
		1109, 3, 130, 65, 0, 1108, 1106, 1, 0, 0, 0, 1108, 1107, 1, 0, 0, 0, 1109,
		127, 1, 0, 0, 0, 1110, 1112, 5, 96, 0, 0, 1111, 1113, 5, 149, 0, 0, 1112,
		1111, 1, 0, 0, 0, 1112, 1113, 1, 0, 0, 0, 1113, 1117, 1, 0, 0, 0, 1114,
		1118, 3, 132, 66, 0, 1115, 1118, 3, 134, 67, 0, 1116, 1118, 3, 136, 68,
		0, 1117, 1114, 1, 0, 0, 0, 1117, 1115, 1, 0, 0, 0, 1117, 1116, 1, 0, 0,
		0, 1118, 129, 1, 0, 0, 0, 1119, 1123, 7, 1, 0, 0, 1120, 1124, 3, 132, 66,
		0, 1121, 1124, 3, 134, 67, 0, 1122, 1124, 3, 136, 68, 0, 1123, 1120, 1,
		0, 0, 0, 1123, 1121, 1, 0, 0, 0, 1123, 1122, 1, 0, 0, 0, 1124, 131, 1,
		0, 0, 0, 1125, 1126, 5, 11, 0, 0, 1126, 1127, 3, 284, 142, 0, 1127, 1128,
		5, 3, 0, 0, 1128, 1129, 3, 284, 142, 0, 1129, 1132, 5, 2, 0, 0, 1130, 1133,
		5, 136, 0, 0, 1131, 1133, 3, 276, 138, 0, 1132, 1130, 1, 0, 0, 0, 1132,
		1131, 1, 0, 0, 0, 1133, 1134, 1, 0, 0, 0, 1134, 1135, 5, 4, 0, 0, 1135,
		133, 1, 0, 0, 0, 1136, 1137, 5, 11, 0, 0, 1137, 1138, 3, 284, 142, 0, 1138,
		1141, 5, 3, 0, 0, 1139, 1142, 5, 136, 0, 0, 1140, 1142, 3, 276, 138, 0,
		1141, 1139, 1, 0, 0, 0, 1141, 1140, 1, 0, 0, 0, 1142, 1143, 1, 0, 0, 0,
		1143, 1144, 5, 4, 0, 0, 1144, 135, 1, 0, 0, 0, 1145, 1149, 5, 3, 0, 0,
		1146, 1150, 3, 138, 69, 0, 1147, 1150, 3, 276, 138, 0, 1148, 1150, 5, 10,
		0, 0, 1149, 1146, 1, 0, 0, 0, 1149, 1147, 1, 0, 0, 0, 1149, 1148, 1, 0,
		0, 0, 1150, 1151, 1, 0, 0, 0, 1151, 1152, 5, 4, 0, 0, 1152, 137, 1, 0,
		0, 0, 1153, 1164, 3, 266, 133, 0, 1154, 1156, 5, 149, 0, 0, 1155, 1154,
		1, 0, 0, 0, 1155, 1156, 1, 0, 0, 0, 1156, 1157, 1, 0, 0, 0, 1157, 1159,
		5, 7, 0, 0, 1158, 1160, 5, 149, 0, 0, 1159, 1158, 1, 0, 0, 0, 1159, 1160,
		1, 0, 0, 0, 1160, 1161, 1, 0, 0, 0, 1161, 1163, 3, 266, 133, 0, 1162, 1155,
		1, 0, 0, 0, 1163, 1166, 1, 0, 0, 0, 1164, 1162, 1, 0, 0, 0, 1164, 1165,
		1, 0, 0, 0, 1165, 139, 1, 0, 0, 0, 1166, 1164, 1, 0, 0, 0, 1167, 1168,
		5, 99, 0, 0, 1168, 1169, 5, 149, 0, 0, 1169, 1170, 3, 180, 90, 0, 1170,
		141, 1, 0, 0, 0, 1171, 1182, 3, 144, 72, 0, 1172, 1174, 5, 149, 0, 0, 1173,
		1172, 1, 0, 0, 0, 1173, 1174, 1, 0, 0, 0, 1174, 1175, 1, 0, 0, 0, 1175,
		1177, 5, 7, 0, 0, 1176, 1178, 5, 149, 0, 0, 1177, 1176, 1, 0, 0, 0, 1177,
		1178, 1, 0, 0, 0, 1178, 1179, 1, 0, 0, 0, 1179, 1181, 3, 144, 72, 0, 1180,
		1173, 1, 0, 0, 0, 1181, 1184, 1, 0, 0, 0, 1182, 1180, 1, 0, 0, 0, 1182,
		1183, 1, 0, 0, 0, 1183, 143, 1, 0, 0, 0, 1184, 1182, 1, 0, 0, 0, 1185,
		1187, 3, 258, 129, 0, 1186, 1188, 5, 149, 0, 0, 1187, 1186, 1, 0, 0, 0,
		1187, 1188, 1, 0, 0, 0, 1188, 1189, 1, 0, 0, 0, 1189, 1191, 5, 2, 0, 0,
		1190, 1192, 5, 149, 0, 0, 1191, 1190, 1, 0, 0, 0, 1191, 1192, 1, 0, 0,
		0, 1192, 1193, 1, 0, 0, 0, 1193, 1194, 3, 146, 73, 0, 1194, 1197, 1, 0,
		0, 0, 1195, 1197, 3, 146, 73, 0, 1196, 1185, 1, 0, 0, 0, 1196, 1195, 1,
		0, 0, 0, 1197, 145, 1, 0, 0, 0, 1198, 1201, 3, 148, 74, 0, 1199, 1201,
		3, 150, 75, 0, 1200, 1198, 1, 0, 0, 0, 1200, 1199, 1, 0, 0, 0, 1201, 147,
		1, 0, 0, 0, 1202, 1203, 5, 100, 0, 0, 1203, 1204, 5, 3, 0, 0, 1204, 1205,
		3, 150, 75, 0, 1205, 1206, 5, 4, 0, 0, 1206, 1213, 1, 0, 0, 0, 1207, 1208,
		5, 101, 0, 0, 1208, 1209, 5, 3, 0, 0, 1209, 1210, 3, 150, 75, 0, 1210,
		1211, 5, 4, 0, 0, 1211, 1213, 1, 0, 0, 0, 1212, 1202, 1, 0, 0, 0, 1212,
		1207, 1, 0, 0, 0, 1213, 149, 1, 0, 0, 0, 1214, 1221, 3, 154, 77, 0, 1215,
		1217, 5, 149, 0, 0, 1216, 1215, 1, 0, 0, 0, 1216, 1217, 1, 0, 0, 0, 1217,
		1218, 1, 0, 0, 0, 1218, 1220, 3, 156, 78, 0, 1219, 1216, 1, 0, 0, 0, 1220,
		1223, 1, 0, 0, 0, 1221, 1219, 1, 0, 0, 0, 1221, 1222, 1, 0, 0, 0, 1222,
		1229, 1, 0, 0, 0, 1223, 1221, 1, 0, 0, 0, 1224, 1225, 5, 3, 0, 0, 1225,
		1226, 3, 150, 75, 0, 1226, 1227, 5, 4, 0, 0, 1227, 1229, 1, 0, 0, 0, 1228,
		1214, 1, 0, 0, 0, 1228, 1224, 1, 0, 0, 0, 1229, 151, 1, 0, 0, 0, 1230,
		1235, 3, 154, 77, 0, 1231, 1233, 5, 149, 0, 0, 1232, 1231, 1, 0, 0, 0,
		1232, 1233, 1, 0, 0, 0, 1233, 1234, 1, 0, 0, 0, 1234, 1236, 3, 156, 78,
		0, 1235, 1232, 1, 0, 0, 0, 1236, 1237, 1, 0, 0, 0, 1237, 1235, 1, 0, 0,
		0, 1237, 1238, 1, 0, 0, 0, 1238, 153, 1, 0, 0, 0, 1239, 1241, 5, 3, 0,
		0, 1240, 1242, 5, 149, 0, 0, 1241, 1240, 1, 0, 0, 0, 1241, 1242, 1, 0,
		0, 0, 1242, 1247, 1, 0, 0, 0, 1243, 1245, 3, 258, 129, 0, 1244, 1246, 5,
		149, 0, 0, 1245, 1244, 1, 0, 0, 0, 1245, 1246, 1, 0, 0, 0, 1246, 1248,
		1, 0, 0, 0, 1247, 1243, 1, 0, 0, 0, 1247, 1248, 1, 0, 0, 0, 1248, 1253,
		1, 0, 0, 0, 1249, 1251, 3, 168, 84, 0, 1250, 1252, 5, 149, 0, 0, 1251,
		1250, 1, 0, 0, 0, 1251, 1252, 1, 0, 0, 0, 1252, 1254, 1, 0, 0, 0, 1253,
		1249, 1, 0, 0, 0, 1253, 1254, 1, 0, 0, 0, 1254, 1259, 1, 0, 0, 0, 1255,
		1257, 3, 162, 81, 0, 1256, 1258, 5, 149, 0, 0, 1257, 1256, 1, 0, 0, 0,
		1257, 1258, 1, 0, 0, 0, 1258, 1260, 1, 0, 0, 0, 1259, 1255, 1, 0, 0, 0,
		1259, 1260, 1, 0, 0, 0, 1260, 1261, 1, 0, 0, 0, 1261, 1262, 5, 4, 0, 0,
		1262, 155, 1, 0, 0, 0, 1263, 1265, 3, 158, 79, 0, 1264, 1266, 5, 149, 0,
		0, 1265, 1264, 1, 0, 0, 0, 1265, 1266, 1, 0, 0, 0, 1266, 1267, 1, 0, 0,
		0, 1267, 1268, 3, 154, 77, 0, 1268, 157, 1, 0, 0, 0, 1269, 1271, 3, 286,
		143, 0, 1270, 1272, 5, 149, 0, 0, 1271, 1270, 1, 0, 0, 0, 1271, 1272, 1,
		0, 0, 0, 1272, 1273, 1, 0, 0, 0, 1273, 1275, 3, 290, 145, 0, 1274, 1276,
		5, 149, 0, 0, 1275, 1274, 1, 0, 0, 0, 1275, 1276, 1, 0, 0, 0, 1276, 1278,
		1, 0, 0, 0, 1277, 1279, 3, 160, 80, 0, 1278, 1277, 1, 0, 0, 0, 1278, 1279,
		1, 0, 0, 0, 1279, 1281, 1, 0, 0, 0, 1280, 1282, 5, 149, 0, 0, 1281, 1280,
		1, 0, 0, 0, 1281, 1282, 1, 0, 0, 0, 1282, 1283, 1, 0, 0, 0, 1283, 1285,
		3, 290, 145, 0, 1284, 1286, 5, 149, 0, 0, 1285, 1284, 1, 0, 0, 0, 1285,
		1286, 1, 0, 0, 0, 1286, 1287, 1, 0, 0, 0, 1287, 1288, 3, 288, 144, 0, 1288,
		1334, 1, 0, 0, 0, 1289, 1291, 3, 286, 143, 0, 1290, 1292, 5, 149, 0, 0,
		1291, 1290, 1, 0, 0, 0, 1291, 1292, 1, 0, 0, 0, 1292, 1293, 1, 0, 0, 0,
		1293, 1295, 3, 290, 145, 0, 1294, 1296, 5, 149, 0, 0, 1295, 1294, 1, 0,
		0, 0, 1295, 1296, 1, 0, 0, 0, 1296, 1298, 1, 0, 0, 0, 1297, 1299, 3, 160,
		80, 0, 1298, 1297, 1, 0, 0, 0, 1298, 1299, 1, 0, 0, 0, 1299, 1301, 1, 0,
		0, 0, 1300, 1302, 5, 149, 0, 0, 1301, 1300, 1, 0, 0, 0, 1301, 1302, 1,
		0, 0, 0, 1302, 1303, 1, 0, 0, 0, 1303, 1304, 3, 290, 145, 0, 1304, 1334,
		1, 0, 0, 0, 1305, 1307, 3, 290, 145, 0, 1306, 1308, 5, 149, 0, 0, 1307,
		1306, 1, 0, 0, 0, 1307, 1308, 1, 0, 0, 0, 1308, 1310, 1, 0, 0, 0, 1309,
		1311, 3, 160, 80, 0, 1310, 1309, 1, 0, 0, 0, 1310, 1311, 1, 0, 0, 0, 1311,
		1313, 1, 0, 0, 0, 1312, 1314, 5, 149, 0, 0, 1313, 1312, 1, 0, 0, 0, 1313,
		1314, 1, 0, 0, 0, 1314, 1315, 1, 0, 0, 0, 1315, 1317, 3, 290, 145, 0, 1316,
		1318, 5, 149, 0, 0, 1317, 1316, 1, 0, 0, 0, 1317, 1318, 1, 0, 0, 0, 1318,
		1319, 1, 0, 0, 0, 1319, 1320, 3, 288, 144, 0, 1320, 1334, 1, 0, 0, 0, 1321,
		1323, 3, 290, 145, 0, 1322, 1324, 5, 149, 0, 0, 1323, 1322, 1, 0, 0, 0,
		1323, 1324, 1, 0, 0, 0, 1324, 1326, 1, 0, 0, 0, 1325, 1327, 3, 160, 80,
		0, 1326, 1325, 1, 0, 0, 0, 1326, 1327, 1, 0, 0, 0, 1327, 1329, 1, 0, 0,
		0, 1328, 1330, 5, 149, 0, 0, 1329, 1328, 1, 0, 0, 0, 1329, 1330, 1, 0,
		0, 0, 1330, 1331, 1, 0, 0, 0, 1331, 1332, 3, 290, 145, 0, 1332, 1334, 1,
		0, 0, 0, 1333, 1269, 1, 0, 0, 0, 1333, 1289, 1, 0, 0, 0, 1333, 1305, 1,
		0, 0, 0, 1333, 1321, 1, 0, 0, 0, 1334, 159, 1, 0, 0, 0, 1335, 1337, 5,
		5, 0, 0, 1336, 1338, 5, 149, 0, 0, 1337, 1336, 1, 0, 0, 0, 1337, 1338,
		1, 0, 0, 0, 1338, 1343, 1, 0, 0, 0, 1339, 1341, 3, 258, 129, 0, 1340, 1342,
		5, 149, 0, 0, 1341, 1340, 1, 0, 0, 0, 1341, 1342, 1, 0, 0, 0, 1342, 1344,
		1, 0, 0, 0, 1343, 1339, 1, 0, 0, 0, 1343, 1344, 1, 0, 0, 0, 1344, 1349,
		1, 0, 0, 0, 1345, 1347, 3, 166, 83, 0, 1346, 1348, 5, 149, 0, 0, 1347,
		1346, 1, 0, 0, 0, 1347, 1348, 1, 0, 0, 0, 1348, 1350, 1, 0, 0, 0, 1349,
		1345, 1, 0, 0, 0, 1349, 1350, 1, 0, 0, 0, 1350, 1352, 1, 0, 0, 0, 1351,
		1353, 3, 172, 86, 0, 1352, 1351, 1, 0, 0, 0, 1352, 1353, 1, 0, 0, 0, 1353,
		1358, 1, 0, 0, 0, 1354, 1356, 3, 162, 81, 0, 1355, 1357, 5, 149, 0, 0,
		1356, 1355, 1, 0, 0, 0, 1356, 1357, 1, 0, 0, 0, 1357, 1359, 1, 0, 0, 0,
		1358, 1354, 1, 0, 0, 0, 1358, 1359, 1, 0, 0, 0, 1359, 1360, 1, 0, 0, 0,
		1360, 1361, 5, 6, 0, 0, 1361, 161, 1, 0, 0, 0, 1362, 1366, 3, 272, 136,
		0, 1363, 1366, 3, 278, 139, 0, 1364, 1366, 3, 276, 138, 0, 1365, 1362,
		1, 0, 0, 0, 1365, 1363, 1, 0, 0, 0, 1365, 1364, 1, 0, 0, 0, 1366, 163,
		1, 0, 0, 0, 1367, 1369, 5, 11, 0, 0, 1368, 1370, 5, 149, 0, 0, 1369, 1368,
		1, 0, 0, 0, 1369, 1370, 1, 0, 0, 0, 1370, 1371, 1, 0, 0, 0, 1371, 1372,
		3, 176, 88, 0, 1372, 165, 1, 0, 0, 0, 1373, 1375, 5, 11, 0, 0, 1374, 1376,
		5, 149, 0, 0, 1375, 1374, 1, 0, 0, 0, 1375, 1376, 1, 0, 0, 0, 1376, 1377,
		1, 0, 0, 0, 1377, 1391, 3, 176, 88, 0, 1378, 1380, 5, 149, 0, 0, 1379,
		1378, 1, 0, 0, 0, 1379, 1380, 1, 0, 0, 0, 1380, 1381, 1, 0, 0, 0, 1381,
		1383, 5, 9, 0, 0, 1382, 1384, 5, 11, 0, 0, 1383, 1382, 1, 0, 0, 0, 1383,
		1384, 1, 0, 0, 0, 1384, 1386, 1, 0, 0, 0, 1385, 1387, 5, 149, 0, 0, 1386,
		1385, 1, 0, 0, 0, 1386, 1387, 1, 0, 0, 0, 1387, 1388, 1, 0, 0, 0, 1388,
		1390, 3, 176, 88, 0, 1389, 1379, 1, 0, 0, 0, 1390, 1393, 1, 0, 0, 0, 1391,
		1389, 1, 0, 0, 0, 1391, 1392, 1, 0, 0, 0, 1392, 167, 1, 0, 0, 0, 1393,
		1391, 1, 0, 0, 0, 1394, 1401, 3, 170, 85, 0, 1395, 1397, 5, 149, 0, 0,
		1396, 1395, 1, 0, 0, 0, 1396, 1397, 1, 0, 0, 0, 1397, 1398, 1, 0, 0, 0,
		1398, 1400, 3, 170, 85, 0, 1399, 1396, 1, 0, 0, 0, 1400, 1403, 1, 0, 0,
		0, 1401, 1399, 1, 0, 0, 0, 1401, 1402, 1, 0, 0, 0, 1402, 169, 1, 0, 0,
		0, 1403, 1401, 1, 0, 0, 0, 1404, 1406, 5, 11, 0, 0, 1405, 1407, 5, 149,
		0, 0, 1406, 1405, 1, 0, 0, 0, 1406, 1407, 1, 0, 0, 0, 1407, 1408, 1, 0,
		0, 0, 1408, 1409, 3, 174, 87, 0, 1409, 171, 1, 0, 0, 0, 1410, 1412, 5,
		10, 0, 0, 1411, 1413, 5, 149, 0, 0, 1412, 1411, 1, 0, 0, 0, 1412, 1413,
		1, 0, 0, 0, 1413, 1418, 1, 0, 0, 0, 1414, 1416, 3, 266, 133, 0, 1415, 1417,
		5, 149, 0, 0, 1416, 1415, 1, 0, 0, 0, 1416, 1417, 1, 0, 0, 0, 1417, 1419,
		1, 0, 0, 0, 1418, 1414, 1, 0, 0, 0, 1418, 1419, 1, 0, 0, 0, 1419, 1430,
		1, 0, 0, 0, 1420, 1422, 5, 12, 0, 0, 1421, 1423, 5, 149, 0, 0, 1422, 1421,
		1, 0, 0, 0, 1422, 1423, 1, 0, 0, 0, 1423, 1428, 1, 0, 0, 0, 1424, 1426,
		3, 266, 133, 0, 1425, 1427, 5, 149, 0, 0, 1426, 1425, 1, 0, 0, 0, 1426,
		1427, 1, 0, 0, 0, 1427, 1429, 1, 0, 0, 0, 1428, 1424, 1, 0, 0, 0, 1428,
		1429, 1, 0, 0, 0, 1429, 1431, 1, 0, 0, 0, 1430, 1420, 1, 0, 0, 0, 1430,
		1431, 1, 0, 0, 0, 1431, 173, 1, 0, 0, 0, 1432, 1433, 3, 280, 140, 0, 1433,
		175, 1, 0, 0, 0, 1434, 1435, 3, 280, 140, 0, 1435, 177, 1, 0, 0, 0, 1436,
		1441, 3, 218, 109, 0, 1437, 1439, 5, 149, 0, 0, 1438, 1437, 1, 0, 0, 0,
		1438, 1439, 1, 0, 0, 0, 1439, 1440, 1, 0, 0, 0, 1440, 1442, 3, 216, 108,
		0, 1441, 1438, 1, 0, 0, 0, 1442, 1443, 1, 0, 0, 0, 1443, 1441, 1, 0, 0,
		0, 1443, 1444, 1, 0, 0, 0, 1444, 179, 1, 0, 0, 0, 1445, 1446, 3, 182, 91,
		0, 1446, 181, 1, 0, 0, 0, 1447, 1454, 3, 184, 92, 0, 1448, 1449, 5, 149,
		0, 0, 1449, 1450, 5, 102, 0, 0, 1450, 1451, 5, 149, 0, 0, 1451, 1453, 3,
		184, 92, 0, 1452, 1448, 1, 0, 0, 0, 1453, 1456, 1, 0, 0, 0, 1454, 1452,
		1, 0, 0, 0, 1454, 1455, 1, 0, 0, 0, 1455, 183, 1, 0, 0, 0, 1456, 1454,
		1, 0, 0, 0, 1457, 1464, 3, 186, 93, 0, 1458, 1459, 5, 149, 0, 0, 1459,
		1460, 5, 103, 0, 0, 1460, 1461, 5, 149, 0, 0, 1461, 1463, 3, 186, 93, 0,
		1462, 1458, 1, 0, 0, 0, 1463, 1466, 1, 0, 0, 0, 1464, 1462, 1, 0, 0, 0,
		1464, 1465, 1, 0, 0, 0, 1465, 185, 1, 0, 0, 0, 1466, 1464, 1, 0, 0, 0,
		1467, 1474, 3, 188, 94, 0, 1468, 1469, 5, 149, 0, 0, 1469, 1470, 5, 104,
		0, 0, 1470, 1471, 5, 149, 0, 0, 1471, 1473, 3, 188, 94, 0, 1472, 1468,
		1, 0, 0, 0, 1473, 1476, 1, 0, 0, 0, 1474, 1472, 1, 0, 0, 0, 1474, 1475,
		1, 0, 0, 0, 1475, 187, 1, 0, 0, 0, 1476, 1474, 1, 0, 0, 0, 1477, 1479,
		5, 105, 0, 0, 1478, 1480, 5, 149, 0, 0, 1479, 1478, 1, 0, 0, 0, 1479, 1480,
		1, 0, 0, 0, 1480, 1482, 1, 0, 0, 0, 1481, 1477, 1, 0, 0, 0, 1482, 1485,
		1, 0, 0, 0, 1483, 1481, 1, 0, 0, 0, 1483, 1484, 1, 0, 0, 0, 1484, 1486,
		1, 0, 0, 0, 1485, 1483, 1, 0, 0, 0, 1486, 1487, 3, 190, 95, 0, 1487, 189,
		1, 0, 0, 0, 1488, 1495, 3, 194, 97, 0, 1489, 1491, 5, 149, 0, 0, 1490,
		1489, 1, 0, 0, 0, 1490, 1491, 1, 0, 0, 0, 1491, 1492, 1, 0, 0, 0, 1492,
		1494, 3, 192, 96, 0, 1493, 1490, 1, 0, 0, 0, 1494, 1497, 1, 0, 0, 0, 1495,
		1493, 1, 0, 0, 0, 1495, 1496, 1, 0, 0, 0, 1496, 191, 1, 0, 0, 0, 1497,
		1495, 1, 0, 0, 0, 1498, 1500, 5, 2, 0, 0, 1499, 1501, 5, 149, 0, 0, 1500,
		1499, 1, 0, 0, 0, 1500, 1501, 1, 0, 0, 0, 1501, 1502, 1, 0, 0, 0, 1502,
		1529, 3, 194, 97, 0, 1503, 1505, 5, 13, 0, 0, 1504, 1506, 5, 149, 0, 0,
		1505, 1504, 1, 0, 0, 0, 1505, 1506, 1, 0, 0, 0, 1506, 1507, 1, 0, 0, 0,
		1507, 1529, 3, 194, 97, 0, 1508, 1510, 5, 14, 0, 0, 1509, 1511, 5, 149,
		0, 0, 1510, 1509, 1, 0, 0, 0, 1510, 1511, 1, 0, 0, 0, 1511, 1512, 1, 0,
		0, 0, 1512, 1529, 3, 194, 97, 0, 1513, 1515, 5, 15, 0, 0, 1514, 1516, 5,
		149, 0, 0, 1515, 1514, 1, 0, 0, 0, 1515, 1516, 1, 0, 0, 0, 1516, 1517,
		1, 0, 0, 0, 1517, 1529, 3, 194, 97, 0, 1518, 1520, 5, 16, 0, 0, 1519, 1521,
		5, 149, 0, 0, 1520, 1519, 1, 0, 0, 0, 1520, 1521, 1, 0, 0, 0, 1521, 1522,
		1, 0, 0, 0, 1522, 1529, 3, 194, 97, 0, 1523, 1525, 5, 17, 0, 0, 1524, 1526,
		5, 149, 0, 0, 1525, 1524, 1, 0, 0, 0, 1525, 1526, 1, 0, 0, 0, 1526, 1527,
		1, 0, 0, 0, 1527, 1529, 3, 194, 97, 0, 1528, 1498, 1, 0, 0, 0, 1528, 1503,
		1, 0, 0, 0, 1528, 1508, 1, 0, 0, 0, 1528, 1513, 1, 0, 0, 0, 1528, 1518,
		1, 0, 0, 0, 1528, 1523, 1, 0, 0, 0, 1529, 193, 1, 0, 0, 0, 1530, 1536,
		3, 204, 102, 0, 1531, 1535, 3, 196, 98, 0, 1532, 1535, 3, 198, 99, 0, 1533,
		1535, 3, 200, 100, 0, 1534, 1531, 1, 0, 0, 0, 1534, 1532, 1, 0, 0, 0, 1534,
		1533, 1, 0, 0, 0, 1535, 1538, 1, 0, 0, 0, 1536, 1534, 1, 0, 0, 0, 1536,
		1537, 1, 0, 0, 0, 1537, 195, 1, 0, 0, 0, 1538, 1536, 1, 0, 0, 0, 1539,
		1551, 3, 202, 101, 0, 1540, 1541, 5, 149, 0, 0, 1541, 1542, 5, 106, 0,
		0, 1542, 1543, 5, 149, 0, 0, 1543, 1551, 5, 66, 0, 0, 1544, 1545, 5, 149,
		0, 0, 1545, 1546, 5, 107, 0, 0, 1546, 1547, 5, 149, 0, 0, 1547, 1551, 5,
		66, 0, 0, 1548, 1549, 5, 149, 0, 0, 1549, 1551, 5, 108, 0, 0, 1550, 1539,
		1, 0, 0, 0, 1550, 1540, 1, 0, 0, 0, 1550, 1544, 1, 0, 0, 0, 1550, 1548,
		1, 0, 0, 0, 1551, 1553, 1, 0, 0, 0, 1552, 1554, 5, 149, 0, 0, 1553, 1552,
		1, 0, 0, 0, 1553, 1554, 1, 0, 0, 0, 1554, 1555, 1, 0, 0, 0, 1555, 1556,
		3, 204, 102, 0, 1556, 197, 1, 0, 0, 0, 1557, 1558, 5, 149, 0, 0, 1558,
		1560, 5, 80, 0, 0, 1559, 1561, 5, 149, 0, 0, 1560, 1559, 1, 0, 0, 0, 1560,
		1561, 1, 0, 0, 0, 1561, 1562, 1, 0, 0, 0, 1562, 1563, 3, 204, 102, 0, 1563,
		199, 1, 0, 0, 0, 1564, 1565, 5, 149, 0, 0, 1565, 1566, 5, 61, 0, 0, 1566,
		1567, 5, 149, 0, 0, 1567, 1575, 5, 109, 0, 0, 1568, 1569, 5, 149, 0, 0,
		1569, 1570, 5, 61, 0, 0, 1570, 1571, 5, 149, 0, 0, 1571, 1572, 5, 105,
		0, 0, 1572, 1573, 5, 149, 0, 0, 1573, 1575, 5, 109, 0, 0, 1574, 1564, 1,
		0, 0, 0, 1574, 1568, 1, 0, 0, 0, 1575, 201, 1, 0, 0, 0, 1576, 1578, 5,
		149, 0, 0, 1577, 1576, 1, 0, 0, 0, 1577, 1578, 1, 0, 0, 0, 1578, 1579,
		1, 0, 0, 0, 1579, 1580, 5, 18, 0, 0, 1580, 203, 1, 0, 0, 0, 1581, 1600,
		3, 206, 103, 0, 1582, 1584, 5, 149, 0, 0, 1583, 1582, 1, 0, 0, 0, 1583,
		1584, 1, 0, 0, 0, 1584, 1585, 1, 0, 0, 0, 1585, 1587, 5, 19, 0, 0, 1586,
		1588, 5, 149, 0, 0, 1587, 1586, 1, 0, 0, 0, 1587, 1588, 1, 0, 0, 0, 1588,
		1589, 1, 0, 0, 0, 1589, 1599, 3, 206, 103, 0, 1590, 1592, 5, 149, 0, 0,
		1591, 1590, 1, 0, 0, 0, 1591, 1592, 1, 0, 0, 0, 1592, 1593, 1, 0, 0, 0,
		1593, 1595, 5, 20, 0, 0, 1594, 1596, 5, 149, 0, 0, 1595, 1594, 1, 0, 0,
		0, 1595, 1596, 1, 0, 0, 0, 1596, 1597, 1, 0, 0, 0, 1597, 1599, 3, 206,
		103, 0, 1598, 1583, 1, 0, 0, 0, 1598, 1591, 1, 0, 0, 0, 1599, 1602, 1,
		0, 0, 0, 1600, 1598, 1, 0, 0, 0, 1600, 1601, 1, 0, 0, 0, 1601, 205, 1,
		0, 0, 0, 1602, 1600, 1, 0, 0, 0, 1603, 1630, 3, 208, 104, 0, 1604, 1606,
		5, 149, 0, 0, 1605, 1604, 1, 0, 0, 0, 1605, 1606, 1, 0, 0, 0, 1606, 1607,
		1, 0, 0, 0, 1607, 1609, 5, 10, 0, 0, 1608, 1610, 5, 149, 0, 0, 1609, 1608,
		1, 0, 0, 0, 1609, 1610, 1, 0, 0, 0, 1610, 1611, 1, 0, 0, 0, 1611, 1629,
		3, 208, 104, 0, 1612, 1614, 5, 149, 0, 0, 1613, 1612, 1, 0, 0, 0, 1613,
		1614, 1, 0, 0, 0, 1614, 1615, 1, 0, 0, 0, 1615, 1617, 5, 21, 0, 0, 1616,
		1618, 5, 149, 0, 0, 1617, 1616, 1, 0, 0, 0, 1617, 1618, 1, 0, 0, 0, 1618,
		1619, 1, 0, 0, 0, 1619, 1629, 3, 208, 104, 0, 1620, 1622, 5, 149, 0, 0,
		1621, 1620, 1, 0, 0, 0, 1621, 1622, 1, 0, 0, 0, 1622, 1623, 1, 0, 0, 0,
		1623, 1625, 5, 22, 0, 0, 1624, 1626, 5, 149, 0, 0, 1625, 1624, 1, 0, 0,
		0, 1625, 1626, 1, 0, 0, 0, 1626, 1627, 1, 0, 0, 0, 1627, 1629, 3, 208,
		104, 0, 1628, 1605, 1, 0, 0, 0, 1628, 1613, 1, 0, 0, 0, 1628, 1621, 1,
		0, 0, 0, 1629, 1632, 1, 0, 0, 0, 1630, 1628, 1, 0, 0, 0, 1630, 1631, 1,
		0, 0, 0, 1631, 207, 1, 0, 0, 0, 1632, 1630, 1, 0, 0, 0, 1633, 1644, 3,
		210, 105, 0, 1634, 1636, 5, 149, 0, 0, 1635, 1634, 1, 0, 0, 0, 1635, 1636,
		1, 0, 0, 0, 1636, 1637, 1, 0, 0, 0, 1637, 1639, 5, 23, 0, 0, 1638, 1640,
		5, 149, 0, 0, 1639, 1638, 1, 0, 0, 0, 1639, 1640, 1, 0, 0, 0, 1640, 1641,
		1, 0, 0, 0, 1641, 1643, 3, 210, 105, 0, 1642, 1635, 1, 0, 0, 0, 1643, 1646,
		1, 0, 0, 0, 1644, 1642, 1, 0, 0, 0, 1644, 1645, 1, 0, 0, 0, 1645, 209,
		1, 0, 0, 0, 1646, 1644, 1, 0, 0, 0, 1647, 1654, 3, 212, 106, 0, 1648, 1650,
		7, 2, 0, 0, 1649, 1651, 5, 149, 0, 0, 1650, 1649, 1, 0, 0, 0, 1650, 1651,
		1, 0, 0, 0, 1651, 1652, 1, 0, 0, 0, 1652, 1654, 3, 212, 106, 0, 1653, 1647,
		1, 0, 0, 0, 1653, 1648, 1, 0, 0, 0, 1654, 211, 1, 0, 0, 0, 1655, 1666,
		3, 218, 109, 0, 1656, 1658, 5, 149, 0, 0, 1657, 1656, 1, 0, 0, 0, 1657,
		1658, 1, 0, 0, 0, 1658, 1659, 1, 0, 0, 0, 1659, 1665, 3, 214, 107, 0, 1660,
		1662, 5, 149, 0, 0, 1661, 1660, 1, 0, 0, 0, 1661, 1662, 1, 0, 0, 0, 1662,
		1663, 1, 0, 0, 0, 1663, 1665, 3, 216, 108, 0, 1664, 1657, 1, 0, 0, 0, 1664,
		1661, 1, 0, 0, 0, 1665, 1668, 1, 0, 0, 0, 1666, 1664, 1, 0, 0, 0, 1666,
		1667, 1, 0, 0, 0, 1667, 1673, 1, 0, 0, 0, 1668, 1666, 1, 0, 0, 0, 1669,
		1671, 5, 149, 0, 0, 1670, 1669, 1, 0, 0, 0, 1670, 1671, 1, 0, 0, 0, 1671,
		1672, 1, 0, 0, 0, 1672, 1674, 3, 168, 84, 0, 1673, 1670, 1, 0, 0, 0, 1673,
		1674, 1, 0, 0, 0, 1674, 213, 1, 0, 0, 0, 1675, 1676, 5, 5, 0, 0, 1676,
		1677, 3, 180, 90, 0, 1677, 1678, 5, 6, 0, 0, 1678, 1689, 1, 0, 0, 0, 1679,
		1681, 5, 5, 0, 0, 1680, 1682, 3, 180, 90, 0, 1681, 1680, 1, 0, 0, 0, 1681,
		1682, 1, 0, 0, 0, 1682, 1683, 1, 0, 0, 0, 1683, 1685, 5, 12, 0, 0, 1684,
		1686, 3, 180, 90, 0, 1685, 1684, 1, 0, 0, 0, 1685, 1686, 1, 0, 0, 0, 1686,
		1687, 1, 0, 0, 0, 1687, 1689, 5, 6, 0, 0, 1688, 1675, 1, 0, 0, 0, 1688,
		1679, 1, 0, 0, 0, 1689, 215, 1, 0, 0, 0, 1690, 1692, 5, 24, 0, 0, 1691,
		1693, 5, 149, 0, 0, 1692, 1691, 1, 0, 0, 0, 1692, 1693, 1, 0, 0, 0, 1693,
		1694, 1, 0, 0, 0, 1694, 1695, 3, 274, 137, 0, 1695, 217, 1, 0, 0, 0, 1696,
		1725, 3, 260, 130, 0, 1697, 1725, 3, 278, 139, 0, 1698, 1725, 3, 276, 138,
		0, 1699, 1725, 3, 220, 110, 0, 1700, 1702, 5, 110, 0, 0, 1701, 1703, 5,
		149, 0, 0, 1702, 1701, 1, 0, 0, 0, 1702, 1703, 1, 0, 0, 0, 1703, 1704,
		1, 0, 0, 0, 1704, 1706, 5, 3, 0, 0, 1705, 1707, 5, 149, 0, 0, 1706, 1705,
		1, 0, 0, 0, 1706, 1707, 1, 0, 0, 0, 1707, 1708, 1, 0, 0, 0, 1708, 1710,
		5, 10, 0, 0, 1709, 1711, 5, 149, 0, 0, 1710, 1709, 1, 0, 0, 0, 1710, 1711,
		1, 0, 0, 0, 1711, 1712, 1, 0, 0, 0, 1712, 1725, 5, 4, 0, 0, 1713, 1725,
		3, 224, 112, 0, 1714, 1725, 3, 226, 113, 0, 1715, 1725, 3, 228, 114, 0,
		1716, 1725, 3, 230, 115, 0, 1717, 1725, 3, 232, 116, 0, 1718, 1725, 3,
		148, 74, 0, 1719, 1725, 3, 236, 118, 0, 1720, 1725, 3, 238, 119, 0, 1721,
		1725, 3, 242, 121, 0, 1722, 1725, 3, 246, 123, 0, 1723, 1725, 3, 258, 129,
		0, 1724, 1696, 1, 0, 0, 0, 1724, 1697, 1, 0, 0, 0, 1724, 1698, 1, 0, 0,
		0, 1724, 1699, 1, 0, 0, 0, 1724, 1700, 1, 0, 0, 0, 1724, 1713, 1, 0, 0,
		0, 1724, 1714, 1, 0, 0, 0, 1724, 1715, 1, 0, 0, 0, 1724, 1716, 1, 0, 0,
		0, 1724, 1717, 1, 0, 0, 0, 1724, 1718, 1, 0, 0, 0, 1724, 1719, 1, 0, 0,
		0, 1724, 1720, 1, 0, 0, 0, 1724, 1721, 1, 0, 0, 0, 1724, 1722, 1, 0, 0,
		0, 1724, 1723, 1, 0, 0, 0, 1725, 219, 1, 0, 0, 0, 1726, 1731, 5, 111, 0,
		0, 1727, 1729, 5, 149, 0, 0, 1728, 1727, 1, 0, 0, 0, 1728, 1729, 1, 0,
		0, 0, 1729, 1730, 1, 0, 0, 0, 1730, 1732, 3, 222, 111, 0, 1731, 1728, 1,
		0, 0, 0, 1732, 1733, 1, 0, 0, 0, 1733, 1731, 1, 0, 0, 0, 1733, 1734, 1,
		0, 0, 0, 1734, 1749, 1, 0, 0, 0, 1735, 1737, 5, 111, 0, 0, 1736, 1738,
		5, 149, 0, 0, 1737, 1736, 1, 0, 0, 0, 1737, 1738, 1, 0, 0, 0, 1738, 1739,
		1, 0, 0, 0, 1739, 1744, 3, 180, 90, 0, 1740, 1742, 5, 149, 0, 0, 1741,
		1740, 1, 0, 0, 0, 1741, 1742, 1, 0, 0, 0, 1742, 1743, 1, 0, 0, 0, 1743,
		1745, 3, 222, 111, 0, 1744, 1741, 1, 0, 0, 0, 1745, 1746, 1, 0, 0, 0, 1746,
		1744, 1, 0, 0, 0, 1746, 1747, 1, 0, 0, 0, 1747, 1749, 1, 0, 0, 0, 1748,
		1726, 1, 0, 0, 0, 1748, 1735, 1, 0, 0, 0, 1749, 1758, 1, 0, 0, 0, 1750,
		1752, 5, 149, 0, 0, 1751, 1750, 1, 0, 0, 0, 1751, 1752, 1, 0, 0, 0, 1752,
		1753, 1, 0, 0, 0, 1753, 1755, 5, 112, 0, 0, 1754, 1756, 5, 149, 0, 0, 1755,
		1754, 1, 0, 0, 0, 1755, 1756, 1, 0, 0, 0, 1756, 1757, 1, 0, 0, 0, 1757,
		1759, 3, 180, 90, 0, 1758, 1751, 1, 0, 0, 0, 1758, 1759, 1, 0, 0, 0, 1759,
		1761, 1, 0, 0, 0, 1760, 1762, 5, 149, 0, 0, 1761, 1760, 1, 0, 0, 0, 1761,
		1762, 1, 0, 0, 0, 1762, 1763, 1, 0, 0, 0, 1763, 1764, 5, 113, 0, 0, 1764,
		221, 1, 0, 0, 0, 1765, 1767, 5, 114, 0, 0, 1766, 1768, 5, 149, 0, 0, 1767,
		1766, 1, 0, 0, 0, 1767, 1768, 1, 0, 0, 0, 1768, 1769, 1, 0, 0, 0, 1769,
		1771, 3, 180, 90, 0, 1770, 1772, 5, 149, 0, 0, 1771, 1770, 1, 0, 0, 0,
		1771, 1772, 1, 0, 0, 0, 1772, 1773, 1, 0, 0, 0, 1773, 1775, 5, 115, 0,
		0, 1774, 1776, 5, 149, 0, 0, 1775, 1774, 1, 0, 0, 0, 1775, 1776, 1, 0,
		0, 0, 1776, 1777, 1, 0, 0, 0, 1777, 1778, 3, 180, 90, 0, 1778, 223, 1,
		0, 0, 0, 1779, 1781, 5, 5, 0, 0, 1780, 1782, 5, 149, 0, 0, 1781, 1780,
		1, 0, 0, 0, 1781, 1782, 1, 0, 0, 0, 1782, 1783, 1, 0, 0, 0, 1783, 1792,
		3, 234, 117, 0, 1784, 1786, 5, 149, 0, 0, 1785, 1784, 1, 0, 0, 0, 1785,
		1786, 1, 0, 0, 0, 1786, 1787, 1, 0, 0, 0, 1787, 1789, 5, 9, 0, 0, 1788,
		1790, 5, 149, 0, 0, 1789, 1788, 1, 0, 0, 0, 1789, 1790, 1, 0, 0, 0, 1790,
		1791, 1, 0, 0, 0, 1791, 1793, 3, 180, 90, 0, 1792, 1785, 1, 0, 0, 0, 1792,
		1793, 1, 0, 0, 0, 1793, 1795, 1, 0, 0, 0, 1794, 1796, 5, 149, 0, 0, 1795,
		1794, 1, 0, 0, 0, 1795, 1796, 1, 0, 0, 0, 1796, 1797, 1, 0, 0, 0, 1797,
		1798, 5, 6, 0, 0, 1798, 225, 1, 0, 0, 0, 1799, 1801, 5, 5, 0, 0, 1800,
		1802, 5, 149, 0, 0, 1801, 1800, 1, 0, 0, 0, 1801, 1802, 1, 0, 0, 0, 1802,
		1811, 1, 0, 0, 0, 1803, 1805, 3, 258, 129, 0, 1804, 1806, 5, 149, 0, 0,
		1805, 1804, 1, 0, 0, 0, 1805, 1806, 1, 0, 0, 0, 1806, 1807, 1, 0, 0, 0,
		1807, 1809, 5, 2, 0, 0, 1808, 1810, 5, 149, 0, 0, 1809, 1808, 1, 0, 0,
		0, 1809, 1810, 1, 0, 0, 0, 1810, 1812, 1, 0, 0, 0, 1811, 1803, 1, 0, 0,
		0, 1811, 1812, 1, 0, 0, 0, 1812, 1813, 1, 0, 0, 0, 1813, 1815, 3, 152,
		76, 0, 1814, 1816, 5, 149, 0, 0, 1815, 1814, 1, 0, 0, 0, 1815, 1816, 1,
		0, 0, 0, 1816, 1821, 1, 0, 0, 0, 1817, 1819, 3, 140, 70, 0, 1818, 1820,
		5, 149, 0, 0, 1819, 1818, 1, 0, 0, 0, 1819, 1820, 1, 0, 0, 0, 1820, 1822,
		1, 0, 0, 0, 1821, 1817, 1, 0, 0, 0, 1821, 1822, 1, 0, 0, 0, 1822, 1823,
		1, 0, 0, 0, 1823, 1825, 5, 9, 0, 0, 1824, 1826, 5, 149, 0, 0, 1825, 1824,
		1, 0, 0, 0, 1825, 1826, 1, 0, 0, 0, 1826, 1827, 1, 0, 0, 0, 1827, 1829,
		3, 180, 90, 0, 1828, 1830, 5, 149, 0, 0, 1829, 1828, 1, 0, 0, 0, 1829,
		1830, 1, 0, 0, 0, 1830, 1831, 1, 0, 0, 0, 1831, 1832, 5, 6, 0, 0, 1832,
		227, 1, 0, 0, 0, 1833, 1835, 5, 116, 0, 0, 1834, 1836, 5, 149, 0, 0, 1835,
		1834, 1, 0, 0, 0, 1835, 1836, 1, 0, 0, 0, 1836, 1837, 1, 0, 0, 0, 1837,
		1839, 5, 3, 0, 0, 1838, 1840, 5, 149, 0, 0, 1839, 1838, 1, 0, 0, 0, 1839,
		1840, 1, 0, 0, 0, 1840, 1841, 1, 0, 0, 0, 1841, 1843, 3, 234, 117, 0, 1842,
		1844, 5, 149, 0, 0, 1843, 1842, 1, 0, 0, 0, 1843, 1844, 1, 0, 0, 0, 1844,
		1845, 1, 0, 0, 0, 1845, 1846, 5, 4, 0, 0, 1846, 1869, 1, 0, 0, 0, 1847,
		1849, 5, 117, 0, 0, 1848, 1850, 5, 149, 0, 0, 1849, 1848, 1, 0, 0, 0, 1849,
		1850, 1, 0, 0, 0, 1850, 1851, 1, 0, 0, 0, 1851, 1853, 5, 3, 0, 0, 1852,
		1854, 5, 149, 0, 0, 1853, 1852, 1, 0, 0, 0, 1853, 1854, 1, 0, 0, 0, 1854,
		1855, 1, 0, 0, 0, 1855, 1857, 3, 234, 117, 0, 1856, 1858, 5, 149, 0, 0,
		1857, 1856, 1, 0, 0, 0, 1857, 1858, 1, 0, 0, 0, 1858, 1864, 1, 0, 0, 0,
		1859, 1861, 5, 149, 0, 0, 1860, 1859, 1, 0, 0, 0, 1860, 1861, 1, 0, 0,
		0, 1861, 1862, 1, 0, 0, 0, 1862, 1863, 5, 9, 0, 0, 1863, 1865, 3, 180,
		90, 0, 1864, 1860, 1, 0, 0, 0, 1864, 1865, 1, 0, 0, 0, 1865, 1866, 1, 0,
		0, 0, 1866, 1867, 5, 4, 0, 0, 1867, 1869, 1, 0, 0, 0, 1868, 1833, 1, 0,
		0, 0, 1868, 1847, 1, 0, 0, 0, 1869, 229, 1, 0, 0, 0, 1870, 1872, 5, 118,
		0, 0, 1871, 1873, 5, 149, 0, 0, 1872, 1871, 1, 0, 0, 0, 1872, 1873, 1,
		0, 0, 0, 1873, 1874, 1, 0, 0, 0, 1874, 1875, 5, 3, 0, 0, 1875, 1876, 3,
		258, 129, 0, 1876, 1877, 5, 2, 0, 0, 1877, 1878, 3, 180, 90, 0, 1878, 1879,
		5, 7, 0, 0, 1879, 1880, 3, 240, 120, 0, 1880, 1881, 5, 9, 0, 0, 1881, 1882,
		3, 180, 90, 0, 1882, 1883, 5, 4, 0, 0, 1883, 231, 1, 0, 0, 0, 1884, 1886,
		5, 54, 0, 0, 1885, 1887, 5, 149, 0, 0, 1886, 1885, 1, 0, 0, 0, 1886, 1887,
		1, 0, 0, 0, 1887, 1888, 1, 0, 0, 0, 1888, 1890, 5, 3, 0, 0, 1889, 1891,
		5, 149, 0, 0, 1890, 1889, 1, 0, 0, 0, 1890, 1891, 1, 0, 0, 0, 1891, 1892,
		1, 0, 0, 0, 1892, 1894, 3, 234, 117, 0, 1893, 1895, 5, 149, 0, 0, 1894,
		1893, 1, 0, 0, 0, 1894, 1895, 1, 0, 0, 0, 1895, 1896, 1, 0, 0, 0, 1896,
		1897, 5, 4, 0, 0, 1897, 1941, 1, 0, 0, 0, 1898, 1900, 5, 119, 0, 0, 1899,
		1901, 5, 149, 0, 0, 1900, 1899, 1, 0, 0, 0, 1900, 1901, 1, 0, 0, 0, 1901,
		1902, 1, 0, 0, 0, 1902, 1904, 5, 3, 0, 0, 1903, 1905, 5, 149, 0, 0, 1904,
		1903, 1, 0, 0, 0, 1904, 1905, 1, 0, 0, 0, 1905, 1906, 1, 0, 0, 0, 1906,
		1908, 3, 234, 117, 0, 1907, 1909, 5, 149, 0, 0, 1908, 1907, 1, 0, 0, 0,
		1908, 1909, 1, 0, 0, 0, 1909, 1910, 1, 0, 0, 0, 1910, 1911, 5, 4, 0, 0,
		1911, 1941, 1, 0, 0, 0, 1912, 1914, 5, 120, 0, 0, 1913, 1915, 5, 149, 0,
		0, 1914, 1913, 1, 0, 0, 0, 1914, 1915, 1, 0, 0, 0, 1915, 1916, 1, 0, 0,
		0, 1916, 1918, 5, 3, 0, 0, 1917, 1919, 5, 149, 0, 0, 1918, 1917, 1, 0,
		0, 0, 1918, 1919, 1, 0, 0, 0, 1919, 1920, 1, 0, 0, 0, 1920, 1922, 3, 234,
		117, 0, 1921, 1923, 5, 149, 0, 0, 1922, 1921, 1, 0, 0, 0, 1922, 1923, 1,
		0, 0, 0, 1923, 1924, 1, 0, 0, 0, 1924, 1925, 5, 4, 0, 0, 1925, 1941, 1,
		0, 0, 0, 1926, 1928, 5, 121, 0, 0, 1927, 1929, 5, 149, 0, 0, 1928, 1927,
		1, 0, 0, 0, 1928, 1929, 1, 0, 0, 0, 1929, 1930, 1, 0, 0, 0, 1930, 1932,
		5, 3, 0, 0, 1931, 1933, 5, 149, 0, 0, 1932, 1931, 1, 0, 0, 0, 1932, 1933,
		1, 0, 0, 0, 1933, 1934, 1, 0, 0, 0, 1934, 1936, 3, 234, 117, 0, 1935, 1937,
		5, 149, 0, 0, 1936, 1935, 1, 0, 0, 0, 1936, 1937, 1, 0, 0, 0, 1937, 1938,
		1, 0, 0, 0, 1938, 1939, 5, 4, 0, 0, 1939, 1941, 1, 0, 0, 0, 1940, 1884,
		1, 0, 0, 0, 1940, 1898, 1, 0, 0, 0, 1940, 1912, 1, 0, 0, 0, 1940, 1926,
		1, 0, 0, 0, 1941, 233, 1, 0, 0, 0, 1942, 1947, 3, 240, 120, 0, 1943, 1945,
		5, 149, 0, 0, 1944, 1943, 1, 0, 0, 0, 1944, 1945, 1, 0, 0, 0, 1945, 1946,
		1, 0, 0, 0, 1946, 1948, 3, 140, 70, 0, 1947, 1944, 1, 0, 0, 0, 1947, 1948,
		1, 0, 0, 0, 1948, 235, 1, 0, 0, 0, 1949, 1950, 3, 152, 76, 0, 1950, 237,
		1, 0, 0, 0, 1951, 1953, 5, 3, 0, 0, 1952, 1954, 5, 149, 0, 0, 1953, 1952,
		1, 0, 0, 0, 1953, 1954, 1, 0, 0, 0, 1954, 1955, 1, 0, 0, 0, 1955, 1957,
		3, 180, 90, 0, 1956, 1958, 5, 149, 0, 0, 1957, 1956, 1, 0, 0, 0, 1957,
		1958, 1, 0, 0, 0, 1958, 1959, 1, 0, 0, 0, 1959, 1960, 5, 4, 0, 0, 1960,
		239, 1, 0, 0, 0, 1961, 1962, 3, 258, 129, 0, 1962, 1963, 5, 149, 0, 0,
		1963, 1964, 5, 80, 0, 0, 1964, 1965, 5, 149, 0, 0, 1965, 1966, 3, 180,
		90, 0, 1966, 241, 1, 0, 0, 0, 1967, 1969, 3, 244, 122, 0, 1968, 1970, 5,
		149, 0, 0, 1969, 1968, 1, 0, 0, 0, 1969, 1970, 1, 0, 0, 0, 1970, 1971,
		1, 0, 0, 0, 1971, 1973, 5, 3, 0, 0, 1972, 1974, 5, 149, 0, 0, 1973, 1972,
		1, 0, 0, 0, 1973, 1974, 1, 0, 0, 0, 1974, 1979, 1, 0, 0, 0, 1975, 1977,
		5, 84, 0, 0, 1976, 1978, 5, 149, 0, 0, 1977, 1976, 1, 0, 0, 0, 1977, 1978,
		1, 0, 0, 0, 1978, 1980, 1, 0, 0, 0, 1979, 1975, 1, 0, 0, 0, 1979, 1980,
		1, 0, 0, 0, 1980, 1998, 1, 0, 0, 0, 1981, 1983, 3, 180, 90, 0, 1982, 1984,
		5, 149, 0, 0, 1983, 1982, 1, 0, 0, 0, 1983, 1984, 1, 0, 0, 0, 1984, 1995,
		1, 0, 0, 0, 1985, 1987, 5, 7, 0, 0, 1986, 1988, 5, 149, 0, 0, 1987, 1986,
		1, 0, 0, 0, 1987, 1988, 1, 0, 0, 0, 1988, 1989, 1, 0, 0, 0, 1989, 1991,
		3, 180, 90, 0, 1990, 1992, 5, 149, 0, 0, 1991, 1990, 1, 0, 0, 0, 1991,
		1992, 1, 0, 0, 0, 1992, 1994, 1, 0, 0, 0, 1993, 1985, 1, 0, 0, 0, 1994,
		1997, 1, 0, 0, 0, 1995, 1993, 1, 0, 0, 0, 1995, 1996, 1, 0, 0, 0, 1996,
		1999, 1, 0, 0, 0, 1997, 1995, 1, 0, 0, 0, 1998, 1981, 1, 0, 0, 0, 1998,
		1999, 1, 0, 0, 0, 1999, 2000, 1, 0, 0, 0, 2000, 2001, 5, 4, 0, 0, 2001,
		243, 1, 0, 0, 0, 2002, 2003, 3, 256, 128, 0, 2003, 2004, 3, 284, 142, 0,
		2004, 245, 1, 0, 0, 0, 2005, 2007, 5, 63, 0, 0, 2006, 2008, 5, 149, 0,
		0, 2007, 2006, 1, 0, 0, 0, 2007, 2008, 1, 0, 0, 0, 2008, 2009, 1, 0, 0,
		0, 2009, 2011, 5, 25, 0, 0, 2010, 2012, 5, 149, 0, 0, 2011, 2010, 1, 0,
		0, 0, 2011, 2012, 1, 0, 0, 0, 2012, 2021, 1, 0, 0, 0, 2013, 2022, 3, 20,
		10, 0, 2014, 2019, 3, 142, 71, 0, 2015, 2017, 5, 149, 0, 0, 2016, 2015,
		1, 0, 0, 0, 2016, 2017, 1, 0, 0, 0, 2017, 2018, 1, 0, 0, 0, 2018, 2020,
		3, 140, 70, 0, 2019, 2016, 1, 0, 0, 0, 2019, 2020, 1, 0, 0, 0, 2020, 2022,
		1, 0, 0, 0, 2021, 2013, 1, 0, 0, 0, 2021, 2014, 1, 0, 0, 0, 2022, 2024,
		1, 0, 0, 0, 2023, 2025, 5, 149, 0, 0, 2024, 2023, 1, 0, 0, 0, 2024, 2025,
		1, 0, 0, 0, 2025, 2026, 1, 0, 0, 0, 2026, 2027, 5, 26, 0, 0, 2027, 247,
		1, 0, 0, 0, 2028, 2030, 3, 254, 127, 0, 2029, 2031, 5, 149, 0, 0, 2030,
		2029, 1, 0, 0, 0, 2030, 2031, 1, 0, 0, 0, 2031, 2032, 1, 0, 0, 0, 2032,
		2034, 5, 3, 0, 0, 2033, 2035, 5, 149, 0, 0, 2034, 2033, 1, 0, 0, 0, 2034,
		2035, 1, 0, 0, 0, 2035, 2053, 1, 0, 0, 0, 2036, 2038, 3, 180, 90, 0, 2037,
		2039, 5, 149, 0, 0, 2038, 2037, 1, 0, 0, 0, 2038, 2039, 1, 0, 0, 0, 2039,
		2050, 1, 0, 0, 0, 2040, 2042, 5, 7, 0, 0, 2041, 2043, 5, 149, 0, 0, 2042,
		2041, 1, 0, 0, 0, 2042, 2043, 1, 0, 0, 0, 2043, 2044, 1, 0, 0, 0, 2044,
		2046, 3, 180, 90, 0, 2045, 2047, 5, 149, 0, 0, 2046, 2045, 1, 0, 0, 0,
		2046, 2047, 1, 0, 0, 0, 2047, 2049, 1, 0, 0, 0, 2048, 2040, 1, 0, 0, 0,
		2049, 2052, 1, 0, 0, 0, 2050, 2048, 1, 0, 0, 0, 2050, 2051, 1, 0, 0, 0,
		2051, 2054, 1, 0, 0, 0, 2052, 2050, 1, 0, 0, 0, 2053, 2036, 1, 0, 0, 0,
		2053, 2054, 1, 0, 0, 0, 2054, 2055, 1, 0, 0, 0, 2055, 2056, 5, 4, 0, 0,
		2056, 249, 1, 0, 0, 0, 2057, 2058, 3, 254, 127, 0, 2058, 251, 1, 0, 0,
		0, 2059, 2060, 3, 284, 142, 0, 2060, 253, 1, 0, 0, 0, 2061, 2062, 3, 256,
		128, 0, 2062, 2063, 3, 284, 142, 0, 2063, 255, 1, 0, 0, 0, 2064, 2065,
		3, 284, 142, 0, 2065, 2066, 5, 24, 0, 0, 2066, 2068, 1, 0, 0, 0, 2067,
		2064, 1, 0, 0, 0, 2068, 2071, 1, 0, 0, 0, 2069, 2067, 1, 0, 0, 0, 2069,
		2070, 1, 0, 0, 0, 2070, 257, 1, 0, 0, 0, 2071, 2069, 1, 0, 0, 0, 2072,
		2073, 3, 284, 142, 0, 2073, 259, 1, 0, 0, 0, 2074, 2081, 3, 262, 131, 0,
		2075, 2081, 5, 109, 0, 0, 2076, 2081, 3, 264, 132, 0, 2077, 2081, 5, 136,
		0, 0, 2078, 2081, 3, 270, 135, 0, 2079, 2081, 3, 272, 136, 0, 2080, 2074,
		1, 0, 0, 0, 2080, 2075, 1, 0, 0, 0, 2080, 2076, 1, 0, 0, 0, 2080, 2077,
		1, 0, 0, 0, 2080, 2078, 1, 0, 0, 0, 2080, 2079, 1, 0, 0, 0, 2081, 261,
		1, 0, 0, 0, 2082, 2083, 7, 3, 0, 0, 2083, 263, 1, 0, 0, 0, 2084, 2087,
		3, 268, 134, 0, 2085, 2087, 3, 266, 133, 0, 2086, 2084, 1, 0, 0, 0, 2086,
		2085, 1, 0, 0, 0, 2087, 265, 1, 0, 0, 0, 2088, 2089, 7, 4, 0, 0, 2089,
		267, 1, 0, 0, 0, 2090, 2091, 7, 5, 0, 0, 2091, 269, 1, 0, 0, 0, 2092, 2094,
		5, 5, 0, 0, 2093, 2095, 5, 149, 0, 0, 2094, 2093, 1, 0, 0, 0, 2094, 2095,
		1, 0, 0, 0, 2095, 2113, 1, 0, 0, 0, 2096, 2098, 3, 180, 90, 0, 2097, 2099,
		5, 149, 0, 0, 2098, 2097, 1, 0, 0, 0, 2098, 2099, 1, 0, 0, 0, 2099, 2110,
		1, 0, 0, 0, 2100, 2102, 5, 7, 0, 0, 2101, 2103, 5, 149, 0, 0, 2102, 2101,
		1, 0, 0, 0, 2102, 2103, 1, 0, 0, 0, 2103, 2104, 1, 0, 0, 0, 2104, 2106,
		3, 180, 90, 0, 2105, 2107, 5, 149, 0, 0, 2106, 2105, 1, 0, 0, 0, 2106,
		2107, 1, 0, 0, 0, 2107, 2109, 1, 0, 0, 0, 2108, 2100, 1, 0, 0, 0, 2109,
		2112, 1, 0, 0, 0, 2110, 2108, 1, 0, 0, 0, 2110, 2111, 1, 0, 0, 0, 2111,
		2114, 1, 0, 0, 0, 2112, 2110, 1, 0, 0, 0, 2113, 2096, 1, 0, 0, 0, 2113,
		2114, 1, 0, 0, 0, 2114, 2115, 1, 0, 0, 0, 2115, 2116, 5, 6, 0, 0, 2116,
		271, 1, 0, 0, 0, 2117, 2119, 5, 25, 0, 0, 2118, 2120, 5, 149, 0, 0, 2119,
		2118, 1, 0, 0, 0, 2119, 2120, 1, 0, 0, 0, 2120, 2154, 1, 0, 0, 0, 2121,
		2123, 3, 274, 137, 0, 2122, 2124, 5, 149, 0, 0, 2123, 2122, 1, 0, 0, 0,
		2123, 2124, 1, 0, 0, 0, 2124, 2125, 1, 0, 0, 0, 2125, 2127, 5, 11, 0, 0,
		2126, 2128, 5, 149, 0, 0, 2127, 2126, 1, 0, 0, 0, 2127, 2128, 1, 0, 0,
		0, 2128, 2129, 1, 0, 0, 0, 2129, 2131, 3, 180, 90, 0, 2130, 2132, 5, 149,
		0, 0, 2131, 2130, 1, 0, 0, 0, 2131, 2132, 1, 0, 0, 0, 2132, 2151, 1, 0,
		0, 0, 2133, 2135, 5, 7, 0, 0, 2134, 2136, 5, 149, 0, 0, 2135, 2134, 1,
		0, 0, 0, 2135, 2136, 1, 0, 0, 0, 2136, 2137, 1, 0, 0, 0, 2137, 2139, 3,
		274, 137, 0, 2138, 2140, 5, 149, 0, 0, 2139, 2138, 1, 0, 0, 0, 2139, 2140,
		1, 0, 0, 0, 2140, 2141, 1, 0, 0, 0, 2141, 2143, 5, 11, 0, 0, 2142, 2144,
		5, 149, 0, 0, 2143, 2142, 1, 0, 0, 0, 2143, 2144, 1, 0, 0, 0, 2144, 2145,
		1, 0, 0, 0, 2145, 2147, 3, 180, 90, 0, 2146, 2148, 5, 149, 0, 0, 2147,
		2146, 1, 0, 0, 0, 2147, 2148, 1, 0, 0, 0, 2148, 2150, 1, 0, 0, 0, 2149,
		2133, 1, 0, 0, 0, 2150, 2153, 1, 0, 0, 0, 2151, 2149, 1, 0, 0, 0, 2151,
		2152, 1, 0, 0, 0, 2152, 2155, 1, 0, 0, 0, 2153, 2151, 1, 0, 0, 0, 2154,
		2121, 1, 0, 0, 0, 2154, 2155, 1, 0, 0, 0, 2155, 2156, 1, 0, 0, 0, 2156,
		2157, 5, 26, 0, 0, 2157, 273, 1, 0, 0, 0, 2158, 2159, 3, 280, 140, 0, 2159,
		275, 1, 0, 0, 0, 2160, 2162, 5, 25, 0, 0, 2161, 2163, 5, 149, 0, 0, 2162,
		2161, 1, 0, 0, 0, 2162, 2163, 1, 0, 0, 0, 2163, 2166, 1, 0, 0, 0, 2164,
		2167, 3, 284, 142, 0, 2165, 2167, 5, 125, 0, 0, 2166, 2164, 1, 0, 0, 0,
		2166, 2165, 1, 0, 0, 0, 2167, 2169, 1, 0, 0, 0, 2168, 2170, 5, 149, 0,
		0, 2169, 2168, 1, 0, 0, 0, 2169, 2170, 1, 0, 0, 0, 2170, 2171, 1, 0, 0,
		0, 2171, 2172, 5, 26, 0, 0, 2172, 277, 1, 0, 0, 0, 2173, 2176, 5, 27, 0,
		0, 2174, 2177, 3, 284, 142, 0, 2175, 2177, 5, 125, 0, 0, 2176, 2174, 1,
		0, 0, 0, 2176, 2175, 1, 0, 0, 0, 2177, 279, 1, 0, 0, 0, 2178, 2181, 3,
		284, 142, 0, 2179, 2181, 3, 282, 141, 0, 2180, 2178, 1, 0, 0, 0, 2180,
		2179, 1, 0, 0, 0, 2181, 281, 1, 0, 0, 0, 2182, 2183, 7, 6, 0, 0, 2183,
		283, 1, 0, 0, 0, 2184, 2185, 7, 7, 0, 0, 2185, 285, 1, 0, 0, 0, 2186, 2187,
		7, 8, 0, 0, 2187, 287, 1, 0, 0, 0, 2188, 2189, 7, 9, 0, 0, 2189, 289, 1,
		0, 0, 0, 2190, 2191, 7, 10, 0, 0, 2191, 291, 1, 0, 0, 0, 365, 293, 298,
		301, 304, 310, 314, 320, 325, 331, 342, 346, 352, 357, 361, 366, 371, 382,
		391, 396, 399, 403, 407, 411, 417, 421, 426, 431, 435, 438, 440, 444, 448,
		453, 457, 462, 466, 477, 484, 494, 532, 543, 550, 564, 571, 577, 587, 591,
		597, 605, 616, 622, 634, 640, 652, 656, 666, 679, 683, 687, 693, 697, 700,
		704, 714, 721, 734, 738, 746, 752, 756, 760, 765, 770, 774, 780, 784, 790,
		794, 800, 804, 808, 812, 816, 820, 825, 832, 836, 841, 848, 852, 856, 864,
		871, 874, 882, 887, 893, 896, 902, 904, 908, 912, 917, 921, 924, 931, 938,
		941, 947, 950, 956, 960, 964, 968, 972, 977, 982, 986, 991, 994, 1003,
		1012, 1017, 1030, 1033, 1036, 1056, 1060, 1065, 1075, 1081, 1085, 1090,
		1094, 1098, 1102, 1108, 1112, 1117, 1123, 1132, 1141, 1149, 1155, 1159,
		1164, 1173, 1177, 1182, 1187, 1191, 1196, 1200, 1212, 1216, 1221, 1228,
		1232, 1237, 1241, 1245, 1247, 1251, 1253, 1257, 1259, 1265, 1271, 1275,
		1278, 1281, 1285, 1291, 1295, 1298, 1301, 1307, 1310, 1313, 1317, 1323,
		1326, 1329, 1333, 1337, 1341, 1343, 1347, 1349, 1352, 1356, 1358, 1365,
		1369, 1375, 1379, 1383, 1386, 1391, 1396, 1401, 1406, 1412, 1416, 1418,
		1422, 1426, 1428, 1430, 1438, 1443, 1454, 1464, 1474, 1479, 1483, 1490,
		1495, 1500, 1505, 1510, 1515, 1520, 1525, 1528, 1534, 1536, 1550, 1553,
		1560, 1574, 1577, 1583, 1587, 1591, 1595, 1598, 1600, 1605, 1609, 1613,
		1617, 1621, 1625, 1628, 1630, 1635, 1639, 1644, 1650, 1653, 1657, 1661,
		1664, 1666, 1670, 1673, 1681, 1685, 1688, 1692, 1702, 1706, 1710, 1724,
		1728, 1733, 1737, 1741, 1746, 1748, 1751, 1755, 1758, 1761, 1767, 1771,
		1775, 1781, 1785, 1789, 1792, 1795, 1801, 1805, 1809, 1811, 1815, 1819,
		1821, 1825, 1829, 1835, 1839, 1843, 1849, 1853, 1857, 1860, 1864, 1868,
		1872, 1886, 1890, 1894, 1900, 1904, 1908, 1914, 1918, 1922, 1928, 1932,
		1936, 1940, 1944, 1947, 1953, 1957, 1969, 1973, 1977, 1979, 1983, 1987,
		1991, 1995, 1998, 2007, 2011, 2016, 2019, 2021, 2024, 2030, 2034, 2038,
		2042, 2046, 2050, 2053, 2069, 2080, 2086, 2094, 2098, 2102, 2106, 2110,
		2113, 2119, 2123, 2127, 2131, 2135, 2139, 2143, 2147, 2151, 2154, 2162,
		2166, 2169, 2176, 2180,
	}
	deserializer := antlr.NewATNDeserializer(nil)
	staticData.atn = deserializer.Deserialize(staticData.serializedATN)
	atn := staticData.atn
	staticData.decisionToDFA = make([]*antlr.DFA, len(atn.DecisionToState))
	decisionToDFA := staticData.decisionToDFA
	for index, state := range atn.DecisionToState {
		decisionToDFA[index] = antlr.NewDFA(state, index)
	}
}

// CypherParserInit initializes any static state used to implement CypherParser. By default the
// static state used to implement the parser is lazily initialized during the first call to
// NewCypherParser(). You can call this function if you wish to initialize the static state ahead
// of time.
func CypherParserInit() {
	staticData := &CypherParserStaticData
	staticData.once.Do(cypherParserInit)
}

// NewCypherParser produces a new parser instance for the optional input antlr.TokenStream.
func NewCypherParser(input antlr.TokenStream) *CypherParser {
	CypherParserInit()
	this := new(CypherParser)
	this.BaseParser = antlr.NewBaseParser(input)
	staticData := &CypherParserStaticData
	this.Interpreter = antlr.NewParserATNSimulator(this, staticData.atn, staticData.decisionToDFA, staticData.PredictionContextCache)
	this.RuleNames = staticData.RuleNames
	this.LiteralNames = staticData.LiteralNames
	this.SymbolicNames = staticData.SymbolicNames
	this.GrammarFileName = "Cypher.g4"

	return this
}

// CypherParser tokens.
const (
	CypherParserEOF                   = antlr.TokenEOF
	CypherParserT__0                  = 1
	CypherParserT__1                  = 2
	CypherParserT__2                  = 3
	CypherParserT__3                  = 4
	CypherParserT__4                  = 5
	CypherParserT__5                  = 6
	CypherParserT__6                  = 7
	CypherParserT__7                  = 8
	CypherParserT__8                  = 9
	CypherParserT__9                  = 10
	CypherParserT__10                 = 11
	CypherParserT__11                 = 12
	CypherParserT__12                 = 13
	CypherParserT__13                 = 14
	CypherParserT__14                 = 15
	CypherParserT__15                 = 16
	CypherParserT__16                 = 17
	CypherParserT__17                 = 18
	CypherParserT__18                 = 19
	CypherParserT__19                 = 20
	CypherParserT__20                 = 21
	CypherParserT__21                 = 22
	CypherParserT__22                 = 23
	CypherParserT__23                 = 24
	CypherParserT__24                 = 25
	CypherParserT__25                 = 26
	CypherParserT__26                 = 27
	CypherParserT__27                 = 28
	CypherParserT__28                 = 29
	CypherParserT__29                 = 30
	CypherParserT__30                 = 31
	CypherParserT__31                 = 32
	CypherParserT__32                 = 33
	CypherParserT__33                 = 34
	CypherParserT__34                 = 35
	CypherParserT__35                 = 36
	CypherParserT__36                 = 37
	CypherParserT__37                 = 38
	CypherParserT__38                 = 39
	CypherParserT__39                 = 40
	CypherParserT__40                 = 41
	CypherParserT__41                 = 42
	CypherParserT__42                 = 43
	CypherParserT__43                 = 44
	CypherParserT__44                 = 45
	CypherParserT__45                 = 46
	CypherParserCYPHER                = 47
	CypherParserEXPLAIN               = 48
	CypherParserPROFILE               = 49
	CypherParserUSING                 = 50
	CypherParserPERIODIC              = 51
	CypherParserCOMMIT                = 52
	CypherParserUNION                 = 53
	CypherParserALL                   = 54
	CypherParserCREATE                = 55
	CypherParserDROP                  = 56
	CypherParserINDEX                 = 57
	CypherParserON                    = 58
	CypherParserCONSTRAINT            = 59
	CypherParserASSERT                = 60
	CypherParserIS                    = 61
	CypherParserUNIQUE                = 62
	CypherParserEXISTS                = 63
	CypherParserLOAD                  = 64
	CypherParserCSV                   = 65
	CypherParserWITH                  = 66
	CypherParserHEADERS               = 67
	CypherParserFROM                  = 68
	CypherParserAS                    = 69
	CypherParserFIELDTERMINATOR       = 70
	CypherParserOPTIONAL              = 71
	CypherParserMATCH                 = 72
	CypherParserUNWIND                = 73
	CypherParserMERGE                 = 74
	CypherParserSET                   = 75
	CypherParserDETACH                = 76
	CypherParserDELETE                = 77
	CypherParserREMOVE                = 78
	CypherParserFOREACH               = 79
	CypherParserIN                    = 80
	CypherParserCALL                  = 81
	CypherParserYIELD                 = 82
	CypherParserRETURN                = 83
	CypherParserDISTINCT              = 84
	CypherParserORDER                 = 85
	CypherParserBY                    = 86
	CypherParserL_SKIP                = 87
	CypherParserLIMIT                 = 88
	CypherParserASCENDING             = 89
	CypherParserASC                   = 90
	CypherParserDESCENDING            = 91
	CypherParserDESC                  = 92
	CypherParserJOIN                  = 93
	CypherParserSCAN                  = 94
	CypherParserSTART                 = 95
	CypherParserNODE                  = 96
	CypherParserRELATIONSHIP          = 97
	CypherParserREL                   = 98
	CypherParserWHERE                 = 99
	CypherParserSHORTESTPATH          = 100
	CypherParserALLSHORTESTPATHS      = 101
	CypherParserOR                    = 102
	CypherParserXOR                   = 103
	CypherParserAND                   = 104
	CypherParserNOT                   = 105
	CypherParserSTARTS                = 106
	CypherParserENDS                  = 107
	CypherParserCONTAINS              = 108
	CypherParserNULL                  = 109
	CypherParserCOUNT                 = 110
	CypherParserCASE                  = 111
	CypherParserELSE                  = 112
	CypherParserEND                   = 113
	CypherParserWHEN                  = 114
	CypherParserTHEN                  = 115
	CypherParserFILTER                = 116
	CypherParserEXTRACT               = 117
	CypherParserREDUCE                = 118
	CypherParserANY                   = 119
	CypherParserNONE                  = 120
	CypherParserSINGLE                = 121
	CypherParserTRUE                  = 122
	CypherParserFALSE                 = 123
	CypherParserHexInteger            = 124
	CypherParserDecimalInteger        = 125
	CypherParserOctalInteger          = 126
	CypherParserHexLetter             = 127
	CypherParserHexDigit              = 128
	CypherParserDigit                 = 129
	CypherParserNonZeroDigit          = 130
	CypherParserNonZeroOctDigit       = 131
	CypherParserOctDigit              = 132
	CypherParserZeroDigit             = 133
	CypherParserExponentDecimalReal   = 134
	CypherParserRegularDecimalReal    = 135
	CypherParserStringLiteral         = 136
	CypherParserEscapedChar           = 137
	CypherParserDO                    = 138
	CypherParserFOR                   = 139
	CypherParserREQUIRE               = 140
	CypherParserMANDATORY             = 141
	CypherParserSCALAR                = 142
	CypherParserOF                    = 143
	CypherParserADD                   = 144
	CypherParserUnescapedSymbolicName = 145
	CypherParserIdentifierStart       = 146
	CypherParserIdentifierPart        = 147
	CypherParserEscapedSymbolicName   = 148
	CypherParserSP                    = 149
	CypherParserWHITESPACE            = 150
	CypherParserComment               = 151
)

// CypherParser rules.
const (
	CypherParserRULE_oC_Cypher                                        = 0
	CypherParserRULE_oC_QueryOptions                                  = 1
	CypherParserRULE_oC_AnyCypherOption                               = 2
	CypherParserRULE_oC_CypherOption                                  = 3
	CypherParserRULE_oC_VersionNumber                                 = 4
	CypherParserRULE_oC_Explain                                       = 5
	CypherParserRULE_oC_Profile                                       = 6
	CypherParserRULE_oC_ConfigurationOption                           = 7
	CypherParserRULE_oC_Statement                                     = 8
	CypherParserRULE_oC_Query                                         = 9
	CypherParserRULE_oC_RegularQuery                                  = 10
	CypherParserRULE_oC_BulkImportQuery                               = 11
	CypherParserRULE_oC_PeriodicCommitHint                            = 12
	CypherParserRULE_oC_LoadCSVQuery                                  = 13
	CypherParserRULE_oC_Union                                         = 14
	CypherParserRULE_oC_SingleQuery                                   = 15
	CypherParserRULE_oC_SinglePartQuery                               = 16
	CypherParserRULE_oC_MultiPartQuery                                = 17
	CypherParserRULE_oC_UpdatingClause                                = 18
	CypherParserRULE_oC_ReadingClause                                 = 19
	CypherParserRULE_oC_Command                                       = 20
	CypherParserRULE_oC_CreateUniqueConstraint                        = 21
	CypherParserRULE_oC_CreateNodePropertyExistenceConstraint         = 22
	CypherParserRULE_oC_CreateRelationshipPropertyExistenceConstraint = 23
	CypherParserRULE_oC_CreateIndex                                   = 24
	CypherParserRULE_oC_DropUniqueConstraint                          = 25
	CypherParserRULE_oC_DropNodePropertyExistenceConstraint           = 26
	CypherParserRULE_oC_DropRelationshipPropertyExistenceConstraint   = 27
	CypherParserRULE_oC_DropIndex                                     = 28
	CypherParserRULE_oC_Index                                         = 29
	CypherParserRULE_oC_UniqueConstraint                              = 30
	CypherParserRULE_oC_NodePropertyExistenceConstraint               = 31
	CypherParserRULE_oC_RelationshipPropertyExistenceConstraint       = 32
	CypherParserRULE_oC_RelationshipPatternSyntax                     = 33
	CypherParserRULE_oC_LoadCSV                                       = 34
	CypherParserRULE_oC_Match                                         = 35
	CypherParserRULE_oC_Unwind                                        = 36
	CypherParserRULE_oC_Merge                                         = 37
	CypherParserRULE_oC_MergeAction                                   = 38
	CypherParserRULE_oC_Create                                        = 39
	CypherParserRULE_oC_CreateUnique                                  = 40
	CypherParserRULE_oC_Set                                           = 41
	CypherParserRULE_oC_SetItem                                       = 42
	CypherParserRULE_oC_Delete                                        = 43
	CypherParserRULE_oC_Remove                                        = 44
	CypherParserRULE_oC_RemoveItem                                    = 45
	CypherParserRULE_oC_Foreach                                       = 46
	CypherParserRULE_oC_InQueryCall                                   = 47
	CypherParserRULE_oC_StandaloneCall                                = 48
	CypherParserRULE_oC_YieldItems                                    = 49
	CypherParserRULE_oC_YieldItem                                     = 50
	CypherParserRULE_oC_With                                          = 51
	CypherParserRULE_oC_Return                                        = 52
	CypherParserRULE_oC_ProjectionBody                                = 53
	CypherParserRULE_oC_ProjectionItems                               = 54
	CypherParserRULE_oC_ProjectionItem                                = 55
	CypherParserRULE_oC_Order                                         = 56
	CypherParserRULE_oC_Skip                                          = 57
	CypherParserRULE_oC_Limit                                         = 58
	CypherParserRULE_oC_SortItem                                      = 59
	CypherParserRULE_oC_Hint                                          = 60
	CypherParserRULE_oC_Start                                         = 61
	CypherParserRULE_oC_StartPoint                                    = 62
	CypherParserRULE_oC_Lookup                                        = 63
	CypherParserRULE_oC_NodeLookup                                    = 64
	CypherParserRULE_oC_RelationshipLookup                            = 65
	CypherParserRULE_oC_IdentifiedIndexLookup                         = 66
	CypherParserRULE_oC_IndexQuery                                    = 67
	CypherParserRULE_oC_IdLookup                                      = 68
	CypherParserRULE_oC_LiteralIds                                    = 69
	CypherParserRULE_oC_Where                                         = 70
	CypherParserRULE_oC_Pattern                                       = 71
	CypherParserRULE_oC_PatternPart                                   = 72
	CypherParserRULE_oC_AnonymousPatternPart                          = 73
	CypherParserRULE_oC_ShortestPathPattern                           = 74
	CypherParserRULE_oC_PatternElement                                = 75
	CypherParserRULE_oC_RelationshipsPattern                          = 76
	CypherParserRULE_oC_NodePattern                                   = 77
	CypherParserRULE_oC_PatternElementChain                           = 78
	CypherParserRULE_oC_RelationshipPattern                           = 79
	CypherParserRULE_oC_RelationshipDetail                            = 80
	CypherParserRULE_oC_Properties                                    = 81
	CypherParserRULE_oC_RelType                                       = 82
	CypherParserRULE_oC_RelationshipTypes                             = 83
	CypherParserRULE_oC_NodeLabels                                    = 84
	CypherParserRULE_oC_NodeLabel                                     = 85
	CypherParserRULE_oC_RangeLiteral                                  = 86
	CypherParserRULE_oC_LabelName                                     = 87
	CypherParserRULE_oC_RelTypeName                                   = 88
	CypherParserRULE_oC_PropertyExpression                            = 89
	CypherParserRULE_oC_Expression                                    = 90
	CypherParserRULE_oC_OrExpression                                  = 91
	CypherParserRULE_oC_XorExpression                                 = 92
	CypherParserRULE_oC_AndExpression                                 = 93
	CypherParserRULE_oC_NotExpression                                 = 94
	CypherParserRULE_oC_ComparisonExpression                          = 95
	CypherParserRULE_oC_PartialComparisonExpression                   = 96
	CypherParserRULE_oC_StringListNullPredicateExpression             = 97
	CypherParserRULE_oC_StringPredicateExpression                     = 98
	CypherParserRULE_oC_ListPredicateExpression                       = 99
	CypherParserRULE_oC_NullPredicateExpression                       = 100
	CypherParserRULE_oC_RegularExpression                             = 101
	CypherParserRULE_oC_AddOrSubtractExpression                       = 102
	CypherParserRULE_oC_MultiplyDivideModuloExpression                = 103
	CypherParserRULE_oC_PowerOfExpression                             = 104
	CypherParserRULE_oC_UnaryAddOrSubtractExpression                  = 105
	CypherParserRULE_oC_NonArithmeticOperatorExpression               = 106
	CypherParserRULE_oC_ListOperatorExpression                        = 107
	CypherParserRULE_oC_PropertyLookup                                = 108
	CypherParserRULE_oC_Atom                                          = 109
	CypherParserRULE_oC_CaseExpression                                = 110
	CypherParserRULE_oC_CaseAlternative                               = 111
	CypherParserRULE_oC_ListComprehension                             = 112
	CypherParserRULE_oC_PatternComprehension                          = 113
	CypherParserRULE_oC_LegacyListExpression                          = 114
	CypherParserRULE_oC_Reduce                                        = 115
	CypherParserRULE_oC_Quantifier                                    = 116
	CypherParserRULE_oC_FilterExpression                              = 117
	CypherParserRULE_oC_PatternPredicate                              = 118
	CypherParserRULE_oC_ParenthesizedExpression                       = 119
	CypherParserRULE_oC_IdInColl                                      = 120
	CypherParserRULE_oC_FunctionInvocation                            = 121
	CypherParserRULE_oC_FunctionName                                  = 122
	CypherParserRULE_oC_ExistentialSubquery                           = 123
	CypherParserRULE_oC_ExplicitProcedureInvocation                   = 124
	CypherParserRULE_oC_ImplicitProcedureInvocation                   = 125
	CypherParserRULE_oC_ProcedureResultField                          = 126
	CypherParserRULE_oC_ProcedureName                                 = 127
	CypherParserRULE_oC_Namespace                                     = 128
	CypherParserRULE_oC_Variable                                      = 129
	CypherParserRULE_oC_Literal                                       = 130
	CypherParserRULE_oC_BooleanLiteral                                = 131
	CypherParserRULE_oC_NumberLiteral                                 = 132
	CypherParserRULE_oC_IntegerLiteral                                = 133
	CypherParserRULE_oC_DoubleLiteral                                 = 134
	CypherParserRULE_oC_ListLiteral                                   = 135
	CypherParserRULE_oC_MapLiteral                                    = 136
	CypherParserRULE_oC_PropertyKeyName                               = 137
	CypherParserRULE_oC_LegacyParameter                               = 138
	CypherParserRULE_oC_Parameter                                     = 139
	CypherParserRULE_oC_SchemaName                                    = 140
	CypherParserRULE_oC_ReservedWord                                  = 141
	CypherParserRULE_oC_SymbolicName                                  = 142
	CypherParserRULE_oC_LeftArrowHead                                 = 143
	CypherParserRULE_oC_RightArrowHead                                = 144
	CypherParserRULE_oC_Dash                                          = 145
)

// IOC_CypherContext is an interface to support dynamic dispatch.
type IOC_CypherContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_QueryOptions() IOC_QueryOptionsContext
	OC_Statement() IOC_StatementContext
	EOF() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_CypherContext differentiates from other interfaces.
	IsOC_CypherContext()
}

type OC_CypherContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_CypherContext() *OC_CypherContext {
	var p = new(OC_CypherContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Cypher
	return p
}

func InitEmptyOC_CypherContext(p *OC_CypherContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Cypher
}

func (*OC_CypherContext) IsOC_CypherContext() {}

func NewOC_CypherContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_CypherContext {
	var p = new(OC_CypherContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Cypher

	return p
}

func (s *OC_CypherContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_CypherContext) OC_QueryOptions() IOC_QueryOptionsContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_QueryOptionsContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_QueryOptionsContext)
}

func (s *OC_CypherContext) OC_Statement() IOC_StatementContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_StatementContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_StatementContext)
}

func (s *OC_CypherContext) EOF() antlr.TerminalNode {
	return s.GetToken(CypherParserEOF, 0)
}

func (s *OC_CypherContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_CypherContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_CypherContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_CypherContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_CypherContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Cypher(s)
	}
}

func (s *OC_CypherContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Cypher(s)
	}
}

func (p *CypherParser) OC_Cypher() (localctx IOC_CypherContext) {
	localctx = NewOC_CypherContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 0, CypherParserRULE_oC_Cypher)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	p.SetState(293)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(292)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(295)
		p.OC_QueryOptions()
	}
	{
		p.SetState(296)
		p.OC_Statement()
	}
	p.SetState(301)
	p.GetErrorHandler().Sync(p)

	if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 2, p.GetParserRuleContext()) == 1 {
		p.SetState(298)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(297)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(300)
			p.Match(CypherParserT__0)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	} else if p.HasError() { // JIM
		goto errorExit
	}
	p.SetState(304)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(303)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(306)
		p.Match(CypherParserEOF)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_QueryOptionsContext is an interface to support dynamic dispatch.
type IOC_QueryOptionsContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllOC_AnyCypherOption() []IOC_AnyCypherOptionContext
	OC_AnyCypherOption(i int) IOC_AnyCypherOptionContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_QueryOptionsContext differentiates from other interfaces.
	IsOC_QueryOptionsContext()
}

type OC_QueryOptionsContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_QueryOptionsContext() *OC_QueryOptionsContext {
	var p = new(OC_QueryOptionsContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_QueryOptions
	return p
}

func InitEmptyOC_QueryOptionsContext(p *OC_QueryOptionsContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_QueryOptions
}

func (*OC_QueryOptionsContext) IsOC_QueryOptionsContext() {}

func NewOC_QueryOptionsContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_QueryOptionsContext {
	var p = new(OC_QueryOptionsContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_QueryOptions

	return p
}

func (s *OC_QueryOptionsContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_QueryOptionsContext) AllOC_AnyCypherOption() []IOC_AnyCypherOptionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_AnyCypherOptionContext); ok {
			len++
		}
	}

	tst := make([]IOC_AnyCypherOptionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_AnyCypherOptionContext); ok {
			tst[i] = t.(IOC_AnyCypherOptionContext)
			i++
		}
	}

	return tst
}

func (s *OC_QueryOptionsContext) OC_AnyCypherOption(i int) IOC_AnyCypherOptionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_AnyCypherOptionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_AnyCypherOptionContext)
}

func (s *OC_QueryOptionsContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_QueryOptionsContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_QueryOptionsContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_QueryOptionsContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_QueryOptionsContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_QueryOptions(s)
	}
}

func (s *OC_QueryOptionsContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_QueryOptions(s)
	}
}

func (p *CypherParser) OC_QueryOptions() (localctx IOC_QueryOptionsContext) {
	localctx = NewOC_QueryOptionsContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 2, CypherParserRULE_oC_QueryOptions)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	p.SetState(314)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	for (int64(_la) & ^0x3f) == 0 && ((int64(1)<<_la)&985162418487296) != 0 {
		{
			p.SetState(308)
			p.OC_AnyCypherOption()
		}
		p.SetState(310)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(309)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}

		p.SetState(316)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_AnyCypherOptionContext is an interface to support dynamic dispatch.
type IOC_AnyCypherOptionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_CypherOption() IOC_CypherOptionContext
	OC_Explain() IOC_ExplainContext
	OC_Profile() IOC_ProfileContext

	// IsOC_AnyCypherOptionContext differentiates from other interfaces.
	IsOC_AnyCypherOptionContext()
}

type OC_AnyCypherOptionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_AnyCypherOptionContext() *OC_AnyCypherOptionContext {
	var p = new(OC_AnyCypherOptionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_AnyCypherOption
	return p
}

func InitEmptyOC_AnyCypherOptionContext(p *OC_AnyCypherOptionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_AnyCypherOption
}

func (*OC_AnyCypherOptionContext) IsOC_AnyCypherOptionContext() {}

func NewOC_AnyCypherOptionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_AnyCypherOptionContext {
	var p = new(OC_AnyCypherOptionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_AnyCypherOption

	return p
}

func (s *OC_AnyCypherOptionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_AnyCypherOptionContext) OC_CypherOption() IOC_CypherOptionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_CypherOptionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_CypherOptionContext)
}

func (s *OC_AnyCypherOptionContext) OC_Explain() IOC_ExplainContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExplainContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExplainContext)
}

func (s *OC_AnyCypherOptionContext) OC_Profile() IOC_ProfileContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ProfileContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ProfileContext)
}

func (s *OC_AnyCypherOptionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_AnyCypherOptionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_AnyCypherOptionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_AnyCypherOption(s)
	}
}

func (s *OC_AnyCypherOptionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_AnyCypherOption(s)
	}
}

func (p *CypherParser) OC_AnyCypherOption() (localctx IOC_AnyCypherOptionContext) {
	localctx = NewOC_AnyCypherOptionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 4, CypherParserRULE_oC_AnyCypherOption)
	p.SetState(320)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetTokenStream().LA(1) {
	case CypherParserCYPHER:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(317)
			p.OC_CypherOption()
		}

	case CypherParserEXPLAIN:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(318)
			p.OC_Explain()
		}

	case CypherParserPROFILE:
		p.EnterOuterAlt(localctx, 3)
		{
			p.SetState(319)
			p.OC_Profile()
		}

	default:
		p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_CypherOptionContext is an interface to support dynamic dispatch.
type IOC_CypherOptionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	CYPHER() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	OC_VersionNumber() IOC_VersionNumberContext
	AllOC_ConfigurationOption() []IOC_ConfigurationOptionContext
	OC_ConfigurationOption(i int) IOC_ConfigurationOptionContext

	// IsOC_CypherOptionContext differentiates from other interfaces.
	IsOC_CypherOptionContext()
}

type OC_CypherOptionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_CypherOptionContext() *OC_CypherOptionContext {
	var p = new(OC_CypherOptionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_CypherOption
	return p
}

func InitEmptyOC_CypherOptionContext(p *OC_CypherOptionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_CypherOption
}

func (*OC_CypherOptionContext) IsOC_CypherOptionContext() {}

func NewOC_CypherOptionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_CypherOptionContext {
	var p = new(OC_CypherOptionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_CypherOption

	return p
}

func (s *OC_CypherOptionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_CypherOptionContext) CYPHER() antlr.TerminalNode {
	return s.GetToken(CypherParserCYPHER, 0)
}

func (s *OC_CypherOptionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_CypherOptionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_CypherOptionContext) OC_VersionNumber() IOC_VersionNumberContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_VersionNumberContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_VersionNumberContext)
}

func (s *OC_CypherOptionContext) AllOC_ConfigurationOption() []IOC_ConfigurationOptionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_ConfigurationOptionContext); ok {
			len++
		}
	}

	tst := make([]IOC_ConfigurationOptionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_ConfigurationOptionContext); ok {
			tst[i] = t.(IOC_ConfigurationOptionContext)
			i++
		}
	}

	return tst
}

func (s *OC_CypherOptionContext) OC_ConfigurationOption(i int) IOC_ConfigurationOptionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ConfigurationOptionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ConfigurationOptionContext)
}

func (s *OC_CypherOptionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_CypherOptionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_CypherOptionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_CypherOption(s)
	}
}

func (s *OC_CypherOptionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_CypherOption(s)
	}
}

func (p *CypherParser) OC_CypherOption() (localctx IOC_CypherOptionContext) {
	localctx = NewOC_CypherOptionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 6, CypherParserRULE_oC_CypherOption)
	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(322)
		p.Match(CypherParserCYPHER)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(325)
	p.GetErrorHandler().Sync(p)

	if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 7, p.GetParserRuleContext()) == 1 {
		{
			p.SetState(323)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(324)
			p.OC_VersionNumber()
		}

	} else if p.HasError() { // JIM
		goto errorExit
	}
	p.SetState(331)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 8, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			{
				p.SetState(327)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			{
				p.SetState(328)
				p.OC_ConfigurationOption()
			}

		}
		p.SetState(333)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 8, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_VersionNumberContext is an interface to support dynamic dispatch.
type IOC_VersionNumberContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	RegularDecimalReal() antlr.TerminalNode

	// IsOC_VersionNumberContext differentiates from other interfaces.
	IsOC_VersionNumberContext()
}

type OC_VersionNumberContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_VersionNumberContext() *OC_VersionNumberContext {
	var p = new(OC_VersionNumberContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_VersionNumber
	return p
}

func InitEmptyOC_VersionNumberContext(p *OC_VersionNumberContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_VersionNumber
}

func (*OC_VersionNumberContext) IsOC_VersionNumberContext() {}

func NewOC_VersionNumberContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_VersionNumberContext {
	var p = new(OC_VersionNumberContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_VersionNumber

	return p
}

func (s *OC_VersionNumberContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_VersionNumberContext) RegularDecimalReal() antlr.TerminalNode {
	return s.GetToken(CypherParserRegularDecimalReal, 0)
}

func (s *OC_VersionNumberContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_VersionNumberContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_VersionNumberContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_VersionNumber(s)
	}
}

func (s *OC_VersionNumberContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_VersionNumber(s)
	}
}

func (p *CypherParser) OC_VersionNumber() (localctx IOC_VersionNumberContext) {
	localctx = NewOC_VersionNumberContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 8, CypherParserRULE_oC_VersionNumber)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(334)
		p.Match(CypherParserRegularDecimalReal)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ExplainContext is an interface to support dynamic dispatch.
type IOC_ExplainContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	EXPLAIN() antlr.TerminalNode

	// IsOC_ExplainContext differentiates from other interfaces.
	IsOC_ExplainContext()
}

type OC_ExplainContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ExplainContext() *OC_ExplainContext {
	var p = new(OC_ExplainContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Explain
	return p
}

func InitEmptyOC_ExplainContext(p *OC_ExplainContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Explain
}

func (*OC_ExplainContext) IsOC_ExplainContext() {}

func NewOC_ExplainContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ExplainContext {
	var p = new(OC_ExplainContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Explain

	return p
}

func (s *OC_ExplainContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ExplainContext) EXPLAIN() antlr.TerminalNode {
	return s.GetToken(CypherParserEXPLAIN, 0)
}

func (s *OC_ExplainContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ExplainContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ExplainContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Explain(s)
	}
}

func (s *OC_ExplainContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Explain(s)
	}
}

func (p *CypherParser) OC_Explain() (localctx IOC_ExplainContext) {
	localctx = NewOC_ExplainContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 10, CypherParserRULE_oC_Explain)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(336)
		p.Match(CypherParserEXPLAIN)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ProfileContext is an interface to support dynamic dispatch.
type IOC_ProfileContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	PROFILE() antlr.TerminalNode

	// IsOC_ProfileContext differentiates from other interfaces.
	IsOC_ProfileContext()
}

type OC_ProfileContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ProfileContext() *OC_ProfileContext {
	var p = new(OC_ProfileContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Profile
	return p
}

func InitEmptyOC_ProfileContext(p *OC_ProfileContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Profile
}

func (*OC_ProfileContext) IsOC_ProfileContext() {}

func NewOC_ProfileContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ProfileContext {
	var p = new(OC_ProfileContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Profile

	return p
}

func (s *OC_ProfileContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ProfileContext) PROFILE() antlr.TerminalNode {
	return s.GetToken(CypherParserPROFILE, 0)
}

func (s *OC_ProfileContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ProfileContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ProfileContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Profile(s)
	}
}

func (s *OC_ProfileContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Profile(s)
	}
}

func (p *CypherParser) OC_Profile() (localctx IOC_ProfileContext) {
	localctx = NewOC_ProfileContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 12, CypherParserRULE_oC_Profile)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(338)
		p.Match(CypherParserPROFILE)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ConfigurationOptionContext is an interface to support dynamic dispatch.
type IOC_ConfigurationOptionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllOC_SymbolicName() []IOC_SymbolicNameContext
	OC_SymbolicName(i int) IOC_SymbolicNameContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_ConfigurationOptionContext differentiates from other interfaces.
	IsOC_ConfigurationOptionContext()
}

type OC_ConfigurationOptionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ConfigurationOptionContext() *OC_ConfigurationOptionContext {
	var p = new(OC_ConfigurationOptionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ConfigurationOption
	return p
}

func InitEmptyOC_ConfigurationOptionContext(p *OC_ConfigurationOptionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ConfigurationOption
}

func (*OC_ConfigurationOptionContext) IsOC_ConfigurationOptionContext() {}

func NewOC_ConfigurationOptionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ConfigurationOptionContext {
	var p = new(OC_ConfigurationOptionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_ConfigurationOption

	return p
}

func (s *OC_ConfigurationOptionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ConfigurationOptionContext) AllOC_SymbolicName() []IOC_SymbolicNameContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_SymbolicNameContext); ok {
			len++
		}
	}

	tst := make([]IOC_SymbolicNameContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_SymbolicNameContext); ok {
			tst[i] = t.(IOC_SymbolicNameContext)
			i++
		}
	}

	return tst
}

func (s *OC_ConfigurationOptionContext) OC_SymbolicName(i int) IOC_SymbolicNameContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SymbolicNameContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SymbolicNameContext)
}

func (s *OC_ConfigurationOptionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_ConfigurationOptionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_ConfigurationOptionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ConfigurationOptionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ConfigurationOptionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_ConfigurationOption(s)
	}
}

func (s *OC_ConfigurationOptionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_ConfigurationOption(s)
	}
}

func (p *CypherParser) OC_ConfigurationOption() (localctx IOC_ConfigurationOptionContext) {
	localctx = NewOC_ConfigurationOptionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 14, CypherParserRULE_oC_ConfigurationOption)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(340)
		p.OC_SymbolicName()
	}
	p.SetState(342)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(341)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(344)
		p.Match(CypherParserT__1)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(346)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(345)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(348)
		p.OC_SymbolicName()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_StatementContext is an interface to support dynamic dispatch.
type IOC_StatementContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_Command() IOC_CommandContext
	OC_Query() IOC_QueryContext

	// IsOC_StatementContext differentiates from other interfaces.
	IsOC_StatementContext()
}

type OC_StatementContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_StatementContext() *OC_StatementContext {
	var p = new(OC_StatementContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Statement
	return p
}

func InitEmptyOC_StatementContext(p *OC_StatementContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Statement
}

func (*OC_StatementContext) IsOC_StatementContext() {}

func NewOC_StatementContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_StatementContext {
	var p = new(OC_StatementContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Statement

	return p
}

func (s *OC_StatementContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_StatementContext) OC_Command() IOC_CommandContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_CommandContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_CommandContext)
}

func (s *OC_StatementContext) OC_Query() IOC_QueryContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_QueryContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_QueryContext)
}

func (s *OC_StatementContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_StatementContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_StatementContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Statement(s)
	}
}

func (s *OC_StatementContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Statement(s)
	}
}

func (p *CypherParser) OC_Statement() (localctx IOC_StatementContext) {
	localctx = NewOC_StatementContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 16, CypherParserRULE_oC_Statement)
	p.SetState(352)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 11, p.GetParserRuleContext()) {
	case 1:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(350)
			p.OC_Command()
		}

	case 2:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(351)
			p.OC_Query()
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_QueryContext is an interface to support dynamic dispatch.
type IOC_QueryContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_RegularQuery() IOC_RegularQueryContext
	OC_StandaloneCall() IOC_StandaloneCallContext
	OC_BulkImportQuery() IOC_BulkImportQueryContext

	// IsOC_QueryContext differentiates from other interfaces.
	IsOC_QueryContext()
}

type OC_QueryContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_QueryContext() *OC_QueryContext {
	var p = new(OC_QueryContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Query
	return p
}

func InitEmptyOC_QueryContext(p *OC_QueryContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Query
}

func (*OC_QueryContext) IsOC_QueryContext() {}

func NewOC_QueryContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_QueryContext {
	var p = new(OC_QueryContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Query

	return p
}

func (s *OC_QueryContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_QueryContext) OC_RegularQuery() IOC_RegularQueryContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_RegularQueryContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_RegularQueryContext)
}

func (s *OC_QueryContext) OC_StandaloneCall() IOC_StandaloneCallContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_StandaloneCallContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_StandaloneCallContext)
}

func (s *OC_QueryContext) OC_BulkImportQuery() IOC_BulkImportQueryContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_BulkImportQueryContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_BulkImportQueryContext)
}

func (s *OC_QueryContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_QueryContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_QueryContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Query(s)
	}
}

func (s *OC_QueryContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Query(s)
	}
}

func (p *CypherParser) OC_Query() (localctx IOC_QueryContext) {
	localctx = NewOC_QueryContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 18, CypherParserRULE_oC_Query)
	p.SetState(357)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 12, p.GetParserRuleContext()) {
	case 1:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(354)
			p.OC_RegularQuery()
		}

	case 2:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(355)
			p.OC_StandaloneCall()
		}

	case 3:
		p.EnterOuterAlt(localctx, 3)
		{
			p.SetState(356)
			p.OC_BulkImportQuery()
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_RegularQueryContext is an interface to support dynamic dispatch.
type IOC_RegularQueryContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_SingleQuery() IOC_SingleQueryContext
	AllOC_Union() []IOC_UnionContext
	OC_Union(i int) IOC_UnionContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_RegularQueryContext differentiates from other interfaces.
	IsOC_RegularQueryContext()
}

type OC_RegularQueryContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_RegularQueryContext() *OC_RegularQueryContext {
	var p = new(OC_RegularQueryContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RegularQuery
	return p
}

func InitEmptyOC_RegularQueryContext(p *OC_RegularQueryContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RegularQuery
}

func (*OC_RegularQueryContext) IsOC_RegularQueryContext() {}

func NewOC_RegularQueryContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_RegularQueryContext {
	var p = new(OC_RegularQueryContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_RegularQuery

	return p
}

func (s *OC_RegularQueryContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_RegularQueryContext) OC_SingleQuery() IOC_SingleQueryContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SingleQueryContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SingleQueryContext)
}

func (s *OC_RegularQueryContext) AllOC_Union() []IOC_UnionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_UnionContext); ok {
			len++
		}
	}

	tst := make([]IOC_UnionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_UnionContext); ok {
			tst[i] = t.(IOC_UnionContext)
			i++
		}
	}

	return tst
}

func (s *OC_RegularQueryContext) OC_Union(i int) IOC_UnionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_UnionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_UnionContext)
}

func (s *OC_RegularQueryContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_RegularQueryContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_RegularQueryContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_RegularQueryContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_RegularQueryContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_RegularQuery(s)
	}
}

func (s *OC_RegularQueryContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_RegularQuery(s)
	}
}

func (p *CypherParser) OC_RegularQuery() (localctx IOC_RegularQueryContext) {
	localctx = NewOC_RegularQueryContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 20, CypherParserRULE_oC_RegularQuery)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(359)
		p.OC_SingleQuery()
	}
	p.SetState(366)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 14, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			p.SetState(361)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(360)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(363)
				p.OC_Union()
			}

		}
		p.SetState(368)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 14, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_BulkImportQueryContext is an interface to support dynamic dispatch.
type IOC_BulkImportQueryContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_PeriodicCommitHint() IOC_PeriodicCommitHintContext
	OC_LoadCSVQuery() IOC_LoadCSVQueryContext
	SP() antlr.TerminalNode

	// IsOC_BulkImportQueryContext differentiates from other interfaces.
	IsOC_BulkImportQueryContext()
}

type OC_BulkImportQueryContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_BulkImportQueryContext() *OC_BulkImportQueryContext {
	var p = new(OC_BulkImportQueryContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_BulkImportQuery
	return p
}

func InitEmptyOC_BulkImportQueryContext(p *OC_BulkImportQueryContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_BulkImportQuery
}

func (*OC_BulkImportQueryContext) IsOC_BulkImportQueryContext() {}

func NewOC_BulkImportQueryContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_BulkImportQueryContext {
	var p = new(OC_BulkImportQueryContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_BulkImportQuery

	return p
}

func (s *OC_BulkImportQueryContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_BulkImportQueryContext) OC_PeriodicCommitHint() IOC_PeriodicCommitHintContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PeriodicCommitHintContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PeriodicCommitHintContext)
}

func (s *OC_BulkImportQueryContext) OC_LoadCSVQuery() IOC_LoadCSVQueryContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_LoadCSVQueryContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_LoadCSVQueryContext)
}

func (s *OC_BulkImportQueryContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_BulkImportQueryContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_BulkImportQueryContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_BulkImportQueryContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_BulkImportQuery(s)
	}
}

func (s *OC_BulkImportQueryContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_BulkImportQuery(s)
	}
}

func (p *CypherParser) OC_BulkImportQuery() (localctx IOC_BulkImportQueryContext) {
	localctx = NewOC_BulkImportQueryContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 22, CypherParserRULE_oC_BulkImportQuery)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(369)
		p.OC_PeriodicCommitHint()
	}
	p.SetState(371)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(370)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(373)
		p.OC_LoadCSVQuery()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_PeriodicCommitHintContext is an interface to support dynamic dispatch.
type IOC_PeriodicCommitHintContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	USING() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	PERIODIC() antlr.TerminalNode
	COMMIT() antlr.TerminalNode
	OC_IntegerLiteral() IOC_IntegerLiteralContext

	// IsOC_PeriodicCommitHintContext differentiates from other interfaces.
	IsOC_PeriodicCommitHintContext()
}

type OC_PeriodicCommitHintContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_PeriodicCommitHintContext() *OC_PeriodicCommitHintContext {
	var p = new(OC_PeriodicCommitHintContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PeriodicCommitHint
	return p
}

func InitEmptyOC_PeriodicCommitHintContext(p *OC_PeriodicCommitHintContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PeriodicCommitHint
}

func (*OC_PeriodicCommitHintContext) IsOC_PeriodicCommitHintContext() {}

func NewOC_PeriodicCommitHintContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_PeriodicCommitHintContext {
	var p = new(OC_PeriodicCommitHintContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_PeriodicCommitHint

	return p
}

func (s *OC_PeriodicCommitHintContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_PeriodicCommitHintContext) USING() antlr.TerminalNode {
	return s.GetToken(CypherParserUSING, 0)
}

func (s *OC_PeriodicCommitHintContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_PeriodicCommitHintContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_PeriodicCommitHintContext) PERIODIC() antlr.TerminalNode {
	return s.GetToken(CypherParserPERIODIC, 0)
}

func (s *OC_PeriodicCommitHintContext) COMMIT() antlr.TerminalNode {
	return s.GetToken(CypherParserCOMMIT, 0)
}

func (s *OC_PeriodicCommitHintContext) OC_IntegerLiteral() IOC_IntegerLiteralContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_IntegerLiteralContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_IntegerLiteralContext)
}

func (s *OC_PeriodicCommitHintContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_PeriodicCommitHintContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_PeriodicCommitHintContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_PeriodicCommitHint(s)
	}
}

func (s *OC_PeriodicCommitHintContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_PeriodicCommitHint(s)
	}
}

func (p *CypherParser) OC_PeriodicCommitHint() (localctx IOC_PeriodicCommitHintContext) {
	localctx = NewOC_PeriodicCommitHintContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 24, CypherParserRULE_oC_PeriodicCommitHint)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(375)
		p.Match(CypherParserUSING)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(376)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(377)
		p.Match(CypherParserPERIODIC)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(378)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(379)
		p.Match(CypherParserCOMMIT)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(382)
	p.GetErrorHandler().Sync(p)

	if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 16, p.GetParserRuleContext()) == 1 {
		{
			p.SetState(380)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(381)
			p.OC_IntegerLiteral()
		}

	} else if p.HasError() { // JIM
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_LoadCSVQueryContext is an interface to support dynamic dispatch.
type IOC_LoadCSVQueryContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_LoadCSV() IOC_LoadCSVContext
	OC_SingleQuery() IOC_SingleQueryContext

	// IsOC_LoadCSVQueryContext differentiates from other interfaces.
	IsOC_LoadCSVQueryContext()
}

type OC_LoadCSVQueryContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_LoadCSVQueryContext() *OC_LoadCSVQueryContext {
	var p = new(OC_LoadCSVQueryContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_LoadCSVQuery
	return p
}

func InitEmptyOC_LoadCSVQueryContext(p *OC_LoadCSVQueryContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_LoadCSVQuery
}

func (*OC_LoadCSVQueryContext) IsOC_LoadCSVQueryContext() {}

func NewOC_LoadCSVQueryContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_LoadCSVQueryContext {
	var p = new(OC_LoadCSVQueryContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_LoadCSVQuery

	return p
}

func (s *OC_LoadCSVQueryContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_LoadCSVQueryContext) OC_LoadCSV() IOC_LoadCSVContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_LoadCSVContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_LoadCSVContext)
}

func (s *OC_LoadCSVQueryContext) OC_SingleQuery() IOC_SingleQueryContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SingleQueryContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SingleQueryContext)
}

func (s *OC_LoadCSVQueryContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_LoadCSVQueryContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_LoadCSVQueryContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_LoadCSVQuery(s)
	}
}

func (s *OC_LoadCSVQueryContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_LoadCSVQuery(s)
	}
}

func (p *CypherParser) OC_LoadCSVQuery() (localctx IOC_LoadCSVQueryContext) {
	localctx = NewOC_LoadCSVQueryContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 26, CypherParserRULE_oC_LoadCSVQuery)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(384)
		p.OC_LoadCSV()
	}
	{
		p.SetState(385)
		p.OC_SingleQuery()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_UnionContext is an interface to support dynamic dispatch.
type IOC_UnionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	UNION() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	ALL() antlr.TerminalNode
	OC_SingleQuery() IOC_SingleQueryContext

	// IsOC_UnionContext differentiates from other interfaces.
	IsOC_UnionContext()
}

type OC_UnionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_UnionContext() *OC_UnionContext {
	var p = new(OC_UnionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Union
	return p
}

func InitEmptyOC_UnionContext(p *OC_UnionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Union
}

func (*OC_UnionContext) IsOC_UnionContext() {}

func NewOC_UnionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_UnionContext {
	var p = new(OC_UnionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Union

	return p
}

func (s *OC_UnionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_UnionContext) UNION() antlr.TerminalNode {
	return s.GetToken(CypherParserUNION, 0)
}

func (s *OC_UnionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_UnionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_UnionContext) ALL() antlr.TerminalNode {
	return s.GetToken(CypherParserALL, 0)
}

func (s *OC_UnionContext) OC_SingleQuery() IOC_SingleQueryContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SingleQueryContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SingleQueryContext)
}

func (s *OC_UnionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_UnionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_UnionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Union(s)
	}
}

func (s *OC_UnionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Union(s)
	}
}

func (p *CypherParser) OC_Union() (localctx IOC_UnionContext) {
	localctx = NewOC_UnionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 28, CypherParserRULE_oC_Union)
	var _la int

	p.SetState(399)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 19, p.GetParserRuleContext()) {
	case 1:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(387)
			p.Match(CypherParserUNION)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(388)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(389)
			p.Match(CypherParserALL)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(391)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(390)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(393)
			p.OC_SingleQuery()
		}

	case 2:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(394)
			p.Match(CypherParserUNION)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(396)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(395)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(398)
			p.OC_SingleQuery()
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_SingleQueryContext is an interface to support dynamic dispatch.
type IOC_SingleQueryContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_SinglePartQuery() IOC_SinglePartQueryContext
	OC_MultiPartQuery() IOC_MultiPartQueryContext

	// IsOC_SingleQueryContext differentiates from other interfaces.
	IsOC_SingleQueryContext()
}

type OC_SingleQueryContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_SingleQueryContext() *OC_SingleQueryContext {
	var p = new(OC_SingleQueryContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_SingleQuery
	return p
}

func InitEmptyOC_SingleQueryContext(p *OC_SingleQueryContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_SingleQuery
}

func (*OC_SingleQueryContext) IsOC_SingleQueryContext() {}

func NewOC_SingleQueryContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_SingleQueryContext {
	var p = new(OC_SingleQueryContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_SingleQuery

	return p
}

func (s *OC_SingleQueryContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_SingleQueryContext) OC_SinglePartQuery() IOC_SinglePartQueryContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SinglePartQueryContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SinglePartQueryContext)
}

func (s *OC_SingleQueryContext) OC_MultiPartQuery() IOC_MultiPartQueryContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_MultiPartQueryContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_MultiPartQueryContext)
}

func (s *OC_SingleQueryContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_SingleQueryContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_SingleQueryContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_SingleQuery(s)
	}
}

func (s *OC_SingleQueryContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_SingleQuery(s)
	}
}

func (p *CypherParser) OC_SingleQuery() (localctx IOC_SingleQueryContext) {
	localctx = NewOC_SingleQueryContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 30, CypherParserRULE_oC_SingleQuery)
	p.SetState(403)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 20, p.GetParserRuleContext()) {
	case 1:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(401)
			p.OC_SinglePartQuery()
		}

	case 2:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(402)
			p.OC_MultiPartQuery()
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_SinglePartQueryContext is an interface to support dynamic dispatch.
type IOC_SinglePartQueryContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_Return() IOC_ReturnContext
	AllOC_ReadingClause() []IOC_ReadingClauseContext
	OC_ReadingClause(i int) IOC_ReadingClauseContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	AllOC_UpdatingClause() []IOC_UpdatingClauseContext
	OC_UpdatingClause(i int) IOC_UpdatingClauseContext

	// IsOC_SinglePartQueryContext differentiates from other interfaces.
	IsOC_SinglePartQueryContext()
}

type OC_SinglePartQueryContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_SinglePartQueryContext() *OC_SinglePartQueryContext {
	var p = new(OC_SinglePartQueryContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_SinglePartQuery
	return p
}

func InitEmptyOC_SinglePartQueryContext(p *OC_SinglePartQueryContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_SinglePartQuery
}

func (*OC_SinglePartQueryContext) IsOC_SinglePartQueryContext() {}

func NewOC_SinglePartQueryContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_SinglePartQueryContext {
	var p = new(OC_SinglePartQueryContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_SinglePartQuery

	return p
}

func (s *OC_SinglePartQueryContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_SinglePartQueryContext) OC_Return() IOC_ReturnContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ReturnContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ReturnContext)
}

func (s *OC_SinglePartQueryContext) AllOC_ReadingClause() []IOC_ReadingClauseContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_ReadingClauseContext); ok {
			len++
		}
	}

	tst := make([]IOC_ReadingClauseContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_ReadingClauseContext); ok {
			tst[i] = t.(IOC_ReadingClauseContext)
			i++
		}
	}

	return tst
}

func (s *OC_SinglePartQueryContext) OC_ReadingClause(i int) IOC_ReadingClauseContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ReadingClauseContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ReadingClauseContext)
}

func (s *OC_SinglePartQueryContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_SinglePartQueryContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_SinglePartQueryContext) AllOC_UpdatingClause() []IOC_UpdatingClauseContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_UpdatingClauseContext); ok {
			len++
		}
	}

	tst := make([]IOC_UpdatingClauseContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_UpdatingClauseContext); ok {
			tst[i] = t.(IOC_UpdatingClauseContext)
			i++
		}
	}

	return tst
}

func (s *OC_SinglePartQueryContext) OC_UpdatingClause(i int) IOC_UpdatingClauseContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_UpdatingClauseContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_UpdatingClauseContext)
}

func (s *OC_SinglePartQueryContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_SinglePartQueryContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_SinglePartQueryContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_SinglePartQuery(s)
	}
}

func (s *OC_SinglePartQueryContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_SinglePartQuery(s)
	}
}

func (p *CypherParser) OC_SinglePartQuery() (localctx IOC_SinglePartQueryContext) {
	localctx = NewOC_SinglePartQueryContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 32, CypherParserRULE_oC_SinglePartQuery)
	var _la int

	var _alt int

	p.SetState(440)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 29, p.GetParserRuleContext()) {
	case 1:
		p.EnterOuterAlt(localctx, 1)
		p.SetState(411)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		for (int64((_la-64)) & ^0x3f) == 0 && ((int64(1)<<(_la-64))&2147615617) != 0 {
			{
				p.SetState(405)
				p.OC_ReadingClause()
			}
			p.SetState(407)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(406)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}

			p.SetState(413)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)
		}
		{
			p.SetState(414)
			p.OC_Return()
		}

	case 2:
		p.EnterOuterAlt(localctx, 2)
		p.SetState(421)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		for (int64((_la-64)) & ^0x3f) == 0 && ((int64(1)<<(_la-64))&2147615617) != 0 {
			{
				p.SetState(415)
				p.OC_ReadingClause()
			}
			p.SetState(417)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(416)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}

			p.SetState(423)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)
		}
		{
			p.SetState(424)
			p.OC_UpdatingClause()
		}
		p.SetState(431)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 26, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
		for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
			if _alt == 1 {
				p.SetState(426)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(425)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(428)
					p.OC_UpdatingClause()
				}

			}
			p.SetState(433)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 26, p.GetParserRuleContext())
			if p.HasError() {
				goto errorExit
			}
		}
		p.SetState(438)
		p.GetErrorHandler().Sync(p)

		if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 28, p.GetParserRuleContext()) == 1 {
			p.SetState(435)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(434)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(437)
				p.OC_Return()
			}

		} else if p.HasError() { // JIM
			goto errorExit
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_MultiPartQueryContext is an interface to support dynamic dispatch.
type IOC_MultiPartQueryContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_SinglePartQuery() IOC_SinglePartQueryContext
	AllOC_With() []IOC_WithContext
	OC_With(i int) IOC_WithContext
	AllOC_ReadingClause() []IOC_ReadingClauseContext
	OC_ReadingClause(i int) IOC_ReadingClauseContext
	AllOC_UpdatingClause() []IOC_UpdatingClauseContext
	OC_UpdatingClause(i int) IOC_UpdatingClauseContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_MultiPartQueryContext differentiates from other interfaces.
	IsOC_MultiPartQueryContext()
}

type OC_MultiPartQueryContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_MultiPartQueryContext() *OC_MultiPartQueryContext {
	var p = new(OC_MultiPartQueryContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_MultiPartQuery
	return p
}

func InitEmptyOC_MultiPartQueryContext(p *OC_MultiPartQueryContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_MultiPartQuery
}

func (*OC_MultiPartQueryContext) IsOC_MultiPartQueryContext() {}

func NewOC_MultiPartQueryContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_MultiPartQueryContext {
	var p = new(OC_MultiPartQueryContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_MultiPartQuery

	return p
}

func (s *OC_MultiPartQueryContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_MultiPartQueryContext) OC_SinglePartQuery() IOC_SinglePartQueryContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SinglePartQueryContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SinglePartQueryContext)
}

func (s *OC_MultiPartQueryContext) AllOC_With() []IOC_WithContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_WithContext); ok {
			len++
		}
	}

	tst := make([]IOC_WithContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_WithContext); ok {
			tst[i] = t.(IOC_WithContext)
			i++
		}
	}

	return tst
}

func (s *OC_MultiPartQueryContext) OC_With(i int) IOC_WithContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_WithContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_WithContext)
}

func (s *OC_MultiPartQueryContext) AllOC_ReadingClause() []IOC_ReadingClauseContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_ReadingClauseContext); ok {
			len++
		}
	}

	tst := make([]IOC_ReadingClauseContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_ReadingClauseContext); ok {
			tst[i] = t.(IOC_ReadingClauseContext)
			i++
		}
	}

	return tst
}

func (s *OC_MultiPartQueryContext) OC_ReadingClause(i int) IOC_ReadingClauseContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ReadingClauseContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ReadingClauseContext)
}

func (s *OC_MultiPartQueryContext) AllOC_UpdatingClause() []IOC_UpdatingClauseContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_UpdatingClauseContext); ok {
			len++
		}
	}

	tst := make([]IOC_UpdatingClauseContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_UpdatingClauseContext); ok {
			tst[i] = t.(IOC_UpdatingClauseContext)
			i++
		}
	}

	return tst
}

func (s *OC_MultiPartQueryContext) OC_UpdatingClause(i int) IOC_UpdatingClauseContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_UpdatingClauseContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_UpdatingClauseContext)
}

func (s *OC_MultiPartQueryContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_MultiPartQueryContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_MultiPartQueryContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_MultiPartQueryContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_MultiPartQueryContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_MultiPartQuery(s)
	}
}

func (s *OC_MultiPartQueryContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_MultiPartQuery(s)
	}
}

func (p *CypherParser) OC_MultiPartQuery() (localctx IOC_MultiPartQueryContext) {
	localctx = NewOC_MultiPartQueryContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 34, CypherParserRULE_oC_MultiPartQuery)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	p.SetState(464)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = 1
	for ok := true; ok; ok = _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		switch _alt {
		case 1:
			p.SetState(448)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			for (int64((_la-64)) & ^0x3f) == 0 && ((int64(1)<<(_la-64))&2147615617) != 0 {
				{
					p.SetState(442)
					p.OC_ReadingClause()
				}
				p.SetState(444)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(443)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}

				p.SetState(450)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)
			}
			p.SetState(457)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			for (int64((_la-55)) & ^0x3f) == 0 && ((int64(1)<<(_la-55))&33030145) != 0 {
				{
					p.SetState(451)
					p.OC_UpdatingClause()
				}
				p.SetState(453)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(452)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}

				p.SetState(459)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)
			}
			{
				p.SetState(460)
				p.OC_With()
			}
			p.SetState(462)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(461)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}

		default:
			p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
			goto errorExit
		}

		p.SetState(466)
		p.GetErrorHandler().Sync(p)
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 35, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}
	{
		p.SetState(468)
		p.OC_SinglePartQuery()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_UpdatingClauseContext is an interface to support dynamic dispatch.
type IOC_UpdatingClauseContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_Create() IOC_CreateContext
	OC_Merge() IOC_MergeContext
	OC_CreateUnique() IOC_CreateUniqueContext
	OC_Foreach() IOC_ForeachContext
	OC_Delete() IOC_DeleteContext
	OC_Set() IOC_SetContext
	OC_Remove() IOC_RemoveContext

	// IsOC_UpdatingClauseContext differentiates from other interfaces.
	IsOC_UpdatingClauseContext()
}

type OC_UpdatingClauseContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_UpdatingClauseContext() *OC_UpdatingClauseContext {
	var p = new(OC_UpdatingClauseContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_UpdatingClause
	return p
}

func InitEmptyOC_UpdatingClauseContext(p *OC_UpdatingClauseContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_UpdatingClause
}

func (*OC_UpdatingClauseContext) IsOC_UpdatingClauseContext() {}

func NewOC_UpdatingClauseContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_UpdatingClauseContext {
	var p = new(OC_UpdatingClauseContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_UpdatingClause

	return p
}

func (s *OC_UpdatingClauseContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_UpdatingClauseContext) OC_Create() IOC_CreateContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_CreateContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_CreateContext)
}

func (s *OC_UpdatingClauseContext) OC_Merge() IOC_MergeContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_MergeContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_MergeContext)
}

func (s *OC_UpdatingClauseContext) OC_CreateUnique() IOC_CreateUniqueContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_CreateUniqueContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_CreateUniqueContext)
}

func (s *OC_UpdatingClauseContext) OC_Foreach() IOC_ForeachContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ForeachContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ForeachContext)
}

func (s *OC_UpdatingClauseContext) OC_Delete() IOC_DeleteContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_DeleteContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_DeleteContext)
}

func (s *OC_UpdatingClauseContext) OC_Set() IOC_SetContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SetContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SetContext)
}

func (s *OC_UpdatingClauseContext) OC_Remove() IOC_RemoveContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_RemoveContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_RemoveContext)
}

func (s *OC_UpdatingClauseContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_UpdatingClauseContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_UpdatingClauseContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_UpdatingClause(s)
	}
}

func (s *OC_UpdatingClauseContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_UpdatingClause(s)
	}
}

func (p *CypherParser) OC_UpdatingClause() (localctx IOC_UpdatingClauseContext) {
	localctx = NewOC_UpdatingClauseContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 36, CypherParserRULE_oC_UpdatingClause)
	p.SetState(477)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 36, p.GetParserRuleContext()) {
	case 1:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(470)
			p.OC_Create()
		}

	case 2:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(471)
			p.OC_Merge()
		}

	case 3:
		p.EnterOuterAlt(localctx, 3)
		{
			p.SetState(472)
			p.OC_CreateUnique()
		}

	case 4:
		p.EnterOuterAlt(localctx, 4)
		{
			p.SetState(473)
			p.OC_Foreach()
		}

	case 5:
		p.EnterOuterAlt(localctx, 5)
		{
			p.SetState(474)
			p.OC_Delete()
		}

	case 6:
		p.EnterOuterAlt(localctx, 6)
		{
			p.SetState(475)
			p.OC_Set()
		}

	case 7:
		p.EnterOuterAlt(localctx, 7)
		{
			p.SetState(476)
			p.OC_Remove()
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ReadingClauseContext is an interface to support dynamic dispatch.
type IOC_ReadingClauseContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_LoadCSV() IOC_LoadCSVContext
	OC_Start() IOC_StartContext
	OC_Match() IOC_MatchContext
	OC_Unwind() IOC_UnwindContext
	OC_InQueryCall() IOC_InQueryCallContext

	// IsOC_ReadingClauseContext differentiates from other interfaces.
	IsOC_ReadingClauseContext()
}

type OC_ReadingClauseContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ReadingClauseContext() *OC_ReadingClauseContext {
	var p = new(OC_ReadingClauseContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ReadingClause
	return p
}

func InitEmptyOC_ReadingClauseContext(p *OC_ReadingClauseContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ReadingClause
}

func (*OC_ReadingClauseContext) IsOC_ReadingClauseContext() {}

func NewOC_ReadingClauseContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ReadingClauseContext {
	var p = new(OC_ReadingClauseContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_ReadingClause

	return p
}

func (s *OC_ReadingClauseContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ReadingClauseContext) OC_LoadCSV() IOC_LoadCSVContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_LoadCSVContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_LoadCSVContext)
}

func (s *OC_ReadingClauseContext) OC_Start() IOC_StartContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_StartContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_StartContext)
}

func (s *OC_ReadingClauseContext) OC_Match() IOC_MatchContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_MatchContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_MatchContext)
}

func (s *OC_ReadingClauseContext) OC_Unwind() IOC_UnwindContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_UnwindContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_UnwindContext)
}

func (s *OC_ReadingClauseContext) OC_InQueryCall() IOC_InQueryCallContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_InQueryCallContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_InQueryCallContext)
}

func (s *OC_ReadingClauseContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ReadingClauseContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ReadingClauseContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_ReadingClause(s)
	}
}

func (s *OC_ReadingClauseContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_ReadingClause(s)
	}
}

func (p *CypherParser) OC_ReadingClause() (localctx IOC_ReadingClauseContext) {
	localctx = NewOC_ReadingClauseContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 38, CypherParserRULE_oC_ReadingClause)
	p.SetState(484)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetTokenStream().LA(1) {
	case CypherParserLOAD:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(479)
			p.OC_LoadCSV()
		}

	case CypherParserSTART:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(480)
			p.OC_Start()
		}

	case CypherParserOPTIONAL, CypherParserMATCH:
		p.EnterOuterAlt(localctx, 3)
		{
			p.SetState(481)
			p.OC_Match()
		}

	case CypherParserUNWIND:
		p.EnterOuterAlt(localctx, 4)
		{
			p.SetState(482)
			p.OC_Unwind()
		}

	case CypherParserCALL:
		p.EnterOuterAlt(localctx, 5)
		{
			p.SetState(483)
			p.OC_InQueryCall()
		}

	default:
		p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_CommandContext is an interface to support dynamic dispatch.
type IOC_CommandContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_CreateIndex() IOC_CreateIndexContext
	OC_DropIndex() IOC_DropIndexContext
	OC_CreateUniqueConstraint() IOC_CreateUniqueConstraintContext
	OC_DropUniqueConstraint() IOC_DropUniqueConstraintContext
	OC_CreateNodePropertyExistenceConstraint() IOC_CreateNodePropertyExistenceConstraintContext
	OC_DropNodePropertyExistenceConstraint() IOC_DropNodePropertyExistenceConstraintContext
	OC_CreateRelationshipPropertyExistenceConstraint() IOC_CreateRelationshipPropertyExistenceConstraintContext
	OC_DropRelationshipPropertyExistenceConstraint() IOC_DropRelationshipPropertyExistenceConstraintContext

	// IsOC_CommandContext differentiates from other interfaces.
	IsOC_CommandContext()
}

type OC_CommandContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_CommandContext() *OC_CommandContext {
	var p = new(OC_CommandContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Command
	return p
}

func InitEmptyOC_CommandContext(p *OC_CommandContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Command
}

func (*OC_CommandContext) IsOC_CommandContext() {}

func NewOC_CommandContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_CommandContext {
	var p = new(OC_CommandContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Command

	return p
}

func (s *OC_CommandContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_CommandContext) OC_CreateIndex() IOC_CreateIndexContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_CreateIndexContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_CreateIndexContext)
}

func (s *OC_CommandContext) OC_DropIndex() IOC_DropIndexContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_DropIndexContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_DropIndexContext)
}

func (s *OC_CommandContext) OC_CreateUniqueConstraint() IOC_CreateUniqueConstraintContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_CreateUniqueConstraintContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_CreateUniqueConstraintContext)
}

func (s *OC_CommandContext) OC_DropUniqueConstraint() IOC_DropUniqueConstraintContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_DropUniqueConstraintContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_DropUniqueConstraintContext)
}

func (s *OC_CommandContext) OC_CreateNodePropertyExistenceConstraint() IOC_CreateNodePropertyExistenceConstraintContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_CreateNodePropertyExistenceConstraintContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_CreateNodePropertyExistenceConstraintContext)
}

func (s *OC_CommandContext) OC_DropNodePropertyExistenceConstraint() IOC_DropNodePropertyExistenceConstraintContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_DropNodePropertyExistenceConstraintContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_DropNodePropertyExistenceConstraintContext)
}

func (s *OC_CommandContext) OC_CreateRelationshipPropertyExistenceConstraint() IOC_CreateRelationshipPropertyExistenceConstraintContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_CreateRelationshipPropertyExistenceConstraintContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_CreateRelationshipPropertyExistenceConstraintContext)
}

func (s *OC_CommandContext) OC_DropRelationshipPropertyExistenceConstraint() IOC_DropRelationshipPropertyExistenceConstraintContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_DropRelationshipPropertyExistenceConstraintContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_DropRelationshipPropertyExistenceConstraintContext)
}

func (s *OC_CommandContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_CommandContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_CommandContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Command(s)
	}
}

func (s *OC_CommandContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Command(s)
	}
}

func (p *CypherParser) OC_Command() (localctx IOC_CommandContext) {
	localctx = NewOC_CommandContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 40, CypherParserRULE_oC_Command)
	p.SetState(494)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 38, p.GetParserRuleContext()) {
	case 1:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(486)
			p.OC_CreateIndex()
		}

	case 2:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(487)
			p.OC_DropIndex()
		}

	case 3:
		p.EnterOuterAlt(localctx, 3)
		{
			p.SetState(488)
			p.OC_CreateUniqueConstraint()
		}

	case 4:
		p.EnterOuterAlt(localctx, 4)
		{
			p.SetState(489)
			p.OC_DropUniqueConstraint()
		}

	case 5:
		p.EnterOuterAlt(localctx, 5)
		{
			p.SetState(490)
			p.OC_CreateNodePropertyExistenceConstraint()
		}

	case 6:
		p.EnterOuterAlt(localctx, 6)
		{
			p.SetState(491)
			p.OC_DropNodePropertyExistenceConstraint()
		}

	case 7:
		p.EnterOuterAlt(localctx, 7)
		{
			p.SetState(492)
			p.OC_CreateRelationshipPropertyExistenceConstraint()
		}

	case 8:
		p.EnterOuterAlt(localctx, 8)
		{
			p.SetState(493)
			p.OC_DropRelationshipPropertyExistenceConstraint()
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_CreateUniqueConstraintContext is an interface to support dynamic dispatch.
type IOC_CreateUniqueConstraintContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	CREATE() antlr.TerminalNode
	SP() antlr.TerminalNode
	OC_UniqueConstraint() IOC_UniqueConstraintContext

	// IsOC_CreateUniqueConstraintContext differentiates from other interfaces.
	IsOC_CreateUniqueConstraintContext()
}

type OC_CreateUniqueConstraintContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_CreateUniqueConstraintContext() *OC_CreateUniqueConstraintContext {
	var p = new(OC_CreateUniqueConstraintContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_CreateUniqueConstraint
	return p
}

func InitEmptyOC_CreateUniqueConstraintContext(p *OC_CreateUniqueConstraintContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_CreateUniqueConstraint
}

func (*OC_CreateUniqueConstraintContext) IsOC_CreateUniqueConstraintContext() {}

func NewOC_CreateUniqueConstraintContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_CreateUniqueConstraintContext {
	var p = new(OC_CreateUniqueConstraintContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_CreateUniqueConstraint

	return p
}

func (s *OC_CreateUniqueConstraintContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_CreateUniqueConstraintContext) CREATE() antlr.TerminalNode {
	return s.GetToken(CypherParserCREATE, 0)
}

func (s *OC_CreateUniqueConstraintContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_CreateUniqueConstraintContext) OC_UniqueConstraint() IOC_UniqueConstraintContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_UniqueConstraintContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_UniqueConstraintContext)
}

func (s *OC_CreateUniqueConstraintContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_CreateUniqueConstraintContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_CreateUniqueConstraintContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_CreateUniqueConstraint(s)
	}
}

func (s *OC_CreateUniqueConstraintContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_CreateUniqueConstraint(s)
	}
}

func (p *CypherParser) OC_CreateUniqueConstraint() (localctx IOC_CreateUniqueConstraintContext) {
	localctx = NewOC_CreateUniqueConstraintContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 42, CypherParserRULE_oC_CreateUniqueConstraint)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(496)
		p.Match(CypherParserCREATE)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(497)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(498)
		p.OC_UniqueConstraint()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_CreateNodePropertyExistenceConstraintContext is an interface to support dynamic dispatch.
type IOC_CreateNodePropertyExistenceConstraintContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	CREATE() antlr.TerminalNode
	SP() antlr.TerminalNode
	OC_NodePropertyExistenceConstraint() IOC_NodePropertyExistenceConstraintContext

	// IsOC_CreateNodePropertyExistenceConstraintContext differentiates from other interfaces.
	IsOC_CreateNodePropertyExistenceConstraintContext()
}

type OC_CreateNodePropertyExistenceConstraintContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_CreateNodePropertyExistenceConstraintContext() *OC_CreateNodePropertyExistenceConstraintContext {
	var p = new(OC_CreateNodePropertyExistenceConstraintContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_CreateNodePropertyExistenceConstraint
	return p
}

func InitEmptyOC_CreateNodePropertyExistenceConstraintContext(p *OC_CreateNodePropertyExistenceConstraintContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_CreateNodePropertyExistenceConstraint
}

func (*OC_CreateNodePropertyExistenceConstraintContext) IsOC_CreateNodePropertyExistenceConstraintContext() {
}

func NewOC_CreateNodePropertyExistenceConstraintContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_CreateNodePropertyExistenceConstraintContext {
	var p = new(OC_CreateNodePropertyExistenceConstraintContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_CreateNodePropertyExistenceConstraint

	return p
}

func (s *OC_CreateNodePropertyExistenceConstraintContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_CreateNodePropertyExistenceConstraintContext) CREATE() antlr.TerminalNode {
	return s.GetToken(CypherParserCREATE, 0)
}

func (s *OC_CreateNodePropertyExistenceConstraintContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_CreateNodePropertyExistenceConstraintContext) OC_NodePropertyExistenceConstraint() IOC_NodePropertyExistenceConstraintContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NodePropertyExistenceConstraintContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NodePropertyExistenceConstraintContext)
}

func (s *OC_CreateNodePropertyExistenceConstraintContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_CreateNodePropertyExistenceConstraintContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_CreateNodePropertyExistenceConstraintContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_CreateNodePropertyExistenceConstraint(s)
	}
}

func (s *OC_CreateNodePropertyExistenceConstraintContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_CreateNodePropertyExistenceConstraint(s)
	}
}

func (p *CypherParser) OC_CreateNodePropertyExistenceConstraint() (localctx IOC_CreateNodePropertyExistenceConstraintContext) {
	localctx = NewOC_CreateNodePropertyExistenceConstraintContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 44, CypherParserRULE_oC_CreateNodePropertyExistenceConstraint)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(500)
		p.Match(CypherParserCREATE)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(501)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(502)
		p.OC_NodePropertyExistenceConstraint()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_CreateRelationshipPropertyExistenceConstraintContext is an interface to support dynamic dispatch.
type IOC_CreateRelationshipPropertyExistenceConstraintContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	CREATE() antlr.TerminalNode
	SP() antlr.TerminalNode
	OC_RelationshipPropertyExistenceConstraint() IOC_RelationshipPropertyExistenceConstraintContext

	// IsOC_CreateRelationshipPropertyExistenceConstraintContext differentiates from other interfaces.
	IsOC_CreateRelationshipPropertyExistenceConstraintContext()
}

type OC_CreateRelationshipPropertyExistenceConstraintContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_CreateRelationshipPropertyExistenceConstraintContext() *OC_CreateRelationshipPropertyExistenceConstraintContext {
	var p = new(OC_CreateRelationshipPropertyExistenceConstraintContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_CreateRelationshipPropertyExistenceConstraint
	return p
}

func InitEmptyOC_CreateRelationshipPropertyExistenceConstraintContext(p *OC_CreateRelationshipPropertyExistenceConstraintContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_CreateRelationshipPropertyExistenceConstraint
}

func (*OC_CreateRelationshipPropertyExistenceConstraintContext) IsOC_CreateRelationshipPropertyExistenceConstraintContext() {
}

func NewOC_CreateRelationshipPropertyExistenceConstraintContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_CreateRelationshipPropertyExistenceConstraintContext {
	var p = new(OC_CreateRelationshipPropertyExistenceConstraintContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_CreateRelationshipPropertyExistenceConstraint

	return p
}

func (s *OC_CreateRelationshipPropertyExistenceConstraintContext) GetParser() antlr.Parser {
	return s.parser
}

func (s *OC_CreateRelationshipPropertyExistenceConstraintContext) CREATE() antlr.TerminalNode {
	return s.GetToken(CypherParserCREATE, 0)
}

func (s *OC_CreateRelationshipPropertyExistenceConstraintContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_CreateRelationshipPropertyExistenceConstraintContext) OC_RelationshipPropertyExistenceConstraint() IOC_RelationshipPropertyExistenceConstraintContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_RelationshipPropertyExistenceConstraintContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_RelationshipPropertyExistenceConstraintContext)
}

func (s *OC_CreateRelationshipPropertyExistenceConstraintContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_CreateRelationshipPropertyExistenceConstraintContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_CreateRelationshipPropertyExistenceConstraintContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_CreateRelationshipPropertyExistenceConstraint(s)
	}
}

func (s *OC_CreateRelationshipPropertyExistenceConstraintContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_CreateRelationshipPropertyExistenceConstraint(s)
	}
}

func (p *CypherParser) OC_CreateRelationshipPropertyExistenceConstraint() (localctx IOC_CreateRelationshipPropertyExistenceConstraintContext) {
	localctx = NewOC_CreateRelationshipPropertyExistenceConstraintContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 46, CypherParserRULE_oC_CreateRelationshipPropertyExistenceConstraint)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(504)
		p.Match(CypherParserCREATE)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(505)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(506)
		p.OC_RelationshipPropertyExistenceConstraint()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_CreateIndexContext is an interface to support dynamic dispatch.
type IOC_CreateIndexContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	CREATE() antlr.TerminalNode
	SP() antlr.TerminalNode
	OC_Index() IOC_IndexContext

	// IsOC_CreateIndexContext differentiates from other interfaces.
	IsOC_CreateIndexContext()
}

type OC_CreateIndexContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_CreateIndexContext() *OC_CreateIndexContext {
	var p = new(OC_CreateIndexContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_CreateIndex
	return p
}

func InitEmptyOC_CreateIndexContext(p *OC_CreateIndexContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_CreateIndex
}

func (*OC_CreateIndexContext) IsOC_CreateIndexContext() {}

func NewOC_CreateIndexContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_CreateIndexContext {
	var p = new(OC_CreateIndexContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_CreateIndex

	return p
}

func (s *OC_CreateIndexContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_CreateIndexContext) CREATE() antlr.TerminalNode {
	return s.GetToken(CypherParserCREATE, 0)
}

func (s *OC_CreateIndexContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_CreateIndexContext) OC_Index() IOC_IndexContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_IndexContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_IndexContext)
}

func (s *OC_CreateIndexContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_CreateIndexContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_CreateIndexContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_CreateIndex(s)
	}
}

func (s *OC_CreateIndexContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_CreateIndex(s)
	}
}

func (p *CypherParser) OC_CreateIndex() (localctx IOC_CreateIndexContext) {
	localctx = NewOC_CreateIndexContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 48, CypherParserRULE_oC_CreateIndex)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(508)
		p.Match(CypherParserCREATE)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(509)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(510)
		p.OC_Index()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_DropUniqueConstraintContext is an interface to support dynamic dispatch.
type IOC_DropUniqueConstraintContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	DROP() antlr.TerminalNode
	SP() antlr.TerminalNode
	OC_UniqueConstraint() IOC_UniqueConstraintContext

	// IsOC_DropUniqueConstraintContext differentiates from other interfaces.
	IsOC_DropUniqueConstraintContext()
}

type OC_DropUniqueConstraintContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_DropUniqueConstraintContext() *OC_DropUniqueConstraintContext {
	var p = new(OC_DropUniqueConstraintContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_DropUniqueConstraint
	return p
}

func InitEmptyOC_DropUniqueConstraintContext(p *OC_DropUniqueConstraintContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_DropUniqueConstraint
}

func (*OC_DropUniqueConstraintContext) IsOC_DropUniqueConstraintContext() {}

func NewOC_DropUniqueConstraintContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_DropUniqueConstraintContext {
	var p = new(OC_DropUniqueConstraintContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_DropUniqueConstraint

	return p
}

func (s *OC_DropUniqueConstraintContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_DropUniqueConstraintContext) DROP() antlr.TerminalNode {
	return s.GetToken(CypherParserDROP, 0)
}

func (s *OC_DropUniqueConstraintContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_DropUniqueConstraintContext) OC_UniqueConstraint() IOC_UniqueConstraintContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_UniqueConstraintContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_UniqueConstraintContext)
}

func (s *OC_DropUniqueConstraintContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_DropUniqueConstraintContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_DropUniqueConstraintContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_DropUniqueConstraint(s)
	}
}

func (s *OC_DropUniqueConstraintContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_DropUniqueConstraint(s)
	}
}

func (p *CypherParser) OC_DropUniqueConstraint() (localctx IOC_DropUniqueConstraintContext) {
	localctx = NewOC_DropUniqueConstraintContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 50, CypherParserRULE_oC_DropUniqueConstraint)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(512)
		p.Match(CypherParserDROP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(513)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(514)
		p.OC_UniqueConstraint()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_DropNodePropertyExistenceConstraintContext is an interface to support dynamic dispatch.
type IOC_DropNodePropertyExistenceConstraintContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	DROP() antlr.TerminalNode
	SP() antlr.TerminalNode
	OC_NodePropertyExistenceConstraint() IOC_NodePropertyExistenceConstraintContext

	// IsOC_DropNodePropertyExistenceConstraintContext differentiates from other interfaces.
	IsOC_DropNodePropertyExistenceConstraintContext()
}

type OC_DropNodePropertyExistenceConstraintContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_DropNodePropertyExistenceConstraintContext() *OC_DropNodePropertyExistenceConstraintContext {
	var p = new(OC_DropNodePropertyExistenceConstraintContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_DropNodePropertyExistenceConstraint
	return p
}

func InitEmptyOC_DropNodePropertyExistenceConstraintContext(p *OC_DropNodePropertyExistenceConstraintContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_DropNodePropertyExistenceConstraint
}

func (*OC_DropNodePropertyExistenceConstraintContext) IsOC_DropNodePropertyExistenceConstraintContext() {
}

func NewOC_DropNodePropertyExistenceConstraintContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_DropNodePropertyExistenceConstraintContext {
	var p = new(OC_DropNodePropertyExistenceConstraintContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_DropNodePropertyExistenceConstraint

	return p
}

func (s *OC_DropNodePropertyExistenceConstraintContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_DropNodePropertyExistenceConstraintContext) DROP() antlr.TerminalNode {
	return s.GetToken(CypherParserDROP, 0)
}

func (s *OC_DropNodePropertyExistenceConstraintContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_DropNodePropertyExistenceConstraintContext) OC_NodePropertyExistenceConstraint() IOC_NodePropertyExistenceConstraintContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NodePropertyExistenceConstraintContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NodePropertyExistenceConstraintContext)
}

func (s *OC_DropNodePropertyExistenceConstraintContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_DropNodePropertyExistenceConstraintContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_DropNodePropertyExistenceConstraintContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_DropNodePropertyExistenceConstraint(s)
	}
}

func (s *OC_DropNodePropertyExistenceConstraintContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_DropNodePropertyExistenceConstraint(s)
	}
}

func (p *CypherParser) OC_DropNodePropertyExistenceConstraint() (localctx IOC_DropNodePropertyExistenceConstraintContext) {
	localctx = NewOC_DropNodePropertyExistenceConstraintContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 52, CypherParserRULE_oC_DropNodePropertyExistenceConstraint)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(516)
		p.Match(CypherParserDROP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(517)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(518)
		p.OC_NodePropertyExistenceConstraint()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_DropRelationshipPropertyExistenceConstraintContext is an interface to support dynamic dispatch.
type IOC_DropRelationshipPropertyExistenceConstraintContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	DROP() antlr.TerminalNode
	SP() antlr.TerminalNode
	OC_RelationshipPropertyExistenceConstraint() IOC_RelationshipPropertyExistenceConstraintContext

	// IsOC_DropRelationshipPropertyExistenceConstraintContext differentiates from other interfaces.
	IsOC_DropRelationshipPropertyExistenceConstraintContext()
}

type OC_DropRelationshipPropertyExistenceConstraintContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_DropRelationshipPropertyExistenceConstraintContext() *OC_DropRelationshipPropertyExistenceConstraintContext {
	var p = new(OC_DropRelationshipPropertyExistenceConstraintContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_DropRelationshipPropertyExistenceConstraint
	return p
}

func InitEmptyOC_DropRelationshipPropertyExistenceConstraintContext(p *OC_DropRelationshipPropertyExistenceConstraintContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_DropRelationshipPropertyExistenceConstraint
}

func (*OC_DropRelationshipPropertyExistenceConstraintContext) IsOC_DropRelationshipPropertyExistenceConstraintContext() {
}

func NewOC_DropRelationshipPropertyExistenceConstraintContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_DropRelationshipPropertyExistenceConstraintContext {
	var p = new(OC_DropRelationshipPropertyExistenceConstraintContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_DropRelationshipPropertyExistenceConstraint

	return p
}

func (s *OC_DropRelationshipPropertyExistenceConstraintContext) GetParser() antlr.Parser {
	return s.parser
}

func (s *OC_DropRelationshipPropertyExistenceConstraintContext) DROP() antlr.TerminalNode {
	return s.GetToken(CypherParserDROP, 0)
}

func (s *OC_DropRelationshipPropertyExistenceConstraintContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_DropRelationshipPropertyExistenceConstraintContext) OC_RelationshipPropertyExistenceConstraint() IOC_RelationshipPropertyExistenceConstraintContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_RelationshipPropertyExistenceConstraintContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_RelationshipPropertyExistenceConstraintContext)
}

func (s *OC_DropRelationshipPropertyExistenceConstraintContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_DropRelationshipPropertyExistenceConstraintContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_DropRelationshipPropertyExistenceConstraintContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_DropRelationshipPropertyExistenceConstraint(s)
	}
}

func (s *OC_DropRelationshipPropertyExistenceConstraintContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_DropRelationshipPropertyExistenceConstraint(s)
	}
}

func (p *CypherParser) OC_DropRelationshipPropertyExistenceConstraint() (localctx IOC_DropRelationshipPropertyExistenceConstraintContext) {
	localctx = NewOC_DropRelationshipPropertyExistenceConstraintContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 54, CypherParserRULE_oC_DropRelationshipPropertyExistenceConstraint)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(520)
		p.Match(CypherParserDROP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(521)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(522)
		p.OC_RelationshipPropertyExistenceConstraint()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_DropIndexContext is an interface to support dynamic dispatch.
type IOC_DropIndexContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	DROP() antlr.TerminalNode
	SP() antlr.TerminalNode
	OC_Index() IOC_IndexContext

	// IsOC_DropIndexContext differentiates from other interfaces.
	IsOC_DropIndexContext()
}

type OC_DropIndexContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_DropIndexContext() *OC_DropIndexContext {
	var p = new(OC_DropIndexContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_DropIndex
	return p
}

func InitEmptyOC_DropIndexContext(p *OC_DropIndexContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_DropIndex
}

func (*OC_DropIndexContext) IsOC_DropIndexContext() {}

func NewOC_DropIndexContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_DropIndexContext {
	var p = new(OC_DropIndexContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_DropIndex

	return p
}

func (s *OC_DropIndexContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_DropIndexContext) DROP() antlr.TerminalNode {
	return s.GetToken(CypherParserDROP, 0)
}

func (s *OC_DropIndexContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_DropIndexContext) OC_Index() IOC_IndexContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_IndexContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_IndexContext)
}

func (s *OC_DropIndexContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_DropIndexContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_DropIndexContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_DropIndex(s)
	}
}

func (s *OC_DropIndexContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_DropIndex(s)
	}
}

func (p *CypherParser) OC_DropIndex() (localctx IOC_DropIndexContext) {
	localctx = NewOC_DropIndexContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 56, CypherParserRULE_oC_DropIndex)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(524)
		p.Match(CypherParserDROP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(525)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(526)
		p.OC_Index()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_IndexContext is an interface to support dynamic dispatch.
type IOC_IndexContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	INDEX() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	ON() antlr.TerminalNode
	OC_NodeLabel() IOC_NodeLabelContext
	OC_PropertyKeyName() IOC_PropertyKeyNameContext

	// IsOC_IndexContext differentiates from other interfaces.
	IsOC_IndexContext()
}

type OC_IndexContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_IndexContext() *OC_IndexContext {
	var p = new(OC_IndexContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Index
	return p
}

func InitEmptyOC_IndexContext(p *OC_IndexContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Index
}

func (*OC_IndexContext) IsOC_IndexContext() {}

func NewOC_IndexContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_IndexContext {
	var p = new(OC_IndexContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Index

	return p
}

func (s *OC_IndexContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_IndexContext) INDEX() antlr.TerminalNode {
	return s.GetToken(CypherParserINDEX, 0)
}

func (s *OC_IndexContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_IndexContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_IndexContext) ON() antlr.TerminalNode {
	return s.GetToken(CypherParserON, 0)
}

func (s *OC_IndexContext) OC_NodeLabel() IOC_NodeLabelContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NodeLabelContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NodeLabelContext)
}

func (s *OC_IndexContext) OC_PropertyKeyName() IOC_PropertyKeyNameContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PropertyKeyNameContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PropertyKeyNameContext)
}

func (s *OC_IndexContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_IndexContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_IndexContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Index(s)
	}
}

func (s *OC_IndexContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Index(s)
	}
}

func (p *CypherParser) OC_Index() (localctx IOC_IndexContext) {
	localctx = NewOC_IndexContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 58, CypherParserRULE_oC_Index)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(528)
		p.Match(CypherParserINDEX)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(529)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(530)
		p.Match(CypherParserON)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(532)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(531)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(534)
		p.OC_NodeLabel()
	}
	{
		p.SetState(535)
		p.Match(CypherParserT__2)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(536)
		p.OC_PropertyKeyName()
	}
	{
		p.SetState(537)
		p.Match(CypherParserT__3)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_UniqueConstraintContext is an interface to support dynamic dispatch.
type IOC_UniqueConstraintContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	CONSTRAINT() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	ON() antlr.TerminalNode
	OC_Variable() IOC_VariableContext
	OC_NodeLabel() IOC_NodeLabelContext
	ASSERT() antlr.TerminalNode
	OC_PropertyExpression() IOC_PropertyExpressionContext
	IS() antlr.TerminalNode
	UNIQUE() antlr.TerminalNode

	// IsOC_UniqueConstraintContext differentiates from other interfaces.
	IsOC_UniqueConstraintContext()
}

type OC_UniqueConstraintContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_UniqueConstraintContext() *OC_UniqueConstraintContext {
	var p = new(OC_UniqueConstraintContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_UniqueConstraint
	return p
}

func InitEmptyOC_UniqueConstraintContext(p *OC_UniqueConstraintContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_UniqueConstraint
}

func (*OC_UniqueConstraintContext) IsOC_UniqueConstraintContext() {}

func NewOC_UniqueConstraintContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_UniqueConstraintContext {
	var p = new(OC_UniqueConstraintContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_UniqueConstraint

	return p
}

func (s *OC_UniqueConstraintContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_UniqueConstraintContext) CONSTRAINT() antlr.TerminalNode {
	return s.GetToken(CypherParserCONSTRAINT, 0)
}

func (s *OC_UniqueConstraintContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_UniqueConstraintContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_UniqueConstraintContext) ON() antlr.TerminalNode {
	return s.GetToken(CypherParserON, 0)
}

func (s *OC_UniqueConstraintContext) OC_Variable() IOC_VariableContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_VariableContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_VariableContext)
}

func (s *OC_UniqueConstraintContext) OC_NodeLabel() IOC_NodeLabelContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NodeLabelContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NodeLabelContext)
}

func (s *OC_UniqueConstraintContext) ASSERT() antlr.TerminalNode {
	return s.GetToken(CypherParserASSERT, 0)
}

func (s *OC_UniqueConstraintContext) OC_PropertyExpression() IOC_PropertyExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PropertyExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PropertyExpressionContext)
}

func (s *OC_UniqueConstraintContext) IS() antlr.TerminalNode {
	return s.GetToken(CypherParserIS, 0)
}

func (s *OC_UniqueConstraintContext) UNIQUE() antlr.TerminalNode {
	return s.GetToken(CypherParserUNIQUE, 0)
}

func (s *OC_UniqueConstraintContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_UniqueConstraintContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_UniqueConstraintContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_UniqueConstraint(s)
	}
}

func (s *OC_UniqueConstraintContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_UniqueConstraint(s)
	}
}

func (p *CypherParser) OC_UniqueConstraint() (localctx IOC_UniqueConstraintContext) {
	localctx = NewOC_UniqueConstraintContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 60, CypherParserRULE_oC_UniqueConstraint)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(539)
		p.Match(CypherParserCONSTRAINT)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(540)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(541)
		p.Match(CypherParserON)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(543)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(542)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(545)
		p.Match(CypherParserT__2)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(546)
		p.OC_Variable()
	}
	{
		p.SetState(547)
		p.OC_NodeLabel()
	}
	{
		p.SetState(548)
		p.Match(CypherParserT__3)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(550)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(549)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(552)
		p.Match(CypherParserASSERT)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(553)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(554)
		p.OC_PropertyExpression()
	}
	{
		p.SetState(555)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(556)
		p.Match(CypherParserIS)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(557)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(558)
		p.Match(CypherParserUNIQUE)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_NodePropertyExistenceConstraintContext is an interface to support dynamic dispatch.
type IOC_NodePropertyExistenceConstraintContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	CONSTRAINT() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	ON() antlr.TerminalNode
	OC_Variable() IOC_VariableContext
	OC_NodeLabel() IOC_NodeLabelContext
	ASSERT() antlr.TerminalNode
	EXISTS() antlr.TerminalNode
	OC_PropertyExpression() IOC_PropertyExpressionContext

	// IsOC_NodePropertyExistenceConstraintContext differentiates from other interfaces.
	IsOC_NodePropertyExistenceConstraintContext()
}

type OC_NodePropertyExistenceConstraintContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_NodePropertyExistenceConstraintContext() *OC_NodePropertyExistenceConstraintContext {
	var p = new(OC_NodePropertyExistenceConstraintContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_NodePropertyExistenceConstraint
	return p
}

func InitEmptyOC_NodePropertyExistenceConstraintContext(p *OC_NodePropertyExistenceConstraintContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_NodePropertyExistenceConstraint
}

func (*OC_NodePropertyExistenceConstraintContext) IsOC_NodePropertyExistenceConstraintContext() {}

func NewOC_NodePropertyExistenceConstraintContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_NodePropertyExistenceConstraintContext {
	var p = new(OC_NodePropertyExistenceConstraintContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_NodePropertyExistenceConstraint

	return p
}

func (s *OC_NodePropertyExistenceConstraintContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_NodePropertyExistenceConstraintContext) CONSTRAINT() antlr.TerminalNode {
	return s.GetToken(CypherParserCONSTRAINT, 0)
}

func (s *OC_NodePropertyExistenceConstraintContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_NodePropertyExistenceConstraintContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_NodePropertyExistenceConstraintContext) ON() antlr.TerminalNode {
	return s.GetToken(CypherParserON, 0)
}

func (s *OC_NodePropertyExistenceConstraintContext) OC_Variable() IOC_VariableContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_VariableContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_VariableContext)
}

func (s *OC_NodePropertyExistenceConstraintContext) OC_NodeLabel() IOC_NodeLabelContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NodeLabelContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NodeLabelContext)
}

func (s *OC_NodePropertyExistenceConstraintContext) ASSERT() antlr.TerminalNode {
	return s.GetToken(CypherParserASSERT, 0)
}

func (s *OC_NodePropertyExistenceConstraintContext) EXISTS() antlr.TerminalNode {
	return s.GetToken(CypherParserEXISTS, 0)
}

func (s *OC_NodePropertyExistenceConstraintContext) OC_PropertyExpression() IOC_PropertyExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PropertyExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PropertyExpressionContext)
}

func (s *OC_NodePropertyExistenceConstraintContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_NodePropertyExistenceConstraintContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_NodePropertyExistenceConstraintContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_NodePropertyExistenceConstraint(s)
	}
}

func (s *OC_NodePropertyExistenceConstraintContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_NodePropertyExistenceConstraint(s)
	}
}

func (p *CypherParser) OC_NodePropertyExistenceConstraint() (localctx IOC_NodePropertyExistenceConstraintContext) {
	localctx = NewOC_NodePropertyExistenceConstraintContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 62, CypherParserRULE_oC_NodePropertyExistenceConstraint)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(560)
		p.Match(CypherParserCONSTRAINT)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(561)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(562)
		p.Match(CypherParserON)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(564)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(563)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(566)
		p.Match(CypherParserT__2)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(567)
		p.OC_Variable()
	}
	{
		p.SetState(568)
		p.OC_NodeLabel()
	}
	{
		p.SetState(569)
		p.Match(CypherParserT__3)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(571)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(570)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(573)
		p.Match(CypherParserASSERT)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(574)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(575)
		p.Match(CypherParserEXISTS)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(577)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(576)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(579)
		p.Match(CypherParserT__2)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(580)
		p.OC_PropertyExpression()
	}
	{
		p.SetState(581)
		p.Match(CypherParserT__3)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_RelationshipPropertyExistenceConstraintContext is an interface to support dynamic dispatch.
type IOC_RelationshipPropertyExistenceConstraintContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	CONSTRAINT() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	ON() antlr.TerminalNode
	OC_RelationshipPatternSyntax() IOC_RelationshipPatternSyntaxContext
	ASSERT() antlr.TerminalNode
	EXISTS() antlr.TerminalNode
	OC_PropertyExpression() IOC_PropertyExpressionContext

	// IsOC_RelationshipPropertyExistenceConstraintContext differentiates from other interfaces.
	IsOC_RelationshipPropertyExistenceConstraintContext()
}

type OC_RelationshipPropertyExistenceConstraintContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_RelationshipPropertyExistenceConstraintContext() *OC_RelationshipPropertyExistenceConstraintContext {
	var p = new(OC_RelationshipPropertyExistenceConstraintContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RelationshipPropertyExistenceConstraint
	return p
}

func InitEmptyOC_RelationshipPropertyExistenceConstraintContext(p *OC_RelationshipPropertyExistenceConstraintContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RelationshipPropertyExistenceConstraint
}

func (*OC_RelationshipPropertyExistenceConstraintContext) IsOC_RelationshipPropertyExistenceConstraintContext() {
}

func NewOC_RelationshipPropertyExistenceConstraintContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_RelationshipPropertyExistenceConstraintContext {
	var p = new(OC_RelationshipPropertyExistenceConstraintContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_RelationshipPropertyExistenceConstraint

	return p
}

func (s *OC_RelationshipPropertyExistenceConstraintContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_RelationshipPropertyExistenceConstraintContext) CONSTRAINT() antlr.TerminalNode {
	return s.GetToken(CypherParserCONSTRAINT, 0)
}

func (s *OC_RelationshipPropertyExistenceConstraintContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_RelationshipPropertyExistenceConstraintContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_RelationshipPropertyExistenceConstraintContext) ON() antlr.TerminalNode {
	return s.GetToken(CypherParserON, 0)
}

func (s *OC_RelationshipPropertyExistenceConstraintContext) OC_RelationshipPatternSyntax() IOC_RelationshipPatternSyntaxContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_RelationshipPatternSyntaxContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_RelationshipPatternSyntaxContext)
}

func (s *OC_RelationshipPropertyExistenceConstraintContext) ASSERT() antlr.TerminalNode {
	return s.GetToken(CypherParserASSERT, 0)
}

func (s *OC_RelationshipPropertyExistenceConstraintContext) EXISTS() antlr.TerminalNode {
	return s.GetToken(CypherParserEXISTS, 0)
}

func (s *OC_RelationshipPropertyExistenceConstraintContext) OC_PropertyExpression() IOC_PropertyExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PropertyExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PropertyExpressionContext)
}

func (s *OC_RelationshipPropertyExistenceConstraintContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_RelationshipPropertyExistenceConstraintContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_RelationshipPropertyExistenceConstraintContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_RelationshipPropertyExistenceConstraint(s)
	}
}

func (s *OC_RelationshipPropertyExistenceConstraintContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_RelationshipPropertyExistenceConstraint(s)
	}
}

func (p *CypherParser) OC_RelationshipPropertyExistenceConstraint() (localctx IOC_RelationshipPropertyExistenceConstraintContext) {
	localctx = NewOC_RelationshipPropertyExistenceConstraintContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 64, CypherParserRULE_oC_RelationshipPropertyExistenceConstraint)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(583)
		p.Match(CypherParserCONSTRAINT)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(584)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(585)
		p.Match(CypherParserON)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(587)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(586)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(589)
		p.OC_RelationshipPatternSyntax()
	}
	p.SetState(591)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(590)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(593)
		p.Match(CypherParserASSERT)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(594)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(595)
		p.Match(CypherParserEXISTS)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(597)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(596)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(599)
		p.Match(CypherParserT__2)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(600)
		p.OC_PropertyExpression()
	}
	{
		p.SetState(601)
		p.Match(CypherParserT__3)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_RelationshipPatternSyntaxContext is an interface to support dynamic dispatch.
type IOC_RelationshipPatternSyntaxContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllOC_Dash() []IOC_DashContext
	OC_Dash(i int) IOC_DashContext
	OC_Variable() IOC_VariableContext
	OC_RelType() IOC_RelTypeContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	OC_RightArrowHead() IOC_RightArrowHeadContext
	OC_LeftArrowHead() IOC_LeftArrowHeadContext

	// IsOC_RelationshipPatternSyntaxContext differentiates from other interfaces.
	IsOC_RelationshipPatternSyntaxContext()
}

type OC_RelationshipPatternSyntaxContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_RelationshipPatternSyntaxContext() *OC_RelationshipPatternSyntaxContext {
	var p = new(OC_RelationshipPatternSyntaxContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RelationshipPatternSyntax
	return p
}

func InitEmptyOC_RelationshipPatternSyntaxContext(p *OC_RelationshipPatternSyntaxContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RelationshipPatternSyntax
}

func (*OC_RelationshipPatternSyntaxContext) IsOC_RelationshipPatternSyntaxContext() {}

func NewOC_RelationshipPatternSyntaxContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_RelationshipPatternSyntaxContext {
	var p = new(OC_RelationshipPatternSyntaxContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_RelationshipPatternSyntax

	return p
}

func (s *OC_RelationshipPatternSyntaxContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_RelationshipPatternSyntaxContext) AllOC_Dash() []IOC_DashContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_DashContext); ok {
			len++
		}
	}

	tst := make([]IOC_DashContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_DashContext); ok {
			tst[i] = t.(IOC_DashContext)
			i++
		}
	}

	return tst
}

func (s *OC_RelationshipPatternSyntaxContext) OC_Dash(i int) IOC_DashContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_DashContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_DashContext)
}

func (s *OC_RelationshipPatternSyntaxContext) OC_Variable() IOC_VariableContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_VariableContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_VariableContext)
}

func (s *OC_RelationshipPatternSyntaxContext) OC_RelType() IOC_RelTypeContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_RelTypeContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_RelTypeContext)
}

func (s *OC_RelationshipPatternSyntaxContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_RelationshipPatternSyntaxContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_RelationshipPatternSyntaxContext) OC_RightArrowHead() IOC_RightArrowHeadContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_RightArrowHeadContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_RightArrowHeadContext)
}

func (s *OC_RelationshipPatternSyntaxContext) OC_LeftArrowHead() IOC_LeftArrowHeadContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_LeftArrowHeadContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_LeftArrowHeadContext)
}

func (s *OC_RelationshipPatternSyntaxContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_RelationshipPatternSyntaxContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_RelationshipPatternSyntaxContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_RelationshipPatternSyntax(s)
	}
}

func (s *OC_RelationshipPatternSyntaxContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_RelationshipPatternSyntax(s)
	}
}

func (p *CypherParser) OC_RelationshipPatternSyntax() (localctx IOC_RelationshipPatternSyntaxContext) {
	localctx = NewOC_RelationshipPatternSyntaxContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 66, CypherParserRULE_oC_RelationshipPatternSyntax)
	var _la int

	p.SetState(656)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 54, p.GetParserRuleContext()) {
	case 1:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(603)
			p.Match(CypherParserT__2)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(605)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(604)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(607)
			p.Match(CypherParserT__3)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(608)
			p.OC_Dash()
		}
		{
			p.SetState(609)
			p.Match(CypherParserT__4)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(610)
			p.OC_Variable()
		}
		{
			p.SetState(611)
			p.OC_RelType()
		}
		{
			p.SetState(612)
			p.Match(CypherParserT__5)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(613)
			p.OC_Dash()
		}
		{
			p.SetState(614)
			p.Match(CypherParserT__2)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(616)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(615)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(618)
			p.Match(CypherParserT__3)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case 2:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(620)
			p.Match(CypherParserT__2)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(622)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(621)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(624)
			p.Match(CypherParserT__3)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(625)
			p.OC_Dash()
		}
		{
			p.SetState(626)
			p.Match(CypherParserT__4)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(627)
			p.OC_Variable()
		}
		{
			p.SetState(628)
			p.OC_RelType()
		}
		{
			p.SetState(629)
			p.Match(CypherParserT__5)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(630)
			p.OC_Dash()
		}
		{
			p.SetState(631)
			p.OC_RightArrowHead()
		}
		{
			p.SetState(632)
			p.Match(CypherParserT__2)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(634)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(633)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(636)
			p.Match(CypherParserT__3)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case 3:
		p.EnterOuterAlt(localctx, 3)
		{
			p.SetState(638)
			p.Match(CypherParserT__2)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(640)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(639)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(642)
			p.Match(CypherParserT__3)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(643)
			p.OC_LeftArrowHead()
		}
		{
			p.SetState(644)
			p.OC_Dash()
		}
		{
			p.SetState(645)
			p.Match(CypherParserT__4)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(646)
			p.OC_Variable()
		}
		{
			p.SetState(647)
			p.OC_RelType()
		}
		{
			p.SetState(648)
			p.Match(CypherParserT__5)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(649)
			p.OC_Dash()
		}
		{
			p.SetState(650)
			p.Match(CypherParserT__2)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(652)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(651)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(654)
			p.Match(CypherParserT__3)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_LoadCSVContext is an interface to support dynamic dispatch.
type IOC_LoadCSVContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	LOAD() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	CSV() antlr.TerminalNode
	FROM() antlr.TerminalNode
	OC_Expression() IOC_ExpressionContext
	AS() antlr.TerminalNode
	OC_Variable() IOC_VariableContext
	WITH() antlr.TerminalNode
	HEADERS() antlr.TerminalNode
	FIELDTERMINATOR() antlr.TerminalNode
	StringLiteral() antlr.TerminalNode

	// IsOC_LoadCSVContext differentiates from other interfaces.
	IsOC_LoadCSVContext()
}

type OC_LoadCSVContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_LoadCSVContext() *OC_LoadCSVContext {
	var p = new(OC_LoadCSVContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_LoadCSV
	return p
}

func InitEmptyOC_LoadCSVContext(p *OC_LoadCSVContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_LoadCSV
}

func (*OC_LoadCSVContext) IsOC_LoadCSVContext() {}

func NewOC_LoadCSVContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_LoadCSVContext {
	var p = new(OC_LoadCSVContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_LoadCSV

	return p
}

func (s *OC_LoadCSVContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_LoadCSVContext) LOAD() antlr.TerminalNode {
	return s.GetToken(CypherParserLOAD, 0)
}

func (s *OC_LoadCSVContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_LoadCSVContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_LoadCSVContext) CSV() antlr.TerminalNode {
	return s.GetToken(CypherParserCSV, 0)
}

func (s *OC_LoadCSVContext) FROM() antlr.TerminalNode {
	return s.GetToken(CypherParserFROM, 0)
}

func (s *OC_LoadCSVContext) OC_Expression() IOC_ExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_LoadCSVContext) AS() antlr.TerminalNode {
	return s.GetToken(CypherParserAS, 0)
}

func (s *OC_LoadCSVContext) OC_Variable() IOC_VariableContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_VariableContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_VariableContext)
}

func (s *OC_LoadCSVContext) WITH() antlr.TerminalNode {
	return s.GetToken(CypherParserWITH, 0)
}

func (s *OC_LoadCSVContext) HEADERS() antlr.TerminalNode {
	return s.GetToken(CypherParserHEADERS, 0)
}

func (s *OC_LoadCSVContext) FIELDTERMINATOR() antlr.TerminalNode {
	return s.GetToken(CypherParserFIELDTERMINATOR, 0)
}

func (s *OC_LoadCSVContext) StringLiteral() antlr.TerminalNode {
	return s.GetToken(CypherParserStringLiteral, 0)
}

func (s *OC_LoadCSVContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_LoadCSVContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_LoadCSVContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_LoadCSV(s)
	}
}

func (s *OC_LoadCSVContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_LoadCSV(s)
	}
}

func (p *CypherParser) OC_LoadCSV() (localctx IOC_LoadCSVContext) {
	localctx = NewOC_LoadCSVContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 68, CypherParserRULE_oC_LoadCSV)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(658)
		p.Match(CypherParserLOAD)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(659)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(660)
		p.Match(CypherParserCSV)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(661)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(666)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserWITH {
		{
			p.SetState(662)
			p.Match(CypherParserWITH)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(663)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(664)
			p.Match(CypherParserHEADERS)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(665)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(668)
		p.Match(CypherParserFROM)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(669)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(670)
		p.OC_Expression()
	}
	{
		p.SetState(671)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(672)
		p.Match(CypherParserAS)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(673)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(674)
		p.OC_Variable()
	}
	{
		p.SetState(675)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(679)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserFIELDTERMINATOR {
		{
			p.SetState(676)
			p.Match(CypherParserFIELDTERMINATOR)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(677)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(678)
			p.Match(CypherParserStringLiteral)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_MatchContext is an interface to support dynamic dispatch.
type IOC_MatchContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	MATCH() antlr.TerminalNode
	OC_Pattern() IOC_PatternContext
	OPTIONAL() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	AllOC_Hint() []IOC_HintContext
	OC_Hint(i int) IOC_HintContext
	OC_Where() IOC_WhereContext

	// IsOC_MatchContext differentiates from other interfaces.
	IsOC_MatchContext()
}

type OC_MatchContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_MatchContext() *OC_MatchContext {
	var p = new(OC_MatchContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Match
	return p
}

func InitEmptyOC_MatchContext(p *OC_MatchContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Match
}

func (*OC_MatchContext) IsOC_MatchContext() {}

func NewOC_MatchContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_MatchContext {
	var p = new(OC_MatchContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Match

	return p
}

func (s *OC_MatchContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_MatchContext) MATCH() antlr.TerminalNode {
	return s.GetToken(CypherParserMATCH, 0)
}

func (s *OC_MatchContext) OC_Pattern() IOC_PatternContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PatternContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PatternContext)
}

func (s *OC_MatchContext) OPTIONAL() antlr.TerminalNode {
	return s.GetToken(CypherParserOPTIONAL, 0)
}

func (s *OC_MatchContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_MatchContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_MatchContext) AllOC_Hint() []IOC_HintContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_HintContext); ok {
			len++
		}
	}

	tst := make([]IOC_HintContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_HintContext); ok {
			tst[i] = t.(IOC_HintContext)
			i++
		}
	}

	return tst
}

func (s *OC_MatchContext) OC_Hint(i int) IOC_HintContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_HintContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_HintContext)
}

func (s *OC_MatchContext) OC_Where() IOC_WhereContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_WhereContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_WhereContext)
}

func (s *OC_MatchContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_MatchContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_MatchContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Match(s)
	}
}

func (s *OC_MatchContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Match(s)
	}
}

func (p *CypherParser) OC_Match() (localctx IOC_MatchContext) {
	localctx = NewOC_MatchContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 70, CypherParserRULE_oC_Match)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	p.SetState(683)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserOPTIONAL {
		{
			p.SetState(681)
			p.Match(CypherParserOPTIONAL)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(682)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(685)
		p.Match(CypherParserMATCH)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(687)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(686)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(689)
		p.OC_Pattern()
	}
	p.SetState(693)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 59, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			{
				p.SetState(690)
				p.OC_Hint()
			}

		}
		p.SetState(695)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 59, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}
	p.SetState(700)
	p.GetErrorHandler().Sync(p)

	if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 61, p.GetParserRuleContext()) == 1 {
		p.SetState(697)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(696)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(699)
			p.OC_Where()
		}

	} else if p.HasError() { // JIM
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_UnwindContext is an interface to support dynamic dispatch.
type IOC_UnwindContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	UNWIND() antlr.TerminalNode
	OC_Expression() IOC_ExpressionContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	AS() antlr.TerminalNode
	OC_Variable() IOC_VariableContext

	// IsOC_UnwindContext differentiates from other interfaces.
	IsOC_UnwindContext()
}

type OC_UnwindContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_UnwindContext() *OC_UnwindContext {
	var p = new(OC_UnwindContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Unwind
	return p
}

func InitEmptyOC_UnwindContext(p *OC_UnwindContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Unwind
}

func (*OC_UnwindContext) IsOC_UnwindContext() {}

func NewOC_UnwindContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_UnwindContext {
	var p = new(OC_UnwindContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Unwind

	return p
}

func (s *OC_UnwindContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_UnwindContext) UNWIND() antlr.TerminalNode {
	return s.GetToken(CypherParserUNWIND, 0)
}

func (s *OC_UnwindContext) OC_Expression() IOC_ExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_UnwindContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_UnwindContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_UnwindContext) AS() antlr.TerminalNode {
	return s.GetToken(CypherParserAS, 0)
}

func (s *OC_UnwindContext) OC_Variable() IOC_VariableContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_VariableContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_VariableContext)
}

func (s *OC_UnwindContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_UnwindContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_UnwindContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Unwind(s)
	}
}

func (s *OC_UnwindContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Unwind(s)
	}
}

func (p *CypherParser) OC_Unwind() (localctx IOC_UnwindContext) {
	localctx = NewOC_UnwindContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 72, CypherParserRULE_oC_Unwind)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(702)
		p.Match(CypherParserUNWIND)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(704)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(703)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(706)
		p.OC_Expression()
	}
	{
		p.SetState(707)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(708)
		p.Match(CypherParserAS)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(709)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(710)
		p.OC_Variable()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_MergeContext is an interface to support dynamic dispatch.
type IOC_MergeContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	MERGE() antlr.TerminalNode
	OC_PatternPart() IOC_PatternPartContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	AllOC_MergeAction() []IOC_MergeActionContext
	OC_MergeAction(i int) IOC_MergeActionContext

	// IsOC_MergeContext differentiates from other interfaces.
	IsOC_MergeContext()
}

type OC_MergeContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_MergeContext() *OC_MergeContext {
	var p = new(OC_MergeContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Merge
	return p
}

func InitEmptyOC_MergeContext(p *OC_MergeContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Merge
}

func (*OC_MergeContext) IsOC_MergeContext() {}

func NewOC_MergeContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_MergeContext {
	var p = new(OC_MergeContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Merge

	return p
}

func (s *OC_MergeContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_MergeContext) MERGE() antlr.TerminalNode {
	return s.GetToken(CypherParserMERGE, 0)
}

func (s *OC_MergeContext) OC_PatternPart() IOC_PatternPartContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PatternPartContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PatternPartContext)
}

func (s *OC_MergeContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_MergeContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_MergeContext) AllOC_MergeAction() []IOC_MergeActionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_MergeActionContext); ok {
			len++
		}
	}

	tst := make([]IOC_MergeActionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_MergeActionContext); ok {
			tst[i] = t.(IOC_MergeActionContext)
			i++
		}
	}

	return tst
}

func (s *OC_MergeContext) OC_MergeAction(i int) IOC_MergeActionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_MergeActionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_MergeActionContext)
}

func (s *OC_MergeContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_MergeContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_MergeContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Merge(s)
	}
}

func (s *OC_MergeContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Merge(s)
	}
}

func (p *CypherParser) OC_Merge() (localctx IOC_MergeContext) {
	localctx = NewOC_MergeContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 74, CypherParserRULE_oC_Merge)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(712)
		p.Match(CypherParserMERGE)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(714)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(713)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(716)
		p.OC_PatternPart()
	}
	p.SetState(721)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 64, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			{
				p.SetState(717)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			{
				p.SetState(718)
				p.OC_MergeAction()
			}

		}
		p.SetState(723)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 64, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_MergeActionContext is an interface to support dynamic dispatch.
type IOC_MergeActionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	ON() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	MATCH() antlr.TerminalNode
	OC_Set() IOC_SetContext
	CREATE() antlr.TerminalNode

	// IsOC_MergeActionContext differentiates from other interfaces.
	IsOC_MergeActionContext()
}

type OC_MergeActionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_MergeActionContext() *OC_MergeActionContext {
	var p = new(OC_MergeActionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_MergeAction
	return p
}

func InitEmptyOC_MergeActionContext(p *OC_MergeActionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_MergeAction
}

func (*OC_MergeActionContext) IsOC_MergeActionContext() {}

func NewOC_MergeActionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_MergeActionContext {
	var p = new(OC_MergeActionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_MergeAction

	return p
}

func (s *OC_MergeActionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_MergeActionContext) ON() antlr.TerminalNode {
	return s.GetToken(CypherParserON, 0)
}

func (s *OC_MergeActionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_MergeActionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_MergeActionContext) MATCH() antlr.TerminalNode {
	return s.GetToken(CypherParserMATCH, 0)
}

func (s *OC_MergeActionContext) OC_Set() IOC_SetContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SetContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SetContext)
}

func (s *OC_MergeActionContext) CREATE() antlr.TerminalNode {
	return s.GetToken(CypherParserCREATE, 0)
}

func (s *OC_MergeActionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_MergeActionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_MergeActionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_MergeAction(s)
	}
}

func (s *OC_MergeActionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_MergeAction(s)
	}
}

func (p *CypherParser) OC_MergeAction() (localctx IOC_MergeActionContext) {
	localctx = NewOC_MergeActionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 76, CypherParserRULE_oC_MergeAction)
	p.SetState(734)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 65, p.GetParserRuleContext()) {
	case 1:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(724)
			p.Match(CypherParserON)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(725)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(726)
			p.Match(CypherParserMATCH)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(727)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(728)
			p.OC_Set()
		}

	case 2:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(729)
			p.Match(CypherParserON)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(730)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(731)
			p.Match(CypherParserCREATE)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(732)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(733)
			p.OC_Set()
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_CreateContext is an interface to support dynamic dispatch.
type IOC_CreateContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	CREATE() antlr.TerminalNode
	OC_Pattern() IOC_PatternContext
	SP() antlr.TerminalNode

	// IsOC_CreateContext differentiates from other interfaces.
	IsOC_CreateContext()
}

type OC_CreateContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_CreateContext() *OC_CreateContext {
	var p = new(OC_CreateContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Create
	return p
}

func InitEmptyOC_CreateContext(p *OC_CreateContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Create
}

func (*OC_CreateContext) IsOC_CreateContext() {}

func NewOC_CreateContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_CreateContext {
	var p = new(OC_CreateContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Create

	return p
}

func (s *OC_CreateContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_CreateContext) CREATE() antlr.TerminalNode {
	return s.GetToken(CypherParserCREATE, 0)
}

func (s *OC_CreateContext) OC_Pattern() IOC_PatternContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PatternContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PatternContext)
}

func (s *OC_CreateContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_CreateContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_CreateContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_CreateContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Create(s)
	}
}

func (s *OC_CreateContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Create(s)
	}
}

func (p *CypherParser) OC_Create() (localctx IOC_CreateContext) {
	localctx = NewOC_CreateContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 78, CypherParserRULE_oC_Create)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(736)
		p.Match(CypherParserCREATE)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(738)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(737)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(740)
		p.OC_Pattern()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_CreateUniqueContext is an interface to support dynamic dispatch.
type IOC_CreateUniqueContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	CREATE() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	UNIQUE() antlr.TerminalNode
	OC_Pattern() IOC_PatternContext

	// IsOC_CreateUniqueContext differentiates from other interfaces.
	IsOC_CreateUniqueContext()
}

type OC_CreateUniqueContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_CreateUniqueContext() *OC_CreateUniqueContext {
	var p = new(OC_CreateUniqueContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_CreateUnique
	return p
}

func InitEmptyOC_CreateUniqueContext(p *OC_CreateUniqueContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_CreateUnique
}

func (*OC_CreateUniqueContext) IsOC_CreateUniqueContext() {}

func NewOC_CreateUniqueContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_CreateUniqueContext {
	var p = new(OC_CreateUniqueContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_CreateUnique

	return p
}

func (s *OC_CreateUniqueContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_CreateUniqueContext) CREATE() antlr.TerminalNode {
	return s.GetToken(CypherParserCREATE, 0)
}

func (s *OC_CreateUniqueContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_CreateUniqueContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_CreateUniqueContext) UNIQUE() antlr.TerminalNode {
	return s.GetToken(CypherParserUNIQUE, 0)
}

func (s *OC_CreateUniqueContext) OC_Pattern() IOC_PatternContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PatternContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PatternContext)
}

func (s *OC_CreateUniqueContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_CreateUniqueContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_CreateUniqueContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_CreateUnique(s)
	}
}

func (s *OC_CreateUniqueContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_CreateUnique(s)
	}
}

func (p *CypherParser) OC_CreateUnique() (localctx IOC_CreateUniqueContext) {
	localctx = NewOC_CreateUniqueContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 80, CypherParserRULE_oC_CreateUnique)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(742)
		p.Match(CypherParserCREATE)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(743)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(744)
		p.Match(CypherParserUNIQUE)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(746)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(745)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(748)
		p.OC_Pattern()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_SetContext is an interface to support dynamic dispatch.
type IOC_SetContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	SET() antlr.TerminalNode
	AllOC_SetItem() []IOC_SetItemContext
	OC_SetItem(i int) IOC_SetItemContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_SetContext differentiates from other interfaces.
	IsOC_SetContext()
}

type OC_SetContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_SetContext() *OC_SetContext {
	var p = new(OC_SetContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Set
	return p
}

func InitEmptyOC_SetContext(p *OC_SetContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Set
}

func (*OC_SetContext) IsOC_SetContext() {}

func NewOC_SetContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_SetContext {
	var p = new(OC_SetContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Set

	return p
}

func (s *OC_SetContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_SetContext) SET() antlr.TerminalNode {
	return s.GetToken(CypherParserSET, 0)
}

func (s *OC_SetContext) AllOC_SetItem() []IOC_SetItemContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_SetItemContext); ok {
			len++
		}
	}

	tst := make([]IOC_SetItemContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_SetItemContext); ok {
			tst[i] = t.(IOC_SetItemContext)
			i++
		}
	}

	return tst
}

func (s *OC_SetContext) OC_SetItem(i int) IOC_SetItemContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SetItemContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SetItemContext)
}

func (s *OC_SetContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_SetContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_SetContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_SetContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_SetContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Set(s)
	}
}

func (s *OC_SetContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Set(s)
	}
}

func (p *CypherParser) OC_Set() (localctx IOC_SetContext) {
	localctx = NewOC_SetContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 82, CypherParserRULE_oC_Set)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(750)
		p.Match(CypherParserSET)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(752)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(751)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(754)
		p.OC_SetItem()
	}
	p.SetState(765)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 71, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			p.SetState(756)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(755)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(758)
				p.Match(CypherParserT__6)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			p.SetState(760)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(759)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(762)
				p.OC_SetItem()
			}

		}
		p.SetState(767)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 71, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_SetItemContext is an interface to support dynamic dispatch.
type IOC_SetItemContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_PropertyExpression() IOC_PropertyExpressionContext
	OC_Expression() IOC_ExpressionContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	OC_Variable() IOC_VariableContext
	OC_NodeLabels() IOC_NodeLabelsContext

	// IsOC_SetItemContext differentiates from other interfaces.
	IsOC_SetItemContext()
}

type OC_SetItemContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_SetItemContext() *OC_SetItemContext {
	var p = new(OC_SetItemContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_SetItem
	return p
}

func InitEmptyOC_SetItemContext(p *OC_SetItemContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_SetItem
}

func (*OC_SetItemContext) IsOC_SetItemContext() {}

func NewOC_SetItemContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_SetItemContext {
	var p = new(OC_SetItemContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_SetItem

	return p
}

func (s *OC_SetItemContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_SetItemContext) OC_PropertyExpression() IOC_PropertyExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PropertyExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PropertyExpressionContext)
}

func (s *OC_SetItemContext) OC_Expression() IOC_ExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_SetItemContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_SetItemContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_SetItemContext) OC_Variable() IOC_VariableContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_VariableContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_VariableContext)
}

func (s *OC_SetItemContext) OC_NodeLabels() IOC_NodeLabelsContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NodeLabelsContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NodeLabelsContext)
}

func (s *OC_SetItemContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_SetItemContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_SetItemContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_SetItem(s)
	}
}

func (s *OC_SetItemContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_SetItem(s)
	}
}

func (p *CypherParser) OC_SetItem() (localctx IOC_SetItemContext) {
	localctx = NewOC_SetItemContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 84, CypherParserRULE_oC_SetItem)
	var _la int

	p.SetState(804)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 79, p.GetParserRuleContext()) {
	case 1:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(768)
			p.OC_PropertyExpression()
		}
		p.SetState(770)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(769)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(772)
			p.Match(CypherParserT__1)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(774)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(773)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(776)
			p.OC_Expression()
		}

	case 2:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(778)
			p.OC_Variable()
		}
		p.SetState(780)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(779)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(782)
			p.Match(CypherParserT__1)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(784)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(783)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(786)
			p.OC_Expression()
		}

	case 3:
		p.EnterOuterAlt(localctx, 3)
		{
			p.SetState(788)
			p.OC_Variable()
		}
		p.SetState(790)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(789)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(792)
			p.Match(CypherParserT__7)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(794)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(793)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(796)
			p.OC_Expression()
		}

	case 4:
		p.EnterOuterAlt(localctx, 4)
		{
			p.SetState(798)
			p.OC_Variable()
		}
		p.SetState(800)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(799)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(802)
			p.OC_NodeLabels()
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_DeleteContext is an interface to support dynamic dispatch.
type IOC_DeleteContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	DELETE() antlr.TerminalNode
	AllOC_Expression() []IOC_ExpressionContext
	OC_Expression(i int) IOC_ExpressionContext
	DETACH() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_DeleteContext differentiates from other interfaces.
	IsOC_DeleteContext()
}

type OC_DeleteContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_DeleteContext() *OC_DeleteContext {
	var p = new(OC_DeleteContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Delete
	return p
}

func InitEmptyOC_DeleteContext(p *OC_DeleteContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Delete
}

func (*OC_DeleteContext) IsOC_DeleteContext() {}

func NewOC_DeleteContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_DeleteContext {
	var p = new(OC_DeleteContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Delete

	return p
}

func (s *OC_DeleteContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_DeleteContext) DELETE() antlr.TerminalNode {
	return s.GetToken(CypherParserDELETE, 0)
}

func (s *OC_DeleteContext) AllOC_Expression() []IOC_ExpressionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			len++
		}
	}

	tst := make([]IOC_ExpressionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_ExpressionContext); ok {
			tst[i] = t.(IOC_ExpressionContext)
			i++
		}
	}

	return tst
}

func (s *OC_DeleteContext) OC_Expression(i int) IOC_ExpressionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_DeleteContext) DETACH() antlr.TerminalNode {
	return s.GetToken(CypherParserDETACH, 0)
}

func (s *OC_DeleteContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_DeleteContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_DeleteContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_DeleteContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_DeleteContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Delete(s)
	}
}

func (s *OC_DeleteContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Delete(s)
	}
}

func (p *CypherParser) OC_Delete() (localctx IOC_DeleteContext) {
	localctx = NewOC_DeleteContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 86, CypherParserRULE_oC_Delete)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	p.SetState(808)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserDETACH {
		{
			p.SetState(806)
			p.Match(CypherParserDETACH)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(807)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(810)
		p.Match(CypherParserDELETE)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(812)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(811)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(814)
		p.OC_Expression()
	}
	p.SetState(825)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 84, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			p.SetState(816)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(815)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(818)
				p.Match(CypherParserT__6)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			p.SetState(820)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(819)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(822)
				p.OC_Expression()
			}

		}
		p.SetState(827)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 84, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_RemoveContext is an interface to support dynamic dispatch.
type IOC_RemoveContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	REMOVE() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	AllOC_RemoveItem() []IOC_RemoveItemContext
	OC_RemoveItem(i int) IOC_RemoveItemContext

	// IsOC_RemoveContext differentiates from other interfaces.
	IsOC_RemoveContext()
}

type OC_RemoveContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_RemoveContext() *OC_RemoveContext {
	var p = new(OC_RemoveContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Remove
	return p
}

func InitEmptyOC_RemoveContext(p *OC_RemoveContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Remove
}

func (*OC_RemoveContext) IsOC_RemoveContext() {}

func NewOC_RemoveContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_RemoveContext {
	var p = new(OC_RemoveContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Remove

	return p
}

func (s *OC_RemoveContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_RemoveContext) REMOVE() antlr.TerminalNode {
	return s.GetToken(CypherParserREMOVE, 0)
}

func (s *OC_RemoveContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_RemoveContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_RemoveContext) AllOC_RemoveItem() []IOC_RemoveItemContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_RemoveItemContext); ok {
			len++
		}
	}

	tst := make([]IOC_RemoveItemContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_RemoveItemContext); ok {
			tst[i] = t.(IOC_RemoveItemContext)
			i++
		}
	}

	return tst
}

func (s *OC_RemoveContext) OC_RemoveItem(i int) IOC_RemoveItemContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_RemoveItemContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_RemoveItemContext)
}

func (s *OC_RemoveContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_RemoveContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_RemoveContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Remove(s)
	}
}

func (s *OC_RemoveContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Remove(s)
	}
}

func (p *CypherParser) OC_Remove() (localctx IOC_RemoveContext) {
	localctx = NewOC_RemoveContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 88, CypherParserRULE_oC_Remove)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(828)
		p.Match(CypherParserREMOVE)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(829)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(830)
		p.OC_RemoveItem()
	}
	p.SetState(841)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 87, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			p.SetState(832)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(831)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(834)
				p.Match(CypherParserT__6)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			p.SetState(836)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(835)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(838)
				p.OC_RemoveItem()
			}

		}
		p.SetState(843)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 87, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_RemoveItemContext is an interface to support dynamic dispatch.
type IOC_RemoveItemContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_Variable() IOC_VariableContext
	OC_NodeLabels() IOC_NodeLabelsContext
	OC_PropertyExpression() IOC_PropertyExpressionContext

	// IsOC_RemoveItemContext differentiates from other interfaces.
	IsOC_RemoveItemContext()
}

type OC_RemoveItemContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_RemoveItemContext() *OC_RemoveItemContext {
	var p = new(OC_RemoveItemContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RemoveItem
	return p
}

func InitEmptyOC_RemoveItemContext(p *OC_RemoveItemContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RemoveItem
}

func (*OC_RemoveItemContext) IsOC_RemoveItemContext() {}

func NewOC_RemoveItemContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_RemoveItemContext {
	var p = new(OC_RemoveItemContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_RemoveItem

	return p
}

func (s *OC_RemoveItemContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_RemoveItemContext) OC_Variable() IOC_VariableContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_VariableContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_VariableContext)
}

func (s *OC_RemoveItemContext) OC_NodeLabels() IOC_NodeLabelsContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NodeLabelsContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NodeLabelsContext)
}

func (s *OC_RemoveItemContext) OC_PropertyExpression() IOC_PropertyExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PropertyExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PropertyExpressionContext)
}

func (s *OC_RemoveItemContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_RemoveItemContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_RemoveItemContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_RemoveItem(s)
	}
}

func (s *OC_RemoveItemContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_RemoveItem(s)
	}
}

func (p *CypherParser) OC_RemoveItem() (localctx IOC_RemoveItemContext) {
	localctx = NewOC_RemoveItemContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 90, CypherParserRULE_oC_RemoveItem)
	p.SetState(848)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 88, p.GetParserRuleContext()) {
	case 1:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(844)
			p.OC_Variable()
		}
		{
			p.SetState(845)
			p.OC_NodeLabels()
		}

	case 2:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(847)
			p.OC_PropertyExpression()
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ForeachContext is an interface to support dynamic dispatch.
type IOC_ForeachContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	FOREACH() antlr.TerminalNode
	OC_Variable() IOC_VariableContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	IN() antlr.TerminalNode
	OC_Expression() IOC_ExpressionContext
	AllOC_UpdatingClause() []IOC_UpdatingClauseContext
	OC_UpdatingClause(i int) IOC_UpdatingClauseContext

	// IsOC_ForeachContext differentiates from other interfaces.
	IsOC_ForeachContext()
}

type OC_ForeachContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ForeachContext() *OC_ForeachContext {
	var p = new(OC_ForeachContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Foreach
	return p
}

func InitEmptyOC_ForeachContext(p *OC_ForeachContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Foreach
}

func (*OC_ForeachContext) IsOC_ForeachContext() {}

func NewOC_ForeachContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ForeachContext {
	var p = new(OC_ForeachContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Foreach

	return p
}

func (s *OC_ForeachContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ForeachContext) FOREACH() antlr.TerminalNode {
	return s.GetToken(CypherParserFOREACH, 0)
}

func (s *OC_ForeachContext) OC_Variable() IOC_VariableContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_VariableContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_VariableContext)
}

func (s *OC_ForeachContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_ForeachContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_ForeachContext) IN() antlr.TerminalNode {
	return s.GetToken(CypherParserIN, 0)
}

func (s *OC_ForeachContext) OC_Expression() IOC_ExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_ForeachContext) AllOC_UpdatingClause() []IOC_UpdatingClauseContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_UpdatingClauseContext); ok {
			len++
		}
	}

	tst := make([]IOC_UpdatingClauseContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_UpdatingClauseContext); ok {
			tst[i] = t.(IOC_UpdatingClauseContext)
			i++
		}
	}

	return tst
}

func (s *OC_ForeachContext) OC_UpdatingClause(i int) IOC_UpdatingClauseContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_UpdatingClauseContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_UpdatingClauseContext)
}

func (s *OC_ForeachContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ForeachContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ForeachContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Foreach(s)
	}
}

func (s *OC_ForeachContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Foreach(s)
	}
}

func (p *CypherParser) OC_Foreach() (localctx IOC_ForeachContext) {
	localctx = NewOC_ForeachContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 92, CypherParserRULE_oC_Foreach)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(850)
		p.Match(CypherParserFOREACH)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(852)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(851)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(854)
		p.Match(CypherParserT__2)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(856)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(855)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(858)
		p.OC_Variable()
	}
	{
		p.SetState(859)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(860)
		p.Match(CypherParserIN)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(861)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(862)
		p.OC_Expression()
	}
	p.SetState(864)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(863)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(866)
		p.Match(CypherParserT__8)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(869)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = 1
	for ok := true; ok; ok = _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		switch _alt {
		case 1:
			{
				p.SetState(867)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			{
				p.SetState(868)
				p.OC_UpdatingClause()
			}

		default:
			p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
			goto errorExit
		}

		p.SetState(871)
		p.GetErrorHandler().Sync(p)
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 92, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}
	p.SetState(874)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(873)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(876)
		p.Match(CypherParserT__3)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_InQueryCallContext is an interface to support dynamic dispatch.
type IOC_InQueryCallContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	CALL() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	OC_ExplicitProcedureInvocation() IOC_ExplicitProcedureInvocationContext
	YIELD() antlr.TerminalNode
	OC_YieldItems() IOC_YieldItemsContext

	// IsOC_InQueryCallContext differentiates from other interfaces.
	IsOC_InQueryCallContext()
}

type OC_InQueryCallContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_InQueryCallContext() *OC_InQueryCallContext {
	var p = new(OC_InQueryCallContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_InQueryCall
	return p
}

func InitEmptyOC_InQueryCallContext(p *OC_InQueryCallContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_InQueryCall
}

func (*OC_InQueryCallContext) IsOC_InQueryCallContext() {}

func NewOC_InQueryCallContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_InQueryCallContext {
	var p = new(OC_InQueryCallContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_InQueryCall

	return p
}

func (s *OC_InQueryCallContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_InQueryCallContext) CALL() antlr.TerminalNode {
	return s.GetToken(CypherParserCALL, 0)
}

func (s *OC_InQueryCallContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_InQueryCallContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_InQueryCallContext) OC_ExplicitProcedureInvocation() IOC_ExplicitProcedureInvocationContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExplicitProcedureInvocationContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExplicitProcedureInvocationContext)
}

func (s *OC_InQueryCallContext) YIELD() antlr.TerminalNode {
	return s.GetToken(CypherParserYIELD, 0)
}

func (s *OC_InQueryCallContext) OC_YieldItems() IOC_YieldItemsContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_YieldItemsContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_YieldItemsContext)
}

func (s *OC_InQueryCallContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_InQueryCallContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_InQueryCallContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_InQueryCall(s)
	}
}

func (s *OC_InQueryCallContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_InQueryCall(s)
	}
}

func (p *CypherParser) OC_InQueryCall() (localctx IOC_InQueryCallContext) {
	localctx = NewOC_InQueryCallContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 94, CypherParserRULE_oC_InQueryCall)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(878)
		p.Match(CypherParserCALL)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(879)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(880)
		p.OC_ExplicitProcedureInvocation()
	}
	p.SetState(887)
	p.GetErrorHandler().Sync(p)

	if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 95, p.GetParserRuleContext()) == 1 {
		p.SetState(882)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(881)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(884)
			p.Match(CypherParserYIELD)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(885)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(886)
			p.OC_YieldItems()
		}

	} else if p.HasError() { // JIM
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_StandaloneCallContext is an interface to support dynamic dispatch.
type IOC_StandaloneCallContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	CALL() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	OC_ExplicitProcedureInvocation() IOC_ExplicitProcedureInvocationContext
	OC_ImplicitProcedureInvocation() IOC_ImplicitProcedureInvocationContext
	YIELD() antlr.TerminalNode
	OC_YieldItems() IOC_YieldItemsContext

	// IsOC_StandaloneCallContext differentiates from other interfaces.
	IsOC_StandaloneCallContext()
}

type OC_StandaloneCallContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_StandaloneCallContext() *OC_StandaloneCallContext {
	var p = new(OC_StandaloneCallContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_StandaloneCall
	return p
}

func InitEmptyOC_StandaloneCallContext(p *OC_StandaloneCallContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_StandaloneCall
}

func (*OC_StandaloneCallContext) IsOC_StandaloneCallContext() {}

func NewOC_StandaloneCallContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_StandaloneCallContext {
	var p = new(OC_StandaloneCallContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_StandaloneCall

	return p
}

func (s *OC_StandaloneCallContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_StandaloneCallContext) CALL() antlr.TerminalNode {
	return s.GetToken(CypherParserCALL, 0)
}

func (s *OC_StandaloneCallContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_StandaloneCallContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_StandaloneCallContext) OC_ExplicitProcedureInvocation() IOC_ExplicitProcedureInvocationContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExplicitProcedureInvocationContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExplicitProcedureInvocationContext)
}

func (s *OC_StandaloneCallContext) OC_ImplicitProcedureInvocation() IOC_ImplicitProcedureInvocationContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ImplicitProcedureInvocationContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ImplicitProcedureInvocationContext)
}

func (s *OC_StandaloneCallContext) YIELD() antlr.TerminalNode {
	return s.GetToken(CypherParserYIELD, 0)
}

func (s *OC_StandaloneCallContext) OC_YieldItems() IOC_YieldItemsContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_YieldItemsContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_YieldItemsContext)
}

func (s *OC_StandaloneCallContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_StandaloneCallContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_StandaloneCallContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_StandaloneCall(s)
	}
}

func (s *OC_StandaloneCallContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_StandaloneCall(s)
	}
}

func (p *CypherParser) OC_StandaloneCall() (localctx IOC_StandaloneCallContext) {
	localctx = NewOC_StandaloneCallContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 96, CypherParserRULE_oC_StandaloneCall)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(889)
		p.Match(CypherParserCALL)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(890)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(893)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 96, p.GetParserRuleContext()) {
	case 1:
		{
			p.SetState(891)
			p.OC_ExplicitProcedureInvocation()
		}

	case 2:
		{
			p.SetState(892)
			p.OC_ImplicitProcedureInvocation()
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}
	p.SetState(904)
	p.GetErrorHandler().Sync(p)

	if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 99, p.GetParserRuleContext()) == 1 {
		p.SetState(896)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(895)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(898)
			p.Match(CypherParserYIELD)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(899)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(902)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}

		switch p.GetTokenStream().LA(1) {
		case CypherParserT__9:
			{
				p.SetState(900)
				p.Match(CypherParserT__9)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		case CypherParserCOUNT, CypherParserFILTER, CypherParserEXTRACT, CypherParserANY, CypherParserNONE, CypherParserSINGLE, CypherParserHexLetter, CypherParserUnescapedSymbolicName, CypherParserEscapedSymbolicName:
			{
				p.SetState(901)
				p.OC_YieldItems()
			}

		default:
			p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
			goto errorExit
		}

	} else if p.HasError() { // JIM
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_YieldItemsContext is an interface to support dynamic dispatch.
type IOC_YieldItemsContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllOC_YieldItem() []IOC_YieldItemContext
	OC_YieldItem(i int) IOC_YieldItemContext
	OC_Where() IOC_WhereContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_YieldItemsContext differentiates from other interfaces.
	IsOC_YieldItemsContext()
}

type OC_YieldItemsContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_YieldItemsContext() *OC_YieldItemsContext {
	var p = new(OC_YieldItemsContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_YieldItems
	return p
}

func InitEmptyOC_YieldItemsContext(p *OC_YieldItemsContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_YieldItems
}

func (*OC_YieldItemsContext) IsOC_YieldItemsContext() {}

func NewOC_YieldItemsContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_YieldItemsContext {
	var p = new(OC_YieldItemsContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_YieldItems

	return p
}

func (s *OC_YieldItemsContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_YieldItemsContext) AllOC_YieldItem() []IOC_YieldItemContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_YieldItemContext); ok {
			len++
		}
	}

	tst := make([]IOC_YieldItemContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_YieldItemContext); ok {
			tst[i] = t.(IOC_YieldItemContext)
			i++
		}
	}

	return tst
}

func (s *OC_YieldItemsContext) OC_YieldItem(i int) IOC_YieldItemContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_YieldItemContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_YieldItemContext)
}

func (s *OC_YieldItemsContext) OC_Where() IOC_WhereContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_WhereContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_WhereContext)
}

func (s *OC_YieldItemsContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_YieldItemsContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_YieldItemsContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_YieldItemsContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_YieldItemsContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_YieldItems(s)
	}
}

func (s *OC_YieldItemsContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_YieldItems(s)
	}
}

func (p *CypherParser) OC_YieldItems() (localctx IOC_YieldItemsContext) {
	localctx = NewOC_YieldItemsContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 98, CypherParserRULE_oC_YieldItems)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(906)
		p.OC_YieldItem()
	}
	p.SetState(917)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 102, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			p.SetState(908)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(907)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(910)
				p.Match(CypherParserT__6)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			p.SetState(912)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(911)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(914)
				p.OC_YieldItem()
			}

		}
		p.SetState(919)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 102, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}
	p.SetState(924)
	p.GetErrorHandler().Sync(p)

	if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 104, p.GetParserRuleContext()) == 1 {
		p.SetState(921)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(920)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(923)
			p.OC_Where()
		}

	} else if p.HasError() { // JIM
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_YieldItemContext is an interface to support dynamic dispatch.
type IOC_YieldItemContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_Variable() IOC_VariableContext
	OC_ProcedureResultField() IOC_ProcedureResultFieldContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	AS() antlr.TerminalNode

	// IsOC_YieldItemContext differentiates from other interfaces.
	IsOC_YieldItemContext()
}

type OC_YieldItemContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_YieldItemContext() *OC_YieldItemContext {
	var p = new(OC_YieldItemContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_YieldItem
	return p
}

func InitEmptyOC_YieldItemContext(p *OC_YieldItemContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_YieldItem
}

func (*OC_YieldItemContext) IsOC_YieldItemContext() {}

func NewOC_YieldItemContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_YieldItemContext {
	var p = new(OC_YieldItemContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_YieldItem

	return p
}

func (s *OC_YieldItemContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_YieldItemContext) OC_Variable() IOC_VariableContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_VariableContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_VariableContext)
}

func (s *OC_YieldItemContext) OC_ProcedureResultField() IOC_ProcedureResultFieldContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ProcedureResultFieldContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ProcedureResultFieldContext)
}

func (s *OC_YieldItemContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_YieldItemContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_YieldItemContext) AS() antlr.TerminalNode {
	return s.GetToken(CypherParserAS, 0)
}

func (s *OC_YieldItemContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_YieldItemContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_YieldItemContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_YieldItem(s)
	}
}

func (s *OC_YieldItemContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_YieldItem(s)
	}
}

func (p *CypherParser) OC_YieldItem() (localctx IOC_YieldItemContext) {
	localctx = NewOC_YieldItemContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 100, CypherParserRULE_oC_YieldItem)
	p.EnterOuterAlt(localctx, 1)
	p.SetState(931)
	p.GetErrorHandler().Sync(p)

	if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 105, p.GetParserRuleContext()) == 1 {
		{
			p.SetState(926)
			p.OC_ProcedureResultField()
		}
		{
			p.SetState(927)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(928)
			p.Match(CypherParserAS)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(929)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	} else if p.HasError() { // JIM
		goto errorExit
	}
	{
		p.SetState(933)
		p.OC_Variable()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_WithContext is an interface to support dynamic dispatch.
type IOC_WithContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	WITH() antlr.TerminalNode
	OC_ProjectionBody() IOC_ProjectionBodyContext
	OC_Where() IOC_WhereContext
	SP() antlr.TerminalNode

	// IsOC_WithContext differentiates from other interfaces.
	IsOC_WithContext()
}

type OC_WithContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_WithContext() *OC_WithContext {
	var p = new(OC_WithContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_With
	return p
}

func InitEmptyOC_WithContext(p *OC_WithContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_With
}

func (*OC_WithContext) IsOC_WithContext() {}

func NewOC_WithContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_WithContext {
	var p = new(OC_WithContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_With

	return p
}

func (s *OC_WithContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_WithContext) WITH() antlr.TerminalNode {
	return s.GetToken(CypherParserWITH, 0)
}

func (s *OC_WithContext) OC_ProjectionBody() IOC_ProjectionBodyContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ProjectionBodyContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ProjectionBodyContext)
}

func (s *OC_WithContext) OC_Where() IOC_WhereContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_WhereContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_WhereContext)
}

func (s *OC_WithContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_WithContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_WithContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_WithContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_With(s)
	}
}

func (s *OC_WithContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_With(s)
	}
}

func (p *CypherParser) OC_With() (localctx IOC_WithContext) {
	localctx = NewOC_WithContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 102, CypherParserRULE_oC_With)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(935)
		p.Match(CypherParserWITH)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(936)
		p.OC_ProjectionBody()
	}
	p.SetState(941)
	p.GetErrorHandler().Sync(p)

	if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 107, p.GetParserRuleContext()) == 1 {
		p.SetState(938)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(937)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(940)
			p.OC_Where()
		}

	} else if p.HasError() { // JIM
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ReturnContext is an interface to support dynamic dispatch.
type IOC_ReturnContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	RETURN() antlr.TerminalNode
	OC_ProjectionBody() IOC_ProjectionBodyContext

	// IsOC_ReturnContext differentiates from other interfaces.
	IsOC_ReturnContext()
}

type OC_ReturnContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ReturnContext() *OC_ReturnContext {
	var p = new(OC_ReturnContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Return
	return p
}

func InitEmptyOC_ReturnContext(p *OC_ReturnContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Return
}

func (*OC_ReturnContext) IsOC_ReturnContext() {}

func NewOC_ReturnContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ReturnContext {
	var p = new(OC_ReturnContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Return

	return p
}

func (s *OC_ReturnContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ReturnContext) RETURN() antlr.TerminalNode {
	return s.GetToken(CypherParserRETURN, 0)
}

func (s *OC_ReturnContext) OC_ProjectionBody() IOC_ProjectionBodyContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ProjectionBodyContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ProjectionBodyContext)
}

func (s *OC_ReturnContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ReturnContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ReturnContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Return(s)
	}
}

func (s *OC_ReturnContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Return(s)
	}
}

func (p *CypherParser) OC_Return() (localctx IOC_ReturnContext) {
	localctx = NewOC_ReturnContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 104, CypherParserRULE_oC_Return)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(943)
		p.Match(CypherParserRETURN)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(944)
		p.OC_ProjectionBody()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ProjectionBodyContext is an interface to support dynamic dispatch.
type IOC_ProjectionBodyContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	OC_ProjectionItems() IOC_ProjectionItemsContext
	DISTINCT() antlr.TerminalNode
	OC_Order() IOC_OrderContext
	OC_Skip() IOC_SkipContext
	OC_Limit() IOC_LimitContext

	// IsOC_ProjectionBodyContext differentiates from other interfaces.
	IsOC_ProjectionBodyContext()
}

type OC_ProjectionBodyContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ProjectionBodyContext() *OC_ProjectionBodyContext {
	var p = new(OC_ProjectionBodyContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ProjectionBody
	return p
}

func InitEmptyOC_ProjectionBodyContext(p *OC_ProjectionBodyContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ProjectionBody
}

func (*OC_ProjectionBodyContext) IsOC_ProjectionBodyContext() {}

func NewOC_ProjectionBodyContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ProjectionBodyContext {
	var p = new(OC_ProjectionBodyContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_ProjectionBody

	return p
}

func (s *OC_ProjectionBodyContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ProjectionBodyContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_ProjectionBodyContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_ProjectionBodyContext) OC_ProjectionItems() IOC_ProjectionItemsContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ProjectionItemsContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ProjectionItemsContext)
}

func (s *OC_ProjectionBodyContext) DISTINCT() antlr.TerminalNode {
	return s.GetToken(CypherParserDISTINCT, 0)
}

func (s *OC_ProjectionBodyContext) OC_Order() IOC_OrderContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_OrderContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_OrderContext)
}

func (s *OC_ProjectionBodyContext) OC_Skip() IOC_SkipContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SkipContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SkipContext)
}

func (s *OC_ProjectionBodyContext) OC_Limit() IOC_LimitContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_LimitContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_LimitContext)
}

func (s *OC_ProjectionBodyContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ProjectionBodyContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ProjectionBodyContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_ProjectionBody(s)
	}
}

func (s *OC_ProjectionBodyContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_ProjectionBody(s)
	}
}

func (p *CypherParser) OC_ProjectionBody() (localctx IOC_ProjectionBodyContext) {
	localctx = NewOC_ProjectionBodyContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 106, CypherParserRULE_oC_ProjectionBody)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	p.SetState(950)
	p.GetErrorHandler().Sync(p)

	if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 109, p.GetParserRuleContext()) == 1 {
		p.SetState(947)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(946)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(949)
			p.Match(CypherParserDISTINCT)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	} else if p.HasError() { // JIM
		goto errorExit
	}
	{
		p.SetState(952)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(953)
		p.OC_ProjectionItems()
	}
	p.SetState(956)
	p.GetErrorHandler().Sync(p)

	if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 110, p.GetParserRuleContext()) == 1 {
		{
			p.SetState(954)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(955)
			p.OC_Order()
		}

	} else if p.HasError() { // JIM
		goto errorExit
	}
	p.SetState(960)
	p.GetErrorHandler().Sync(p)

	if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 111, p.GetParserRuleContext()) == 1 {
		{
			p.SetState(958)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(959)
			p.OC_Skip()
		}

	} else if p.HasError() { // JIM
		goto errorExit
	}
	p.SetState(964)
	p.GetErrorHandler().Sync(p)

	if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 112, p.GetParserRuleContext()) == 1 {
		{
			p.SetState(962)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(963)
			p.OC_Limit()
		}

	} else if p.HasError() { // JIM
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ProjectionItemsContext is an interface to support dynamic dispatch.
type IOC_ProjectionItemsContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllOC_ProjectionItem() []IOC_ProjectionItemContext
	OC_ProjectionItem(i int) IOC_ProjectionItemContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_ProjectionItemsContext differentiates from other interfaces.
	IsOC_ProjectionItemsContext()
}

type OC_ProjectionItemsContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ProjectionItemsContext() *OC_ProjectionItemsContext {
	var p = new(OC_ProjectionItemsContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ProjectionItems
	return p
}

func InitEmptyOC_ProjectionItemsContext(p *OC_ProjectionItemsContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ProjectionItems
}

func (*OC_ProjectionItemsContext) IsOC_ProjectionItemsContext() {}

func NewOC_ProjectionItemsContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ProjectionItemsContext {
	var p = new(OC_ProjectionItemsContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_ProjectionItems

	return p
}

func (s *OC_ProjectionItemsContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ProjectionItemsContext) AllOC_ProjectionItem() []IOC_ProjectionItemContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_ProjectionItemContext); ok {
			len++
		}
	}

	tst := make([]IOC_ProjectionItemContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_ProjectionItemContext); ok {
			tst[i] = t.(IOC_ProjectionItemContext)
			i++
		}
	}

	return tst
}

func (s *OC_ProjectionItemsContext) OC_ProjectionItem(i int) IOC_ProjectionItemContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ProjectionItemContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ProjectionItemContext)
}

func (s *OC_ProjectionItemsContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_ProjectionItemsContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_ProjectionItemsContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ProjectionItemsContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ProjectionItemsContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_ProjectionItems(s)
	}
}

func (s *OC_ProjectionItemsContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_ProjectionItems(s)
	}
}

func (p *CypherParser) OC_ProjectionItems() (localctx IOC_ProjectionItemsContext) {
	localctx = NewOC_ProjectionItemsContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 108, CypherParserRULE_oC_ProjectionItems)
	var _la int

	var _alt int

	p.SetState(994)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetTokenStream().LA(1) {
	case CypherParserT__9:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(966)
			p.Match(CypherParserT__9)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(977)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 115, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
		for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
			if _alt == 1 {
				p.SetState(968)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(967)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(970)
					p.Match(CypherParserT__6)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}
				p.SetState(972)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(971)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(974)
					p.OC_ProjectionItem()
				}

			}
			p.SetState(979)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 115, p.GetParserRuleContext())
			if p.HasError() {
				goto errorExit
			}
		}

	case CypherParserT__2, CypherParserT__4, CypherParserT__18, CypherParserT__19, CypherParserT__24, CypherParserT__26, CypherParserALL, CypherParserEXISTS, CypherParserSHORTESTPATH, CypherParserALLSHORTESTPATHS, CypherParserNOT, CypherParserNULL, CypherParserCOUNT, CypherParserCASE, CypherParserFILTER, CypherParserEXTRACT, CypherParserREDUCE, CypherParserANY, CypherParserNONE, CypherParserSINGLE, CypherParserTRUE, CypherParserFALSE, CypherParserHexInteger, CypherParserDecimalInteger, CypherParserOctalInteger, CypherParserHexLetter, CypherParserExponentDecimalReal, CypherParserRegularDecimalReal, CypherParserStringLiteral, CypherParserUnescapedSymbolicName, CypherParserEscapedSymbolicName:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(980)
			p.OC_ProjectionItem()
		}
		p.SetState(991)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 118, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
		for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
			if _alt == 1 {
				p.SetState(982)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(981)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(984)
					p.Match(CypherParserT__6)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}
				p.SetState(986)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(985)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(988)
					p.OC_ProjectionItem()
				}

			}
			p.SetState(993)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 118, p.GetParserRuleContext())
			if p.HasError() {
				goto errorExit
			}
		}

	default:
		p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ProjectionItemContext is an interface to support dynamic dispatch.
type IOC_ProjectionItemContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_Expression() IOC_ExpressionContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	AS() antlr.TerminalNode
	OC_Variable() IOC_VariableContext

	// IsOC_ProjectionItemContext differentiates from other interfaces.
	IsOC_ProjectionItemContext()
}

type OC_ProjectionItemContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ProjectionItemContext() *OC_ProjectionItemContext {
	var p = new(OC_ProjectionItemContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ProjectionItem
	return p
}

func InitEmptyOC_ProjectionItemContext(p *OC_ProjectionItemContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ProjectionItem
}

func (*OC_ProjectionItemContext) IsOC_ProjectionItemContext() {}

func NewOC_ProjectionItemContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ProjectionItemContext {
	var p = new(OC_ProjectionItemContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_ProjectionItem

	return p
}

func (s *OC_ProjectionItemContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ProjectionItemContext) OC_Expression() IOC_ExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_ProjectionItemContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_ProjectionItemContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_ProjectionItemContext) AS() antlr.TerminalNode {
	return s.GetToken(CypherParserAS, 0)
}

func (s *OC_ProjectionItemContext) OC_Variable() IOC_VariableContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_VariableContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_VariableContext)
}

func (s *OC_ProjectionItemContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ProjectionItemContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ProjectionItemContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_ProjectionItem(s)
	}
}

func (s *OC_ProjectionItemContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_ProjectionItem(s)
	}
}

func (p *CypherParser) OC_ProjectionItem() (localctx IOC_ProjectionItemContext) {
	localctx = NewOC_ProjectionItemContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 110, CypherParserRULE_oC_ProjectionItem)
	p.SetState(1003)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 120, p.GetParserRuleContext()) {
	case 1:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(996)
			p.OC_Expression()
		}
		{
			p.SetState(997)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(998)
			p.Match(CypherParserAS)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(999)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1000)
			p.OC_Variable()
		}

	case 2:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(1002)
			p.OC_Expression()
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_OrderContext is an interface to support dynamic dispatch.
type IOC_OrderContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	ORDER() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	BY() antlr.TerminalNode
	AllOC_SortItem() []IOC_SortItemContext
	OC_SortItem(i int) IOC_SortItemContext

	// IsOC_OrderContext differentiates from other interfaces.
	IsOC_OrderContext()
}

type OC_OrderContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_OrderContext() *OC_OrderContext {
	var p = new(OC_OrderContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Order
	return p
}

func InitEmptyOC_OrderContext(p *OC_OrderContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Order
}

func (*OC_OrderContext) IsOC_OrderContext() {}

func NewOC_OrderContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_OrderContext {
	var p = new(OC_OrderContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Order

	return p
}

func (s *OC_OrderContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_OrderContext) ORDER() antlr.TerminalNode {
	return s.GetToken(CypherParserORDER, 0)
}

func (s *OC_OrderContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_OrderContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_OrderContext) BY() antlr.TerminalNode {
	return s.GetToken(CypherParserBY, 0)
}

func (s *OC_OrderContext) AllOC_SortItem() []IOC_SortItemContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_SortItemContext); ok {
			len++
		}
	}

	tst := make([]IOC_SortItemContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_SortItemContext); ok {
			tst[i] = t.(IOC_SortItemContext)
			i++
		}
	}

	return tst
}

func (s *OC_OrderContext) OC_SortItem(i int) IOC_SortItemContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SortItemContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SortItemContext)
}

func (s *OC_OrderContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_OrderContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_OrderContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Order(s)
	}
}

func (s *OC_OrderContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Order(s)
	}
}

func (p *CypherParser) OC_Order() (localctx IOC_OrderContext) {
	localctx = NewOC_OrderContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 112, CypherParserRULE_oC_Order)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1005)
		p.Match(CypherParserORDER)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1006)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1007)
		p.Match(CypherParserBY)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1008)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1009)
		p.OC_SortItem()
	}
	p.SetState(1017)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	for _la == CypherParserT__6 {
		{
			p.SetState(1010)
			p.Match(CypherParserT__6)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1012)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1011)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1014)
			p.OC_SortItem()
		}

		p.SetState(1019)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_SkipContext is an interface to support dynamic dispatch.
type IOC_SkipContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	L_SKIP() antlr.TerminalNode
	SP() antlr.TerminalNode
	OC_Expression() IOC_ExpressionContext

	// IsOC_SkipContext differentiates from other interfaces.
	IsOC_SkipContext()
}

type OC_SkipContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_SkipContext() *OC_SkipContext {
	var p = new(OC_SkipContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Skip
	return p
}

func InitEmptyOC_SkipContext(p *OC_SkipContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Skip
}

func (*OC_SkipContext) IsOC_SkipContext() {}

func NewOC_SkipContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_SkipContext {
	var p = new(OC_SkipContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Skip

	return p
}

func (s *OC_SkipContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_SkipContext) L_SKIP() antlr.TerminalNode {
	return s.GetToken(CypherParserL_SKIP, 0)
}

func (s *OC_SkipContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_SkipContext) OC_Expression() IOC_ExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_SkipContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_SkipContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_SkipContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Skip(s)
	}
}

func (s *OC_SkipContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Skip(s)
	}
}

func (p *CypherParser) OC_Skip() (localctx IOC_SkipContext) {
	localctx = NewOC_SkipContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 114, CypherParserRULE_oC_Skip)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1020)
		p.Match(CypherParserL_SKIP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1021)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1022)
		p.OC_Expression()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_LimitContext is an interface to support dynamic dispatch.
type IOC_LimitContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	LIMIT() antlr.TerminalNode
	SP() antlr.TerminalNode
	OC_Expression() IOC_ExpressionContext

	// IsOC_LimitContext differentiates from other interfaces.
	IsOC_LimitContext()
}

type OC_LimitContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_LimitContext() *OC_LimitContext {
	var p = new(OC_LimitContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Limit
	return p
}

func InitEmptyOC_LimitContext(p *OC_LimitContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Limit
}

func (*OC_LimitContext) IsOC_LimitContext() {}

func NewOC_LimitContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_LimitContext {
	var p = new(OC_LimitContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Limit

	return p
}

func (s *OC_LimitContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_LimitContext) LIMIT() antlr.TerminalNode {
	return s.GetToken(CypherParserLIMIT, 0)
}

func (s *OC_LimitContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_LimitContext) OC_Expression() IOC_ExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_LimitContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_LimitContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_LimitContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Limit(s)
	}
}

func (s *OC_LimitContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Limit(s)
	}
}

func (p *CypherParser) OC_Limit() (localctx IOC_LimitContext) {
	localctx = NewOC_LimitContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 116, CypherParserRULE_oC_Limit)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1024)
		p.Match(CypherParserLIMIT)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1025)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1026)
		p.OC_Expression()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_SortItemContext is an interface to support dynamic dispatch.
type IOC_SortItemContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_Expression() IOC_ExpressionContext
	ASCENDING() antlr.TerminalNode
	ASC() antlr.TerminalNode
	DESCENDING() antlr.TerminalNode
	DESC() antlr.TerminalNode
	SP() antlr.TerminalNode

	// IsOC_SortItemContext differentiates from other interfaces.
	IsOC_SortItemContext()
}

type OC_SortItemContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_SortItemContext() *OC_SortItemContext {
	var p = new(OC_SortItemContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_SortItem
	return p
}

func InitEmptyOC_SortItemContext(p *OC_SortItemContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_SortItem
}

func (*OC_SortItemContext) IsOC_SortItemContext() {}

func NewOC_SortItemContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_SortItemContext {
	var p = new(OC_SortItemContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_SortItem

	return p
}

func (s *OC_SortItemContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_SortItemContext) OC_Expression() IOC_ExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_SortItemContext) ASCENDING() antlr.TerminalNode {
	return s.GetToken(CypherParserASCENDING, 0)
}

func (s *OC_SortItemContext) ASC() antlr.TerminalNode {
	return s.GetToken(CypherParserASC, 0)
}

func (s *OC_SortItemContext) DESCENDING() antlr.TerminalNode {
	return s.GetToken(CypherParserDESCENDING, 0)
}

func (s *OC_SortItemContext) DESC() antlr.TerminalNode {
	return s.GetToken(CypherParserDESC, 0)
}

func (s *OC_SortItemContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_SortItemContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_SortItemContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_SortItemContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_SortItem(s)
	}
}

func (s *OC_SortItemContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_SortItem(s)
	}
}

func (p *CypherParser) OC_SortItem() (localctx IOC_SortItemContext) {
	localctx = NewOC_SortItemContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 118, CypherParserRULE_oC_SortItem)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1028)
		p.OC_Expression()
	}
	p.SetState(1033)
	p.GetErrorHandler().Sync(p)

	if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 124, p.GetParserRuleContext()) == 1 {
		p.SetState(1030)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1029)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1032)
			_la = p.GetTokenStream().LA(1)

			if !((int64((_la-89)) & ^0x3f) == 0 && ((int64(1)<<(_la-89))&15) != 0) {
				p.GetErrorHandler().RecoverInline(p)
			} else {
				p.GetErrorHandler().ReportMatch(p)
				p.Consume()
			}
		}

	} else if p.HasError() { // JIM
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_HintContext is an interface to support dynamic dispatch.
type IOC_HintContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	USING() antlr.TerminalNode
	INDEX() antlr.TerminalNode
	AllOC_Variable() []IOC_VariableContext
	OC_Variable(i int) IOC_VariableContext
	OC_NodeLabel() IOC_NodeLabelContext
	OC_PropertyKeyName() IOC_PropertyKeyNameContext
	JOIN() antlr.TerminalNode
	ON() antlr.TerminalNode
	SCAN() antlr.TerminalNode

	// IsOC_HintContext differentiates from other interfaces.
	IsOC_HintContext()
}

type OC_HintContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_HintContext() *OC_HintContext {
	var p = new(OC_HintContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Hint
	return p
}

func InitEmptyOC_HintContext(p *OC_HintContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Hint
}

func (*OC_HintContext) IsOC_HintContext() {}

func NewOC_HintContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_HintContext {
	var p = new(OC_HintContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Hint

	return p
}

func (s *OC_HintContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_HintContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_HintContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_HintContext) USING() antlr.TerminalNode {
	return s.GetToken(CypherParserUSING, 0)
}

func (s *OC_HintContext) INDEX() antlr.TerminalNode {
	return s.GetToken(CypherParserINDEX, 0)
}

func (s *OC_HintContext) AllOC_Variable() []IOC_VariableContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_VariableContext); ok {
			len++
		}
	}

	tst := make([]IOC_VariableContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_VariableContext); ok {
			tst[i] = t.(IOC_VariableContext)
			i++
		}
	}

	return tst
}

func (s *OC_HintContext) OC_Variable(i int) IOC_VariableContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_VariableContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_VariableContext)
}

func (s *OC_HintContext) OC_NodeLabel() IOC_NodeLabelContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NodeLabelContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NodeLabelContext)
}

func (s *OC_HintContext) OC_PropertyKeyName() IOC_PropertyKeyNameContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PropertyKeyNameContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PropertyKeyNameContext)
}

func (s *OC_HintContext) JOIN() antlr.TerminalNode {
	return s.GetToken(CypherParserJOIN, 0)
}

func (s *OC_HintContext) ON() antlr.TerminalNode {
	return s.GetToken(CypherParserON, 0)
}

func (s *OC_HintContext) SCAN() antlr.TerminalNode {
	return s.GetToken(CypherParserSCAN, 0)
}

func (s *OC_HintContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_HintContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_HintContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Hint(s)
	}
}

func (s *OC_HintContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Hint(s)
	}
}

func (p *CypherParser) OC_Hint() (localctx IOC_HintContext) {
	localctx = NewOC_HintContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 120, CypherParserRULE_oC_Hint)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	p.SetState(1036)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1035)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	p.SetState(1075)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 129, p.GetParserRuleContext()) {
	case 1:
		{
			p.SetState(1038)
			p.Match(CypherParserUSING)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1039)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1040)
			p.Match(CypherParserINDEX)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1041)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1042)
			p.OC_Variable()
		}
		{
			p.SetState(1043)
			p.OC_NodeLabel()
		}
		{
			p.SetState(1044)
			p.Match(CypherParserT__2)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1045)
			p.OC_PropertyKeyName()
		}
		{
			p.SetState(1046)
			p.Match(CypherParserT__3)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case 2:
		{
			p.SetState(1048)
			p.Match(CypherParserUSING)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1049)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1050)
			p.Match(CypherParserJOIN)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1051)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1052)
			p.Match(CypherParserON)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1053)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1054)
			p.OC_Variable()
		}
		p.SetState(1065)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 128, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
		for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
			if _alt == 1 {
				p.SetState(1056)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(1055)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(1058)
					p.Match(CypherParserT__6)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}
				p.SetState(1060)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(1059)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(1062)
					p.OC_Variable()
				}

			}
			p.SetState(1067)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 128, p.GetParserRuleContext())
			if p.HasError() {
				goto errorExit
			}
		}

	case 3:
		{
			p.SetState(1068)
			p.Match(CypherParserUSING)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1069)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1070)
			p.Match(CypherParserSCAN)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1071)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1072)
			p.OC_Variable()
		}
		{
			p.SetState(1073)
			p.OC_NodeLabel()
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_StartContext is an interface to support dynamic dispatch.
type IOC_StartContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	START() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	AllOC_StartPoint() []IOC_StartPointContext
	OC_StartPoint(i int) IOC_StartPointContext
	OC_Where() IOC_WhereContext

	// IsOC_StartContext differentiates from other interfaces.
	IsOC_StartContext()
}

type OC_StartContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_StartContext() *OC_StartContext {
	var p = new(OC_StartContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Start
	return p
}

func InitEmptyOC_StartContext(p *OC_StartContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Start
}

func (*OC_StartContext) IsOC_StartContext() {}

func NewOC_StartContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_StartContext {
	var p = new(OC_StartContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Start

	return p
}

func (s *OC_StartContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_StartContext) START() antlr.TerminalNode {
	return s.GetToken(CypherParserSTART, 0)
}

func (s *OC_StartContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_StartContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_StartContext) AllOC_StartPoint() []IOC_StartPointContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_StartPointContext); ok {
			len++
		}
	}

	tst := make([]IOC_StartPointContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_StartPointContext); ok {
			tst[i] = t.(IOC_StartPointContext)
			i++
		}
	}

	return tst
}

func (s *OC_StartContext) OC_StartPoint(i int) IOC_StartPointContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_StartPointContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_StartPointContext)
}

func (s *OC_StartContext) OC_Where() IOC_WhereContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_WhereContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_WhereContext)
}

func (s *OC_StartContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_StartContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_StartContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Start(s)
	}
}

func (s *OC_StartContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Start(s)
	}
}

func (p *CypherParser) OC_Start() (localctx IOC_StartContext) {
	localctx = NewOC_StartContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 122, CypherParserRULE_oC_Start)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1077)
		p.Match(CypherParserSTART)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1078)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1079)
		p.OC_StartPoint()
	}
	p.SetState(1090)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 132, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			p.SetState(1081)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(1080)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(1083)
				p.Match(CypherParserT__6)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			p.SetState(1085)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(1084)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(1087)
				p.OC_StartPoint()
			}

		}
		p.SetState(1092)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 132, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}
	p.SetState(1094)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserWHERE {
		{
			p.SetState(1093)
			p.OC_Where()
		}

	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_StartPointContext is an interface to support dynamic dispatch.
type IOC_StartPointContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_Variable() IOC_VariableContext
	OC_Lookup() IOC_LookupContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_StartPointContext differentiates from other interfaces.
	IsOC_StartPointContext()
}

type OC_StartPointContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_StartPointContext() *OC_StartPointContext {
	var p = new(OC_StartPointContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_StartPoint
	return p
}

func InitEmptyOC_StartPointContext(p *OC_StartPointContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_StartPoint
}

func (*OC_StartPointContext) IsOC_StartPointContext() {}

func NewOC_StartPointContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_StartPointContext {
	var p = new(OC_StartPointContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_StartPoint

	return p
}

func (s *OC_StartPointContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_StartPointContext) OC_Variable() IOC_VariableContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_VariableContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_VariableContext)
}

func (s *OC_StartPointContext) OC_Lookup() IOC_LookupContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_LookupContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_LookupContext)
}

func (s *OC_StartPointContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_StartPointContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_StartPointContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_StartPointContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_StartPointContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_StartPoint(s)
	}
}

func (s *OC_StartPointContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_StartPoint(s)
	}
}

func (p *CypherParser) OC_StartPoint() (localctx IOC_StartPointContext) {
	localctx = NewOC_StartPointContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 124, CypherParserRULE_oC_StartPoint)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1096)
		p.OC_Variable()
	}
	p.SetState(1098)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1097)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1100)
		p.Match(CypherParserT__1)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1102)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1101)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1104)
		p.OC_Lookup()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_LookupContext is an interface to support dynamic dispatch.
type IOC_LookupContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_NodeLookup() IOC_NodeLookupContext
	OC_RelationshipLookup() IOC_RelationshipLookupContext

	// IsOC_LookupContext differentiates from other interfaces.
	IsOC_LookupContext()
}

type OC_LookupContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_LookupContext() *OC_LookupContext {
	var p = new(OC_LookupContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Lookup
	return p
}

func InitEmptyOC_LookupContext(p *OC_LookupContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Lookup
}

func (*OC_LookupContext) IsOC_LookupContext() {}

func NewOC_LookupContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_LookupContext {
	var p = new(OC_LookupContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Lookup

	return p
}

func (s *OC_LookupContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_LookupContext) OC_NodeLookup() IOC_NodeLookupContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NodeLookupContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NodeLookupContext)
}

func (s *OC_LookupContext) OC_RelationshipLookup() IOC_RelationshipLookupContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_RelationshipLookupContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_RelationshipLookupContext)
}

func (s *OC_LookupContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_LookupContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_LookupContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Lookup(s)
	}
}

func (s *OC_LookupContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Lookup(s)
	}
}

func (p *CypherParser) OC_Lookup() (localctx IOC_LookupContext) {
	localctx = NewOC_LookupContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 126, CypherParserRULE_oC_Lookup)
	p.SetState(1108)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetTokenStream().LA(1) {
	case CypherParserNODE:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(1106)
			p.OC_NodeLookup()
		}

	case CypherParserRELATIONSHIP, CypherParserREL:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(1107)
			p.OC_RelationshipLookup()
		}

	default:
		p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_NodeLookupContext is an interface to support dynamic dispatch.
type IOC_NodeLookupContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	NODE() antlr.TerminalNode
	OC_IdentifiedIndexLookup() IOC_IdentifiedIndexLookupContext
	OC_IndexQuery() IOC_IndexQueryContext
	OC_IdLookup() IOC_IdLookupContext
	SP() antlr.TerminalNode

	// IsOC_NodeLookupContext differentiates from other interfaces.
	IsOC_NodeLookupContext()
}

type OC_NodeLookupContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_NodeLookupContext() *OC_NodeLookupContext {
	var p = new(OC_NodeLookupContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_NodeLookup
	return p
}

func InitEmptyOC_NodeLookupContext(p *OC_NodeLookupContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_NodeLookup
}

func (*OC_NodeLookupContext) IsOC_NodeLookupContext() {}

func NewOC_NodeLookupContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_NodeLookupContext {
	var p = new(OC_NodeLookupContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_NodeLookup

	return p
}

func (s *OC_NodeLookupContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_NodeLookupContext) NODE() antlr.TerminalNode {
	return s.GetToken(CypherParserNODE, 0)
}

func (s *OC_NodeLookupContext) OC_IdentifiedIndexLookup() IOC_IdentifiedIndexLookupContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_IdentifiedIndexLookupContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_IdentifiedIndexLookupContext)
}

func (s *OC_NodeLookupContext) OC_IndexQuery() IOC_IndexQueryContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_IndexQueryContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_IndexQueryContext)
}

func (s *OC_NodeLookupContext) OC_IdLookup() IOC_IdLookupContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_IdLookupContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_IdLookupContext)
}

func (s *OC_NodeLookupContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_NodeLookupContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_NodeLookupContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_NodeLookupContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_NodeLookup(s)
	}
}

func (s *OC_NodeLookupContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_NodeLookup(s)
	}
}

func (p *CypherParser) OC_NodeLookup() (localctx IOC_NodeLookupContext) {
	localctx = NewOC_NodeLookupContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 128, CypherParserRULE_oC_NodeLookup)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1110)
		p.Match(CypherParserNODE)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1112)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1111)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	p.SetState(1117)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 138, p.GetParserRuleContext()) {
	case 1:
		{
			p.SetState(1114)
			p.OC_IdentifiedIndexLookup()
		}

	case 2:
		{
			p.SetState(1115)
			p.OC_IndexQuery()
		}

	case 3:
		{
			p.SetState(1116)
			p.OC_IdLookup()
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_RelationshipLookupContext is an interface to support dynamic dispatch.
type IOC_RelationshipLookupContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	RELATIONSHIP() antlr.TerminalNode
	REL() antlr.TerminalNode
	OC_IdentifiedIndexLookup() IOC_IdentifiedIndexLookupContext
	OC_IndexQuery() IOC_IndexQueryContext
	OC_IdLookup() IOC_IdLookupContext

	// IsOC_RelationshipLookupContext differentiates from other interfaces.
	IsOC_RelationshipLookupContext()
}

type OC_RelationshipLookupContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_RelationshipLookupContext() *OC_RelationshipLookupContext {
	var p = new(OC_RelationshipLookupContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RelationshipLookup
	return p
}

func InitEmptyOC_RelationshipLookupContext(p *OC_RelationshipLookupContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RelationshipLookup
}

func (*OC_RelationshipLookupContext) IsOC_RelationshipLookupContext() {}

func NewOC_RelationshipLookupContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_RelationshipLookupContext {
	var p = new(OC_RelationshipLookupContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_RelationshipLookup

	return p
}

func (s *OC_RelationshipLookupContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_RelationshipLookupContext) RELATIONSHIP() antlr.TerminalNode {
	return s.GetToken(CypherParserRELATIONSHIP, 0)
}

func (s *OC_RelationshipLookupContext) REL() antlr.TerminalNode {
	return s.GetToken(CypherParserREL, 0)
}

func (s *OC_RelationshipLookupContext) OC_IdentifiedIndexLookup() IOC_IdentifiedIndexLookupContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_IdentifiedIndexLookupContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_IdentifiedIndexLookupContext)
}

func (s *OC_RelationshipLookupContext) OC_IndexQuery() IOC_IndexQueryContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_IndexQueryContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_IndexQueryContext)
}

func (s *OC_RelationshipLookupContext) OC_IdLookup() IOC_IdLookupContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_IdLookupContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_IdLookupContext)
}

func (s *OC_RelationshipLookupContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_RelationshipLookupContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_RelationshipLookupContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_RelationshipLookup(s)
	}
}

func (s *OC_RelationshipLookupContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_RelationshipLookup(s)
	}
}

func (p *CypherParser) OC_RelationshipLookup() (localctx IOC_RelationshipLookupContext) {
	localctx = NewOC_RelationshipLookupContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 130, CypherParserRULE_oC_RelationshipLookup)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1119)
		_la = p.GetTokenStream().LA(1)

		if !(_la == CypherParserRELATIONSHIP || _la == CypherParserREL) {
			p.GetErrorHandler().RecoverInline(p)
		} else {
			p.GetErrorHandler().ReportMatch(p)
			p.Consume()
		}
	}
	p.SetState(1123)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 139, p.GetParserRuleContext()) {
	case 1:
		{
			p.SetState(1120)
			p.OC_IdentifiedIndexLookup()
		}

	case 2:
		{
			p.SetState(1121)
			p.OC_IndexQuery()
		}

	case 3:
		{
			p.SetState(1122)
			p.OC_IdLookup()
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_IdentifiedIndexLookupContext is an interface to support dynamic dispatch.
type IOC_IdentifiedIndexLookupContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllOC_SymbolicName() []IOC_SymbolicNameContext
	OC_SymbolicName(i int) IOC_SymbolicNameContext
	StringLiteral() antlr.TerminalNode
	OC_LegacyParameter() IOC_LegacyParameterContext

	// IsOC_IdentifiedIndexLookupContext differentiates from other interfaces.
	IsOC_IdentifiedIndexLookupContext()
}

type OC_IdentifiedIndexLookupContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_IdentifiedIndexLookupContext() *OC_IdentifiedIndexLookupContext {
	var p = new(OC_IdentifiedIndexLookupContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_IdentifiedIndexLookup
	return p
}

func InitEmptyOC_IdentifiedIndexLookupContext(p *OC_IdentifiedIndexLookupContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_IdentifiedIndexLookup
}

func (*OC_IdentifiedIndexLookupContext) IsOC_IdentifiedIndexLookupContext() {}

func NewOC_IdentifiedIndexLookupContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_IdentifiedIndexLookupContext {
	var p = new(OC_IdentifiedIndexLookupContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_IdentifiedIndexLookup

	return p
}

func (s *OC_IdentifiedIndexLookupContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_IdentifiedIndexLookupContext) AllOC_SymbolicName() []IOC_SymbolicNameContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_SymbolicNameContext); ok {
			len++
		}
	}

	tst := make([]IOC_SymbolicNameContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_SymbolicNameContext); ok {
			tst[i] = t.(IOC_SymbolicNameContext)
			i++
		}
	}

	return tst
}

func (s *OC_IdentifiedIndexLookupContext) OC_SymbolicName(i int) IOC_SymbolicNameContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SymbolicNameContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SymbolicNameContext)
}

func (s *OC_IdentifiedIndexLookupContext) StringLiteral() antlr.TerminalNode {
	return s.GetToken(CypherParserStringLiteral, 0)
}

func (s *OC_IdentifiedIndexLookupContext) OC_LegacyParameter() IOC_LegacyParameterContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_LegacyParameterContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_LegacyParameterContext)
}

func (s *OC_IdentifiedIndexLookupContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_IdentifiedIndexLookupContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_IdentifiedIndexLookupContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_IdentifiedIndexLookup(s)
	}
}

func (s *OC_IdentifiedIndexLookupContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_IdentifiedIndexLookup(s)
	}
}

func (p *CypherParser) OC_IdentifiedIndexLookup() (localctx IOC_IdentifiedIndexLookupContext) {
	localctx = NewOC_IdentifiedIndexLookupContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 132, CypherParserRULE_oC_IdentifiedIndexLookup)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1125)
		p.Match(CypherParserT__10)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1126)
		p.OC_SymbolicName()
	}
	{
		p.SetState(1127)
		p.Match(CypherParserT__2)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1128)
		p.OC_SymbolicName()
	}
	{
		p.SetState(1129)
		p.Match(CypherParserT__1)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1132)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetTokenStream().LA(1) {
	case CypherParserStringLiteral:
		{
			p.SetState(1130)
			p.Match(CypherParserStringLiteral)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case CypherParserT__24:
		{
			p.SetState(1131)
			p.OC_LegacyParameter()
		}

	default:
		p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
		goto errorExit
	}
	{
		p.SetState(1134)
		p.Match(CypherParserT__3)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_IndexQueryContext is an interface to support dynamic dispatch.
type IOC_IndexQueryContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_SymbolicName() IOC_SymbolicNameContext
	StringLiteral() antlr.TerminalNode
	OC_LegacyParameter() IOC_LegacyParameterContext

	// IsOC_IndexQueryContext differentiates from other interfaces.
	IsOC_IndexQueryContext()
}

type OC_IndexQueryContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_IndexQueryContext() *OC_IndexQueryContext {
	var p = new(OC_IndexQueryContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_IndexQuery
	return p
}

func InitEmptyOC_IndexQueryContext(p *OC_IndexQueryContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_IndexQuery
}

func (*OC_IndexQueryContext) IsOC_IndexQueryContext() {}

func NewOC_IndexQueryContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_IndexQueryContext {
	var p = new(OC_IndexQueryContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_IndexQuery

	return p
}

func (s *OC_IndexQueryContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_IndexQueryContext) OC_SymbolicName() IOC_SymbolicNameContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SymbolicNameContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SymbolicNameContext)
}

func (s *OC_IndexQueryContext) StringLiteral() antlr.TerminalNode {
	return s.GetToken(CypherParserStringLiteral, 0)
}

func (s *OC_IndexQueryContext) OC_LegacyParameter() IOC_LegacyParameterContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_LegacyParameterContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_LegacyParameterContext)
}

func (s *OC_IndexQueryContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_IndexQueryContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_IndexQueryContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_IndexQuery(s)
	}
}

func (s *OC_IndexQueryContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_IndexQuery(s)
	}
}

func (p *CypherParser) OC_IndexQuery() (localctx IOC_IndexQueryContext) {
	localctx = NewOC_IndexQueryContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 134, CypherParserRULE_oC_IndexQuery)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1136)
		p.Match(CypherParserT__10)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1137)
		p.OC_SymbolicName()
	}
	{
		p.SetState(1138)
		p.Match(CypherParserT__2)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1141)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetTokenStream().LA(1) {
	case CypherParserStringLiteral:
		{
			p.SetState(1139)
			p.Match(CypherParserStringLiteral)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case CypherParserT__24:
		{
			p.SetState(1140)
			p.OC_LegacyParameter()
		}

	default:
		p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
		goto errorExit
	}
	{
		p.SetState(1143)
		p.Match(CypherParserT__3)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_IdLookupContext is an interface to support dynamic dispatch.
type IOC_IdLookupContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_LiteralIds() IOC_LiteralIdsContext
	OC_LegacyParameter() IOC_LegacyParameterContext

	// IsOC_IdLookupContext differentiates from other interfaces.
	IsOC_IdLookupContext()
}

type OC_IdLookupContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_IdLookupContext() *OC_IdLookupContext {
	var p = new(OC_IdLookupContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_IdLookup
	return p
}

func InitEmptyOC_IdLookupContext(p *OC_IdLookupContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_IdLookup
}

func (*OC_IdLookupContext) IsOC_IdLookupContext() {}

func NewOC_IdLookupContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_IdLookupContext {
	var p = new(OC_IdLookupContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_IdLookup

	return p
}

func (s *OC_IdLookupContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_IdLookupContext) OC_LiteralIds() IOC_LiteralIdsContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_LiteralIdsContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_LiteralIdsContext)
}

func (s *OC_IdLookupContext) OC_LegacyParameter() IOC_LegacyParameterContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_LegacyParameterContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_LegacyParameterContext)
}

func (s *OC_IdLookupContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_IdLookupContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_IdLookupContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_IdLookup(s)
	}
}

func (s *OC_IdLookupContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_IdLookup(s)
	}
}

func (p *CypherParser) OC_IdLookup() (localctx IOC_IdLookupContext) {
	localctx = NewOC_IdLookupContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 136, CypherParserRULE_oC_IdLookup)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1145)
		p.Match(CypherParserT__2)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1149)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetTokenStream().LA(1) {
	case CypherParserHexInteger, CypherParserDecimalInteger, CypherParserOctalInteger:
		{
			p.SetState(1146)
			p.OC_LiteralIds()
		}

	case CypherParserT__24:
		{
			p.SetState(1147)
			p.OC_LegacyParameter()
		}

	case CypherParserT__9:
		{
			p.SetState(1148)
			p.Match(CypherParserT__9)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	default:
		p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
		goto errorExit
	}
	{
		p.SetState(1151)
		p.Match(CypherParserT__3)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_LiteralIdsContext is an interface to support dynamic dispatch.
type IOC_LiteralIdsContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllOC_IntegerLiteral() []IOC_IntegerLiteralContext
	OC_IntegerLiteral(i int) IOC_IntegerLiteralContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_LiteralIdsContext differentiates from other interfaces.
	IsOC_LiteralIdsContext()
}

type OC_LiteralIdsContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_LiteralIdsContext() *OC_LiteralIdsContext {
	var p = new(OC_LiteralIdsContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_LiteralIds
	return p
}

func InitEmptyOC_LiteralIdsContext(p *OC_LiteralIdsContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_LiteralIds
}

func (*OC_LiteralIdsContext) IsOC_LiteralIdsContext() {}

func NewOC_LiteralIdsContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_LiteralIdsContext {
	var p = new(OC_LiteralIdsContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_LiteralIds

	return p
}

func (s *OC_LiteralIdsContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_LiteralIdsContext) AllOC_IntegerLiteral() []IOC_IntegerLiteralContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_IntegerLiteralContext); ok {
			len++
		}
	}

	tst := make([]IOC_IntegerLiteralContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_IntegerLiteralContext); ok {
			tst[i] = t.(IOC_IntegerLiteralContext)
			i++
		}
	}

	return tst
}

func (s *OC_LiteralIdsContext) OC_IntegerLiteral(i int) IOC_IntegerLiteralContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_IntegerLiteralContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_IntegerLiteralContext)
}

func (s *OC_LiteralIdsContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_LiteralIdsContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_LiteralIdsContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_LiteralIdsContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_LiteralIdsContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_LiteralIds(s)
	}
}

func (s *OC_LiteralIdsContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_LiteralIds(s)
	}
}

func (p *CypherParser) OC_LiteralIds() (localctx IOC_LiteralIdsContext) {
	localctx = NewOC_LiteralIdsContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 138, CypherParserRULE_oC_LiteralIds)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1153)
		p.OC_IntegerLiteral()
	}
	p.SetState(1164)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	for _la == CypherParserT__6 || _la == CypherParserSP {
		p.SetState(1155)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1154)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1157)
			p.Match(CypherParserT__6)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1159)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1158)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1161)
			p.OC_IntegerLiteral()
		}

		p.SetState(1166)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_WhereContext is an interface to support dynamic dispatch.
type IOC_WhereContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	WHERE() antlr.TerminalNode
	SP() antlr.TerminalNode
	OC_Expression() IOC_ExpressionContext

	// IsOC_WhereContext differentiates from other interfaces.
	IsOC_WhereContext()
}

type OC_WhereContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_WhereContext() *OC_WhereContext {
	var p = new(OC_WhereContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Where
	return p
}

func InitEmptyOC_WhereContext(p *OC_WhereContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Where
}

func (*OC_WhereContext) IsOC_WhereContext() {}

func NewOC_WhereContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_WhereContext {
	var p = new(OC_WhereContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Where

	return p
}

func (s *OC_WhereContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_WhereContext) WHERE() antlr.TerminalNode {
	return s.GetToken(CypherParserWHERE, 0)
}

func (s *OC_WhereContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_WhereContext) OC_Expression() IOC_ExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_WhereContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_WhereContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_WhereContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Where(s)
	}
}

func (s *OC_WhereContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Where(s)
	}
}

func (p *CypherParser) OC_Where() (localctx IOC_WhereContext) {
	localctx = NewOC_WhereContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 140, CypherParserRULE_oC_Where)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1167)
		p.Match(CypherParserWHERE)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1168)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1169)
		p.OC_Expression()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_PatternContext is an interface to support dynamic dispatch.
type IOC_PatternContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllOC_PatternPart() []IOC_PatternPartContext
	OC_PatternPart(i int) IOC_PatternPartContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_PatternContext differentiates from other interfaces.
	IsOC_PatternContext()
}

type OC_PatternContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_PatternContext() *OC_PatternContext {
	var p = new(OC_PatternContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Pattern
	return p
}

func InitEmptyOC_PatternContext(p *OC_PatternContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Pattern
}

func (*OC_PatternContext) IsOC_PatternContext() {}

func NewOC_PatternContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_PatternContext {
	var p = new(OC_PatternContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Pattern

	return p
}

func (s *OC_PatternContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_PatternContext) AllOC_PatternPart() []IOC_PatternPartContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_PatternPartContext); ok {
			len++
		}
	}

	tst := make([]IOC_PatternPartContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_PatternPartContext); ok {
			tst[i] = t.(IOC_PatternPartContext)
			i++
		}
	}

	return tst
}

func (s *OC_PatternContext) OC_PatternPart(i int) IOC_PatternPartContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PatternPartContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PatternPartContext)
}

func (s *OC_PatternContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_PatternContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_PatternContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_PatternContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_PatternContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Pattern(s)
	}
}

func (s *OC_PatternContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Pattern(s)
	}
}

func (p *CypherParser) OC_Pattern() (localctx IOC_PatternContext) {
	localctx = NewOC_PatternContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 142, CypherParserRULE_oC_Pattern)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1171)
		p.OC_PatternPart()
	}
	p.SetState(1182)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 148, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			p.SetState(1173)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(1172)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(1175)
				p.Match(CypherParserT__6)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			p.SetState(1177)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(1176)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(1179)
				p.OC_PatternPart()
			}

		}
		p.SetState(1184)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 148, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_PatternPartContext is an interface to support dynamic dispatch.
type IOC_PatternPartContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_Variable() IOC_VariableContext
	OC_AnonymousPatternPart() IOC_AnonymousPatternPartContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_PatternPartContext differentiates from other interfaces.
	IsOC_PatternPartContext()
}

type OC_PatternPartContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_PatternPartContext() *OC_PatternPartContext {
	var p = new(OC_PatternPartContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PatternPart
	return p
}

func InitEmptyOC_PatternPartContext(p *OC_PatternPartContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PatternPart
}

func (*OC_PatternPartContext) IsOC_PatternPartContext() {}

func NewOC_PatternPartContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_PatternPartContext {
	var p = new(OC_PatternPartContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_PatternPart

	return p
}

func (s *OC_PatternPartContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_PatternPartContext) OC_Variable() IOC_VariableContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_VariableContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_VariableContext)
}

func (s *OC_PatternPartContext) OC_AnonymousPatternPart() IOC_AnonymousPatternPartContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_AnonymousPatternPartContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_AnonymousPatternPartContext)
}

func (s *OC_PatternPartContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_PatternPartContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_PatternPartContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_PatternPartContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_PatternPartContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_PatternPart(s)
	}
}

func (s *OC_PatternPartContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_PatternPart(s)
	}
}

func (p *CypherParser) OC_PatternPart() (localctx IOC_PatternPartContext) {
	localctx = NewOC_PatternPartContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 144, CypherParserRULE_oC_PatternPart)
	var _la int

	p.SetState(1196)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetTokenStream().LA(1) {
	case CypherParserCOUNT, CypherParserFILTER, CypherParserEXTRACT, CypherParserANY, CypherParserNONE, CypherParserSINGLE, CypherParserHexLetter, CypherParserUnescapedSymbolicName, CypherParserEscapedSymbolicName:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(1185)
			p.OC_Variable()
		}
		p.SetState(1187)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1186)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1189)
			p.Match(CypherParserT__1)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1191)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1190)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1193)
			p.OC_AnonymousPatternPart()
		}

	case CypherParserT__2, CypherParserSHORTESTPATH, CypherParserALLSHORTESTPATHS:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(1195)
			p.OC_AnonymousPatternPart()
		}

	default:
		p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_AnonymousPatternPartContext is an interface to support dynamic dispatch.
type IOC_AnonymousPatternPartContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_ShortestPathPattern() IOC_ShortestPathPatternContext
	OC_PatternElement() IOC_PatternElementContext

	// IsOC_AnonymousPatternPartContext differentiates from other interfaces.
	IsOC_AnonymousPatternPartContext()
}

type OC_AnonymousPatternPartContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_AnonymousPatternPartContext() *OC_AnonymousPatternPartContext {
	var p = new(OC_AnonymousPatternPartContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_AnonymousPatternPart
	return p
}

func InitEmptyOC_AnonymousPatternPartContext(p *OC_AnonymousPatternPartContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_AnonymousPatternPart
}

func (*OC_AnonymousPatternPartContext) IsOC_AnonymousPatternPartContext() {}

func NewOC_AnonymousPatternPartContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_AnonymousPatternPartContext {
	var p = new(OC_AnonymousPatternPartContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_AnonymousPatternPart

	return p
}

func (s *OC_AnonymousPatternPartContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_AnonymousPatternPartContext) OC_ShortestPathPattern() IOC_ShortestPathPatternContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ShortestPathPatternContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ShortestPathPatternContext)
}

func (s *OC_AnonymousPatternPartContext) OC_PatternElement() IOC_PatternElementContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PatternElementContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PatternElementContext)
}

func (s *OC_AnonymousPatternPartContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_AnonymousPatternPartContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_AnonymousPatternPartContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_AnonymousPatternPart(s)
	}
}

func (s *OC_AnonymousPatternPartContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_AnonymousPatternPart(s)
	}
}

func (p *CypherParser) OC_AnonymousPatternPart() (localctx IOC_AnonymousPatternPartContext) {
	localctx = NewOC_AnonymousPatternPartContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 146, CypherParserRULE_oC_AnonymousPatternPart)
	p.SetState(1200)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetTokenStream().LA(1) {
	case CypherParserSHORTESTPATH, CypherParserALLSHORTESTPATHS:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(1198)
			p.OC_ShortestPathPattern()
		}

	case CypherParserT__2:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(1199)
			p.OC_PatternElement()
		}

	default:
		p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ShortestPathPatternContext is an interface to support dynamic dispatch.
type IOC_ShortestPathPatternContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	SHORTESTPATH() antlr.TerminalNode
	OC_PatternElement() IOC_PatternElementContext
	ALLSHORTESTPATHS() antlr.TerminalNode

	// IsOC_ShortestPathPatternContext differentiates from other interfaces.
	IsOC_ShortestPathPatternContext()
}

type OC_ShortestPathPatternContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ShortestPathPatternContext() *OC_ShortestPathPatternContext {
	var p = new(OC_ShortestPathPatternContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ShortestPathPattern
	return p
}

func InitEmptyOC_ShortestPathPatternContext(p *OC_ShortestPathPatternContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ShortestPathPattern
}

func (*OC_ShortestPathPatternContext) IsOC_ShortestPathPatternContext() {}

func NewOC_ShortestPathPatternContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ShortestPathPatternContext {
	var p = new(OC_ShortestPathPatternContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_ShortestPathPattern

	return p
}

func (s *OC_ShortestPathPatternContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ShortestPathPatternContext) SHORTESTPATH() antlr.TerminalNode {
	return s.GetToken(CypherParserSHORTESTPATH, 0)
}

func (s *OC_ShortestPathPatternContext) OC_PatternElement() IOC_PatternElementContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PatternElementContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PatternElementContext)
}

func (s *OC_ShortestPathPatternContext) ALLSHORTESTPATHS() antlr.TerminalNode {
	return s.GetToken(CypherParserALLSHORTESTPATHS, 0)
}

func (s *OC_ShortestPathPatternContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ShortestPathPatternContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ShortestPathPatternContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_ShortestPathPattern(s)
	}
}

func (s *OC_ShortestPathPatternContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_ShortestPathPattern(s)
	}
}

func (p *CypherParser) OC_ShortestPathPattern() (localctx IOC_ShortestPathPatternContext) {
	localctx = NewOC_ShortestPathPatternContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 148, CypherParserRULE_oC_ShortestPathPattern)
	p.SetState(1212)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetTokenStream().LA(1) {
	case CypherParserSHORTESTPATH:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(1202)
			p.Match(CypherParserSHORTESTPATH)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1203)
			p.Match(CypherParserT__2)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1204)
			p.OC_PatternElement()
		}
		{
			p.SetState(1205)
			p.Match(CypherParserT__3)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case CypherParserALLSHORTESTPATHS:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(1207)
			p.Match(CypherParserALLSHORTESTPATHS)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1208)
			p.Match(CypherParserT__2)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1209)
			p.OC_PatternElement()
		}
		{
			p.SetState(1210)
			p.Match(CypherParserT__3)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	default:
		p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_PatternElementContext is an interface to support dynamic dispatch.
type IOC_PatternElementContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_NodePattern() IOC_NodePatternContext
	AllOC_PatternElementChain() []IOC_PatternElementChainContext
	OC_PatternElementChain(i int) IOC_PatternElementChainContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	OC_PatternElement() IOC_PatternElementContext

	// IsOC_PatternElementContext differentiates from other interfaces.
	IsOC_PatternElementContext()
}

type OC_PatternElementContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_PatternElementContext() *OC_PatternElementContext {
	var p = new(OC_PatternElementContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PatternElement
	return p
}

func InitEmptyOC_PatternElementContext(p *OC_PatternElementContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PatternElement
}

func (*OC_PatternElementContext) IsOC_PatternElementContext() {}

func NewOC_PatternElementContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_PatternElementContext {
	var p = new(OC_PatternElementContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_PatternElement

	return p
}

func (s *OC_PatternElementContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_PatternElementContext) OC_NodePattern() IOC_NodePatternContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NodePatternContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NodePatternContext)
}

func (s *OC_PatternElementContext) AllOC_PatternElementChain() []IOC_PatternElementChainContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_PatternElementChainContext); ok {
			len++
		}
	}

	tst := make([]IOC_PatternElementChainContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_PatternElementChainContext); ok {
			tst[i] = t.(IOC_PatternElementChainContext)
			i++
		}
	}

	return tst
}

func (s *OC_PatternElementContext) OC_PatternElementChain(i int) IOC_PatternElementChainContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PatternElementChainContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PatternElementChainContext)
}

func (s *OC_PatternElementContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_PatternElementContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_PatternElementContext) OC_PatternElement() IOC_PatternElementContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PatternElementContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PatternElementContext)
}

func (s *OC_PatternElementContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_PatternElementContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_PatternElementContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_PatternElement(s)
	}
}

func (s *OC_PatternElementContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_PatternElement(s)
	}
}

func (p *CypherParser) OC_PatternElement() (localctx IOC_PatternElementContext) {
	localctx = NewOC_PatternElementContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 150, CypherParserRULE_oC_PatternElement)
	var _la int

	var _alt int

	p.SetState(1228)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 156, p.GetParserRuleContext()) {
	case 1:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(1214)
			p.OC_NodePattern()
		}
		p.SetState(1221)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 155, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
		for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
			if _alt == 1 {
				p.SetState(1216)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(1215)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(1218)
					p.OC_PatternElementChain()
				}

			}
			p.SetState(1223)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 155, p.GetParserRuleContext())
			if p.HasError() {
				goto errorExit
			}
		}

	case 2:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(1224)
			p.Match(CypherParserT__2)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1225)
			p.OC_PatternElement()
		}
		{
			p.SetState(1226)
			p.Match(CypherParserT__3)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_RelationshipsPatternContext is an interface to support dynamic dispatch.
type IOC_RelationshipsPatternContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_NodePattern() IOC_NodePatternContext
	AllOC_PatternElementChain() []IOC_PatternElementChainContext
	OC_PatternElementChain(i int) IOC_PatternElementChainContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_RelationshipsPatternContext differentiates from other interfaces.
	IsOC_RelationshipsPatternContext()
}

type OC_RelationshipsPatternContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_RelationshipsPatternContext() *OC_RelationshipsPatternContext {
	var p = new(OC_RelationshipsPatternContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RelationshipsPattern
	return p
}

func InitEmptyOC_RelationshipsPatternContext(p *OC_RelationshipsPatternContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RelationshipsPattern
}

func (*OC_RelationshipsPatternContext) IsOC_RelationshipsPatternContext() {}

func NewOC_RelationshipsPatternContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_RelationshipsPatternContext {
	var p = new(OC_RelationshipsPatternContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_RelationshipsPattern

	return p
}

func (s *OC_RelationshipsPatternContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_RelationshipsPatternContext) OC_NodePattern() IOC_NodePatternContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NodePatternContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NodePatternContext)
}

func (s *OC_RelationshipsPatternContext) AllOC_PatternElementChain() []IOC_PatternElementChainContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_PatternElementChainContext); ok {
			len++
		}
	}

	tst := make([]IOC_PatternElementChainContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_PatternElementChainContext); ok {
			tst[i] = t.(IOC_PatternElementChainContext)
			i++
		}
	}

	return tst
}

func (s *OC_RelationshipsPatternContext) OC_PatternElementChain(i int) IOC_PatternElementChainContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PatternElementChainContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PatternElementChainContext)
}

func (s *OC_RelationshipsPatternContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_RelationshipsPatternContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_RelationshipsPatternContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_RelationshipsPatternContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_RelationshipsPatternContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_RelationshipsPattern(s)
	}
}

func (s *OC_RelationshipsPatternContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_RelationshipsPattern(s)
	}
}

func (p *CypherParser) OC_RelationshipsPattern() (localctx IOC_RelationshipsPatternContext) {
	localctx = NewOC_RelationshipsPatternContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 152, CypherParserRULE_oC_RelationshipsPattern)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1230)
		p.OC_NodePattern()
	}
	p.SetState(1235)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = 1
	for ok := true; ok; ok = _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		switch _alt {
		case 1:
			p.SetState(1232)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(1231)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(1234)
				p.OC_PatternElementChain()
			}

		default:
			p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
			goto errorExit
		}

		p.SetState(1237)
		p.GetErrorHandler().Sync(p)
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 158, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_NodePatternContext is an interface to support dynamic dispatch.
type IOC_NodePatternContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	OC_Variable() IOC_VariableContext
	OC_NodeLabels() IOC_NodeLabelsContext
	OC_Properties() IOC_PropertiesContext

	// IsOC_NodePatternContext differentiates from other interfaces.
	IsOC_NodePatternContext()
}

type OC_NodePatternContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_NodePatternContext() *OC_NodePatternContext {
	var p = new(OC_NodePatternContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_NodePattern
	return p
}

func InitEmptyOC_NodePatternContext(p *OC_NodePatternContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_NodePattern
}

func (*OC_NodePatternContext) IsOC_NodePatternContext() {}

func NewOC_NodePatternContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_NodePatternContext {
	var p = new(OC_NodePatternContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_NodePattern

	return p
}

func (s *OC_NodePatternContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_NodePatternContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_NodePatternContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_NodePatternContext) OC_Variable() IOC_VariableContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_VariableContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_VariableContext)
}

func (s *OC_NodePatternContext) OC_NodeLabels() IOC_NodeLabelsContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NodeLabelsContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NodeLabelsContext)
}

func (s *OC_NodePatternContext) OC_Properties() IOC_PropertiesContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PropertiesContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PropertiesContext)
}

func (s *OC_NodePatternContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_NodePatternContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_NodePatternContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_NodePattern(s)
	}
}

func (s *OC_NodePatternContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_NodePattern(s)
	}
}

func (p *CypherParser) OC_NodePattern() (localctx IOC_NodePatternContext) {
	localctx = NewOC_NodePatternContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 154, CypherParserRULE_oC_NodePattern)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1239)
		p.Match(CypherParserT__2)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1241)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1240)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	p.SetState(1247)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if (int64((_la-110)) & ^0x3f) == 0 && ((int64(1)<<(_la-110))&309237780161) != 0 {
		{
			p.SetState(1243)
			p.OC_Variable()
		}
		p.SetState(1245)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1244)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}

	}
	p.SetState(1253)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserT__10 {
		{
			p.SetState(1249)
			p.OC_NodeLabels()
		}
		p.SetState(1251)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1250)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}

	}
	p.SetState(1259)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserT__24 || _la == CypherParserT__26 {
		{
			p.SetState(1255)
			p.OC_Properties()
		}
		p.SetState(1257)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1256)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}

	}
	{
		p.SetState(1261)
		p.Match(CypherParserT__3)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_PatternElementChainContext is an interface to support dynamic dispatch.
type IOC_PatternElementChainContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_RelationshipPattern() IOC_RelationshipPatternContext
	OC_NodePattern() IOC_NodePatternContext
	SP() antlr.TerminalNode

	// IsOC_PatternElementChainContext differentiates from other interfaces.
	IsOC_PatternElementChainContext()
}

type OC_PatternElementChainContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_PatternElementChainContext() *OC_PatternElementChainContext {
	var p = new(OC_PatternElementChainContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PatternElementChain
	return p
}

func InitEmptyOC_PatternElementChainContext(p *OC_PatternElementChainContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PatternElementChain
}

func (*OC_PatternElementChainContext) IsOC_PatternElementChainContext() {}

func NewOC_PatternElementChainContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_PatternElementChainContext {
	var p = new(OC_PatternElementChainContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_PatternElementChain

	return p
}

func (s *OC_PatternElementChainContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_PatternElementChainContext) OC_RelationshipPattern() IOC_RelationshipPatternContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_RelationshipPatternContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_RelationshipPatternContext)
}

func (s *OC_PatternElementChainContext) OC_NodePattern() IOC_NodePatternContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NodePatternContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NodePatternContext)
}

func (s *OC_PatternElementChainContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_PatternElementChainContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_PatternElementChainContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_PatternElementChainContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_PatternElementChain(s)
	}
}

func (s *OC_PatternElementChainContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_PatternElementChain(s)
	}
}

func (p *CypherParser) OC_PatternElementChain() (localctx IOC_PatternElementChainContext) {
	localctx = NewOC_PatternElementChainContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 156, CypherParserRULE_oC_PatternElementChain)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1263)
		p.OC_RelationshipPattern()
	}
	p.SetState(1265)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1264)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1267)
		p.OC_NodePattern()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_RelationshipPatternContext is an interface to support dynamic dispatch.
type IOC_RelationshipPatternContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_LeftArrowHead() IOC_LeftArrowHeadContext
	AllOC_Dash() []IOC_DashContext
	OC_Dash(i int) IOC_DashContext
	OC_RightArrowHead() IOC_RightArrowHeadContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	OC_RelationshipDetail() IOC_RelationshipDetailContext

	// IsOC_RelationshipPatternContext differentiates from other interfaces.
	IsOC_RelationshipPatternContext()
}

type OC_RelationshipPatternContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_RelationshipPatternContext() *OC_RelationshipPatternContext {
	var p = new(OC_RelationshipPatternContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RelationshipPattern
	return p
}

func InitEmptyOC_RelationshipPatternContext(p *OC_RelationshipPatternContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RelationshipPattern
}

func (*OC_RelationshipPatternContext) IsOC_RelationshipPatternContext() {}

func NewOC_RelationshipPatternContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_RelationshipPatternContext {
	var p = new(OC_RelationshipPatternContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_RelationshipPattern

	return p
}

func (s *OC_RelationshipPatternContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_RelationshipPatternContext) OC_LeftArrowHead() IOC_LeftArrowHeadContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_LeftArrowHeadContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_LeftArrowHeadContext)
}

func (s *OC_RelationshipPatternContext) AllOC_Dash() []IOC_DashContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_DashContext); ok {
			len++
		}
	}

	tst := make([]IOC_DashContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_DashContext); ok {
			tst[i] = t.(IOC_DashContext)
			i++
		}
	}

	return tst
}

func (s *OC_RelationshipPatternContext) OC_Dash(i int) IOC_DashContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_DashContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_DashContext)
}

func (s *OC_RelationshipPatternContext) OC_RightArrowHead() IOC_RightArrowHeadContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_RightArrowHeadContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_RightArrowHeadContext)
}

func (s *OC_RelationshipPatternContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_RelationshipPatternContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_RelationshipPatternContext) OC_RelationshipDetail() IOC_RelationshipDetailContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_RelationshipDetailContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_RelationshipDetailContext)
}

func (s *OC_RelationshipPatternContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_RelationshipPatternContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_RelationshipPatternContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_RelationshipPattern(s)
	}
}

func (s *OC_RelationshipPatternContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_RelationshipPattern(s)
	}
}

func (p *CypherParser) OC_RelationshipPattern() (localctx IOC_RelationshipPatternContext) {
	localctx = NewOC_RelationshipPatternContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 158, CypherParserRULE_oC_RelationshipPattern)
	var _la int

	p.SetState(1333)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 183, p.GetParserRuleContext()) {
	case 1:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(1269)
			p.OC_LeftArrowHead()
		}
		p.SetState(1271)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1270)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1273)
			p.OC_Dash()
		}
		p.SetState(1275)
		p.GetErrorHandler().Sync(p)

		if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 168, p.GetParserRuleContext()) == 1 {
			{
				p.SetState(1274)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		} else if p.HasError() { // JIM
			goto errorExit
		}
		p.SetState(1278)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserT__4 {
			{
				p.SetState(1277)
				p.OC_RelationshipDetail()
			}

		}
		p.SetState(1281)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1280)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1283)
			p.OC_Dash()
		}
		p.SetState(1285)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1284)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1287)
			p.OC_RightArrowHead()
		}

	case 2:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(1289)
			p.OC_LeftArrowHead()
		}
		p.SetState(1291)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1290)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1293)
			p.OC_Dash()
		}
		p.SetState(1295)
		p.GetErrorHandler().Sync(p)

		if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 173, p.GetParserRuleContext()) == 1 {
			{
				p.SetState(1294)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		} else if p.HasError() { // JIM
			goto errorExit
		}
		p.SetState(1298)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserT__4 {
			{
				p.SetState(1297)
				p.OC_RelationshipDetail()
			}

		}
		p.SetState(1301)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1300)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1303)
			p.OC_Dash()
		}

	case 3:
		p.EnterOuterAlt(localctx, 3)
		{
			p.SetState(1305)
			p.OC_Dash()
		}
		p.SetState(1307)
		p.GetErrorHandler().Sync(p)

		if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 176, p.GetParserRuleContext()) == 1 {
			{
				p.SetState(1306)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		} else if p.HasError() { // JIM
			goto errorExit
		}
		p.SetState(1310)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserT__4 {
			{
				p.SetState(1309)
				p.OC_RelationshipDetail()
			}

		}
		p.SetState(1313)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1312)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1315)
			p.OC_Dash()
		}
		p.SetState(1317)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1316)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1319)
			p.OC_RightArrowHead()
		}

	case 4:
		p.EnterOuterAlt(localctx, 4)
		{
			p.SetState(1321)
			p.OC_Dash()
		}
		p.SetState(1323)
		p.GetErrorHandler().Sync(p)

		if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 180, p.GetParserRuleContext()) == 1 {
			{
				p.SetState(1322)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		} else if p.HasError() { // JIM
			goto errorExit
		}
		p.SetState(1326)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserT__4 {
			{
				p.SetState(1325)
				p.OC_RelationshipDetail()
			}

		}
		p.SetState(1329)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1328)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1331)
			p.OC_Dash()
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_RelationshipDetailContext is an interface to support dynamic dispatch.
type IOC_RelationshipDetailContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	OC_Variable() IOC_VariableContext
	OC_RelationshipTypes() IOC_RelationshipTypesContext
	OC_RangeLiteral() IOC_RangeLiteralContext
	OC_Properties() IOC_PropertiesContext

	// IsOC_RelationshipDetailContext differentiates from other interfaces.
	IsOC_RelationshipDetailContext()
}

type OC_RelationshipDetailContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_RelationshipDetailContext() *OC_RelationshipDetailContext {
	var p = new(OC_RelationshipDetailContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RelationshipDetail
	return p
}

func InitEmptyOC_RelationshipDetailContext(p *OC_RelationshipDetailContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RelationshipDetail
}

func (*OC_RelationshipDetailContext) IsOC_RelationshipDetailContext() {}

func NewOC_RelationshipDetailContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_RelationshipDetailContext {
	var p = new(OC_RelationshipDetailContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_RelationshipDetail

	return p
}

func (s *OC_RelationshipDetailContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_RelationshipDetailContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_RelationshipDetailContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_RelationshipDetailContext) OC_Variable() IOC_VariableContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_VariableContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_VariableContext)
}

func (s *OC_RelationshipDetailContext) OC_RelationshipTypes() IOC_RelationshipTypesContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_RelationshipTypesContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_RelationshipTypesContext)
}

func (s *OC_RelationshipDetailContext) OC_RangeLiteral() IOC_RangeLiteralContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_RangeLiteralContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_RangeLiteralContext)
}

func (s *OC_RelationshipDetailContext) OC_Properties() IOC_PropertiesContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PropertiesContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PropertiesContext)
}

func (s *OC_RelationshipDetailContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_RelationshipDetailContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_RelationshipDetailContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_RelationshipDetail(s)
	}
}

func (s *OC_RelationshipDetailContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_RelationshipDetail(s)
	}
}

func (p *CypherParser) OC_RelationshipDetail() (localctx IOC_RelationshipDetailContext) {
	localctx = NewOC_RelationshipDetailContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 160, CypherParserRULE_oC_RelationshipDetail)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1335)
		p.Match(CypherParserT__4)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1337)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1336)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	p.SetState(1343)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if (int64((_la-110)) & ^0x3f) == 0 && ((int64(1)<<(_la-110))&309237780161) != 0 {
		{
			p.SetState(1339)
			p.OC_Variable()
		}
		p.SetState(1341)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1340)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}

	}
	p.SetState(1349)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserT__10 {
		{
			p.SetState(1345)
			p.OC_RelationshipTypes()
		}
		p.SetState(1347)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1346)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}

	}
	p.SetState(1352)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserT__9 {
		{
			p.SetState(1351)
			p.OC_RangeLiteral()
		}

	}
	p.SetState(1358)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserT__24 || _la == CypherParserT__26 {
		{
			p.SetState(1354)
			p.OC_Properties()
		}
		p.SetState(1356)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1355)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}

	}
	{
		p.SetState(1360)
		p.Match(CypherParserT__5)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_PropertiesContext is an interface to support dynamic dispatch.
type IOC_PropertiesContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_MapLiteral() IOC_MapLiteralContext
	OC_Parameter() IOC_ParameterContext
	OC_LegacyParameter() IOC_LegacyParameterContext

	// IsOC_PropertiesContext differentiates from other interfaces.
	IsOC_PropertiesContext()
}

type OC_PropertiesContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_PropertiesContext() *OC_PropertiesContext {
	var p = new(OC_PropertiesContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Properties
	return p
}

func InitEmptyOC_PropertiesContext(p *OC_PropertiesContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Properties
}

func (*OC_PropertiesContext) IsOC_PropertiesContext() {}

func NewOC_PropertiesContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_PropertiesContext {
	var p = new(OC_PropertiesContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Properties

	return p
}

func (s *OC_PropertiesContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_PropertiesContext) OC_MapLiteral() IOC_MapLiteralContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_MapLiteralContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_MapLiteralContext)
}

func (s *OC_PropertiesContext) OC_Parameter() IOC_ParameterContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ParameterContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ParameterContext)
}

func (s *OC_PropertiesContext) OC_LegacyParameter() IOC_LegacyParameterContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_LegacyParameterContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_LegacyParameterContext)
}

func (s *OC_PropertiesContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_PropertiesContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_PropertiesContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Properties(s)
	}
}

func (s *OC_PropertiesContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Properties(s)
	}
}

func (p *CypherParser) OC_Properties() (localctx IOC_PropertiesContext) {
	localctx = NewOC_PropertiesContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 162, CypherParserRULE_oC_Properties)
	p.SetState(1365)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 192, p.GetParserRuleContext()) {
	case 1:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(1362)
			p.OC_MapLiteral()
		}

	case 2:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(1363)
			p.OC_Parameter()
		}

	case 3:
		p.EnterOuterAlt(localctx, 3)
		{
			p.SetState(1364)
			p.OC_LegacyParameter()
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_RelTypeContext is an interface to support dynamic dispatch.
type IOC_RelTypeContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_RelTypeName() IOC_RelTypeNameContext
	SP() antlr.TerminalNode

	// IsOC_RelTypeContext differentiates from other interfaces.
	IsOC_RelTypeContext()
}

type OC_RelTypeContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_RelTypeContext() *OC_RelTypeContext {
	var p = new(OC_RelTypeContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RelType
	return p
}

func InitEmptyOC_RelTypeContext(p *OC_RelTypeContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RelType
}

func (*OC_RelTypeContext) IsOC_RelTypeContext() {}

func NewOC_RelTypeContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_RelTypeContext {
	var p = new(OC_RelTypeContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_RelType

	return p
}

func (s *OC_RelTypeContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_RelTypeContext) OC_RelTypeName() IOC_RelTypeNameContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_RelTypeNameContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_RelTypeNameContext)
}

func (s *OC_RelTypeContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_RelTypeContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_RelTypeContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_RelTypeContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_RelType(s)
	}
}

func (s *OC_RelTypeContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_RelType(s)
	}
}

func (p *CypherParser) OC_RelType() (localctx IOC_RelTypeContext) {
	localctx = NewOC_RelTypeContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 164, CypherParserRULE_oC_RelType)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1367)
		p.Match(CypherParserT__10)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1369)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1368)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1371)
		p.OC_RelTypeName()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_RelationshipTypesContext is an interface to support dynamic dispatch.
type IOC_RelationshipTypesContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllOC_RelTypeName() []IOC_RelTypeNameContext
	OC_RelTypeName(i int) IOC_RelTypeNameContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_RelationshipTypesContext differentiates from other interfaces.
	IsOC_RelationshipTypesContext()
}

type OC_RelationshipTypesContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_RelationshipTypesContext() *OC_RelationshipTypesContext {
	var p = new(OC_RelationshipTypesContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RelationshipTypes
	return p
}

func InitEmptyOC_RelationshipTypesContext(p *OC_RelationshipTypesContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RelationshipTypes
}

func (*OC_RelationshipTypesContext) IsOC_RelationshipTypesContext() {}

func NewOC_RelationshipTypesContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_RelationshipTypesContext {
	var p = new(OC_RelationshipTypesContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_RelationshipTypes

	return p
}

func (s *OC_RelationshipTypesContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_RelationshipTypesContext) AllOC_RelTypeName() []IOC_RelTypeNameContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_RelTypeNameContext); ok {
			len++
		}
	}

	tst := make([]IOC_RelTypeNameContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_RelTypeNameContext); ok {
			tst[i] = t.(IOC_RelTypeNameContext)
			i++
		}
	}

	return tst
}

func (s *OC_RelationshipTypesContext) OC_RelTypeName(i int) IOC_RelTypeNameContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_RelTypeNameContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_RelTypeNameContext)
}

func (s *OC_RelationshipTypesContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_RelationshipTypesContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_RelationshipTypesContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_RelationshipTypesContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_RelationshipTypesContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_RelationshipTypes(s)
	}
}

func (s *OC_RelationshipTypesContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_RelationshipTypes(s)
	}
}

func (p *CypherParser) OC_RelationshipTypes() (localctx IOC_RelationshipTypesContext) {
	localctx = NewOC_RelationshipTypesContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 166, CypherParserRULE_oC_RelationshipTypes)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1373)
		p.Match(CypherParserT__10)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1375)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1374)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1377)
		p.OC_RelTypeName()
	}
	p.SetState(1391)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 198, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			p.SetState(1379)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(1378)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(1381)
				p.Match(CypherParserT__8)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			p.SetState(1383)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserT__10 {
				{
					p.SetState(1382)
					p.Match(CypherParserT__10)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			p.SetState(1386)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(1385)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(1388)
				p.OC_RelTypeName()
			}

		}
		p.SetState(1393)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 198, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_NodeLabelsContext is an interface to support dynamic dispatch.
type IOC_NodeLabelsContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllOC_NodeLabel() []IOC_NodeLabelContext
	OC_NodeLabel(i int) IOC_NodeLabelContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_NodeLabelsContext differentiates from other interfaces.
	IsOC_NodeLabelsContext()
}

type OC_NodeLabelsContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_NodeLabelsContext() *OC_NodeLabelsContext {
	var p = new(OC_NodeLabelsContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_NodeLabels
	return p
}

func InitEmptyOC_NodeLabelsContext(p *OC_NodeLabelsContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_NodeLabels
}

func (*OC_NodeLabelsContext) IsOC_NodeLabelsContext() {}

func NewOC_NodeLabelsContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_NodeLabelsContext {
	var p = new(OC_NodeLabelsContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_NodeLabels

	return p
}

func (s *OC_NodeLabelsContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_NodeLabelsContext) AllOC_NodeLabel() []IOC_NodeLabelContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_NodeLabelContext); ok {
			len++
		}
	}

	tst := make([]IOC_NodeLabelContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_NodeLabelContext); ok {
			tst[i] = t.(IOC_NodeLabelContext)
			i++
		}
	}

	return tst
}

func (s *OC_NodeLabelsContext) OC_NodeLabel(i int) IOC_NodeLabelContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NodeLabelContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NodeLabelContext)
}

func (s *OC_NodeLabelsContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_NodeLabelsContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_NodeLabelsContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_NodeLabelsContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_NodeLabelsContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_NodeLabels(s)
	}
}

func (s *OC_NodeLabelsContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_NodeLabels(s)
	}
}

func (p *CypherParser) OC_NodeLabels() (localctx IOC_NodeLabelsContext) {
	localctx = NewOC_NodeLabelsContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 168, CypherParserRULE_oC_NodeLabels)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1394)
		p.OC_NodeLabel()
	}
	p.SetState(1401)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 200, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			p.SetState(1396)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(1395)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(1398)
				p.OC_NodeLabel()
			}

		}
		p.SetState(1403)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 200, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_NodeLabelContext is an interface to support dynamic dispatch.
type IOC_NodeLabelContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_LabelName() IOC_LabelNameContext
	SP() antlr.TerminalNode

	// IsOC_NodeLabelContext differentiates from other interfaces.
	IsOC_NodeLabelContext()
}

type OC_NodeLabelContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_NodeLabelContext() *OC_NodeLabelContext {
	var p = new(OC_NodeLabelContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_NodeLabel
	return p
}

func InitEmptyOC_NodeLabelContext(p *OC_NodeLabelContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_NodeLabel
}

func (*OC_NodeLabelContext) IsOC_NodeLabelContext() {}

func NewOC_NodeLabelContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_NodeLabelContext {
	var p = new(OC_NodeLabelContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_NodeLabel

	return p
}

func (s *OC_NodeLabelContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_NodeLabelContext) OC_LabelName() IOC_LabelNameContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_LabelNameContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_LabelNameContext)
}

func (s *OC_NodeLabelContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_NodeLabelContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_NodeLabelContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_NodeLabelContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_NodeLabel(s)
	}
}

func (s *OC_NodeLabelContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_NodeLabel(s)
	}
}

func (p *CypherParser) OC_NodeLabel() (localctx IOC_NodeLabelContext) {
	localctx = NewOC_NodeLabelContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 170, CypherParserRULE_oC_NodeLabel)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1404)
		p.Match(CypherParserT__10)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1406)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1405)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1408)
		p.OC_LabelName()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_RangeLiteralContext is an interface to support dynamic dispatch.
type IOC_RangeLiteralContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	AllOC_IntegerLiteral() []IOC_IntegerLiteralContext
	OC_IntegerLiteral(i int) IOC_IntegerLiteralContext

	// IsOC_RangeLiteralContext differentiates from other interfaces.
	IsOC_RangeLiteralContext()
}

type OC_RangeLiteralContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_RangeLiteralContext() *OC_RangeLiteralContext {
	var p = new(OC_RangeLiteralContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RangeLiteral
	return p
}

func InitEmptyOC_RangeLiteralContext(p *OC_RangeLiteralContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RangeLiteral
}

func (*OC_RangeLiteralContext) IsOC_RangeLiteralContext() {}

func NewOC_RangeLiteralContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_RangeLiteralContext {
	var p = new(OC_RangeLiteralContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_RangeLiteral

	return p
}

func (s *OC_RangeLiteralContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_RangeLiteralContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_RangeLiteralContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_RangeLiteralContext) AllOC_IntegerLiteral() []IOC_IntegerLiteralContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_IntegerLiteralContext); ok {
			len++
		}
	}

	tst := make([]IOC_IntegerLiteralContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_IntegerLiteralContext); ok {
			tst[i] = t.(IOC_IntegerLiteralContext)
			i++
		}
	}

	return tst
}

func (s *OC_RangeLiteralContext) OC_IntegerLiteral(i int) IOC_IntegerLiteralContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_IntegerLiteralContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_IntegerLiteralContext)
}

func (s *OC_RangeLiteralContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_RangeLiteralContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_RangeLiteralContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_RangeLiteral(s)
	}
}

func (s *OC_RangeLiteralContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_RangeLiteral(s)
	}
}

func (p *CypherParser) OC_RangeLiteral() (localctx IOC_RangeLiteralContext) {
	localctx = NewOC_RangeLiteralContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 172, CypherParserRULE_oC_RangeLiteral)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1410)
		p.Match(CypherParserT__9)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1412)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1411)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	p.SetState(1418)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if (int64((_la-124)) & ^0x3f) == 0 && ((int64(1)<<(_la-124))&7) != 0 {
		{
			p.SetState(1414)
			p.OC_IntegerLiteral()
		}
		p.SetState(1416)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1415)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}

	}
	p.SetState(1430)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserT__11 {
		{
			p.SetState(1420)
			p.Match(CypherParserT__11)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1422)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1421)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		p.SetState(1428)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if (int64((_la-124)) & ^0x3f) == 0 && ((int64(1)<<(_la-124))&7) != 0 {
			{
				p.SetState(1424)
				p.OC_IntegerLiteral()
			}
			p.SetState(1426)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(1425)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}

		}

	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_LabelNameContext is an interface to support dynamic dispatch.
type IOC_LabelNameContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_SchemaName() IOC_SchemaNameContext

	// IsOC_LabelNameContext differentiates from other interfaces.
	IsOC_LabelNameContext()
}

type OC_LabelNameContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_LabelNameContext() *OC_LabelNameContext {
	var p = new(OC_LabelNameContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_LabelName
	return p
}

func InitEmptyOC_LabelNameContext(p *OC_LabelNameContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_LabelName
}

func (*OC_LabelNameContext) IsOC_LabelNameContext() {}

func NewOC_LabelNameContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_LabelNameContext {
	var p = new(OC_LabelNameContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_LabelName

	return p
}

func (s *OC_LabelNameContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_LabelNameContext) OC_SchemaName() IOC_SchemaNameContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SchemaNameContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SchemaNameContext)
}

func (s *OC_LabelNameContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_LabelNameContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_LabelNameContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_LabelName(s)
	}
}

func (s *OC_LabelNameContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_LabelName(s)
	}
}

func (p *CypherParser) OC_LabelName() (localctx IOC_LabelNameContext) {
	localctx = NewOC_LabelNameContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 174, CypherParserRULE_oC_LabelName)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1432)
		p.OC_SchemaName()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_RelTypeNameContext is an interface to support dynamic dispatch.
type IOC_RelTypeNameContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_SchemaName() IOC_SchemaNameContext

	// IsOC_RelTypeNameContext differentiates from other interfaces.
	IsOC_RelTypeNameContext()
}

type OC_RelTypeNameContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_RelTypeNameContext() *OC_RelTypeNameContext {
	var p = new(OC_RelTypeNameContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RelTypeName
	return p
}

func InitEmptyOC_RelTypeNameContext(p *OC_RelTypeNameContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RelTypeName
}

func (*OC_RelTypeNameContext) IsOC_RelTypeNameContext() {}

func NewOC_RelTypeNameContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_RelTypeNameContext {
	var p = new(OC_RelTypeNameContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_RelTypeName

	return p
}

func (s *OC_RelTypeNameContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_RelTypeNameContext) OC_SchemaName() IOC_SchemaNameContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SchemaNameContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SchemaNameContext)
}

func (s *OC_RelTypeNameContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_RelTypeNameContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_RelTypeNameContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_RelTypeName(s)
	}
}

func (s *OC_RelTypeNameContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_RelTypeName(s)
	}
}

func (p *CypherParser) OC_RelTypeName() (localctx IOC_RelTypeNameContext) {
	localctx = NewOC_RelTypeNameContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 176, CypherParserRULE_oC_RelTypeName)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1434)
		p.OC_SchemaName()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_PropertyExpressionContext is an interface to support dynamic dispatch.
type IOC_PropertyExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_Atom() IOC_AtomContext
	AllOC_PropertyLookup() []IOC_PropertyLookupContext
	OC_PropertyLookup(i int) IOC_PropertyLookupContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_PropertyExpressionContext differentiates from other interfaces.
	IsOC_PropertyExpressionContext()
}

type OC_PropertyExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_PropertyExpressionContext() *OC_PropertyExpressionContext {
	var p = new(OC_PropertyExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PropertyExpression
	return p
}

func InitEmptyOC_PropertyExpressionContext(p *OC_PropertyExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PropertyExpression
}

func (*OC_PropertyExpressionContext) IsOC_PropertyExpressionContext() {}

func NewOC_PropertyExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_PropertyExpressionContext {
	var p = new(OC_PropertyExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_PropertyExpression

	return p
}

func (s *OC_PropertyExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_PropertyExpressionContext) OC_Atom() IOC_AtomContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_AtomContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_AtomContext)
}

func (s *OC_PropertyExpressionContext) AllOC_PropertyLookup() []IOC_PropertyLookupContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_PropertyLookupContext); ok {
			len++
		}
	}

	tst := make([]IOC_PropertyLookupContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_PropertyLookupContext); ok {
			tst[i] = t.(IOC_PropertyLookupContext)
			i++
		}
	}

	return tst
}

func (s *OC_PropertyExpressionContext) OC_PropertyLookup(i int) IOC_PropertyLookupContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PropertyLookupContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PropertyLookupContext)
}

func (s *OC_PropertyExpressionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_PropertyExpressionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_PropertyExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_PropertyExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_PropertyExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_PropertyExpression(s)
	}
}

func (s *OC_PropertyExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_PropertyExpression(s)
	}
}

func (p *CypherParser) OC_PropertyExpression() (localctx IOC_PropertyExpressionContext) {
	localctx = NewOC_PropertyExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 178, CypherParserRULE_oC_PropertyExpression)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1436)
		p.OC_Atom()
	}
	p.SetState(1441)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = 1
	for ok := true; ok; ok = _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		switch _alt {
		case 1:
			p.SetState(1438)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(1437)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(1440)
				p.OC_PropertyLookup()
			}

		default:
			p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
			goto errorExit
		}

		p.SetState(1443)
		p.GetErrorHandler().Sync(p)
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 210, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ExpressionContext is an interface to support dynamic dispatch.
type IOC_ExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_OrExpression() IOC_OrExpressionContext

	// IsOC_ExpressionContext differentiates from other interfaces.
	IsOC_ExpressionContext()
}

type OC_ExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ExpressionContext() *OC_ExpressionContext {
	var p = new(OC_ExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Expression
	return p
}

func InitEmptyOC_ExpressionContext(p *OC_ExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Expression
}

func (*OC_ExpressionContext) IsOC_ExpressionContext() {}

func NewOC_ExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ExpressionContext {
	var p = new(OC_ExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Expression

	return p
}

func (s *OC_ExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ExpressionContext) OC_OrExpression() IOC_OrExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_OrExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_OrExpressionContext)
}

func (s *OC_ExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Expression(s)
	}
}

func (s *OC_ExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Expression(s)
	}
}

func (p *CypherParser) OC_Expression() (localctx IOC_ExpressionContext) {
	localctx = NewOC_ExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 180, CypherParserRULE_oC_Expression)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1445)
		p.OC_OrExpression()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_OrExpressionContext is an interface to support dynamic dispatch.
type IOC_OrExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllOC_XorExpression() []IOC_XorExpressionContext
	OC_XorExpression(i int) IOC_XorExpressionContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	AllOR() []antlr.TerminalNode
	OR(i int) antlr.TerminalNode

	// IsOC_OrExpressionContext differentiates from other interfaces.
	IsOC_OrExpressionContext()
}

type OC_OrExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_OrExpressionContext() *OC_OrExpressionContext {
	var p = new(OC_OrExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_OrExpression
	return p
}

func InitEmptyOC_OrExpressionContext(p *OC_OrExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_OrExpression
}

func (*OC_OrExpressionContext) IsOC_OrExpressionContext() {}

func NewOC_OrExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_OrExpressionContext {
	var p = new(OC_OrExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_OrExpression

	return p
}

func (s *OC_OrExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_OrExpressionContext) AllOC_XorExpression() []IOC_XorExpressionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_XorExpressionContext); ok {
			len++
		}
	}

	tst := make([]IOC_XorExpressionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_XorExpressionContext); ok {
			tst[i] = t.(IOC_XorExpressionContext)
			i++
		}
	}

	return tst
}

func (s *OC_OrExpressionContext) OC_XorExpression(i int) IOC_XorExpressionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_XorExpressionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_XorExpressionContext)
}

func (s *OC_OrExpressionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_OrExpressionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_OrExpressionContext) AllOR() []antlr.TerminalNode {
	return s.GetTokens(CypherParserOR)
}

func (s *OC_OrExpressionContext) OR(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserOR, i)
}

func (s *OC_OrExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_OrExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_OrExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_OrExpression(s)
	}
}

func (s *OC_OrExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_OrExpression(s)
	}
}

func (p *CypherParser) OC_OrExpression() (localctx IOC_OrExpressionContext) {
	localctx = NewOC_OrExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 182, CypherParserRULE_oC_OrExpression)
	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1447)
		p.OC_XorExpression()
	}
	p.SetState(1454)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 211, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			{
				p.SetState(1448)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			{
				p.SetState(1449)
				p.Match(CypherParserOR)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			{
				p.SetState(1450)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			{
				p.SetState(1451)
				p.OC_XorExpression()
			}

		}
		p.SetState(1456)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 211, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_XorExpressionContext is an interface to support dynamic dispatch.
type IOC_XorExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllOC_AndExpression() []IOC_AndExpressionContext
	OC_AndExpression(i int) IOC_AndExpressionContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	AllXOR() []antlr.TerminalNode
	XOR(i int) antlr.TerminalNode

	// IsOC_XorExpressionContext differentiates from other interfaces.
	IsOC_XorExpressionContext()
}

type OC_XorExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_XorExpressionContext() *OC_XorExpressionContext {
	var p = new(OC_XorExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_XorExpression
	return p
}

func InitEmptyOC_XorExpressionContext(p *OC_XorExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_XorExpression
}

func (*OC_XorExpressionContext) IsOC_XorExpressionContext() {}

func NewOC_XorExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_XorExpressionContext {
	var p = new(OC_XorExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_XorExpression

	return p
}

func (s *OC_XorExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_XorExpressionContext) AllOC_AndExpression() []IOC_AndExpressionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_AndExpressionContext); ok {
			len++
		}
	}

	tst := make([]IOC_AndExpressionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_AndExpressionContext); ok {
			tst[i] = t.(IOC_AndExpressionContext)
			i++
		}
	}

	return tst
}

func (s *OC_XorExpressionContext) OC_AndExpression(i int) IOC_AndExpressionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_AndExpressionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_AndExpressionContext)
}

func (s *OC_XorExpressionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_XorExpressionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_XorExpressionContext) AllXOR() []antlr.TerminalNode {
	return s.GetTokens(CypherParserXOR)
}

func (s *OC_XorExpressionContext) XOR(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserXOR, i)
}

func (s *OC_XorExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_XorExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_XorExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_XorExpression(s)
	}
}

func (s *OC_XorExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_XorExpression(s)
	}
}

func (p *CypherParser) OC_XorExpression() (localctx IOC_XorExpressionContext) {
	localctx = NewOC_XorExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 184, CypherParserRULE_oC_XorExpression)
	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1457)
		p.OC_AndExpression()
	}
	p.SetState(1464)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 212, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			{
				p.SetState(1458)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			{
				p.SetState(1459)
				p.Match(CypherParserXOR)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			{
				p.SetState(1460)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			{
				p.SetState(1461)
				p.OC_AndExpression()
			}

		}
		p.SetState(1466)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 212, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_AndExpressionContext is an interface to support dynamic dispatch.
type IOC_AndExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllOC_NotExpression() []IOC_NotExpressionContext
	OC_NotExpression(i int) IOC_NotExpressionContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	AllAND() []antlr.TerminalNode
	AND(i int) antlr.TerminalNode

	// IsOC_AndExpressionContext differentiates from other interfaces.
	IsOC_AndExpressionContext()
}

type OC_AndExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_AndExpressionContext() *OC_AndExpressionContext {
	var p = new(OC_AndExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_AndExpression
	return p
}

func InitEmptyOC_AndExpressionContext(p *OC_AndExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_AndExpression
}

func (*OC_AndExpressionContext) IsOC_AndExpressionContext() {}

func NewOC_AndExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_AndExpressionContext {
	var p = new(OC_AndExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_AndExpression

	return p
}

func (s *OC_AndExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_AndExpressionContext) AllOC_NotExpression() []IOC_NotExpressionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_NotExpressionContext); ok {
			len++
		}
	}

	tst := make([]IOC_NotExpressionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_NotExpressionContext); ok {
			tst[i] = t.(IOC_NotExpressionContext)
			i++
		}
	}

	return tst
}

func (s *OC_AndExpressionContext) OC_NotExpression(i int) IOC_NotExpressionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NotExpressionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NotExpressionContext)
}

func (s *OC_AndExpressionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_AndExpressionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_AndExpressionContext) AllAND() []antlr.TerminalNode {
	return s.GetTokens(CypherParserAND)
}

func (s *OC_AndExpressionContext) AND(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserAND, i)
}

func (s *OC_AndExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_AndExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_AndExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_AndExpression(s)
	}
}

func (s *OC_AndExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_AndExpression(s)
	}
}

func (p *CypherParser) OC_AndExpression() (localctx IOC_AndExpressionContext) {
	localctx = NewOC_AndExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 186, CypherParserRULE_oC_AndExpression)
	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1467)
		p.OC_NotExpression()
	}
	p.SetState(1474)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 213, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			{
				p.SetState(1468)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			{
				p.SetState(1469)
				p.Match(CypherParserAND)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			{
				p.SetState(1470)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			{
				p.SetState(1471)
				p.OC_NotExpression()
			}

		}
		p.SetState(1476)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 213, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_NotExpressionContext is an interface to support dynamic dispatch.
type IOC_NotExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_ComparisonExpression() IOC_ComparisonExpressionContext
	AllNOT() []antlr.TerminalNode
	NOT(i int) antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_NotExpressionContext differentiates from other interfaces.
	IsOC_NotExpressionContext()
}

type OC_NotExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_NotExpressionContext() *OC_NotExpressionContext {
	var p = new(OC_NotExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_NotExpression
	return p
}

func InitEmptyOC_NotExpressionContext(p *OC_NotExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_NotExpression
}

func (*OC_NotExpressionContext) IsOC_NotExpressionContext() {}

func NewOC_NotExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_NotExpressionContext {
	var p = new(OC_NotExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_NotExpression

	return p
}

func (s *OC_NotExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_NotExpressionContext) OC_ComparisonExpression() IOC_ComparisonExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ComparisonExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ComparisonExpressionContext)
}

func (s *OC_NotExpressionContext) AllNOT() []antlr.TerminalNode {
	return s.GetTokens(CypherParserNOT)
}

func (s *OC_NotExpressionContext) NOT(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserNOT, i)
}

func (s *OC_NotExpressionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_NotExpressionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_NotExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_NotExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_NotExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_NotExpression(s)
	}
}

func (s *OC_NotExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_NotExpression(s)
	}
}

func (p *CypherParser) OC_NotExpression() (localctx IOC_NotExpressionContext) {
	localctx = NewOC_NotExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 188, CypherParserRULE_oC_NotExpression)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	p.SetState(1483)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	for _la == CypherParserNOT {
		{
			p.SetState(1477)
			p.Match(CypherParserNOT)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1479)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1478)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}

		p.SetState(1485)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)
	}
	{
		p.SetState(1486)
		p.OC_ComparisonExpression()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ComparisonExpressionContext is an interface to support dynamic dispatch.
type IOC_ComparisonExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_StringListNullPredicateExpression() IOC_StringListNullPredicateExpressionContext
	AllOC_PartialComparisonExpression() []IOC_PartialComparisonExpressionContext
	OC_PartialComparisonExpression(i int) IOC_PartialComparisonExpressionContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_ComparisonExpressionContext differentiates from other interfaces.
	IsOC_ComparisonExpressionContext()
}

type OC_ComparisonExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ComparisonExpressionContext() *OC_ComparisonExpressionContext {
	var p = new(OC_ComparisonExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ComparisonExpression
	return p
}

func InitEmptyOC_ComparisonExpressionContext(p *OC_ComparisonExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ComparisonExpression
}

func (*OC_ComparisonExpressionContext) IsOC_ComparisonExpressionContext() {}

func NewOC_ComparisonExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ComparisonExpressionContext {
	var p = new(OC_ComparisonExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_ComparisonExpression

	return p
}

func (s *OC_ComparisonExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ComparisonExpressionContext) OC_StringListNullPredicateExpression() IOC_StringListNullPredicateExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_StringListNullPredicateExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_StringListNullPredicateExpressionContext)
}

func (s *OC_ComparisonExpressionContext) AllOC_PartialComparisonExpression() []IOC_PartialComparisonExpressionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_PartialComparisonExpressionContext); ok {
			len++
		}
	}

	tst := make([]IOC_PartialComparisonExpressionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_PartialComparisonExpressionContext); ok {
			tst[i] = t.(IOC_PartialComparisonExpressionContext)
			i++
		}
	}

	return tst
}

func (s *OC_ComparisonExpressionContext) OC_PartialComparisonExpression(i int) IOC_PartialComparisonExpressionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PartialComparisonExpressionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PartialComparisonExpressionContext)
}

func (s *OC_ComparisonExpressionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_ComparisonExpressionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_ComparisonExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ComparisonExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ComparisonExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_ComparisonExpression(s)
	}
}

func (s *OC_ComparisonExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_ComparisonExpression(s)
	}
}

func (p *CypherParser) OC_ComparisonExpression() (localctx IOC_ComparisonExpressionContext) {
	localctx = NewOC_ComparisonExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 190, CypherParserRULE_oC_ComparisonExpression)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1488)
		p.OC_StringListNullPredicateExpression()
	}
	p.SetState(1495)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 217, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			p.SetState(1490)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(1489)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(1492)
				p.OC_PartialComparisonExpression()
			}

		}
		p.SetState(1497)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 217, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_PartialComparisonExpressionContext is an interface to support dynamic dispatch.
type IOC_PartialComparisonExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_StringListNullPredicateExpression() IOC_StringListNullPredicateExpressionContext
	SP() antlr.TerminalNode

	// IsOC_PartialComparisonExpressionContext differentiates from other interfaces.
	IsOC_PartialComparisonExpressionContext()
}

type OC_PartialComparisonExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_PartialComparisonExpressionContext() *OC_PartialComparisonExpressionContext {
	var p = new(OC_PartialComparisonExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PartialComparisonExpression
	return p
}

func InitEmptyOC_PartialComparisonExpressionContext(p *OC_PartialComparisonExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PartialComparisonExpression
}

func (*OC_PartialComparisonExpressionContext) IsOC_PartialComparisonExpressionContext() {}

func NewOC_PartialComparisonExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_PartialComparisonExpressionContext {
	var p = new(OC_PartialComparisonExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_PartialComparisonExpression

	return p
}

func (s *OC_PartialComparisonExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_PartialComparisonExpressionContext) OC_StringListNullPredicateExpression() IOC_StringListNullPredicateExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_StringListNullPredicateExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_StringListNullPredicateExpressionContext)
}

func (s *OC_PartialComparisonExpressionContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_PartialComparisonExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_PartialComparisonExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_PartialComparisonExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_PartialComparisonExpression(s)
	}
}

func (s *OC_PartialComparisonExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_PartialComparisonExpression(s)
	}
}

func (p *CypherParser) OC_PartialComparisonExpression() (localctx IOC_PartialComparisonExpressionContext) {
	localctx = NewOC_PartialComparisonExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 192, CypherParserRULE_oC_PartialComparisonExpression)
	var _la int

	p.SetState(1528)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetTokenStream().LA(1) {
	case CypherParserT__1:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(1498)
			p.Match(CypherParserT__1)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1500)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1499)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1502)
			p.OC_StringListNullPredicateExpression()
		}

	case CypherParserT__12:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(1503)
			p.Match(CypherParserT__12)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1505)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1504)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1507)
			p.OC_StringListNullPredicateExpression()
		}

	case CypherParserT__13:
		p.EnterOuterAlt(localctx, 3)
		{
			p.SetState(1508)
			p.Match(CypherParserT__13)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1510)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1509)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1512)
			p.OC_StringListNullPredicateExpression()
		}

	case CypherParserT__14:
		p.EnterOuterAlt(localctx, 4)
		{
			p.SetState(1513)
			p.Match(CypherParserT__14)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1515)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1514)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1517)
			p.OC_StringListNullPredicateExpression()
		}

	case CypherParserT__15:
		p.EnterOuterAlt(localctx, 5)
		{
			p.SetState(1518)
			p.Match(CypherParserT__15)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1520)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1519)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1522)
			p.OC_StringListNullPredicateExpression()
		}

	case CypherParserT__16:
		p.EnterOuterAlt(localctx, 6)
		{
			p.SetState(1523)
			p.Match(CypherParserT__16)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1525)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1524)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1527)
			p.OC_StringListNullPredicateExpression()
		}

	default:
		p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_StringListNullPredicateExpressionContext is an interface to support dynamic dispatch.
type IOC_StringListNullPredicateExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_AddOrSubtractExpression() IOC_AddOrSubtractExpressionContext
	AllOC_StringPredicateExpression() []IOC_StringPredicateExpressionContext
	OC_StringPredicateExpression(i int) IOC_StringPredicateExpressionContext
	AllOC_ListPredicateExpression() []IOC_ListPredicateExpressionContext
	OC_ListPredicateExpression(i int) IOC_ListPredicateExpressionContext
	AllOC_NullPredicateExpression() []IOC_NullPredicateExpressionContext
	OC_NullPredicateExpression(i int) IOC_NullPredicateExpressionContext

	// IsOC_StringListNullPredicateExpressionContext differentiates from other interfaces.
	IsOC_StringListNullPredicateExpressionContext()
}

type OC_StringListNullPredicateExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_StringListNullPredicateExpressionContext() *OC_StringListNullPredicateExpressionContext {
	var p = new(OC_StringListNullPredicateExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_StringListNullPredicateExpression
	return p
}

func InitEmptyOC_StringListNullPredicateExpressionContext(p *OC_StringListNullPredicateExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_StringListNullPredicateExpression
}

func (*OC_StringListNullPredicateExpressionContext) IsOC_StringListNullPredicateExpressionContext() {}

func NewOC_StringListNullPredicateExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_StringListNullPredicateExpressionContext {
	var p = new(OC_StringListNullPredicateExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_StringListNullPredicateExpression

	return p
}

func (s *OC_StringListNullPredicateExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_StringListNullPredicateExpressionContext) OC_AddOrSubtractExpression() IOC_AddOrSubtractExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_AddOrSubtractExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_AddOrSubtractExpressionContext)
}

func (s *OC_StringListNullPredicateExpressionContext) AllOC_StringPredicateExpression() []IOC_StringPredicateExpressionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_StringPredicateExpressionContext); ok {
			len++
		}
	}

	tst := make([]IOC_StringPredicateExpressionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_StringPredicateExpressionContext); ok {
			tst[i] = t.(IOC_StringPredicateExpressionContext)
			i++
		}
	}

	return tst
}

func (s *OC_StringListNullPredicateExpressionContext) OC_StringPredicateExpression(i int) IOC_StringPredicateExpressionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_StringPredicateExpressionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_StringPredicateExpressionContext)
}

func (s *OC_StringListNullPredicateExpressionContext) AllOC_ListPredicateExpression() []IOC_ListPredicateExpressionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_ListPredicateExpressionContext); ok {
			len++
		}
	}

	tst := make([]IOC_ListPredicateExpressionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_ListPredicateExpressionContext); ok {
			tst[i] = t.(IOC_ListPredicateExpressionContext)
			i++
		}
	}

	return tst
}

func (s *OC_StringListNullPredicateExpressionContext) OC_ListPredicateExpression(i int) IOC_ListPredicateExpressionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ListPredicateExpressionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ListPredicateExpressionContext)
}

func (s *OC_StringListNullPredicateExpressionContext) AllOC_NullPredicateExpression() []IOC_NullPredicateExpressionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_NullPredicateExpressionContext); ok {
			len++
		}
	}

	tst := make([]IOC_NullPredicateExpressionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_NullPredicateExpressionContext); ok {
			tst[i] = t.(IOC_NullPredicateExpressionContext)
			i++
		}
	}

	return tst
}

func (s *OC_StringListNullPredicateExpressionContext) OC_NullPredicateExpression(i int) IOC_NullPredicateExpressionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NullPredicateExpressionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NullPredicateExpressionContext)
}

func (s *OC_StringListNullPredicateExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_StringListNullPredicateExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_StringListNullPredicateExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_StringListNullPredicateExpression(s)
	}
}

func (s *OC_StringListNullPredicateExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_StringListNullPredicateExpression(s)
	}
}

func (p *CypherParser) OC_StringListNullPredicateExpression() (localctx IOC_StringListNullPredicateExpressionContext) {
	localctx = NewOC_StringListNullPredicateExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 194, CypherParserRULE_oC_StringListNullPredicateExpression)
	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1530)
		p.OC_AddOrSubtractExpression()
	}
	p.SetState(1536)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 226, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			p.SetState(1534)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}

			switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 225, p.GetParserRuleContext()) {
			case 1:
				{
					p.SetState(1531)
					p.OC_StringPredicateExpression()
				}

			case 2:
				{
					p.SetState(1532)
					p.OC_ListPredicateExpression()
				}

			case 3:
				{
					p.SetState(1533)
					p.OC_NullPredicateExpression()
				}

			case antlr.ATNInvalidAltNumber:
				goto errorExit
			}

		}
		p.SetState(1538)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 226, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_StringPredicateExpressionContext is an interface to support dynamic dispatch.
type IOC_StringPredicateExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_AddOrSubtractExpression() IOC_AddOrSubtractExpressionContext
	OC_RegularExpression() IOC_RegularExpressionContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	STARTS() antlr.TerminalNode
	WITH() antlr.TerminalNode
	ENDS() antlr.TerminalNode
	CONTAINS() antlr.TerminalNode

	// IsOC_StringPredicateExpressionContext differentiates from other interfaces.
	IsOC_StringPredicateExpressionContext()
}

type OC_StringPredicateExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_StringPredicateExpressionContext() *OC_StringPredicateExpressionContext {
	var p = new(OC_StringPredicateExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_StringPredicateExpression
	return p
}

func InitEmptyOC_StringPredicateExpressionContext(p *OC_StringPredicateExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_StringPredicateExpression
}

func (*OC_StringPredicateExpressionContext) IsOC_StringPredicateExpressionContext() {}

func NewOC_StringPredicateExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_StringPredicateExpressionContext {
	var p = new(OC_StringPredicateExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_StringPredicateExpression

	return p
}

func (s *OC_StringPredicateExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_StringPredicateExpressionContext) OC_AddOrSubtractExpression() IOC_AddOrSubtractExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_AddOrSubtractExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_AddOrSubtractExpressionContext)
}

func (s *OC_StringPredicateExpressionContext) OC_RegularExpression() IOC_RegularExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_RegularExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_RegularExpressionContext)
}

func (s *OC_StringPredicateExpressionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_StringPredicateExpressionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_StringPredicateExpressionContext) STARTS() antlr.TerminalNode {
	return s.GetToken(CypherParserSTARTS, 0)
}

func (s *OC_StringPredicateExpressionContext) WITH() antlr.TerminalNode {
	return s.GetToken(CypherParserWITH, 0)
}

func (s *OC_StringPredicateExpressionContext) ENDS() antlr.TerminalNode {
	return s.GetToken(CypherParserENDS, 0)
}

func (s *OC_StringPredicateExpressionContext) CONTAINS() antlr.TerminalNode {
	return s.GetToken(CypherParserCONTAINS, 0)
}

func (s *OC_StringPredicateExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_StringPredicateExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_StringPredicateExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_StringPredicateExpression(s)
	}
}

func (s *OC_StringPredicateExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_StringPredicateExpression(s)
	}
}

func (p *CypherParser) OC_StringPredicateExpression() (localctx IOC_StringPredicateExpressionContext) {
	localctx = NewOC_StringPredicateExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 196, CypherParserRULE_oC_StringPredicateExpression)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	p.SetState(1550)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 227, p.GetParserRuleContext()) {
	case 1:
		{
			p.SetState(1539)
			p.OC_RegularExpression()
		}

	case 2:
		{
			p.SetState(1540)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1541)
			p.Match(CypherParserSTARTS)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1542)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1543)
			p.Match(CypherParserWITH)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case 3:
		{
			p.SetState(1544)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1545)
			p.Match(CypherParserENDS)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1546)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1547)
			p.Match(CypherParserWITH)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case 4:
		{
			p.SetState(1548)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1549)
			p.Match(CypherParserCONTAINS)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}
	p.SetState(1553)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1552)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1555)
		p.OC_AddOrSubtractExpression()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ListPredicateExpressionContext is an interface to support dynamic dispatch.
type IOC_ListPredicateExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	IN() antlr.TerminalNode
	OC_AddOrSubtractExpression() IOC_AddOrSubtractExpressionContext

	// IsOC_ListPredicateExpressionContext differentiates from other interfaces.
	IsOC_ListPredicateExpressionContext()
}

type OC_ListPredicateExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ListPredicateExpressionContext() *OC_ListPredicateExpressionContext {
	var p = new(OC_ListPredicateExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ListPredicateExpression
	return p
}

func InitEmptyOC_ListPredicateExpressionContext(p *OC_ListPredicateExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ListPredicateExpression
}

func (*OC_ListPredicateExpressionContext) IsOC_ListPredicateExpressionContext() {}

func NewOC_ListPredicateExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ListPredicateExpressionContext {
	var p = new(OC_ListPredicateExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_ListPredicateExpression

	return p
}

func (s *OC_ListPredicateExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ListPredicateExpressionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_ListPredicateExpressionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_ListPredicateExpressionContext) IN() antlr.TerminalNode {
	return s.GetToken(CypherParserIN, 0)
}

func (s *OC_ListPredicateExpressionContext) OC_AddOrSubtractExpression() IOC_AddOrSubtractExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_AddOrSubtractExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_AddOrSubtractExpressionContext)
}

func (s *OC_ListPredicateExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ListPredicateExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ListPredicateExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_ListPredicateExpression(s)
	}
}

func (s *OC_ListPredicateExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_ListPredicateExpression(s)
	}
}

func (p *CypherParser) OC_ListPredicateExpression() (localctx IOC_ListPredicateExpressionContext) {
	localctx = NewOC_ListPredicateExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 198, CypherParserRULE_oC_ListPredicateExpression)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1557)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1558)
		p.Match(CypherParserIN)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1560)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1559)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1562)
		p.OC_AddOrSubtractExpression()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_NullPredicateExpressionContext is an interface to support dynamic dispatch.
type IOC_NullPredicateExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	IS() antlr.TerminalNode
	NULL() antlr.TerminalNode
	NOT() antlr.TerminalNode

	// IsOC_NullPredicateExpressionContext differentiates from other interfaces.
	IsOC_NullPredicateExpressionContext()
}

type OC_NullPredicateExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_NullPredicateExpressionContext() *OC_NullPredicateExpressionContext {
	var p = new(OC_NullPredicateExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_NullPredicateExpression
	return p
}

func InitEmptyOC_NullPredicateExpressionContext(p *OC_NullPredicateExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_NullPredicateExpression
}

func (*OC_NullPredicateExpressionContext) IsOC_NullPredicateExpressionContext() {}

func NewOC_NullPredicateExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_NullPredicateExpressionContext {
	var p = new(OC_NullPredicateExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_NullPredicateExpression

	return p
}

func (s *OC_NullPredicateExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_NullPredicateExpressionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_NullPredicateExpressionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_NullPredicateExpressionContext) IS() antlr.TerminalNode {
	return s.GetToken(CypherParserIS, 0)
}

func (s *OC_NullPredicateExpressionContext) NULL() antlr.TerminalNode {
	return s.GetToken(CypherParserNULL, 0)
}

func (s *OC_NullPredicateExpressionContext) NOT() antlr.TerminalNode {
	return s.GetToken(CypherParserNOT, 0)
}

func (s *OC_NullPredicateExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_NullPredicateExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_NullPredicateExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_NullPredicateExpression(s)
	}
}

func (s *OC_NullPredicateExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_NullPredicateExpression(s)
	}
}

func (p *CypherParser) OC_NullPredicateExpression() (localctx IOC_NullPredicateExpressionContext) {
	localctx = NewOC_NullPredicateExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 200, CypherParserRULE_oC_NullPredicateExpression)
	p.SetState(1574)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 230, p.GetParserRuleContext()) {
	case 1:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(1564)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1565)
			p.Match(CypherParserIS)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1566)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1567)
			p.Match(CypherParserNULL)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case 2:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(1568)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1569)
			p.Match(CypherParserIS)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1570)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1571)
			p.Match(CypherParserNOT)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1572)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1573)
			p.Match(CypherParserNULL)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_RegularExpressionContext is an interface to support dynamic dispatch.
type IOC_RegularExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	SP() antlr.TerminalNode

	// IsOC_RegularExpressionContext differentiates from other interfaces.
	IsOC_RegularExpressionContext()
}

type OC_RegularExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_RegularExpressionContext() *OC_RegularExpressionContext {
	var p = new(OC_RegularExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RegularExpression
	return p
}

func InitEmptyOC_RegularExpressionContext(p *OC_RegularExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RegularExpression
}

func (*OC_RegularExpressionContext) IsOC_RegularExpressionContext() {}

func NewOC_RegularExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_RegularExpressionContext {
	var p = new(OC_RegularExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_RegularExpression

	return p
}

func (s *OC_RegularExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_RegularExpressionContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_RegularExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_RegularExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_RegularExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_RegularExpression(s)
	}
}

func (s *OC_RegularExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_RegularExpression(s)
	}
}

func (p *CypherParser) OC_RegularExpression() (localctx IOC_RegularExpressionContext) {
	localctx = NewOC_RegularExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 202, CypherParserRULE_oC_RegularExpression)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	p.SetState(1577)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1576)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1579)
		p.Match(CypherParserT__17)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_AddOrSubtractExpressionContext is an interface to support dynamic dispatch.
type IOC_AddOrSubtractExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllOC_MultiplyDivideModuloExpression() []IOC_MultiplyDivideModuloExpressionContext
	OC_MultiplyDivideModuloExpression(i int) IOC_MultiplyDivideModuloExpressionContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_AddOrSubtractExpressionContext differentiates from other interfaces.
	IsOC_AddOrSubtractExpressionContext()
}

type OC_AddOrSubtractExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_AddOrSubtractExpressionContext() *OC_AddOrSubtractExpressionContext {
	var p = new(OC_AddOrSubtractExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_AddOrSubtractExpression
	return p
}

func InitEmptyOC_AddOrSubtractExpressionContext(p *OC_AddOrSubtractExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_AddOrSubtractExpression
}

func (*OC_AddOrSubtractExpressionContext) IsOC_AddOrSubtractExpressionContext() {}

func NewOC_AddOrSubtractExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_AddOrSubtractExpressionContext {
	var p = new(OC_AddOrSubtractExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_AddOrSubtractExpression

	return p
}

func (s *OC_AddOrSubtractExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_AddOrSubtractExpressionContext) AllOC_MultiplyDivideModuloExpression() []IOC_MultiplyDivideModuloExpressionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_MultiplyDivideModuloExpressionContext); ok {
			len++
		}
	}

	tst := make([]IOC_MultiplyDivideModuloExpressionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_MultiplyDivideModuloExpressionContext); ok {
			tst[i] = t.(IOC_MultiplyDivideModuloExpressionContext)
			i++
		}
	}

	return tst
}

func (s *OC_AddOrSubtractExpressionContext) OC_MultiplyDivideModuloExpression(i int) IOC_MultiplyDivideModuloExpressionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_MultiplyDivideModuloExpressionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_MultiplyDivideModuloExpressionContext)
}

func (s *OC_AddOrSubtractExpressionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_AddOrSubtractExpressionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_AddOrSubtractExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_AddOrSubtractExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_AddOrSubtractExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_AddOrSubtractExpression(s)
	}
}

func (s *OC_AddOrSubtractExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_AddOrSubtractExpression(s)
	}
}

func (p *CypherParser) OC_AddOrSubtractExpression() (localctx IOC_AddOrSubtractExpressionContext) {
	localctx = NewOC_AddOrSubtractExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 204, CypherParserRULE_oC_AddOrSubtractExpression)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1581)
		p.OC_MultiplyDivideModuloExpression()
	}
	p.SetState(1600)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 237, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			p.SetState(1598)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}

			switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 236, p.GetParserRuleContext()) {
			case 1:
				p.SetState(1583)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(1582)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(1585)
					p.Match(CypherParserT__18)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}
				p.SetState(1587)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(1586)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(1589)
					p.OC_MultiplyDivideModuloExpression()
				}

			case 2:
				p.SetState(1591)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(1590)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(1593)
					p.Match(CypherParserT__19)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}
				p.SetState(1595)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(1594)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(1597)
					p.OC_MultiplyDivideModuloExpression()
				}

			case antlr.ATNInvalidAltNumber:
				goto errorExit
			}

		}
		p.SetState(1602)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 237, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_MultiplyDivideModuloExpressionContext is an interface to support dynamic dispatch.
type IOC_MultiplyDivideModuloExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllOC_PowerOfExpression() []IOC_PowerOfExpressionContext
	OC_PowerOfExpression(i int) IOC_PowerOfExpressionContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_MultiplyDivideModuloExpressionContext differentiates from other interfaces.
	IsOC_MultiplyDivideModuloExpressionContext()
}

type OC_MultiplyDivideModuloExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_MultiplyDivideModuloExpressionContext() *OC_MultiplyDivideModuloExpressionContext {
	var p = new(OC_MultiplyDivideModuloExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_MultiplyDivideModuloExpression
	return p
}

func InitEmptyOC_MultiplyDivideModuloExpressionContext(p *OC_MultiplyDivideModuloExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_MultiplyDivideModuloExpression
}

func (*OC_MultiplyDivideModuloExpressionContext) IsOC_MultiplyDivideModuloExpressionContext() {}

func NewOC_MultiplyDivideModuloExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_MultiplyDivideModuloExpressionContext {
	var p = new(OC_MultiplyDivideModuloExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_MultiplyDivideModuloExpression

	return p
}

func (s *OC_MultiplyDivideModuloExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_MultiplyDivideModuloExpressionContext) AllOC_PowerOfExpression() []IOC_PowerOfExpressionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_PowerOfExpressionContext); ok {
			len++
		}
	}

	tst := make([]IOC_PowerOfExpressionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_PowerOfExpressionContext); ok {
			tst[i] = t.(IOC_PowerOfExpressionContext)
			i++
		}
	}

	return tst
}

func (s *OC_MultiplyDivideModuloExpressionContext) OC_PowerOfExpression(i int) IOC_PowerOfExpressionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PowerOfExpressionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PowerOfExpressionContext)
}

func (s *OC_MultiplyDivideModuloExpressionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_MultiplyDivideModuloExpressionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_MultiplyDivideModuloExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_MultiplyDivideModuloExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_MultiplyDivideModuloExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_MultiplyDivideModuloExpression(s)
	}
}

func (s *OC_MultiplyDivideModuloExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_MultiplyDivideModuloExpression(s)
	}
}

func (p *CypherParser) OC_MultiplyDivideModuloExpression() (localctx IOC_MultiplyDivideModuloExpressionContext) {
	localctx = NewOC_MultiplyDivideModuloExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 206, CypherParserRULE_oC_MultiplyDivideModuloExpression)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1603)
		p.OC_PowerOfExpression()
	}
	p.SetState(1630)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 245, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			p.SetState(1628)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}

			switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 244, p.GetParserRuleContext()) {
			case 1:
				p.SetState(1605)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(1604)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(1607)
					p.Match(CypherParserT__9)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}
				p.SetState(1609)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(1608)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(1611)
					p.OC_PowerOfExpression()
				}

			case 2:
				p.SetState(1613)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(1612)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(1615)
					p.Match(CypherParserT__20)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}
				p.SetState(1617)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(1616)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(1619)
					p.OC_PowerOfExpression()
				}

			case 3:
				p.SetState(1621)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(1620)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(1623)
					p.Match(CypherParserT__21)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}
				p.SetState(1625)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(1624)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(1627)
					p.OC_PowerOfExpression()
				}

			case antlr.ATNInvalidAltNumber:
				goto errorExit
			}

		}
		p.SetState(1632)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 245, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_PowerOfExpressionContext is an interface to support dynamic dispatch.
type IOC_PowerOfExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllOC_UnaryAddOrSubtractExpression() []IOC_UnaryAddOrSubtractExpressionContext
	OC_UnaryAddOrSubtractExpression(i int) IOC_UnaryAddOrSubtractExpressionContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_PowerOfExpressionContext differentiates from other interfaces.
	IsOC_PowerOfExpressionContext()
}

type OC_PowerOfExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_PowerOfExpressionContext() *OC_PowerOfExpressionContext {
	var p = new(OC_PowerOfExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PowerOfExpression
	return p
}

func InitEmptyOC_PowerOfExpressionContext(p *OC_PowerOfExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PowerOfExpression
}

func (*OC_PowerOfExpressionContext) IsOC_PowerOfExpressionContext() {}

func NewOC_PowerOfExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_PowerOfExpressionContext {
	var p = new(OC_PowerOfExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_PowerOfExpression

	return p
}

func (s *OC_PowerOfExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_PowerOfExpressionContext) AllOC_UnaryAddOrSubtractExpression() []IOC_UnaryAddOrSubtractExpressionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_UnaryAddOrSubtractExpressionContext); ok {
			len++
		}
	}

	tst := make([]IOC_UnaryAddOrSubtractExpressionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_UnaryAddOrSubtractExpressionContext); ok {
			tst[i] = t.(IOC_UnaryAddOrSubtractExpressionContext)
			i++
		}
	}

	return tst
}

func (s *OC_PowerOfExpressionContext) OC_UnaryAddOrSubtractExpression(i int) IOC_UnaryAddOrSubtractExpressionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_UnaryAddOrSubtractExpressionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_UnaryAddOrSubtractExpressionContext)
}

func (s *OC_PowerOfExpressionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_PowerOfExpressionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_PowerOfExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_PowerOfExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_PowerOfExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_PowerOfExpression(s)
	}
}

func (s *OC_PowerOfExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_PowerOfExpression(s)
	}
}

func (p *CypherParser) OC_PowerOfExpression() (localctx IOC_PowerOfExpressionContext) {
	localctx = NewOC_PowerOfExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 208, CypherParserRULE_oC_PowerOfExpression)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1633)
		p.OC_UnaryAddOrSubtractExpression()
	}
	p.SetState(1644)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 248, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			p.SetState(1635)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(1634)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(1637)
				p.Match(CypherParserT__22)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			p.SetState(1639)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(1638)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(1641)
				p.OC_UnaryAddOrSubtractExpression()
			}

		}
		p.SetState(1646)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 248, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_UnaryAddOrSubtractExpressionContext is an interface to support dynamic dispatch.
type IOC_UnaryAddOrSubtractExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_NonArithmeticOperatorExpression() IOC_NonArithmeticOperatorExpressionContext
	SP() antlr.TerminalNode

	// IsOC_UnaryAddOrSubtractExpressionContext differentiates from other interfaces.
	IsOC_UnaryAddOrSubtractExpressionContext()
}

type OC_UnaryAddOrSubtractExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_UnaryAddOrSubtractExpressionContext() *OC_UnaryAddOrSubtractExpressionContext {
	var p = new(OC_UnaryAddOrSubtractExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_UnaryAddOrSubtractExpression
	return p
}

func InitEmptyOC_UnaryAddOrSubtractExpressionContext(p *OC_UnaryAddOrSubtractExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_UnaryAddOrSubtractExpression
}

func (*OC_UnaryAddOrSubtractExpressionContext) IsOC_UnaryAddOrSubtractExpressionContext() {}

func NewOC_UnaryAddOrSubtractExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_UnaryAddOrSubtractExpressionContext {
	var p = new(OC_UnaryAddOrSubtractExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_UnaryAddOrSubtractExpression

	return p
}

func (s *OC_UnaryAddOrSubtractExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_UnaryAddOrSubtractExpressionContext) OC_NonArithmeticOperatorExpression() IOC_NonArithmeticOperatorExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NonArithmeticOperatorExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NonArithmeticOperatorExpressionContext)
}

func (s *OC_UnaryAddOrSubtractExpressionContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_UnaryAddOrSubtractExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_UnaryAddOrSubtractExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_UnaryAddOrSubtractExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_UnaryAddOrSubtractExpression(s)
	}
}

func (s *OC_UnaryAddOrSubtractExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_UnaryAddOrSubtractExpression(s)
	}
}

func (p *CypherParser) OC_UnaryAddOrSubtractExpression() (localctx IOC_UnaryAddOrSubtractExpressionContext) {
	localctx = NewOC_UnaryAddOrSubtractExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 210, CypherParserRULE_oC_UnaryAddOrSubtractExpression)
	var _la int

	p.SetState(1653)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetTokenStream().LA(1) {
	case CypherParserT__2, CypherParserT__4, CypherParserT__24, CypherParserT__26, CypherParserALL, CypherParserEXISTS, CypherParserSHORTESTPATH, CypherParserALLSHORTESTPATHS, CypherParserNULL, CypherParserCOUNT, CypherParserCASE, CypherParserFILTER, CypherParserEXTRACT, CypherParserREDUCE, CypherParserANY, CypherParserNONE, CypherParserSINGLE, CypherParserTRUE, CypherParserFALSE, CypherParserHexInteger, CypherParserDecimalInteger, CypherParserOctalInteger, CypherParserHexLetter, CypherParserExponentDecimalReal, CypherParserRegularDecimalReal, CypherParserStringLiteral, CypherParserUnescapedSymbolicName, CypherParserEscapedSymbolicName:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(1647)
			p.OC_NonArithmeticOperatorExpression()
		}

	case CypherParserT__18, CypherParserT__19:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(1648)
			_la = p.GetTokenStream().LA(1)

			if !(_la == CypherParserT__18 || _la == CypherParserT__19) {
				p.GetErrorHandler().RecoverInline(p)
			} else {
				p.GetErrorHandler().ReportMatch(p)
				p.Consume()
			}
		}
		p.SetState(1650)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1649)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1652)
			p.OC_NonArithmeticOperatorExpression()
		}

	default:
		p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_NonArithmeticOperatorExpressionContext is an interface to support dynamic dispatch.
type IOC_NonArithmeticOperatorExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_Atom() IOC_AtomContext
	OC_NodeLabels() IOC_NodeLabelsContext
	AllOC_ListOperatorExpression() []IOC_ListOperatorExpressionContext
	OC_ListOperatorExpression(i int) IOC_ListOperatorExpressionContext
	AllOC_PropertyLookup() []IOC_PropertyLookupContext
	OC_PropertyLookup(i int) IOC_PropertyLookupContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_NonArithmeticOperatorExpressionContext differentiates from other interfaces.
	IsOC_NonArithmeticOperatorExpressionContext()
}

type OC_NonArithmeticOperatorExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_NonArithmeticOperatorExpressionContext() *OC_NonArithmeticOperatorExpressionContext {
	var p = new(OC_NonArithmeticOperatorExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_NonArithmeticOperatorExpression
	return p
}

func InitEmptyOC_NonArithmeticOperatorExpressionContext(p *OC_NonArithmeticOperatorExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_NonArithmeticOperatorExpression
}

func (*OC_NonArithmeticOperatorExpressionContext) IsOC_NonArithmeticOperatorExpressionContext() {}

func NewOC_NonArithmeticOperatorExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_NonArithmeticOperatorExpressionContext {
	var p = new(OC_NonArithmeticOperatorExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_NonArithmeticOperatorExpression

	return p
}

func (s *OC_NonArithmeticOperatorExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_NonArithmeticOperatorExpressionContext) OC_Atom() IOC_AtomContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_AtomContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_AtomContext)
}

func (s *OC_NonArithmeticOperatorExpressionContext) OC_NodeLabels() IOC_NodeLabelsContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NodeLabelsContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NodeLabelsContext)
}

func (s *OC_NonArithmeticOperatorExpressionContext) AllOC_ListOperatorExpression() []IOC_ListOperatorExpressionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_ListOperatorExpressionContext); ok {
			len++
		}
	}

	tst := make([]IOC_ListOperatorExpressionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_ListOperatorExpressionContext); ok {
			tst[i] = t.(IOC_ListOperatorExpressionContext)
			i++
		}
	}

	return tst
}

func (s *OC_NonArithmeticOperatorExpressionContext) OC_ListOperatorExpression(i int) IOC_ListOperatorExpressionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ListOperatorExpressionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ListOperatorExpressionContext)
}

func (s *OC_NonArithmeticOperatorExpressionContext) AllOC_PropertyLookup() []IOC_PropertyLookupContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_PropertyLookupContext); ok {
			len++
		}
	}

	tst := make([]IOC_PropertyLookupContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_PropertyLookupContext); ok {
			tst[i] = t.(IOC_PropertyLookupContext)
			i++
		}
	}

	return tst
}

func (s *OC_NonArithmeticOperatorExpressionContext) OC_PropertyLookup(i int) IOC_PropertyLookupContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PropertyLookupContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PropertyLookupContext)
}

func (s *OC_NonArithmeticOperatorExpressionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_NonArithmeticOperatorExpressionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_NonArithmeticOperatorExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_NonArithmeticOperatorExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_NonArithmeticOperatorExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_NonArithmeticOperatorExpression(s)
	}
}

func (s *OC_NonArithmeticOperatorExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_NonArithmeticOperatorExpression(s)
	}
}

func (p *CypherParser) OC_NonArithmeticOperatorExpression() (localctx IOC_NonArithmeticOperatorExpressionContext) {
	localctx = NewOC_NonArithmeticOperatorExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 212, CypherParserRULE_oC_NonArithmeticOperatorExpression)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1655)
		p.OC_Atom()
	}
	p.SetState(1666)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 254, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			p.SetState(1664)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}

			switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 253, p.GetParserRuleContext()) {
			case 1:
				p.SetState(1657)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(1656)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(1659)
					p.OC_ListOperatorExpression()
				}

			case 2:
				p.SetState(1661)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(1660)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(1663)
					p.OC_PropertyLookup()
				}

			case antlr.ATNInvalidAltNumber:
				goto errorExit
			}

		}
		p.SetState(1668)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 254, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}
	p.SetState(1673)
	p.GetErrorHandler().Sync(p)

	if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 256, p.GetParserRuleContext()) == 1 {
		p.SetState(1670)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1669)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1672)
			p.OC_NodeLabels()
		}

	} else if p.HasError() { // JIM
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ListOperatorExpressionContext is an interface to support dynamic dispatch.
type IOC_ListOperatorExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllOC_Expression() []IOC_ExpressionContext
	OC_Expression(i int) IOC_ExpressionContext

	// IsOC_ListOperatorExpressionContext differentiates from other interfaces.
	IsOC_ListOperatorExpressionContext()
}

type OC_ListOperatorExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ListOperatorExpressionContext() *OC_ListOperatorExpressionContext {
	var p = new(OC_ListOperatorExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ListOperatorExpression
	return p
}

func InitEmptyOC_ListOperatorExpressionContext(p *OC_ListOperatorExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ListOperatorExpression
}

func (*OC_ListOperatorExpressionContext) IsOC_ListOperatorExpressionContext() {}

func NewOC_ListOperatorExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ListOperatorExpressionContext {
	var p = new(OC_ListOperatorExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_ListOperatorExpression

	return p
}

func (s *OC_ListOperatorExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ListOperatorExpressionContext) AllOC_Expression() []IOC_ExpressionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			len++
		}
	}

	tst := make([]IOC_ExpressionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_ExpressionContext); ok {
			tst[i] = t.(IOC_ExpressionContext)
			i++
		}
	}

	return tst
}

func (s *OC_ListOperatorExpressionContext) OC_Expression(i int) IOC_ExpressionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_ListOperatorExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ListOperatorExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ListOperatorExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_ListOperatorExpression(s)
	}
}

func (s *OC_ListOperatorExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_ListOperatorExpression(s)
	}
}

func (p *CypherParser) OC_ListOperatorExpression() (localctx IOC_ListOperatorExpressionContext) {
	localctx = NewOC_ListOperatorExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 214, CypherParserRULE_oC_ListOperatorExpression)
	var _la int

	p.SetState(1688)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 259, p.GetParserRuleContext()) {
	case 1:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(1675)
			p.Match(CypherParserT__4)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		{
			p.SetState(1676)
			p.OC_Expression()
		}
		{
			p.SetState(1677)
			p.Match(CypherParserT__5)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case 2:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(1679)
			p.Match(CypherParserT__4)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1681)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if ((int64(_la) & ^0x3f) == 0 && ((int64(1)<<_la)&-9205357638175948760) != 0) || ((int64((_la-100)) & ^0x3f) == 0 && ((int64(1)<<(_la-100))&316779876257315) != 0) {
			{
				p.SetState(1680)
				p.OC_Expression()
			}

		}
		{
			p.SetState(1683)
			p.Match(CypherParserT__11)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1685)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if ((int64(_la) & ^0x3f) == 0 && ((int64(1)<<_la)&-9205357638175948760) != 0) || ((int64((_la-100)) & ^0x3f) == 0 && ((int64(1)<<(_la-100))&316779876257315) != 0) {
			{
				p.SetState(1684)
				p.OC_Expression()
			}

		}
		{
			p.SetState(1687)
			p.Match(CypherParserT__5)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_PropertyLookupContext is an interface to support dynamic dispatch.
type IOC_PropertyLookupContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_PropertyKeyName() IOC_PropertyKeyNameContext
	SP() antlr.TerminalNode

	// IsOC_PropertyLookupContext differentiates from other interfaces.
	IsOC_PropertyLookupContext()
}

type OC_PropertyLookupContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_PropertyLookupContext() *OC_PropertyLookupContext {
	var p = new(OC_PropertyLookupContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PropertyLookup
	return p
}

func InitEmptyOC_PropertyLookupContext(p *OC_PropertyLookupContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PropertyLookup
}

func (*OC_PropertyLookupContext) IsOC_PropertyLookupContext() {}

func NewOC_PropertyLookupContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_PropertyLookupContext {
	var p = new(OC_PropertyLookupContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_PropertyLookup

	return p
}

func (s *OC_PropertyLookupContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_PropertyLookupContext) OC_PropertyKeyName() IOC_PropertyKeyNameContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PropertyKeyNameContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PropertyKeyNameContext)
}

func (s *OC_PropertyLookupContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_PropertyLookupContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_PropertyLookupContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_PropertyLookupContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_PropertyLookup(s)
	}
}

func (s *OC_PropertyLookupContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_PropertyLookup(s)
	}
}

func (p *CypherParser) OC_PropertyLookup() (localctx IOC_PropertyLookupContext) {
	localctx = NewOC_PropertyLookupContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 216, CypherParserRULE_oC_PropertyLookup)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1690)
		p.Match(CypherParserT__23)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1692)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1691)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}

	{
		p.SetState(1694)
		p.OC_PropertyKeyName()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_AtomContext is an interface to support dynamic dispatch.
type IOC_AtomContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_Literal() IOC_LiteralContext
	OC_Parameter() IOC_ParameterContext
	OC_LegacyParameter() IOC_LegacyParameterContext
	OC_CaseExpression() IOC_CaseExpressionContext
	COUNT() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	OC_ListComprehension() IOC_ListComprehensionContext
	OC_PatternComprehension() IOC_PatternComprehensionContext
	OC_LegacyListExpression() IOC_LegacyListExpressionContext
	OC_Reduce() IOC_ReduceContext
	OC_Quantifier() IOC_QuantifierContext
	OC_ShortestPathPattern() IOC_ShortestPathPatternContext
	OC_PatternPredicate() IOC_PatternPredicateContext
	OC_ParenthesizedExpression() IOC_ParenthesizedExpressionContext
	OC_FunctionInvocation() IOC_FunctionInvocationContext
	OC_ExistentialSubquery() IOC_ExistentialSubqueryContext
	OC_Variable() IOC_VariableContext

	// IsOC_AtomContext differentiates from other interfaces.
	IsOC_AtomContext()
}

type OC_AtomContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_AtomContext() *OC_AtomContext {
	var p = new(OC_AtomContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Atom
	return p
}

func InitEmptyOC_AtomContext(p *OC_AtomContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Atom
}

func (*OC_AtomContext) IsOC_AtomContext() {}

func NewOC_AtomContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_AtomContext {
	var p = new(OC_AtomContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Atom

	return p
}

func (s *OC_AtomContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_AtomContext) OC_Literal() IOC_LiteralContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_LiteralContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_LiteralContext)
}

func (s *OC_AtomContext) OC_Parameter() IOC_ParameterContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ParameterContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ParameterContext)
}

func (s *OC_AtomContext) OC_LegacyParameter() IOC_LegacyParameterContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_LegacyParameterContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_LegacyParameterContext)
}

func (s *OC_AtomContext) OC_CaseExpression() IOC_CaseExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_CaseExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_CaseExpressionContext)
}

func (s *OC_AtomContext) COUNT() antlr.TerminalNode {
	return s.GetToken(CypherParserCOUNT, 0)
}

func (s *OC_AtomContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_AtomContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_AtomContext) OC_ListComprehension() IOC_ListComprehensionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ListComprehensionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ListComprehensionContext)
}

func (s *OC_AtomContext) OC_PatternComprehension() IOC_PatternComprehensionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PatternComprehensionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PatternComprehensionContext)
}

func (s *OC_AtomContext) OC_LegacyListExpression() IOC_LegacyListExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_LegacyListExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_LegacyListExpressionContext)
}

func (s *OC_AtomContext) OC_Reduce() IOC_ReduceContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ReduceContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ReduceContext)
}

func (s *OC_AtomContext) OC_Quantifier() IOC_QuantifierContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_QuantifierContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_QuantifierContext)
}

func (s *OC_AtomContext) OC_ShortestPathPattern() IOC_ShortestPathPatternContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ShortestPathPatternContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ShortestPathPatternContext)
}

func (s *OC_AtomContext) OC_PatternPredicate() IOC_PatternPredicateContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PatternPredicateContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PatternPredicateContext)
}

func (s *OC_AtomContext) OC_ParenthesizedExpression() IOC_ParenthesizedExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ParenthesizedExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ParenthesizedExpressionContext)
}

func (s *OC_AtomContext) OC_FunctionInvocation() IOC_FunctionInvocationContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_FunctionInvocationContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_FunctionInvocationContext)
}

func (s *OC_AtomContext) OC_ExistentialSubquery() IOC_ExistentialSubqueryContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExistentialSubqueryContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExistentialSubqueryContext)
}

func (s *OC_AtomContext) OC_Variable() IOC_VariableContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_VariableContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_VariableContext)
}

func (s *OC_AtomContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_AtomContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_AtomContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Atom(s)
	}
}

func (s *OC_AtomContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Atom(s)
	}
}

func (p *CypherParser) OC_Atom() (localctx IOC_AtomContext) {
	localctx = NewOC_AtomContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 218, CypherParserRULE_oC_Atom)
	var _la int

	p.SetState(1724)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 264, p.GetParserRuleContext()) {
	case 1:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(1696)
			p.OC_Literal()
		}

	case 2:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(1697)
			p.OC_Parameter()
		}

	case 3:
		p.EnterOuterAlt(localctx, 3)
		{
			p.SetState(1698)
			p.OC_LegacyParameter()
		}

	case 4:
		p.EnterOuterAlt(localctx, 4)
		{
			p.SetState(1699)
			p.OC_CaseExpression()
		}

	case 5:
		p.EnterOuterAlt(localctx, 5)
		{
			p.SetState(1700)
			p.Match(CypherParserCOUNT)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1702)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1701)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1704)
			p.Match(CypherParserT__2)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1706)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1705)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1708)
			p.Match(CypherParserT__9)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1710)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1709)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1712)
			p.Match(CypherParserT__3)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case 6:
		p.EnterOuterAlt(localctx, 6)
		{
			p.SetState(1713)
			p.OC_ListComprehension()
		}

	case 7:
		p.EnterOuterAlt(localctx, 7)
		{
			p.SetState(1714)
			p.OC_PatternComprehension()
		}

	case 8:
		p.EnterOuterAlt(localctx, 8)
		{
			p.SetState(1715)
			p.OC_LegacyListExpression()
		}

	case 9:
		p.EnterOuterAlt(localctx, 9)
		{
			p.SetState(1716)
			p.OC_Reduce()
		}

	case 10:
		p.EnterOuterAlt(localctx, 10)
		{
			p.SetState(1717)
			p.OC_Quantifier()
		}

	case 11:
		p.EnterOuterAlt(localctx, 11)
		{
			p.SetState(1718)
			p.OC_ShortestPathPattern()
		}

	case 12:
		p.EnterOuterAlt(localctx, 12)
		{
			p.SetState(1719)
			p.OC_PatternPredicate()
		}

	case 13:
		p.EnterOuterAlt(localctx, 13)
		{
			p.SetState(1720)
			p.OC_ParenthesizedExpression()
		}

	case 14:
		p.EnterOuterAlt(localctx, 14)
		{
			p.SetState(1721)
			p.OC_FunctionInvocation()
		}

	case 15:
		p.EnterOuterAlt(localctx, 15)
		{
			p.SetState(1722)
			p.OC_ExistentialSubquery()
		}

	case 16:
		p.EnterOuterAlt(localctx, 16)
		{
			p.SetState(1723)
			p.OC_Variable()
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_CaseExpressionContext is an interface to support dynamic dispatch.
type IOC_CaseExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	END() antlr.TerminalNode
	ELSE() antlr.TerminalNode
	AllOC_Expression() []IOC_ExpressionContext
	OC_Expression(i int) IOC_ExpressionContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	CASE() antlr.TerminalNode
	AllOC_CaseAlternative() []IOC_CaseAlternativeContext
	OC_CaseAlternative(i int) IOC_CaseAlternativeContext

	// IsOC_CaseExpressionContext differentiates from other interfaces.
	IsOC_CaseExpressionContext()
}

type OC_CaseExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_CaseExpressionContext() *OC_CaseExpressionContext {
	var p = new(OC_CaseExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_CaseExpression
	return p
}

func InitEmptyOC_CaseExpressionContext(p *OC_CaseExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_CaseExpression
}

func (*OC_CaseExpressionContext) IsOC_CaseExpressionContext() {}

func NewOC_CaseExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_CaseExpressionContext {
	var p = new(OC_CaseExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_CaseExpression

	return p
}

func (s *OC_CaseExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_CaseExpressionContext) END() antlr.TerminalNode {
	return s.GetToken(CypherParserEND, 0)
}

func (s *OC_CaseExpressionContext) ELSE() antlr.TerminalNode {
	return s.GetToken(CypherParserELSE, 0)
}

func (s *OC_CaseExpressionContext) AllOC_Expression() []IOC_ExpressionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			len++
		}
	}

	tst := make([]IOC_ExpressionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_ExpressionContext); ok {
			tst[i] = t.(IOC_ExpressionContext)
			i++
		}
	}

	return tst
}

func (s *OC_CaseExpressionContext) OC_Expression(i int) IOC_ExpressionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_CaseExpressionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_CaseExpressionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_CaseExpressionContext) CASE() antlr.TerminalNode {
	return s.GetToken(CypherParserCASE, 0)
}

func (s *OC_CaseExpressionContext) AllOC_CaseAlternative() []IOC_CaseAlternativeContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_CaseAlternativeContext); ok {
			len++
		}
	}

	tst := make([]IOC_CaseAlternativeContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_CaseAlternativeContext); ok {
			tst[i] = t.(IOC_CaseAlternativeContext)
			i++
		}
	}

	return tst
}

func (s *OC_CaseExpressionContext) OC_CaseAlternative(i int) IOC_CaseAlternativeContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_CaseAlternativeContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_CaseAlternativeContext)
}

func (s *OC_CaseExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_CaseExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_CaseExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_CaseExpression(s)
	}
}

func (s *OC_CaseExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_CaseExpression(s)
	}
}

func (p *CypherParser) OC_CaseExpression() (localctx IOC_CaseExpressionContext) {
	localctx = NewOC_CaseExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 220, CypherParserRULE_oC_CaseExpression)
	var _la int

	var _alt int

	p.EnterOuterAlt(localctx, 1)
	p.SetState(1748)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 270, p.GetParserRuleContext()) {
	case 1:
		{
			p.SetState(1726)
			p.Match(CypherParserCASE)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1731)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = 1
		for ok := true; ok; ok = _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
			switch _alt {
			case 1:
				p.SetState(1728)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(1727)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(1730)
					p.OC_CaseAlternative()
				}

			default:
				p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
				goto errorExit
			}

			p.SetState(1733)
			p.GetErrorHandler().Sync(p)
			_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 266, p.GetParserRuleContext())
			if p.HasError() {
				goto errorExit
			}
		}

	case 2:
		{
			p.SetState(1735)
			p.Match(CypherParserCASE)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1737)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1736)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1739)
			p.OC_Expression()
		}
		p.SetState(1744)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = 1
		for ok := true; ok; ok = _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
			switch _alt {
			case 1:
				p.SetState(1741)
				p.GetErrorHandler().Sync(p)
				if p.HasError() {
					goto errorExit
				}
				_la = p.GetTokenStream().LA(1)

				if _la == CypherParserSP {
					{
						p.SetState(1740)
						p.Match(CypherParserSP)
						if p.HasError() {
							// Recognition error - abort rule
							goto errorExit
						}
					}

				}
				{
					p.SetState(1743)
					p.OC_CaseAlternative()
				}

			default:
				p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
				goto errorExit
			}

			p.SetState(1746)
			p.GetErrorHandler().Sync(p)
			_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 269, p.GetParserRuleContext())
			if p.HasError() {
				goto errorExit
			}
		}

	case antlr.ATNInvalidAltNumber:
		goto errorExit
	}
	p.SetState(1758)
	p.GetErrorHandler().Sync(p)

	if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 273, p.GetParserRuleContext()) == 1 {
		p.SetState(1751)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1750)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1753)
			p.Match(CypherParserELSE)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1755)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1754)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1757)
			p.OC_Expression()
		}

	} else if p.HasError() { // JIM
		goto errorExit
	}
	p.SetState(1761)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1760)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1763)
		p.Match(CypherParserEND)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_CaseAlternativeContext is an interface to support dynamic dispatch.
type IOC_CaseAlternativeContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	WHEN() antlr.TerminalNode
	AllOC_Expression() []IOC_ExpressionContext
	OC_Expression(i int) IOC_ExpressionContext
	THEN() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_CaseAlternativeContext differentiates from other interfaces.
	IsOC_CaseAlternativeContext()
}

type OC_CaseAlternativeContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_CaseAlternativeContext() *OC_CaseAlternativeContext {
	var p = new(OC_CaseAlternativeContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_CaseAlternative
	return p
}

func InitEmptyOC_CaseAlternativeContext(p *OC_CaseAlternativeContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_CaseAlternative
}

func (*OC_CaseAlternativeContext) IsOC_CaseAlternativeContext() {}

func NewOC_CaseAlternativeContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_CaseAlternativeContext {
	var p = new(OC_CaseAlternativeContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_CaseAlternative

	return p
}

func (s *OC_CaseAlternativeContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_CaseAlternativeContext) WHEN() antlr.TerminalNode {
	return s.GetToken(CypherParserWHEN, 0)
}

func (s *OC_CaseAlternativeContext) AllOC_Expression() []IOC_ExpressionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			len++
		}
	}

	tst := make([]IOC_ExpressionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_ExpressionContext); ok {
			tst[i] = t.(IOC_ExpressionContext)
			i++
		}
	}

	return tst
}

func (s *OC_CaseAlternativeContext) OC_Expression(i int) IOC_ExpressionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_CaseAlternativeContext) THEN() antlr.TerminalNode {
	return s.GetToken(CypherParserTHEN, 0)
}

func (s *OC_CaseAlternativeContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_CaseAlternativeContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_CaseAlternativeContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_CaseAlternativeContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_CaseAlternativeContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_CaseAlternative(s)
	}
}

func (s *OC_CaseAlternativeContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_CaseAlternative(s)
	}
}

func (p *CypherParser) OC_CaseAlternative() (localctx IOC_CaseAlternativeContext) {
	localctx = NewOC_CaseAlternativeContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 222, CypherParserRULE_oC_CaseAlternative)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1765)
		p.Match(CypherParserWHEN)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1767)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1766)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1769)
		p.OC_Expression()
	}
	p.SetState(1771)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1770)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1773)
		p.Match(CypherParserTHEN)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1775)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1774)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1777)
		p.OC_Expression()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ListComprehensionContext is an interface to support dynamic dispatch.
type IOC_ListComprehensionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_FilterExpression() IOC_FilterExpressionContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	OC_Expression() IOC_ExpressionContext

	// IsOC_ListComprehensionContext differentiates from other interfaces.
	IsOC_ListComprehensionContext()
}

type OC_ListComprehensionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ListComprehensionContext() *OC_ListComprehensionContext {
	var p = new(OC_ListComprehensionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ListComprehension
	return p
}

func InitEmptyOC_ListComprehensionContext(p *OC_ListComprehensionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ListComprehension
}

func (*OC_ListComprehensionContext) IsOC_ListComprehensionContext() {}

func NewOC_ListComprehensionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ListComprehensionContext {
	var p = new(OC_ListComprehensionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_ListComprehension

	return p
}

func (s *OC_ListComprehensionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ListComprehensionContext) OC_FilterExpression() IOC_FilterExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_FilterExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_FilterExpressionContext)
}

func (s *OC_ListComprehensionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_ListComprehensionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_ListComprehensionContext) OC_Expression() IOC_ExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_ListComprehensionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ListComprehensionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ListComprehensionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_ListComprehension(s)
	}
}

func (s *OC_ListComprehensionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_ListComprehension(s)
	}
}

func (p *CypherParser) OC_ListComprehension() (localctx IOC_ListComprehensionContext) {
	localctx = NewOC_ListComprehensionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 224, CypherParserRULE_oC_ListComprehension)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1779)
		p.Match(CypherParserT__4)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1781)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1780)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1783)
		p.OC_FilterExpression()
	}
	p.SetState(1792)
	p.GetErrorHandler().Sync(p)

	if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 281, p.GetParserRuleContext()) == 1 {
		p.SetState(1785)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1784)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1787)
			p.Match(CypherParserT__8)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1789)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1788)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1791)
			p.OC_Expression()
		}

	} else if p.HasError() { // JIM
		goto errorExit
	}
	p.SetState(1795)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1794)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1797)
		p.Match(CypherParserT__5)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_PatternComprehensionContext is an interface to support dynamic dispatch.
type IOC_PatternComprehensionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_RelationshipsPattern() IOC_RelationshipsPatternContext
	OC_Expression() IOC_ExpressionContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	OC_Variable() IOC_VariableContext
	OC_Where() IOC_WhereContext

	// IsOC_PatternComprehensionContext differentiates from other interfaces.
	IsOC_PatternComprehensionContext()
}

type OC_PatternComprehensionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_PatternComprehensionContext() *OC_PatternComprehensionContext {
	var p = new(OC_PatternComprehensionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PatternComprehension
	return p
}

func InitEmptyOC_PatternComprehensionContext(p *OC_PatternComprehensionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PatternComprehension
}

func (*OC_PatternComprehensionContext) IsOC_PatternComprehensionContext() {}

func NewOC_PatternComprehensionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_PatternComprehensionContext {
	var p = new(OC_PatternComprehensionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_PatternComprehension

	return p
}

func (s *OC_PatternComprehensionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_PatternComprehensionContext) OC_RelationshipsPattern() IOC_RelationshipsPatternContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_RelationshipsPatternContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_RelationshipsPatternContext)
}

func (s *OC_PatternComprehensionContext) OC_Expression() IOC_ExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_PatternComprehensionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_PatternComprehensionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_PatternComprehensionContext) OC_Variable() IOC_VariableContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_VariableContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_VariableContext)
}

func (s *OC_PatternComprehensionContext) OC_Where() IOC_WhereContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_WhereContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_WhereContext)
}

func (s *OC_PatternComprehensionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_PatternComprehensionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_PatternComprehensionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_PatternComprehension(s)
	}
}

func (s *OC_PatternComprehensionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_PatternComprehension(s)
	}
}

func (p *CypherParser) OC_PatternComprehension() (localctx IOC_PatternComprehensionContext) {
	localctx = NewOC_PatternComprehensionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 226, CypherParserRULE_oC_PatternComprehension)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1799)
		p.Match(CypherParserT__4)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1801)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1800)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	p.SetState(1811)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if (int64((_la-110)) & ^0x3f) == 0 && ((int64(1)<<(_la-110))&309237780161) != 0 {
		{
			p.SetState(1803)
			p.OC_Variable()
		}
		p.SetState(1805)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1804)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1807)
			p.Match(CypherParserT__1)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1809)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1808)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}

	}
	{
		p.SetState(1813)
		p.OC_RelationshipsPattern()
	}
	p.SetState(1815)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1814)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	p.SetState(1821)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserWHERE {
		{
			p.SetState(1817)
			p.OC_Where()
		}
		p.SetState(1819)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1818)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}

	}
	{
		p.SetState(1823)
		p.Match(CypherParserT__8)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1825)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1824)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1827)
		p.OC_Expression()
	}
	p.SetState(1829)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1828)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1831)
		p.Match(CypherParserT__5)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_LegacyListExpressionContext is an interface to support dynamic dispatch.
type IOC_LegacyListExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	FILTER() antlr.TerminalNode
	OC_FilterExpression() IOC_FilterExpressionContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	EXTRACT() antlr.TerminalNode
	OC_Expression() IOC_ExpressionContext

	// IsOC_LegacyListExpressionContext differentiates from other interfaces.
	IsOC_LegacyListExpressionContext()
}

type OC_LegacyListExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_LegacyListExpressionContext() *OC_LegacyListExpressionContext {
	var p = new(OC_LegacyListExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_LegacyListExpression
	return p
}

func InitEmptyOC_LegacyListExpressionContext(p *OC_LegacyListExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_LegacyListExpression
}

func (*OC_LegacyListExpressionContext) IsOC_LegacyListExpressionContext() {}

func NewOC_LegacyListExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_LegacyListExpressionContext {
	var p = new(OC_LegacyListExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_LegacyListExpression

	return p
}

func (s *OC_LegacyListExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_LegacyListExpressionContext) FILTER() antlr.TerminalNode {
	return s.GetToken(CypherParserFILTER, 0)
}

func (s *OC_LegacyListExpressionContext) OC_FilterExpression() IOC_FilterExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_FilterExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_FilterExpressionContext)
}

func (s *OC_LegacyListExpressionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_LegacyListExpressionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_LegacyListExpressionContext) EXTRACT() antlr.TerminalNode {
	return s.GetToken(CypherParserEXTRACT, 0)
}

func (s *OC_LegacyListExpressionContext) OC_Expression() IOC_ExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_LegacyListExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_LegacyListExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_LegacyListExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_LegacyListExpression(s)
	}
}

func (s *OC_LegacyListExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_LegacyListExpression(s)
	}
}

func (p *CypherParser) OC_LegacyListExpression() (localctx IOC_LegacyListExpressionContext) {
	localctx = NewOC_LegacyListExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 228, CypherParserRULE_oC_LegacyListExpression)
	var _la int

	p.SetState(1868)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetTokenStream().LA(1) {
	case CypherParserFILTER:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(1833)
			p.Match(CypherParserFILTER)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1835)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1834)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1837)
			p.Match(CypherParserT__2)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1839)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1838)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1841)
			p.OC_FilterExpression()
		}
		p.SetState(1843)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1842)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1845)
			p.Match(CypherParserT__3)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case CypherParserEXTRACT:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(1847)
			p.Match(CypherParserEXTRACT)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1849)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1848)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1851)
			p.Match(CypherParserT__2)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1853)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1852)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1855)
			p.OC_FilterExpression()
		}
		p.SetState(1857)
		p.GetErrorHandler().Sync(p)

		if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 297, p.GetParserRuleContext()) == 1 {
			{
				p.SetState(1856)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		} else if p.HasError() { // JIM
			goto errorExit
		}
		p.SetState(1864)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserT__8 || _la == CypherParserSP {
			p.SetState(1860)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(1859)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(1862)
				p.Match(CypherParserT__8)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			{
				p.SetState(1863)
				p.OC_Expression()
			}

		}
		{
			p.SetState(1866)
			p.Match(CypherParserT__3)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	default:
		p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ReduceContext is an interface to support dynamic dispatch.
type IOC_ReduceContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	REDUCE() antlr.TerminalNode
	OC_Variable() IOC_VariableContext
	AllOC_Expression() []IOC_ExpressionContext
	OC_Expression(i int) IOC_ExpressionContext
	OC_IdInColl() IOC_IdInCollContext
	SP() antlr.TerminalNode

	// IsOC_ReduceContext differentiates from other interfaces.
	IsOC_ReduceContext()
}

type OC_ReduceContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ReduceContext() *OC_ReduceContext {
	var p = new(OC_ReduceContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Reduce
	return p
}

func InitEmptyOC_ReduceContext(p *OC_ReduceContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Reduce
}

func (*OC_ReduceContext) IsOC_ReduceContext() {}

func NewOC_ReduceContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ReduceContext {
	var p = new(OC_ReduceContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Reduce

	return p
}

func (s *OC_ReduceContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ReduceContext) REDUCE() antlr.TerminalNode {
	return s.GetToken(CypherParserREDUCE, 0)
}

func (s *OC_ReduceContext) OC_Variable() IOC_VariableContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_VariableContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_VariableContext)
}

func (s *OC_ReduceContext) AllOC_Expression() []IOC_ExpressionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			len++
		}
	}

	tst := make([]IOC_ExpressionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_ExpressionContext); ok {
			tst[i] = t.(IOC_ExpressionContext)
			i++
		}
	}

	return tst
}

func (s *OC_ReduceContext) OC_Expression(i int) IOC_ExpressionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_ReduceContext) OC_IdInColl() IOC_IdInCollContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_IdInCollContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_IdInCollContext)
}

func (s *OC_ReduceContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_ReduceContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ReduceContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ReduceContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Reduce(s)
	}
}

func (s *OC_ReduceContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Reduce(s)
	}
}

func (p *CypherParser) OC_Reduce() (localctx IOC_ReduceContext) {
	localctx = NewOC_ReduceContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 230, CypherParserRULE_oC_Reduce)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1870)
		p.Match(CypherParserREDUCE)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1872)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1871)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1874)
		p.Match(CypherParserT__2)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1875)
		p.OC_Variable()
	}
	{
		p.SetState(1876)
		p.Match(CypherParserT__1)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1877)
		p.OC_Expression()
	}
	{
		p.SetState(1878)
		p.Match(CypherParserT__6)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1879)
		p.OC_IdInColl()
	}
	{
		p.SetState(1880)
		p.Match(CypherParserT__8)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1881)
		p.OC_Expression()
	}
	{
		p.SetState(1882)
		p.Match(CypherParserT__3)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_QuantifierContext is an interface to support dynamic dispatch.
type IOC_QuantifierContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	ALL() antlr.TerminalNode
	OC_FilterExpression() IOC_FilterExpressionContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	ANY() antlr.TerminalNode
	NONE() antlr.TerminalNode
	SINGLE() antlr.TerminalNode

	// IsOC_QuantifierContext differentiates from other interfaces.
	IsOC_QuantifierContext()
}

type OC_QuantifierContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_QuantifierContext() *OC_QuantifierContext {
	var p = new(OC_QuantifierContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Quantifier
	return p
}

func InitEmptyOC_QuantifierContext(p *OC_QuantifierContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Quantifier
}

func (*OC_QuantifierContext) IsOC_QuantifierContext() {}

func NewOC_QuantifierContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_QuantifierContext {
	var p = new(OC_QuantifierContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Quantifier

	return p
}

func (s *OC_QuantifierContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_QuantifierContext) ALL() antlr.TerminalNode {
	return s.GetToken(CypherParserALL, 0)
}

func (s *OC_QuantifierContext) OC_FilterExpression() IOC_FilterExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_FilterExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_FilterExpressionContext)
}

func (s *OC_QuantifierContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_QuantifierContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_QuantifierContext) ANY() antlr.TerminalNode {
	return s.GetToken(CypherParserANY, 0)
}

func (s *OC_QuantifierContext) NONE() antlr.TerminalNode {
	return s.GetToken(CypherParserNONE, 0)
}

func (s *OC_QuantifierContext) SINGLE() antlr.TerminalNode {
	return s.GetToken(CypherParserSINGLE, 0)
}

func (s *OC_QuantifierContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_QuantifierContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_QuantifierContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Quantifier(s)
	}
}

func (s *OC_QuantifierContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Quantifier(s)
	}
}

func (p *CypherParser) OC_Quantifier() (localctx IOC_QuantifierContext) {
	localctx = NewOC_QuantifierContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 232, CypherParserRULE_oC_Quantifier)
	var _la int

	p.SetState(1940)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetTokenStream().LA(1) {
	case CypherParserALL:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(1884)
			p.Match(CypherParserALL)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1886)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1885)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1888)
			p.Match(CypherParserT__2)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1890)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1889)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1892)
			p.OC_FilterExpression()
		}
		p.SetState(1894)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1893)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1896)
			p.Match(CypherParserT__3)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case CypherParserANY:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(1898)
			p.Match(CypherParserANY)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1900)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1899)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1902)
			p.Match(CypherParserT__2)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1904)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1903)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1906)
			p.OC_FilterExpression()
		}
		p.SetState(1908)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1907)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1910)
			p.Match(CypherParserT__3)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case CypherParserNONE:
		p.EnterOuterAlt(localctx, 3)
		{
			p.SetState(1912)
			p.Match(CypherParserNONE)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1914)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1913)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1916)
			p.Match(CypherParserT__2)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1918)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1917)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1920)
			p.OC_FilterExpression()
		}
		p.SetState(1922)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1921)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1924)
			p.Match(CypherParserT__3)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case CypherParserSINGLE:
		p.EnterOuterAlt(localctx, 4)
		{
			p.SetState(1926)
			p.Match(CypherParserSINGLE)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1928)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1927)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1930)
			p.Match(CypherParserT__2)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1932)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1931)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1934)
			p.OC_FilterExpression()
		}
		p.SetState(1936)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1935)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1938)
			p.Match(CypherParserT__3)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	default:
		p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_FilterExpressionContext is an interface to support dynamic dispatch.
type IOC_FilterExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_IdInColl() IOC_IdInCollContext
	OC_Where() IOC_WhereContext
	SP() antlr.TerminalNode

	// IsOC_FilterExpressionContext differentiates from other interfaces.
	IsOC_FilterExpressionContext()
}

type OC_FilterExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_FilterExpressionContext() *OC_FilterExpressionContext {
	var p = new(OC_FilterExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_FilterExpression
	return p
}

func InitEmptyOC_FilterExpressionContext(p *OC_FilterExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_FilterExpression
}

func (*OC_FilterExpressionContext) IsOC_FilterExpressionContext() {}

func NewOC_FilterExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_FilterExpressionContext {
	var p = new(OC_FilterExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_FilterExpression

	return p
}

func (s *OC_FilterExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_FilterExpressionContext) OC_IdInColl() IOC_IdInCollContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_IdInCollContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_IdInCollContext)
}

func (s *OC_FilterExpressionContext) OC_Where() IOC_WhereContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_WhereContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_WhereContext)
}

func (s *OC_FilterExpressionContext) SP() antlr.TerminalNode {
	return s.GetToken(CypherParserSP, 0)
}

func (s *OC_FilterExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_FilterExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_FilterExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_FilterExpression(s)
	}
}

func (s *OC_FilterExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_FilterExpression(s)
	}
}

func (p *CypherParser) OC_FilterExpression() (localctx IOC_FilterExpressionContext) {
	localctx = NewOC_FilterExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 234, CypherParserRULE_oC_FilterExpression)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1942)
		p.OC_IdInColl()
	}
	p.SetState(1947)
	p.GetErrorHandler().Sync(p)

	if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 316, p.GetParserRuleContext()) == 1 {
		p.SetState(1944)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1943)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(1946)
			p.OC_Where()
		}

	} else if p.HasError() { // JIM
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_PatternPredicateContext is an interface to support dynamic dispatch.
type IOC_PatternPredicateContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_RelationshipsPattern() IOC_RelationshipsPatternContext

	// IsOC_PatternPredicateContext differentiates from other interfaces.
	IsOC_PatternPredicateContext()
}

type OC_PatternPredicateContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_PatternPredicateContext() *OC_PatternPredicateContext {
	var p = new(OC_PatternPredicateContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PatternPredicate
	return p
}

func InitEmptyOC_PatternPredicateContext(p *OC_PatternPredicateContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PatternPredicate
}

func (*OC_PatternPredicateContext) IsOC_PatternPredicateContext() {}

func NewOC_PatternPredicateContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_PatternPredicateContext {
	var p = new(OC_PatternPredicateContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_PatternPredicate

	return p
}

func (s *OC_PatternPredicateContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_PatternPredicateContext) OC_RelationshipsPattern() IOC_RelationshipsPatternContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_RelationshipsPatternContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_RelationshipsPatternContext)
}

func (s *OC_PatternPredicateContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_PatternPredicateContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_PatternPredicateContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_PatternPredicate(s)
	}
}

func (s *OC_PatternPredicateContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_PatternPredicate(s)
	}
}

func (p *CypherParser) OC_PatternPredicate() (localctx IOC_PatternPredicateContext) {
	localctx = NewOC_PatternPredicateContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 236, CypherParserRULE_oC_PatternPredicate)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1949)
		p.OC_RelationshipsPattern()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ParenthesizedExpressionContext is an interface to support dynamic dispatch.
type IOC_ParenthesizedExpressionContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_Expression() IOC_ExpressionContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_ParenthesizedExpressionContext differentiates from other interfaces.
	IsOC_ParenthesizedExpressionContext()
}

type OC_ParenthesizedExpressionContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ParenthesizedExpressionContext() *OC_ParenthesizedExpressionContext {
	var p = new(OC_ParenthesizedExpressionContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ParenthesizedExpression
	return p
}

func InitEmptyOC_ParenthesizedExpressionContext(p *OC_ParenthesizedExpressionContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ParenthesizedExpression
}

func (*OC_ParenthesizedExpressionContext) IsOC_ParenthesizedExpressionContext() {}

func NewOC_ParenthesizedExpressionContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ParenthesizedExpressionContext {
	var p = new(OC_ParenthesizedExpressionContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_ParenthesizedExpression

	return p
}

func (s *OC_ParenthesizedExpressionContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ParenthesizedExpressionContext) OC_Expression() IOC_ExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_ParenthesizedExpressionContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_ParenthesizedExpressionContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_ParenthesizedExpressionContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ParenthesizedExpressionContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ParenthesizedExpressionContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_ParenthesizedExpression(s)
	}
}

func (s *OC_ParenthesizedExpressionContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_ParenthesizedExpression(s)
	}
}

func (p *CypherParser) OC_ParenthesizedExpression() (localctx IOC_ParenthesizedExpressionContext) {
	localctx = NewOC_ParenthesizedExpressionContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 238, CypherParserRULE_oC_ParenthesizedExpression)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1951)
		p.Match(CypherParserT__2)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1953)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1952)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1955)
		p.OC_Expression()
	}
	p.SetState(1957)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1956)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1959)
		p.Match(CypherParserT__3)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_IdInCollContext is an interface to support dynamic dispatch.
type IOC_IdInCollContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_Variable() IOC_VariableContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	IN() antlr.TerminalNode
	OC_Expression() IOC_ExpressionContext

	// IsOC_IdInCollContext differentiates from other interfaces.
	IsOC_IdInCollContext()
}

type OC_IdInCollContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_IdInCollContext() *OC_IdInCollContext {
	var p = new(OC_IdInCollContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_IdInColl
	return p
}

func InitEmptyOC_IdInCollContext(p *OC_IdInCollContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_IdInColl
}

func (*OC_IdInCollContext) IsOC_IdInCollContext() {}

func NewOC_IdInCollContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_IdInCollContext {
	var p = new(OC_IdInCollContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_IdInColl

	return p
}

func (s *OC_IdInCollContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_IdInCollContext) OC_Variable() IOC_VariableContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_VariableContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_VariableContext)
}

func (s *OC_IdInCollContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_IdInCollContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_IdInCollContext) IN() antlr.TerminalNode {
	return s.GetToken(CypherParserIN, 0)
}

func (s *OC_IdInCollContext) OC_Expression() IOC_ExpressionContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_IdInCollContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_IdInCollContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_IdInCollContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_IdInColl(s)
	}
}

func (s *OC_IdInCollContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_IdInColl(s)
	}
}

func (p *CypherParser) OC_IdInColl() (localctx IOC_IdInCollContext) {
	localctx = NewOC_IdInCollContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 240, CypherParserRULE_oC_IdInColl)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1961)
		p.OC_Variable()
	}
	{
		p.SetState(1962)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1963)
		p.Match(CypherParserIN)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1964)
		p.Match(CypherParserSP)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	{
		p.SetState(1965)
		p.OC_Expression()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_FunctionInvocationContext is an interface to support dynamic dispatch.
type IOC_FunctionInvocationContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_FunctionName() IOC_FunctionNameContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	DISTINCT() antlr.TerminalNode
	AllOC_Expression() []IOC_ExpressionContext
	OC_Expression(i int) IOC_ExpressionContext

	// IsOC_FunctionInvocationContext differentiates from other interfaces.
	IsOC_FunctionInvocationContext()
}

type OC_FunctionInvocationContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_FunctionInvocationContext() *OC_FunctionInvocationContext {
	var p = new(OC_FunctionInvocationContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_FunctionInvocation
	return p
}

func InitEmptyOC_FunctionInvocationContext(p *OC_FunctionInvocationContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_FunctionInvocation
}

func (*OC_FunctionInvocationContext) IsOC_FunctionInvocationContext() {}

func NewOC_FunctionInvocationContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_FunctionInvocationContext {
	var p = new(OC_FunctionInvocationContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_FunctionInvocation

	return p
}

func (s *OC_FunctionInvocationContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_FunctionInvocationContext) OC_FunctionName() IOC_FunctionNameContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_FunctionNameContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_FunctionNameContext)
}

func (s *OC_FunctionInvocationContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_FunctionInvocationContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_FunctionInvocationContext) DISTINCT() antlr.TerminalNode {
	return s.GetToken(CypherParserDISTINCT, 0)
}

func (s *OC_FunctionInvocationContext) AllOC_Expression() []IOC_ExpressionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			len++
		}
	}

	tst := make([]IOC_ExpressionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_ExpressionContext); ok {
			tst[i] = t.(IOC_ExpressionContext)
			i++
		}
	}

	return tst
}

func (s *OC_FunctionInvocationContext) OC_Expression(i int) IOC_ExpressionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_FunctionInvocationContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_FunctionInvocationContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_FunctionInvocationContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_FunctionInvocation(s)
	}
}

func (s *OC_FunctionInvocationContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_FunctionInvocation(s)
	}
}

func (p *CypherParser) OC_FunctionInvocation() (localctx IOC_FunctionInvocationContext) {
	localctx = NewOC_FunctionInvocationContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 242, CypherParserRULE_oC_FunctionInvocation)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(1967)
		p.OC_FunctionName()
	}
	p.SetState(1969)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1968)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(1971)
		p.Match(CypherParserT__2)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(1973)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(1972)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	p.SetState(1979)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserDISTINCT {
		{
			p.SetState(1975)
			p.Match(CypherParserDISTINCT)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(1977)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1976)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}

	}
	p.SetState(1998)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if ((int64(_la) & ^0x3f) == 0 && ((int64(1)<<_la)&-9205357638175948760) != 0) || ((int64((_la-100)) & ^0x3f) == 0 && ((int64(1)<<(_la-100))&316779876257315) != 0) {
		{
			p.SetState(1981)
			p.OC_Expression()
		}
		p.SetState(1983)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(1982)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		p.SetState(1995)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		for _la == CypherParserT__6 {
			{
				p.SetState(1985)
				p.Match(CypherParserT__6)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			p.SetState(1987)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(1986)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(1989)
				p.OC_Expression()
			}
			p.SetState(1991)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(1990)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}

			p.SetState(1997)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)
		}

	}
	{
		p.SetState(2000)
		p.Match(CypherParserT__3)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_FunctionNameContext is an interface to support dynamic dispatch.
type IOC_FunctionNameContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_Namespace() IOC_NamespaceContext
	OC_SymbolicName() IOC_SymbolicNameContext

	// IsOC_FunctionNameContext differentiates from other interfaces.
	IsOC_FunctionNameContext()
}

type OC_FunctionNameContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_FunctionNameContext() *OC_FunctionNameContext {
	var p = new(OC_FunctionNameContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_FunctionName
	return p
}

func InitEmptyOC_FunctionNameContext(p *OC_FunctionNameContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_FunctionName
}

func (*OC_FunctionNameContext) IsOC_FunctionNameContext() {}

func NewOC_FunctionNameContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_FunctionNameContext {
	var p = new(OC_FunctionNameContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_FunctionName

	return p
}

func (s *OC_FunctionNameContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_FunctionNameContext) OC_Namespace() IOC_NamespaceContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NamespaceContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NamespaceContext)
}

func (s *OC_FunctionNameContext) OC_SymbolicName() IOC_SymbolicNameContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SymbolicNameContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SymbolicNameContext)
}

func (s *OC_FunctionNameContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_FunctionNameContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_FunctionNameContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_FunctionName(s)
	}
}

func (s *OC_FunctionNameContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_FunctionName(s)
	}
}

func (p *CypherParser) OC_FunctionName() (localctx IOC_FunctionNameContext) {
	localctx = NewOC_FunctionNameContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 244, CypherParserRULE_oC_FunctionName)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(2002)
		p.OC_Namespace()
	}
	{
		p.SetState(2003)
		p.OC_SymbolicName()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ExistentialSubqueryContext is an interface to support dynamic dispatch.
type IOC_ExistentialSubqueryContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	EXISTS() antlr.TerminalNode
	OC_RegularQuery() IOC_RegularQueryContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	OC_Pattern() IOC_PatternContext
	OC_Where() IOC_WhereContext

	// IsOC_ExistentialSubqueryContext differentiates from other interfaces.
	IsOC_ExistentialSubqueryContext()
}

type OC_ExistentialSubqueryContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ExistentialSubqueryContext() *OC_ExistentialSubqueryContext {
	var p = new(OC_ExistentialSubqueryContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ExistentialSubquery
	return p
}

func InitEmptyOC_ExistentialSubqueryContext(p *OC_ExistentialSubqueryContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ExistentialSubquery
}

func (*OC_ExistentialSubqueryContext) IsOC_ExistentialSubqueryContext() {}

func NewOC_ExistentialSubqueryContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ExistentialSubqueryContext {
	var p = new(OC_ExistentialSubqueryContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_ExistentialSubquery

	return p
}

func (s *OC_ExistentialSubqueryContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ExistentialSubqueryContext) EXISTS() antlr.TerminalNode {
	return s.GetToken(CypherParserEXISTS, 0)
}

func (s *OC_ExistentialSubqueryContext) OC_RegularQuery() IOC_RegularQueryContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_RegularQueryContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_RegularQueryContext)
}

func (s *OC_ExistentialSubqueryContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_ExistentialSubqueryContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_ExistentialSubqueryContext) OC_Pattern() IOC_PatternContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PatternContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PatternContext)
}

func (s *OC_ExistentialSubqueryContext) OC_Where() IOC_WhereContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_WhereContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_WhereContext)
}

func (s *OC_ExistentialSubqueryContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ExistentialSubqueryContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ExistentialSubqueryContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_ExistentialSubquery(s)
	}
}

func (s *OC_ExistentialSubqueryContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_ExistentialSubquery(s)
	}
}

func (p *CypherParser) OC_ExistentialSubquery() (localctx IOC_ExistentialSubqueryContext) {
	localctx = NewOC_ExistentialSubqueryContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 246, CypherParserRULE_oC_ExistentialSubquery)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(2005)
		p.Match(CypherParserEXISTS)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(2007)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(2006)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(2009)
		p.Match(CypherParserT__24)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(2011)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(2010)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	p.SetState(2021)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetTokenStream().LA(1) {
	case CypherParserCREATE, CypherParserLOAD, CypherParserWITH, CypherParserOPTIONAL, CypherParserMATCH, CypherParserUNWIND, CypherParserMERGE, CypherParserSET, CypherParserDETACH, CypherParserDELETE, CypherParserREMOVE, CypherParserFOREACH, CypherParserCALL, CypherParserRETURN, CypherParserSTART:
		{
			p.SetState(2013)
			p.OC_RegularQuery()
		}

	case CypherParserT__2, CypherParserSHORTESTPATH, CypherParserALLSHORTESTPATHS, CypherParserCOUNT, CypherParserFILTER, CypherParserEXTRACT, CypherParserANY, CypherParserNONE, CypherParserSINGLE, CypherParserHexLetter, CypherParserUnescapedSymbolicName, CypherParserEscapedSymbolicName:
		{
			p.SetState(2014)
			p.OC_Pattern()
		}
		p.SetState(2019)
		p.GetErrorHandler().Sync(p)

		if p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 331, p.GetParserRuleContext()) == 1 {
			p.SetState(2016)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(2015)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(2018)
				p.OC_Where()
			}

		} else if p.HasError() { // JIM
			goto errorExit
		}

	default:
		p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
		goto errorExit
	}
	p.SetState(2024)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(2023)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(2026)
		p.Match(CypherParserT__25)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ExplicitProcedureInvocationContext is an interface to support dynamic dispatch.
type IOC_ExplicitProcedureInvocationContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_ProcedureName() IOC_ProcedureNameContext
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	AllOC_Expression() []IOC_ExpressionContext
	OC_Expression(i int) IOC_ExpressionContext

	// IsOC_ExplicitProcedureInvocationContext differentiates from other interfaces.
	IsOC_ExplicitProcedureInvocationContext()
}

type OC_ExplicitProcedureInvocationContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ExplicitProcedureInvocationContext() *OC_ExplicitProcedureInvocationContext {
	var p = new(OC_ExplicitProcedureInvocationContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ExplicitProcedureInvocation
	return p
}

func InitEmptyOC_ExplicitProcedureInvocationContext(p *OC_ExplicitProcedureInvocationContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ExplicitProcedureInvocation
}

func (*OC_ExplicitProcedureInvocationContext) IsOC_ExplicitProcedureInvocationContext() {}

func NewOC_ExplicitProcedureInvocationContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ExplicitProcedureInvocationContext {
	var p = new(OC_ExplicitProcedureInvocationContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_ExplicitProcedureInvocation

	return p
}

func (s *OC_ExplicitProcedureInvocationContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ExplicitProcedureInvocationContext) OC_ProcedureName() IOC_ProcedureNameContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ProcedureNameContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ProcedureNameContext)
}

func (s *OC_ExplicitProcedureInvocationContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_ExplicitProcedureInvocationContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_ExplicitProcedureInvocationContext) AllOC_Expression() []IOC_ExpressionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			len++
		}
	}

	tst := make([]IOC_ExpressionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_ExpressionContext); ok {
			tst[i] = t.(IOC_ExpressionContext)
			i++
		}
	}

	return tst
}

func (s *OC_ExplicitProcedureInvocationContext) OC_Expression(i int) IOC_ExpressionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_ExplicitProcedureInvocationContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ExplicitProcedureInvocationContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ExplicitProcedureInvocationContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_ExplicitProcedureInvocation(s)
	}
}

func (s *OC_ExplicitProcedureInvocationContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_ExplicitProcedureInvocation(s)
	}
}

func (p *CypherParser) OC_ExplicitProcedureInvocation() (localctx IOC_ExplicitProcedureInvocationContext) {
	localctx = NewOC_ExplicitProcedureInvocationContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 248, CypherParserRULE_oC_ExplicitProcedureInvocation)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(2028)
		p.OC_ProcedureName()
	}
	p.SetState(2030)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(2029)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(2032)
		p.Match(CypherParserT__2)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(2034)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(2033)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	p.SetState(2053)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if ((int64(_la) & ^0x3f) == 0 && ((int64(1)<<_la)&-9205357638175948760) != 0) || ((int64((_la-100)) & ^0x3f) == 0 && ((int64(1)<<(_la-100))&316779876257315) != 0) {
		{
			p.SetState(2036)
			p.OC_Expression()
		}
		p.SetState(2038)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(2037)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		p.SetState(2050)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		for _la == CypherParserT__6 {
			{
				p.SetState(2040)
				p.Match(CypherParserT__6)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			p.SetState(2042)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(2041)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(2044)
				p.OC_Expression()
			}
			p.SetState(2046)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(2045)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}

			p.SetState(2052)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)
		}

	}
	{
		p.SetState(2055)
		p.Match(CypherParserT__3)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ImplicitProcedureInvocationContext is an interface to support dynamic dispatch.
type IOC_ImplicitProcedureInvocationContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_ProcedureName() IOC_ProcedureNameContext

	// IsOC_ImplicitProcedureInvocationContext differentiates from other interfaces.
	IsOC_ImplicitProcedureInvocationContext()
}

type OC_ImplicitProcedureInvocationContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ImplicitProcedureInvocationContext() *OC_ImplicitProcedureInvocationContext {
	var p = new(OC_ImplicitProcedureInvocationContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ImplicitProcedureInvocation
	return p
}

func InitEmptyOC_ImplicitProcedureInvocationContext(p *OC_ImplicitProcedureInvocationContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ImplicitProcedureInvocation
}

func (*OC_ImplicitProcedureInvocationContext) IsOC_ImplicitProcedureInvocationContext() {}

func NewOC_ImplicitProcedureInvocationContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ImplicitProcedureInvocationContext {
	var p = new(OC_ImplicitProcedureInvocationContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_ImplicitProcedureInvocation

	return p
}

func (s *OC_ImplicitProcedureInvocationContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ImplicitProcedureInvocationContext) OC_ProcedureName() IOC_ProcedureNameContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ProcedureNameContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ProcedureNameContext)
}

func (s *OC_ImplicitProcedureInvocationContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ImplicitProcedureInvocationContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ImplicitProcedureInvocationContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_ImplicitProcedureInvocation(s)
	}
}

func (s *OC_ImplicitProcedureInvocationContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_ImplicitProcedureInvocation(s)
	}
}

func (p *CypherParser) OC_ImplicitProcedureInvocation() (localctx IOC_ImplicitProcedureInvocationContext) {
	localctx = NewOC_ImplicitProcedureInvocationContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 250, CypherParserRULE_oC_ImplicitProcedureInvocation)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(2057)
		p.OC_ProcedureName()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ProcedureResultFieldContext is an interface to support dynamic dispatch.
type IOC_ProcedureResultFieldContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_SymbolicName() IOC_SymbolicNameContext

	// IsOC_ProcedureResultFieldContext differentiates from other interfaces.
	IsOC_ProcedureResultFieldContext()
}

type OC_ProcedureResultFieldContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ProcedureResultFieldContext() *OC_ProcedureResultFieldContext {
	var p = new(OC_ProcedureResultFieldContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ProcedureResultField
	return p
}

func InitEmptyOC_ProcedureResultFieldContext(p *OC_ProcedureResultFieldContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ProcedureResultField
}

func (*OC_ProcedureResultFieldContext) IsOC_ProcedureResultFieldContext() {}

func NewOC_ProcedureResultFieldContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ProcedureResultFieldContext {
	var p = new(OC_ProcedureResultFieldContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_ProcedureResultField

	return p
}

func (s *OC_ProcedureResultFieldContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ProcedureResultFieldContext) OC_SymbolicName() IOC_SymbolicNameContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SymbolicNameContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SymbolicNameContext)
}

func (s *OC_ProcedureResultFieldContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ProcedureResultFieldContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ProcedureResultFieldContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_ProcedureResultField(s)
	}
}

func (s *OC_ProcedureResultFieldContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_ProcedureResultField(s)
	}
}

func (p *CypherParser) OC_ProcedureResultField() (localctx IOC_ProcedureResultFieldContext) {
	localctx = NewOC_ProcedureResultFieldContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 252, CypherParserRULE_oC_ProcedureResultField)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(2059)
		p.OC_SymbolicName()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ProcedureNameContext is an interface to support dynamic dispatch.
type IOC_ProcedureNameContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_Namespace() IOC_NamespaceContext
	OC_SymbolicName() IOC_SymbolicNameContext

	// IsOC_ProcedureNameContext differentiates from other interfaces.
	IsOC_ProcedureNameContext()
}

type OC_ProcedureNameContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ProcedureNameContext() *OC_ProcedureNameContext {
	var p = new(OC_ProcedureNameContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ProcedureName
	return p
}

func InitEmptyOC_ProcedureNameContext(p *OC_ProcedureNameContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ProcedureName
}

func (*OC_ProcedureNameContext) IsOC_ProcedureNameContext() {}

func NewOC_ProcedureNameContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ProcedureNameContext {
	var p = new(OC_ProcedureNameContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_ProcedureName

	return p
}

func (s *OC_ProcedureNameContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ProcedureNameContext) OC_Namespace() IOC_NamespaceContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NamespaceContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NamespaceContext)
}

func (s *OC_ProcedureNameContext) OC_SymbolicName() IOC_SymbolicNameContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SymbolicNameContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SymbolicNameContext)
}

func (s *OC_ProcedureNameContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ProcedureNameContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ProcedureNameContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_ProcedureName(s)
	}
}

func (s *OC_ProcedureNameContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_ProcedureName(s)
	}
}

func (p *CypherParser) OC_ProcedureName() (localctx IOC_ProcedureNameContext) {
	localctx = NewOC_ProcedureNameContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 254, CypherParserRULE_oC_ProcedureName)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(2061)
		p.OC_Namespace()
	}
	{
		p.SetState(2062)
		p.OC_SymbolicName()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_NamespaceContext is an interface to support dynamic dispatch.
type IOC_NamespaceContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllOC_SymbolicName() []IOC_SymbolicNameContext
	OC_SymbolicName(i int) IOC_SymbolicNameContext

	// IsOC_NamespaceContext differentiates from other interfaces.
	IsOC_NamespaceContext()
}

type OC_NamespaceContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_NamespaceContext() *OC_NamespaceContext {
	var p = new(OC_NamespaceContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Namespace
	return p
}

func InitEmptyOC_NamespaceContext(p *OC_NamespaceContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Namespace
}

func (*OC_NamespaceContext) IsOC_NamespaceContext() {}

func NewOC_NamespaceContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_NamespaceContext {
	var p = new(OC_NamespaceContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Namespace

	return p
}

func (s *OC_NamespaceContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_NamespaceContext) AllOC_SymbolicName() []IOC_SymbolicNameContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_SymbolicNameContext); ok {
			len++
		}
	}

	tst := make([]IOC_SymbolicNameContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_SymbolicNameContext); ok {
			tst[i] = t.(IOC_SymbolicNameContext)
			i++
		}
	}

	return tst
}

func (s *OC_NamespaceContext) OC_SymbolicName(i int) IOC_SymbolicNameContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SymbolicNameContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SymbolicNameContext)
}

func (s *OC_NamespaceContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_NamespaceContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_NamespaceContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Namespace(s)
	}
}

func (s *OC_NamespaceContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Namespace(s)
	}
}

func (p *CypherParser) OC_Namespace() (localctx IOC_NamespaceContext) {
	localctx = NewOC_NamespaceContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 256, CypherParserRULE_oC_Namespace)
	var _alt int

	p.EnterOuterAlt(localctx, 1)
	p.SetState(2069)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 341, p.GetParserRuleContext())
	if p.HasError() {
		goto errorExit
	}
	for _alt != 2 && _alt != antlr.ATNInvalidAltNumber {
		if _alt == 1 {
			{
				p.SetState(2064)
				p.OC_SymbolicName()
			}
			{
				p.SetState(2065)
				p.Match(CypherParserT__23)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		p.SetState(2071)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_alt = p.GetInterpreter().AdaptivePredict(p.BaseParser, p.GetTokenStream(), 341, p.GetParserRuleContext())
		if p.HasError() {
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_VariableContext is an interface to support dynamic dispatch.
type IOC_VariableContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_SymbolicName() IOC_SymbolicNameContext

	// IsOC_VariableContext differentiates from other interfaces.
	IsOC_VariableContext()
}

type OC_VariableContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_VariableContext() *OC_VariableContext {
	var p = new(OC_VariableContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Variable
	return p
}

func InitEmptyOC_VariableContext(p *OC_VariableContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Variable
}

func (*OC_VariableContext) IsOC_VariableContext() {}

func NewOC_VariableContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_VariableContext {
	var p = new(OC_VariableContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Variable

	return p
}

func (s *OC_VariableContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_VariableContext) OC_SymbolicName() IOC_SymbolicNameContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SymbolicNameContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SymbolicNameContext)
}

func (s *OC_VariableContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_VariableContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_VariableContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Variable(s)
	}
}

func (s *OC_VariableContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Variable(s)
	}
}

func (p *CypherParser) OC_Variable() (localctx IOC_VariableContext) {
	localctx = NewOC_VariableContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 258, CypherParserRULE_oC_Variable)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(2072)
		p.OC_SymbolicName()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_LiteralContext is an interface to support dynamic dispatch.
type IOC_LiteralContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_BooleanLiteral() IOC_BooleanLiteralContext
	NULL() antlr.TerminalNode
	OC_NumberLiteral() IOC_NumberLiteralContext
	StringLiteral() antlr.TerminalNode
	OC_ListLiteral() IOC_ListLiteralContext
	OC_MapLiteral() IOC_MapLiteralContext

	// IsOC_LiteralContext differentiates from other interfaces.
	IsOC_LiteralContext()
}

type OC_LiteralContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_LiteralContext() *OC_LiteralContext {
	var p = new(OC_LiteralContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Literal
	return p
}

func InitEmptyOC_LiteralContext(p *OC_LiteralContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Literal
}

func (*OC_LiteralContext) IsOC_LiteralContext() {}

func NewOC_LiteralContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_LiteralContext {
	var p = new(OC_LiteralContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Literal

	return p
}

func (s *OC_LiteralContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_LiteralContext) OC_BooleanLiteral() IOC_BooleanLiteralContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_BooleanLiteralContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_BooleanLiteralContext)
}

func (s *OC_LiteralContext) NULL() antlr.TerminalNode {
	return s.GetToken(CypherParserNULL, 0)
}

func (s *OC_LiteralContext) OC_NumberLiteral() IOC_NumberLiteralContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_NumberLiteralContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_NumberLiteralContext)
}

func (s *OC_LiteralContext) StringLiteral() antlr.TerminalNode {
	return s.GetToken(CypherParserStringLiteral, 0)
}

func (s *OC_LiteralContext) OC_ListLiteral() IOC_ListLiteralContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ListLiteralContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ListLiteralContext)
}

func (s *OC_LiteralContext) OC_MapLiteral() IOC_MapLiteralContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_MapLiteralContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_MapLiteralContext)
}

func (s *OC_LiteralContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_LiteralContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_LiteralContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Literal(s)
	}
}

func (s *OC_LiteralContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Literal(s)
	}
}

func (p *CypherParser) OC_Literal() (localctx IOC_LiteralContext) {
	localctx = NewOC_LiteralContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 260, CypherParserRULE_oC_Literal)
	p.SetState(2080)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetTokenStream().LA(1) {
	case CypherParserTRUE, CypherParserFALSE:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(2074)
			p.OC_BooleanLiteral()
		}

	case CypherParserNULL:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(2075)
			p.Match(CypherParserNULL)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case CypherParserHexInteger, CypherParserDecimalInteger, CypherParserOctalInteger, CypherParserExponentDecimalReal, CypherParserRegularDecimalReal:
		p.EnterOuterAlt(localctx, 3)
		{
			p.SetState(2076)
			p.OC_NumberLiteral()
		}

	case CypherParserStringLiteral:
		p.EnterOuterAlt(localctx, 4)
		{
			p.SetState(2077)
			p.Match(CypherParserStringLiteral)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	case CypherParserT__4:
		p.EnterOuterAlt(localctx, 5)
		{
			p.SetState(2078)
			p.OC_ListLiteral()
		}

	case CypherParserT__24:
		p.EnterOuterAlt(localctx, 6)
		{
			p.SetState(2079)
			p.OC_MapLiteral()
		}

	default:
		p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_BooleanLiteralContext is an interface to support dynamic dispatch.
type IOC_BooleanLiteralContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	TRUE() antlr.TerminalNode
	FALSE() antlr.TerminalNode

	// IsOC_BooleanLiteralContext differentiates from other interfaces.
	IsOC_BooleanLiteralContext()
}

type OC_BooleanLiteralContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_BooleanLiteralContext() *OC_BooleanLiteralContext {
	var p = new(OC_BooleanLiteralContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_BooleanLiteral
	return p
}

func InitEmptyOC_BooleanLiteralContext(p *OC_BooleanLiteralContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_BooleanLiteral
}

func (*OC_BooleanLiteralContext) IsOC_BooleanLiteralContext() {}

func NewOC_BooleanLiteralContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_BooleanLiteralContext {
	var p = new(OC_BooleanLiteralContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_BooleanLiteral

	return p
}

func (s *OC_BooleanLiteralContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_BooleanLiteralContext) TRUE() antlr.TerminalNode {
	return s.GetToken(CypherParserTRUE, 0)
}

func (s *OC_BooleanLiteralContext) FALSE() antlr.TerminalNode {
	return s.GetToken(CypherParserFALSE, 0)
}

func (s *OC_BooleanLiteralContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_BooleanLiteralContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_BooleanLiteralContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_BooleanLiteral(s)
	}
}

func (s *OC_BooleanLiteralContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_BooleanLiteral(s)
	}
}

func (p *CypherParser) OC_BooleanLiteral() (localctx IOC_BooleanLiteralContext) {
	localctx = NewOC_BooleanLiteralContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 262, CypherParserRULE_oC_BooleanLiteral)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(2082)
		_la = p.GetTokenStream().LA(1)

		if !(_la == CypherParserTRUE || _la == CypherParserFALSE) {
			p.GetErrorHandler().RecoverInline(p)
		} else {
			p.GetErrorHandler().ReportMatch(p)
			p.Consume()
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_NumberLiteralContext is an interface to support dynamic dispatch.
type IOC_NumberLiteralContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_DoubleLiteral() IOC_DoubleLiteralContext
	OC_IntegerLiteral() IOC_IntegerLiteralContext

	// IsOC_NumberLiteralContext differentiates from other interfaces.
	IsOC_NumberLiteralContext()
}

type OC_NumberLiteralContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_NumberLiteralContext() *OC_NumberLiteralContext {
	var p = new(OC_NumberLiteralContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_NumberLiteral
	return p
}

func InitEmptyOC_NumberLiteralContext(p *OC_NumberLiteralContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_NumberLiteral
}

func (*OC_NumberLiteralContext) IsOC_NumberLiteralContext() {}

func NewOC_NumberLiteralContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_NumberLiteralContext {
	var p = new(OC_NumberLiteralContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_NumberLiteral

	return p
}

func (s *OC_NumberLiteralContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_NumberLiteralContext) OC_DoubleLiteral() IOC_DoubleLiteralContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_DoubleLiteralContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_DoubleLiteralContext)
}

func (s *OC_NumberLiteralContext) OC_IntegerLiteral() IOC_IntegerLiteralContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_IntegerLiteralContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_IntegerLiteralContext)
}

func (s *OC_NumberLiteralContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_NumberLiteralContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_NumberLiteralContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_NumberLiteral(s)
	}
}

func (s *OC_NumberLiteralContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_NumberLiteral(s)
	}
}

func (p *CypherParser) OC_NumberLiteral() (localctx IOC_NumberLiteralContext) {
	localctx = NewOC_NumberLiteralContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 264, CypherParserRULE_oC_NumberLiteral)
	p.SetState(2086)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetTokenStream().LA(1) {
	case CypherParserExponentDecimalReal, CypherParserRegularDecimalReal:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(2084)
			p.OC_DoubleLiteral()
		}

	case CypherParserHexInteger, CypherParserDecimalInteger, CypherParserOctalInteger:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(2085)
			p.OC_IntegerLiteral()
		}

	default:
		p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_IntegerLiteralContext is an interface to support dynamic dispatch.
type IOC_IntegerLiteralContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	HexInteger() antlr.TerminalNode
	OctalInteger() antlr.TerminalNode
	DecimalInteger() antlr.TerminalNode

	// IsOC_IntegerLiteralContext differentiates from other interfaces.
	IsOC_IntegerLiteralContext()
}

type OC_IntegerLiteralContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_IntegerLiteralContext() *OC_IntegerLiteralContext {
	var p = new(OC_IntegerLiteralContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_IntegerLiteral
	return p
}

func InitEmptyOC_IntegerLiteralContext(p *OC_IntegerLiteralContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_IntegerLiteral
}

func (*OC_IntegerLiteralContext) IsOC_IntegerLiteralContext() {}

func NewOC_IntegerLiteralContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_IntegerLiteralContext {
	var p = new(OC_IntegerLiteralContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_IntegerLiteral

	return p
}

func (s *OC_IntegerLiteralContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_IntegerLiteralContext) HexInteger() antlr.TerminalNode {
	return s.GetToken(CypherParserHexInteger, 0)
}

func (s *OC_IntegerLiteralContext) OctalInteger() antlr.TerminalNode {
	return s.GetToken(CypherParserOctalInteger, 0)
}

func (s *OC_IntegerLiteralContext) DecimalInteger() antlr.TerminalNode {
	return s.GetToken(CypherParserDecimalInteger, 0)
}

func (s *OC_IntegerLiteralContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_IntegerLiteralContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_IntegerLiteralContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_IntegerLiteral(s)
	}
}

func (s *OC_IntegerLiteralContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_IntegerLiteral(s)
	}
}

func (p *CypherParser) OC_IntegerLiteral() (localctx IOC_IntegerLiteralContext) {
	localctx = NewOC_IntegerLiteralContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 266, CypherParserRULE_oC_IntegerLiteral)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(2088)
		_la = p.GetTokenStream().LA(1)

		if !((int64((_la-124)) & ^0x3f) == 0 && ((int64(1)<<(_la-124))&7) != 0) {
			p.GetErrorHandler().RecoverInline(p)
		} else {
			p.GetErrorHandler().ReportMatch(p)
			p.Consume()
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_DoubleLiteralContext is an interface to support dynamic dispatch.
type IOC_DoubleLiteralContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	ExponentDecimalReal() antlr.TerminalNode
	RegularDecimalReal() antlr.TerminalNode

	// IsOC_DoubleLiteralContext differentiates from other interfaces.
	IsOC_DoubleLiteralContext()
}

type OC_DoubleLiteralContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_DoubleLiteralContext() *OC_DoubleLiteralContext {
	var p = new(OC_DoubleLiteralContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_DoubleLiteral
	return p
}

func InitEmptyOC_DoubleLiteralContext(p *OC_DoubleLiteralContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_DoubleLiteral
}

func (*OC_DoubleLiteralContext) IsOC_DoubleLiteralContext() {}

func NewOC_DoubleLiteralContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_DoubleLiteralContext {
	var p = new(OC_DoubleLiteralContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_DoubleLiteral

	return p
}

func (s *OC_DoubleLiteralContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_DoubleLiteralContext) ExponentDecimalReal() antlr.TerminalNode {
	return s.GetToken(CypherParserExponentDecimalReal, 0)
}

func (s *OC_DoubleLiteralContext) RegularDecimalReal() antlr.TerminalNode {
	return s.GetToken(CypherParserRegularDecimalReal, 0)
}

func (s *OC_DoubleLiteralContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_DoubleLiteralContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_DoubleLiteralContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_DoubleLiteral(s)
	}
}

func (s *OC_DoubleLiteralContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_DoubleLiteral(s)
	}
}

func (p *CypherParser) OC_DoubleLiteral() (localctx IOC_DoubleLiteralContext) {
	localctx = NewOC_DoubleLiteralContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 268, CypherParserRULE_oC_DoubleLiteral)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(2090)
		_la = p.GetTokenStream().LA(1)

		if !(_la == CypherParserExponentDecimalReal || _la == CypherParserRegularDecimalReal) {
			p.GetErrorHandler().RecoverInline(p)
		} else {
			p.GetErrorHandler().ReportMatch(p)
			p.Consume()
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ListLiteralContext is an interface to support dynamic dispatch.
type IOC_ListLiteralContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	AllOC_Expression() []IOC_ExpressionContext
	OC_Expression(i int) IOC_ExpressionContext

	// IsOC_ListLiteralContext differentiates from other interfaces.
	IsOC_ListLiteralContext()
}

type OC_ListLiteralContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ListLiteralContext() *OC_ListLiteralContext {
	var p = new(OC_ListLiteralContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ListLiteral
	return p
}

func InitEmptyOC_ListLiteralContext(p *OC_ListLiteralContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ListLiteral
}

func (*OC_ListLiteralContext) IsOC_ListLiteralContext() {}

func NewOC_ListLiteralContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ListLiteralContext {
	var p = new(OC_ListLiteralContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_ListLiteral

	return p
}

func (s *OC_ListLiteralContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ListLiteralContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_ListLiteralContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_ListLiteralContext) AllOC_Expression() []IOC_ExpressionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			len++
		}
	}

	tst := make([]IOC_ExpressionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_ExpressionContext); ok {
			tst[i] = t.(IOC_ExpressionContext)
			i++
		}
	}

	return tst
}

func (s *OC_ListLiteralContext) OC_Expression(i int) IOC_ExpressionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_ListLiteralContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ListLiteralContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ListLiteralContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_ListLiteral(s)
	}
}

func (s *OC_ListLiteralContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_ListLiteral(s)
	}
}

func (p *CypherParser) OC_ListLiteral() (localctx IOC_ListLiteralContext) {
	localctx = NewOC_ListLiteralContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 270, CypherParserRULE_oC_ListLiteral)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(2092)
		p.Match(CypherParserT__4)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(2094)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(2093)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	p.SetState(2113)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if ((int64(_la) & ^0x3f) == 0 && ((int64(1)<<_la)&-9205357638175948760) != 0) || ((int64((_la-100)) & ^0x3f) == 0 && ((int64(1)<<(_la-100))&316779876257315) != 0) {
		{
			p.SetState(2096)
			p.OC_Expression()
		}
		p.SetState(2098)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(2097)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		p.SetState(2110)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		for _la == CypherParserT__6 {
			{
				p.SetState(2100)
				p.Match(CypherParserT__6)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			p.SetState(2102)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(2101)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(2104)
				p.OC_Expression()
			}
			p.SetState(2106)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(2105)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}

			p.SetState(2112)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)
		}

	}
	{
		p.SetState(2115)
		p.Match(CypherParserT__5)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_MapLiteralContext is an interface to support dynamic dispatch.
type IOC_MapLiteralContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode
	AllOC_PropertyKeyName() []IOC_PropertyKeyNameContext
	OC_PropertyKeyName(i int) IOC_PropertyKeyNameContext
	AllOC_Expression() []IOC_ExpressionContext
	OC_Expression(i int) IOC_ExpressionContext

	// IsOC_MapLiteralContext differentiates from other interfaces.
	IsOC_MapLiteralContext()
}

type OC_MapLiteralContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_MapLiteralContext() *OC_MapLiteralContext {
	var p = new(OC_MapLiteralContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_MapLiteral
	return p
}

func InitEmptyOC_MapLiteralContext(p *OC_MapLiteralContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_MapLiteral
}

func (*OC_MapLiteralContext) IsOC_MapLiteralContext() {}

func NewOC_MapLiteralContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_MapLiteralContext {
	var p = new(OC_MapLiteralContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_MapLiteral

	return p
}

func (s *OC_MapLiteralContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_MapLiteralContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_MapLiteralContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_MapLiteralContext) AllOC_PropertyKeyName() []IOC_PropertyKeyNameContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_PropertyKeyNameContext); ok {
			len++
		}
	}

	tst := make([]IOC_PropertyKeyNameContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_PropertyKeyNameContext); ok {
			tst[i] = t.(IOC_PropertyKeyNameContext)
			i++
		}
	}

	return tst
}

func (s *OC_MapLiteralContext) OC_PropertyKeyName(i int) IOC_PropertyKeyNameContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_PropertyKeyNameContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_PropertyKeyNameContext)
}

func (s *OC_MapLiteralContext) AllOC_Expression() []IOC_ExpressionContext {
	children := s.GetChildren()
	len := 0
	for _, ctx := range children {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			len++
		}
	}

	tst := make([]IOC_ExpressionContext, len)
	i := 0
	for _, ctx := range children {
		if t, ok := ctx.(IOC_ExpressionContext); ok {
			tst[i] = t.(IOC_ExpressionContext)
			i++
		}
	}

	return tst
}

func (s *OC_MapLiteralContext) OC_Expression(i int) IOC_ExpressionContext {
	var t antlr.RuleContext
	j := 0
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ExpressionContext); ok {
			if j == i {
				t = ctx.(antlr.RuleContext)
				break
			}
			j++
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ExpressionContext)
}

func (s *OC_MapLiteralContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_MapLiteralContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_MapLiteralContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_MapLiteral(s)
	}
}

func (s *OC_MapLiteralContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_MapLiteral(s)
	}
}

func (p *CypherParser) OC_MapLiteral() (localctx IOC_MapLiteralContext) {
	localctx = NewOC_MapLiteralContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 272, CypherParserRULE_oC_MapLiteral)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(2117)
		p.Match(CypherParserT__24)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(2119)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(2118)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	p.SetState(2154)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if ((int64((_la-53)) & ^0x3f) == 0 && ((int64(1)<<(_la-53))&-491482570217617) != 0) || ((int64((_la-117)) & ^0x3f) == 0 && ((int64(1)<<(_la-117))&2682258557) != 0) {
		{
			p.SetState(2121)
			p.OC_PropertyKeyName()
		}
		p.SetState(2123)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(2122)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(2125)
			p.Match(CypherParserT__10)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}
		p.SetState(2127)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(2126)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		{
			p.SetState(2129)
			p.OC_Expression()
		}
		p.SetState(2131)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		if _la == CypherParserSP {
			{
				p.SetState(2130)
				p.Match(CypherParserSP)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}

		}
		p.SetState(2151)
		p.GetErrorHandler().Sync(p)
		if p.HasError() {
			goto errorExit
		}
		_la = p.GetTokenStream().LA(1)

		for _la == CypherParserT__6 {
			{
				p.SetState(2133)
				p.Match(CypherParserT__6)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			p.SetState(2135)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(2134)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(2137)
				p.OC_PropertyKeyName()
			}
			p.SetState(2139)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(2138)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(2141)
				p.Match(CypherParserT__10)
				if p.HasError() {
					// Recognition error - abort rule
					goto errorExit
				}
			}
			p.SetState(2143)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(2142)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}
			{
				p.SetState(2145)
				p.OC_Expression()
			}
			p.SetState(2147)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)

			if _la == CypherParserSP {
				{
					p.SetState(2146)
					p.Match(CypherParserSP)
					if p.HasError() {
						// Recognition error - abort rule
						goto errorExit
					}
				}

			}

			p.SetState(2153)
			p.GetErrorHandler().Sync(p)
			if p.HasError() {
				goto errorExit
			}
			_la = p.GetTokenStream().LA(1)
		}

	}
	{
		p.SetState(2156)
		p.Match(CypherParserT__25)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_PropertyKeyNameContext is an interface to support dynamic dispatch.
type IOC_PropertyKeyNameContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_SchemaName() IOC_SchemaNameContext

	// IsOC_PropertyKeyNameContext differentiates from other interfaces.
	IsOC_PropertyKeyNameContext()
}

type OC_PropertyKeyNameContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_PropertyKeyNameContext() *OC_PropertyKeyNameContext {
	var p = new(OC_PropertyKeyNameContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PropertyKeyName
	return p
}

func InitEmptyOC_PropertyKeyNameContext(p *OC_PropertyKeyNameContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_PropertyKeyName
}

func (*OC_PropertyKeyNameContext) IsOC_PropertyKeyNameContext() {}

func NewOC_PropertyKeyNameContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_PropertyKeyNameContext {
	var p = new(OC_PropertyKeyNameContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_PropertyKeyName

	return p
}

func (s *OC_PropertyKeyNameContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_PropertyKeyNameContext) OC_SchemaName() IOC_SchemaNameContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SchemaNameContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SchemaNameContext)
}

func (s *OC_PropertyKeyNameContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_PropertyKeyNameContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_PropertyKeyNameContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_PropertyKeyName(s)
	}
}

func (s *OC_PropertyKeyNameContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_PropertyKeyName(s)
	}
}

func (p *CypherParser) OC_PropertyKeyName() (localctx IOC_PropertyKeyNameContext) {
	localctx = NewOC_PropertyKeyNameContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 274, CypherParserRULE_oC_PropertyKeyName)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(2158)
		p.OC_SchemaName()
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_LegacyParameterContext is an interface to support dynamic dispatch.
type IOC_LegacyParameterContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_SymbolicName() IOC_SymbolicNameContext
	DecimalInteger() antlr.TerminalNode
	AllSP() []antlr.TerminalNode
	SP(i int) antlr.TerminalNode

	// IsOC_LegacyParameterContext differentiates from other interfaces.
	IsOC_LegacyParameterContext()
}

type OC_LegacyParameterContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_LegacyParameterContext() *OC_LegacyParameterContext {
	var p = new(OC_LegacyParameterContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_LegacyParameter
	return p
}

func InitEmptyOC_LegacyParameterContext(p *OC_LegacyParameterContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_LegacyParameter
}

func (*OC_LegacyParameterContext) IsOC_LegacyParameterContext() {}

func NewOC_LegacyParameterContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_LegacyParameterContext {
	var p = new(OC_LegacyParameterContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_LegacyParameter

	return p
}

func (s *OC_LegacyParameterContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_LegacyParameterContext) OC_SymbolicName() IOC_SymbolicNameContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SymbolicNameContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SymbolicNameContext)
}

func (s *OC_LegacyParameterContext) DecimalInteger() antlr.TerminalNode {
	return s.GetToken(CypherParserDecimalInteger, 0)
}

func (s *OC_LegacyParameterContext) AllSP() []antlr.TerminalNode {
	return s.GetTokens(CypherParserSP)
}

func (s *OC_LegacyParameterContext) SP(i int) antlr.TerminalNode {
	return s.GetToken(CypherParserSP, i)
}

func (s *OC_LegacyParameterContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_LegacyParameterContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_LegacyParameterContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_LegacyParameter(s)
	}
}

func (s *OC_LegacyParameterContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_LegacyParameter(s)
	}
}

func (p *CypherParser) OC_LegacyParameter() (localctx IOC_LegacyParameterContext) {
	localctx = NewOC_LegacyParameterContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 276, CypherParserRULE_oC_LegacyParameter)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(2160)
		p.Match(CypherParserT__24)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(2162)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(2161)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	p.SetState(2166)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetTokenStream().LA(1) {
	case CypherParserCOUNT, CypherParserFILTER, CypherParserEXTRACT, CypherParserANY, CypherParserNONE, CypherParserSINGLE, CypherParserHexLetter, CypherParserUnescapedSymbolicName, CypherParserEscapedSymbolicName:
		{
			p.SetState(2164)
			p.OC_SymbolicName()
		}

	case CypherParserDecimalInteger:
		{
			p.SetState(2165)
			p.Match(CypherParserDecimalInteger)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	default:
		p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
		goto errorExit
	}
	p.SetState(2169)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}
	_la = p.GetTokenStream().LA(1)

	if _la == CypherParserSP {
		{
			p.SetState(2168)
			p.Match(CypherParserSP)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	}
	{
		p.SetState(2171)
		p.Match(CypherParserT__25)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ParameterContext is an interface to support dynamic dispatch.
type IOC_ParameterContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_SymbolicName() IOC_SymbolicNameContext
	DecimalInteger() antlr.TerminalNode

	// IsOC_ParameterContext differentiates from other interfaces.
	IsOC_ParameterContext()
}

type OC_ParameterContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ParameterContext() *OC_ParameterContext {
	var p = new(OC_ParameterContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Parameter
	return p
}

func InitEmptyOC_ParameterContext(p *OC_ParameterContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Parameter
}

func (*OC_ParameterContext) IsOC_ParameterContext() {}

func NewOC_ParameterContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ParameterContext {
	var p = new(OC_ParameterContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Parameter

	return p
}

func (s *OC_ParameterContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ParameterContext) OC_SymbolicName() IOC_SymbolicNameContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SymbolicNameContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SymbolicNameContext)
}

func (s *OC_ParameterContext) DecimalInteger() antlr.TerminalNode {
	return s.GetToken(CypherParserDecimalInteger, 0)
}

func (s *OC_ParameterContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ParameterContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ParameterContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Parameter(s)
	}
}

func (s *OC_ParameterContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Parameter(s)
	}
}

func (p *CypherParser) OC_Parameter() (localctx IOC_ParameterContext) {
	localctx = NewOC_ParameterContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 278, CypherParserRULE_oC_Parameter)
	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(2173)
		p.Match(CypherParserT__26)
		if p.HasError() {
			// Recognition error - abort rule
			goto errorExit
		}
	}
	p.SetState(2176)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetTokenStream().LA(1) {
	case CypherParserCOUNT, CypherParserFILTER, CypherParserEXTRACT, CypherParserANY, CypherParserNONE, CypherParserSINGLE, CypherParserHexLetter, CypherParserUnescapedSymbolicName, CypherParserEscapedSymbolicName:
		{
			p.SetState(2174)
			p.OC_SymbolicName()
		}

	case CypherParserDecimalInteger:
		{
			p.SetState(2175)
			p.Match(CypherParserDecimalInteger)
			if p.HasError() {
				// Recognition error - abort rule
				goto errorExit
			}
		}

	default:
		p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_SchemaNameContext is an interface to support dynamic dispatch.
type IOC_SchemaNameContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	OC_SymbolicName() IOC_SymbolicNameContext
	OC_ReservedWord() IOC_ReservedWordContext

	// IsOC_SchemaNameContext differentiates from other interfaces.
	IsOC_SchemaNameContext()
}

type OC_SchemaNameContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_SchemaNameContext() *OC_SchemaNameContext {
	var p = new(OC_SchemaNameContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_SchemaName
	return p
}

func InitEmptyOC_SchemaNameContext(p *OC_SchemaNameContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_SchemaName
}

func (*OC_SchemaNameContext) IsOC_SchemaNameContext() {}

func NewOC_SchemaNameContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_SchemaNameContext {
	var p = new(OC_SchemaNameContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_SchemaName

	return p
}

func (s *OC_SchemaNameContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_SchemaNameContext) OC_SymbolicName() IOC_SymbolicNameContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_SymbolicNameContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_SymbolicNameContext)
}

func (s *OC_SchemaNameContext) OC_ReservedWord() IOC_ReservedWordContext {
	var t antlr.RuleContext
	for _, ctx := range s.GetChildren() {
		if _, ok := ctx.(IOC_ReservedWordContext); ok {
			t = ctx.(antlr.RuleContext)
			break
		}
	}

	if t == nil {
		return nil
	}

	return t.(IOC_ReservedWordContext)
}

func (s *OC_SchemaNameContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_SchemaNameContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_SchemaNameContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_SchemaName(s)
	}
}

func (s *OC_SchemaNameContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_SchemaName(s)
	}
}

func (p *CypherParser) OC_SchemaName() (localctx IOC_SchemaNameContext) {
	localctx = NewOC_SchemaNameContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 280, CypherParserRULE_oC_SchemaName)
	p.SetState(2180)
	p.GetErrorHandler().Sync(p)
	if p.HasError() {
		goto errorExit
	}

	switch p.GetTokenStream().LA(1) {
	case CypherParserCOUNT, CypherParserFILTER, CypherParserEXTRACT, CypherParserANY, CypherParserNONE, CypherParserSINGLE, CypherParserHexLetter, CypherParserUnescapedSymbolicName, CypherParserEscapedSymbolicName:
		p.EnterOuterAlt(localctx, 1)
		{
			p.SetState(2178)
			p.OC_SymbolicName()
		}

	case CypherParserUNION, CypherParserALL, CypherParserCREATE, CypherParserDROP, CypherParserON, CypherParserCONSTRAINT, CypherParserIS, CypherParserUNIQUE, CypherParserEXISTS, CypherParserWITH, CypherParserAS, CypherParserOPTIONAL, CypherParserMATCH, CypherParserUNWIND, CypherParserMERGE, CypherParserSET, CypherParserDETACH, CypherParserDELETE, CypherParserREMOVE, CypherParserIN, CypherParserRETURN, CypherParserDISTINCT, CypherParserORDER, CypherParserBY, CypherParserL_SKIP, CypherParserLIMIT, CypherParserASCENDING, CypherParserASC, CypherParserDESCENDING, CypherParserDESC, CypherParserWHERE, CypherParserOR, CypherParserXOR, CypherParserAND, CypherParserNOT, CypherParserSTARTS, CypherParserENDS, CypherParserCONTAINS, CypherParserNULL, CypherParserCASE, CypherParserELSE, CypherParserEND, CypherParserWHEN, CypherParserTHEN, CypherParserTRUE, CypherParserFALSE, CypherParserDO, CypherParserFOR, CypherParserREQUIRE, CypherParserMANDATORY, CypherParserSCALAR, CypherParserOF, CypherParserADD:
		p.EnterOuterAlt(localctx, 2)
		{
			p.SetState(2179)
			p.OC_ReservedWord()
		}

	default:
		p.SetError(antlr.NewNoViableAltException(p, nil, nil, nil, nil, nil))
		goto errorExit
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_ReservedWordContext is an interface to support dynamic dispatch.
type IOC_ReservedWordContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	ALL() antlr.TerminalNode
	ASC() antlr.TerminalNode
	ASCENDING() antlr.TerminalNode
	BY() antlr.TerminalNode
	CREATE() antlr.TerminalNode
	DELETE() antlr.TerminalNode
	DESC() antlr.TerminalNode
	DESCENDING() antlr.TerminalNode
	DETACH() antlr.TerminalNode
	EXISTS() antlr.TerminalNode
	LIMIT() antlr.TerminalNode
	MATCH() antlr.TerminalNode
	MERGE() antlr.TerminalNode
	ON() antlr.TerminalNode
	OPTIONAL() antlr.TerminalNode
	ORDER() antlr.TerminalNode
	REMOVE() antlr.TerminalNode
	RETURN() antlr.TerminalNode
	SET() antlr.TerminalNode
	L_SKIP() antlr.TerminalNode
	WHERE() antlr.TerminalNode
	WITH() antlr.TerminalNode
	UNION() antlr.TerminalNode
	UNWIND() antlr.TerminalNode
	AND() antlr.TerminalNode
	AS() antlr.TerminalNode
	CONTAINS() antlr.TerminalNode
	DISTINCT() antlr.TerminalNode
	ENDS() antlr.TerminalNode
	IN() antlr.TerminalNode
	IS() antlr.TerminalNode
	NOT() antlr.TerminalNode
	OR() antlr.TerminalNode
	STARTS() antlr.TerminalNode
	XOR() antlr.TerminalNode
	FALSE() antlr.TerminalNode
	TRUE() antlr.TerminalNode
	NULL() antlr.TerminalNode
	CONSTRAINT() antlr.TerminalNode
	DO() antlr.TerminalNode
	FOR() antlr.TerminalNode
	REQUIRE() antlr.TerminalNode
	UNIQUE() antlr.TerminalNode
	CASE() antlr.TerminalNode
	WHEN() antlr.TerminalNode
	THEN() antlr.TerminalNode
	ELSE() antlr.TerminalNode
	END() antlr.TerminalNode
	MANDATORY() antlr.TerminalNode
	SCALAR() antlr.TerminalNode
	OF() antlr.TerminalNode
	ADD() antlr.TerminalNode
	DROP() antlr.TerminalNode

	// IsOC_ReservedWordContext differentiates from other interfaces.
	IsOC_ReservedWordContext()
}

type OC_ReservedWordContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_ReservedWordContext() *OC_ReservedWordContext {
	var p = new(OC_ReservedWordContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ReservedWord
	return p
}

func InitEmptyOC_ReservedWordContext(p *OC_ReservedWordContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_ReservedWord
}

func (*OC_ReservedWordContext) IsOC_ReservedWordContext() {}

func NewOC_ReservedWordContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_ReservedWordContext {
	var p = new(OC_ReservedWordContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_ReservedWord

	return p
}

func (s *OC_ReservedWordContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_ReservedWordContext) ALL() antlr.TerminalNode {
	return s.GetToken(CypherParserALL, 0)
}

func (s *OC_ReservedWordContext) ASC() antlr.TerminalNode {
	return s.GetToken(CypherParserASC, 0)
}

func (s *OC_ReservedWordContext) ASCENDING() antlr.TerminalNode {
	return s.GetToken(CypherParserASCENDING, 0)
}

func (s *OC_ReservedWordContext) BY() antlr.TerminalNode {
	return s.GetToken(CypherParserBY, 0)
}

func (s *OC_ReservedWordContext) CREATE() antlr.TerminalNode {
	return s.GetToken(CypherParserCREATE, 0)
}

func (s *OC_ReservedWordContext) DELETE() antlr.TerminalNode {
	return s.GetToken(CypherParserDELETE, 0)
}

func (s *OC_ReservedWordContext) DESC() antlr.TerminalNode {
	return s.GetToken(CypherParserDESC, 0)
}

func (s *OC_ReservedWordContext) DESCENDING() antlr.TerminalNode {
	return s.GetToken(CypherParserDESCENDING, 0)
}

func (s *OC_ReservedWordContext) DETACH() antlr.TerminalNode {
	return s.GetToken(CypherParserDETACH, 0)
}

func (s *OC_ReservedWordContext) EXISTS() antlr.TerminalNode {
	return s.GetToken(CypherParserEXISTS, 0)
}

func (s *OC_ReservedWordContext) LIMIT() antlr.TerminalNode {
	return s.GetToken(CypherParserLIMIT, 0)
}

func (s *OC_ReservedWordContext) MATCH() antlr.TerminalNode {
	return s.GetToken(CypherParserMATCH, 0)
}

func (s *OC_ReservedWordContext) MERGE() antlr.TerminalNode {
	return s.GetToken(CypherParserMERGE, 0)
}

func (s *OC_ReservedWordContext) ON() antlr.TerminalNode {
	return s.GetToken(CypherParserON, 0)
}

func (s *OC_ReservedWordContext) OPTIONAL() antlr.TerminalNode {
	return s.GetToken(CypherParserOPTIONAL, 0)
}

func (s *OC_ReservedWordContext) ORDER() antlr.TerminalNode {
	return s.GetToken(CypherParserORDER, 0)
}

func (s *OC_ReservedWordContext) REMOVE() antlr.TerminalNode {
	return s.GetToken(CypherParserREMOVE, 0)
}

func (s *OC_ReservedWordContext) RETURN() antlr.TerminalNode {
	return s.GetToken(CypherParserRETURN, 0)
}

func (s *OC_ReservedWordContext) SET() antlr.TerminalNode {
	return s.GetToken(CypherParserSET, 0)
}

func (s *OC_ReservedWordContext) L_SKIP() antlr.TerminalNode {
	return s.GetToken(CypherParserL_SKIP, 0)
}

func (s *OC_ReservedWordContext) WHERE() antlr.TerminalNode {
	return s.GetToken(CypherParserWHERE, 0)
}

func (s *OC_ReservedWordContext) WITH() antlr.TerminalNode {
	return s.GetToken(CypherParserWITH, 0)
}

func (s *OC_ReservedWordContext) UNION() antlr.TerminalNode {
	return s.GetToken(CypherParserUNION, 0)
}

func (s *OC_ReservedWordContext) UNWIND() antlr.TerminalNode {
	return s.GetToken(CypherParserUNWIND, 0)
}

func (s *OC_ReservedWordContext) AND() antlr.TerminalNode {
	return s.GetToken(CypherParserAND, 0)
}

func (s *OC_ReservedWordContext) AS() antlr.TerminalNode {
	return s.GetToken(CypherParserAS, 0)
}

func (s *OC_ReservedWordContext) CONTAINS() antlr.TerminalNode {
	return s.GetToken(CypherParserCONTAINS, 0)
}

func (s *OC_ReservedWordContext) DISTINCT() antlr.TerminalNode {
	return s.GetToken(CypherParserDISTINCT, 0)
}

func (s *OC_ReservedWordContext) ENDS() antlr.TerminalNode {
	return s.GetToken(CypherParserENDS, 0)
}

func (s *OC_ReservedWordContext) IN() antlr.TerminalNode {
	return s.GetToken(CypherParserIN, 0)
}

func (s *OC_ReservedWordContext) IS() antlr.TerminalNode {
	return s.GetToken(CypherParserIS, 0)
}

func (s *OC_ReservedWordContext) NOT() antlr.TerminalNode {
	return s.GetToken(CypherParserNOT, 0)
}

func (s *OC_ReservedWordContext) OR() antlr.TerminalNode {
	return s.GetToken(CypherParserOR, 0)
}

func (s *OC_ReservedWordContext) STARTS() antlr.TerminalNode {
	return s.GetToken(CypherParserSTARTS, 0)
}

func (s *OC_ReservedWordContext) XOR() antlr.TerminalNode {
	return s.GetToken(CypherParserXOR, 0)
}

func (s *OC_ReservedWordContext) FALSE() antlr.TerminalNode {
	return s.GetToken(CypherParserFALSE, 0)
}

func (s *OC_ReservedWordContext) TRUE() antlr.TerminalNode {
	return s.GetToken(CypherParserTRUE, 0)
}

func (s *OC_ReservedWordContext) NULL() antlr.TerminalNode {
	return s.GetToken(CypherParserNULL, 0)
}

func (s *OC_ReservedWordContext) CONSTRAINT() antlr.TerminalNode {
	return s.GetToken(CypherParserCONSTRAINT, 0)
}

func (s *OC_ReservedWordContext) DO() antlr.TerminalNode {
	return s.GetToken(CypherParserDO, 0)
}

func (s *OC_ReservedWordContext) FOR() antlr.TerminalNode {
	return s.GetToken(CypherParserFOR, 0)
}

func (s *OC_ReservedWordContext) REQUIRE() antlr.TerminalNode {
	return s.GetToken(CypherParserREQUIRE, 0)
}

func (s *OC_ReservedWordContext) UNIQUE() antlr.TerminalNode {
	return s.GetToken(CypherParserUNIQUE, 0)
}

func (s *OC_ReservedWordContext) CASE() antlr.TerminalNode {
	return s.GetToken(CypherParserCASE, 0)
}

func (s *OC_ReservedWordContext) WHEN() antlr.TerminalNode {
	return s.GetToken(CypherParserWHEN, 0)
}

func (s *OC_ReservedWordContext) THEN() antlr.TerminalNode {
	return s.GetToken(CypherParserTHEN, 0)
}

func (s *OC_ReservedWordContext) ELSE() antlr.TerminalNode {
	return s.GetToken(CypherParserELSE, 0)
}

func (s *OC_ReservedWordContext) END() antlr.TerminalNode {
	return s.GetToken(CypherParserEND, 0)
}

func (s *OC_ReservedWordContext) MANDATORY() antlr.TerminalNode {
	return s.GetToken(CypherParserMANDATORY, 0)
}

func (s *OC_ReservedWordContext) SCALAR() antlr.TerminalNode {
	return s.GetToken(CypherParserSCALAR, 0)
}

func (s *OC_ReservedWordContext) OF() antlr.TerminalNode {
	return s.GetToken(CypherParserOF, 0)
}

func (s *OC_ReservedWordContext) ADD() antlr.TerminalNode {
	return s.GetToken(CypherParserADD, 0)
}

func (s *OC_ReservedWordContext) DROP() antlr.TerminalNode {
	return s.GetToken(CypherParserDROP, 0)
}

func (s *OC_ReservedWordContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_ReservedWordContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_ReservedWordContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_ReservedWord(s)
	}
}

func (s *OC_ReservedWordContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_ReservedWord(s)
	}
}

func (p *CypherParser) OC_ReservedWord() (localctx IOC_ReservedWordContext) {
	localctx = NewOC_ReservedWordContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 282, CypherParserRULE_oC_ReservedWord)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(2182)
		_la = p.GetTokenStream().LA(1)

		if !(((int64((_la-53)) & ^0x3f) == 0 && ((int64(1)<<(_la-53))&9078765366208702319) != 0) || ((int64((_la-122)) & ^0x3f) == 0 && ((int64(1)<<(_la-122))&8323075) != 0)) {
			p.GetErrorHandler().RecoverInline(p)
		} else {
			p.GetErrorHandler().ReportMatch(p)
			p.Consume()
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_SymbolicNameContext is an interface to support dynamic dispatch.
type IOC_SymbolicNameContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser

	// Getter signatures
	UnescapedSymbolicName() antlr.TerminalNode
	EscapedSymbolicName() antlr.TerminalNode
	HexLetter() antlr.TerminalNode
	COUNT() antlr.TerminalNode
	FILTER() antlr.TerminalNode
	EXTRACT() antlr.TerminalNode
	ANY() antlr.TerminalNode
	NONE() antlr.TerminalNode
	SINGLE() antlr.TerminalNode

	// IsOC_SymbolicNameContext differentiates from other interfaces.
	IsOC_SymbolicNameContext()
}

type OC_SymbolicNameContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_SymbolicNameContext() *OC_SymbolicNameContext {
	var p = new(OC_SymbolicNameContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_SymbolicName
	return p
}

func InitEmptyOC_SymbolicNameContext(p *OC_SymbolicNameContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_SymbolicName
}

func (*OC_SymbolicNameContext) IsOC_SymbolicNameContext() {}

func NewOC_SymbolicNameContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_SymbolicNameContext {
	var p = new(OC_SymbolicNameContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_SymbolicName

	return p
}

func (s *OC_SymbolicNameContext) GetParser() antlr.Parser { return s.parser }

func (s *OC_SymbolicNameContext) UnescapedSymbolicName() antlr.TerminalNode {
	return s.GetToken(CypherParserUnescapedSymbolicName, 0)
}

func (s *OC_SymbolicNameContext) EscapedSymbolicName() antlr.TerminalNode {
	return s.GetToken(CypherParserEscapedSymbolicName, 0)
}

func (s *OC_SymbolicNameContext) HexLetter() antlr.TerminalNode {
	return s.GetToken(CypherParserHexLetter, 0)
}

func (s *OC_SymbolicNameContext) COUNT() antlr.TerminalNode {
	return s.GetToken(CypherParserCOUNT, 0)
}

func (s *OC_SymbolicNameContext) FILTER() antlr.TerminalNode {
	return s.GetToken(CypherParserFILTER, 0)
}

func (s *OC_SymbolicNameContext) EXTRACT() antlr.TerminalNode {
	return s.GetToken(CypherParserEXTRACT, 0)
}

func (s *OC_SymbolicNameContext) ANY() antlr.TerminalNode {
	return s.GetToken(CypherParserANY, 0)
}

func (s *OC_SymbolicNameContext) NONE() antlr.TerminalNode {
	return s.GetToken(CypherParserNONE, 0)
}

func (s *OC_SymbolicNameContext) SINGLE() antlr.TerminalNode {
	return s.GetToken(CypherParserSINGLE, 0)
}

func (s *OC_SymbolicNameContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_SymbolicNameContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_SymbolicNameContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_SymbolicName(s)
	}
}

func (s *OC_SymbolicNameContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_SymbolicName(s)
	}
}

func (p *CypherParser) OC_SymbolicName() (localctx IOC_SymbolicNameContext) {
	localctx = NewOC_SymbolicNameContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 284, CypherParserRULE_oC_SymbolicName)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(2184)
		_la = p.GetTokenStream().LA(1)

		if !((int64((_la-110)) & ^0x3f) == 0 && ((int64(1)<<(_la-110))&309237780161) != 0) {
			p.GetErrorHandler().RecoverInline(p)
		} else {
			p.GetErrorHandler().ReportMatch(p)
			p.Consume()
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_LeftArrowHeadContext is an interface to support dynamic dispatch.
type IOC_LeftArrowHeadContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser
	// IsOC_LeftArrowHeadContext differentiates from other interfaces.
	IsOC_LeftArrowHeadContext()
}

type OC_LeftArrowHeadContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_LeftArrowHeadContext() *OC_LeftArrowHeadContext {
	var p = new(OC_LeftArrowHeadContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_LeftArrowHead
	return p
}

func InitEmptyOC_LeftArrowHeadContext(p *OC_LeftArrowHeadContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_LeftArrowHead
}

func (*OC_LeftArrowHeadContext) IsOC_LeftArrowHeadContext() {}

func NewOC_LeftArrowHeadContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_LeftArrowHeadContext {
	var p = new(OC_LeftArrowHeadContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_LeftArrowHead

	return p
}

func (s *OC_LeftArrowHeadContext) GetParser() antlr.Parser { return s.parser }
func (s *OC_LeftArrowHeadContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_LeftArrowHeadContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_LeftArrowHeadContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_LeftArrowHead(s)
	}
}

func (s *OC_LeftArrowHeadContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_LeftArrowHead(s)
	}
}

func (p *CypherParser) OC_LeftArrowHead() (localctx IOC_LeftArrowHeadContext) {
	localctx = NewOC_LeftArrowHeadContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 286, CypherParserRULE_oC_LeftArrowHead)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(2186)
		_la = p.GetTokenStream().LA(1)

		if !((int64(_la) & ^0x3f) == 0 && ((int64(1)<<_la)&4026548224) != 0) {
			p.GetErrorHandler().RecoverInline(p)
		} else {
			p.GetErrorHandler().ReportMatch(p)
			p.Consume()
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_RightArrowHeadContext is an interface to support dynamic dispatch.
type IOC_RightArrowHeadContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser
	// IsOC_RightArrowHeadContext differentiates from other interfaces.
	IsOC_RightArrowHeadContext()
}

type OC_RightArrowHeadContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_RightArrowHeadContext() *OC_RightArrowHeadContext {
	var p = new(OC_RightArrowHeadContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RightArrowHead
	return p
}

func InitEmptyOC_RightArrowHeadContext(p *OC_RightArrowHeadContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_RightArrowHead
}

func (*OC_RightArrowHeadContext) IsOC_RightArrowHeadContext() {}

func NewOC_RightArrowHeadContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_RightArrowHeadContext {
	var p = new(OC_RightArrowHeadContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_RightArrowHead

	return p
}

func (s *OC_RightArrowHeadContext) GetParser() antlr.Parser { return s.parser }
func (s *OC_RightArrowHeadContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_RightArrowHeadContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_RightArrowHeadContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_RightArrowHead(s)
	}
}

func (s *OC_RightArrowHeadContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_RightArrowHead(s)
	}
}

func (p *CypherParser) OC_RightArrowHead() (localctx IOC_RightArrowHeadContext) {
	localctx = NewOC_RightArrowHeadContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 288, CypherParserRULE_oC_RightArrowHead)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(2188)
		_la = p.GetTokenStream().LA(1)

		if !((int64(_la) & ^0x3f) == 0 && ((int64(1)<<_la)&64424542208) != 0) {
			p.GetErrorHandler().RecoverInline(p)
		} else {
			p.GetErrorHandler().ReportMatch(p)
			p.Consume()
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}

// IOC_DashContext is an interface to support dynamic dispatch.
type IOC_DashContext interface {
	antlr.ParserRuleContext

	// GetParser returns the parser.
	GetParser() antlr.Parser
	// IsOC_DashContext differentiates from other interfaces.
	IsOC_DashContext()
}

type OC_DashContext struct {
	antlr.BaseParserRuleContext
	parser antlr.Parser
}

func NewEmptyOC_DashContext() *OC_DashContext {
	var p = new(OC_DashContext)
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Dash
	return p
}

func InitEmptyOC_DashContext(p *OC_DashContext) {
	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, nil, -1)
	p.RuleIndex = CypherParserRULE_oC_Dash
}

func (*OC_DashContext) IsOC_DashContext() {}

func NewOC_DashContext(parser antlr.Parser, parent antlr.ParserRuleContext, invokingState int) *OC_DashContext {
	var p = new(OC_DashContext)

	antlr.InitBaseParserRuleContext(&p.BaseParserRuleContext, parent, invokingState)

	p.parser = parser
	p.RuleIndex = CypherParserRULE_oC_Dash

	return p
}

func (s *OC_DashContext) GetParser() antlr.Parser { return s.parser }
func (s *OC_DashContext) GetRuleContext() antlr.RuleContext {
	return s
}

func (s *OC_DashContext) ToStringTree(ruleNames []string, recog antlr.Recognizer) string {
	return antlr.TreesStringTree(s, ruleNames, recog)
}

func (s *OC_DashContext) EnterRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.EnterOC_Dash(s)
	}
}

func (s *OC_DashContext) ExitRule(listener antlr.ParseTreeListener) {
	if listenerT, ok := listener.(CypherListener); ok {
		listenerT.ExitOC_Dash(s)
	}
}

func (p *CypherParser) OC_Dash() (localctx IOC_DashContext) {
	localctx = NewOC_DashContext(p, p.GetParserRuleContext(), p.GetState())
	p.EnterRule(localctx, 290, CypherParserRULE_oC_Dash)
	var _la int

	p.EnterOuterAlt(localctx, 1)
	{
		p.SetState(2190)
		_la = p.GetTokenStream().LA(1)

		if !((int64(_la) & ^0x3f) == 0 && ((int64(1)<<_la)&140668769927168) != 0) {
			p.GetErrorHandler().RecoverInline(p)
		} else {
			p.GetErrorHandler().ReportMatch(p)
			p.Consume()
		}
	}

errorExit:
	if p.HasError() {
		v := p.GetError()
		localctx.SetException(v)
		p.GetErrorHandler().ReportError(p, v)
		p.GetErrorHandler().Recover(p, v)
		p.SetError(nil)
	}
	p.ExitRule()
	return localctx
	goto errorExit // Trick to prevent compiler error if the label is not used
}
