// Copyright 2025 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

// Code generated by MockGen. DO NOT EDIT.
// Source: query.go
//
// Generated by this command:
//
//	mockgen -source=query.go -copyright_file=../../../../LICENSE.header -destination=./mocks/query.go -package=graph_mocks .
//

// Package graph_mocks is a generated GoMock package.
package graph_mocks

import (
	reflect "reflect"

	graph "github.com/specterops/bloodhound/dawgs/graph"
	gomock "go.uber.org/mock/gomock"
)

// MockResult is a mock of Result interface.
type MockResult struct {
	ctrl     *gomock.Controller
	recorder *MockResultMockRecorder
	isgomock struct{}
}

// MockResultMockRecorder is the mock recorder for MockResult.
type MockResultMockRecorder struct {
	mock *MockResult
}

// NewMockResult creates a new mock instance.
func NewMockResult(ctrl *gomock.Controller) *MockResult {
	mock := &MockResult{ctrl: ctrl}
	mock.recorder = &MockResultMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockResult) EXPECT() *MockResultMockRecorder {
	return m.recorder
}

// Close mocks base method.
func (m *MockResult) Close() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Close")
}

// Close indicates an expected call of Close.
func (mr *MockResultMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockResult)(nil).Close))
}

// Error mocks base method.
func (m *MockResult) Error() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Error")
	ret0, _ := ret[0].(error)
	return ret0
}

// Error indicates an expected call of Error.
func (mr *MockResultMockRecorder) Error() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Error", reflect.TypeOf((*MockResult)(nil).Error))
}

// Mapper mocks base method.
func (m *MockResult) Mapper() graph.ValueMapper {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Mapper")
	ret0, _ := ret[0].(graph.ValueMapper)
	return ret0
}

// Mapper indicates an expected call of Mapper.
func (mr *MockResultMockRecorder) Mapper() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Mapper", reflect.TypeOf((*MockResult)(nil).Mapper))
}

// Next mocks base method.
func (m *MockResult) Next() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Next")
	ret0, _ := ret[0].(bool)
	return ret0
}

// Next indicates an expected call of Next.
func (mr *MockResultMockRecorder) Next() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Next", reflect.TypeOf((*MockResult)(nil).Next))
}

// Scan mocks base method.
func (m *MockResult) Scan(targets ...any) error {
	m.ctrl.T.Helper()
	varargs := []any{}
	for _, a := range targets {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "Scan", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// Scan indicates an expected call of Scan.
func (mr *MockResultMockRecorder) Scan(targets ...any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Scan", reflect.TypeOf((*MockResult)(nil).Scan), targets...)
}

// Values mocks base method.
func (m *MockResult) Values() []any {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Values")
	ret0, _ := ret[0].([]any)
	return ret0
}

// Values indicates an expected call of Values.
func (mr *MockResultMockRecorder) Values() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Values", reflect.TypeOf((*MockResult)(nil).Values))
}

// MockNodeQuery is a mock of NodeQuery interface.
type MockNodeQuery struct {
	ctrl     *gomock.Controller
	recorder *MockNodeQueryMockRecorder
	isgomock struct{}
}

// MockNodeQueryMockRecorder is the mock recorder for MockNodeQuery.
type MockNodeQueryMockRecorder struct {
	mock *MockNodeQuery
}

// NewMockNodeQuery creates a new mock instance.
func NewMockNodeQuery(ctrl *gomock.Controller) *MockNodeQuery {
	mock := &MockNodeQuery{ctrl: ctrl}
	mock.recorder = &MockNodeQueryMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockNodeQuery) EXPECT() *MockNodeQueryMockRecorder {
	return m.recorder
}

// Count mocks base method.
func (m *MockNodeQuery) Count() (int64, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Count")
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Count indicates an expected call of Count.
func (mr *MockNodeQueryMockRecorder) Count() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Count", reflect.TypeOf((*MockNodeQuery)(nil).Count))
}

// Delete mocks base method.
func (m *MockNodeQuery) Delete() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Delete")
	ret0, _ := ret[0].(error)
	return ret0
}

// Delete indicates an expected call of Delete.
func (mr *MockNodeQueryMockRecorder) Delete() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Delete", reflect.TypeOf((*MockNodeQuery)(nil).Delete))
}

// Fetch mocks base method.
func (m *MockNodeQuery) Fetch(delegate func(graph.Cursor[*graph.Node]) error, finalCriteria ...graph.Criteria) error {
	m.ctrl.T.Helper()
	varargs := []any{delegate}
	for _, a := range finalCriteria {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "Fetch", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// Fetch indicates an expected call of Fetch.
func (mr *MockNodeQueryMockRecorder) Fetch(delegate any, finalCriteria ...any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]any{delegate}, finalCriteria...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Fetch", reflect.TypeOf((*MockNodeQuery)(nil).Fetch), varargs...)
}

// FetchIDs mocks base method.
func (m *MockNodeQuery) FetchIDs(delegate func(graph.Cursor[graph.ID]) error) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchIDs", delegate)
	ret0, _ := ret[0].(error)
	return ret0
}

// FetchIDs indicates an expected call of FetchIDs.
func (mr *MockNodeQueryMockRecorder) FetchIDs(delegate any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchIDs", reflect.TypeOf((*MockNodeQuery)(nil).FetchIDs), delegate)
}

// FetchKinds mocks base method.
func (m *MockNodeQuery) FetchKinds(arg0 func(graph.Cursor[graph.KindsResult]) error) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchKinds", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// FetchKinds indicates an expected call of FetchKinds.
func (mr *MockNodeQueryMockRecorder) FetchKinds(arg0 any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchKinds", reflect.TypeOf((*MockNodeQuery)(nil).FetchKinds), arg0)
}

// Filter mocks base method.
func (m *MockNodeQuery) Filter(criteria graph.Criteria) graph.NodeQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Filter", criteria)
	ret0, _ := ret[0].(graph.NodeQuery)
	return ret0
}

// Filter indicates an expected call of Filter.
func (mr *MockNodeQueryMockRecorder) Filter(criteria any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Filter", reflect.TypeOf((*MockNodeQuery)(nil).Filter), criteria)
}

// Filterf mocks base method.
func (m *MockNodeQuery) Filterf(criteriaDelegate graph.CriteriaProvider) graph.NodeQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Filterf", criteriaDelegate)
	ret0, _ := ret[0].(graph.NodeQuery)
	return ret0
}

// Filterf indicates an expected call of Filterf.
func (mr *MockNodeQueryMockRecorder) Filterf(criteriaDelegate any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Filterf", reflect.TypeOf((*MockNodeQuery)(nil).Filterf), criteriaDelegate)
}

// First mocks base method.
func (m *MockNodeQuery) First() (*graph.Node, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "First")
	ret0, _ := ret[0].(*graph.Node)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// First indicates an expected call of First.
func (mr *MockNodeQueryMockRecorder) First() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "First", reflect.TypeOf((*MockNodeQuery)(nil).First))
}

// Limit mocks base method.
func (m *MockNodeQuery) Limit(skip int) graph.NodeQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Limit", skip)
	ret0, _ := ret[0].(graph.NodeQuery)
	return ret0
}

// Limit indicates an expected call of Limit.
func (mr *MockNodeQueryMockRecorder) Limit(skip any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Limit", reflect.TypeOf((*MockNodeQuery)(nil).Limit), skip)
}

// Offset mocks base method.
func (m *MockNodeQuery) Offset(skip int) graph.NodeQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Offset", skip)
	ret0, _ := ret[0].(graph.NodeQuery)
	return ret0
}

// Offset indicates an expected call of Offset.
func (mr *MockNodeQueryMockRecorder) Offset(skip any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Offset", reflect.TypeOf((*MockNodeQuery)(nil).Offset), skip)
}

// OrderBy mocks base method.
func (m *MockNodeQuery) OrderBy(criteria ...graph.Criteria) graph.NodeQuery {
	m.ctrl.T.Helper()
	varargs := []any{}
	for _, a := range criteria {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "OrderBy", varargs...)
	ret0, _ := ret[0].(graph.NodeQuery)
	return ret0
}

// OrderBy indicates an expected call of OrderBy.
func (mr *MockNodeQueryMockRecorder) OrderBy(criteria ...any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "OrderBy", reflect.TypeOf((*MockNodeQuery)(nil).OrderBy), criteria...)
}

// Query mocks base method.
func (m *MockNodeQuery) Query(delegate func(graph.Result) error, finalCriteria ...graph.Criteria) error {
	m.ctrl.T.Helper()
	varargs := []any{delegate}
	for _, a := range finalCriteria {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "Query", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// Query indicates an expected call of Query.
func (mr *MockNodeQueryMockRecorder) Query(delegate any, finalCriteria ...any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]any{delegate}, finalCriteria...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Query", reflect.TypeOf((*MockNodeQuery)(nil).Query), varargs...)
}

// Update mocks base method.
func (m *MockNodeQuery) Update(properties *graph.Properties) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Update", properties)
	ret0, _ := ret[0].(error)
	return ret0
}

// Update indicates an expected call of Update.
func (mr *MockNodeQueryMockRecorder) Update(properties any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Update", reflect.TypeOf((*MockNodeQuery)(nil).Update), properties)
}

// MockRelationshipQuery is a mock of RelationshipQuery interface.
type MockRelationshipQuery struct {
	ctrl     *gomock.Controller
	recorder *MockRelationshipQueryMockRecorder
	isgomock struct{}
}

// MockRelationshipQueryMockRecorder is the mock recorder for MockRelationshipQuery.
type MockRelationshipQueryMockRecorder struct {
	mock *MockRelationshipQuery
}

// NewMockRelationshipQuery creates a new mock instance.
func NewMockRelationshipQuery(ctrl *gomock.Controller) *MockRelationshipQuery {
	mock := &MockRelationshipQuery{ctrl: ctrl}
	mock.recorder = &MockRelationshipQueryMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockRelationshipQuery) EXPECT() *MockRelationshipQueryMockRecorder {
	return m.recorder
}

// Count mocks base method.
func (m *MockRelationshipQuery) Count() (int64, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Count")
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Count indicates an expected call of Count.
func (mr *MockRelationshipQueryMockRecorder) Count() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Count", reflect.TypeOf((*MockRelationshipQuery)(nil).Count))
}

// Delete mocks base method.
func (m *MockRelationshipQuery) Delete() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Delete")
	ret0, _ := ret[0].(error)
	return ret0
}

// Delete indicates an expected call of Delete.
func (mr *MockRelationshipQueryMockRecorder) Delete() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Delete", reflect.TypeOf((*MockRelationshipQuery)(nil).Delete))
}

// Fetch mocks base method.
func (m *MockRelationshipQuery) Fetch(delegate func(graph.Cursor[*graph.Relationship]) error) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Fetch", delegate)
	ret0, _ := ret[0].(error)
	return ret0
}

// Fetch indicates an expected call of Fetch.
func (mr *MockRelationshipQueryMockRecorder) Fetch(delegate any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Fetch", reflect.TypeOf((*MockRelationshipQuery)(nil).Fetch), delegate)
}

// FetchAllShortestPaths mocks base method.
func (m *MockRelationshipQuery) FetchAllShortestPaths(delegate func(graph.Cursor[graph.Path]) error) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchAllShortestPaths", delegate)
	ret0, _ := ret[0].(error)
	return ret0
}

// FetchAllShortestPaths indicates an expected call of FetchAllShortestPaths.
func (mr *MockRelationshipQueryMockRecorder) FetchAllShortestPaths(delegate any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchAllShortestPaths", reflect.TypeOf((*MockRelationshipQuery)(nil).FetchAllShortestPaths), delegate)
}

// FetchDirection mocks base method.
func (m *MockRelationshipQuery) FetchDirection(direction graph.Direction, delegate func(graph.Cursor[graph.DirectionalResult]) error) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchDirection", direction, delegate)
	ret0, _ := ret[0].(error)
	return ret0
}

// FetchDirection indicates an expected call of FetchDirection.
func (mr *MockRelationshipQueryMockRecorder) FetchDirection(direction, delegate any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchDirection", reflect.TypeOf((*MockRelationshipQuery)(nil).FetchDirection), direction, delegate)
}

// FetchIDs mocks base method.
func (m *MockRelationshipQuery) FetchIDs(delegate func(graph.Cursor[graph.ID]) error) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchIDs", delegate)
	ret0, _ := ret[0].(error)
	return ret0
}

// FetchIDs indicates an expected call of FetchIDs.
func (mr *MockRelationshipQueryMockRecorder) FetchIDs(delegate any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchIDs", reflect.TypeOf((*MockRelationshipQuery)(nil).FetchIDs), delegate)
}

// FetchKinds mocks base method.
func (m *MockRelationshipQuery) FetchKinds(delegate func(graph.Cursor[graph.RelationshipKindsResult]) error) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchKinds", delegate)
	ret0, _ := ret[0].(error)
	return ret0
}

// FetchKinds indicates an expected call of FetchKinds.
func (mr *MockRelationshipQueryMockRecorder) FetchKinds(delegate any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchKinds", reflect.TypeOf((*MockRelationshipQuery)(nil).FetchKinds), delegate)
}

// FetchTriples mocks base method.
func (m *MockRelationshipQuery) FetchTriples(delegate func(graph.Cursor[graph.RelationshipTripleResult]) error) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchTriples", delegate)
	ret0, _ := ret[0].(error)
	return ret0
}

// FetchTriples indicates an expected call of FetchTriples.
func (mr *MockRelationshipQueryMockRecorder) FetchTriples(delegate any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchTriples", reflect.TypeOf((*MockRelationshipQuery)(nil).FetchTriples), delegate)
}

// Filter mocks base method.
func (m *MockRelationshipQuery) Filter(criteria graph.Criteria) graph.RelationshipQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Filter", criteria)
	ret0, _ := ret[0].(graph.RelationshipQuery)
	return ret0
}

// Filter indicates an expected call of Filter.
func (mr *MockRelationshipQueryMockRecorder) Filter(criteria any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Filter", reflect.TypeOf((*MockRelationshipQuery)(nil).Filter), criteria)
}

// Filterf mocks base method.
func (m *MockRelationshipQuery) Filterf(criteriaDelegate graph.CriteriaProvider) graph.RelationshipQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Filterf", criteriaDelegate)
	ret0, _ := ret[0].(graph.RelationshipQuery)
	return ret0
}

// Filterf indicates an expected call of Filterf.
func (mr *MockRelationshipQueryMockRecorder) Filterf(criteriaDelegate any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Filterf", reflect.TypeOf((*MockRelationshipQuery)(nil).Filterf), criteriaDelegate)
}

// First mocks base method.
func (m *MockRelationshipQuery) First() (*graph.Relationship, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "First")
	ret0, _ := ret[0].(*graph.Relationship)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// First indicates an expected call of First.
func (mr *MockRelationshipQueryMockRecorder) First() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "First", reflect.TypeOf((*MockRelationshipQuery)(nil).First))
}

// Limit mocks base method.
func (m *MockRelationshipQuery) Limit(skip int) graph.RelationshipQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Limit", skip)
	ret0, _ := ret[0].(graph.RelationshipQuery)
	return ret0
}

// Limit indicates an expected call of Limit.
func (mr *MockRelationshipQueryMockRecorder) Limit(skip any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Limit", reflect.TypeOf((*MockRelationshipQuery)(nil).Limit), skip)
}

// Offset mocks base method.
func (m *MockRelationshipQuery) Offset(skip int) graph.RelationshipQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Offset", skip)
	ret0, _ := ret[0].(graph.RelationshipQuery)
	return ret0
}

// Offset indicates an expected call of Offset.
func (mr *MockRelationshipQueryMockRecorder) Offset(skip any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Offset", reflect.TypeOf((*MockRelationshipQuery)(nil).Offset), skip)
}

// OrderBy mocks base method.
func (m *MockRelationshipQuery) OrderBy(criteria ...graph.Criteria) graph.RelationshipQuery {
	m.ctrl.T.Helper()
	varargs := []any{}
	for _, a := range criteria {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "OrderBy", varargs...)
	ret0, _ := ret[0].(graph.RelationshipQuery)
	return ret0
}

// OrderBy indicates an expected call of OrderBy.
func (mr *MockRelationshipQueryMockRecorder) OrderBy(criteria ...any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "OrderBy", reflect.TypeOf((*MockRelationshipQuery)(nil).OrderBy), criteria...)
}

// Query mocks base method.
func (m *MockRelationshipQuery) Query(delegate func(graph.Result) error, finalCriteria ...graph.Criteria) error {
	m.ctrl.T.Helper()
	varargs := []any{delegate}
	for _, a := range finalCriteria {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "Query", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// Query indicates an expected call of Query.
func (mr *MockRelationshipQueryMockRecorder) Query(delegate any, finalCriteria ...any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]any{delegate}, finalCriteria...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Query", reflect.TypeOf((*MockRelationshipQuery)(nil).Query), varargs...)
}

// Update mocks base method.
func (m *MockRelationshipQuery) Update(properties *graph.Properties) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Update", properties)
	ret0, _ := ret[0].(error)
	return ret0
}

// Update indicates an expected call of Update.
func (mr *MockRelationshipQueryMockRecorder) Update(properties any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Update", reflect.TypeOf((*MockRelationshipQuery)(nil).Update), properties)
}
