import * as AccordionPrimitive from '@radix-ui/react-accordion';
import { ButtonProps as ButtonProps_2 } from '../Button';
import * as CheckboxPrimitive from '@radix-ui/react-checkbox';
import { ClassProp } from 'class-variance-authority/types';
import { ColumnDef } from '@tanstack/react-table';
import { createColumnHelper } from '@tanstack/react-table';
import { DayPicker } from 'react-day-picker';
import { default as default_2 } from 'embla-carousel-react';
import { DetailedHTMLProps } from 'react';
import * as DialogPrimitive from '@radix-ui/react-dialog';
import { flexRender } from '@tanstack/react-table';
import { ForwardRefExoticComponent } from 'react';
import { HTMLAttributes } from 'react';
import { JSX as JSX_2 } from 'react/jsx-runtime';
import * as LabelPrimitive from '@radix-ui/react-label';
import { PluginCreator } from 'tailwindcss/types/config';
import * as PopoverPrimitive from '@radix-ui/react-popover';
import * as React_2 from 'react';
import { RefAttributes } from 'react';
import * as SelectPrimitive from '@radix-ui/react-select';
import * as SwitchPrimitives from '@radix-ui/react-switch';
import { TableOptions } from '@tanstack/react-table';
import * as TabsPrimitive from '@radix-ui/react-tabs';
import * as TooltipPrimitive from '@radix-ui/react-tooltip';
import { UseEmblaCarouselType } from 'embla-carousel-react';
import { useVirtualizer } from '@tanstack/react-virtual';
import { VariantProps } from 'class-variance-authority';
import * as VisuallyHiddenPrimitive from '@radix-ui/react-visually-hidden';

export declare const Accordion: React_2.ForwardRefExoticComponent<(AccordionPrimitive.AccordionSingleProps | AccordionPrimitive.AccordionMultipleProps) & React_2.RefAttributes<HTMLDivElement>>;

export declare const AccordionContent: React_2.ForwardRefExoticComponent<Omit<AccordionPrimitive.AccordionContentProps & React_2.RefAttributes<HTMLDivElement>, "ref"> & React_2.RefAttributes<HTMLDivElement>>;

export declare const AccordionHeader: React_2.ForwardRefExoticComponent<Omit<AccordionPrimitive.AccordionTriggerProps & React_2.RefAttributes<HTMLButtonElement>, "ref"> & React_2.RefAttributes<HTMLButtonElement>>;

export declare const AccordionItem: React_2.ForwardRefExoticComponent<Omit<AccordionPrimitive.AccordionItemProps & React_2.RefAttributes<HTMLDivElement>, "ref"> & React_2.RefAttributes<HTMLDivElement>>;

export declare const Badge: React_2.ForwardRefExoticComponent<BadgeProps & React_2.RefAttributes<HTMLDivElement>>;

declare interface BadgeProps extends React_2.HTMLAttributes<HTMLDivElement> {
    label: string;
    icon?: React_2.ReactNode;
    color?: string;
    backgroundColor?: string;
}

export declare const Breadcrumb: React_2.ForwardRefExoticComponent<Omit<React_2.DetailedHTMLProps<React_2.HTMLAttributes<HTMLElement>, HTMLElement>, "ref"> & {
    separator?: React_2.ReactNode;
} & React_2.RefAttributes<HTMLElement>>;

export declare const BreadcrumbEllipsis: {
    ({ className, ...props }: React_2.ComponentProps<"span">): JSX_2.Element;
    displayName: string;
};

export declare const BreadcrumbItem: React_2.ForwardRefExoticComponent<Omit<React_2.DetailedHTMLProps<React_2.LiHTMLAttributes<HTMLLIElement>, HTMLLIElement>, "ref"> & React_2.RefAttributes<HTMLLIElement>>;

export declare const BreadcrumbLink: React_2.ForwardRefExoticComponent<Omit<React_2.DetailedHTMLProps<React_2.AnchorHTMLAttributes<HTMLAnchorElement>, HTMLAnchorElement>, "ref"> & {
    asChild?: boolean;
} & React_2.RefAttributes<HTMLAnchorElement>>;

export declare const BreadcrumbList: React_2.ForwardRefExoticComponent<Omit<React_2.DetailedHTMLProps<React_2.OlHTMLAttributes<HTMLOListElement>, HTMLOListElement>, "ref"> & React_2.RefAttributes<HTMLOListElement>>;

export declare const BreadcrumbPage: React_2.ForwardRefExoticComponent<Omit<React_2.DetailedHTMLProps<React_2.HTMLAttributes<HTMLSpanElement>, HTMLSpanElement>, "ref"> & React_2.RefAttributes<HTMLSpanElement>>;

export declare const BreadcrumbSeparator: {
    ({ children, className, ...props }: React_2.ComponentProps<"li">): JSX_2.Element;
    displayName: string;
};

export declare const Button: React_2.ForwardRefExoticComponent<ButtonProps & React_2.RefAttributes<HTMLButtonElement>>;

export declare interface ButtonProps extends React_2.ButtonHTMLAttributes<HTMLButtonElement>, VariantProps<typeof ButtonVariants> {
    asChild?: boolean;
}

export declare const ButtonVariants: (props?: ({
    variant?: "primary" | "secondary" | "tertiary" | "transparent" | "text" | "icon" | null | undefined;
    fontColor?: "primary" | null | undefined;
    size?: "medium" | "large" | "small" | null | undefined;
} & ClassProp) | undefined) => string;

export declare function Calendar({ className, classNames, showOutsideDays, ...props }: CalendarProps & {
    onChange?: React_2.ChangeEventHandler<HTMLSelectElement>;
}): JSX_2.Element;

export declare namespace Calendar {
    var displayName: string;
}

export declare type CalendarProps = React_2.ComponentProps<typeof DayPicker>;

export declare const Card: React_2.ForwardRefExoticComponent<React_2.HTMLAttributes<HTMLDivElement> & React_2.RefAttributes<HTMLDivElement>>;

export declare const CardContent: React_2.ForwardRefExoticComponent<React_2.HTMLAttributes<HTMLDivElement> & React_2.RefAttributes<HTMLDivElement>>;

export declare const CardDescription: React_2.ForwardRefExoticComponent<React_2.HTMLAttributes<HTMLParagraphElement> & React_2.RefAttributes<HTMLParagraphElement>>;

export declare const CardFooter: React_2.ForwardRefExoticComponent<React_2.HTMLAttributes<HTMLDivElement> & React_2.RefAttributes<HTMLDivElement>>;

export declare const CardHeader: React_2.ForwardRefExoticComponent<React_2.HTMLAttributes<HTMLDivElement> & React_2.RefAttributes<HTMLDivElement>>;

export declare const CardTitle: React_2.ForwardRefExoticComponent<React_2.HTMLAttributes<HTMLHeadingElement> & React_2.RefAttributes<HTMLParagraphElement>>;

export declare const Carousel: React_2.ForwardRefExoticComponent<React_2.HTMLAttributes<HTMLDivElement> & CarouselProps & React_2.RefAttributes<HTMLDivElement>>;

export declare type CarouselApi = UseEmblaCarouselType[1];

export declare const CarouselContent: React_2.ForwardRefExoticComponent<React_2.HTMLAttributes<HTMLDivElement> & React_2.RefAttributes<HTMLDivElement>>;

export declare const CarouselDots: React_2.ForwardRefExoticComponent<Omit<ButtonProps_2 & React_2.RefAttributes<HTMLButtonElement>, "ref"> & React_2.RefAttributes<HTMLButtonElement>>;

export declare const CarouselItem: React_2.ForwardRefExoticComponent<React_2.HTMLAttributes<HTMLDivElement> & React_2.RefAttributes<HTMLDivElement>>;

export declare const CarouselNext: React_2.ForwardRefExoticComponent<Omit<ButtonProps_2 & React_2.RefAttributes<HTMLButtonElement>, "ref"> & React_2.RefAttributes<HTMLButtonElement>>;

declare type CarouselOptions = UseCarouselParameters[0];

export declare const CarouselPrev: React_2.ForwardRefExoticComponent<Omit<ButtonProps_2 & React_2.RefAttributes<HTMLButtonElement>, "ref"> & React_2.RefAttributes<HTMLButtonElement>>;

declare type CarouselProps = {
    opts?: CarouselOptions;
    autoplay?: boolean;
    orientation?: 'horizontal' | 'vertical';
    setApi?: (api: CarouselApi) => void;
};

export declare const Checkbox: React_2.ForwardRefExoticComponent<CheckboxProps & React_2.RefAttributes<HTMLButtonElement>>;

declare interface CheckboxProps extends React_2.ComponentPropsWithoutRef<typeof CheckboxPrimitive.Root>, VariantProps<typeof CheckboxVariants> {
    icon?: React_2.ReactNode;
}

declare const CheckboxVariants: (props?: ({
    size?: "lg" | "md" | "sm" | null | undefined;
} & ClassProp) | undefined) => string;

declare type ColorOptions = ThemeOptions | CustomColorOptions;

export { ColumnDef }

export declare const ComboBadge: (props: ComboBadgeProps) => JSX_2.Element;

declare interface ComboBadgeProps extends Omit<React.HTMLAttributes<HTMLDivElement>, 'aria-label'> {
    label: string | JSX.Element;
    adornment?: string | JSX.Element;
    /** An arial label is required because of the hidden adornment. Please provide context as to what this badge is conveying to a visual user  */
    ariaLabel: string;
    /** slideLeft by default */
    type?: 'slideLeft' | 'slideRight' | 'inlineSlideLeft' | 'inlineSlideRight';
    /** false by default, displays the adornment without hovering over its peer */
    displayAdornment?: boolean;
    disableAdornment?: boolean;
}

declare interface ContentProps extends React_2.ComponentPropsWithoutRef<typeof TooltipPrimitive.Content> {
    contentWidth?: 'default' | 'match_trigger' | 'lg' | 'md' | 'sm';
}

export { createColumnHelper }

declare type CustomColorOptions = `#${string}` | `rgb(${string})` | `rgba(${string})` | `hsl(${string})` | `hsla(${string})`;

export declare const DataTable: <TData, TValue>(props: DataTableProps<TData, TValue>) => JSX_2.Element;

declare interface DataTableProps<TData, TValue> extends React.HTMLAttributes<HTMLDivElement> {
    /**
     * If using DataTable with a high order component and you need to spread ...rest props, consider casting the  columns prop `as ColumnDef<unknown, unknown>[]` to avoid a noisy TS error.
     *
     * *[Link to more info](https://github.com/microsoft/TypeScript/issues/28938#issuecomment-450636046)*
     * ***
     * Note: Use `ColumnDef<RowInterface>[]` for intellisense when building columns.
     */
    columns: ColumnDef<TData, TValue>[];
    data: TData[];
    onRowClick?: (row: TData) => void;
    selectedRow?: string;
    noResultsFallback?: string | React.ReactNode;
    growLastColumn?: boolean;
    virtualizationOptions?: Partial<Parameters<typeof useVirtualizer>[0]>;
    tableOptions?: Omit<TableOptions<TData>, 'columns' | 'data' | 'getCoreRowModel'>;
    TableProps?: React.ComponentPropsWithoutRef<typeof Table> & {
        disableDefaultOverflowAuto?: boolean;
    };
    TableHeaderProps?: React.ComponentPropsWithoutRef<typeof TableHeader>;
    TableHeaderRowProps?: React.ComponentPropsWithoutRef<typeof TableRow>;
    TableHeadProps?: React.ComponentPropsWithoutRef<typeof TableHead>;
    TableBodyProps?: React.ComponentPropsWithoutRef<typeof TableBody>;
    TableBodyRowProps?: React.ComponentPropsWithoutRef<typeof TableRow>;
    TableCellProps?: React.ComponentPropsWithoutRef<typeof TableCell>;
}

/**
 * See documentation: [Dialog](https://www.radix-ui.com/primitives/docs/components/dialog#root)
 */
export declare const Dialog: React_2.FC<DialogPrimitive.DialogProps>;

export declare const DialogActions: {
    ({ className, ...props }: React_2.HTMLAttributes<HTMLDivElement>): JSX_2.Element;
    displayName: string;
};

/**
 * See documentation: [DialogClose](https://www.radix-ui.com/primitives/docs/components/dialog#close)
 */
export declare const DialogClose: React_2.ForwardRefExoticComponent<DialogPrimitive.DialogCloseProps & React_2.RefAttributes<HTMLButtonElement>>;

/**
 * See documentation: [DialogContent](https://www.radix-ui.com/primitives/docs/components/dialog#content)
 */
export declare const DialogContent: React_2.ForwardRefExoticComponent<DialogContentProps & React_2.RefAttributes<HTMLDivElement>>;

declare interface DialogContentProps extends React_2.ComponentPropsWithoutRef<typeof DialogPrimitive.Content> {
    maxWidth?: (typeof DialogMaxWidth)[number];
    DialogOverlayProps?: DialogOverlayProps;
}

/**
 * See documentation: [DialogDescription](https://www.radix-ui.com/primitives/docs/components/dialog#description)
 */
export declare const DialogDescription: React_2.ForwardRefExoticComponent<Omit<DialogPrimitive.DialogDescriptionProps & React_2.RefAttributes<HTMLParagraphElement>, "ref"> & React_2.RefAttributes<HTMLParagraphElement>>;

export declare const DialogMaxWidth: readonly ["xl", "lg", "md", "sm", "xs"];

/**
 * See documentation: [DialogOverlay](https://www.radix-ui.com/primitives/docs/components/dialog#overlay)
 */
export declare const DialogOverlay: React_2.ForwardRefExoticComponent<DialogOverlayProps & React_2.RefAttributes<HTMLDivElement>>;

declare interface DialogOverlayProps extends React_2.ComponentPropsWithoutRef<typeof DialogPrimitive.Overlay>, VariantProps<typeof DialogOverlayVariants> {
}

declare const DialogOverlayVariants: (props?: ({
    blurBackground?: boolean | null | undefined;
} & ClassProp) | undefined) => string;

/**
 * See documentation: [DialogPortal](https://www.radix-ui.com/primitives/docs/components/dialog#overlay)
 */
export declare const DialogPortal: React_2.FC<DialogPrimitive.DialogPortalProps>;

/**
 * See documentation: [DialogTitle](https://www.radix-ui.com/primitives/docs/components/dialog#title)
 */
export declare const DialogTitle: React_2.ForwardRefExoticComponent<Omit<DialogPrimitive.DialogTitleProps & React_2.RefAttributes<HTMLHeadingElement>, "ref"> & React_2.RefAttributes<HTMLHeadingElement>>;

/**
 * See documentation: [DialogTrigger](https://www.radix-ui.com/primitives/docs/components/dialog#trigger)
 */
export declare const DialogTrigger: React_2.ForwardRefExoticComponent<DialogPrimitive.DialogTriggerProps & React_2.RefAttributes<HTMLButtonElement>>;

export declare const DoodleUIPlugin: PluginCreator;

export declare const DoodleUIPreset: {
    theme: {
        fontFamily: {
            sans: string[];
        };
        container: {
            center: boolean;
            padding: string;
            screens: {
                '2xl': string;
            };
        };
        extend: {
            colors: {
                primary: string;
                'primary-variant': string;
                secondary: string;
                'secondary-variant': string;
                'secondary-variant-2': string;
                tertiary: string;
                'tertiary-variant': string;
                'neutral-light-1': string;
                'neutral-light-2': string;
                'neutral-light-3': string;
                'neutral-light-4': string;
                'neutral-light-5': string;
                'neutral-dark-0': string;
                'neutral-dark-1': string;
                'neutral-dark-2': string;
                'neutral-dark-3': string;
                'neutral-dark-4': string;
                'neutral-dark-5': string;
                'error-1': string;
                'error-2': string;
                'error-3': string;
                purple: string;
                red: string;
                orange: string;
                yellow: string;
                green: string;
                blue: string;
            };
            keyframes: {
                'accordion-down': {
                    from: {
                        height: string;
                    };
                    to: {
                        height: string;
                    };
                };
                'accordion-up': {
                    from: {
                        height: string;
                    };
                    to: {
                        height: string;
                    };
                };
            };
            animation: {
                'accordion-down': string;
                'accordion-up': string;
            };
            boxShadow: {
                inner1xl: string;
                'outer-1': string;
                'outer-2': string;
            };
        };
    };
    plugins: {
        handler: () => void;
    }[];
};

export { flexRender }

export declare const Input: React_2.ForwardRefExoticComponent<InputProps & React_2.RefAttributes<HTMLInputElement>>;

export declare interface InputProps extends React_2.InputHTMLAttributes<HTMLInputElement> {
}

export declare const Label: React_2.ForwardRefExoticComponent<Omit<LabelPrimitive.LabelProps & React_2.RefAttributes<HTMLLabelElement>, "ref"> & VariantProps<(props?: ClassProp | undefined) => string> & React_2.RefAttributes<HTMLLabelElement>>;

export declare const Pagination: React.FC<PaginationProps>;

export declare const PaginationContent: ForwardRefExoticComponent<Omit<DetailedHTMLProps<HTMLAttributes<HTMLDivElement>, HTMLDivElement>, "ref"> & RefAttributes<HTMLDivElement>>;

export declare const PaginationEllipsis: {
    ({ className, ...props }: React.ComponentProps<"span">): JSX_2.Element;
    displayName: string;
};

export declare const PaginationLink: {
    ({ className, isActive, asChild, ...props }: PaginationLinkProps): JSX_2.Element;
    displayName: string;
};

declare type PaginationLinkProps = {
    isActive?: boolean;
    asChild?: boolean;
} & React.ComponentProps<'button'>;

export declare const PaginationNav: {
    ({ className, ...props }: React.ComponentProps<"nav">): JSX_2.Element;
    displayName: string;
};

export declare const PaginationNext: {
    ({ onClick, className, ...props }: React.ComponentProps<typeof PaginationLink>): JSX_2.Element;
    displayName: string;
};

export declare const PaginationPrevious: {
    ({ onClick, className, ...props }: React.ComponentProps<typeof PaginationLink>): JSX_2.Element;
    displayName: string;
};

export declare interface PaginationProps extends React.ComponentProps<'nav'> {
    page: number;
    rowsPerPage: number;
    count: number;
    paginationOptions?: string[];
    defaultPaginationValue?: string;
    onPageChange: (page: number) => void;
    onRowsPerPageChange: (rowsPerPage: number) => void;
}

export declare const Popover: React_2.FC<PopoverPrimitive.PopoverProps>;

export declare const PopoverContent: React_2.ForwardRefExoticComponent<Omit<PopoverPrimitive.PopoverContentProps & React_2.RefAttributes<HTMLDivElement>, "ref"> & React_2.RefAttributes<HTMLDivElement>>;

export declare const PopoverTrigger: React_2.ForwardRefExoticComponent<PopoverPrimitive.PopoverTriggerProps & React_2.RefAttributes<HTMLButtonElement>>;

declare interface Props extends React.HTMLAttributes<HTMLDivElement> {
    value: number;
    color: ColorOptions;
    hideAnimation?: boolean;
}

export declare function RadialGauge(props: Props): JSX_2.Element;

export declare function RiskBadge(props: RiskBadgeProps): JSX_2.Element;

export declare interface RiskBadgeProps extends React.HTMLAttributes<HTMLDivElement>, VariantProps<typeof RiskBadgePropVariants> {
    color?: ColorOptions;
    outlined: boolean;
    label?: string;
}

declare const RiskBadgePropVariants: (props?: ({
    type?: "labeled" | "sm-circle" | "md-circle" | null | undefined;
} & ClassProp) | undefined) => string;

declare type RootProps = React_2.ComponentPropsWithoutRef<typeof TooltipPrimitive.Root>;

export declare const Select: React_2.FC<SelectPrimitive.SelectProps>;

export declare const SelectContent: React_2.ForwardRefExoticComponent<Omit<SelectPrimitive.SelectContentProps & React_2.RefAttributes<HTMLDivElement>, "ref"> & React_2.RefAttributes<HTMLDivElement>>;

export declare const SelectGroup: React_2.ForwardRefExoticComponent<SelectPrimitive.SelectGroupProps & React_2.RefAttributes<HTMLDivElement>>;

export declare const SelectItem: React_2.ForwardRefExoticComponent<Omit<SelectPrimitive.SelectItemProps & React_2.RefAttributes<HTMLDivElement>, "ref"> & React_2.RefAttributes<HTMLDivElement>>;

export declare const SelectLabel: React_2.ForwardRefExoticComponent<Omit<SelectPrimitive.SelectLabelProps & React_2.RefAttributes<HTMLDivElement>, "ref"> & React_2.RefAttributes<HTMLDivElement>>;

export declare const SelectPortal: React_2.FC<SelectPrimitive.SelectPortalProps>;

export declare const SelectScrollDownButton: React_2.ForwardRefExoticComponent<Omit<SelectPrimitive.SelectScrollDownButtonProps & React_2.RefAttributes<HTMLDivElement>, "ref"> & React_2.RefAttributes<HTMLDivElement>>;

export declare const SelectScrollUpButton: React_2.ForwardRefExoticComponent<Omit<SelectPrimitive.SelectScrollUpButtonProps & React_2.RefAttributes<HTMLDivElement>, "ref"> & React_2.RefAttributes<HTMLDivElement>>;

export declare const SelectSeparator: React_2.ForwardRefExoticComponent<Omit<SelectPrimitive.SelectSeparatorProps & React_2.RefAttributes<HTMLDivElement>, "ref"> & React_2.RefAttributes<HTMLDivElement>>;

export declare const SelectTrigger: React_2.ForwardRefExoticComponent<Omit<SelectPrimitive.SelectTriggerProps & React_2.RefAttributes<HTMLButtonElement>, "ref"> & React_2.RefAttributes<HTMLButtonElement>>;

export declare const SelectValue: React_2.ForwardRefExoticComponent<SelectPrimitive.SelectValueProps & React_2.RefAttributes<HTMLSpanElement>>;

export declare const Skeleton: React_2.ForwardRefExoticComponent<React_2.HTMLAttributes<HTMLDivElement> & React_2.RefAttributes<HTMLDivElement>>;

export declare const Switch: ForwardRefExoticComponent<Omit<SwitchPrimitives.SwitchProps & RefAttributes<HTMLButtonElement>, "ref"> & VariantProps<(props?: ({
size?: "medium" | "large" | "small" | null | undefined;
} & ClassProp) | undefined) => string> & {
label?: string;
labelPosition?: "left" | "right";
} & RefAttributes<HTMLButtonElement>>;

export declare const Table: React_2.ForwardRefExoticComponent<React_2.HTMLAttributes<HTMLTableElement> & {
    disableDefaultOverflowAuto?: boolean;
} & React_2.RefAttributes<HTMLTableElement>>;

export declare const TableBody: React_2.ForwardRefExoticComponent<React_2.HTMLAttributes<HTMLTableSectionElement> & React_2.RefAttributes<HTMLTableSectionElement>>;

export declare const TableCaption: React_2.ForwardRefExoticComponent<React_2.HTMLAttributes<HTMLTableCaptionElement> & React_2.RefAttributes<HTMLTableCaptionElement>>;

export declare const TableCell: React_2.ForwardRefExoticComponent<React_2.TdHTMLAttributes<HTMLTableCellElement> & React_2.RefAttributes<HTMLTableCellElement>>;

export declare const TableFooter: React_2.ForwardRefExoticComponent<React_2.HTMLAttributes<HTMLTableSectionElement> & React_2.RefAttributes<HTMLTableSectionElement>>;

export declare const TableHead: React_2.ForwardRefExoticComponent<React_2.ThHTMLAttributes<HTMLTableCellElement> & React_2.RefAttributes<HTMLTableCellElement>>;

export declare const TableHeader: React_2.ForwardRefExoticComponent<React_2.HTMLAttributes<HTMLTableSectionElement> & React_2.RefAttributes<HTMLTableSectionElement>>;

export declare const TableRow: React_2.ForwardRefExoticComponent<React_2.HTMLAttributes<HTMLTableRowElement> & React_2.RefAttributes<HTMLTableRowElement>>;

export declare const Tabs: React_2.ForwardRefExoticComponent<TabsPrimitive.TabsProps & React_2.RefAttributes<HTMLDivElement>>;

export declare const TabsContent: React_2.ForwardRefExoticComponent<Omit<TabsPrimitive.TabsContentProps & React_2.RefAttributes<HTMLDivElement>, "ref"> & React_2.RefAttributes<HTMLDivElement>>;

export declare const TabsList: React_2.ForwardRefExoticComponent<Omit<TabsPrimitive.TabsListProps & React_2.RefAttributes<HTMLDivElement>, "ref"> & React_2.RefAttributes<HTMLDivElement>>;

export declare const TabsTrigger: React_2.ForwardRefExoticComponent<Omit<TabsPrimitive.TabsTriggerProps & React_2.RefAttributes<HTMLButtonElement>, "ref"> & React_2.RefAttributes<HTMLButtonElement>>;

declare type ThemeOptions = (typeof themeOptions)[number];

declare const themeOptions: readonly ["primary", "primary-variant", "primary", "primary-variant", "secondary", "secondary-variant", "tertiary", "tertiary-variant", "purple", "red", "orange", "yellow", "green", "blue"];

export declare const Tooltip: React_2.FC<TooltipProps>;

export declare const TooltipContent: React_2.ForwardRefExoticComponent<ContentProps & React_2.RefAttributes<HTMLDivElement>>;

export declare const TooltipPortal: React_2.FC<TooltipPrimitive.TooltipPortalProps>;

declare interface TooltipProps extends React_2.PropsWithChildren {
    tooltip: string | React_2.ReactNode;
    open?: RootProps['open'];
    defaultOpen?: RootProps['defaultOpen'];
    onOpenChange?: RootProps['onOpenChange'];
    delayDuration?: RootProps['delayDuration'];
    rootProps?: Omit<RootProps, 'open' | 'defaultOpen' | 'onOpenChange' | 'delayDuration'>;
    triggerProps?: TriggerProps;
    contentWidth?: ContentProps['contentWidth'];
    contentProps?: Omit<ContentProps, 'contentWidth'>;
}

export declare const TooltipProvider: React_2.FC<TooltipPrimitive.TooltipProviderProps>;

export declare const TooltipRoot: React_2.FC<TooltipPrimitive.TooltipProps>;

export declare const TooltipTrigger: React_2.ForwardRefExoticComponent<Omit<TooltipPrimitive.TooltipTriggerProps & React_2.RefAttributes<HTMLButtonElement>, "ref"> & React_2.RefAttributes<HTMLButtonElement>>;

declare type TriggerProps = React_2.ComponentPropsWithoutRef<typeof TooltipPrimitive.Trigger>;

declare type UseCarouselParameters = Parameters<typeof default_2>;

/**
 * Radix Doc for [when to use VisuallyHidden](https://www.radix-ui.com/primitives/docs/utilities/visually-hidden)
 */
export declare const VisuallyHidden: ForwardRefExoticComponent<VisuallyHiddenPrimitive.VisuallyHiddenProps & RefAttributes<HTMLSpanElement>>;

export { }
