// Copyright 2025 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/specterops/bloodhound/cmd/api/src/database (interfaces: Database)
//
// Generated by this command:
//
//	mockgen -copyright_file=../../../../LICENSE.header -destination=./mocks/db.go -package=mocks . Database
//

// Package mocks is a generated GoMock package.
package mocks

import (
	context "context"
	reflect "reflect"
	time "time"

	uuid "github.com/gofrs/uuid"
	database "github.com/specterops/bloodhound/cmd/api/src/database"
	null "github.com/specterops/bloodhound/cmd/api/src/database/types/null"
	model "github.com/specterops/bloodhound/cmd/api/src/model"
	appcfg "github.com/specterops/bloodhound/cmd/api/src/model/appcfg"
	graph "github.com/specterops/dawgs/graph"
	gomock "go.uber.org/mock/gomock"
)

// MockDatabase is a mock of Database interface.
type MockDatabase struct {
	ctrl     *gomock.Controller
	recorder *MockDatabaseMockRecorder
	isgomock struct{}
}

// MockDatabaseMockRecorder is the mock recorder for MockDatabase.
type MockDatabaseMockRecorder struct {
	mock *MockDatabase
}

// NewMockDatabase creates a new mock instance.
func NewMockDatabase(ctrl *gomock.Controller) *MockDatabase {
	mock := &MockDatabase{ctrl: ctrl}
	mock.recorder = &MockDatabaseMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockDatabase) EXPECT() *MockDatabaseMockRecorder {
	return m.recorder
}

// AppendAuditLog mocks base method.
func (m *MockDatabase) AppendAuditLog(ctx context.Context, entry model.AuditEntry) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AppendAuditLog", ctx, entry)
	ret0, _ := ret[0].(error)
	return ret0
}

// AppendAuditLog indicates an expected call of AppendAuditLog.
func (mr *MockDatabaseMockRecorder) AppendAuditLog(ctx, entry any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AppendAuditLog", reflect.TypeOf((*MockDatabase)(nil).AppendAuditLog), ctx, entry)
}

// CancelAllIngestJobs mocks base method.
func (m *MockDatabase) CancelAllIngestJobs(ctx context.Context) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelAllIngestJobs", ctx)
	ret0, _ := ret[0].(error)
	return ret0
}

// CancelAllIngestJobs indicates an expected call of CancelAllIngestJobs.
func (mr *MockDatabaseMockRecorder) CancelAllIngestJobs(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelAllIngestJobs", reflect.TypeOf((*MockDatabase)(nil).CancelAllIngestJobs), ctx)
}

// Close mocks base method.
func (m *MockDatabase) Close(ctx context.Context) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Close", ctx)
}

// Close indicates an expected call of Close.
func (mr *MockDatabaseMockRecorder) Close(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockDatabase)(nil).Close), ctx)
}

// CountAllIngestTasks mocks base method.
func (m *MockDatabase) CountAllIngestTasks(ctx context.Context) (int64, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CountAllIngestTasks", ctx)
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CountAllIngestTasks indicates an expected call of CountAllIngestTasks.
func (mr *MockDatabaseMockRecorder) CountAllIngestTasks(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CountAllIngestTasks", reflect.TypeOf((*MockDatabase)(nil).CountAllIngestTasks), ctx)
}

// CreateADDataQualityAggregation mocks base method.
func (m *MockDatabase) CreateADDataQualityAggregation(ctx context.Context, aggregation model.ADDataQualityAggregation) (model.ADDataQualityAggregation, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateADDataQualityAggregation", ctx, aggregation)
	ret0, _ := ret[0].(model.ADDataQualityAggregation)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateADDataQualityAggregation indicates an expected call of CreateADDataQualityAggregation.
func (mr *MockDatabaseMockRecorder) CreateADDataQualityAggregation(ctx, aggregation any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateADDataQualityAggregation", reflect.TypeOf((*MockDatabase)(nil).CreateADDataQualityAggregation), ctx, aggregation)
}

// CreateADDataQualityStats mocks base method.
func (m *MockDatabase) CreateADDataQualityStats(ctx context.Context, stats model.ADDataQualityStats) (model.ADDataQualityStats, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateADDataQualityStats", ctx, stats)
	ret0, _ := ret[0].(model.ADDataQualityStats)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateADDataQualityStats indicates an expected call of CreateADDataQualityStats.
func (mr *MockDatabaseMockRecorder) CreateADDataQualityStats(ctx, stats any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateADDataQualityStats", reflect.TypeOf((*MockDatabase)(nil).CreateADDataQualityStats), ctx, stats)
}

// CreateAssetGroup mocks base method.
func (m *MockDatabase) CreateAssetGroup(ctx context.Context, name, tag string, systemGroup bool) (model.AssetGroup, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateAssetGroup", ctx, name, tag, systemGroup)
	ret0, _ := ret[0].(model.AssetGroup)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateAssetGroup indicates an expected call of CreateAssetGroup.
func (mr *MockDatabaseMockRecorder) CreateAssetGroup(ctx, name, tag, systemGroup any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateAssetGroup", reflect.TypeOf((*MockDatabase)(nil).CreateAssetGroup), ctx, name, tag, systemGroup)
}

// CreateAssetGroupCollection mocks base method.
func (m *MockDatabase) CreateAssetGroupCollection(ctx context.Context, collection model.AssetGroupCollection, entries model.AssetGroupCollectionEntries) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateAssetGroupCollection", ctx, collection, entries)
	ret0, _ := ret[0].(error)
	return ret0
}

// CreateAssetGroupCollection indicates an expected call of CreateAssetGroupCollection.
func (mr *MockDatabaseMockRecorder) CreateAssetGroupCollection(ctx, collection, entries any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateAssetGroupCollection", reflect.TypeOf((*MockDatabase)(nil).CreateAssetGroupCollection), ctx, collection, entries)
}

// CreateAssetGroupHistoryRecord mocks base method.
func (m *MockDatabase) CreateAssetGroupHistoryRecord(ctx context.Context, actorId, email, target string, action model.AssetGroupHistoryAction, assetGroupTagId int, environmentId, note null.String) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateAssetGroupHistoryRecord", ctx, actorId, email, target, action, assetGroupTagId, environmentId, note)
	ret0, _ := ret[0].(error)
	return ret0
}

// CreateAssetGroupHistoryRecord indicates an expected call of CreateAssetGroupHistoryRecord.
func (mr *MockDatabaseMockRecorder) CreateAssetGroupHistoryRecord(ctx, actorId, email, target, action, assetGroupTagId, environmentId, note any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateAssetGroupHistoryRecord", reflect.TypeOf((*MockDatabase)(nil).CreateAssetGroupHistoryRecord), ctx, actorId, email, target, action, assetGroupTagId, environmentId, note)
}

// CreateAssetGroupTag mocks base method.
func (m *MockDatabase) CreateAssetGroupTag(ctx context.Context, tagType model.AssetGroupTagType, user model.User, name, description string, position null.Int32, requireCertify null.Bool) (model.AssetGroupTag, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateAssetGroupTag", ctx, tagType, user, name, description, position, requireCertify)
	ret0, _ := ret[0].(model.AssetGroupTag)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateAssetGroupTag indicates an expected call of CreateAssetGroupTag.
func (mr *MockDatabaseMockRecorder) CreateAssetGroupTag(ctx, tagType, user, name, description, position, requireCertify any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateAssetGroupTag", reflect.TypeOf((*MockDatabase)(nil).CreateAssetGroupTag), ctx, tagType, user, name, description, position, requireCertify)
}

// CreateAssetGroupTagSelector mocks base method.
func (m *MockDatabase) CreateAssetGroupTagSelector(ctx context.Context, assetGroupTagId int, user model.User, name, description string, isDefault, allowDisable bool, autoCertify null.Bool, seeds []model.SelectorSeed) (model.AssetGroupTagSelector, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateAssetGroupTagSelector", ctx, assetGroupTagId, user, name, description, isDefault, allowDisable, autoCertify, seeds)
	ret0, _ := ret[0].(model.AssetGroupTagSelector)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateAssetGroupTagSelector indicates an expected call of CreateAssetGroupTagSelector.
func (mr *MockDatabaseMockRecorder) CreateAssetGroupTagSelector(ctx, assetGroupTagId, user, name, description, isDefault, allowDisable, autoCertify, seeds any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateAssetGroupTagSelector", reflect.TypeOf((*MockDatabase)(nil).CreateAssetGroupTagSelector), ctx, assetGroupTagId, user, name, description, isDefault, allowDisable, autoCertify, seeds)
}

// CreateAuditLog mocks base method.
func (m *MockDatabase) CreateAuditLog(ctx context.Context, auditLog model.AuditLog) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateAuditLog", ctx, auditLog)
	ret0, _ := ret[0].(error)
	return ret0
}

// CreateAuditLog indicates an expected call of CreateAuditLog.
func (mr *MockDatabaseMockRecorder) CreateAuditLog(ctx, auditLog any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateAuditLog", reflect.TypeOf((*MockDatabase)(nil).CreateAuditLog), ctx, auditLog)
}

// CreateAuthSecret mocks base method.
func (m *MockDatabase) CreateAuthSecret(ctx context.Context, authSecret model.AuthSecret) (model.AuthSecret, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateAuthSecret", ctx, authSecret)
	ret0, _ := ret[0].(model.AuthSecret)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateAuthSecret indicates an expected call of CreateAuthSecret.
func (mr *MockDatabaseMockRecorder) CreateAuthSecret(ctx, authSecret any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateAuthSecret", reflect.TypeOf((*MockDatabase)(nil).CreateAuthSecret), ctx, authSecret)
}

// CreateAuthToken mocks base method.
func (m *MockDatabase) CreateAuthToken(ctx context.Context, authToken model.AuthToken) (model.AuthToken, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateAuthToken", ctx, authToken)
	ret0, _ := ret[0].(model.AuthToken)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateAuthToken indicates an expected call of CreateAuthToken.
func (mr *MockDatabaseMockRecorder) CreateAuthToken(ctx, authToken any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateAuthToken", reflect.TypeOf((*MockDatabase)(nil).CreateAuthToken), ctx, authToken)
}

// CreateAzureDataQualityAggregation mocks base method.
func (m *MockDatabase) CreateAzureDataQualityAggregation(ctx context.Context, aggregation model.AzureDataQualityAggregation) (model.AzureDataQualityAggregation, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateAzureDataQualityAggregation", ctx, aggregation)
	ret0, _ := ret[0].(model.AzureDataQualityAggregation)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateAzureDataQualityAggregation indicates an expected call of CreateAzureDataQualityAggregation.
func (mr *MockDatabaseMockRecorder) CreateAzureDataQualityAggregation(ctx, aggregation any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateAzureDataQualityAggregation", reflect.TypeOf((*MockDatabase)(nil).CreateAzureDataQualityAggregation), ctx, aggregation)
}

// CreateAzureDataQualityStats mocks base method.
func (m *MockDatabase) CreateAzureDataQualityStats(ctx context.Context, stats model.AzureDataQualityStats) (model.AzureDataQualityStats, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateAzureDataQualityStats", ctx, stats)
	ret0, _ := ret[0].(model.AzureDataQualityStats)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateAzureDataQualityStats indicates an expected call of CreateAzureDataQualityStats.
func (mr *MockDatabaseMockRecorder) CreateAzureDataQualityStats(ctx, stats any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateAzureDataQualityStats", reflect.TypeOf((*MockDatabase)(nil).CreateAzureDataQualityStats), ctx, stats)
}

// CreateCompositionInfo mocks base method.
func (m *MockDatabase) CreateCompositionInfo(ctx context.Context, nodes model.EdgeCompositionNodes, edges model.EdgeCompositionEdges) (model.EdgeCompositionNodes, model.EdgeCompositionEdges, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateCompositionInfo", ctx, nodes, edges)
	ret0, _ := ret[0].(model.EdgeCompositionNodes)
	ret1, _ := ret[1].(model.EdgeCompositionEdges)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// CreateCompositionInfo indicates an expected call of CreateCompositionInfo.
func (mr *MockDatabaseMockRecorder) CreateCompositionInfo(ctx, nodes, edges any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateCompositionInfo", reflect.TypeOf((*MockDatabase)(nil).CreateCompositionInfo), ctx, nodes, edges)
}

// CreateCustomNodeKinds mocks base method.
func (m *MockDatabase) CreateCustomNodeKinds(ctx context.Context, customNodeKind model.CustomNodeKinds) (model.CustomNodeKinds, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateCustomNodeKinds", ctx, customNodeKind)
	ret0, _ := ret[0].(model.CustomNodeKinds)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateCustomNodeKinds indicates an expected call of CreateCustomNodeKinds.
func (mr *MockDatabaseMockRecorder) CreateCustomNodeKinds(ctx, customNodeKind any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateCustomNodeKinds", reflect.TypeOf((*MockDatabase)(nil).CreateCustomNodeKinds), ctx, customNodeKind)
}

// CreateIngestJob mocks base method.
func (m *MockDatabase) CreateIngestJob(ctx context.Context, job model.IngestJob) (model.IngestJob, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateIngestJob", ctx, job)
	ret0, _ := ret[0].(model.IngestJob)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateIngestJob indicates an expected call of CreateIngestJob.
func (mr *MockDatabaseMockRecorder) CreateIngestJob(ctx, job any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateIngestJob", reflect.TypeOf((*MockDatabase)(nil).CreateIngestJob), ctx, job)
}

// CreateIngestTask mocks base method.
func (m *MockDatabase) CreateIngestTask(ctx context.Context, task model.IngestTask) (model.IngestTask, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateIngestTask", ctx, task)
	ret0, _ := ret[0].(model.IngestTask)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateIngestTask indicates an expected call of CreateIngestTask.
func (mr *MockDatabaseMockRecorder) CreateIngestTask(ctx, task any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateIngestTask", reflect.TypeOf((*MockDatabase)(nil).CreateIngestTask), ctx, task)
}

// CreateInstallation mocks base method.
func (m *MockDatabase) CreateInstallation(ctx context.Context) (model.Installation, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateInstallation", ctx)
	ret0, _ := ret[0].(model.Installation)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateInstallation indicates an expected call of CreateInstallation.
func (mr *MockDatabaseMockRecorder) CreateInstallation(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateInstallation", reflect.TypeOf((*MockDatabase)(nil).CreateInstallation), ctx)
}

// CreateOIDCProvider mocks base method.
func (m *MockDatabase) CreateOIDCProvider(ctx context.Context, name, issuer, clientID string, config model.SSOProviderConfig) (model.OIDCProvider, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateOIDCProvider", ctx, name, issuer, clientID, config)
	ret0, _ := ret[0].(model.OIDCProvider)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateOIDCProvider indicates an expected call of CreateOIDCProvider.
func (mr *MockDatabaseMockRecorder) CreateOIDCProvider(ctx, name, issuer, clientID, config any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateOIDCProvider", reflect.TypeOf((*MockDatabase)(nil).CreateOIDCProvider), ctx, name, issuer, clientID, config)
}

// CreateSAMLIdentityProvider mocks base method.
func (m *MockDatabase) CreateSAMLIdentityProvider(ctx context.Context, samlProvider model.SAMLProvider, config model.SSOProviderConfig) (model.SAMLProvider, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateSAMLIdentityProvider", ctx, samlProvider, config)
	ret0, _ := ret[0].(model.SAMLProvider)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateSAMLIdentityProvider indicates an expected call of CreateSAMLIdentityProvider.
func (mr *MockDatabaseMockRecorder) CreateSAMLIdentityProvider(ctx, samlProvider, config any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSAMLIdentityProvider", reflect.TypeOf((*MockDatabase)(nil).CreateSAMLIdentityProvider), ctx, samlProvider, config)
}

// CreateSSOProvider mocks base method.
func (m *MockDatabase) CreateSSOProvider(ctx context.Context, name string, authProvider model.SessionAuthProvider, config model.SSOProviderConfig) (model.SSOProvider, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateSSOProvider", ctx, name, authProvider, config)
	ret0, _ := ret[0].(model.SSOProvider)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateSSOProvider indicates an expected call of CreateSSOProvider.
func (mr *MockDatabaseMockRecorder) CreateSSOProvider(ctx, name, authProvider, config any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSSOProvider", reflect.TypeOf((*MockDatabase)(nil).CreateSSOProvider), ctx, name, authProvider, config)
}

// CreateSavedQueries mocks base method.
func (m *MockDatabase) CreateSavedQueries(ctx context.Context, savedQueries model.SavedQueries) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateSavedQueries", ctx, savedQueries)
	ret0, _ := ret[0].(error)
	return ret0
}

// CreateSavedQueries indicates an expected call of CreateSavedQueries.
func (mr *MockDatabaseMockRecorder) CreateSavedQueries(ctx, savedQueries any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSavedQueries", reflect.TypeOf((*MockDatabase)(nil).CreateSavedQueries), ctx, savedQueries)
}

// CreateSavedQuery mocks base method.
func (m *MockDatabase) CreateSavedQuery(ctx context.Context, userID uuid.UUID, name, query, description string) (model.SavedQuery, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateSavedQuery", ctx, userID, name, query, description)
	ret0, _ := ret[0].(model.SavedQuery)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateSavedQuery indicates an expected call of CreateSavedQuery.
func (mr *MockDatabaseMockRecorder) CreateSavedQuery(ctx, userID, name, query, description any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSavedQuery", reflect.TypeOf((*MockDatabase)(nil).CreateSavedQuery), ctx, userID, name, query, description)
}

// CreateSavedQueryPermissionToPublic mocks base method.
func (m *MockDatabase) CreateSavedQueryPermissionToPublic(ctx context.Context, queryID int64) (model.SavedQueriesPermissions, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateSavedQueryPermissionToPublic", ctx, queryID)
	ret0, _ := ret[0].(model.SavedQueriesPermissions)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateSavedQueryPermissionToPublic indicates an expected call of CreateSavedQueryPermissionToPublic.
func (mr *MockDatabaseMockRecorder) CreateSavedQueryPermissionToPublic(ctx, queryID any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSavedQueryPermissionToPublic", reflect.TypeOf((*MockDatabase)(nil).CreateSavedQueryPermissionToPublic), ctx, queryID)
}

// CreateSavedQueryPermissionsToUsers mocks base method.
func (m *MockDatabase) CreateSavedQueryPermissionsToUsers(ctx context.Context, queryID int64, userIDs ...uuid.UUID) ([]model.SavedQueriesPermissions, error) {
	m.ctrl.T.Helper()
	varargs := []any{ctx, queryID}
	for _, a := range userIDs {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateSavedQueryPermissionsToUsers", varargs...)
	ret0, _ := ret[0].([]model.SavedQueriesPermissions)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateSavedQueryPermissionsToUsers indicates an expected call of CreateSavedQueryPermissionsToUsers.
func (mr *MockDatabaseMockRecorder) CreateSavedQueryPermissionsToUsers(ctx, queryID any, userIDs ...any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]any{ctx, queryID}, userIDs...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSavedQueryPermissionsToUsers", reflect.TypeOf((*MockDatabase)(nil).CreateSavedQueryPermissionsToUsers), varargs...)
}

// CreateUser mocks base method.
func (m *MockDatabase) CreateUser(ctx context.Context, user model.User) (model.User, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateUser", ctx, user)
	ret0, _ := ret[0].(model.User)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateUser indicates an expected call of CreateUser.
func (mr *MockDatabaseMockRecorder) CreateUser(ctx, user any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateUser", reflect.TypeOf((*MockDatabase)(nil).CreateUser), ctx, user)
}

// CreateUserSession mocks base method.
func (m *MockDatabase) CreateUserSession(ctx context.Context, userSession model.UserSession) (model.UserSession, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateUserSession", ctx, userSession)
	ret0, _ := ret[0].(model.UserSession)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateUserSession indicates an expected call of CreateUserSession.
func (mr *MockDatabaseMockRecorder) CreateUserSession(ctx, userSession any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateUserSession", reflect.TypeOf((*MockDatabase)(nil).CreateUserSession), ctx, userSession)
}

// DeleteAllDataQuality mocks base method.
func (m *MockDatabase) DeleteAllDataQuality(ctx context.Context) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteAllDataQuality", ctx)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteAllDataQuality indicates an expected call of DeleteAllDataQuality.
func (mr *MockDatabaseMockRecorder) DeleteAllDataQuality(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteAllDataQuality", reflect.TypeOf((*MockDatabase)(nil).DeleteAllDataQuality), ctx)
}

// DeleteAllIngestJobs mocks base method.
func (m *MockDatabase) DeleteAllIngestJobs(ctx context.Context) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteAllIngestJobs", ctx)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteAllIngestJobs indicates an expected call of DeleteAllIngestJobs.
func (mr *MockDatabaseMockRecorder) DeleteAllIngestJobs(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteAllIngestJobs", reflect.TypeOf((*MockDatabase)(nil).DeleteAllIngestJobs), ctx)
}

// DeleteAllIngestTasks mocks base method.
func (m *MockDatabase) DeleteAllIngestTasks(ctx context.Context) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteAllIngestTasks", ctx)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteAllIngestTasks indicates an expected call of DeleteAllIngestTasks.
func (mr *MockDatabaseMockRecorder) DeleteAllIngestTasks(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteAllIngestTasks", reflect.TypeOf((*MockDatabase)(nil).DeleteAllIngestTasks), ctx)
}

// DeleteAnalysisRequest mocks base method.
func (m *MockDatabase) DeleteAnalysisRequest(ctx context.Context) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteAnalysisRequest", ctx)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteAnalysisRequest indicates an expected call of DeleteAnalysisRequest.
func (mr *MockDatabaseMockRecorder) DeleteAnalysisRequest(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteAnalysisRequest", reflect.TypeOf((*MockDatabase)(nil).DeleteAnalysisRequest), ctx)
}

// DeleteAssetGroup mocks base method.
func (m *MockDatabase) DeleteAssetGroup(ctx context.Context, assetGroup model.AssetGroup) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteAssetGroup", ctx, assetGroup)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteAssetGroup indicates an expected call of DeleteAssetGroup.
func (mr *MockDatabaseMockRecorder) DeleteAssetGroup(ctx, assetGroup any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteAssetGroup", reflect.TypeOf((*MockDatabase)(nil).DeleteAssetGroup), ctx, assetGroup)
}

// DeleteAssetGroupSelector mocks base method.
func (m *MockDatabase) DeleteAssetGroupSelector(ctx context.Context, selector model.AssetGroupSelector) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteAssetGroupSelector", ctx, selector)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteAssetGroupSelector indicates an expected call of DeleteAssetGroupSelector.
func (mr *MockDatabaseMockRecorder) DeleteAssetGroupSelector(ctx, selector any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteAssetGroupSelector", reflect.TypeOf((*MockDatabase)(nil).DeleteAssetGroupSelector), ctx, selector)
}

// DeleteAssetGroupSelectorsForAssetGroups mocks base method.
func (m *MockDatabase) DeleteAssetGroupSelectorsForAssetGroups(ctx context.Context, assetGroupIds []int) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteAssetGroupSelectorsForAssetGroups", ctx, assetGroupIds)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteAssetGroupSelectorsForAssetGroups indicates an expected call of DeleteAssetGroupSelectorsForAssetGroups.
func (mr *MockDatabaseMockRecorder) DeleteAssetGroupSelectorsForAssetGroups(ctx, assetGroupIds any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteAssetGroupSelectorsForAssetGroups", reflect.TypeOf((*MockDatabase)(nil).DeleteAssetGroupSelectorsForAssetGroups), ctx, assetGroupIds)
}

// DeleteAssetGroupTag mocks base method.
func (m *MockDatabase) DeleteAssetGroupTag(ctx context.Context, user model.User, assetGroupTag model.AssetGroupTag) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteAssetGroupTag", ctx, user, assetGroupTag)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteAssetGroupTag indicates an expected call of DeleteAssetGroupTag.
func (mr *MockDatabaseMockRecorder) DeleteAssetGroupTag(ctx, user, assetGroupTag any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteAssetGroupTag", reflect.TypeOf((*MockDatabase)(nil).DeleteAssetGroupTag), ctx, user, assetGroupTag)
}

// DeleteAssetGroupTagSelector mocks base method.
func (m *MockDatabase) DeleteAssetGroupTagSelector(ctx context.Context, user model.User, selector model.AssetGroupTagSelector) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteAssetGroupTagSelector", ctx, user, selector)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteAssetGroupTagSelector indicates an expected call of DeleteAssetGroupTagSelector.
func (mr *MockDatabaseMockRecorder) DeleteAssetGroupTagSelector(ctx, user, selector any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteAssetGroupTagSelector", reflect.TypeOf((*MockDatabase)(nil).DeleteAssetGroupTagSelector), ctx, user, selector)
}

// DeleteAuthSecret mocks base method.
func (m *MockDatabase) DeleteAuthSecret(ctx context.Context, authSecret model.AuthSecret) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteAuthSecret", ctx, authSecret)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteAuthSecret indicates an expected call of DeleteAuthSecret.
func (mr *MockDatabaseMockRecorder) DeleteAuthSecret(ctx, authSecret any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteAuthSecret", reflect.TypeOf((*MockDatabase)(nil).DeleteAuthSecret), ctx, authSecret)
}

// DeleteAuthToken mocks base method.
func (m *MockDatabase) DeleteAuthToken(ctx context.Context, authToken model.AuthToken) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteAuthToken", ctx, authToken)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteAuthToken indicates an expected call of DeleteAuthToken.
func (mr *MockDatabaseMockRecorder) DeleteAuthToken(ctx, authToken any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteAuthToken", reflect.TypeOf((*MockDatabase)(nil).DeleteAuthToken), ctx, authToken)
}

// DeleteCustomNodeKind mocks base method.
func (m *MockDatabase) DeleteCustomNodeKind(ctx context.Context, kindName string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteCustomNodeKind", ctx, kindName)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteCustomNodeKind indicates an expected call of DeleteCustomNodeKind.
func (mr *MockDatabaseMockRecorder) DeleteCustomNodeKind(ctx, kindName any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteCustomNodeKind", reflect.TypeOf((*MockDatabase)(nil).DeleteCustomNodeKind), ctx, kindName)
}

// DeleteIngestTask mocks base method.
func (m *MockDatabase) DeleteIngestTask(ctx context.Context, ingestTask model.IngestTask) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteIngestTask", ctx, ingestTask)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteIngestTask indicates an expected call of DeleteIngestTask.
func (mr *MockDatabaseMockRecorder) DeleteIngestTask(ctx, ingestTask any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteIngestTask", reflect.TypeOf((*MockDatabase)(nil).DeleteIngestTask), ctx, ingestTask)
}

// DeleteSSOProvider mocks base method.
func (m *MockDatabase) DeleteSSOProvider(ctx context.Context, id int) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteSSOProvider", ctx, id)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteSSOProvider indicates an expected call of DeleteSSOProvider.
func (mr *MockDatabaseMockRecorder) DeleteSSOProvider(ctx, id any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteSSOProvider", reflect.TypeOf((*MockDatabase)(nil).DeleteSSOProvider), ctx, id)
}

// DeleteSavedQuery mocks base method.
func (m *MockDatabase) DeleteSavedQuery(ctx context.Context, savedQueryID int64) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteSavedQuery", ctx, savedQueryID)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteSavedQuery indicates an expected call of DeleteSavedQuery.
func (mr *MockDatabaseMockRecorder) DeleteSavedQuery(ctx, savedQueryID any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteSavedQuery", reflect.TypeOf((*MockDatabase)(nil).DeleteSavedQuery), ctx, savedQueryID)
}

// DeleteSavedQueryPermissionsForUsers mocks base method.
func (m *MockDatabase) DeleteSavedQueryPermissionsForUsers(ctx context.Context, queryID int64, userIDs ...uuid.UUID) error {
	m.ctrl.T.Helper()
	varargs := []any{ctx, queryID}
	for _, a := range userIDs {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteSavedQueryPermissionsForUsers", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteSavedQueryPermissionsForUsers indicates an expected call of DeleteSavedQueryPermissionsForUsers.
func (mr *MockDatabaseMockRecorder) DeleteSavedQueryPermissionsForUsers(ctx, queryID any, userIDs ...any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]any{ctx, queryID}, userIDs...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteSavedQueryPermissionsForUsers", reflect.TypeOf((*MockDatabase)(nil).DeleteSavedQueryPermissionsForUsers), varargs...)
}

// DeleteSelectorNodesByNodeId mocks base method.
func (m *MockDatabase) DeleteSelectorNodesByNodeId(ctx context.Context, selectorId int, nodeId graph.ID) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteSelectorNodesByNodeId", ctx, selectorId, nodeId)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteSelectorNodesByNodeId indicates an expected call of DeleteSelectorNodesByNodeId.
func (mr *MockDatabaseMockRecorder) DeleteSelectorNodesByNodeId(ctx, selectorId, nodeId any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteSelectorNodesByNodeId", reflect.TypeOf((*MockDatabase)(nil).DeleteSelectorNodesByNodeId), ctx, selectorId, nodeId)
}

// DeleteSelectorNodesBySelectorIds mocks base method.
func (m *MockDatabase) DeleteSelectorNodesBySelectorIds(ctx context.Context, selectorId ...int) error {
	m.ctrl.T.Helper()
	varargs := []any{ctx}
	for _, a := range selectorId {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteSelectorNodesBySelectorIds", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteSelectorNodesBySelectorIds indicates an expected call of DeleteSelectorNodesBySelectorIds.
func (mr *MockDatabaseMockRecorder) DeleteSelectorNodesBySelectorIds(ctx any, selectorId ...any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]any{ctx}, selectorId...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteSelectorNodesBySelectorIds", reflect.TypeOf((*MockDatabase)(nil).DeleteSelectorNodesBySelectorIds), varargs...)
}

// DeleteSourceKindsByName mocks base method.
func (m *MockDatabase) DeleteSourceKindsByName(ctx context.Context, kinds graph.Kinds) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteSourceKindsByName", ctx, kinds)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteSourceKindsByName indicates an expected call of DeleteSourceKindsByName.
func (mr *MockDatabaseMockRecorder) DeleteSourceKindsByName(ctx, kinds any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteSourceKindsByName", reflect.TypeOf((*MockDatabase)(nil).DeleteSourceKindsByName), ctx, kinds)
}

// DeleteUser mocks base method.
func (m *MockDatabase) DeleteUser(ctx context.Context, user model.User) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteUser", ctx, user)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteUser indicates an expected call of DeleteUser.
func (mr *MockDatabaseMockRecorder) DeleteUser(ctx, user any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteUser", reflect.TypeOf((*MockDatabase)(nil).DeleteUser), ctx, user)
}

// EndUserSession mocks base method.
func (m *MockDatabase) EndUserSession(ctx context.Context, userSession model.UserSession) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "EndUserSession", ctx, userSession)
}

// EndUserSession indicates an expected call of EndUserSession.
func (mr *MockDatabaseMockRecorder) EndUserSession(ctx, userSession any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EndUserSession", reflect.TypeOf((*MockDatabase)(nil).EndUserSession), ctx, userSession)
}

// GetADDataQualityAggregations mocks base method.
func (m *MockDatabase) GetADDataQualityAggregations(ctx context.Context, start, end time.Time, sort_by string, limit, skip int) (model.ADDataQualityAggregations, int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetADDataQualityAggregations", ctx, start, end, sort_by, limit, skip)
	ret0, _ := ret[0].(model.ADDataQualityAggregations)
	ret1, _ := ret[1].(int)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetADDataQualityAggregations indicates an expected call of GetADDataQualityAggregations.
func (mr *MockDatabaseMockRecorder) GetADDataQualityAggregations(ctx, start, end, sort_by, limit, skip any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetADDataQualityAggregations", reflect.TypeOf((*MockDatabase)(nil).GetADDataQualityAggregations), ctx, start, end, sort_by, limit, skip)
}

// GetADDataQualityStats mocks base method.
func (m *MockDatabase) GetADDataQualityStats(ctx context.Context, domainSid string, start, end time.Time, sort_by string, limit, skip int) (model.ADDataQualityStats, int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetADDataQualityStats", ctx, domainSid, start, end, sort_by, limit, skip)
	ret0, _ := ret[0].(model.ADDataQualityStats)
	ret1, _ := ret[1].(int)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetADDataQualityStats indicates an expected call of GetADDataQualityStats.
func (mr *MockDatabaseMockRecorder) GetADDataQualityStats(ctx, domainSid, start, end, sort_by, limit, skip any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetADDataQualityStats", reflect.TypeOf((*MockDatabase)(nil).GetADDataQualityStats), ctx, domainSid, start, end, sort_by, limit, skip)
}

// GetAggregateADDataQualityStats mocks base method.
func (m *MockDatabase) GetAggregateADDataQualityStats(ctx context.Context, domainSIDs []string, start, end time.Time) (model.ADDataQualityStats, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAggregateADDataQualityStats", ctx, domainSIDs, start, end)
	ret0, _ := ret[0].(model.ADDataQualityStats)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAggregateADDataQualityStats indicates an expected call of GetAggregateADDataQualityStats.
func (mr *MockDatabaseMockRecorder) GetAggregateADDataQualityStats(ctx, domainSIDs, start, end any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAggregateADDataQualityStats", reflect.TypeOf((*MockDatabase)(nil).GetAggregateADDataQualityStats), ctx, domainSIDs, start, end)
}

// GetAllAssetGroups mocks base method.
func (m *MockDatabase) GetAllAssetGroups(ctx context.Context, order string, filter model.SQLFilter) (model.AssetGroups, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAllAssetGroups", ctx, order, filter)
	ret0, _ := ret[0].(model.AssetGroups)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAllAssetGroups indicates an expected call of GetAllAssetGroups.
func (mr *MockDatabaseMockRecorder) GetAllAssetGroups(ctx, order, filter any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAllAssetGroups", reflect.TypeOf((*MockDatabase)(nil).GetAllAssetGroups), ctx, order, filter)
}

// GetAllAuthTokens mocks base method.
func (m *MockDatabase) GetAllAuthTokens(ctx context.Context, order string, filter model.SQLFilter) (model.AuthTokens, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAllAuthTokens", ctx, order, filter)
	ret0, _ := ret[0].(model.AuthTokens)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAllAuthTokens indicates an expected call of GetAllAuthTokens.
func (mr *MockDatabaseMockRecorder) GetAllAuthTokens(ctx, order, filter any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAllAuthTokens", reflect.TypeOf((*MockDatabase)(nil).GetAllAuthTokens), ctx, order, filter)
}

// GetAllConfigurationParameters mocks base method.
func (m *MockDatabase) GetAllConfigurationParameters(ctx context.Context) (appcfg.Parameters, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAllConfigurationParameters", ctx)
	ret0, _ := ret[0].(appcfg.Parameters)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAllConfigurationParameters indicates an expected call of GetAllConfigurationParameters.
func (mr *MockDatabaseMockRecorder) GetAllConfigurationParameters(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAllConfigurationParameters", reflect.TypeOf((*MockDatabase)(nil).GetAllConfigurationParameters), ctx)
}

// GetAllFlags mocks base method.
func (m *MockDatabase) GetAllFlags(ctx context.Context) ([]appcfg.FeatureFlag, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAllFlags", ctx)
	ret0, _ := ret[0].([]appcfg.FeatureFlag)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAllFlags indicates an expected call of GetAllFlags.
func (mr *MockDatabaseMockRecorder) GetAllFlags(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAllFlags", reflect.TypeOf((*MockDatabase)(nil).GetAllFlags), ctx)
}

// GetAllIngestJobs mocks base method.
func (m *MockDatabase) GetAllIngestJobs(ctx context.Context, skip, limit int, order string, filter model.SQLFilter) ([]model.IngestJob, int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAllIngestJobs", ctx, skip, limit, order, filter)
	ret0, _ := ret[0].([]model.IngestJob)
	ret1, _ := ret[1].(int)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetAllIngestJobs indicates an expected call of GetAllIngestJobs.
func (mr *MockDatabaseMockRecorder) GetAllIngestJobs(ctx, skip, limit, order, filter any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAllIngestJobs", reflect.TypeOf((*MockDatabase)(nil).GetAllIngestJobs), ctx, skip, limit, order, filter)
}

// GetAllIngestTasks mocks base method.
func (m *MockDatabase) GetAllIngestTasks(ctx context.Context) (model.IngestTasks, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAllIngestTasks", ctx)
	ret0, _ := ret[0].(model.IngestTasks)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAllIngestTasks indicates an expected call of GetAllIngestTasks.
func (mr *MockDatabaseMockRecorder) GetAllIngestTasks(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAllIngestTasks", reflect.TypeOf((*MockDatabase)(nil).GetAllIngestTasks), ctx)
}

// GetAllPermissions mocks base method.
func (m *MockDatabase) GetAllPermissions(ctx context.Context, order string, filter model.SQLFilter) (model.Permissions, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAllPermissions", ctx, order, filter)
	ret0, _ := ret[0].(model.Permissions)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAllPermissions indicates an expected call of GetAllPermissions.
func (mr *MockDatabaseMockRecorder) GetAllPermissions(ctx, order, filter any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAllPermissions", reflect.TypeOf((*MockDatabase)(nil).GetAllPermissions), ctx, order, filter)
}

// GetAllRoles mocks base method.
func (m *MockDatabase) GetAllRoles(ctx context.Context, order string, filter model.SQLFilter) (model.Roles, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAllRoles", ctx, order, filter)
	ret0, _ := ret[0].(model.Roles)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAllRoles indicates an expected call of GetAllRoles.
func (mr *MockDatabaseMockRecorder) GetAllRoles(ctx, order, filter any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAllRoles", reflect.TypeOf((*MockDatabase)(nil).GetAllRoles), ctx, order, filter)
}

// GetAllSAMLProviders mocks base method.
func (m *MockDatabase) GetAllSAMLProviders(ctx context.Context) (model.SAMLProviders, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAllSAMLProviders", ctx)
	ret0, _ := ret[0].(model.SAMLProviders)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAllSAMLProviders indicates an expected call of GetAllSAMLProviders.
func (mr *MockDatabaseMockRecorder) GetAllSAMLProviders(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAllSAMLProviders", reflect.TypeOf((*MockDatabase)(nil).GetAllSAMLProviders), ctx)
}

// GetAllSSOProviders mocks base method.
func (m *MockDatabase) GetAllSSOProviders(ctx context.Context, order string, sqlFilter model.SQLFilter) ([]model.SSOProvider, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAllSSOProviders", ctx, order, sqlFilter)
	ret0, _ := ret[0].([]model.SSOProvider)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAllSSOProviders indicates an expected call of GetAllSSOProviders.
func (mr *MockDatabaseMockRecorder) GetAllSSOProviders(ctx, order, sqlFilter any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAllSSOProviders", reflect.TypeOf((*MockDatabase)(nil).GetAllSSOProviders), ctx, order, sqlFilter)
}

// GetAllSavedQueriesByUser mocks base method.
func (m *MockDatabase) GetAllSavedQueriesByUser(ctx context.Context, userID uuid.UUID) (model.SavedQueries, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAllSavedQueriesByUser", ctx, userID)
	ret0, _ := ret[0].(model.SavedQueries)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAllSavedQueriesByUser indicates an expected call of GetAllSavedQueriesByUser.
func (mr *MockDatabaseMockRecorder) GetAllSavedQueriesByUser(ctx, userID any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAllSavedQueriesByUser", reflect.TypeOf((*MockDatabase)(nil).GetAllSavedQueriesByUser), ctx, userID)
}

// GetAllUsers mocks base method.
func (m *MockDatabase) GetAllUsers(ctx context.Context, order string, filter model.SQLFilter) (model.Users, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAllUsers", ctx, order, filter)
	ret0, _ := ret[0].(model.Users)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAllUsers indicates an expected call of GetAllUsers.
func (mr *MockDatabaseMockRecorder) GetAllUsers(ctx, order, filter any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAllUsers", reflect.TypeOf((*MockDatabase)(nil).GetAllUsers), ctx, order, filter)
}

// GetAnalysisRequest mocks base method.
func (m *MockDatabase) GetAnalysisRequest(ctx context.Context) (model.AnalysisRequest, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAnalysisRequest", ctx)
	ret0, _ := ret[0].(model.AnalysisRequest)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAnalysisRequest indicates an expected call of GetAnalysisRequest.
func (mr *MockDatabaseMockRecorder) GetAnalysisRequest(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAnalysisRequest", reflect.TypeOf((*MockDatabase)(nil).GetAnalysisRequest), ctx)
}

// GetAssetGroup mocks base method.
func (m *MockDatabase) GetAssetGroup(ctx context.Context, id int32) (model.AssetGroup, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAssetGroup", ctx, id)
	ret0, _ := ret[0].(model.AssetGroup)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAssetGroup indicates an expected call of GetAssetGroup.
func (mr *MockDatabaseMockRecorder) GetAssetGroup(ctx, id any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAssetGroup", reflect.TypeOf((*MockDatabase)(nil).GetAssetGroup), ctx, id)
}

// GetAssetGroupCollections mocks base method.
func (m *MockDatabase) GetAssetGroupCollections(ctx context.Context, assetGroupID int32, order string, filter model.SQLFilter) (model.AssetGroupCollections, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAssetGroupCollections", ctx, assetGroupID, order, filter)
	ret0, _ := ret[0].(model.AssetGroupCollections)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAssetGroupCollections indicates an expected call of GetAssetGroupCollections.
func (mr *MockDatabaseMockRecorder) GetAssetGroupCollections(ctx, assetGroupID, order, filter any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAssetGroupCollections", reflect.TypeOf((*MockDatabase)(nil).GetAssetGroupCollections), ctx, assetGroupID, order, filter)
}

// GetAssetGroupHistoryRecords mocks base method.
func (m *MockDatabase) GetAssetGroupHistoryRecords(ctx context.Context, sqlFilter model.SQLFilter, sortItems model.Sort, skip, limit int) ([]model.AssetGroupHistory, int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAssetGroupHistoryRecords", ctx, sqlFilter, sortItems, skip, limit)
	ret0, _ := ret[0].([]model.AssetGroupHistory)
	ret1, _ := ret[1].(int)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetAssetGroupHistoryRecords indicates an expected call of GetAssetGroupHistoryRecords.
func (mr *MockDatabaseMockRecorder) GetAssetGroupHistoryRecords(ctx, sqlFilter, sortItems, skip, limit any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAssetGroupHistoryRecords", reflect.TypeOf((*MockDatabase)(nil).GetAssetGroupHistoryRecords), ctx, sqlFilter, sortItems, skip, limit)
}

// GetAssetGroupSelector mocks base method.
func (m *MockDatabase) GetAssetGroupSelector(ctx context.Context, id int32) (model.AssetGroupSelector, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAssetGroupSelector", ctx, id)
	ret0, _ := ret[0].(model.AssetGroupSelector)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAssetGroupSelector indicates an expected call of GetAssetGroupSelector.
func (mr *MockDatabaseMockRecorder) GetAssetGroupSelector(ctx, id any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAssetGroupSelector", reflect.TypeOf((*MockDatabase)(nil).GetAssetGroupSelector), ctx, id)
}

// GetAssetGroupTag mocks base method.
func (m *MockDatabase) GetAssetGroupTag(ctx context.Context, assetGroupTagId int) (model.AssetGroupTag, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAssetGroupTag", ctx, assetGroupTagId)
	ret0, _ := ret[0].(model.AssetGroupTag)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAssetGroupTag indicates an expected call of GetAssetGroupTag.
func (mr *MockDatabaseMockRecorder) GetAssetGroupTag(ctx, assetGroupTagId any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAssetGroupTag", reflect.TypeOf((*MockDatabase)(nil).GetAssetGroupTag), ctx, assetGroupTagId)
}

// GetAssetGroupTagForSelection mocks base method.
func (m *MockDatabase) GetAssetGroupTagForSelection(ctx context.Context) ([]model.AssetGroupTag, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAssetGroupTagForSelection", ctx)
	ret0, _ := ret[0].([]model.AssetGroupTag)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAssetGroupTagForSelection indicates an expected call of GetAssetGroupTagForSelection.
func (mr *MockDatabaseMockRecorder) GetAssetGroupTagForSelection(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAssetGroupTagForSelection", reflect.TypeOf((*MockDatabase)(nil).GetAssetGroupTagForSelection), ctx)
}

// GetAssetGroupTagSelectorBySelectorId mocks base method.
func (m *MockDatabase) GetAssetGroupTagSelectorBySelectorId(ctx context.Context, assetGroupTagSelectorId int) (model.AssetGroupTagSelector, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAssetGroupTagSelectorBySelectorId", ctx, assetGroupTagSelectorId)
	ret0, _ := ret[0].(model.AssetGroupTagSelector)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAssetGroupTagSelectorBySelectorId indicates an expected call of GetAssetGroupTagSelectorBySelectorId.
func (mr *MockDatabaseMockRecorder) GetAssetGroupTagSelectorBySelectorId(ctx, assetGroupTagSelectorId any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAssetGroupTagSelectorBySelectorId", reflect.TypeOf((*MockDatabase)(nil).GetAssetGroupTagSelectorBySelectorId), ctx, assetGroupTagSelectorId)
}

// GetAssetGroupTagSelectorCounts mocks base method.
func (m *MockDatabase) GetAssetGroupTagSelectorCounts(ctx context.Context, tagIds []int) (map[int]int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAssetGroupTagSelectorCounts", ctx, tagIds)
	ret0, _ := ret[0].(map[int]int)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAssetGroupTagSelectorCounts indicates an expected call of GetAssetGroupTagSelectorCounts.
func (mr *MockDatabaseMockRecorder) GetAssetGroupTagSelectorCounts(ctx, tagIds any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAssetGroupTagSelectorCounts", reflect.TypeOf((*MockDatabase)(nil).GetAssetGroupTagSelectorCounts), ctx, tagIds)
}

// GetAssetGroupTagSelectors mocks base method.
func (m *MockDatabase) GetAssetGroupTagSelectors(ctx context.Context, sqlFilter model.SQLFilter, limit int) (model.AssetGroupTagSelectors, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAssetGroupTagSelectors", ctx, sqlFilter, limit)
	ret0, _ := ret[0].(model.AssetGroupTagSelectors)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAssetGroupTagSelectors indicates an expected call of GetAssetGroupTagSelectors.
func (mr *MockDatabaseMockRecorder) GetAssetGroupTagSelectors(ctx, sqlFilter, limit any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAssetGroupTagSelectors", reflect.TypeOf((*MockDatabase)(nil).GetAssetGroupTagSelectors), ctx, sqlFilter, limit)
}

// GetAssetGroupTagSelectorsByTagId mocks base method.
func (m *MockDatabase) GetAssetGroupTagSelectorsByTagId(ctx context.Context, assetGroupTagId int, selectorSqlFilter, selectorSeedSqlFilter model.SQLFilter, skip, limit int) (model.AssetGroupTagSelectors, int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAssetGroupTagSelectorsByTagId", ctx, assetGroupTagId, selectorSqlFilter, selectorSeedSqlFilter, skip, limit)
	ret0, _ := ret[0].(model.AssetGroupTagSelectors)
	ret1, _ := ret[1].(int)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetAssetGroupTagSelectorsByTagId indicates an expected call of GetAssetGroupTagSelectorsByTagId.
func (mr *MockDatabaseMockRecorder) GetAssetGroupTagSelectorsByTagId(ctx, assetGroupTagId, selectorSqlFilter, selectorSeedSqlFilter, skip, limit any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAssetGroupTagSelectorsByTagId", reflect.TypeOf((*MockDatabase)(nil).GetAssetGroupTagSelectorsByTagId), ctx, assetGroupTagId, selectorSqlFilter, selectorSeedSqlFilter, skip, limit)
}

// GetAssetGroupTags mocks base method.
func (m *MockDatabase) GetAssetGroupTags(ctx context.Context, sqlFilter model.SQLFilter) (model.AssetGroupTags, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAssetGroupTags", ctx, sqlFilter)
	ret0, _ := ret[0].(model.AssetGroupTags)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAssetGroupTags indicates an expected call of GetAssetGroupTags.
func (mr *MockDatabaseMockRecorder) GetAssetGroupTags(ctx, sqlFilter any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAssetGroupTags", reflect.TypeOf((*MockDatabase)(nil).GetAssetGroupTags), ctx, sqlFilter)
}

// GetAuthSecret mocks base method.
func (m *MockDatabase) GetAuthSecret(ctx context.Context, id int32) (model.AuthSecret, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAuthSecret", ctx, id)
	ret0, _ := ret[0].(model.AuthSecret)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAuthSecret indicates an expected call of GetAuthSecret.
func (mr *MockDatabaseMockRecorder) GetAuthSecret(ctx, id any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAuthSecret", reflect.TypeOf((*MockDatabase)(nil).GetAuthSecret), ctx, id)
}

// GetAuthToken mocks base method.
func (m *MockDatabase) GetAuthToken(ctx context.Context, id uuid.UUID) (model.AuthToken, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAuthToken", ctx, id)
	ret0, _ := ret[0].(model.AuthToken)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAuthToken indicates an expected call of GetAuthToken.
func (mr *MockDatabaseMockRecorder) GetAuthToken(ctx, id any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAuthToken", reflect.TypeOf((*MockDatabase)(nil).GetAuthToken), ctx, id)
}

// GetAzureDataQualityAggregations mocks base method.
func (m *MockDatabase) GetAzureDataQualityAggregations(ctx context.Context, start, end time.Time, sort_by string, limit, skip int) (model.AzureDataQualityAggregations, int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAzureDataQualityAggregations", ctx, start, end, sort_by, limit, skip)
	ret0, _ := ret[0].(model.AzureDataQualityAggregations)
	ret1, _ := ret[1].(int)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetAzureDataQualityAggregations indicates an expected call of GetAzureDataQualityAggregations.
func (mr *MockDatabaseMockRecorder) GetAzureDataQualityAggregations(ctx, start, end, sort_by, limit, skip any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAzureDataQualityAggregations", reflect.TypeOf((*MockDatabase)(nil).GetAzureDataQualityAggregations), ctx, start, end, sort_by, limit, skip)
}

// GetAzureDataQualityStats mocks base method.
func (m *MockDatabase) GetAzureDataQualityStats(ctx context.Context, tenantId string, start, end time.Time, sort_by string, limit, skip int) (model.AzureDataQualityStats, int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAzureDataQualityStats", ctx, tenantId, start, end, sort_by, limit, skip)
	ret0, _ := ret[0].(model.AzureDataQualityStats)
	ret1, _ := ret[1].(int)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetAzureDataQualityStats indicates an expected call of GetAzureDataQualityStats.
func (mr *MockDatabaseMockRecorder) GetAzureDataQualityStats(ctx, tenantId, start, end, sort_by, limit, skip any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAzureDataQualityStats", reflect.TypeOf((*MockDatabase)(nil).GetAzureDataQualityStats), ctx, tenantId, start, end, sort_by, limit, skip)
}

// GetConfigurationParameter mocks base method.
func (m *MockDatabase) GetConfigurationParameter(ctx context.Context, parameterKey appcfg.ParameterKey) (appcfg.Parameter, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetConfigurationParameter", ctx, parameterKey)
	ret0, _ := ret[0].(appcfg.Parameter)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetConfigurationParameter indicates an expected call of GetConfigurationParameter.
func (mr *MockDatabaseMockRecorder) GetConfigurationParameter(ctx, parameterKey any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetConfigurationParameter", reflect.TypeOf((*MockDatabase)(nil).GetConfigurationParameter), ctx, parameterKey)
}

// GetCustomAssetGroupTagSelectorsToMigrate mocks base method.
func (m *MockDatabase) GetCustomAssetGroupTagSelectorsToMigrate(ctx context.Context) (model.AssetGroupTagSelectors, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCustomAssetGroupTagSelectorsToMigrate", ctx)
	ret0, _ := ret[0].(model.AssetGroupTagSelectors)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCustomAssetGroupTagSelectorsToMigrate indicates an expected call of GetCustomAssetGroupTagSelectorsToMigrate.
func (mr *MockDatabaseMockRecorder) GetCustomAssetGroupTagSelectorsToMigrate(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCustomAssetGroupTagSelectorsToMigrate", reflect.TypeOf((*MockDatabase)(nil).GetCustomAssetGroupTagSelectorsToMigrate), ctx)
}

// GetCustomNodeKind mocks base method.
func (m *MockDatabase) GetCustomNodeKind(ctx context.Context, kindName string) (model.CustomNodeKind, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCustomNodeKind", ctx, kindName)
	ret0, _ := ret[0].(model.CustomNodeKind)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCustomNodeKind indicates an expected call of GetCustomNodeKind.
func (mr *MockDatabaseMockRecorder) GetCustomNodeKind(ctx, kindName any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCustomNodeKind", reflect.TypeOf((*MockDatabase)(nil).GetCustomNodeKind), ctx, kindName)
}

// GetCustomNodeKinds mocks base method.
func (m *MockDatabase) GetCustomNodeKinds(ctx context.Context) ([]model.CustomNodeKind, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCustomNodeKinds", ctx)
	ret0, _ := ret[0].([]model.CustomNodeKind)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCustomNodeKinds indicates an expected call of GetCustomNodeKinds.
func (mr *MockDatabaseMockRecorder) GetCustomNodeKinds(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCustomNodeKinds", reflect.TypeOf((*MockDatabase)(nil).GetCustomNodeKinds), ctx)
}

// GetDatapipeStatus mocks base method.
func (m *MockDatabase) GetDatapipeStatus(ctx context.Context) (model.DatapipeStatusWrapper, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetDatapipeStatus", ctx)
	ret0, _ := ret[0].(model.DatapipeStatusWrapper)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetDatapipeStatus indicates an expected call of GetDatapipeStatus.
func (mr *MockDatabaseMockRecorder) GetDatapipeStatus(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDatapipeStatus", reflect.TypeOf((*MockDatabase)(nil).GetDatapipeStatus), ctx)
}

// GetFlag mocks base method.
func (m *MockDatabase) GetFlag(ctx context.Context, id int32) (appcfg.FeatureFlag, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetFlag", ctx, id)
	ret0, _ := ret[0].(appcfg.FeatureFlag)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetFlag indicates an expected call of GetFlag.
func (mr *MockDatabaseMockRecorder) GetFlag(ctx, id any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetFlag", reflect.TypeOf((*MockDatabase)(nil).GetFlag), ctx, id)
}

// GetFlagByKey mocks base method.
func (m *MockDatabase) GetFlagByKey(arg0 context.Context, arg1 string) (appcfg.FeatureFlag, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetFlagByKey", arg0, arg1)
	ret0, _ := ret[0].(appcfg.FeatureFlag)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetFlagByKey indicates an expected call of GetFlagByKey.
func (mr *MockDatabaseMockRecorder) GetFlagByKey(arg0, arg1 any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetFlagByKey", reflect.TypeOf((*MockDatabase)(nil).GetFlagByKey), arg0, arg1)
}

// GetIngestJob mocks base method.
func (m *MockDatabase) GetIngestJob(ctx context.Context, id int64) (model.IngestJob, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetIngestJob", ctx, id)
	ret0, _ := ret[0].(model.IngestJob)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetIngestJob indicates an expected call of GetIngestJob.
func (mr *MockDatabaseMockRecorder) GetIngestJob(ctx, id any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetIngestJob", reflect.TypeOf((*MockDatabase)(nil).GetIngestJob), ctx, id)
}

// GetIngestJobsWithStatus mocks base method.
func (m *MockDatabase) GetIngestJobsWithStatus(ctx context.Context, status model.JobStatus) ([]model.IngestJob, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetIngestJobsWithStatus", ctx, status)
	ret0, _ := ret[0].([]model.IngestJob)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetIngestJobsWithStatus indicates an expected call of GetIngestJobsWithStatus.
func (mr *MockDatabaseMockRecorder) GetIngestJobsWithStatus(ctx, status any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetIngestJobsWithStatus", reflect.TypeOf((*MockDatabase)(nil).GetIngestJobsWithStatus), ctx, status)
}

// GetIngestTasksForJob mocks base method.
func (m *MockDatabase) GetIngestTasksForJob(ctx context.Context, jobID int64) (model.IngestTasks, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetIngestTasksForJob", ctx, jobID)
	ret0, _ := ret[0].(model.IngestTasks)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetIngestTasksForJob indicates an expected call of GetIngestTasksForJob.
func (mr *MockDatabaseMockRecorder) GetIngestTasksForJob(ctx, jobID any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetIngestTasksForJob", reflect.TypeOf((*MockDatabase)(nil).GetIngestTasksForJob), ctx, jobID)
}

// GetInstallation mocks base method.
func (m *MockDatabase) GetInstallation(ctx context.Context) (model.Installation, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetInstallation", ctx)
	ret0, _ := ret[0].(model.Installation)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetInstallation indicates an expected call of GetInstallation.
func (mr *MockDatabaseMockRecorder) GetInstallation(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetInstallation", reflect.TypeOf((*MockDatabase)(nil).GetInstallation), ctx)
}

// GetLatestAssetGroupCollection mocks base method.
func (m *MockDatabase) GetLatestAssetGroupCollection(ctx context.Context, assetGroupID int32) (model.AssetGroupCollection, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetLatestAssetGroupCollection", ctx, assetGroupID)
	ret0, _ := ret[0].(model.AssetGroupCollection)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetLatestAssetGroupCollection indicates an expected call of GetLatestAssetGroupCollection.
func (mr *MockDatabaseMockRecorder) GetLatestAssetGroupCollection(ctx, assetGroupID any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLatestAssetGroupCollection", reflect.TypeOf((*MockDatabase)(nil).GetLatestAssetGroupCollection), ctx, assetGroupID)
}

// GetOrderedAssetGroupTagTiers mocks base method.
func (m *MockDatabase) GetOrderedAssetGroupTagTiers(ctx context.Context) ([]model.AssetGroupTag, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetOrderedAssetGroupTagTiers", ctx)
	ret0, _ := ret[0].([]model.AssetGroupTag)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetOrderedAssetGroupTagTiers indicates an expected call of GetOrderedAssetGroupTagTiers.
func (mr *MockDatabaseMockRecorder) GetOrderedAssetGroupTagTiers(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOrderedAssetGroupTagTiers", reflect.TypeOf((*MockDatabase)(nil).GetOrderedAssetGroupTagTiers), ctx)
}

// GetPermission mocks base method.
func (m *MockDatabase) GetPermission(ctx context.Context, id int) (model.Permission, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPermission", ctx, id)
	ret0, _ := ret[0].(model.Permission)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetPermission indicates an expected call of GetPermission.
func (mr *MockDatabaseMockRecorder) GetPermission(ctx, id any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPermission", reflect.TypeOf((*MockDatabase)(nil).GetPermission), ctx, id)
}

// GetPublicSavedQueries mocks base method.
func (m *MockDatabase) GetPublicSavedQueries(ctx context.Context) (model.SavedQueries, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPublicSavedQueries", ctx)
	ret0, _ := ret[0].(model.SavedQueries)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetPublicSavedQueries indicates an expected call of GetPublicSavedQueries.
func (mr *MockDatabaseMockRecorder) GetPublicSavedQueries(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPublicSavedQueries", reflect.TypeOf((*MockDatabase)(nil).GetPublicSavedQueries), ctx)
}

// GetRole mocks base method.
func (m *MockDatabase) GetRole(ctx context.Context, id int32) (model.Role, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetRole", ctx, id)
	ret0, _ := ret[0].(model.Role)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetRole indicates an expected call of GetRole.
func (mr *MockDatabaseMockRecorder) GetRole(ctx, id any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetRole", reflect.TypeOf((*MockDatabase)(nil).GetRole), ctx, id)
}

// GetRoles mocks base method.
func (m *MockDatabase) GetRoles(ctx context.Context, ids []int32) (model.Roles, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetRoles", ctx, ids)
	ret0, _ := ret[0].(model.Roles)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetRoles indicates an expected call of GetRoles.
func (mr *MockDatabaseMockRecorder) GetRoles(ctx, ids any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetRoles", reflect.TypeOf((*MockDatabase)(nil).GetRoles), ctx, ids)
}

// GetSAMLProvider mocks base method.
func (m *MockDatabase) GetSAMLProvider(ctx context.Context, id int32) (model.SAMLProvider, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSAMLProvider", ctx, id)
	ret0, _ := ret[0].(model.SAMLProvider)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSAMLProvider indicates an expected call of GetSAMLProvider.
func (mr *MockDatabaseMockRecorder) GetSAMLProvider(ctx, id any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSAMLProvider", reflect.TypeOf((*MockDatabase)(nil).GetSAMLProvider), ctx, id)
}

// GetSAMLProviderUsers mocks base method.
func (m *MockDatabase) GetSAMLProviderUsers(ctx context.Context, id int32) (model.Users, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSAMLProviderUsers", ctx, id)
	ret0, _ := ret[0].(model.Users)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSAMLProviderUsers indicates an expected call of GetSAMLProviderUsers.
func (mr *MockDatabaseMockRecorder) GetSAMLProviderUsers(ctx, id any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSAMLProviderUsers", reflect.TypeOf((*MockDatabase)(nil).GetSAMLProviderUsers), ctx, id)
}

// GetSSOProviderById mocks base method.
func (m *MockDatabase) GetSSOProviderById(ctx context.Context, id int32) (model.SSOProvider, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSSOProviderById", ctx, id)
	ret0, _ := ret[0].(model.SSOProvider)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSSOProviderById indicates an expected call of GetSSOProviderById.
func (mr *MockDatabaseMockRecorder) GetSSOProviderById(ctx, id any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSSOProviderById", reflect.TypeOf((*MockDatabase)(nil).GetSSOProviderById), ctx, id)
}

// GetSSOProviderBySlug mocks base method.
func (m *MockDatabase) GetSSOProviderBySlug(ctx context.Context, slug string) (model.SSOProvider, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSSOProviderBySlug", ctx, slug)
	ret0, _ := ret[0].(model.SSOProvider)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSSOProviderBySlug indicates an expected call of GetSSOProviderBySlug.
func (mr *MockDatabaseMockRecorder) GetSSOProviderBySlug(ctx, slug any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSSOProviderBySlug", reflect.TypeOf((*MockDatabase)(nil).GetSSOProviderBySlug), ctx, slug)
}

// GetSSOProviderUsers mocks base method.
func (m *MockDatabase) GetSSOProviderUsers(ctx context.Context, id int) (model.Users, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSSOProviderUsers", ctx, id)
	ret0, _ := ret[0].(model.Users)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSSOProviderUsers indicates an expected call of GetSSOProviderUsers.
func (mr *MockDatabaseMockRecorder) GetSSOProviderUsers(ctx, id any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSSOProviderUsers", reflect.TypeOf((*MockDatabase)(nil).GetSSOProviderUsers), ctx, id)
}

// GetSavedQuery mocks base method.
func (m *MockDatabase) GetSavedQuery(ctx context.Context, savedQueryID int64) (model.SavedQuery, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSavedQuery", ctx, savedQueryID)
	ret0, _ := ret[0].(model.SavedQuery)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSavedQuery indicates an expected call of GetSavedQuery.
func (mr *MockDatabaseMockRecorder) GetSavedQuery(ctx, savedQueryID any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSavedQuery", reflect.TypeOf((*MockDatabase)(nil).GetSavedQuery), ctx, savedQueryID)
}

// GetScopeForSavedQuery mocks base method.
func (m *MockDatabase) GetScopeForSavedQuery(ctx context.Context, queryID int64, userID uuid.UUID) (database.SavedQueryScopeMap, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetScopeForSavedQuery", ctx, queryID, userID)
	ret0, _ := ret[0].(database.SavedQueryScopeMap)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetScopeForSavedQuery indicates an expected call of GetScopeForSavedQuery.
func (mr *MockDatabaseMockRecorder) GetScopeForSavedQuery(ctx, queryID, userID any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetScopeForSavedQuery", reflect.TypeOf((*MockDatabase)(nil).GetScopeForSavedQuery), ctx, queryID, userID)
}

// GetSelectorNodesBySelectorIds mocks base method.
func (m *MockDatabase) GetSelectorNodesBySelectorIds(ctx context.Context, selectorIds ...int) ([]model.AssetGroupSelectorNode, error) {
	m.ctrl.T.Helper()
	varargs := []any{ctx}
	for _, a := range selectorIds {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetSelectorNodesBySelectorIds", varargs...)
	ret0, _ := ret[0].([]model.AssetGroupSelectorNode)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSelectorNodesBySelectorIds indicates an expected call of GetSelectorNodesBySelectorIds.
func (mr *MockDatabaseMockRecorder) GetSelectorNodesBySelectorIds(ctx any, selectorIds ...any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]any{ctx}, selectorIds...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSelectorNodesBySelectorIds", reflect.TypeOf((*MockDatabase)(nil).GetSelectorNodesBySelectorIds), varargs...)
}

// GetSelectorsByMemberId mocks base method.
func (m *MockDatabase) GetSelectorsByMemberId(ctx context.Context, memberId, assetGroupTagId int) (model.AssetGroupTagSelectors, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSelectorsByMemberId", ctx, memberId, assetGroupTagId)
	ret0, _ := ret[0].(model.AssetGroupTagSelectors)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSelectorsByMemberId indicates an expected call of GetSelectorsByMemberId.
func (mr *MockDatabaseMockRecorder) GetSelectorsByMemberId(ctx, memberId, assetGroupTagId any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSelectorsByMemberId", reflect.TypeOf((*MockDatabase)(nil).GetSelectorsByMemberId), ctx, memberId, assetGroupTagId)
}

// GetSharedSavedQueries mocks base method.
func (m *MockDatabase) GetSharedSavedQueries(ctx context.Context, userID uuid.UUID) (model.SavedQueries, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSharedSavedQueries", ctx, userID)
	ret0, _ := ret[0].(model.SavedQueries)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSharedSavedQueries indicates an expected call of GetSharedSavedQueries.
func (mr *MockDatabaseMockRecorder) GetSharedSavedQueries(ctx, userID any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSharedSavedQueries", reflect.TypeOf((*MockDatabase)(nil).GetSharedSavedQueries), ctx, userID)
}

// GetSourceKinds mocks base method.
func (m *MockDatabase) GetSourceKinds(ctx context.Context) ([]database.SourceKind, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSourceKinds", ctx)
	ret0, _ := ret[0].([]database.SourceKind)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSourceKinds indicates an expected call of GetSourceKinds.
func (mr *MockDatabaseMockRecorder) GetSourceKinds(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSourceKinds", reflect.TypeOf((*MockDatabase)(nil).GetSourceKinds), ctx)
}

// GetTimeRangedAssetGroupCollections mocks base method.
func (m *MockDatabase) GetTimeRangedAssetGroupCollections(ctx context.Context, assetGroupID int32, from, to int64, order string) (model.AssetGroupCollections, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTimeRangedAssetGroupCollections", ctx, assetGroupID, from, to, order)
	ret0, _ := ret[0].(model.AssetGroupCollections)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTimeRangedAssetGroupCollections indicates an expected call of GetTimeRangedAssetGroupCollections.
func (mr *MockDatabaseMockRecorder) GetTimeRangedAssetGroupCollections(ctx, assetGroupID, from, to, order any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTimeRangedAssetGroupCollections", reflect.TypeOf((*MockDatabase)(nil).GetTimeRangedAssetGroupCollections), ctx, assetGroupID, from, to, order)
}

// GetUser mocks base method.
func (m *MockDatabase) GetUser(ctx context.Context, id uuid.UUID) (model.User, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetUser", ctx, id)
	ret0, _ := ret[0].(model.User)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetUser indicates an expected call of GetUser.
func (mr *MockDatabaseMockRecorder) GetUser(ctx, id any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetUser", reflect.TypeOf((*MockDatabase)(nil).GetUser), ctx, id)
}

// GetUserSession mocks base method.
func (m *MockDatabase) GetUserSession(ctx context.Context, id int64) (model.UserSession, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetUserSession", ctx, id)
	ret0, _ := ret[0].(model.UserSession)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetUserSession indicates an expected call of GetUserSession.
func (mr *MockDatabaseMockRecorder) GetUserSession(ctx, id any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetUserSession", reflect.TypeOf((*MockDatabase)(nil).GetUserSession), ctx, id)
}

// GetUserToken mocks base method.
func (m *MockDatabase) GetUserToken(ctx context.Context, userId, tokenId uuid.UUID) (model.AuthToken, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetUserToken", ctx, userId, tokenId)
	ret0, _ := ret[0].(model.AuthToken)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetUserToken indicates an expected call of GetUserToken.
func (mr *MockDatabaseMockRecorder) GetUserToken(ctx, userId, tokenId any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetUserToken", reflect.TypeOf((*MockDatabase)(nil).GetUserToken), ctx, userId, tokenId)
}

// HasAnalysisRequest mocks base method.
func (m *MockDatabase) HasAnalysisRequest(ctx context.Context) bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HasAnalysisRequest", ctx)
	ret0, _ := ret[0].(bool)
	return ret0
}

// HasAnalysisRequest indicates an expected call of HasAnalysisRequest.
func (mr *MockDatabaseMockRecorder) HasAnalysisRequest(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HasAnalysisRequest", reflect.TypeOf((*MockDatabase)(nil).HasAnalysisRequest), ctx)
}

// HasCollectedGraphDataDeletionRequest mocks base method.
func (m *MockDatabase) HasCollectedGraphDataDeletionRequest(ctx context.Context) (model.AnalysisRequest, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HasCollectedGraphDataDeletionRequest", ctx)
	ret0, _ := ret[0].(model.AnalysisRequest)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// HasCollectedGraphDataDeletionRequest indicates an expected call of HasCollectedGraphDataDeletionRequest.
func (mr *MockDatabaseMockRecorder) HasCollectedGraphDataDeletionRequest(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HasCollectedGraphDataDeletionRequest", reflect.TypeOf((*MockDatabase)(nil).HasCollectedGraphDataDeletionRequest), ctx)
}

// HasInstallation mocks base method.
func (m *MockDatabase) HasInstallation(ctx context.Context) (bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HasInstallation", ctx)
	ret0, _ := ret[0].(bool)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// HasInstallation indicates an expected call of HasInstallation.
func (mr *MockDatabaseMockRecorder) HasInstallation(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HasInstallation", reflect.TypeOf((*MockDatabase)(nil).HasInstallation), ctx)
}

// InitializeSecretAuth mocks base method.
func (m *MockDatabase) InitializeSecretAuth(ctx context.Context, adminUser model.User, authSecret model.AuthSecret) (model.Installation, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "InitializeSecretAuth", ctx, adminUser, authSecret)
	ret0, _ := ret[0].(model.Installation)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// InitializeSecretAuth indicates an expected call of InitializeSecretAuth.
func (mr *MockDatabaseMockRecorder) InitializeSecretAuth(ctx, adminUser, authSecret any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InitializeSecretAuth", reflect.TypeOf((*MockDatabase)(nil).InitializeSecretAuth), ctx, adminUser, authSecret)
}

// InsertSelectorNode mocks base method.
func (m *MockDatabase) InsertSelectorNode(ctx context.Context, selectorId int, nodeId graph.ID, certified model.AssetGroupCertification, certifiedBy null.String, source model.AssetGroupSelectorNodeSource) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "InsertSelectorNode", ctx, selectorId, nodeId, certified, certifiedBy, source)
	ret0, _ := ret[0].(error)
	return ret0
}

// InsertSelectorNode indicates an expected call of InsertSelectorNode.
func (mr *MockDatabaseMockRecorder) InsertSelectorNode(ctx, selectorId, nodeId, certified, certifiedBy, source any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InsertSelectorNode", reflect.TypeOf((*MockDatabase)(nil).InsertSelectorNode), ctx, selectorId, nodeId, certified, certifiedBy, source)
}

// IsSavedQueryPublic mocks base method.
func (m *MockDatabase) IsSavedQueryPublic(ctx context.Context, savedQueryID int64) (bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsSavedQueryPublic", ctx, savedQueryID)
	ret0, _ := ret[0].(bool)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// IsSavedQueryPublic indicates an expected call of IsSavedQueryPublic.
func (mr *MockDatabaseMockRecorder) IsSavedQueryPublic(ctx, savedQueryID any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsSavedQueryPublic", reflect.TypeOf((*MockDatabase)(nil).IsSavedQueryPublic), ctx, savedQueryID)
}

// IsSavedQuerySharedToUser mocks base method.
func (m *MockDatabase) IsSavedQuerySharedToUser(ctx context.Context, queryID int64, userID uuid.UUID) (bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsSavedQuerySharedToUser", ctx, queryID, userID)
	ret0, _ := ret[0].(bool)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// IsSavedQuerySharedToUser indicates an expected call of IsSavedQuerySharedToUser.
func (mr *MockDatabaseMockRecorder) IsSavedQuerySharedToUser(ctx, queryID, userID any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsSavedQuerySharedToUser", reflect.TypeOf((*MockDatabase)(nil).IsSavedQuerySharedToUser), ctx, queryID, userID)
}

// IsSavedQuerySharedToUserOrPublic mocks base method.
func (m *MockDatabase) IsSavedQuerySharedToUserOrPublic(ctx context.Context, queryID int64, userID uuid.UUID) (bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsSavedQuerySharedToUserOrPublic", ctx, queryID, userID)
	ret0, _ := ret[0].(bool)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// IsSavedQuerySharedToUserOrPublic indicates an expected call of IsSavedQuerySharedToUserOrPublic.
func (mr *MockDatabaseMockRecorder) IsSavedQuerySharedToUserOrPublic(ctx, queryID, userID any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsSavedQuerySharedToUserOrPublic", reflect.TypeOf((*MockDatabase)(nil).IsSavedQuerySharedToUserOrPublic), ctx, queryID, userID)
}

// ListAuditLogs mocks base method.
func (m *MockDatabase) ListAuditLogs(ctx context.Context, before, after time.Time, offset, limit int, order string, filter model.SQLFilter) (model.AuditLogs, int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListAuditLogs", ctx, before, after, offset, limit, order, filter)
	ret0, _ := ret[0].(model.AuditLogs)
	ret1, _ := ret[1].(int)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// ListAuditLogs indicates an expected call of ListAuditLogs.
func (mr *MockDatabaseMockRecorder) ListAuditLogs(ctx, before, after, offset, limit, order, filter any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListAuditLogs", reflect.TypeOf((*MockDatabase)(nil).ListAuditLogs), ctx, before, after, offset, limit, order, filter)
}

// ListSavedQueries mocks base method.
func (m *MockDatabase) ListSavedQueries(ctx context.Context, userID uuid.UUID, order string, filter model.SQLFilter, skip, limit int) (model.SavedQueries, int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListSavedQueries", ctx, userID, order, filter, skip, limit)
	ret0, _ := ret[0].(model.SavedQueries)
	ret1, _ := ret[1].(int)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// ListSavedQueries indicates an expected call of ListSavedQueries.
func (mr *MockDatabaseMockRecorder) ListSavedQueries(ctx, userID, order, filter, skip, limit any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListSavedQueries", reflect.TypeOf((*MockDatabase)(nil).ListSavedQueries), ctx, userID, order, filter, skip, limit)
}

// LookupActiveSessionsByUser mocks base method.
func (m *MockDatabase) LookupActiveSessionsByUser(ctx context.Context, user model.User) ([]model.UserSession, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LookupActiveSessionsByUser", ctx, user)
	ret0, _ := ret[0].([]model.UserSession)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// LookupActiveSessionsByUser indicates an expected call of LookupActiveSessionsByUser.
func (mr *MockDatabaseMockRecorder) LookupActiveSessionsByUser(ctx, user any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LookupActiveSessionsByUser", reflect.TypeOf((*MockDatabase)(nil).LookupActiveSessionsByUser), ctx, user)
}

// LookupUser mocks base method.
func (m *MockDatabase) LookupUser(ctx context.Context, principalName string) (model.User, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LookupUser", ctx, principalName)
	ret0, _ := ret[0].(model.User)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// LookupUser indicates an expected call of LookupUser.
func (mr *MockDatabaseMockRecorder) LookupUser(ctx, principalName any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LookupUser", reflect.TypeOf((*MockDatabase)(nil).LookupUser), ctx, principalName)
}

// Migrate mocks base method.
func (m *MockDatabase) Migrate(ctx context.Context) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Migrate", ctx)
	ret0, _ := ret[0].(error)
	return ret0
}

// Migrate indicates an expected call of Migrate.
func (mr *MockDatabaseMockRecorder) Migrate(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Migrate", reflect.TypeOf((*MockDatabase)(nil).Migrate), ctx)
}

// RegisterSourceKind mocks base method.
func (m *MockDatabase) RegisterSourceKind(ctx context.Context) func(graph.Kind) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RegisterSourceKind", ctx)
	ret0, _ := ret[0].(func(graph.Kind) error)
	return ret0
}

// RegisterSourceKind indicates an expected call of RegisterSourceKind.
func (mr *MockDatabaseMockRecorder) RegisterSourceKind(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RegisterSourceKind", reflect.TypeOf((*MockDatabase)(nil).RegisterSourceKind), ctx)
}

// RequestAnalysis mocks base method.
func (m *MockDatabase) RequestAnalysis(ctx context.Context, requester string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RequestAnalysis", ctx, requester)
	ret0, _ := ret[0].(error)
	return ret0
}

// RequestAnalysis indicates an expected call of RequestAnalysis.
func (mr *MockDatabaseMockRecorder) RequestAnalysis(ctx, requester any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RequestAnalysis", reflect.TypeOf((*MockDatabase)(nil).RequestAnalysis), ctx, requester)
}

// RequestCollectedGraphDataDeletion mocks base method.
func (m *MockDatabase) RequestCollectedGraphDataDeletion(ctx context.Context, request model.AnalysisRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RequestCollectedGraphDataDeletion", ctx, request)
	ret0, _ := ret[0].(error)
	return ret0
}

// RequestCollectedGraphDataDeletion indicates an expected call of RequestCollectedGraphDataDeletion.
func (mr *MockDatabaseMockRecorder) RequestCollectedGraphDataDeletion(ctx, request any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RequestCollectedGraphDataDeletion", reflect.TypeOf((*MockDatabase)(nil).RequestCollectedGraphDataDeletion), ctx, request)
}

// SavedQueryBelongsToUser mocks base method.
func (m *MockDatabase) SavedQueryBelongsToUser(ctx context.Context, userID uuid.UUID, savedQueryID int64) (bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SavedQueryBelongsToUser", ctx, userID, savedQueryID)
	ret0, _ := ret[0].(bool)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SavedQueryBelongsToUser indicates an expected call of SavedQueryBelongsToUser.
func (mr *MockDatabaseMockRecorder) SavedQueryBelongsToUser(ctx, userID, savedQueryID any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SavedQueryBelongsToUser", reflect.TypeOf((*MockDatabase)(nil).SavedQueryBelongsToUser), ctx, userID, savedQueryID)
}

// SetConfigurationParameter mocks base method.
func (m *MockDatabase) SetConfigurationParameter(ctx context.Context, configurationParameter appcfg.Parameter) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetConfigurationParameter", ctx, configurationParameter)
	ret0, _ := ret[0].(error)
	return ret0
}

// SetConfigurationParameter indicates an expected call of SetConfigurationParameter.
func (mr *MockDatabaseMockRecorder) SetConfigurationParameter(ctx, configurationParameter any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetConfigurationParameter", reflect.TypeOf((*MockDatabase)(nil).SetConfigurationParameter), ctx, configurationParameter)
}

// SetDatapipeStatus mocks base method.
func (m *MockDatabase) SetDatapipeStatus(ctx context.Context, status model.DatapipeStatus) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetDatapipeStatus", ctx, status)
	ret0, _ := ret[0].(error)
	return ret0
}

// SetDatapipeStatus indicates an expected call of SetDatapipeStatus.
func (mr *MockDatabaseMockRecorder) SetDatapipeStatus(ctx, status any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetDatapipeStatus", reflect.TypeOf((*MockDatabase)(nil).SetDatapipeStatus), ctx, status)
}

// SetFlag mocks base method.
func (m *MockDatabase) SetFlag(ctx context.Context, value appcfg.FeatureFlag) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetFlag", ctx, value)
	ret0, _ := ret[0].(error)
	return ret0
}

// SetFlag indicates an expected call of SetFlag.
func (mr *MockDatabaseMockRecorder) SetFlag(ctx, value any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetFlag", reflect.TypeOf((*MockDatabase)(nil).SetFlag), ctx, value)
}

// SetLastAnalysisStartTime mocks base method.
func (m *MockDatabase) SetLastAnalysisStartTime(ctx context.Context) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetLastAnalysisStartTime", ctx)
	ret0, _ := ret[0].(error)
	return ret0
}

// SetLastAnalysisStartTime indicates an expected call of SetLastAnalysisStartTime.
func (mr *MockDatabaseMockRecorder) SetLastAnalysisStartTime(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetLastAnalysisStartTime", reflect.TypeOf((*MockDatabase)(nil).SetLastAnalysisStartTime), ctx)
}

// SetUserSessionFlag mocks base method.
func (m *MockDatabase) SetUserSessionFlag(ctx context.Context, userSession *model.UserSession, key model.SessionFlagKey, state bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetUserSessionFlag", ctx, userSession, key, state)
	ret0, _ := ret[0].(error)
	return ret0
}

// SetUserSessionFlag indicates an expected call of SetUserSessionFlag.
func (mr *MockDatabaseMockRecorder) SetUserSessionFlag(ctx, userSession, key, state any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetUserSessionFlag", reflect.TypeOf((*MockDatabase)(nil).SetUserSessionFlag), ctx, userSession, key, state)
}

// SweepAssetGroupCollections mocks base method.
func (m *MockDatabase) SweepAssetGroupCollections(ctx context.Context) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SweepAssetGroupCollections", ctx)
}

// SweepAssetGroupCollections indicates an expected call of SweepAssetGroupCollections.
func (mr *MockDatabaseMockRecorder) SweepAssetGroupCollections(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SweepAssetGroupCollections", reflect.TypeOf((*MockDatabase)(nil).SweepAssetGroupCollections), ctx)
}

// SweepSessions mocks base method.
func (m *MockDatabase) SweepSessions(ctx context.Context) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SweepSessions", ctx)
}

// SweepSessions indicates an expected call of SweepSessions.
func (mr *MockDatabaseMockRecorder) SweepSessions(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SweepSessions", reflect.TypeOf((*MockDatabase)(nil).SweepSessions), ctx)
}

// TerminateUserSessionsBySSOProvider mocks base method.
func (m *MockDatabase) TerminateUserSessionsBySSOProvider(ctx context.Context, ssoProvider model.SSOProvider) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TerminateUserSessionsBySSOProvider", ctx, ssoProvider)
	ret0, _ := ret[0].(error)
	return ret0
}

// TerminateUserSessionsBySSOProvider indicates an expected call of TerminateUserSessionsBySSOProvider.
func (mr *MockDatabaseMockRecorder) TerminateUserSessionsBySSOProvider(ctx, ssoProvider any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TerminateUserSessionsBySSOProvider", reflect.TypeOf((*MockDatabase)(nil).TerminateUserSessionsBySSOProvider), ctx, ssoProvider)
}

// UpdateAssetGroup mocks base method.
func (m *MockDatabase) UpdateAssetGroup(ctx context.Context, assetGroup model.AssetGroup) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateAssetGroup", ctx, assetGroup)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateAssetGroup indicates an expected call of UpdateAssetGroup.
func (mr *MockDatabaseMockRecorder) UpdateAssetGroup(ctx, assetGroup any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateAssetGroup", reflect.TypeOf((*MockDatabase)(nil).UpdateAssetGroup), ctx, assetGroup)
}

// UpdateAssetGroupSelectors mocks base method.
func (m *MockDatabase) UpdateAssetGroupSelectors(ctx context.Context, assetGroup model.AssetGroup, selectorSpecs []model.AssetGroupSelectorSpec, systemSelector bool) (model.UpdatedAssetGroupSelectors, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateAssetGroupSelectors", ctx, assetGroup, selectorSpecs, systemSelector)
	ret0, _ := ret[0].(model.UpdatedAssetGroupSelectors)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateAssetGroupSelectors indicates an expected call of UpdateAssetGroupSelectors.
func (mr *MockDatabaseMockRecorder) UpdateAssetGroupSelectors(ctx, assetGroup, selectorSpecs, systemSelector any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateAssetGroupSelectors", reflect.TypeOf((*MockDatabase)(nil).UpdateAssetGroupSelectors), ctx, assetGroup, selectorSpecs, systemSelector)
}

// UpdateAssetGroupTag mocks base method.
func (m *MockDatabase) UpdateAssetGroupTag(ctx context.Context, user model.User, tag model.AssetGroupTag) (model.AssetGroupTag, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateAssetGroupTag", ctx, user, tag)
	ret0, _ := ret[0].(model.AssetGroupTag)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateAssetGroupTag indicates an expected call of UpdateAssetGroupTag.
func (mr *MockDatabaseMockRecorder) UpdateAssetGroupTag(ctx, user, tag any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateAssetGroupTag", reflect.TypeOf((*MockDatabase)(nil).UpdateAssetGroupTag), ctx, user, tag)
}

// UpdateAssetGroupTagSelector mocks base method.
func (m *MockDatabase) UpdateAssetGroupTagSelector(ctx context.Context, actorId, email string, selector model.AssetGroupTagSelector) (model.AssetGroupTagSelector, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateAssetGroupTagSelector", ctx, actorId, email, selector)
	ret0, _ := ret[0].(model.AssetGroupTagSelector)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateAssetGroupTagSelector indicates an expected call of UpdateAssetGroupTagSelector.
func (mr *MockDatabaseMockRecorder) UpdateAssetGroupTagSelector(ctx, actorId, email, selector any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateAssetGroupTagSelector", reflect.TypeOf((*MockDatabase)(nil).UpdateAssetGroupTagSelector), ctx, actorId, email, selector)
}

// UpdateAuthSecret mocks base method.
func (m *MockDatabase) UpdateAuthSecret(ctx context.Context, authSecret model.AuthSecret) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateAuthSecret", ctx, authSecret)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateAuthSecret indicates an expected call of UpdateAuthSecret.
func (mr *MockDatabaseMockRecorder) UpdateAuthSecret(ctx, authSecret any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateAuthSecret", reflect.TypeOf((*MockDatabase)(nil).UpdateAuthSecret), ctx, authSecret)
}

// UpdateAuthToken mocks base method.
func (m *MockDatabase) UpdateAuthToken(ctx context.Context, authToken model.AuthToken) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateAuthToken", ctx, authToken)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateAuthToken indicates an expected call of UpdateAuthToken.
func (mr *MockDatabaseMockRecorder) UpdateAuthToken(ctx, authToken any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateAuthToken", reflect.TypeOf((*MockDatabase)(nil).UpdateAuthToken), ctx, authToken)
}

// UpdateCustomNodeKind mocks base method.
func (m *MockDatabase) UpdateCustomNodeKind(ctx context.Context, customNodeKind model.CustomNodeKind) (model.CustomNodeKind, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateCustomNodeKind", ctx, customNodeKind)
	ret0, _ := ret[0].(model.CustomNodeKind)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateCustomNodeKind indicates an expected call of UpdateCustomNodeKind.
func (mr *MockDatabaseMockRecorder) UpdateCustomNodeKind(ctx, customNodeKind any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateCustomNodeKind", reflect.TypeOf((*MockDatabase)(nil).UpdateCustomNodeKind), ctx, customNodeKind)
}

// UpdateIngestJob mocks base method.
func (m *MockDatabase) UpdateIngestJob(ctx context.Context, job model.IngestJob) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateIngestJob", ctx, job)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateIngestJob indicates an expected call of UpdateIngestJob.
func (mr *MockDatabaseMockRecorder) UpdateIngestJob(ctx, job any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateIngestJob", reflect.TypeOf((*MockDatabase)(nil).UpdateIngestJob), ctx, job)
}

// UpdateLastAnalysisCompleteTime mocks base method.
func (m *MockDatabase) UpdateLastAnalysisCompleteTime(ctx context.Context) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateLastAnalysisCompleteTime", ctx)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateLastAnalysisCompleteTime indicates an expected call of UpdateLastAnalysisCompleteTime.
func (mr *MockDatabaseMockRecorder) UpdateLastAnalysisCompleteTime(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateLastAnalysisCompleteTime", reflect.TypeOf((*MockDatabase)(nil).UpdateLastAnalysisCompleteTime), ctx)
}

// UpdateOIDCProvider mocks base method.
func (m *MockDatabase) UpdateOIDCProvider(ctx context.Context, ssoProvider model.SSOProvider) (model.OIDCProvider, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateOIDCProvider", ctx, ssoProvider)
	ret0, _ := ret[0].(model.OIDCProvider)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateOIDCProvider indicates an expected call of UpdateOIDCProvider.
func (mr *MockDatabaseMockRecorder) UpdateOIDCProvider(ctx, ssoProvider any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateOIDCProvider", reflect.TypeOf((*MockDatabase)(nil).UpdateOIDCProvider), ctx, ssoProvider)
}

// UpdateSAMLIdentityProvider mocks base method.
func (m *MockDatabase) UpdateSAMLIdentityProvider(ctx context.Context, ssoProvider model.SSOProvider) (model.SAMLProvider, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateSAMLIdentityProvider", ctx, ssoProvider)
	ret0, _ := ret[0].(model.SAMLProvider)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateSAMLIdentityProvider indicates an expected call of UpdateSAMLIdentityProvider.
func (mr *MockDatabaseMockRecorder) UpdateSAMLIdentityProvider(ctx, ssoProvider any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateSAMLIdentityProvider", reflect.TypeOf((*MockDatabase)(nil).UpdateSAMLIdentityProvider), ctx, ssoProvider)
}

// UpdateSSOProvider mocks base method.
func (m *MockDatabase) UpdateSSOProvider(ctx context.Context, ssoProvider model.SSOProvider) (model.SSOProvider, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateSSOProvider", ctx, ssoProvider)
	ret0, _ := ret[0].(model.SSOProvider)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateSSOProvider indicates an expected call of UpdateSSOProvider.
func (mr *MockDatabaseMockRecorder) UpdateSSOProvider(ctx, ssoProvider any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateSSOProvider", reflect.TypeOf((*MockDatabase)(nil).UpdateSSOProvider), ctx, ssoProvider)
}

// UpdateSavedQuery mocks base method.
func (m *MockDatabase) UpdateSavedQuery(ctx context.Context, savedQuery model.SavedQuery) (model.SavedQuery, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateSavedQuery", ctx, savedQuery)
	ret0, _ := ret[0].(model.SavedQuery)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateSavedQuery indicates an expected call of UpdateSavedQuery.
func (mr *MockDatabaseMockRecorder) UpdateSavedQuery(ctx, savedQuery any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateSavedQuery", reflect.TypeOf((*MockDatabase)(nil).UpdateSavedQuery), ctx, savedQuery)
}

// UpdateSelectorNodesByNodeId mocks base method.
func (m *MockDatabase) UpdateSelectorNodesByNodeId(ctx context.Context, selectorId int, certified model.AssetGroupCertification, certifiedBy null.String, nodeId graph.ID) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateSelectorNodesByNodeId", ctx, selectorId, certified, certifiedBy, nodeId)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateSelectorNodesByNodeId indicates an expected call of UpdateSelectorNodesByNodeId.
func (mr *MockDatabaseMockRecorder) UpdateSelectorNodesByNodeId(ctx, selectorId, certified, certifiedBy, nodeId any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateSelectorNodesByNodeId", reflect.TypeOf((*MockDatabase)(nil).UpdateSelectorNodesByNodeId), ctx, selectorId, certified, certifiedBy, nodeId)
}

// UpdateUser mocks base method.
func (m *MockDatabase) UpdateUser(ctx context.Context, user model.User) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateUser", ctx, user)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateUser indicates an expected call of UpdateUser.
func (mr *MockDatabaseMockRecorder) UpdateUser(ctx, user any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateUser", reflect.TypeOf((*MockDatabase)(nil).UpdateUser), ctx, user)
}

// Wipe mocks base method.
func (m *MockDatabase) Wipe(ctx context.Context) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Wipe", ctx)
	ret0, _ := ret[0].(error)
	return ret0
}

// Wipe indicates an expected call of Wipe.
func (mr *MockDatabaseMockRecorder) Wipe(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Wipe", reflect.TypeOf((*MockDatabase)(nil).Wipe), ctx)
}
