// Copyright 2025 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/specterops/bloodhound/cmd/api/src/services/upload (interfaces: UploadData)
//
// Generated by this command:
//
//	mockgen -copyright_file=../../../../../LICENSE.header -destination=./mocks/mock.go -package=mocks . UploadData
//

// Package mocks is a generated GoMock package.
package mocks

import (
	context "context"
	reflect "reflect"

	model "github.com/specterops/bloodhound/cmd/api/src/model"
	gomock "go.uber.org/mock/gomock"
)

// MockUploadData is a mock of UploadData interface.
type MockUploadData struct {
	ctrl     *gomock.Controller
	recorder *MockUploadDataMockRecorder
	isgomock struct{}
}

// MockUploadDataMockRecorder is the mock recorder for MockUploadData.
type MockUploadDataMockRecorder struct {
	mock *MockUploadData
}

// NewMockUploadData creates a new mock instance.
func NewMockUploadData(ctrl *gomock.Controller) *MockUploadData {
	mock := &MockUploadData{ctrl: ctrl}
	mock.recorder = &MockUploadDataMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockUploadData) EXPECT() *MockUploadDataMockRecorder {
	return m.recorder
}

// CancelAllIngestJobs mocks base method.
func (m *MockUploadData) CancelAllIngestJobs(ctx context.Context) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelAllIngestJobs", ctx)
	ret0, _ := ret[0].(error)
	return ret0
}

// CancelAllIngestJobs indicates an expected call of CancelAllIngestJobs.
func (mr *MockUploadDataMockRecorder) CancelAllIngestJobs(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelAllIngestJobs", reflect.TypeOf((*MockUploadData)(nil).CancelAllIngestJobs), ctx)
}

// CreateCompositionInfo mocks base method.
func (m *MockUploadData) CreateCompositionInfo(ctx context.Context, nodes model.EdgeCompositionNodes, edges model.EdgeCompositionEdges) (model.EdgeCompositionNodes, model.EdgeCompositionEdges, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateCompositionInfo", ctx, nodes, edges)
	ret0, _ := ret[0].(model.EdgeCompositionNodes)
	ret1, _ := ret[1].(model.EdgeCompositionEdges)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// CreateCompositionInfo indicates an expected call of CreateCompositionInfo.
func (mr *MockUploadDataMockRecorder) CreateCompositionInfo(ctx, nodes, edges any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateCompositionInfo", reflect.TypeOf((*MockUploadData)(nil).CreateCompositionInfo), ctx, nodes, edges)
}

// CreateIngestJob mocks base method.
func (m *MockUploadData) CreateIngestJob(ctx context.Context, job model.IngestJob) (model.IngestJob, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateIngestJob", ctx, job)
	ret0, _ := ret[0].(model.IngestJob)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateIngestJob indicates an expected call of CreateIngestJob.
func (mr *MockUploadDataMockRecorder) CreateIngestJob(ctx, job any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateIngestJob", reflect.TypeOf((*MockUploadData)(nil).CreateIngestJob), ctx, job)
}

// CreateIngestTask mocks base method.
func (m *MockUploadData) CreateIngestTask(ctx context.Context, task model.IngestTask) (model.IngestTask, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateIngestTask", ctx, task)
	ret0, _ := ret[0].(model.IngestTask)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateIngestTask indicates an expected call of CreateIngestTask.
func (mr *MockUploadDataMockRecorder) CreateIngestTask(ctx, task any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateIngestTask", reflect.TypeOf((*MockUploadData)(nil).CreateIngestTask), ctx, task)
}

// DeleteAllIngestJobs mocks base method.
func (m *MockUploadData) DeleteAllIngestJobs(ctx context.Context) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteAllIngestJobs", ctx)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteAllIngestJobs indicates an expected call of DeleteAllIngestJobs.
func (mr *MockUploadDataMockRecorder) DeleteAllIngestJobs(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteAllIngestJobs", reflect.TypeOf((*MockUploadData)(nil).DeleteAllIngestJobs), ctx)
}

// DeleteAllIngestTasks mocks base method.
func (m *MockUploadData) DeleteAllIngestTasks(ctx context.Context) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteAllIngestTasks", ctx)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteAllIngestTasks indicates an expected call of DeleteAllIngestTasks.
func (mr *MockUploadDataMockRecorder) DeleteAllIngestTasks(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteAllIngestTasks", reflect.TypeOf((*MockUploadData)(nil).DeleteAllIngestTasks), ctx)
}

// GetAllIngestJobs mocks base method.
func (m *MockUploadData) GetAllIngestJobs(ctx context.Context, skip, limit int, order string, filter model.SQLFilter) ([]model.IngestJob, int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAllIngestJobs", ctx, skip, limit, order, filter)
	ret0, _ := ret[0].([]model.IngestJob)
	ret1, _ := ret[1].(int)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetAllIngestJobs indicates an expected call of GetAllIngestJobs.
func (mr *MockUploadDataMockRecorder) GetAllIngestJobs(ctx, skip, limit, order, filter any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAllIngestJobs", reflect.TypeOf((*MockUploadData)(nil).GetAllIngestJobs), ctx, skip, limit, order, filter)
}

// GetIngestJob mocks base method.
func (m *MockUploadData) GetIngestJob(ctx context.Context, id int64) (model.IngestJob, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetIngestJob", ctx, id)
	ret0, _ := ret[0].(model.IngestJob)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetIngestJob indicates an expected call of GetIngestJob.
func (mr *MockUploadDataMockRecorder) GetIngestJob(ctx, id any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetIngestJob", reflect.TypeOf((*MockUploadData)(nil).GetIngestJob), ctx, id)
}

// GetIngestJobsWithStatus mocks base method.
func (m *MockUploadData) GetIngestJobsWithStatus(ctx context.Context, status model.JobStatus) ([]model.IngestJob, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetIngestJobsWithStatus", ctx, status)
	ret0, _ := ret[0].([]model.IngestJob)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetIngestJobsWithStatus indicates an expected call of GetIngestJobsWithStatus.
func (mr *MockUploadDataMockRecorder) GetIngestJobsWithStatus(ctx, status any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetIngestJobsWithStatus", reflect.TypeOf((*MockUploadData)(nil).GetIngestJobsWithStatus), ctx, status)
}

// UpdateIngestJob mocks base method.
func (m *MockUploadData) UpdateIngestJob(ctx context.Context, job model.IngestJob) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateIngestJob", ctx, job)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateIngestJob indicates an expected call of UpdateIngestJob.
func (mr *MockUploadDataMockRecorder) UpdateIngestJob(ctx, job any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateIngestJob", reflect.TypeOf((*MockUploadData)(nil).UpdateIngestJob), ctx, job)
}
