import { DateTime } from "luxon";
import { IUtils } from "@date-io/core/IUtils";
export default class LuxonUtils implements IUtils<DateTime> {
    locale: string;
    yearFormat: string;
    yearMonthFormat: string;
    dateTime12hFormat: string;
    dateTime24hFormat: string;
    time12hFormat: string;
    time24hFormat: string;
    dateFormat: string;
    constructor({ locale }?: {
        locale?: string;
    });
    date(value?: any): DateTime;
    parse(value: string, formatString: string): DateTime;
    addDays(date: DateTime, count: number): DateTime;
    isValid(value: any): boolean;
    isEqual(value: any, comparing: any): boolean;
    isSameDay(date: DateTime, comparing: DateTime): boolean;
    isSameMonth(date: DateTime, comparing: DateTime): boolean;
    isSameYear(date: DateTime, comparing: DateTime): boolean;
    isSameHour(date: DateTime, comparing: DateTime): boolean;
    isAfter(value: DateTime, comparing: DateTime): boolean;
    isBefore(value: DateTime, comparing: DateTime): boolean;
    isBeforeDay(value: DateTime, comparing: DateTime): boolean;
    isAfterDay(value: DateTime, comparing: DateTime): boolean;
    isBeforeYear(value: DateTime, comparing: DateTime): boolean;
    isAfterYear(value: DateTime, comparing: DateTime): boolean;
    getDiff(value: DateTime, comparing: DateTime | string): number;
    startOfDay(value: DateTime): DateTime;
    endOfDay(value: DateTime): DateTime;
    format(date: DateTime, format: string): string;
    formatNumber(numberToFormat: string): string;
    getHours(value: DateTime): number;
    setHours(value: DateTime, count: number): DateTime;
    getMinutes(value: DateTime): number;
    setMinutes(value: DateTime, count: number): DateTime;
    getSeconds(value: DateTime): number;
    setSeconds(value: DateTime, count: number): DateTime;
    getMonth(value: DateTime): number;
    setMonth(value: DateTime, count: number): DateTime;
    getYear(value: DateTime): number;
    setYear(value: DateTime, year: number): DateTime;
    mergeDateAndTime(date: DateTime, time: DateTime): DateTime;
    startOfMonth(value: DateTime): DateTime;
    endOfMonth(value: DateTime): DateTime;
    getNextMonth(value: DateTime): DateTime;
    getPreviousMonth(value: DateTime): DateTime;
    getMonthArray(date: DateTime): DateTime[];
    getWeekdays(): string[];
    getWeekArray(date: DateTime): DateTime[][];
    getYearRange(start: DateTime, end: DateTime): DateTime[];
    getMeridiemText(ampm: "am" | "pm"): string;
    getCalendarHeaderText(date: DateTime): string;
    getDatePickerHeaderText(date: DateTime): string;
    getDateTimePickerHeaderText(date: DateTime): string;
    getMonthText(date: DateTime): string;
    getDayText(date: DateTime): string;
    getHourText(date: DateTime, ampm: boolean): string;
    getMinuteText(date: DateTime): string;
    getSecondText(date: DateTime): string;
    getYearText(date: DateTime): string;
    isNull(date: DateTime | null): boolean;
}
