/*======================================================================================================================
 * utils/TypeInfo.cpp is part of Brewtarget, and is copyright the following authors 2023-2025:
 *   • Matt Young <mfsy@yahoo.com>
 *
 * Brewtarget is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Brewtarget is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 =====================================================================================================================*/
#include "utils/TypeInfo.h"

namespace PropertyNames::None {
   BtStringConst const none{"none"};
}

bool TypeInfo::isEnum() const {
   if (this->classification == TypeInfo::Classification::RequiredEnum ||
       this->classification == TypeInfo::Classification::OptionalEnum) {
      return true;
   }
   return false;
}

bool TypeInfo::isOptional() const {
   if (this->classification == TypeInfo::Classification::OptionalEnum ||
       this->classification == TypeInfo::Classification::OptionalOther) {
      return true;
   }
   return false;
}
