// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudwatchlogs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of the delivery destinations that have been created in the
// account.
func (c *Client) DescribeDeliveryDestinations(ctx context.Context, params *DescribeDeliveryDestinationsInput, optFns ...func(*Options)) (*DescribeDeliveryDestinationsOutput, error) {
	if params == nil {
		params = &DescribeDeliveryDestinationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeDeliveryDestinations", params, optFns, c.addOperationDescribeDeliveryDestinationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeDeliveryDestinationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeDeliveryDestinationsInput struct {

	// Optionally specify the maximum number of delivery destinations to return in the
	// response.
	Limit *int32

	// The token for the next set of items to return. The token expires after 24 hours.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeDeliveryDestinationsOutput struct {

	// An array of structures. Each structure contains information about one delivery
	// destination in the account.
	DeliveryDestinations []types.DeliveryDestination

	// The token for the next set of items to return. The token expires after 24 hours.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeDeliveryDestinationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeDeliveryDestinations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeDeliveryDestinations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeDeliveryDestinations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeDeliveryDestinations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// DescribeDeliveryDestinationsPaginatorOptions is the paginator options for
// DescribeDeliveryDestinations
type DescribeDeliveryDestinationsPaginatorOptions struct {
	// Optionally specify the maximum number of delivery destinations to return in the
	// response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeDeliveryDestinationsPaginator is a paginator for
// DescribeDeliveryDestinations
type DescribeDeliveryDestinationsPaginator struct {
	options   DescribeDeliveryDestinationsPaginatorOptions
	client    DescribeDeliveryDestinationsAPIClient
	params    *DescribeDeliveryDestinationsInput
	nextToken *string
	firstPage bool
}

// NewDescribeDeliveryDestinationsPaginator returns a new
// DescribeDeliveryDestinationsPaginator
func NewDescribeDeliveryDestinationsPaginator(client DescribeDeliveryDestinationsAPIClient, params *DescribeDeliveryDestinationsInput, optFns ...func(*DescribeDeliveryDestinationsPaginatorOptions)) *DescribeDeliveryDestinationsPaginator {
	if params == nil {
		params = &DescribeDeliveryDestinationsInput{}
	}

	options := DescribeDeliveryDestinationsPaginatorOptions{}
	if params.Limit != nil {
		options.Limit = *params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeDeliveryDestinationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeDeliveryDestinationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeDeliveryDestinations page.
func (p *DescribeDeliveryDestinationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeDeliveryDestinationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.Limit = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeDeliveryDestinations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeDeliveryDestinationsAPIClient is a client that implements the
// DescribeDeliveryDestinations operation.
type DescribeDeliveryDestinationsAPIClient interface {
	DescribeDeliveryDestinations(context.Context, *DescribeDeliveryDestinationsInput, ...func(*Options)) (*DescribeDeliveryDestinationsOutput, error)
}

var _ DescribeDeliveryDestinationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeDeliveryDestinations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeDeliveryDestinations",
	}
}
