# Contributing to Cilium CLI

`cilium-cli` is an open source project licensed under [Apache-2.0](LICENSE). Everybody is welcome to contribute. Contributors are required to follow the [CNCF Code of Conduct](https://github.com/cncf/foundation/blob/main/code-of-conduct.md).

## Contribution workflow

Cilium CLI uses GitHub for collaborative development. This repository only hosts
release artifacts for Cilium CLI. The actual code for Cilium CLI is in
[Cilium GitHub repository] under [`cilium-cli/` directory]. Please use GitHub
issues to discuss proposals and use pull requests to suggest changes in
[Cilium GitHub repository]. For more information see the [Development Guide].

## Contributor Ladder  

The Cilium project has a well-defined [contributor ladder](https://github.com/cilium/community/blob/main/CONTRIBUTOR-LADDER.md) to help community members grow both responsibilities and privileges in the project ecosystem. This ladder outlines the path from an occasional contributor to a committer, detailing expectations at each stage. Most contributors start at the community level in a sub-project and progress as they become more engaged in the project ecosystem. We encourage you to take an active role, and the community is here to support you on this journey.  

Becoming a [Cilium organization member](https://github.com/cilium/community/blob/main/CONTRIBUTOR-LADDER.md#organization-member) grants you additional privileges across the project ecosystem, such as the ability to leave reviews on a PR or trigger CI runs. If you're contributing regularly to `cilium-cli`, consider joining the [cli team](https://github.com/cilium/community/blob/main/ladder/teams/cli.yaml) to help review code and accelerate development. Your contributions play a vital role in improving the project, and we'd love to have you more involved!

## Community

Join the Cilium community for discussions:

Slack: [Cilium Slack](https://slack.cilium.io/)
GitHub Discussions: [cilium/cilium discussions](https://github.com/cilium/cilium/discussions)

We appreciate your contributions to `cilium-cli` and look forward to your involvement!

[`cilium-cli/` directory]: https://github.com/cilium/cilium/tree/main/cilium-cli
[Cilium GitHub repository]: https://github.com/cilium/cilium
[Development Guide]: https://docs.cilium.io/en/latest/contributing/development/
