/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableColumn;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableForeignKey;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableType;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableUniqueKey;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTypedObject;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectWithScript;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class SQLServerDataType
implements DBSDataType,
SQLServerObject,
DBPQualifiedObject,
DBPScriptObject,
DBSObjectWithScript,
DBSEntity {
    private static final Log log = Log.getLog(SQLServerDataType.class);
    private final DBSObject owner;
    private final String name;
    private final int valueType;
    private final DBPDataKind dataKind;
    private final int systemTypeId;
    private final int userTypeId;
    private long schemaId;
    private int maxLength;
    private int scale;
    private int precision;
    private boolean nullable;
    private boolean userType;
    private boolean assemblyType;
    private String collationName;
    private int tableTypeId = 0;
    private int tableTypeSchemaId = 0;
    private boolean persisted;

    public SQLServerDataType(DBSObject owner, ResultSet dbResult) {
        this.owner = owner;
        String nameValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
        this.name = DBUtils.getUnQuotedIdentifier((DBPDataSource)owner.getDataSource(), (String)CommonUtils.notEmpty((String)nameValue));
        this.systemTypeId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"system_type_id");
        this.userTypeId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"user_type_id");
        this.schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"schema_id");
        this.maxLength = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"max_length");
        this.scale = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"scale");
        this.precision = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"precision");
        this.nullable = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_nullable") != 0;
        this.userType = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_user_defined") != 0;
        this.assemblyType = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_assembly_type") != 0;
        boolean isTableType = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_table_type") != 0;
        this.collationName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"collation_name");
        if (isTableType) {
            this.tableTypeId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"type_table_object_id");
            this.tableTypeSchemaId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"type_table_schema_id");
        }
        if (this.userType) {
            if (this.systemTypeId == 243) {
                this.dataKind = DBPDataKind.OBJECT;
                this.valueType = 1111;
            } else {
                SQLServerDataType systemDataType = this.getSystemDataType();
                this.dataKind = systemDataType == null ? DBPDataKind.UNKNOWN : systemDataType.getDataKind();
                this.valueType = systemDataType == null ? 1111 : systemDataType.getTypeID();
            }
        } else {
            this.dataKind = SQLServerDataType.getDataKindByName(this.name);
            this.valueType = SQLServerDataType.getDataTypeIDByName(this.name);
        }
        this.persisted = true;
    }

    public SQLServerDataType(DBSObject owner, String name, int systemId, DBPDataKind dataKind, int valueType) {
        this.owner = owner;
        this.name = name;
        this.systemTypeId = this.userTypeId = systemId;
        this.dataKind = dataKind;
        this.valueType = valueType;
    }

    @Override
    @NotNull
    public SQLServerDataSource getDataSource() {
        return (SQLServerDataSource)this.owner.getDataSource();
    }

    @Property(order=80)
    public long getObjectId() {
        return this.userTypeId;
    }

    public boolean isUserType() {
        return this.userType;
    }

    long getSchemaId() {
        return this.schemaId;
    }

    @Property(order=5)
    @Nullable
    public SQLServerSchema getSchema(DBRProgressMonitor monitor) throws DBException {
        SQLServerSchema sQLServerSchema;
        DBSObject dBSObject = this.owner;
        if (dBSObject instanceof SQLServerDatabase) {
            SQLServerDatabase db = (SQLServerDatabase)dBSObject;
            sQLServerSchema = db.getSchema(monitor, this.schemaId);
        } else {
            sQLServerSchema = null;
        }
        return sQLServerSchema;
    }

    @Nullable
    public SQLServerSchema getSysSchema(DBRProgressMonitor monitor) throws DBException {
        DBSObject dBSObject = this.owner;
        if (dBSObject instanceof SQLServerDatabase) {
            SQLServerDatabase db = (SQLServerDatabase)dBSObject;
            return db.getSysSchema(monitor);
        }
        DBSObject dBSObject2 = this.owner;
        if (dBSObject2 instanceof SQLServerDataSource) {
            SQLServerDataSource ds = (SQLServerDataSource)dBSObject2;
            return ds.getDefaultDatabase(monitor) != null ? ds.getDefaultDatabase(monitor).getSysSchema(monitor) : null;
        }
        return null;
    }

    public SQLServerDataType getSystemDataType() {
        if (this.userType) {
            return this.getDataSource().getSystemDataType(this.systemTypeId);
        }
        return this;
    }

    public SQLServerDatabase getContainer() {
        if (this.owner instanceof SQLServerDatabase) {
            return (SQLServerDatabase)this.owner;
        }
        return null;
    }

    @Override
    public SQLServerDatabase getDatabase() {
        if (this.owner instanceof SQLServerDatabase) {
            return (SQLServerDatabase)this.owner;
        }
        return ((SQLServerDataSource)this.owner).getDefaultDatabase((DBRProgressMonitor)new VoidProgressMonitor());
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBCException {
        StringBuilder sql = new StringBuilder();
        sql.append("-- DROP TYPE ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(";\n\n");
        if (this.tableTypeId == 0) {
            sql.append("CREATE TYPE ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append("\n").append("FROM ");
            SQLServerDataType systemDataType = this.getSystemDataType();
            String typeName = systemDataType.getName();
            sql.append(typeName.toUpperCase(Locale.ENGLISH));
            SQLServerTypedObject serverTypedObjects = new SQLServerTypedObject(typeName, SQLServerDataType.getDataTypeIDByName(typeName), this.dataKind, this.scale, this.precision, this.maxLength);
            String modifiers = SQLUtils.getColumnTypeModifiers((DBPDataSource)this.getDataSource(), (DBSTypedObject)serverTypedObjects, (String)typeName, (DBPDataKind)this.dataKind);
            if (modifiers != null) {
                sql.append(modifiers);
            }
            if (!this.nullable) {
                sql.append(" NOT NULL;");
            }
        } else {
            try {
                SQLServerTableType tableType = this.getTableType(monitor);
                if (tableType == null) {
                    return "-- Error generating table DDL\n-- Table type " + this.tableTypeId + " not found in system catalog (" + this.tableTypeSchemaId + ")";
                }
                options.put("ddl.useSpecialName", this.name);
                String objectDefinitionText = tableType.getObjectDefinitionText(monitor, options);
                sql.append(objectDefinitionText);
            }
            catch (DBException e) {
                log.debug((Object)"Cannot load table type definition", (Throwable)e);
            }
        }
        return sql.toString();
    }

    @NotNull
    public String getTypeName() {
        return this.getFullyQualifiedName(DBPEvaluationContext.DDL);
    }

    @Property(order=70)
    @NotNull
    public String getFullTypeName() {
        return DBUtils.getFullTypeName((DBSTypedObject)this);
    }

    public int getTypeID() {
        return this.valueType;
    }

    @NotNull
    public DBPDataKind getDataKind() {
        return this.dataKind;
    }

    @Property(order=20)
    @Nullable
    public Integer getScale() {
        return this.scale == 0 ? null : Integer.valueOf(this.scale);
    }

    @Property(order=21)
    @Nullable
    public Integer getPrecision() {
        return this.precision == 0 ? null : Integer.valueOf(this.precision);
    }

    @Property(order=22)
    public long getMaxLength() {
        return this.maxLength;
    }

    public long getTypeModifiers() {
        return 0L;
    }

    public int getMinScale() {
        return this.scale;
    }

    public int getMaxScale() {
        return this.scale;
    }

    @Property(order=23)
    public boolean isNullable() {
        return this.nullable;
    }

    @Property(order=24)
    public boolean isAssemblyType() {
        return this.assemblyType;
    }

    @Property(order=25)
    public boolean isTableType() {
        return this.tableTypeId != 0;
    }

    @Property(order=26)
    public String getCollationName() {
        return this.collationName;
    }

    public int getTableTypeId() {
        return this.tableTypeId;
    }

    @NotNull
    public DBCLogicalOperator[] getSupportedOperators(DBSTypedObject attribute) {
        return DBUtils.getDefaultOperators((DBSTypedObject)this);
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.owner;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public Object geTypeExtension() {
        return this.userTypeId;
    }

    public SQLServerDataType getComponentType(@NotNull DBRProgressMonitor monitor) {
        return null;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return this.owner instanceof SQLServerSchema ? DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{((SQLServerSchema)this.owner).getDatabase(), this.owner, this}) : this.name;
    }

    public String toString() {
        return this.getFullyQualifiedName(DBPEvaluationContext.UI);
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public static DBPDataKind getDataKindByName(String systemTypeName) {
        switch (systemTypeName) {
            case "sysname": 
            case "nvarchar": 
            case "char": 
            case "text": 
            case "nchar": 
            case "ntext": 
            case "varchar": {
                return DBPDataKind.STRING;
            }
            case "numeric": 
            case "bigint": 
            case "tinyint": 
            case "smallint": 
            case "bit": 
            case "int": 
            case "real": 
            case "float": 
            case "money": 
            case "smallmoney": 
            case "decimal": {
                return DBPDataKind.NUMERIC;
            }
            case "smalldatetime": 
            case "datetime2": 
            case "date": 
            case "time": 
            case "datetime": {
                return DBPDataKind.DATETIME;
            }
            case "datetimeoffset": {
                return DBPDataKind.DATETIME;
            }
            case "binary": 
            case "varbinary": 
            case "timestamp": {
                return DBPDataKind.BINARY;
            }
            case "image": {
                return DBPDataKind.CONTENT;
            }
            case "uniqueidentifier": {
                return DBPDataKind.STRING;
            }
            case "hierarchyid": 
            case "geography": 
            case "geometry": {
                return DBPDataKind.BINARY;
            }
            case "sql_variant": {
                return DBPDataKind.OBJECT;
            }
            case "xml": {
                return DBPDataKind.CONTENT;
            }
        }
        return DBPDataKind.OBJECT;
    }

    public static int getDataTypeIDByName(String systemTypeName) {
        switch (systemTypeName) {
            case "char": {
                return 1;
            }
            case "nchar": {
                return -15;
            }
            case "nvarchar": 
            case "ntext": {
                return -9;
            }
            case "text": 
            case "varchar": {
                return 12;
            }
            case "sysname": {
                return 12;
            }
            case "tinyint": {
                return -6;
            }
            case "bigint": {
                return -5;
            }
            case "bit": {
                return -7;
            }
            case "int": {
                return 4;
            }
            case "numeric": {
                return 2;
            }
            case "real": {
                return 7;
            }
            case "smallint": {
                return 5;
            }
            case "decimal": {
                return 3;
            }
            case "float": {
                return 6;
            }
            case "date": {
                return 91;
            }
            case "datetime2": 
            case "datetime": {
                return 93;
            }
            case "smalldatetime": {
                return 93;
            }
            case "time": {
                return 92;
            }
            case "timestamp": {
                return 93;
            }
            case "datetimeoffset": {
                return 12;
            }
            case "binary": {
                return -2;
            }
            case "varbinary": 
            case "image": {
                return -3;
            }
            case "uniqueidentifier": {
                return -3;
            }
            case "hierarchyid": 
            case "geography": 
            case "geometry": {
                return -2;
            }
            case "sql_variant": 
            case "money": 
            case "smallmoney": {
                return 1111;
            }
            case "xml": {
                return 2009;
            }
        }
        return 1111;
    }

    public void setObjectDefinitionText(String source) {
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TYPE;
    }

    @Nullable
    public List<SQLServerTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        SQLServerTableType type = this.getTableType(monitor);
        if (type != null) {
            return type.getAttributes(monitor);
        }
        return null;
    }

    @Nullable
    public SQLServerTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        SQLServerTableType type = this.getTableType(monitor);
        if (type != null) {
            return type.getAttribute(monitor, attributeName);
        }
        return null;
    }

    @Nullable
    public Collection<SQLServerTableUniqueKey> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        SQLServerTableType type = this.getTableType(monitor);
        if (type != null) {
            return type.getConstraints(monitor);
        }
        return null;
    }

    private SQLServerTableType getTableType(@NotNull DBRProgressMonitor monitor) throws DBException {
        SQLServerSchema sysSchema;
        if (!this.isTableType()) {
            return null;
        }
        DBSObject dBSObject = this.owner;
        if (dBSObject instanceof SQLServerDatabase) {
            SQLServerDatabase db = (SQLServerDatabase)dBSObject;
            v0 = db.getSchema(monitor, this.tableTypeSchemaId);
        } else {
            v0 = sysSchema = null;
        }
        if (sysSchema != null) {
            SQLServerTableType tableType = sysSchema.getTableType(monitor, this.tableTypeId);
            if (tableType != null) {
                return tableType;
            }
            log.debug((Object)("Table type " + this.tableTypeId + " not found in schema " + sysSchema.getName()));
        } else {
            log.debug((Object)("Table type " + this.tableTypeId + " schema " + this.tableTypeSchemaId + " not found in database"));
        }
        return null;
    }

    public Collection<SQLServerTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<SQLServerTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }
}

