/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.hana.model.HANANotPartitionedTable;
import org.jkiss.dbeaver.ext.hana.model.HANAPartition;
import org.jkiss.dbeaver.ext.hana.model.HANASchema;
import org.jkiss.dbeaver.ext.hana.model.HANATableColumn;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ByteNumberFormat;

public class HANATable
extends GenericTable
implements DBPObjectStatistics {
    private final PartitionCache partitionCache = new PartitionCache();
    private long tableSize = -1L;

    public HANATable(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
    }

    @Nullable
    public List<? extends HANATableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.getAttributes(monitor);
    }

    public HANATableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (HANATableColumn)super.getAttribute(monitor, attributeName);
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1, visibleIf=HANANotPartitionedTable.class)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, order=2, visibleIf=HANANotPartitionedTable.class)
    public String getTableType() {
        return super.getTableType();
    }

    @Property(viewable=true, optional=true, labelProvider=GenericSchema.SchemaNameTermProvider.class, order=4, visibleIf=HANANotPartitionedTable.class)
    @NotNull
    public GenericSchema getSchema() {
        return super.getSchema();
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=13, visibleIf=HANANotPartitionedTable.class)
    public String getDescription() {
        return super.getDescription();
    }

    public boolean hasStatistics() {
        return this.tableSize != -1L;
    }

    public long getStatObjectSize() {
        return this.tableSize;
    }

    void fetchStatistics(JDBCResultSet dbResult) throws SQLException {
        this.tableSize = dbResult.getLong("DISK_SIZE");
    }

    @Property(category="Statistics", formatter=ByteNumberFormat.class)
    public Long getTableSize(DBRProgressMonitor monitor) throws DBException {
        if (this.tableSize == -1L) {
            ((HANASchema)this.getSchema()).collectObjectStatistics(monitor, false, false);
        }
        return this.tableSize;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.tableSize != -1L) {
            this.tableSize = -1L;
            ((HANASchema)this.getSchema()).resetStatistics();
        }
        return super.refreshObject(monitor);
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }

    @NotNull
    public Collection<HANAPartition> getPartitions(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.partitionCache.getAllObjects(monitor, (DBSObject)this);
    }

    private static class PartitionCache
    extends JDBCObjectCache<HANATable, HANAPartition> {
        private PartitionCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull HANATable table) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT tp.*, \nMEMORY_SIZE_IN_TOTAL, RECORD_COUNT, MEMORY_SIZE_IN_MAIN, MEMORY_SIZE_IN_DELTA, CREATE_TIME, LAST_MERGE_TIME, LAST_REPLAY_LOG_TIME, LOADED\nFROM M_CS_TABLES mcs JOIN TABLE_PARTITIONS tp ON mcs.SCHEMA_NAME=tp.SCHEMA_NAME AND mcs.TABLE_NAME=tp.TABLE_NAME AND mcs.PART_ID=tp.PART_ID\nWHERE tp.TABLE_NAME = ? AND tp.SCHEMA_NAME = ? ORDER BY tp.PART_ID");
            dbStat.setString(1, table.getName());
            dbStat.setString(2, ((GenericStructContainer)table.getContainer()).getName());
            return dbStat;
        }

        protected HANAPartition fetchObject(@NotNull JDBCSession session, @NotNull HANATable table, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            int partition_id = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PART_ID");
            if (dbResult == null) {
                return null;
            }
            return new HANAPartition(table, partition_id, dbResult);
        }
    }
}

