/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics;

import java.util.function.Function;
import java.util.function.Supplier;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionAnalyzer;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionContext;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItem;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemKind;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionProposal;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionProposalContext;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryWordEntry;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLEditorQueryCompletionProposal;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLEditorQueryCompletionProposalContext;

public class SQLEditorQueryCompletionAnalyzer
extends SQLQueryCompletionAnalyzer {
    private SQLEditorQueryCompletionProposalContext proposalContext;

    public SQLEditorQueryCompletionAnalyzer(@NotNull Function<DBRProgressMonitor, SQLQueryCompletionContext> completionContextSupplier, @NotNull SQLCompletionRequest request, @NotNull Supplier<Integer> currentCompletionOffsetSupplier) {
        super(completionContextSupplier, request, currentCompletionOffsetSupplier);
    }

    @NotNull
    protected SQLQueryCompletionProposalContext createProposalContext(@NotNull SQLQueryCompletionContext completionContext) {
        this.proposalContext = new SQLEditorQueryCompletionProposalContext(this.request, completionContext.getRequestOffset());
        return this.proposalContext;
    }

    @NotNull
    protected SQLQueryCompletionProposal createProposal(@NotNull SQLQueryCompletionItemKind itemKind, @Nullable DBSObject object, @Nullable DBPImage image, @Nullable String displayString, @Nullable String decorationString, @NotNull String description, @NotNull String replacementString, int replacementOffset, int replacementLength, @Nullable SQLQueryWordEntry filterString, int proposalScore) {
        return new SQLEditorQueryCompletionProposal(this.proposalContext, itemKind, object, image, displayString, decorationString, description, replacementString, replacementOffset, replacementLength, filterString, proposalScore);
    }

    @NotNull
    protected DBPImage prepareProposalImage(@NotNull SQLQueryCompletionItem item) {
        return switch (item.getKind()) {
            case SQLQueryCompletionItemKind.UNKNOWN, SQLQueryCompletionItemKind.CATALOG, SQLQueryCompletionItemKind.SCHEMA -> DBValueFormatting.getObjectImage((DBPObject)item.getObject());
            case SQLQueryCompletionItemKind.RESERVED -> UIIcon.SQL_TEXT;
            case SQLQueryCompletionItemKind.SUBQUERY_ALIAS -> DBIcon.TREE_TABLE_ALIAS;
            case SQLQueryCompletionItemKind.DERIVED_COLUMN_NAME -> DBIcon.TREE_DERIVED_COLUMN;
            case SQLQueryCompletionItemKind.NEW_TABLE_NAME, SQLQueryCompletionItemKind.USED_TABLE_NAME -> {
                DBSObject object = item.getObject();
                if (object == null) {
                    yield DBIcon.TREE_TABLE;
                }
                yield DBValueFormatting.getObjectImage((DBPObject)object);
            }
            case SQLQueryCompletionItemKind.TABLE_COLUMN_NAME -> DBIcon.TREE_COLUMN;
            case SQLQueryCompletionItemKind.COMPOSITE_FIELD_NAME -> DBIcon.TREE_DATA_TYPE;
            case SQLQueryCompletionItemKind.JOIN_CONDITION -> DBIcon.TREE_CONSTRAINT;
            case SQLQueryCompletionItemKind.PROCEDURE -> {
                if (item.getObject() == null) {
                    yield DBIcon.TREE_FUNCTION;
                }
                yield DBValueFormatting.getObjectImage((DBPObject)item.getObject());
            }
            default -> throw new IllegalStateException("Unexpected completion item kind " + String.valueOf(item.getKind()));
        };
    }
}

