/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.altibase.AltibaseConstants;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataSource;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseMetaModel;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSynonym;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class AltibaseSynonym
extends GenericSynonym
implements DBPScriptObject {
    private static final Log log = Log.getLog(AltibaseSynonym.class);
    protected boolean isPublicSynonym;
    protected String refObjectSchema;
    protected String refObjectName;
    protected String ddl;
    protected DBSObject refObj = null;

    protected AltibaseSynonym(GenericStructContainer container, int ownerId, String name, String description, String refObjectSchema, String refObjectName) {
        super(container, name, description);
        this.isPublicSynonym = ownerId < 0;
        this.refObjectSchema = refObjectSchema;
        this.refObjectName = refObjectName;
    }

    @Property(viewable=true, linkPossible=true, order=4)
    public DBSObject getObject(DBRProgressMonitor monitor) throws DBException {
        if (this.refObj == null) {
            this.refObj = this.getTargetObject(monitor);
        }
        return this.refObj;
    }

    public DBSObject getTargetObject(DBRProgressMonitor monitor) {
        if (this.refObj == null) {
            try {
                this.refObj = ((AltibaseDataSource)this.getDataSource()).findSynonymTargetObject(monitor, this.refObjectSchema, this.refObjectName);
            }
            catch (DBException e) {
                log.warn((Object)("Failed to get a synonym's target object: " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + " for " + this.refObjectSchema + "." + this.refObjectName + ": " + e.getMessage()));
            }
        }
        return this.refObj;
    }

    public String getBuiltDdlLocaly(DBRProgressMonitor monitor) {
        DBSObject refObject = this.getTargetObject(monitor);
        String refObjFullName = "";
        if (refObject != null) {
            refObjFullName = refObject instanceof AltibaseSynonym && ((AltibaseSynonym)refObject).isPublicSynonym() ? DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{refObject}) : DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{refObject.getParentObject(), refObject});
        }
        return "CREATE " + this.getSynonymBody() + " FOR " + refObjFullName;
    }

    public String getSynonymBody() {
        String name;
        StringBuilder ddl = new StringBuilder();
        if (this.isPublicSynonym) {
            name = this.getName();
            ddl.append("PUBLIC ");
        } else {
            name = this.getFullyQualifiedName(DBPEvaluationContext.DDL);
        }
        ddl.append("SYNONYM ").append(name);
        return ddl.toString();
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (CommonUtils.getOption(options, (String)"refresh")) {
            this.ddl = null;
        }
        if (CommonUtils.isEmpty((String)this.ddl)) {
            this.ddl = ((AltibaseMetaModel)this.getDataSource().getMetaModel()).getSynonymDDL(monitor, this, options);
        }
        if (CommonUtils.isEmpty((String)this.ddl)) {
            this.ddl = AltibaseConstants.NO_DBMS_METADATA + this.getBuiltDdlLocaly(monitor);
        }
        return CommonUtils.isEmpty((String)this.ddl) ? "" : this.ddl + ";";
    }

    public boolean isPublicSynonym() {
        return this.isPublicSynonym;
    }

    public void setPublicSynonym() {
        this.isPublicSynonym = true;
    }
}

