/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardActivator;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardConfiguration;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DashboardConfigurationList {
    private static final Log log = Log.getLog(DashboardConfigurationList.class);
    public static final String DEFAULT_DASHBOARD_ID = "default";
    public static final String DEFAULT_DASHBOARD_NAME = "Default";
    @NotNull
    private final DBPProject project;
    @Nullable
    private IFile dashboardFile;
    @Nullable
    private final DBPDataSourceContainer dataSourceContainer;
    private final Map<String, DashboardConfiguration> dashboards = new LinkedHashMap<String, DashboardConfiguration>();

    public DashboardConfigurationList(@NotNull DBPProject project, @NotNull IFile dashboardFile) {
        this.project = project;
        this.dashboardFile = dashboardFile;
        this.dataSourceContainer = null;
        this.loadFromFile(dashboardFile);
    }

    public DashboardConfigurationList(DBPDataSourceContainer dataSourceContainer) {
        this.project = dataSourceContainer.getProject();
        this.dataSourceContainer = dataSourceContainer;
        this.loadFromDataSource();
    }

    @NotNull
    public DBPProject getProject() {
        return this.project;
    }

    @Nullable
    public IFile getDashboardFile() {
        return this.dashboardFile;
    }

    @Nullable
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    private void loadFromDataSource() {
        Document dbDocument = null;
        try {
            String dbSerialized = this.dataSourceContainer.getExtension("dashboards");
            if (!CommonUtils.isEmpty((String)dbSerialized)) {
                dbDocument = XMLUtils.parseDocument((Reader)new StringReader(dbSerialized));
            } else {
                Path configFile = this.getConfigFile(false);
                if (Files.exists(configFile, new LinkOption[0])) {
                    dbDocument = XMLUtils.parseDocument((File)configFile.toFile());
                }
            }
        }
        catch (XMLException e) {
            log.error((Object)"Error parsing dashboards", (Throwable)e);
        }
        this.loadConfiguration(dbDocument);
    }

    private void loadFromFile(IFile file) {
        Document dbDocument = null;
        if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream is = file.getContents();){
                    dbDocument = XMLUtils.parseDocument((InputStream)is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error parsing dashboards", (Throwable)e);
            }
            this.loadConfiguration(dbDocument);
        }
    }

    private void loadConfiguration(Document dbDocument) {
        block6: {
            if (dbDocument != null) {
                try {
                    Element rootElement = dbDocument.getDocumentElement();
                    if (rootElement.getTagName().equals("dashboardList")) {
                        for (Element dashboardElement : XMLUtils.getChildElementList((Element)rootElement, (String)"dashboards")) {
                            DashboardConfiguration configuration = new DashboardConfiguration(this.project, this.dataSourceContainer, null);
                            configuration.loadConfiguration(dashboardElement);
                            this.dashboards.put(configuration.getDashboardId(), configuration);
                        }
                        break block6;
                    }
                    if (rootElement.getTagName().equals("dashboards")) {
                        DashboardConfiguration configuration = new DashboardConfiguration(this.project, this.dataSourceContainer, null);
                        configuration.loadConfiguration(rootElement);
                        this.dashboards.put(configuration.getDashboardId(), configuration);
                        break block6;
                    }
                    throw new DBException("Unsupported dashboards format: " + rootElement.getTagName());
                }
                catch (Exception e) {
                    log.error((Object)"Error loading dashboard view configuration", (Throwable)e);
                }
            }
        }
    }

    public void saveConfiguration() throws IOException {
        if (this.dashboardFile != null) {
            try {
                ByteArrayInputStream contents = new ByteArrayInputStream(this.saveToString().getBytes(StandardCharsets.UTF_8));
                if (!this.dashboardFile.exists()) {
                    this.dashboardFile.create((InputStream)contents, true, (IProgressMonitor)new NullProgressMonitor());
                }
                this.dashboardFile.setContents((InputStream)contents, true, false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new IOException(e.getMessage(), e);
            }
        } else if (this.dataSourceContainer != null) {
            this.saveToDataSource();
        } else {
            throw new IOException("Unsupported dashboard configuration format");
        }
    }

    private String saveToString() throws IOException {
        StringWriter buffer = new StringWriter();
        XMLBuilder xml = new XMLBuilder((Writer)buffer, GeneralUtils.UTF8_ENCODING, true);
        xml.setButify(true);
        this.serializeConfig(xml);
        xml.flush();
        return buffer.toString();
    }

    private void saveToDataSource() throws IOException {
        if (this.dataSourceContainer == null) {
            throw new IOException("Dashboard configuration is not connected with datasource");
        }
        if (this.dashboards.isEmpty()) {
            this.dataSourceContainer.setExtension("dashboards", null);
        } else {
            StringWriter buffer = new StringWriter();
            XMLBuilder xml = new XMLBuilder((Writer)buffer, GeneralUtils.UTF8_ENCODING, false);
            xml.setButify(false);
            this.serializeConfig(xml);
            xml.flush();
            this.dataSourceContainer.setExtension("dashboards", buffer.toString());
        }
        this.dataSourceContainer.persistConfiguration();
    }

    private void serializeConfig(XMLBuilder xml) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (XMLBuilder.Element ignored = xml.startElement("dashboardList");){
            for (DashboardConfiguration dashboard : this.dashboards.values()) {
                dashboard.serializeConfig(xml);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Path getConfigFile(boolean forceCreate) {
        Path pluginFolder = RuntimeUtils.getPluginStateLocation((Plugin)UIDashboardActivator.getDefault());
        Path viewConfigFolder = pluginFolder.resolve("views");
        if (!Files.exists(viewConfigFolder, new LinkOption[0]) && forceCreate) {
            try {
                Files.createDirectories(viewConfigFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error((Object)("Can't create view config folder " + String.valueOf(viewConfigFolder)), (Throwable)e);
            }
        }
        return viewConfigFolder.resolve("view-" + this.project.getName() + (String)(this.dataSourceContainer == null ? "" : "_" + this.dataSourceContainer.getId().replace("/", "_")) + ".xml");
    }

    public List<DashboardConfiguration> getDashboards() {
        return new ArrayList<DashboardConfiguration>(this.dashboards.values());
    }

    public DashboardConfiguration getDashboard(String id) {
        return this.dashboards.get(id);
    }

    public DashboardConfiguration createDashboard(String id, String name) {
        DashboardConfiguration configuration = new DashboardConfiguration(this.project, this.dataSourceContainer, id);
        configuration.setDashboardName(name);
        this.dashboards.put(id, configuration);
        return configuration;
    }

    public void deleteDashBoard(DashboardConfiguration dashboard) {
        if (this.dashboards.remove(dashboard.getDashboardId()) != null) {
            try {
                this.saveConfiguration();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void checkDefaultDashboardExistence() {
        if (this.dashboards.isEmpty()) {
            this.createDashboard(DEFAULT_DASHBOARD_ID, DEFAULT_DASHBOARD_NAME);
        }
    }
}

