/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class JsonExpression
extends ASTNodeAccessImpl
implements Expression {
    private final List<Map.Entry<Expression, String>> idents = new ArrayList<Map.Entry<Expression, String>>();
    private Expression expr;

    public JsonExpression() {
    }

    public JsonExpression(Expression expr) {
        this.expr = expr;
    }

    public JsonExpression(Expression expr, List<Map.Entry<Expression, String>> idents) {
        this.expr = expr;
        this.idents.addAll(idents);
    }

    @Override
    public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
        return expressionVisitor.visit(this, context);
    }

    public Expression getExpression() {
        return this.expr;
    }

    public void setExpression(Expression expr) {
        this.expr = expr;
    }

    public void addIdent(Expression ident, String operator) {
        this.idents.add(new AbstractMap.SimpleEntry<Expression, String>(ident, operator));
    }

    public void addAllIdents(Collection<Map.Entry<Expression, String>> idents) {
        this.idents.addAll(idents);
    }

    public List<Map.Entry<Expression, String>> getIdentList() {
        return this.idents;
    }

    public Map.Entry<Expression, String> getIdent(int index) {
        return this.idents.get(index);
    }

    @Deprecated
    public List<Expression> getIdents() {
        ArrayList<Expression> l = new ArrayList<Expression>();
        for (Map.Entry<Expression, String> ident : this.idents) {
            l.add(ident.getKey());
        }
        return l;
    }

    @Deprecated
    public List<String> getOperators() {
        ArrayList<String> l = new ArrayList<String>();
        for (Map.Entry<Expression, String> ident : this.idents) {
            l.add(ident.getValue());
        }
        return l;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.expr.toString());
        for (Map.Entry<Expression, String> ident : this.idents) {
            b.append(ident.getValue()).append(ident.getKey());
        }
        return b.toString();
    }

    public JsonExpression withExpression(Expression expr) {
        this.setExpression(expr);
        return this;
    }
}

