/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.File;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.NativeClientDescriptor;
import org.jkiss.dbeaver.registry.NativeClientDistributionDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;

public class RemoteNativeClientLocation
implements DBPNativeClientLocation {
    private final NativeClientDescriptor clientDescriptor;

    public RemoteNativeClientLocation(NativeClientDescriptor clientDescriptor) {
        this.clientDescriptor = clientDescriptor;
    }

    public String getName() {
        return this.clientDescriptor.getId();
    }

    @NotNull
    public File getPath() {
        NativeClientDistributionDescriptor distribution = this.clientDescriptor.findDistribution();
        if (distribution != null) {
            File driversHome = DriverDescriptor.getCustomDriversHome().toFile();
            return new File(driversHome, distribution.getTargetPath());
        }
        return new File(this.getName());
    }

    @NotNull
    public String getDisplayName() {
        return this.clientDescriptor.getLabel();
    }

    public boolean validateFilesPresence(@NotNull DBRProgressMonitor progressMonitor) throws DBException, InterruptedException {
        NativeClientDistributionDescriptor distribution = this.clientDescriptor.findDistribution();
        if (distribution != null) {
            return distribution.downloadFiles(progressMonitor, this);
        }
        return false;
    }

    public String toString() {
        return "Remote: " + this.clientDescriptor.getId();
    }
}

