/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScopeItem;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryMemberAccessEntry;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.utils.Pair;

public class SQLQueryLexicalScope {
    private static final Comparator<Pair<SQLQueryLexicalScopeItem, Interval>> scopeItemsComparator = (a, b) -> {
        int rc = Integer.compare(((Interval)a.getSecond()).length(), ((Interval)b.getSecond()).length());
        if (rc != 0) {
            return rc;
        }
        rc = Integer.compare(((Interval)a.getSecond()).a, ((Interval)b.getSecond()).a);
        if (rc != 0) {
            return -rc;
        }
        rc = Integer.compare(SQLQueryLexicalScope.getLexicalItemPriority((SQLQueryLexicalScopeItem)a.getFirst()), SQLQueryLexicalScope.getLexicalItemPriority((SQLQueryLexicalScopeItem)b.getFirst()));
        if (rc != 0) {
            return rc;
        }
        return 0;
    };
    @Nullable
    private SQLQuerySymbolOrigin symbolsOrigin = null;
    @NotNull
    private final List<SQLQueryLexicalScopeItem> items;
    @NotNull
    private final List<STMTreeNode> syntaxNodes;
    @Nullable
    private Interval interval = null;

    public SQLQueryLexicalScope() {
        this.items = new ArrayList<SQLQueryLexicalScopeItem>();
        this.syntaxNodes = new ArrayList<STMTreeNode>();
    }

    public SQLQueryLexicalScope(int capacity) {
        this.items = new ArrayList<SQLQueryLexicalScopeItem>(capacity);
        this.syntaxNodes = new ArrayList<STMTreeNode>(capacity);
    }

    @NotNull
    public Interval getInterval() {
        if (this.interval == null) {
            int a = Stream.concat(this.items.stream().map(x -> x.getSyntaxNode().getRealInterval().a), this.syntaxNodes.stream().map(x -> x.getRealInterval().a)).mapToInt(x -> x).min().orElse(0);
            int b = Stream.concat(this.items.stream().map(x -> {
                Interval r = x.getSyntaxNode().getRealInterval();
                return r.b + r.length();
            }), this.syntaxNodes.stream().map(x -> {
                Interval r = x.getRealInterval();
                return r.b + r.length();
            })).mapToInt(x -> x).max().orElse(Integer.MAX_VALUE);
            this.interval = Interval.of((int)a, (int)b);
        }
        return this.interval;
    }

    public void setInterval(@NotNull Interval interval) {
        this.interval = interval;
    }

    @Nullable
    public SQLQuerySymbolOrigin getSymbolsOrigin() {
        return this.symbolsOrigin;
    }

    public void setSymbolsOrigin(@NotNull SQLQuerySymbolOrigin symbolsOrigin) {
        this.symbolsOrigin = symbolsOrigin;
    }

    public void registerItem(@NotNull SQLQueryLexicalScopeItem item) {
        this.items.add(item);
    }

    public void registerSyntaxNode(@NotNull STMTreeNode syntaxNode) {
        this.syntaxNodes.add(syntaxNode);
    }

    @Nullable
    public SQLQueryLexicalScopeItem findItem(int position) {
        return this.items.stream().filter(t -> t.getSyntaxNode().getRealInterval().properlyContains(Interval.of((int)position, (int)position))).min(Comparator.comparingInt(t -> t.getSyntaxNode().getRealInterval().a)).orElse(null);
    }

    @Nullable
    public SQLQueryLexicalScopeItem findNearestItem(int position) {
        ArrayList<Object> candidates = new ArrayList<Object>(this.items.size());
        for (SQLQueryLexicalScopeItem item : this.items) {
            Interval interval = item.getSyntaxNode().getRealInterval();
            if (interval.a >= position || interval.b + 1 < position) continue;
            candidates.add(Pair.of((Object)item, (Object)interval));
        }
        if (candidates.isEmpty()) {
            return null;
        }
        candidates.sort(scopeItemsComparator);
        return (SQLQueryLexicalScopeItem)((Pair)candidates.get(0)).getFirst();
    }

    private static int getLexicalItemPriority(@NotNull SQLQueryLexicalScopeItem item) {
        if (item instanceof SQLQueryMemberAccessEntry) {
            return 0;
        }
        if (item instanceof SQLQuerySymbolEntry) {
            return 1;
        }
        if (item instanceof SQLQueryQualifiedName) {
            return 2;
        }
        return Integer.MAX_VALUE;
    }
}

