/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScope;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScopeItem;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryConnectionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryPureResultTupleContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModelContent;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsCteModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.stm.STMUtils;
import org.jkiss.dbeaver.utils.ListNode;

public class SQLQueryModel
extends SQLQueryNodeModel {
    @NotNull
    private final Set<SQLQuerySymbolEntry> symbolEntries;
    @Nullable
    private final SQLQueryModelContent queryContent;
    @NotNull
    private final List<SQLQueryLexicalScopeItem> lexicalItems;
    @Nullable
    private SQLQueryDataContext dataContext = null;

    public SQLQueryModel(@NotNull STMTreeNode syntaxNode, @Nullable SQLQueryModelContent queryContent, @NotNull Set<SQLQuerySymbolEntry> symbolEntries, @NotNull List<SQLQueryLexicalScopeItem> lexicalItems) {
        super(syntaxNode.getRealInterval(), syntaxNode, queryContent);
        this.queryContent = queryContent;
        this.symbolEntries = symbolEntries;
        this.lexicalItems = lexicalItems;
    }

    @NotNull
    public Collection<SQLQuerySymbolEntry> getAllSymbols() {
        return this.symbolEntries;
    }

    @Nullable
    public SQLQueryModelContent getQueryModel() {
        return this.queryContent;
    }

    @Override
    @Nullable
    public SQLQueryDataContext getGivenDataContext() {
        return this.dataContext;
    }

    @Override
    @Nullable
    public SQLQueryDataContext getResultDataContext() {
        return this.queryContent == null ? null : this.queryContent.getResultDataContext();
    }

    public void propagateContext(@NotNull SQLQueryDataContext dataContext, @NotNull SQLQueryConnectionContext connectionContext, @NotNull SQLQueryRecognitionContext recognitionContext) {
        int actualTailPosition;
        SQLQueryNodeModel tailNode;
        this.dataContext = dataContext;
        if (this.queryContent != null) {
            SQLQueryModelContent sQLQueryModelContent = this.queryContent;
            if (sQLQueryModelContent instanceof SQLQueryRowsCteModel) {
                SQLQueryRowsCteModel rowsSource = (SQLQueryRowsCteModel)sQLQueryModelContent;
                SQLQueryRowsSourceContext rowsContext = new SQLQueryRowsSourceContext(connectionContext);
                rowsSource.resolveObjectAndRowsReferences(rowsContext, recognitionContext);
                rowsSource.resolveValueRelations(rowsContext.makeEmptyTuple(), recognitionContext);
            } else {
                this.queryContent.applyContext(dataContext, recognitionContext);
            }
        }
        if ((tailNode = this.findNodeContaining(actualTailPosition = this.getSyntaxNode().getRealInterval().b)) != this) {
            SQLQueryLexicalScope tailNodeScope;
            SQLQuerySymbolOrigin tailOrigin = tailNode.getTailOrigin();
            if (tailOrigin == null && (tailNodeScope = tailNode.findLexicalScope(actualTailPosition)) != null) {
                tailOrigin = tailNodeScope.getSymbolsOrigin();
            }
            if (tailOrigin != null) {
                this.setTailOrigin(tailOrigin);
            }
        }
    }

    @NotNull
    public SQLQueryNodeModel findNodeContaining(int textOffset) {
        SQLQueryNodeModel node = this;
        SQLQueryNodeModel nested = node.findChildNodeContaining(textOffset);
        while (nested != null) {
            node = nested;
            nested = nested.findChildNodeContaining(textOffset);
        }
        return node;
    }

    @NotNull
    public LexicalContextResolutionResult findLexicalContext(int textOffset) {
        return this.queryContent != null && this.queryContent.getGivenDataContext() == null ? this.findLexicalContextNew(textOffset) : this.findLexicalContextOld(textOffset);
    }

    @NotNull
    private LexicalContextResolutionResult findLexicalContextNew(int textOffset) {
        SQLQuerySymbolOrigin symbolsOrigin;
        ListNode stack = ListNode.of((Object)this);
        SQLQueryModel node = this;
        SQLQueryNodeModel nested = node.findChildNodeContaining(textOffset);
        while (nested != null) {
            stack = ListNode.push((ListNode)stack, (Object)nested);
            nested = nested.findChildNodeContaining(textOffset);
        }
        SQLQueryLexicalScopeItem lexicalItem = null;
        SQLQueryLexicalScope scope = null;
        SQLQuerySymbolOrigin deepestTailOrigin = null;
        while (stack != null && (scope == null || deepestTailOrigin == null)) {
            SQLQueryNodeModel node2 = (SQLQueryNodeModel)stack.data;
            if (scope == null && (scope = node2.findLexicalScope(textOffset)) != null) {
                lexicalItem = scope.findNearestItem(textOffset);
            }
            if (deepestTailOrigin == null && node2.getTailOrigin() != null) {
                deepestTailOrigin = node2.getTailOrigin();
            }
            stack = stack.next;
        }
        if (lexicalItem == null) {
            int index = STMUtils.binarySearchByKey(this.lexicalItems, n -> n.getSyntaxNode().getRealInterval().a, (Object)(textOffset - 1), Comparator.comparingInt(x -> x));
            if (index < 0) {
                index = ~index - 1;
            }
            if (index >= 0) {
                SQLQueryLexicalScopeItem item = this.lexicalItems.get(index);
                Interval interval = item.getSyntaxNode().getRealInterval();
                if (interval.a < textOffset && interval.b + 1 >= textOffset) {
                    lexicalItem = item;
                }
            }
        }
        SQLQuerySymbolOrigin sQLQuerySymbolOrigin = symbolsOrigin = lexicalItem == null ? null : lexicalItem.getOrigin();
        if (symbolsOrigin == null && textOffset > this.getInterval().b && (symbolsOrigin = this.getTailOrigin()) == null) {
            symbolsOrigin = deepestTailOrigin;
        }
        if (symbolsOrigin == null && scope != null) {
            symbolsOrigin = scope.getSymbolsOrigin();
        }
        return new LexicalContextResolutionResult(textOffset, this.dataContext, this.dataContext, lexicalItem, symbolsOrigin);
    }

    @NotNull
    private LexicalContextResolutionResult findLexicalContextOld(int textOffset) {
        SQLQuerySymbolOrigin symbolsOrigin;
        ListNode stack = ListNode.of((Object)this);
        SQLQueryDataContext nearestResultContext = this.getResultDataContext();
        SQLQueryNodeModel node = this;
        SQLQueryNodeModel nested = node.findChildNodeContaining(textOffset);
        while (nested != null) {
            SQLQueryDataContext sQLQueryDataContext = nested.getResultDataContext();
            if (sQLQueryDataContext instanceof SQLQueryPureResultTupleContext) {
                SQLQueryPureResultTupleContext resultTupleContext = (SQLQueryPureResultTupleContext)sQLQueryDataContext;
                nearestResultContext = resultTupleContext;
            }
            stack = ListNode.push((ListNode)stack, (Object)nested);
            node = nested;
            nested = nested.findChildNodeContaining(textOffset);
        }
        SQLQueryDataContext deepestContext = ((SQLQueryNodeModel)node).getGivenDataContext();
        SQLQueryDataContext context = null;
        SQLQueryLexicalScopeItem lexicalItem = null;
        SQLQueryLexicalScope scope = null;
        while (stack != null && scope == null) {
            SQLQueryNodeModel node2 = (SQLQueryNodeModel)stack.data;
            scope = node2.findLexicalScope(textOffset);
            if (scope != null) {
                SQLQuerySymbolOrigin sQLQuerySymbolOrigin = scope.getSymbolsOrigin();
                if (sQLQuerySymbolOrigin instanceof SQLQuerySymbolOrigin.DataContextSymbolOrigin) {
                    SQLQuerySymbolOrigin.DataContextSymbolOrigin dsso = (SQLQuerySymbolOrigin.DataContextSymbolOrigin)sQLQuerySymbolOrigin;
                    context = dsso.getDataContext();
                }
                lexicalItem = scope.findNearestItem(textOffset);
            }
            stack = stack.next;
        }
        if (context == null) {
            context = deepestContext;
        }
        if (lexicalItem == null) {
            int index = STMUtils.binarySearchByKey(this.lexicalItems, n -> n.getSyntaxNode().getRealInterval().a, (Object)(textOffset - 1), Comparator.comparingInt(x -> x));
            if (index < 0) {
                index = ~index - 1;
            }
            if (index >= 0) {
                SQLQueryLexicalScopeItem item = this.lexicalItems.get(index);
                Interval interval = item.getSyntaxNode().getRealInterval();
                if (interval.a < textOffset && interval.b + 1 >= textOffset) {
                    lexicalItem = item;
                }
            }
        }
        SQLQuerySymbolOrigin sQLQuerySymbolOrigin = symbolsOrigin = lexicalItem == null ? null : lexicalItem.getOrigin();
        if (symbolsOrigin == null && textOffset > this.getInterval().b) {
            symbolsOrigin = this.getTailOrigin();
        }
        if (symbolsOrigin == null && scope != null) {
            symbolsOrigin = scope.getSymbolsOrigin();
        }
        return new LexicalContextResolutionResult(textOffset, nearestResultContext, context, lexicalItem, symbolsOrigin);
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitSelectionModel(this, arg);
    }

    public record LexicalContextResolutionResult(int textOffset, SQLQueryDataContext nearestResultContext, SQLQueryDataContext deepestContext, SQLQueryLexicalScopeItem lexicalItem, SQLQuerySymbolOrigin symbolsOrigin) {
    }
}

