/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.SelectItem;

public class AllColumns
extends ASTNodeAccessImpl
implements Expression {
    protected ExpressionList<Column> exceptColumns;
    protected List<SelectItem<Column>> replaceExpressions;
    private String exceptKeyword;

    public AllColumns(ExpressionList<Column> exceptColumns, List<SelectItem<Column>> replaceExpressions) {
        this.exceptColumns = exceptColumns;
        this.replaceExpressions = replaceExpressions;
        this.exceptKeyword = exceptColumns != null ? "Except" : null;
    }

    public AllColumns(ExpressionList<Column> exceptColumns, List<SelectItem<Column>> replaceExpressions, String exceptKeyword) {
        this.exceptColumns = exceptColumns;
        this.replaceExpressions = replaceExpressions;
        this.exceptKeyword = exceptKeyword;
    }

    public AllColumns() {
        this(null, null);
    }

    public ExpressionList<Column> getExceptColumns() {
        return this.exceptColumns;
    }

    public AllColumns setExceptColumns(ExpressionList<Column> exceptColumns) {
        this.exceptColumns = exceptColumns;
        return this;
    }

    public ExpressionList<Column> addExceptColumn(Column column) {
        if (this.exceptColumns == null) {
            this.exceptColumns = new ExpressionList((Expression[])new Column[0]);
        }
        this.exceptColumns.add(column);
        return this.exceptColumns;
    }

    public List<SelectItem<Column>> getReplaceExpressions() {
        return this.replaceExpressions;
    }

    public AllColumns setReplaceExpressions(List<SelectItem<Column>> replaceExpressions) {
        this.replaceExpressions = replaceExpressions;
        return this;
    }

    public List<SelectItem<Column>> addReplaceExpression(SelectItem<Column> selectItem) {
        if (this.replaceExpressions == null) {
            this.replaceExpressions = new ArrayList<SelectItem<Column>>();
        }
        this.replaceExpressions.add(selectItem);
        return this.replaceExpressions;
    }

    public String getExceptKeyword() {
        return this.exceptKeyword;
    }

    public AllColumns setExceptKeyword(String exceptKeyword) {
        this.exceptKeyword = exceptKeyword;
        return this;
    }

    @Override
    public StringBuilder appendTo(StringBuilder builder) {
        builder.append("*");
        if (this.exceptColumns != null && !this.exceptColumns.isEmpty()) {
            builder.append(" ").append(this.exceptKeyword).append("( ");
            this.exceptColumns.appendTo(builder);
            builder.append(" )");
        }
        if (this.replaceExpressions != null && !this.replaceExpressions.isEmpty()) {
            builder.append(" Replace(");
            int i = 0;
            for (SelectItem<Column> selectItem : this.replaceExpressions) {
                builder.append(i++ > 0 ? ", " : " ");
                selectItem.appendTo(builder);
            }
            builder.append(" )");
        }
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    @Override
    public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
        return expressionVisitor.visit(this, context);
    }
}

