/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModelContent;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLCommandModel
extends SQLQueryModelContent {
    @NotNull
    private final String commandText;
    @NotNull
    private final List<VariableNode> variables = new ArrayList<VariableNode>();

    public SQLCommandModel(@NotNull STMTreeNode fakeTree, @NotNull String commandText) {
        super(fakeTree.getRealInterval(), fakeTree, new SQLQueryNodeModel[0]);
        this.commandText = commandText;
    }

    @NotNull
    public String getCommandText() {
        return this.commandText;
    }

    @NotNull
    public VariableNode[] getVariables() {
        return (VariableNode[])this.variables.toArray(VariableNode[]::new);
    }

    public void addVariable(SQLQuerySymbolEntry symbol, String value) {
        this.variables.add(new VariableNode(symbol, value));
    }

    @Override
    protected void applyContext(@NotNull SQLQueryDataContext dataContext, @NotNull SQLQueryRecognitionContext recognitionContext) {
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, T arg) {
        return visitor.visitCommand(this, arg);
    }

    @Override
    @Nullable
    public SQLQueryDataContext getGivenDataContext() {
        return null;
    }

    @Override
    @Nullable
    public SQLQueryDataContext getResultDataContext() {
        return null;
    }

    public static class VariableNode
    extends SQLQueryNodeModel {
        public final SQLQuerySymbolEntry name;
        public final String value;

        public VariableNode(SQLQuerySymbolEntry symbol, String value) {
            super(symbol.getSyntaxNode().getRealInterval(), symbol.getSyntaxNode(), new SQLQueryNodeModel[0]);
            this.name = symbol;
            this.value = value;
        }

        @Override
        protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, T arg) {
            return visitor.visitCommandVariable(this, arg);
        }

        @Override
        @Nullable
        public SQLQueryDataContext getGivenDataContext() {
            return null;
        }

        @Override
        @Nullable
        public SQLQueryDataContext getResultDataContext() {
            return null;
        }
    }
}

