/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScope;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsCorrelatedSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryRowsCteSubqueryModel
extends SQLQueryRowsSourceModel {
    @Nullable
    public final SQLQuerySymbolEntry subqueryName;
    @NotNull
    public final List<SQLQuerySymbolEntry> columNames;
    @Nullable
    public final SQLQueryRowsSourceModel source;
    @Nullable
    private final SQLQueryLexicalScope sourceTailScope;

    public SQLQueryRowsCteSubqueryModel(@NotNull STMTreeNode syntaxNode, @Nullable SQLQuerySymbolEntry subqueryName, @NotNull List<SQLQuerySymbolEntry> columNames, @Nullable SQLQueryRowsSourceModel source, @Nullable SQLQueryLexicalScope sourceTailScope) {
        super(syntaxNode, source);
        this.subqueryName = subqueryName;
        this.columNames = columNames;
        this.source = source;
        this.sourceTailScope = sourceTailScope;
        if (sourceTailScope != null) {
            this.registerLexicalScope(sourceTailScope);
        }
    }

    public void prepareAliasDefinition() {
        if (this.subqueryName != null) {
            this.subqueryName.getSymbol().setDefinition(this.subqueryName);
            if (this.subqueryName.isNotClassified()) {
                this.subqueryName.getSymbol().setSymbolClass(SQLQuerySymbolClass.TABLE_ALIAS);
            }
        }
    }

    @Override
    @NotNull
    protected SQLQueryDataContext propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        return context;
    }

    @Override
    protected SQLQueryRowsSourceContext resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        if (this.subqueryName != null && this.subqueryName.isNotClassified()) {
            this.subqueryName.getSymbol().setDefinition(this.subqueryName);
            if (this.subqueryName.isNotClassified()) {
                this.subqueryName.getSymbol().setSymbolClass(SQLQuerySymbolClass.TABLE_ALIAS);
            }
        }
        if (this.source != null) {
            this.source.resolveRowSources(context, statistics);
        }
        return context.reset();
    }

    @Override
    protected SQLQueryRowsDataContext resolveRowDataImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        if (this.source != null) {
            this.setTailOrigin(this.source.getTailOrigin());
            if (this.sourceTailScope != null && this.source.getTailOrigin() != null) {
                this.sourceTailScope.setSymbolsOrigin(this.source.getTailOrigin());
            }
            if (!this.columNames.isEmpty()) {
                return SQLQueryRowsCorrelatedSourceModel.prepareColumnsCorrelation(this.source.getRowsDataContext(), this.columNames, (SQLQueryRowsSourceModel)this);
            }
            return this.source.getRowsDataContext();
        }
        return context.getRowsSources().makeEmptyTuple();
    }

    @Override
    @Nullable
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T node) {
        return visitor.visitRowsCteSubquery(this, node);
    }
}

