/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.utils.CommonUtils;

public abstract class NLS {
    private static final Log log = Log.getLog(NLS.class);
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final String EXTENSION = ".properties";
    private static String[] nlSuffixes;
    static final Object ASSIGNED;

    static {
        ASSIGNED = new Object();
    }

    protected NLS() {
    }

    @NotNull
    public static String bind(@NotNull String message, @NotNull Object binding) {
        return NLS.internalBind(message, null, String.valueOf(binding), null);
    }

    @NotNull
    public static String bind(@NotNull String message, @NotNull Object binding1, @NotNull Object binding2) {
        return NLS.internalBind(message, null, String.valueOf(binding1), String.valueOf(binding2));
    }

    @NotNull
    public static String bind(@NotNull String message, @NotNull Object[] bindings) {
        return NLS.internalBind(message, bindings, null, null);
    }

    public static void initializeMessages(@NotNull String baseName, @NotNull Class<?> clazz) {
        NLS.load(baseName, clazz);
    }

    @NotNull
    private static String internalBind(String message, Object[] args, String argZero, String argOne) {
        if (message == null) {
            return "No message available.";
        }
        if (args == null || args.length == 0) {
            args = EMPTY_ARGS;
        }
        int length = message.length();
        int bufLen = length + args.length * 5;
        if (argZero != null) {
            bufLen += argZero.length() - 3;
        }
        if (argOne != null) {
            bufLen += argOne.length() - 3;
        }
        StringBuilder buffer = new StringBuilder(Math.max(bufLen, 0));
        int i = 0;
        while (i < length) {
            char c = message.charAt(i);
            switch (c) {
                case '{': {
                    int index = message.indexOf(125, i);
                    if (index == -1) {
                        buffer.append(c);
                        break;
                    }
                    if (++i >= length) {
                        buffer.append(c);
                        break;
                    }
                    int number = CommonUtils.toInt((Object)message.substring(i, index));
                    if (number == 0 && argZero != null) {
                        buffer.append(argZero);
                    } else if (number == 1 && argOne != null) {
                        buffer.append(argOne);
                    } else {
                        if (number >= args.length || number < 0) {
                            buffer.append("<missing argument>");
                            i = index;
                            break;
                        }
                        buffer.append(args[number]);
                    }
                    i = index;
                    break;
                }
                case '\'': {
                    int nextIndex = i + 1;
                    if (nextIndex >= length) {
                        buffer.append(c);
                        break;
                    }
                    char next = message.charAt(nextIndex);
                    if (next == '\'') {
                        ++i;
                        buffer.append(c);
                        break;
                    }
                    int index = message.indexOf(39, nextIndex);
                    if (index == -1) {
                        buffer.append(c);
                        break;
                    }
                    buffer.append(message, nextIndex, index);
                    i = index;
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private static String[] buildVariants(String root) {
        if (nlSuffixes == null) {
            String nl = Locale.getDefault().toString();
            ArrayList<Object> result = new ArrayList<Object>(4);
            while (true) {
                int lastSeparator;
                result.add("_" + nl + EXTENSION);
                String additional = NLS.getAdditionalSuffix(nl);
                if (additional != null) {
                    result.add("_" + additional + EXTENSION);
                }
                if ((lastSeparator = nl.lastIndexOf(95)) == -1) break;
                nl = nl.substring(0, lastSeparator);
            }
            result.add(EXTENSION);
            nlSuffixes = result.toArray(new String[0]);
        }
        root = root.replace('.', '/');
        String[] variants = new String[nlSuffixes.length];
        int i = 0;
        while (i < variants.length) {
            variants[i] = root + nlSuffixes[i];
            ++i;
        }
        return variants;
    }

    private static String getAdditionalSuffix(String nl) {
        Object additional = null;
        if (nl != null) {
            if ("he".equals(nl)) {
                additional = "iw";
            } else if (nl.startsWith("he_")) {
                additional = "iw_" + nl.substring(3);
            }
        }
        return additional;
    }

    private static void computeMissingMessages(String bundleName, Map<Object, Object> fieldMap, Field[] fieldArray, boolean isAccessible) {
        Field[] fieldArray2 = fieldArray;
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            if ((field.getModifiers() & 0x19) == 9 && fieldMap.get(field.getName()) != ASSIGNED) {
                try {
                    String value = "NLS missing message: " + field.getName() + " in: " + bundleName;
                    log.warn(value);
                    if (!isAccessible) {
                        field.setAccessible(true);
                    }
                    field.set(null, value);
                }
                catch (Exception e) {
                    log.error("Error setting the missing message value for: " + field.getName(), e);
                }
            }
            ++n2;
        }
    }

    static void load(String bundleName, Class<?> clazz) {
        String[] variants;
        Field[] fieldArray = clazz.getDeclaredFields();
        ClassLoader loader = clazz.getClassLoader();
        boolean isAccessible = (clazz.getModifiers() & 1) != 0;
        HashMap<Object, Object> fields = new HashMap<Object, Object>(fieldArray.length * 2);
        Field[] fieldArray2 = fieldArray;
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            fields.put(field.getName(), field);
            ++n2;
        }
        String[] stringArray = variants = NLS.buildVariants(bundleName);
        int n3 = variants.length;
        n = 0;
        while (n < n3) {
            String variant = stringArray[n];
            InputStream input = loader == null ? ClassLoader.getSystemResourceAsStream(variant) : loader.getResourceAsStream(variant);
            try {
                Throwable throwable = null;
                Object var13_17 = null;
                try {
                    try {
                        if (input != null) {
                            MessagesProperties properties = new MessagesProperties(fields, bundleName, isAccessible);
                            PropertyResourceBundle bundle = new PropertyResourceBundle(input);
                            for (String key : bundle.keySet()) {
                                properties.put(key, bundle.getString(key));
                            }
                        }
                    }
                    finally {
                        if (input != null) {
                            input.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                log.error("Error loading " + variant, e);
            }
            ++n;
        }
        NLS.computeMissingMessages(bundleName, fields, fieldArray, isAccessible);
    }

    private static class MessagesProperties
    extends Properties {
        private static final int MOD_EXPECTED = 9;
        private static final int MOD_MASK = 25;
        private final String bundleName;
        private final Map<Object, Object> fields;
        private final boolean isAccessible;

        public MessagesProperties(Map<Object, Object> fieldMap, String bundleName, boolean isAccessible) {
            this.fields = fieldMap;
            this.bundleName = bundleName;
            this.isAccessible = isAccessible;
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            Object fieldObject = this.fields.put(key, ASSIGNED);
            if (fieldObject == ASSIGNED) {
                return null;
            }
            if (fieldObject == null) {
                String msg = "NLS unused message: " + String.valueOf(key) + " in: " + this.bundleName;
                if (key instanceof String && ((String)key).indexOf(46) < 0) {
                    log.debug(msg);
                }
                return null;
            }
            Field field = (Field)fieldObject;
            if ((field.getModifiers() & 0x19) != 9) {
                return null;
            }
            try {
                if (!this.isAccessible) {
                    field.setAccessible(true);
                }
                field.set(null, new String(((String)value).toCharArray()));
            }
            catch (Exception e) {
                log.error("Exception setting field value.", e);
            }
            return null;
        }
    }
}

