/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablePhysical;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTablePartition;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class OracleTablePartition
extends OracleTablePhysical
implements DBSTablePartition,
DBPImageProvider {
    private static final Log log = Log.getLog(OracleTablePartition.class);
    private static final String CAT_PARTITIONING = "Partitioning";
    private OracleTablePhysical parent;
    private OracleTablePartition partitionParent;
    private int position;
    private String highValue;
    private boolean usable;
    private long sampleSize;
    private Timestamp lastAnalyzed;
    private List<OracleTablePartition> subPartitions;
    private String valuesForCreating;

    OracleTablePartition(@NotNull OracleTablePhysical parent, @NotNull String name, @NotNull ResultSet dbResult, @Nullable OracleTablePartition partitionParent) {
        super(parent.getSchema(), dbResult, name);
        this.parent = parent;
        this.partitionParent = partitionParent;
        this.highValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"HIGH_VALUE");
        this.position = partitionParent != null ? JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"SUBPARTITION_POSITION") : JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PARTITION_POSITION");
        this.usable = "USABLE".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATUS"));
        this.sampleSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"SAMPLE_SIZE");
        this.lastAnalyzed = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_ANALYZED");
    }

    public OracleTablePartition(@NotNull OracleSchema schema, @NotNull String name, @NotNull OracleTablePhysical parent, @Nullable OracleTablePartition partitionParent) {
        super(schema, name);
        this.parent = parent;
        this.partitionParent = partitionParent;
    }

    @NotNull
    public DBSTable getParentTable() {
        return this.parent;
    }

    @Property(viewable=true, order=10)
    public int getPosition() {
        return this.position;
    }

    @Property(viewable=true, order=11)
    public boolean isUsable() {
        return this.usable;
    }

    @Property(viewable=true, order=30)
    public String getHighValue() {
        return this.highValue;
    }

    @Property(viewable=true, order=41)
    public long getSampleSize() {
        return this.sampleSize;
    }

    @Property(viewable=true, order=42)
    public Timestamp getLastAnalyzed() {
        return this.lastAnalyzed;
    }

    @Override
    @Property(viewable=true, order=13)
    public boolean isPartitioned() {
        return !CommonUtils.isEmpty(this.subPartitions);
    }

    @Association
    public List<OracleTablePartition> getSubPartitions(DBRProgressMonitor monitor) throws DBException {
        if (this.partitionParent != null) {
            return Collections.emptyList();
        }
        if (this.subPartitions == null) {
            this.readSubPartitions(monitor);
        }
        return this.subPartitions;
    }

    public List<OracleTablePartition> getCachedSubPartitions() {
        if (this.partitionParent != null) {
            return Collections.emptyList();
        }
        return this.subPartitions;
    }

    /*
     * Exception decompiling
     */
    private List<OracleTablePartition> readSubPartitions(@NotNull DBRProgressMonitor monitor) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addSubPartition(@NotNull OracleTablePartition partition) {
        if (this.subPartitions == null) {
            this.subPartitions = new ArrayList<OracleTablePartition>();
        }
        this.subPartitions.add(partition);
    }

    @Nullable
    public DBPImage getObjectImage() {
        return DBIcon.TREE_PARTITION;
    }

    @Override
    public OracleTableBase.TableAdditionalInfo getAdditionalInfo() {
        return new OracleTableBase.TableAdditionalInfo();
    }

    @Override
    protected String getTableTypeName() {
        return "TABLE PARTITION";
    }

    public boolean isView() {
        return false;
    }

    protected boolean needAliasInSelect(@Nullable DBDDataFilter dataFilter, @Nullable DBDPseudoAttribute rowIdAttribute, @NotNull DBPDataSource dataSource) {
        return false;
    }

    public OracleTablePhysical getParent() {
        return this.parent;
    }

    @Nullable
    public OracleTablePartition getPartitionParent() {
        return this.partitionParent;
    }

    public boolean isSubPartition() {
        return this.partitionParent != null;
    }

    public String getValuesForCreating() {
        return this.valuesForCreating;
    }

    public void setValuesForCreating(String valuesForCreating) {
        this.valuesForCreating = valuesForCreating;
    }

    @NotNull
    protected String getTableName() {
        return this.parent.getFullyQualifiedName(DBPEvaluationContext.DML);
    }

    protected void appendExtraSelectParameters(@NotNull StringBuilder query) {
        query.append(" ").append(this.partitionParent != null ? "SUB" : "").append("PARTITION (").append(DBUtils.getQuotedIdentifier((DBSObject)this)).append(")");
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.subPartitions = null;
        return super.refreshObject(monitor);
    }

    public static enum PartitionByIntervalKind implements DBPNamedObject
    {
        NONE(null, null, "No partition by interval"),
        CUSTOM(null, null, "Use custom interval expression"),
        YEAR(PartitionByIntervalLiteralKind.YEAR_TO_MONTH, PartitionByIntervalUnitKind.YEAR, "by interval of years"),
        MONTH(PartitionByIntervalLiteralKind.YEAR_TO_MONTH, PartitionByIntervalUnitKind.MONTH, "by interval or months"),
        DAY(PartitionByIntervalLiteralKind.DAY_TO_SECOND, PartitionByIntervalUnitKind.DAY, "by interval of days"),
        HOUR(PartitionByIntervalLiteralKind.DAY_TO_SECOND, PartitionByIntervalUnitKind.HOUR, "by interval of hours"),
        MINUTE(PartitionByIntervalLiteralKind.DAY_TO_SECOND, PartitionByIntervalUnitKind.MINUTE, "by interval of minutes"),
        SECOND(PartitionByIntervalLiteralKind.DAY_TO_SECOND, PartitionByIntervalUnitKind.SECOND, "by interval of seconds");

        public final PartitionByIntervalLiteralKind literalKind;
        public final PartitionByIntervalUnitKind unitKind;
        public final String title;
        private static final Pattern exprPattern;

        static {
            exprPattern = Pattern.compile("^\\s*(?<kind>\\w+)\\s*\\((?<value>.+),\\s*'(?<unit>\\w+)'\\s*\\)\\s*$");
        }

        private PartitionByIntervalKind(PartitionByIntervalLiteralKind literalKind, PartitionByIntervalUnitKind unitKind, String title) {
            this.literalKind = literalKind;
            this.unitKind = unitKind;
            this.title = title;
        }

        @NotNull
        public String getName() {
            return this.title;
        }

        public String prepareExpression(String value) {
            return switch (this) {
                case NONE -> null;
                case CUSTOM -> "<enter custom expression>";
                default -> this.literalKind.literalFuncName + "(" + value + ", '" + this.unitKind.name() + "')";
            };
        }

        public String changeExpression(String expr) {
            Pair<PartitionByIntervalKind, String> kindAndValue = PartitionByIntervalKind.recognizeAndExtractValue(expr);
            return this.prepareExpression(switch ((PartitionByIntervalKind)((Object)kindAndValue.getFirst())) {
                case NONE, CUSTOM -> "1";
                default -> (String)kindAndValue.getSecond();
            });
        }

        @NotNull
        public static Pair<PartitionByIntervalKind, String> recognizeAndExtractValue(String expr) {
            String unitName;
            PartitionByIntervalUnitKind unit;
            String kindName;
            PartitionByIntervalLiteralKind kind;
            if (CommonUtils.isEmpty((String)expr)) {
                return Pair.of((Object)((Object)NONE), null);
            }
            Matcher m = exprPattern.matcher(expr);
            if (m.matches() && (kind = PartitionByIntervalLiteralKind.tryParse(kindName = m.group("kind"))) != null && (unit = kind.tryParseKnownUnit(unitName = m.group("unit"))) != null) {
                return Pair.of((Object)((Object)unit.getIntervalKind()), (Object)m.group("value"));
            }
            return Pair.of((Object)((Object)CUSTOM), (Object)expr);
        }

        @NotNull
        public static PartitionByIntervalKind recognize(String expr) {
            return (PartitionByIntervalKind)((Object)PartitionByIntervalKind.recognizeAndExtractValue(expr).getFirst());
        }
    }

    public static class PartitionByIntervalKindListProvider
    implements IPropertyValueListProvider<OracleTablePhysical> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(OracleTablePhysical table) {
            return PartitionByIntervalKind.values();
        }
    }

    public static enum PartitionByIntervalLiteralKind {
        YEAR_TO_MONTH("NUMTOYMINTERVAL", PartitionByIntervalUnitKind.YEAR, PartitionByIntervalUnitKind.MONTH),
        DAY_TO_SECOND("NUMTODSINTERVAL", PartitionByIntervalUnitKind.DAY, PartitionByIntervalUnitKind.HOUR, PartitionByIntervalUnitKind.MINUTE, PartitionByIntervalUnitKind.SECOND);

        public final Set<PartitionByIntervalUnitKind> units;
        public final String literalFuncName;
        private final Map<String, PartitionByIntervalUnitKind> unitsByName;
        private static final Map<String, PartitionByIntervalLiteralKind> kindByName;

        static {
            kindByName = Stream.of(PartitionByIntervalLiteralKind.values()).collect(Collectors.toMap(k -> k.literalFuncName, k -> k));
        }

        private PartitionByIntervalLiteralKind(String literalFuncName, PartitionByIntervalUnitKind ... units) {
            this.literalFuncName = literalFuncName;
            this.units = Set.of(units);
            this.unitsByName = this.units.stream().collect(Collectors.toMap(u -> u.name().toUpperCase(), u -> u));
        }

        @Nullable
        public PartitionByIntervalUnitKind tryParseKnownUnit(String unitName) {
            return this.unitsByName.get(unitName.toUpperCase());
        }

        @Nullable
        public static PartitionByIntervalLiteralKind tryParse(String kindName) {
            return kindByName.get(kindName.toUpperCase());
        }
    }

    public static enum PartitionByIntervalUnitKind {
        YEAR(() -> PartitionByIntervalKind.YEAR),
        MONTH(() -> PartitionByIntervalKind.MONTH),
        DAY(() -> PartitionByIntervalKind.DAY),
        HOUR(() -> PartitionByIntervalKind.HOUR),
        MINUTE(() -> PartitionByIntervalKind.MINUTE),
        SECOND(() -> PartitionByIntervalKind.SECOND);

        private final Supplier<PartitionByIntervalKind> getIntervalKindSupplier;

        private PartitionByIntervalUnitKind(Supplier<PartitionByIntervalKind> getIntervalKindSupplier) {
            this.getIntervalKindSupplier = getIntervalKindSupplier;
        }

        public PartitionByIntervalKind getIntervalKind() {
            return this.getIntervalKindSupplier.get();
        }
    }

    public static class PartitionInfoBase {
        private PartitionType partitionType;
        private PartitionType subpartitionType;
        private String partitionInterval;
        private long partitionCount;
        private Object partitionTablespace;

        @Property(editable=true, category="Partitioning", order=120)
        @NotNull
        public PartitionType getPartitionType() {
            return this.partitionType;
        }

        public void setPartitionType(PartitionType partitionType) {
            this.partitionType = partitionType;
        }

        @Property(editable=true, category="Partitioning", order=121)
        @NotNull
        public PartitionType getSubpartitionType() {
            return this.subpartitionType;
        }

        public void setSubpartitionType(PartitionType subpartitionType) {
            this.subpartitionType = subpartitionType;
        }

        @Property(category="Partitioning", viewable=true, editable=true, visibleIf=OraclePartitionIntervalValidator.class, listProvider=PartitionByIntervalKindListProvider.class, order=122)
        public PartitionByIntervalKind getPartitionByIntervalKind() {
            return PartitionByIntervalKind.recognize(this.partitionInterval);
        }

        public void setPartitionByIntervalKind(PartitionByIntervalKind kind) {
            this.partitionInterval = ((PartitionByIntervalKind)((Object)CommonUtils.notNull((Object)((Object)kind), (Object)((Object)PartitionByIntervalKind.NONE)))).changeExpression(this.partitionInterval);
        }

        @Property(category="Partitioning", visibleIf=OraclePartitionIntervalValidator.class, viewable=true, editable=true, order=123)
        public String getPartitionByIntervalExpr() {
            return this.partitionInterval;
        }

        public void setPartitionByIntervalExpr(String value) {
            this.partitionInterval = value;
        }

        @Property(category="Partitioning", order=124)
        public long getPartitionCount() {
            return this.partitionCount;
        }

        @Property(category="Partitioning", order=125, updatable=true)
        public Object getPartitionTablespace() {
            return this.partitionTablespace;
        }

        public PartitionInfoBase(DBRProgressMonitor monitor, OracleDataSource dataSource, ResultSet dbResult) {
            this.partitionType = (PartitionType)CommonUtils.valueOf(PartitionType.class, (String)JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"PARTITIONING_TYPE"), (Enum)PartitionType.RANGE);
            this.subpartitionType = (PartitionType)CommonUtils.valueOf(PartitionType.class, (String)JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"SUBPARTITIONING_TYPE"));
            String partitionTablespaceName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"DEF_TABLESPACE_NAME");
            this.partitionInterval = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"INTERVAL");
            this.partitionCount = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"PARTITION_COUNT");
            if (dataSource.isAdmin() && CommonUtils.isNotEmpty((String)partitionTablespaceName)) {
                try {
                    this.partitionTablespace = dataSource.tablespaceCache.getObject(monitor, (DBSObject)dataSource, partitionTablespaceName);
                }
                catch (DBException e) {
                    log.debug((Object)("Can not find tablespace " + partitionTablespaceName), (Throwable)e);
                }
            }
        }

        public PartitionInfoBase() {
            this.partitionType = PartitionType.RANGE;
            this.subpartitionType = PartitionType.RANGE;
        }

        public void setPartitionTablespace(Object partitionTablespace) {
            this.partitionTablespace = partitionTablespace;
        }

        public static class OraclePartitionIntervalValidator
        implements IPropertyValueValidator<OracleTableBase, Object> {
            public boolean isValidValue(OracleTableBase object, Object value) throws IllegalArgumentException {
                return !(object instanceof OracleTablePartition);
            }
        }
    }

    public static enum PartitionType {
        NONE,
        RANGE,
        HASH,
        SYSTEM,
        LIST;

    }
}

