/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.object.struct;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.runtime.properties.PropertySourceEditable;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomFormEditor;
import org.jkiss.dbeaver.ui.editors.object.internal.ObjectEditorMessages;
import org.jkiss.dbeaver.ui.editors.object.struct.BaseObjectEditPage;
import org.jkiss.utils.CommonUtils;

public class PropertyObjectEditPage<OBJECT extends DBSObject>
extends BaseObjectEditPage {
    private final OBJECT object;
    private final PropertySourceEditable propertySource;
    private CustomFormEditor propertyEditor;

    public PropertyObjectEditPage(@Nullable DBECommandContext commandContext, @NotNull OBJECT object) {
        super("Edit " + object.getName());
        this.object = object;
        this.propertySource = new PropertySourceEditable(commandContext, object, object);
        this.propertySource.collectProperties();
        DBPPropertyDescriptor[] dBPPropertyDescriptorArray = this.propertySource.getProperties();
        int n = dBPPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectPropertyDescriptor obj;
            DBPPropertyDescriptor prop = dBPPropertyDescriptorArray[n2];
            if (prop instanceof ObjectPropertyDescriptor && (!(obj = (ObjectPropertyDescriptor)prop).isEditPossible(object) || obj.isNameProperty())) {
                this.propertySource.removeProperty(prop);
            }
            ++n2;
        }
    }

    @NotNull
    public OBJECT getObject() {
        return this.object;
    }

    @Nullable
    public DBECommandContext getCommandContext() {
        return this.propertySource.getCommandContext();
    }

    protected String getPropertiesGroupTitle() {
        return null;
    }

    @Override
    protected Control createPageContents(Composite parent) {
        Composite composite;
        String groupTitle = this.getPropertiesGroupTitle();
        if (CommonUtils.isEmpty((String)groupTitle)) {
            composite = new Composite(parent, 0);
        } else {
            composite = new Group(parent, 0);
            ((Group)composite).setText(groupTitle);
        }
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        this.createDefaultEditControls(composite);
        this.createAdditionalEditControls(parent);
        return composite;
    }

    protected void createAdditionalEditControls(Composite composite) {
    }

    private void createDefaultEditControls(Composite composite) {
        Text nameText = UIUtils.createLabelText((Composite)composite, (String)ObjectEditorMessages.dialog_struct_label_text_name, (String)this.object.getName());
        nameText.selectAll();
        nameText.addModifyListener(e -> {
            if (this.object instanceof DBPNamedObject2 && this.object.getDataSource() != null) {
                String objectName = nameText.getText().trim();
                String transformed = DBObjectNameCaseTransformer.transformName((DBPDataSource)this.object.getDataSource(), (String)objectName);
                ((DBPNamedObject2)this.object).setName(transformed);
                this.validateProperties();
            }
        });
        this.propertyEditor = new CustomFormEditor(this.getObject(), this.getCommandContext(), (DBPPropertySource)this.propertySource);
        DBPPropertyDescriptor[] dBPPropertyDescriptorArray = this.propertySource.getProperties();
        int n = dBPPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPPropertyDescriptor prop = dBPPropertyDescriptorArray[n2];
            this.propertyEditor.createPropertyEditor(composite, prop);
            ++n2;
        }
    }

    @Override
    protected String getEditError() {
        if (CommonUtils.isEmpty((String)this.object.getName())) {
            return "Object name cannot be empty";
        }
        return super.getEditError();
    }

    @Override
    public void performFinish() throws DBException {
    }
}

