/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.database;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPReferentialIntegrityController;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.sql.SQLDialectInsertReplaceMethod;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadata;
import org.jkiss.dbeaver.model.struct.DBSDataBulkLoader;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferEventProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.ui.IDataTransferEventProcessorConfigurator;
import org.jkiss.dbeaver.tools.transfer.ui.controls.EventProcessorComposite;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.pages.DataTransferPageNodeSettings;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;

public class DatabaseConsumerPageLoadSettings
extends DataTransferPageNodeSettings {
    private static final Log log = Log.getLog(DatabaseConsumerPageLoadSettings.class);
    private final String HELP_TOPIC_REPLACE_METHOD = "Data-Import-and-Replace";
    private Button transferAutoGeneratedColumns;
    private Button truncateTargetTable;
    private Button disableReferentialIntegrity;
    private Combo onDuplicateKeyInsertMethods;
    private Group loadSettings;
    private String disableReferentialIntegrityCheckboxTooltip;
    private boolean isDisablingReferentialIntegritySupported;
    private Text multiRowInsertBatch;
    private Button skipBindValues;
    private Button useBatchCheck;
    private Button ignoreDuplicateRows;
    private Button useBulkLoadCheck;
    private List<SQLDialectInsertReplaceMethod> availableInsertMethodsDescriptors;
    private final Map<String, EventProcessorComposite<?>> processors = new HashMap();

    public DatabaseConsumerPageLoadSettings() {
        super(DTUIMessages.database_consumer_wizard_name);
        this.setTitle(DTUIMessages.database_consumer_wizard_title);
        this.setDescription(DTUIMessages.database_consumer_wizard_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = UIUtils.createComposite((Composite)parent, (int)2);
        final DatabaseConsumerSettings settings = this.getSettings();
        this.loadSettings = UIUtils.createControlGroup((Composite)composite, (String)DTUIMessages.database_consumer_wizard_name, (int)2, (int)34, (int)0);
        this.transferAutoGeneratedColumns = UIUtils.createCheckbox((Composite)this.loadSettings, (String)DTUIMessages.database_consumer_wizard_transfer_checkbox_label, (String)DTUIMessages.database_consumer_wizard_transfer_checkbox_tooltip, (boolean)settings.isTransferAutoGeneratedColumns(), (int)2);
        this.transferAutoGeneratedColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setTransferAutoGeneratedColumns(DatabaseConsumerPageLoadSettings.this.transferAutoGeneratedColumns.getSelection());
            }
        });
        this.truncateTargetTable = UIUtils.createCheckbox((Composite)this.loadSettings, (String)DTUIMessages.database_consumer_wizard_truncate_checkbox_label, (String)DTUIMessages.database_consumer_wizard_truncate_checkbox_description, (boolean)settings.isTruncateBeforeLoad(), (int)2);
        this.truncateTargetTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DatabaseConsumerPageLoadSettings.this.truncateTargetTable.getSelection() && !DatabaseConsumerPageLoadSettings.this.confirmDataTruncate()) {
                    DatabaseConsumerPageLoadSettings.this.truncateTargetTable.setSelection(false);
                    return;
                }
                settings.setTruncateBeforeLoad(DatabaseConsumerPageLoadSettings.this.truncateTargetTable.getSelection());
            }
        });
        this.loadUISettingsForDisableReferentialIntegrityCheckbox();
        settings.setDisableReferentialIntegrity(this.isDisablingReferentialIntegritySupported && settings.isDisableReferentialIntegrity());
        this.disableReferentialIntegrity = UIUtils.createCheckbox((Composite)this.loadSettings, (String)DTUIMessages.database_consumer_wizard_disable_referential_integrity_label, (String)this.disableReferentialIntegrityCheckboxTooltip, (boolean)settings.isDisableReferentialIntegrity(), (int)2);
        this.disableReferentialIntegrity.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setDisableReferentialIntegrity(DatabaseConsumerPageLoadSettings.this.disableReferentialIntegrity.getSelection());
            }
        });
        this.disableReferentialIntegrity.setEnabled(this.isDisablingReferentialIntegritySupported);
        UIUtils.createControlLabel((Composite)this.loadSettings, (String)DTUIMessages.database_consumer_wizard_on_duplicate_key_insert_method_text);
        this.onDuplicateKeyInsertMethods = new Combo((Composite)this.loadSettings, 12);
        this.onDuplicateKeyInsertMethods.setLayoutData((Object)new GridData(768));
        this.onDuplicateKeyInsertMethods.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = DatabaseConsumerPageLoadSettings.this.onDuplicateKeyInsertMethods.getSelectionIndex();
                if (selIndex > 0 && !CommonUtils.isEmpty(DatabaseConsumerPageLoadSettings.this.availableInsertMethodsDescriptors)) {
                    SQLDialectInsertReplaceMethod methodDescriptor = DatabaseConsumerPageLoadSettings.this.availableInsertMethodsDescriptors.get(selIndex - 1);
                    settings.setOnDuplicateKeyInsertMethodId(methodDescriptor.getId());
                } else {
                    settings.setOnDuplicateKeyInsertMethodId(DatabaseConsumerPageLoadSettings.this.onDuplicateKeyInsertMethods.getText());
                }
            }
        });
        Link urlLabel = UIUtils.createLink((Composite)this.loadSettings, (String)("<a href=\"" + HelpUtils.getHelpExternalReference((String)"Data-Import-and-Replace") + "\">" + DTUIMessages.database_consumer_wizard_link_label_replace_method_wiki + "</a>"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Data-Import-and-Replace"));
            }
        });
        urlLabel.setLayoutData((Object)new GridData(4, 2, false, false, 2, 1));
        Group generalSettings = UIUtils.createControlGroup((Composite)composite, (String)DTUIMessages.database_consumer_wizard_general_group_label, (int)1, (int)34, (int)0);
        final Button showTableCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)DTUIMessages.database_consumer_wizard_table_checkbox_label, (boolean)settings.isOpenTableOnFinish());
        showTableCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenTableOnFinish(showTableCheckbox.getSelection());
            }
        });
        final Button showFinalMessageCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)DTUIMessages.database_consumer_wizard_final_message_checkbox_label, (boolean)((DataTransferWizard)this.getWizard()).getSettings().isShowFinalMessage());
        showFinalMessageCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((DataTransferWizard)DatabaseConsumerPageLoadSettings.this.getWizard()).getSettings().setShowFinalMessage(showFinalMessageCheckbox.getSelection());
            }
        });
        DataTransferRegistry dataTransferRegistry = DataTransferRegistry.getInstance();
        UIPropertyConfiguratorRegistry configuratorRegistry = UIPropertyConfiguratorRegistry.getInstance();
        for (DataTransferEventProcessorDescriptor descriptor : dataTransferRegistry.getEventProcessors("databaseTransferConsumer")) {
            try {
                UIPropertyConfiguratorDescriptor configuratorDescriptor = configuratorRegistry.getDescriptor(descriptor.getType().getImplName());
                IDataTransferEventProcessorConfigurator configurator = (IDataTransferEventProcessorConfigurator)configuratorDescriptor.createConfigurator();
                this.processors.put(descriptor.getId(), new EventProcessorComposite<DatabaseConsumerSettings>(() -> ((DatabaseConsumerPageLoadSettings)this).updatePageCompletion(), (Composite)generalSettings, settings, descriptor, configurator));
            }
            catch (Exception e2) {
                log.error((Object)"Can't create event processor", (Throwable)e2);
            }
        }
        Group performanceSettings = UIUtils.createControlGroup((Composite)composite, (String)DTUIMessages.database_consumer_wizard_performance_group_label, (int)4, (int)34, (int)0);
        final Button newConnectionCheckbox = UIUtils.createCheckbox((Composite)performanceSettings, (String)DTMessages.data_transfer_wizard_output_checkbox_new_connection, null, (boolean)settings.isOpenNewConnections(), (int)4);
        newConnectionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenNewConnections(newConnectionCheckbox.getSelection());
            }
        });
        final Button useTransactionsCheck = UIUtils.createCheckbox((Composite)performanceSettings, (String)DTUIMessages.database_consumer_wizard_transactions_checkbox_label, null, (boolean)settings.isUseTransactions(), (int)4);
        useTransactionsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setUseTransactions(useTransactionsCheck.getSelection());
            }
        });
        Text commitAfterEdit = UIUtils.createLabelText((Composite)performanceSettings, (String)DTUIMessages.database_consumer_wizard_commit_spinner_label, (String)String.valueOf(settings.getCommitAfterRows()), (int)2048);
        commitAfterEdit.addModifyListener(e -> settings.setCommitAfterRows(CommonUtils.toInt((Object)commitAfterEdit.getText())));
        GridData gd = new GridData(32, 2, false, false, 3, 1);
        gd.widthHint = UIUtils.getFontHeight((Control)commitAfterEdit) * 6;
        commitAfterEdit.setLayoutData((Object)gd);
        final Button useMultiRowInsert = UIUtils.createCheckbox((Composite)performanceSettings, (String)DTUIMessages.database_consumer_wizard_checkbox_multi_insert_label, (String)DTUIMessages.database_consumer_wizard_checkbox_multi_insert_description, (boolean)settings.isUseMultiRowInsert(), (int)1);
        if (this.useBatchCheck != null && (!this.useBatchCheck.isDisposed() && this.useBatchCheck.getSelection() || this.useBatchCheck.isDisposed() && settings.isDisableUsingBatches())) {
            this.disableButton(useMultiRowInsert);
        }
        useMultiRowInsert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setUseMultiRowInsert(useMultiRowInsert.getSelection());
                if (DatabaseConsumerPageLoadSettings.this.multiRowInsertBatch != null) {
                    if (!useMultiRowInsert.getSelection()) {
                        DatabaseConsumerPageLoadSettings.this.multiRowInsertBatch.setEnabled(false);
                    } else if (!DatabaseConsumerPageLoadSettings.this.multiRowInsertBatch.getEnabled()) {
                        DatabaseConsumerPageLoadSettings.this.multiRowInsertBatch.setEnabled(true);
                    }
                }
            }
        });
        this.multiRowInsertBatch = new Text((Composite)performanceSettings, 2048);
        this.multiRowInsertBatch.setToolTipText(DTUIMessages.database_consumer_wizard_spinner_multi_insert_batch_size);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.multiRowInsertBatch.setLayoutData((Object)gd);
        this.multiRowInsertBatch.setText(String.valueOf(settings.getMultiRowInsertBatch()));
        if (!useMultiRowInsert.getSelection() || this.buttonIsAvailable(this.useBatchCheck) && this.useBatchCheck.getSelection()) {
            this.multiRowInsertBatch.setEnabled(false);
        }
        this.multiRowInsertBatch.addModifyListener(e -> settings.setMultiRowInsertBatch(CommonUtils.toInt((Object)this.multiRowInsertBatch.getText())));
        if (settings.getContainer() != null && settings.getContainer().getDataSource().getInfo().supportsStatementBinding()) {
            this.skipBindValues = UIUtils.createCheckbox((Composite)performanceSettings, (String)DTUIMessages.database_consumer_wizard_checkbox_multi_insert_skip_bind_values_label, (String)DTUIMessages.database_consumer_wizard_checkbox_multi_insert_skip_bind_values_description, (boolean)settings.isSkipBindValues(), (int)4);
            this.skipBindValues.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    settings.setSkipBindValues(DatabaseConsumerPageLoadSettings.this.skipBindValues.getSelection());
                }
            });
        } else {
            settings.setSkipBindValues(false);
        }
        this.useBatchCheck = UIUtils.createCheckbox((Composite)performanceSettings, (String)DTUIMessages.database_consumer_wizard_disable_import_batches_label, (String)DTUIMessages.database_consumer_wizard_disable_import_batches_description, (boolean)settings.isDisableUsingBatches(), (int)4);
        this.useBatchCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setDisableUsingBatches(DatabaseConsumerPageLoadSettings.this.useBatchCheck.getSelection());
                if (DatabaseConsumerPageLoadSettings.this.useBatchCheck.getSelection()) {
                    DatabaseConsumerPageLoadSettings.this.disableButton(useMultiRowInsert);
                    settings.setUseMultiRowInsert(false);
                    DatabaseConsumerPageLoadSettings.this.multiRowInsertBatch.setEnabled(false);
                    if (DatabaseConsumerPageLoadSettings.this.buttonIsAvailable(DatabaseConsumerPageLoadSettings.this.ignoreDuplicateRows)) {
                        if (DatabaseConsumerPageLoadSettings.this.buttonIsAvailable(DatabaseConsumerPageLoadSettings.this.useBulkLoadCheck)) {
                            if (!DatabaseConsumerPageLoadSettings.this.useBulkLoadCheck.getSelection()) {
                                DatabaseConsumerPageLoadSettings.this.ignoreDuplicateRows.setEnabled(true);
                            }
                        } else {
                            DatabaseConsumerPageLoadSettings.this.ignoreDuplicateRows.setEnabled(true);
                        }
                    }
                } else if (!DatabaseConsumerPageLoadSettings.this.useBatchCheck.getSelection()) {
                    if (!useMultiRowInsert.getEnabled()) {
                        useMultiRowInsert.setEnabled(true);
                    }
                    if (DatabaseConsumerPageLoadSettings.this.buttonIsAvailable(DatabaseConsumerPageLoadSettings.this.ignoreDuplicateRows) && DatabaseConsumerPageLoadSettings.this.ignoreDuplicateRows.getEnabled()) {
                        DatabaseConsumerPageLoadSettings.this.disableButton(DatabaseConsumerPageLoadSettings.this.ignoreDuplicateRows);
                        settings.setIgnoreDuplicateRows(false);
                    }
                }
            }
        });
        this.ignoreDuplicateRows = UIUtils.createCheckbox((Composite)performanceSettings, (String)DTUIMessages.database_consumer_wizard_ignore_duplicate_rows_label, (String)DTUIMessages.database_consumer_wizard_ignore_duplicate_rows_tip, (boolean)settings.isIgnoreDuplicateRows(), (int)4);
        if (this.buttonIsAvailable(this.useBatchCheck)) {
            boolean canIgnoreDuplicateRows = this.useBatchCheck.getSelection() && !settings.isUseBulkLoad();
            this.ignoreDuplicateRows.setEnabled(canIgnoreDuplicateRows);
            if (!canIgnoreDuplicateRows) {
                this.ignoreDuplicateRows.setSelection(false);
                settings.setIgnoreDuplicateRows(false);
            }
        }
        this.ignoreDuplicateRows.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setIgnoreDuplicateRows(DatabaseConsumerPageLoadSettings.this.ignoreDuplicateRows.getSelection());
            }
        });
        this.useBulkLoadCheck = UIUtils.createCheckbox((Composite)performanceSettings, (String)DTUIMessages.database_consumer_wizard_use_bulk_load_label, (String)DTUIMessages.database_consumer_wizard_use_bulk_load_description, (boolean)settings.isUseBulkLoad(), (int)4);
        this.useBulkLoadCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean checkSelection = DatabaseConsumerPageLoadSettings.this.useBulkLoadCheck.getSelection();
                settings.setUseBulkLoad(checkSelection);
                if (DatabaseConsumerPageLoadSettings.this.buttonIsAvailable(DatabaseConsumerPageLoadSettings.this.ignoreDuplicateRows)) {
                    if (checkSelection) {
                        DatabaseConsumerPageLoadSettings.this.disableButton(DatabaseConsumerPageLoadSettings.this.ignoreDuplicateRows);
                        settings.setIgnoreDuplicateRows(false);
                    } else if (DatabaseConsumerPageLoadSettings.this.buttonIsAvailable(DatabaseConsumerPageLoadSettings.this.useBatchCheck) && DatabaseConsumerPageLoadSettings.this.useBatchCheck.getSelection()) {
                        DatabaseConsumerPageLoadSettings.this.ignoreDuplicateRows.setEnabled(true);
                    }
                }
                DatabaseConsumerPageLoadSettings.this.onDuplicateKeyInsertMethods.setEnabled(!checkSelection);
            }
        });
        this.setControl((Control)composite);
    }

    private boolean buttonIsAvailable(Button button) {
        return button != null && !button.isDisposed();
    }

    private void disableButton(Button button) {
        button.setEnabled(false);
        button.setSelection(false);
    }

    private void loadUISettingsForDisableReferentialIntegrityCheckbox() {
        this.isDisablingReferentialIntegritySupported = false;
        this.disableReferentialIntegrityCheckboxTooltip = "";
        ArrayList<DBPReferentialIntegrityController> riControllers = new ArrayList<DBPReferentialIntegrityController>();
        for (DatabaseMappingContainer mappingContainer : this.getSettings().getDataMappings().values()) {
            if (!(mappingContainer.getTarget() instanceof DBPReferentialIntegrityController)) continue;
            riControllers.add((DBPReferentialIntegrityController)mappingContainer.getTarget());
        }
        if (!riControllers.isEmpty()) {
            try {
                ((DataTransferWizard)this.getWizard()).getRunnableContext().run(false, false, monitor -> {
                    LinkedHashSet<String> statements = new LinkedHashSet<String>();
                    for (DBPReferentialIntegrityController controller : riControllers) {
                        try {
                            if (!controller.supportsChangingReferentialIntegrity(monitor)) continue;
                            this.isDisablingReferentialIntegritySupported = true;
                            statements.add(controller.getChangeReferentialIntegrityStatement(monitor, false));
                            statements.add(controller.getChangeReferentialIntegrityStatement(monitor, true));
                        }
                        catch (DBException e) {
                            log.debug((Object)"Unexpected error when calculating UI options for 'Disable referential integrity' checkbox", (Throwable)e);
                        }
                    }
                    if (!statements.isEmpty()) {
                        StringJoiner tooltip = new StringJoiner(System.lineSeparator(), DTUIMessages.database_consumer_wizard_disable_referential_integrity_tip_start + System.lineSeparator(), "");
                        statements.forEach(tooltip::add);
                        this.disableReferentialIntegrityCheckboxTooltip = tooltip.toString();
                    }
                });
            }
            catch (InvocationTargetException e) {
                log.debug((Object)"Unexpected error", e.getTargetException());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private DatabaseConsumerSettings getSettings() {
        return ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, DatabaseConsumerSettings.class);
    }

    public void activatePage() {
        DatabaseConsumerSettings settings = this.getSettings();
        for (Map.Entry<String, EventProcessorComposite<?>> processor : this.processors.entrySet()) {
            processor.getValue().setProcessorEnabled(settings.hasEventProcessor(processor.getKey()));
            processor.getValue().loadSettings(settings.getEventProcessorSettings(processor.getKey()));
        }
        this.updatePageCompletion();
        this.updateControlsEnablement();
        UIUtils.syncExec(this::loadSettings);
    }

    private void loadSettings() {
        DatabaseConsumerSettings settings = this.getSettings();
        if (settings.isTruncateBeforeLoad() && !this.confirmDataTruncate()) {
            this.truncateTargetTable.setSelection(false);
            settings.setTruncateBeforeLoad(false);
        }
        if (this.buttonIsAvailable(this.useBulkLoadCheck)) {
            DBPDataSource dataSource;
            DBPDataSource dBPDataSource = dataSource = settings.getContainer() == null ? null : settings.getContainer().getDataSource();
            if (DBUtils.getAdapter(DBSDataBulkLoader.class, (Object)dataSource) == null) {
                this.disableButton(this.useBulkLoadCheck);
                settings.setUseBulkLoad(false);
            }
        }
        this.loadInsertMethods();
        this.onDuplicateKeyInsertMethods.setEnabled(!this.useBulkLoadCheck.getSelection());
    }

    private boolean confirmDataTruncate() {
        Shell shell = this.getContainer().getShell();
        if (shell == null) {
            return true;
        }
        if (shell.isVisible() || this.getSettings().isTruncateBeforeLoad()) {
            String tableNames = ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes().stream().map(pipe -> pipe.getConsumer() == null ? "" : pipe.getConsumer().getObjectName()).collect(Collectors.joining(","));
            String checkbox_question = NLS.bind((String)DTUIMessages.database_consumer_wizard_truncate_checkbox_question, (Object)tableNames);
            return UIUtils.confirmAction((Shell)shell, (String)DTUIMessages.database_consumer_wizard_truncate_checkbox_title, (String)checkbox_question, (DBPImage)DBIcon.STATUS_WARNING);
        }
        return true;
    }

    private void loadInsertMethods() {
        SQLDialectMetadata dialectDescriptor;
        DatabaseConsumerSettings settings = this.getSettings();
        DBSObjectContainer container = settings.getContainer();
        if (container == null) {
            return;
        }
        DBPDataSource dataSource = container.getDataSource();
        List insertMethodsDescriptors = null;
        if (dataSource != null && (dialectDescriptor = DBWorkbench.getPlatform().getSQLDialectRegistry().getDialect(dataSource.getSQLDialect().getDialectId())) != null) {
            insertMethodsDescriptors = dialectDescriptor.getSupportedInsertReplaceMethodsDescriptors();
        }
        this.onDuplicateKeyInsertMethods.removeAll();
        this.onDuplicateKeyInsertMethods.add("<None>");
        if (!CommonUtils.isEmpty(insertMethodsDescriptors)) {
            boolean emptyButton = true;
            for (SQLDialectInsertReplaceMethod insertMethod : insertMethodsDescriptors) {
                this.onDuplicateKeyInsertMethods.add(insertMethod.getLabel());
                if (!insertMethod.getId().equals(settings.getOnDuplicateKeyInsertMethodId())) continue;
                this.onDuplicateKeyInsertMethods.setText(insertMethod.getLabel());
                emptyButton = false;
            }
            if (emptyButton) {
                this.onDuplicateKeyInsertMethods.setText("<None>");
                if (!CommonUtils.isEmpty((String)settings.getOnDuplicateKeyInsertMethodId())) {
                    settings.setOnDuplicateKeyInsertMethodId(null);
                }
            }
        } else {
            this.onDuplicateKeyInsertMethods.setText("<None>");
            this.onDuplicateKeyInsertMethods.setEnabled(false);
            settings.setOnDuplicateKeyInsertMethodId(null);
        }
        this.availableInsertMethodsDescriptors = insertMethodsDescriptors;
    }

    public void deactivatePage() {
        DatabaseConsumerSettings settings = this.getSettings();
        for (Map.Entry<String, EventProcessorComposite<?>> processor : this.processors.entrySet()) {
            EventProcessorComposite<?> configurator = processor.getValue();
            if (!configurator.isProcessorEnabled() || !configurator.isProcessorApplicable() || !configurator.isProcessorComplete()) continue;
            configurator.saveSettings(settings.getEventProcessorSettings(processor.getKey()));
        }
        super.deactivatePage();
    }

    protected boolean determinePageCompletion() {
        for (EventProcessorComposite<?> processor : this.processors.values()) {
            if (!processor.isProcessorApplicable() || !processor.isProcessorEnabled() || processor.isProcessorComplete()) continue;
            this.setErrorMessage(NLS.bind((String)DTMessages.data_transfer_wizard_output_event_processor_error_incomplete_configuration, (Object)processor.getDescriptor().getLabel()));
            return false;
        }
        return true;
    }

    public boolean isPageApplicable() {
        return this.isConsumerOfType(DatabaseTransferConsumer.class);
    }

    private void updateControlsEnablement() {
        for (EventProcessorComposite<?> processor : this.processors.values()) {
            processor.setProcessorAvailable(processor.isProcessorApplicable());
        }
    }
}

