/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.openai;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.concurrent.SubmissionPublisher;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.TooManyRequestsException;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIRequestFilter;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.ChatCompletionChunk;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.ChatCompletionRequest;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.ChatCompletionResult;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.Model;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.ModelList;
import org.jkiss.dbeaver.model.ai.utils.AIHttpUtils;
import org.jkiss.dbeaver.model.ai.utils.MonitoredHttpClient;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class OpenAIClient
implements Closeable {
    public static final String OPENAI_ENDPOINT = "https://api.openai.com/v1/";
    private static final String DATA_EVENT = "data: ";
    private static final String DONE_EVENT = "[DONE]";
    private static final Duration TIMEOUT = Duration.ofSeconds(30L);
    private static final Gson GSON = new GsonBuilder().create();
    private final String baseUrl;
    private final List<HttpRequestFilter> requestFilters;
    private final MonitoredHttpClient client = new MonitoredHttpClient(HttpClient.newBuilder().build());

    public OpenAIClient(@NotNull String baseUrl, @NotNull List<HttpRequestFilter> requestFilters) {
        this.baseUrl = baseUrl;
        this.requestFilters = requestFilters;
    }

    @NotNull
    public HttpClient getHttpClient() {
        return this.client.getHttpClient();
    }

    public static OpenAIClient createClient(String token) {
        return new OpenAIClient(OPENAI_ENDPOINT, List.of(new OpenAIRequestFilter(token)));
    }

    @NotNull
    public List<Model> getModels(@NotNull DBRProgressMonitor monitor) throws DBException {
        HttpRequest request = HttpRequest.newBuilder().uri(AIHttpUtils.resolve(this.baseUrl, "models")).GET().timeout(TIMEOUT).build();
        HttpRequest modifiedRequest = this.applyFilters(request);
        HttpResponse<String> response = this.client.send(monitor, modifiedRequest);
        if (response.statusCode() == 200) {
            return ((ModelList)GSON.fromJson(response.body(), ModelList.class)).data();
        }
        throw new DBException("Request failed: " + response.statusCode() + ", body=" + response.body());
    }

    @NotNull
    public ChatCompletionResult createChatCompletion(@NotNull DBRProgressMonitor monitor, @NotNull ChatCompletionRequest completionRequest) throws DBException {
        HttpRequest request = HttpRequest.newBuilder().uri(AIHttpUtils.resolve(this.baseUrl, "chat/completions")).POST(HttpRequest.BodyPublishers.ofString(OpenAIClient.serializeValue(completionRequest))).timeout(TIMEOUT).build();
        HttpRequest modifiedRequest = this.applyFilters(request);
        HttpResponse<String> response = this.client.send(monitor, modifiedRequest);
        if (response.statusCode() == 200) {
            return (ChatCompletionResult)GSON.fromJson(response.body(), ChatCompletionResult.class);
        }
        if (response.statusCode() == 429) {
            throw new TooManyRequestsException("Too many requests: " + response.body());
        }
        throw new DBException("Request failed: " + response.statusCode() + ", body=" + response.body());
    }

    @NotNull
    public Flow.Publisher<ChatCompletionChunk> createChatCompletionStream(@NotNull DBRProgressMonitor monitor, @NotNull ChatCompletionRequest completionRequest) throws DBException {
        HttpRequest request = HttpRequest.newBuilder().uri(AIHttpUtils.resolve(this.baseUrl, "chat/completions")).POST(HttpRequest.BodyPublishers.ofString(OpenAIClient.serializeValue(completionRequest))).timeout(TIMEOUT).build();
        HttpRequest modifiedRequest = this.applyFilters(request);
        SubmissionPublisher<ChatCompletionChunk> publisher = new SubmissionPublisher<ChatCompletionChunk>();
        this.client.sendAsync(modifiedRequest, event -> {
            if (event.startsWith(DATA_EVENT)) {
                String data = event.substring(6).trim();
                if (DONE_EVENT.equals(data)) {
                    publisher.close();
                } else {
                    try {
                        ChatCompletionChunk chunk = (ChatCompletionChunk)GSON.fromJson(data, ChatCompletionChunk.class);
                        publisher.submit(chunk);
                    }
                    catch (Exception e) {
                        publisher.closeExceptionally(e);
                    }
                }
            }
        }, publisher::closeExceptionally, publisher::close);
        return publisher;
    }

    @Override
    public void close() {
        this.client.close();
    }

    public HttpRequest applyFilters(@NotNull HttpRequest request) throws DBException {
        return this.applyFilters(request, true);
    }

    public HttpRequest applyFilters(@NotNull HttpRequest request, boolean setContentType) throws DBException {
        for (HttpRequestFilter filter : this.requestFilters) {
            request = filter.filter(request, setContentType);
        }
        return request;
    }

    @Nullable
    private static String serializeValue(@Nullable Object value) throws DBException {
        try {
            return GSON.toJson(value);
        }
        catch (Exception e) {
            throw new DBException("Error serializing value", (Throwable)e);
        }
    }

    public static interface HttpRequestFilter {
        @NotNull
        public HttpRequest filter(@NotNull HttpRequest var1, boolean var2) throws DBException;
    }
}

