/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.ai.AIQueryConfirmationRule;
import org.jkiss.dbeaver.model.ai.internal.AIMessages;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.model.sql.SQLQueryCategory;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.dbeaver.model.struct.rdb.DBSTrigger;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public final class AIUtils {
    public static final int TOKEN_TO_CHAR_RATIO = 2;
    private static final Log log = Log.getLog(AIUtils.class);

    public static String getSecretValueOrDefault(@NotNull String secretId, @Nullable String defaultValue) throws DBException {
        String secretValue = DBSSecretController.getGlobalSecretController().getPrivateSecretValue(secretId);
        if (CommonUtils.isEmpty((String)secretValue)) {
            return defaultValue;
        }
        return secretValue;
    }

    public static int countTokens(@NotNull List<AIMessage> messages) {
        int count = 0;
        for (AIMessage message : messages) {
            count += AIUtils.countContentTokens(message.getContent());
        }
        return count;
    }

    @NotNull
    public static List<AIMessage> truncateMessages(@NotNull List<AIMessage> messages, int maxTokens) {
        ArrayList<AIMessage> pending = new ArrayList<AIMessage>(AIUtils.filterEmptyMessages(messages));
        ArrayList<AIMessage> truncated = new ArrayList<AIMessage>();
        int remainingTokens = maxTokens - 20;
        if (pending.isEmpty()) {
            return truncated;
        }
        if (pending.size() == 1) {
            AIMessage singleMessage = (AIMessage)pending.getFirst();
            if (AIUtils.countContentTokens(singleMessage.getContent()) <= remainingTokens) {
                return List.of(singleMessage);
            }
            return List.of(AIUtils.truncateMessage(singleMessage, remainingTokens));
        }
        if (((AIMessage)pending.getFirst()).getRole() == AIMessageType.SYSTEM) {
            AIMessage msg = (AIMessage)pending.removeFirst();
            AIMessage truncatedMessage = AIUtils.truncateMessage(msg, remainingTokens - 50);
            remainingTokens -= AIUtils.countContentTokens(truncatedMessage.getContent());
            truncated.add(msg);
        }
        for (AIMessage message : pending) {
            int messageTokens = message.getContent().length();
            if (remainingTokens < 0 || messageTokens > remainingTokens) break;
            AIMessage truncatedMessage = AIUtils.truncateMessage(message, remainingTokens);
            remainingTokens -= AIUtils.countContentTokens(truncatedMessage.getContent());
            truncated.add(truncatedMessage);
        }
        return truncated;
    }

    private static AIMessage truncateMessage(AIMessage message, int remainingTokens) {
        String content = message.getContent();
        int contentTokens = AIUtils.countContentTokens(content);
        if (remainingTokens > contentTokens) {
            return message;
        }
        String truncatedContent = AIUtils.removeContentTokens(content, contentTokens - remainingTokens);
        return new AIMessage(message.getRole(), truncatedContent);
    }

    private static String removeContentTokens(String content, int tokensToRemove) {
        int charsToRemove = tokensToRemove * 2;
        if (charsToRemove >= content.length()) {
            return "";
        }
        return content.substring(0, content.length() - charsToRemove) + "..";
    }

    private static int countContentTokens(String content) {
        return content.length() / 2;
    }

    public static boolean isEligible(@Nullable DBPObject dbpObject) {
        if (dbpObject instanceof DataSourceDescriptor) {
            DataSourceDescriptor descriptor = (DataSourceDescriptor)dbpObject;
            return descriptor.getDriver().isEmbedded();
        }
        return dbpObject instanceof DBSEntity || dbpObject instanceof DBSSchema || dbpObject instanceof DBSTableColumn || dbpObject instanceof DBSProcedure || dbpObject instanceof DBSTrigger || dbpObject instanceof DBSEntityConstraint;
    }

    public static String getObjectDDL(@Nullable DBSObject object, @NotNull DBRProgressMonitor monitor) {
        if ((object instanceof DBSProcedure || object instanceof DBSTrigger || object instanceof DBSEntityConstraint || object instanceof DBSView) && object instanceof DBPScriptObject) {
            DBPScriptObject scriptObject = (DBPScriptObject)object;
            try {
                return scriptObject.getObjectDefinitionText(monitor, Map.of("ddl.includeComments", false, "ddl.includeNestedObjects", false, "ddl.skipIndexes", true, "ddl.skipDrops", true));
            }
            catch (DBException e) {
                log.debug((Object)e);
            }
        }
        return null;
    }

    public static boolean confirmExecutionIfNeeded(@NotNull List<SQLScriptElement> scriptElements, boolean isCommand) {
        boolean isDdlOrUnknown;
        Set queryCategories = SQLQueryCategory.categorizeScript(scriptElements);
        boolean bl = isDdlOrUnknown = queryCategories.contains(SQLQueryCategory.DDL) || queryCategories.contains(SQLQueryCategory.UNKNOWN);
        if (isDdlOrUnknown && AIUtils.isConfirmationNeeded("ai.confirmation.ddl")) {
            String message = isCommand ? AIMessages.ai_execute_command_confirm_ddl_message : AIMessages.ai_execute_query_confirm_ddl_message;
            return AIUtils.confirmExecute(AIMessages.ai_execute_query_title, message);
        }
        if (queryCategories.contains(SQLQueryCategory.DML) && AIUtils.isConfirmationNeeded("ai.confirmation.dml")) {
            String message = isCommand ? AIMessages.ai_execute_command_confirm_dml_message : AIMessages.ai_execute_query_confirm_dml_message;
            return AIUtils.confirmExecute(AIMessages.ai_execute_query_title, message);
        }
        if (queryCategories.contains(SQLQueryCategory.SQL) && AIUtils.isConfirmationNeeded("ai.confirmation.sql")) {
            String message = isCommand ? AIMessages.ai_execute_command_confirm_sql_message : AIMessages.ai_execute_query_confirm_sql_message;
            return AIUtils.confirmExecute(AIMessages.ai_execute_query_title, message);
        }
        return true;
    }

    public static void disableAutoCommitIfNeeded(@NotNull DBRProgressMonitor monitor, @NotNull List<SQLScriptElement> scriptElements, @Nullable DBCExecutionContext context) throws DBException {
        DBCTransactionManager txnManager;
        if (!SQLQueryCategory.categorizeScript(scriptElements).contains(SQLQueryCategory.DML)) {
            return;
        }
        AIQueryConfirmationRule dmlRule = (AIQueryConfirmationRule)CommonUtils.valueOf(AIQueryConfirmationRule.class, (String)DBWorkbench.getPlatform().getPreferenceStore().getString("ai.confirmation.dml"), (Enum)AIQueryConfirmationRule.CONFIRM);
        if (dmlRule == AIQueryConfirmationRule.DISABLE_AUTOCOMMIT && (txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context)) != null && txnManager.isAutoCommit()) {
            txnManager.setAutoCommit(monitor, false);
            AIUtils.showAutoCommitDisabledNotification();
        }
    }

    private static List<AIMessage> filterEmptyMessages(@NotNull List<AIMessage> messages) {
        return messages.stream().filter(message -> !message.getContent().isBlank()).toList();
    }

    private static void showAutoCommitDisabledNotification() {
        DBWorkbench.getPlatformUI().showWarningNotification(AIMessages.ai_execute_query_auto_commit_disabled_title, AIMessages.ai_execute_query_auto_commit_disabled_message);
    }

    private static boolean isConfirmationNeeded(@NotNull String actionName) {
        return CommonUtils.valueOf(AIQueryConfirmationRule.class, (String)DBWorkbench.getPlatform().getPreferenceStore().getString(actionName), (Enum)AIQueryConfirmationRule.CONFIRM) == AIQueryConfirmationRule.CONFIRM;
    }

    private static boolean confirmExecute(String title, String message) {
        return DBWorkbench.getPlatformUI().confirmAction(title, message, true);
    }
}

