/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.commands;

import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.ai.AIBaseFeatures;
import org.jkiss.dbeaver.model.ai.AICommandRequest;
import org.jkiss.dbeaver.model.ai.AICommandResult;
import org.jkiss.dbeaver.model.ai.AICompletionSettings;
import org.jkiss.dbeaver.model.ai.AIDatabaseScope;
import org.jkiss.dbeaver.model.ai.AITextUtils;
import org.jkiss.dbeaver.model.ai.engine.AIDatabaseContext;
import org.jkiss.dbeaver.model.ai.registry.AIAssistantRegistry;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.output.DBCOutputSeverity;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLControlCommandHandler;
import org.jkiss.dbeaver.model.sql.SQLControlResult;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLScript;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLScriptParser;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class SQLCommandAI
implements SQLControlCommandHandler {
    private static final DBCOutputSeverity AI_OUTPUT_SEVERITY = new DBCOutputSeverity(){

        @NotNull
        public String getName() {
            return "AI";
        }

        public boolean isForced() {
            return true;
        }
    };

    @NotNull
    public SQLControlResult handleCommand(@NotNull DBRProgressMonitor monitor, @NotNull SQLControlCommand command, @NotNull SQLScriptContext scriptContext) throws DBException {
        DBCExecutionContext executionContext;
        DBPDataSource dataSource = command.getDataSource();
        if (dataSource == null) {
            throw new DBException("Not connected to database");
        }
        String prompt = command.getParameter();
        if (CommonUtils.isEmptyTrimmed((String)prompt)) {
            throw new DBException("Empty AI prompt");
        }
        AIBaseFeatures.SQL_AI_COMMAND.use();
        DBSLogicalDataSource lDataSource = new DBSLogicalDataSource(command.getDataSourceContainer(), "AI logical wrapper", null);
        DBPDataSourceContainer dataSourceContainer = lDataSource.getDataSourceContainer();
        AICompletionSettings completionSettings = new AICompletionSettings(dataSourceContainer);
        if (!DBWorkbench.getPlatform().getApplication().isHeadlessMode() && !completionSettings.isMetaTransferConfirmed()) {
            if (DBWorkbench.getPlatformUI().confirmAction("Do you confirm AI usage", "Do you confirm AI usage for '" + dataSourceContainer.getName() + "'?")) {
                completionSettings.setMetaTransferConfirmed(true);
                completionSettings.saveSettings();
            } else {
                throw new DBException("AI services restricted for '" + dataSourceContainer.getName() + "'");
            }
        }
        AIDatabaseScope scope = completionSettings.getScope();
        AIDatabaseContext.Builder contextBuilder = new AIDatabaseContext.Builder(lDataSource);
        if (scope != null) {
            contextBuilder.setScope(scope);
        }
        if ((executionContext = scriptContext.getExecutionContext()) != null) {
            contextBuilder.setExecutionContext(executionContext);
        }
        if (scope == AIDatabaseScope.CUSTOM && completionSettings.getCustomObjectIds() != null) {
            contextBuilder.setCustomEntities(AITextUtils.loadCustomEntities(monitor, dataSource, Set.of(completionSettings.getCustomObjectIds())));
        }
        AIDatabaseContext aiContext = contextBuilder.build();
        AICommandResult result = AIAssistantRegistry.getInstance().createAssistant(dataSourceContainer.getProject().getWorkspace()).command(monitor, new AICommandRequest(prompt, aiContext));
        String script = result.sql();
        if (script == null) {
            if (!CommonUtils.isEmpty((String)result.message())) {
                throw new DBException(result.message());
            }
            throw new DBException("Empty AI response for '" + prompt + "'");
        }
        SQLDialect dialect = SQLUtils.getDialectFromObject((DBPObject)dataSource);
        if (!script.contains("\n") && SQLUtils.isCommentLine((SQLDialect)dialect, (String)script)) {
            throw new DBException(script);
        }
        List scriptElements = SQLScriptParser.parseScript((DBPDataSource)dataSource, (String)script);
        if (!AIUtils.confirmExecutionIfNeeded(scriptElements, true)) {
            return SQLControlResult.failure();
        }
        AIUtils.disableAutoCommitIfNeeded(monitor, scriptElements, scriptContext.getExecutionContext());
        scriptContext.getOutputWriter().println(AI_OUTPUT_SEVERITY, prompt + " ==> " + script + "\n");
        if (scriptElements.size() == 1) {
            return SQLControlResult.transform((SQLScriptElement)new SQLQuery(dataSource, script));
        }
        return SQLControlResult.transform((SQLScriptElement)new SQLScript(dataSource, script, scriptElements));
    }
}

