/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.openai.dto;

import com.google.gson.annotations.SerializedName;
import java.util.function.Function;
import org.jkiss.code.NotNull;

public class ChatFunction {
    @NotNull
    private String name;
    private String description;
    @SerializedName(value="parameters")
    private Class<?> parametersClass;
    private transient Function<Object, Object> executor;

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String description;
        private Class<?> parameters;
        private Function<Object, Object> executor;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public <T> Builder executor(Class<T> requestClass, Function<T, Object> executor) {
            this.parameters = requestClass;
            this.executor = executor;
            return this;
        }

        public ChatFunction build() {
            ChatFunction chatFunction = new ChatFunction();
            chatFunction.name = this.name;
            chatFunction.description = this.description;
            chatFunction.parametersClass = this.parameters;
            chatFunction.executor = this.executor;
            return chatFunction;
        }
    }
}

