/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.impls;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreServerExtension;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.utils.CommonUtils;

public class PostgreServerType
extends AbstractDescriptor {
    private final AbstractDescriptor.ObjectType type;
    private final String id;
    private final String name;
    private final DBPImage icon;
    private final boolean cloudServer;
    private final boolean supportsClient;
    private final boolean needsPort;
    private final boolean supportsCustomConnectionURL;
    private final boolean turnOffPreparedStatements;

    PostgreServerType(IConfigurationElement config) {
        super(config);
        this.type = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("name");
        this.icon = this.iconToImage(config.getAttribute("logo"));
        this.supportsCustomConnectionURL = CommonUtils.getBoolean((String)config.getAttribute("customURL"), (boolean)false);
        this.cloudServer = CommonUtils.getBoolean((String)config.getAttribute("cloudServer"), (boolean)false);
        this.supportsClient = CommonUtils.getBoolean((String)config.getAttribute("supportsClient"), (boolean)true);
        this.needsPort = CommonUtils.getBoolean((String)config.getAttribute("needsPort"), (boolean)true);
        this.turnOffPreparedStatements = CommonUtils.getBoolean((String)config.getAttribute("turnOffPreparedStatements"), (boolean)false);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public PostgreServerExtension createServerExtension(PostgreDataSource dataSource) throws DBException {
        try {
            return (PostgreServerExtension)this.type.getObjectClass().getConstructor(PostgreDataSource.class).newInstance(new Object[]{dataSource});
        }
        catch (Throwable e) {
            throw new DBException("Error instantiating PG server type", e);
        }
    }

    public boolean supportsCustomConnectionURL() {
        return this.supportsCustomConnectionURL;
    }

    public boolean isCloudServer() {
        return this.cloudServer;
    }

    public boolean supportsClient() {
        return this.supportsClient;
    }

    public boolean needsPort() {
        return this.needsPort;
    }

    public boolean turnOffPreparedStatements() {
        return this.turnOffPreparedStatements;
    }
}

