/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm.meta;

import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMetaObjectType;

public class QMMStatementInfo
extends QMMObject {
    private final QMMConnectionInfo connection;
    private final DBCExecutionPurpose purpose;
    private final transient QMMStatementInfo previous;
    private transient DBCStatement reference;

    public QMMStatementInfo(QMMConnectionInfo connection, DBCStatement reference, QMMStatementInfo previous) {
        super(QMMetaObjectType.STATEMENT_INFO);
        this.connection = connection;
        this.reference = reference;
        this.purpose = reference.getSession().getPurpose();
        this.previous = previous;
    }

    public QMMStatementInfo(long openTime, long closeTime, QMMConnectionInfo session, DBCExecutionPurpose purpose) {
        super(QMMetaObjectType.STATEMENT_INFO, openTime, closeTime);
        this.connection = session;
        this.purpose = purpose;
        this.previous = null;
    }

    @Override
    public void close() {
        super.close();
        this.reference = null;
    }

    @Override
    public String getText() {
        return this.connection.getText();
    }

    DBCStatement getReference() {
        return this.reference;
    }

    @Override
    public QMMConnectionInfo getConnection() {
        return this.connection;
    }

    public DBCExecutionPurpose getPurpose() {
        return this.purpose;
    }

    public QMMStatementInfo getPrevious() {
        return this.previous;
    }

    public String toString() {
        return "STATEMENT";
    }
}

