/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.task;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPPlatformEventManager;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.task.DBTScheduler;
import org.jkiss.dbeaver.model.task.DBTSchedulerDescriptor;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskCategory;
import org.jkiss.dbeaver.model.task.DBTTaskEvent;
import org.jkiss.dbeaver.model.task.DBTTaskFolderEvent;
import org.jkiss.dbeaver.model.task.DBTTaskListener;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.model.task.DBTTaskRegistry;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.SchedulerDescriptor;
import org.jkiss.dbeaver.registry.task.TaskCategoryDescriptor;
import org.jkiss.dbeaver.registry.task.TaskTypeDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class TaskRegistry
implements DBTTaskRegistry {
    public static final String TASK_EXTENSION_ID = "org.jkiss.dbeaver.task";
    private static final Log log = Log.getLog(TaskRegistry.class);
    private static TaskRegistry instance = null;
    private final Map<String, TaskCategoryDescriptor> taskCategories = new LinkedHashMap<String, TaskCategoryDescriptor>();
    private final Map<String, TaskTypeDescriptor> taskDescriptors = new LinkedHashMap<String, TaskTypeDescriptor>();
    private final List<DBTTaskListener> taskListeners = new ArrayList<DBTTaskListener>();
    private final List<SchedulerDescriptor> schedulers = new ArrayList<SchedulerDescriptor>();

    public static synchronized TaskRegistry getInstance() {
        if (instance == null) {
            instance = new TaskRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private TaskRegistry(IExtensionRegistry registry) {
        AbstractContextDescriptor descriptor;
        IConfigurationElement ext;
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(TASK_EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray[n2];
            if ("category".equals(ext.getName())) {
                descriptor = new TaskCategoryDescriptor(this, ext);
                this.taskCategories.put(descriptor.getId(), (TaskCategoryDescriptor)descriptor);
            }
            ++n2;
        }
        iConfigurationElementArray = extElements;
        n = extElements.length;
        n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray[n2];
            if ("task".equals(ext.getName())) {
                String typeId = ext.getAttribute("type");
                TaskCategoryDescriptor taskType = this.getTaskCategory(typeId);
                TaskTypeDescriptor taskDescriptor = new TaskTypeDescriptor(taskType, ext);
                this.taskDescriptors.put(taskDescriptor.getId(), taskDescriptor);
            }
            ++n2;
        }
        iConfigurationElementArray = extElements;
        n = extElements.length;
        n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray[n2];
            if ("scheduler".equals(ext.getName())) {
                descriptor = new SchedulerDescriptor(ext);
                this.schedulers.add((SchedulerDescriptor)descriptor);
            }
            ++n2;
        }
        if (DBWorkbench.getPlatform().getApplication().isMultiuser()) {
            return;
        }
        DBPPlatform dBPPlatform = DBWorkbench.getPlatform();
        if (dBPPlatform instanceof DBPPlatformEventManager) {
            DBPPlatformEventManager eventManager = (DBPPlatformEventManager)dBPPlatform;
            eventManager.getGlobalEventManager().addEventListener((eventId, properties) -> {
                DBTTask task;
                String projectName;
                if (eventId.equals("taskExecuted")) {
                    projectName = CommonUtils.toString(properties.get("project"));
                    String taskId = CommonUtils.toString(properties.get("taskId"));
                    DBPProject project = DBWorkbench.getPlatform().getWorkspace().getProject(projectName);
                    if (project != null) {
                        task = project.getTaskManager().getTaskById(taskId);
                        if (task != null) {
                            task.refreshRunStatistics();
                        }
                        DBTTaskEvent event = new DBTTaskEvent(task, DBTTaskEvent.Action.TASK_EXECUTE);
                        this.notifyTaskListeners(event);
                    }
                }
                if (eventId.equals("beforeProjectDelete")) {
                    projectName = CommonUtils.toString(properties.get("project"));
                    DBPProject project = DBWorkbench.getPlatform().getWorkspace().getProject(projectName);
                    if (project != null) {
                        DBTTaskManager manager = project.getTaskManager();
                        DBTTask[] dBTTaskArray = manager.getAllTasks();
                        int n = dBTTaskArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            task = dBTTaskArray[n2];
                            try {
                                manager.deleteTaskConfiguration(task);
                            }
                            catch (DBException dBException) {
                                log.warn((Object)("Can't delete configuration for task: " + task.getName()));
                            }
                            ++n2;
                        }
                    }
                }
            });
        }
    }

    @NotNull
    public DBTTaskType[] getAllTaskTypes() {
        return this.taskDescriptors.values().toArray(new DBTTaskType[0]);
    }

    @Nullable
    public TaskTypeDescriptor getTaskType(String id) {
        return this.taskDescriptors.get(id);
    }

    @NotNull
    public DBTTaskCategory[] getAllCategories() {
        return this.taskCategories.values().toArray(new DBTTaskCategory[0]);
    }

    @NotNull
    public DBTTaskCategory[] getRootCategories() {
        ArrayList<TaskCategoryDescriptor> result = new ArrayList<TaskCategoryDescriptor>();
        for (TaskCategoryDescriptor cat : this.taskCategories.values()) {
            if (cat.getParent() != null) continue;
            result.add(cat);
        }
        return result.toArray(new DBTTaskCategory[0]);
    }

    @NotNull
    public DBTSchedulerDescriptor[] getAllSchedulers() {
        return this.schedulers.toArray(new DBTSchedulerDescriptor[0]);
    }

    public DBTSchedulerDescriptor getActiveScheduler() {
        return this.schedulers.stream().filter(SchedulerDescriptor::isEnabled).findFirst().orElse(null);
    }

    @Nullable
    public DBTScheduler getActiveSchedulerInstance() {
        DBTSchedulerDescriptor activeScheduler = this.getActiveScheduler();
        if (activeScheduler != null) {
            try {
                return activeScheduler.getInstance();
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskListener(DBTTaskListener listener) {
        List<DBTTaskListener> list = this.taskListeners;
        synchronized (list) {
            this.taskListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskListener(DBTTaskListener listener) {
        List<DBTTaskListener> list = this.taskListeners;
        synchronized (list) {
            if (!this.taskListeners.remove(listener)) {
                log.debug((Object)("Task listener " + String.valueOf(listener) + " not found"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTaskListeners(DBTTaskEvent event) {
        DBTTaskListener[] listenersCopy;
        List<DBTTaskListener> list = this.taskListeners;
        synchronized (list) {
            listenersCopy = this.taskListeners.toArray(new DBTTaskListener[0]);
        }
        DBTTaskListener[] dBTTaskListenerArray = listenersCopy;
        int n = listenersCopy.length;
        int n2 = 0;
        while (n2 < n) {
            DBTTaskListener listener = dBTTaskListenerArray[n2];
            listener.handleTaskEvent(event);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTaskFoldersListeners(DBTTaskFolderEvent event) {
        DBTTaskListener[] listenersCopy;
        List<DBTTaskListener> list = this.taskListeners;
        synchronized (list) {
            listenersCopy = this.taskListeners.toArray(new DBTTaskListener[0]);
        }
        DBTTaskListener[] dBTTaskListenerArray = listenersCopy;
        int n = listenersCopy.length;
        int n2 = 0;
        while (n2 < n) {
            DBTTaskListener listener = dBTTaskListenerArray[n2];
            listener.handleTaskFolderEvent(event);
            ++n2;
        }
    }

    @Nullable
    TaskCategoryDescriptor getTaskCategory(String id) {
        return this.taskCategories.get(id);
    }
}

