/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai.engine.openai;

import java.util.List;
import java.util.Locale;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.AIEngine;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.AIModelFeature;
import org.jkiss.dbeaver.model.ai.engine.LegacyAISettings;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIBaseProperties;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAICompletionEngine;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIModels;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIProperties;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.engine.openai.ContextWindowSizeField;
import org.jkiss.dbeaver.ui.ai.engine.openai.ModelSelectorField;
import org.jkiss.dbeaver.ui.ai.internal.AIUIMessages;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.function.ThrowableFunction;

public class OpenAiConfigurator<ENGINE extends AIEngine, PROPERTIES extends OpenAIProperties>
implements IObjectPropertyConfigurator<ENGINE, LegacyAISettings<PROPERTIES>> {
    private static final String API_KEY_URL = "https://platform.openai.com/account/api-keys";
    protected volatile String token = "";
    private String temperature = "0.0";
    private boolean logQuery = false;
    @Nullable
    protected Text tokenText;
    private Text temperatureText;
    private ModelSelectorField modelSelectorField;
    private ContextWindowSizeField contextWindowSizeField;
    private Button logQueryCheck;
    protected final CachedValue<List<AIModel>> modelsCache = new CachedValue(this::fetchOpenAiModels);

    public void createControl(@NotNull Composite parent, AIEngine object, @NotNull Runnable propertyChangeListener) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)3);
        composite.setLayoutData((Object)new GridData(768));
        this.createConnectionParameters(composite);
        this.createModelParameters(composite);
        this.createAdditionalSettings(composite);
        UIUtils.syncExec(this::applySettings);
    }

    public void loadSettings(@NotNull LegacyAISettings<PROPERTIES> configuration) {
        this.token = CommonUtils.toString((Object)((OpenAIProperties)configuration.getProperties()).getToken());
        this.modelSelectorField.setSelectedModel(CommonUtils.toString((Object)((OpenAIProperties)configuration.getProperties()).getModel(), (String)"gpt-4o"));
        this.temperature = CommonUtils.toString((Object)((OpenAIProperties)configuration.getProperties()).getTemperature(), (String)"0.0");
        this.logQuery = CommonUtils.toBoolean((Object)((OpenAIProperties)configuration.getProperties()).isLoggingEnabled());
        this.applySettings();
        this.contextWindowSizeField.setValue(((OpenAIProperties)configuration.getProperties()).getContextWindowSize());
        this.modelSelectorField.refreshModelListSilently(false);
    }

    public void saveSettings(@NotNull LegacyAISettings<PROPERTIES> configuration) {
        ((OpenAIProperties)configuration.getProperties()).setToken(this.token);
        ((OpenAIProperties)configuration.getProperties()).setModel(this.modelSelectorField.getSelectedModel());
        ((OpenAIProperties)configuration.getProperties()).setContextWindowSize(this.contextWindowSizeField.getValue());
        ((OpenAIProperties)configuration.getProperties()).setTemperature(Double.parseDouble(this.temperature));
        ((OpenAIProperties)configuration.getProperties()).setLoggingEnabled(this.logQuery);
    }

    public void resetSettings(@NotNull LegacyAISettings<PROPERTIES> openAIPropertiesLegacyAISettings) {
    }

    protected void createAdditionalSettings(@NotNull Composite parent) {
        this.logQueryCheck = UIUtils.createCheckbox((Composite)parent, (String)"Write AI queries to debug log", (String)"Write AI queries with metadata info in debug logs", (boolean)false, (int)2);
        this.logQueryCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenAiConfigurator.this.logQuery = OpenAiConfigurator.this.logQueryCheck.getSelection();
            }
        });
    }

    protected void createModelParameters(@NotNull Composite parent) {
        this.modelSelectorField = ModelSelectorField.builder().withParent(parent).withGridData(new GridData(768)).withModelListSupplier((monitor, forceRefresh) -> this.modelsCache.get(monitor, forceRefresh).stream().filter(it -> it.features().contains(AIModelFeature.CHAT)).map(AIModel::name).toList()).withSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.contextWindowSizeField.setValue(OpenAIModels.getContextWindowSize((String)this.modelSelectorField.getSelectedModel())))).build();
        this.contextWindowSizeField = ContextWindowSizeField.builder().withParent(parent).withGridData(GridDataFactory.fillDefaults().span(2, 1).create()).build();
        this.temperatureText = UIUtils.createLabelText((Composite)parent, (String)AIUIMessages.gpt_preference_page_text_temperature, (String)"0.0");
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        this.temperatureText.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        UIUtils.createInfoLabel((Composite)parent, (String)"Lower temperatures give more precise results", (int)768, (int)3);
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        this.temperatureText.addModifyListener(e -> {
            String string = this.temperature = this.temperatureText.getText();
        });
    }

    private List<AIModel> fetchOpenAiModels(DBRProgressMonitor monitor) throws DBException {
        if (this.token == null || this.token.isEmpty()) {
            throw new DBException("Token is not set");
        }
        OpenAIProperties properties = new OpenAIProperties();
        properties.setToken(this.token);
        Throwable throwable = null;
        Object var4_5 = null;
        try (OpenAICompletionEngine engine = new OpenAICompletionEngine((OpenAIBaseProperties)properties);){
            return engine.getModels(monitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void createConnectionParameters(@NotNull Composite parent) {
        this.tokenText = UIUtils.createLabelText((Composite)parent, (String)AIUIMessages.gpt_preference_page_selector_token, (String)"", (int)0x400800);
        GridData gd = new GridData(768);
        gd.widthHint = 150;
        this.tokenText.setLayoutData((Object)gd);
        this.tokenText.addModifyListener(e -> {
            String string = this.token = this.tokenText.getText();
        });
        this.tokenText.setMessage("API access token");
        this.createURLInfoLink(parent);
    }

    protected void createURLInfoLink(@NotNull Composite parent) {
        Link link = UIUtils.createLink((Composite)parent, (String)NLS.bind((String)AIUIMessages.gpt_preference_page_token_info, (Object)this.getApiKeyURL()), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.openWebBrowser((String)OpenAiConfigurator.this.getApiKeyURL());
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        link.setLayoutData((Object)gd);
    }

    protected String getApiKeyURL() {
        return API_KEY_URL;
    }

    protected void applySettings() {
        if (this.tokenText != null) {
            this.tokenText.setText(this.token);
        }
        this.temperatureText.setText(this.temperature);
        this.logQueryCheck.setSelection(this.logQuery);
    }

    public boolean isComplete() {
        return this.tokenText != null && !this.tokenText.getText().isEmpty() && this.contextWindowSizeField.isComplete();
    }

    protected static class CachedValue<T> {
        private volatile T value;
        private final ThrowableFunction<DBRProgressMonitor, T, DBException> supplier;

        protected CachedValue(ThrowableFunction<DBRProgressMonitor, T, DBException> supplier) {
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get(DBRProgressMonitor monitor, boolean refresh) throws DBException {
            if (this.value == null || refresh) {
                CachedValue cachedValue = this;
                synchronized (cachedValue) {
                    if (this.value == null || refresh) {
                        this.value = this.supplier.apply((Object)monitor);
                    }
                }
            }
            return this.value;
        }
    }
}

