/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.cli;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.cli.CommandLine;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.cli.CommandLineContext;
import org.jkiss.dbeaver.model.cli.ICommandLineParameterHandler;
import org.jkiss.dbeaver.model.impl.preferences.SimplePreferenceStore;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.translate.SQLQueryTranslator;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class SQLTranslatorHandler
implements ICommandLineParameterHandler {
    private static final Log log = Log.getLog(SQLTranslatorHandler.class);

    public void handleParameter(@NotNull CommandLine commandLine, @NotNull String name, String value, @NotNull CommandLineContext context) {
        String script;
        String[] args = value.split(",");
        if (args.length != 2) {
            throw new IllegalStateException("Input parameter format: dialect,<input-file-path>");
        }
        String cfr_ignored_0 = args[0];
        String inputFile = args[1];
        if (CommonUtils.isEmpty((String)inputFile)) {
            throw new IllegalStateException("Input file not specified");
        }
        SimplePreferenceStore preferenceStore = new SimplePreferenceStore(){

            public void save() throws IOException {
            }
        };
        preferenceStore.setValue("sql.format.formatter", "default");
        try {
            Throwable throwable = null;
            Object var10_11 = null;
            try (FileReader fr = new FileReader(inputFile);){
                script = IOUtils.readToString((Reader)fr);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening input file " + inputFile, e);
        }
        BasicSQLDialect srcDialect = new BasicSQLDialect(){};
        BasicSQLDialect targetDialect = new BasicSQLDialect(){};
        String result = null;
        try {
            result = SQLQueryTranslator.translateScript((SQLDialect)srcDialect, (SQLDialect)targetDialect, (DBPPreferenceStore)preferenceStore, (String)script);
        }
        catch (Exception e) {
            throw new RuntimeException("Error translating file " + inputFile, e);
        }
        System.out.println(result);
    }
}

