/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.ICategorizedThemeElementDefinition;
import org.eclipse.ui.internal.themes.IHierarchalThemeElementDefinition;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeElementCategory;
import org.eclipse.ui.internal.themes.WorkbenchThemeManager;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBIconBinary;
import org.jkiss.dbeaver.ui.DBeaverIcons;

public class FontPreferenceOverrides {
    public static void hideFontPrefs(PreferenceManager pm, Set<String> prefIdsToHide) {
        String wbPrefPageId = "org.eclipse.ui.preferencePages.Workbench";
        String viewsCatId = wbPrefPageId + "/org.eclipse.ui.preferencePages.Views";
        String fontsPrefPageId = wbPrefPageId + "/org.eclipse.ui.preferencePages.Views/org.eclipse.ui.preferencePages.ColorsAndFonts";
        IPreferenceNode catNode = pm.find(viewsCatId);
        IPreferenceNode rawFontsNode = pm.find(fontsPrefPageId);
        if (rawFontsNode instanceof PreferenceNode) {
            catNode.remove(rawFontsNode);
            catNode.add((IPreferenceNode)new FontPreferenceNodePageOverride((PreferenceNode)rawFontsNode, prefIdsToHide));
        }
    }

    public static void overrideFontPrefValues(final Map<String, List<String>> fontOverrides) {
        WorkbenchThemeManager.getInstance().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String fontPropertyId = event.getProperty();
                List fontIdsToOverride = (List)fontOverrides.get(fontPropertyId);
                if (fontIdsToOverride != null) {
                    FontRegistry fonts = WorkbenchThemeManager.getInstance().getCurrentTheme().getFontRegistry();
                    FontData[] data = fonts.getFontData(fontPropertyId);
                    for (String fontId : fontIdsToOverride) {
                        fonts.put(fontId, data);
                    }
                }
            }
        });
    }

    private static class FilteredThemeContentProvider
    implements ITreeContentProvider {
        private final Set<String> prefIdsToHide;
        private final Map<String, Object[]> categoryMap = new HashMap<String, Object[]>(7);
        private final IThemeRegistry themeRegistry = WorkbenchPlugin.getDefault().getThemeRegistry();
        private final IThemeManager themeManager;
        private IThemeRegistry registry;
        private IPropertyChangeListener themeChangeListener;
        private ITheme currentTheme;

        public FilteredThemeContentProvider(Set<String> prefIdsToHide) {
            this.prefIdsToHide = prefIdsToHide;
            this.themeManager = PlatformUI.getWorkbench().getThemeManager();
            this.themeChangeListener = event -> {
                if (event.getProperty().equals("CHANGE_CURRENT_THEME")) {
                    this.currentTheme = this.themeManager.getCurrentTheme();
                }
            };
            this.currentTheme = this.themeManager.getCurrentTheme();
            this.themeManager.addPropertyChangeListener(this.themeChangeListener);
        }

        private boolean isIdToHide(String id) {
            return id != null && this.prefIdsToHide.contains(id);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ThemeElementCategory) {
                String categoryId = ((ThemeElementCategory)parentElement).getId();
                Object[] defintions = this.categoryMap.get(categoryId);
                if (defintions == null) {
                    defintions = this.getCategoryChildren(categoryId);
                    this.categoryMap.put(categoryId, defintions);
                }
                return defintions;
            }
            ArrayList<ColorDefinition> list = new ArrayList<ColorDefinition>();
            IHierarchalThemeElementDefinition def = (IHierarchalThemeElementDefinition)parentElement;
            String id = def.getId();
            Object[] defs = def instanceof ColorDefinition ? this.registry.getColors() : this.registry.getFonts();
            ColorDefinition[] colorDefinitionArray = defs;
            int n = defs.length;
            int n2 = 0;
            while (n2 < n) {
                ColorDefinition elementDefinition = colorDefinitionArray[n2];
                if (id.equals(elementDefinition.getDefaultsTo()) && this.catIdEquals(((ICategorizedThemeElementDefinition)def).getCategoryId(), ((ICategorizedThemeElementDefinition)elementDefinition).getCategoryId())) {
                    list.add(elementDefinition);
                }
                ++n2;
            }
            return list.toArray();
        }

        private boolean catIdEquals(String string, String string2) {
            if (string == null && string2 == null) {
                return true;
            }
            if (string == null || string2 == null) {
                return false;
            }
            return string.equals(string2);
        }

        private Object[] getCategoryChildren(String categoryId) {
            FontDefinition[] fontDefinitions;
            ColorDefinition[] colorDefinitions;
            int n;
            if (this.isIdToHide(categoryId)) {
                return new Object[0];
            }
            ArrayList<Object> list = new ArrayList<Object>();
            if (categoryId != null) {
                ThemeElementCategory[] themeElementCategoryArray = this.registry.getCategories();
                n = themeElementCategoryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Set bindings;
                    ThemeElementCategory category = themeElementCategoryArray[n2];
                    if (categoryId.equals(category.getParentId()) && !this.isIdToHide(category.getId()) && (bindings = this.themeRegistry.getPresentationsBindingsFor(category)) == null) {
                        list.add(category);
                    }
                    ++n2;
                }
            }
            ColorDefinition[] colorDefinitionArray = colorDefinitions = this.themeRegistry.getColorsFor(this.currentTheme.getId());
            int n3 = colorDefinitions.length;
            n = 0;
            while (n < n3) {
                String catId;
                ColorDefinition colorDefinition = colorDefinitionArray[n];
                if (colorDefinition.isEditable() && !this.isIdToHide(colorDefinition.getId()) && ((catId = colorDefinition.getCategoryId()) == null && categoryId == null || catId != null && categoryId != null && categoryId.equals(catId)) && (colorDefinition.getDefaultsTo() == null || !this.parentIsInSameCategory(colorDefinition))) {
                    list.add(colorDefinition);
                }
                ++n;
            }
            FontDefinition[] fontDefinitionArray = fontDefinitions = this.themeRegistry.getFontsFor(this.currentTheme.getId());
            int n4 = fontDefinitions.length;
            n3 = 0;
            while (n3 < n4) {
                String catId;
                FontDefinition fontDefinition = fontDefinitionArray[n3];
                if (fontDefinition.isEditable() && !this.isIdToHide(fontDefinition.getId()) && ((catId = fontDefinition.getCategoryId()) == null && categoryId == null || catId != null && categoryId != null && categoryId.equals(catId)) && (fontDefinition.getDefaultsTo() == null || !this.parentIsInSameCategory(fontDefinition))) {
                    list.add(fontDefinition);
                }
                ++n3;
            }
            return list.toArray(new Object[list.size()]);
        }

        private boolean parentIsInSameCategory(ColorDefinition definition) {
            String defaultsTo = definition.getDefaultsTo();
            ColorDefinition[] colorDefinitionArray = this.registry.getColors();
            int n = colorDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColorDefinition colorDef = colorDefinitionArray[n2];
                if (colorDef.getId().equals(defaultsTo) && this.catIdEquals(colorDef.getCategoryId(), definition.getCategoryId())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private boolean parentIsInSameCategory(FontDefinition definition) {
            String defaultsTo = definition.getDefaultsTo();
            FontDefinition[] fontDefinitionArray = this.registry.getFonts();
            int n = fontDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                FontDefinition fontDef = fontDefinitionArray[n2];
                if (fontDef.getId().equals(defaultsTo) && this.catIdEquals(fontDef.getCategoryId(), definition.getCategoryId())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public Object getParent(Object element) {
            if (element instanceof ThemeElementCategory) {
                return this.registry;
            }
            if (element instanceof ColorDefinition) {
                ColorDefinition defaultElement;
                String defaultId = ((IHierarchalThemeElementDefinition)element).getDefaultsTo();
                if (defaultId != null && this.parentIsInSameCategory(defaultElement = this.registry.findColor(defaultId))) {
                    return defaultElement;
                }
                String categoryId = ((ColorDefinition)element).getCategoryId();
                return this.registry.findCategory(categoryId);
            }
            if (element instanceof FontDefinition) {
                FontDefinition defaultElement;
                String defaultId = ((FontDefinition)element).getDefaultsTo();
                if (defaultId != null && this.parentIsInSameCategory(defaultElement = this.registry.findFont(defaultId))) {
                    return defaultElement;
                }
                String categoryId = ((FontDefinition)element).getCategoryId();
                return this.registry.findCategory(categoryId);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ThemeElementCategory) {
                return !this.isIdToHide(((ThemeElementCategory)element).getId());
            }
            IHierarchalThemeElementDefinition def = (IHierarchalThemeElementDefinition)element;
            String id = def.getId();
            if (this.isIdToHide(id)) {
                return false;
            }
            Object[] defs = def instanceof ColorDefinition ? this.registry.getColors() : this.registry.getFonts();
            ColorDefinition[] colorDefinitionArray = defs;
            int n = defs.length;
            int n2 = 0;
            while (n2 < n) {
                ColorDefinition elementDefinition = colorDefinitionArray[n2];
                if (id.equals(elementDefinition.getDefaultsTo()) && this.catIdEquals(((ICategorizedThemeElementDefinition)def).getCategoryId(), ((ICategorizedThemeElementDefinition)elementDefinition).getCategoryId())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Object> list = new ArrayList<Object>();
            Object[] uncatChildren = this.getCategoryChildren(null);
            list.addAll(Arrays.asList(uncatChildren));
            ThemeElementCategory[] themeElementCategoryArray = ((IThemeRegistry)inputElement).getCategories();
            int n = themeElementCategoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] children;
                Set bindings;
                ThemeElementCategory category = themeElementCategoryArray[n2];
                if (category.getParentId() == null && !this.isIdToHide(category.getId()) && (bindings = this.themeRegistry.getPresentationsBindingsFor(category)) == null && (children = this.getChildren(category)) != null && children.length > 0) {
                    list.add(category);
                }
                ++n2;
            }
            return list.toArray(new Object[list.size()]);
        }

        public void dispose() {
            this.categoryMap.clear();
            this.themeManager.removePropertyChangeListener(this.themeChangeListener);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.categoryMap.clear();
            this.registry = (IThemeRegistry)newInput;
        }
    }

    private static class FontPreferenceNodePageOverride
    extends PreferenceNode {
        private PreferenceNode originalNode;
        private Set<String> prefIdsToHide;
        private IPreferencePage page = null;

        public FontPreferenceNodePageOverride(PreferenceNode originalNode, Set<String> prefIdsToHide) {
            super(originalNode.getId());
            this.originalNode = originalNode;
            this.prefIdsToHide = prefIdsToHide;
        }

        public String getLabelText() {
            return this.originalNode.getLabelText();
        }

        public Image getLabelImage() {
            return this.originalNode.getLabelImage();
        }

        public void createPage() {
            this.originalNode.createPage();
            IPreferencePage originalPage = this.originalNode.getPage();
            if (originalPage instanceof PreferencePage) {
                this.page = new MyFontsPrefPage((PreferencePage)originalPage, this.prefIdsToHide);
                if (this.getLabelImage() != null) {
                    this.page.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)new DBIconBinary(null, this.originalNode.getLabelImage())));
                }
                this.page.setTitle(this.getLabelText());
            } else {
                this.page = originalPage;
            }
        }

        public IPreferencePage getPage() {
            return this.page;
        }

        public void setPage(IPreferencePage page) {
            this.page = page;
            if (page == null) {
                this.originalNode.setPage(null);
            }
        }

        public void disposeResources() {
            super.disposeResources();
            if (this.page != null) {
                this.page.dispose();
                this.page = null;
            }
            this.originalNode.disposeResources();
        }
    }

    private static class MyFontsPrefPage
    implements IPreferencePage,
    IMessageProvider {
        private final PreferencePage fontsPage;
        private final Set<String> prefIdsToHide;

        public MyFontsPrefPage(PreferencePage fontsPage, Set<String> prefIdsToHide) {
            this.fontsPage = fontsPage;
            this.prefIdsToHide = prefIdsToHide;
        }

        public void createControl(Composite parent) {
            this.fontsPage.createControl(parent);
            Control[] prefsPageParts = parent.getChildren();
            Composite prefsPageContent = (Composite)prefsPageParts[Math.max(prefsPageParts.length - 1, 0)];
            Composite advancedCompositeSash = (Composite)prefsPageContent.getChildren()[0];
            Composite mainColumn = (Composite)advancedCompositeSash.getChildren()[0];
            FilteredTree tree = (FilteredTree)mainColumn.getChildren()[1];
            tree.getViewer().setContentProvider((IContentProvider)new FilteredThemeContentProvider(this.prefIdsToHide));
        }

        public void dispose() {
            this.fontsPage.dispose();
        }

        public Control getControl() {
            return this.fontsPage.getControl();
        }

        public String getDescription() {
            return this.fontsPage.getDescription();
        }

        public String getErrorMessage() {
            return this.fontsPage.getErrorMessage();
        }

        public Image getImage() {
            return this.fontsPage.getImage();
        }

        public String getMessage() {
            return this.fontsPage.getMessage();
        }

        public String getTitle() {
            return this.fontsPage.getTitle();
        }

        public void performHelp() {
            this.fontsPage.performHelp();
        }

        public void setDescription(String description) {
            this.fontsPage.setDescription(description);
        }

        public void setImageDescriptor(ImageDescriptor image) {
            this.fontsPage.setImageDescriptor(image);
        }

        public void setTitle(String title) {
            this.fontsPage.setTitle(title);
        }

        public void setVisible(boolean visible) {
            this.fontsPage.setVisible(visible);
        }

        public int getMessageType() {
            return this.fontsPage.getMessageType();
        }

        public Point computeSize() {
            return this.fontsPage.computeSize();
        }

        public boolean isValid() {
            return this.fontsPage.isValid();
        }

        public boolean okToLeave() {
            return this.fontsPage.okToLeave();
        }

        public boolean performCancel() {
            return this.fontsPage.performCancel();
        }

        public boolean performOk() {
            return this.fontsPage.performOk();
        }

        public void setContainer(IPreferencePageContainer preferencePageContainer) {
            this.fontsPage.setContainer(preferencePageContainer);
        }

        public void setSize(Point size) {
            this.fontsPage.setSize(size);
        }
    }
}

