/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.snowflake;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.snowflake.model.SnowflakeDataSource;
import org.jkiss.dbeaver.ext.snowflake.model.SnowflakeMetaModel;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class SnowflakeDataSourceProvider
extends JDBCDataSourceProvider {
    private static final Log log = Log.getLog(SnowflakeDataSourceProvider.class);

    public void init(@NotNull DBPPlatform platform) {
    }

    public long getFeatures() {
        return 3L;
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        String schemaName;
        StringBuilder url = new StringBuilder();
        url.append("jdbc:snowflake://").append(connectionInfo.getHostName());
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            url.append(":").append(connectionInfo.getHostPort());
        }
        url.append("/?");
        String warehouse = connectionInfo.getServerName();
        if (CommonUtils.isEmpty((String)warehouse)) {
            warehouse = connectionInfo.getProviderProperty("warehouse");
        }
        if (CommonUtils.isEmpty((String)(schemaName = connectionInfo.getProviderProperty("@dbeaver-schema@")))) {
            schemaName = connectionInfo.getProviderProperty("schema");
        }
        boolean hasParam = SnowflakeDataSourceProvider.addParameter(url, "db", connectionInfo.getDatabaseName(), false);
        hasParam = SnowflakeDataSourceProvider.addParameter(url, "warehouse", warehouse, hasParam);
        hasParam = SnowflakeDataSourceProvider.addParameter(url, "schema", schemaName, hasParam);
        SnowflakeDataSourceProvider.addParameter(url, "role", connectionInfo.getProviderProperty("@dbeaver-role@"), hasParam);
        return url.toString();
    }

    private static boolean addParameter(StringBuilder url, String name, String value, boolean hasParam) {
        if (!CommonUtils.isEmpty((String)value)) {
            if (hasParam) {
                url.append("&");
            }
            url.append(name).append("=").append(value);
            return true;
        }
        return hasParam;
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new SnowflakeDataSource(monitor, container, new SnowflakeMetaModel());
    }
}

