/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc;

import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public abstract class JDBCDataSourceProvider
implements DBPDataSourceProvider {
    protected static final Log log = Log.getLog(JDBCDataSourceProvider.class);

    public void init(@NotNull DBPPlatform platform) {
    }

    public DBPPropertyDescriptor[] getConnectionProperties(DBRProgressMonitor monitor, DBPDriver driver, DBPConnectionConfiguration connectionInfo) throws DBException {
        Collection<DBPPropertyDescriptor> props = null;
        if (driver.isInternalDriver()) {
            props = null;
        } else {
            Object driverInstance = driver.getDefaultDriverLoader().getDriverInstance(monitor);
            if (driverInstance instanceof Driver) {
                Driver jdbcDriver = (Driver)driverInstance;
                props = this.readDriverProperties(connectionInfo, jdbcDriver, driver.isPropagateDriverProperties());
            }
        }
        if (props == null) {
            return null;
        }
        return props.toArray(new DBPPropertyDescriptor[0]);
    }

    private Collection<DBPPropertyDescriptor> readDriverProperties(DBPConnectionConfiguration connectionInfo, Driver driver, boolean propagateDriverProperties) throws DBException {
        DriverPropertyInfo[] propDescs;
        Properties driverProps = new Properties();
        if (propagateDriverProperties) {
            driverProps.putAll((Map<?, ?>)connectionInfo.getProperties());
        }
        try {
            propDescs = driver.getPropertyInfo(connectionInfo.getUrl(), driverProps);
        }
        catch (Throwable e) {
            log.debug((Object)"Cannot obtain driver's properties", e);
            return null;
        }
        if (propDescs == null) {
            return null;
        }
        ArrayList<DBPPropertyDescriptor> properties = new ArrayList<DBPPropertyDescriptor>();
        DriverPropertyInfo[] driverPropertyInfoArray = propDescs;
        int n = propDescs.length;
        int n2 = 0;
        while (n2 < n) {
            DriverPropertyInfo desc = driverPropertyInfoArray[n2];
            if (desc != null && !"user".equals(desc.name) && !"password".equals(desc.name)) {
                desc.value = this.getConnectionPropertyDefaultValue(desc.name, desc.value);
                properties.add((DBPPropertyDescriptor)new PropertyDescriptor(ModelMessages.model_jdbc_driver_properties, desc.name, desc.name, desc.description, String.class, desc.required, (Object)desc.value, desc.choices, true));
            }
            ++n2;
        }
        return properties;
    }

    protected String getConnectionPropertyDefaultValue(String name, String value) {
        return value;
    }
}

