/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridCharset;
import org.jkiss.dbeaver.ext.cubrid.model.CubridCollation;
import org.jkiss.dbeaver.ext.cubrid.model.CubridPrivilage;
import org.jkiss.dbeaver.ext.cubrid.model.CubridSQLDialect;
import org.jkiss.dbeaver.ext.cubrid.model.CubridServer;
import org.jkiss.dbeaver.ext.cubrid.model.CubridShard;
import org.jkiss.dbeaver.ext.cubrid.model.CubridStructureAssistant;
import org.jkiss.dbeaver.ext.cubrid.model.meta.CubridMetaModel;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionResult;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.output.DBCOutputWriter;
import org.jkiss.dbeaver.model.exec.output.DBCServerOutputReader;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class CubridDataSource
extends GenericDataSource {
    private final CubridMetaModel metaModel = new CubridMetaModel();
    private final CubridPrivilageCache privilageCache = new CubridPrivilageCache();
    private final CubridServerCache serverCache = new CubridServerCache();
    private boolean supportMultiSchema;
    private boolean supportDbmsOutputPlCsql = false;
    private boolean isEOLVersion;
    private ArrayList<CubridCharset> charsets;
    private Map<String, CubridCollation> collations;
    private boolean isShard = false;
    private String shardType = "SHARD ID";
    private String shardVal = "0";
    private CubridOutputReader outputReader = null;

    public CubridDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull CubridMetaModel metaModel) throws DBException {
        super(monitor, container, (GenericMetaModel)metaModel, (SQLDialect)new CubridSQLDialect());
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast((Object)new CubridStructureAssistant(this));
        }
        if (adapter == DBCServerOutputReader.class) {
            return adapter.cast(this.outputReader);
        }
        return (T)super.getAdapter(adapter);
    }

    @NotNull
    public CubridDataSource getDataSource() {
        return this;
    }

    @NotNull
    public List<GenericSchema> getCubridUsers(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getSchemas();
    }

    @NotNull
    public List<CubridPrivilage> getCubridPrivilages(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.privilageCache.getAllObjects(monitor, (DBSObject)this);
    }

    public CubridServerCache getServerCache() {
        return this.serverCache;
    }

    @Nullable
    public List<CubridServer> getCubridServers(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.serverCache.getAllObjects(monitor, (DBSObject)this);
    }

    @NotNull
    public CubridServer getCubridServer(@NotNull DBRProgressMonitor monitor, @Nullable String name) throws DBException {
        return (CubridServer)this.serverCache.getObject(monitor, (DBSObject)this, name);
    }

    @NotNull
    public boolean supportsServer() {
        return this.getSupportMultiSchema();
    }

    @NotNull
    public CubridPrivilageCache getCubridPrivilageCache() {
        return this.privilageCache;
    }

    @Nullable
    public GenericTableBase findTable(@NotNull DBRProgressMonitor monitor, @Nullable String catalogName, @Nullable String schemaName, @NotNull String tableName) throws DBException {
        if (schemaName != null) {
            return this.getSchema(schemaName).getTable(monitor, tableName);
        }
        String[] schemas = tableName.split("\\.");
        if (schemas.length > 1) {
            return this.getSchema(schemas[0].toUpperCase()).getTable(monitor, schemas[1]);
        }
        for (GenericSchema schema : this.getCubridUsers(monitor)) {
            GenericTableBase table = schema.getTable(monitor, tableName);
            if (table == null) continue;
            return table;
        }
        return null;
    }

    @NotNull
    public CubridMetaModel getMetaModel() {
        return this.metaModel;
    }

    @NotNull
    public Collection<CubridCharset> getCharsets() {
        return this.charsets;
    }

    @NotNull
    public CubridCollation getCollation(String name) {
        return this.collations.get(name);
    }

    @NotNull
    public Collection<? extends DBSDataType> getDataTypes(@NotNull DBRProgressMonitor monitor) throws DBException {
        HashMap<String, DBSDataType> types = new HashMap<String, DBSDataType>();
        for (DBSDataType dataType : super.getDataTypes(monitor)) {
            types.put(dataType.getName(), dataType);
        }
        return types.values();
    }

    @Nullable
    public CubridCharset getCharset(@NotNull String name) {
        for (CubridCharset charset : this.charsets) {
            if (!charset.getName().equals(name)) continue;
            return charset;
        }
        return null;
    }

    @NotNull
    public ArrayList<String> getCollations() {
        ArrayList<String> collationList = new ArrayList<String>(this.collations.keySet());
        return collationList;
    }

    public void loadCharsets(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.charsets = new ArrayList();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this.container, (String)"Load charsets");){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement(this.wrapShardQuery("select * from db_charset"));){
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            CubridCharset charset = new CubridCharset(this, (ResultSet)dbResult);
                            this.charsets.add(charset);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Load charsets failed", (Throwable)e);
        }
        this.charsets.sort(DBUtils.nameComparator());
    }

    public void loadCollations(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.collations = new LinkedHashMap<String, CubridCollation>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this.container, (String)"Load collations");){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement(this.wrapShardQuery("show collation"));){
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String charsetName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"charset");
                            CubridCharset charset = this.getCharset(charsetName);
                            CubridCollation collation = new CubridCollation(charset, (ResultSet)dbResult);
                            this.collations.put(collation.getName(), collation);
                            charset.addCollation(collation);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Load collations failed", (Throwable)e);
        }
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        if (!this.isEOLVersion()) {
            this.loadCharsets(monitor);
            this.loadCollations(monitor);
        } else {
            DBWorkbench.getPlatformUI().showMessageBox("Connected CUBRID Info", "The connected CUBRID is an EOL version. Limited features are available.", false);
        }
        this.setTracking(monitor);
    }

    @NotNull
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.serverCache.clearCache();
        this.privilageCache.clearCache();
        return this;
    }

    protected void initializeContextState(DBRProgressMonitor monitor, JDBCExecutionContext context, JDBCExecutionContext initFrom) throws DBException {
        super.initializeContextState(monitor, context, initFrom);
        if (this.outputReader == null && this.checkSupportDbmsOutput(monitor, (DBCExecutionContext)context)) {
            this.outputReader = new CubridOutputReader();
        }
        if (this.outputReader != null) {
            this.outputReader.enableDbmsOutput(monitor, (DBCExecutionContext)context);
        }
    }

    public boolean getSupportMultiSchema() {
        return this.supportMultiSchema;
    }

    public void setSupportMultiSchema(@NotNull boolean supportMultiSchema) {
        this.supportMultiSchema = supportMultiSchema;
    }

    @NotNull
    public boolean isEOLVersion() {
        return this.isEOLVersion;
    }

    public void setEOLVersion(@NotNull boolean isEOLVersion) {
        this.isEOLVersion = isEOLVersion;
    }

    public boolean isShard() {
        return this.isShard;
    }

    public void setShard(boolean isShard) {
        this.isShard = isShard;
    }

    public void setShardType(String shardType) {
        this.shardType = shardType;
    }

    public void setShardVal(String shardVal) {
        this.shardVal = shardVal;
    }

    public String wrapShardQuery(String sql) {
        if (!this.isShard || this.hasShardHint(sql)) {
            return sql;
        }
        return this.getShardHint() + sql;
    }

    public StringBuilder wrapShardQuery(StringBuilder sql) {
        if (!this.isShard || this.hasShardHint(sql.toString())) {
            return sql;
        }
        return sql.insert(0, this.getShardHint());
    }

    public boolean hasShardHint(String sql) {
        Pattern idPattern = Pattern.compile("/\\*\\+[ \\t\\r\\n]*shard_id[ \\t\\r\\n]*\\([0-9 \\t\\r\\n]+\\)[ \\t\\r\\n]*\\*/", 10);
        Pattern valPattern = Pattern.compile("/\\*\\+[ \\t\\r\\n]*shard_val[ \\t\\r\\n]*\\([0-9 \\t\\r\\n]+\\)[ \\t\\r\\n]*\\*/", 10);
        return idPattern.matcher(sql).find() || valPattern.matcher(sql).find();
    }

    private String getShardHint() {
        String hintKey = "SHARD ID".equalsIgnoreCase(this.shardType) ? "SHARD_ID" : "SHARD_VAL";
        return String.format("/*+ %s(%s) */ ", hintKey, this.shardVal);
    }

    public CubridShard getCubridShard() {
        return new CubridShard(this, this.shardType, this.shardVal);
    }

    public List<CubridShard> getCubridShards() {
        return Collections.singletonList(new CubridShard(this, this.shardType, this.shardVal));
    }

    @NotNull
    public boolean splitProceduresAndFunctions() {
        return true;
    }

    @Nullable
    public GenericSchema getSchema(String name) {
        return super.getSchema(name == null ? null : name.toUpperCase(Locale.ENGLISH));
    }

    private void setTracking(@NotNull DBRProgressMonitor monitor) throws DBException {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this.container, (String)"set trace");){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCStatement st = session.createStatement();){
                    if (store.getBoolean("statistic_trace")) {
                        st.execute(this.wrapShardQuery("SET TRACE ON"));
                    }
                    if (!CommonUtils.isEmpty((String)store.getString("statistic"))) {
                        st.execute(this.wrapShardQuery("set @collect_exec_stats = 1"));
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Can't set trace", (Throwable)e);
        }
    }

    public boolean isSupportEnableDbms() {
        return this.getContainer().getPreferenceStore().getBoolean("pref.dbms.output");
    }

    public boolean isSupportDbmsOutputPlCsql() {
        return this.supportDbmsOutputPlCsql;
    }

    private boolean checkSupportDbmsOutput(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context) throws DBException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = (JDBCSession)context.openSession(monitor, DBCExecutionPurpose.UTIL, "Read Database Version");){
                this.readDatabaseServerVersion((Connection)session, (DatabaseMetaData)session.getMetaData());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Check Support DBMSOutput failed", (Throwable)e);
        }
        this.supportDbmsOutputPlCsql = this.isServerVersionAtLeast(11, 4);
        return this.supportDbmsOutputPlCsql;
    }

    private class CubridOutputReader
    implements DBCServerOutputReader {
        private CubridOutputReader() {
        }

        public boolean isServerOutputEnabled() {
            return CubridDataSource.this.getContainer().getPreferenceStore().getBoolean("pref.dbms.output");
        }

        public boolean isAsyncOutputReadSupported() {
            return false;
        }

        public void enableDbmsOutput(DBRProgressMonitor monitor, DBCExecutionContext context) throws DBCException {
            if (!this.isServerOutputEnabled()) {
                return;
            }
            int bufferSize = CubridDataSource.this.getContainer().getPreferenceStore().getInt("pref.dbms.output.buffer.size");
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCSession session = (JDBCSession)context.openSession(monitor, DBCExecutionPurpose.UTIL, "Enable DBMS output");){
                    CallableStatement cstmt = session.getOriginal().prepareCall("CALL dbms_output.enable(?)");
                    cstmt.setInt(1, bufferSize);
                    cstmt.execute();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, context);
            }
        }

        public void readServerOutput(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @Nullable DBCExecutionResult executionResult, @Nullable DBCStatement statement, @NotNull DBCOutputWriter output) throws DBCException {
            Throwable throwable = null;
            Object var7_8 = null;
            try (JDBCSession session = (JDBCSession)context.openSession(monitor, DBCExecutionPurpose.UTIL, "Read DBMS output");){
                try {
                    Throwable throwable2 = null;
                    Object var10_14 = null;
                    try (CallableStatement cstmt = session.getOriginal().prepareCall("CALL dbms_output.get_line(?,?)");){
                        cstmt.registerOutParameter(1, 12);
                        cstmt.registerOutParameter(2, 4);
                        int status = 0;
                        while (status == 0) {
                            cstmt.execute();
                            status = cstmt.getInt(2);
                            if (status != 0) continue;
                            String line = cstmt.getString(1);
                            output.println(null, line);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (SQLException e) {
                    throw new DBCException((Throwable)e, context);
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }

    public class CubridPrivilageCache
    extends JDBCObjectCache<CubridDataSource, CubridPrivilage> {
        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull CubridDataSource container) throws SQLException {
            String sql = CubridDataSource.this.wrapShardQuery("select * from db_user");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql);
            return dbStat;
        }

        @Nullable
        protected CubridPrivilage fetchObject(@NotNull JDBCSession session, @NotNull CubridDataSource container, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
            return new CubridPrivilage(container, name, dbResult);
        }
    }

    public class CubridServerCache
    extends JDBCObjectCache<CubridDataSource, CubridServer> {
        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull CubridDataSource container) throws SQLException {
            String sql = CubridDataSource.this.wrapShardQuery("select * from db_server");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql);
            return dbStat;
        }

        @Nullable
        protected CubridServer fetchObject(@NotNull JDBCSession session, @NotNull CubridDataSource container, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new CubridServer(container, dbResult);
        }
    }
}

