/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.statistics;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.WebUtils;
import org.jkiss.dbeaver.ui.statistics.FeatureStatisticsCollector;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class StatisticsTransmitter {
    private static final Log log = Log.getLog(StatisticsTransmitter.class);
    public static final String STATS_STAGE_DBEAVER = "stats.stage.dbeaver.infra";
    public static final String STATS_DBEAVER_COM = "stats.dbeaver.com";
    private static final String URL_TEMPLATE = "https://%s/send-statistics";
    private final String endpoint;
    private final String workspaceId;

    public StatisticsTransmitter(String workspaceId) {
        this.workspaceId = workspaceId;
        this.endpoint = System.getProperty("lm.stage.mode") != null ? URL_TEMPLATE.formatted(STATS_STAGE_DBEAVER) : URL_TEMPLATE.formatted(STATS_DBEAVER_COM);
    }

    public void send(boolean detached) {
        if (detached) {
            new AbstractJob("Usage statistics transmitter"){
                {
                    this.setSystem(true);
                }

                protected IStatus run(DBRProgressMonitor monitor) {
                    StatisticsTransmitter.this.sendStatistics(monitor, false);
                    return Status.OK_STATUS;
                }
            }.schedule(3000L);
        } else {
            this.sendStatistics((DBRProgressMonitor)new LoggingProgressMonitor(log), true);
        }
    }

    private void sendStatistics(DBRProgressMonitor monitor, boolean sendActiveSession) {
        try {
            String appSessionId = DBWorkbench.getPlatform().getApplication().getApplicationRunId();
            Path activityLogsFolder = FeatureStatisticsCollector.getActivityLogsFolder();
            if (Files.exists(activityLogsFolder, new LinkOption[0]) && !Files.isWritable(activityLogsFolder)) {
                log.debug((Object)"Read-only metadata folder - can't send statistics");
                return;
            }
            Throwable throwable = null;
            Object var6_8 = null;
            try (Stream<Path> list = Files.list(activityLogsFolder);){
                List<Path> logFiles = list.filter(path -> path.getFileName().toString().endsWith(".log")).toList();
                for (Path logFile : logFiles) {
                    String fileName = logFile.getFileName().toString();
                    String[] parts = (fileName = fileName.substring(0, fileName.length() - 4)).split("_");
                    if (parts.length != 2) continue;
                    String timestamp = parts[0];
                    String sessionId = parts[1];
                    if (sendActiveSession) {
                        if (!sessionId.equals(appSessionId)) continue;
                        this.sendLogFile(logFile, timestamp, sessionId);
                        break;
                    }
                    if (sessionId.equals(appSessionId)) continue;
                    this.sendLogFile(logFile, timestamp, sessionId);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error sending statistics", (Throwable)e);
        }
    }

    private void sendLogFile(Path logFile, String timestamp, String sessionId) {
        if (Files.exists(logFile, new LinkOption[0]) && !Files.isWritable(logFile)) {
            log.debug((Object)("Statistics file is read-only, skipping transmission: " + String.valueOf(logFile)));
            return;
        }
        try {
            try {
                HashMap<String, String> parametersMap = new HashMap<String, String>();
                parametersMap.put("Content-Type", "text/plain");
                parametersMap.put("Locale", Locale.getDefault().toString());
                parametersMap.put("Country", Locale.getDefault().getISO3Country());
                parametersMap.put("Timezone", TimeZone.getDefault().getID());
                parametersMap.put("Application-Name", GeneralUtils.getProductName());
                parametersMap.put("Application-Version", GeneralUtils.getProductVersion().toString());
                parametersMap.put("OS", CommonUtils.notEmpty((String)System.getProperty("os.name")));
                if (DBWorkbench.isPlatformStarted()) {
                    parametersMap.putAll(DBWorkbench.getPlatform().getApplication().getAdditionalApplicationProperties());
                }
                URLConnection urlConnection = WebUtils.openURLConnection((String)(this.endpoint + "?session=" + sessionId + "&time=" + timestamp), null, (String)this.workspaceId, (String)"POST", (int)0, (int)5000, parametersMap);
                ((HttpURLConnection)urlConnection).setFixedLengthStreamingMode(Files.size(logFile));
                Throwable throwable = null;
                Object var7_10 = null;
                try (OutputStream outputStream = urlConnection.getOutputStream();){
                    Files.copy(logFile, outputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                try {
                    throwable = null;
                    var7_10 = null;
                    try (InputStream inputStream = urlConnection.getInputStream();){
                        if (inputStream != null) {
                            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                            IOUtils.copyStream((InputStream)inputStream, (OutputStream)buffer);
                            log.debug((Object)("Statistics sent (" + buffer.toString(StandardCharsets.UTF_8) + ")"));
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    log.debug((Object)"Error reading statistics server response");
                }
                ((HttpURLConnection)urlConnection).disconnect();
            }
            catch (Exception e) {
                log.debug((Object)("Error sending statistics file '" + String.valueOf(logFile.toAbsolutePath()) + "'."), (Throwable)e);
                try {
                    Files.delete(logFile);
                }
                catch (IOException ex) {
                    log.debug((Object)("Error deleting file with usage statistics '" + String.valueOf(logFile.toAbsolutePath()) + "'."), (Throwable)ex);
                }
            }
        }
        finally {
            try {
                Files.delete(logFile);
            }
            catch (IOException ex) {
                log.debug((Object)("Error deleting file with usage statistics '" + String.valueOf(logFile.toAbsolutePath()) + "'."), (Throwable)ex);
            }
        }
    }
}

