/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBPVirtualObject;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.meta.IPropertyValueTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.utils.CommonUtils;

public class GenericSchema
extends GenericObjectContainer
implements DBSSchema,
DBPSystemObject,
DBPVirtualObject {
    @Nullable
    private final GenericCatalog catalog;
    @NotNull
    private final String schemaName;
    private boolean virtualSchema;

    public GenericSchema(@NotNull GenericDataSource dataSource, @Nullable GenericCatalog catalog, @NotNull String schemaName) {
        super(dataSource);
        this.catalog = catalog;
        this.schemaName = schemaName;
    }

    @Override
    @Property(optional=true, order=2, labelProvider=GenericCatalog.CatalogNameTermProvider.class)
    @Nullable
    public GenericCatalog getCatalog() {
        return this.catalog;
    }

    @Override
    public GenericSchema getSchema() {
        return this;
    }

    @Override
    public GenericSchema getObject() {
        return this;
    }

    @Property(viewable=true, order=1, labelProvider=SchemaNameTermProvider.class)
    @NotNull
    public String getName() {
        return this.schemaName;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.catalog != null ? this.catalog : this.getDataSource().getContainer();
    }

    @NotNull
    public Class<? extends DBSEntity> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return GenericTable.class;
    }

    public boolean isSystem() {
        return this.getDataSource().getMetaModel().isSystemSchema(this);
    }

    public boolean isVirtual() {
        return this.virtualSchema;
    }

    public void setVirtual(boolean nullSchema) {
        this.virtualSchema = nullSchema;
    }

    public static class SchemaNameTermProvider
    implements IPropertyValueTransformer<DBSObject, String> {
        public String transform(DBSObject object, String value) throws IllegalArgumentException {
            String schemaTerm = object.getDataSource().getInfo().getSchemaTerm();
            if (!CommonUtils.isEmpty((String)schemaTerm)) {
                return schemaTerm + " " + ModelMessages.model_navigator_Name;
            }
            return ModelMessages.model_navigator_Name;
        }
    }
}

