/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.cli;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.cli.CLIException;
import org.jkiss.dbeaver.model.cli.CommandLineContext;

public class CLIUtils {
    private static final Log log = Log.getLog(CLIUtils.class);

    @Nullable
    public static String readValueFromFileOrSystemIn(@NotNull CommandLineContext context) throws CLIException {
        String value;
        Path inputFile = (Path)context.getContextParameter("inputFile");
        if (inputFile == null) {
            value = CLIUtils.tryReadFromSystemIn();
        } else {
            if (Files.notExists(inputFile, new LinkOption[0])) {
                throw new CLIException("Input file does not exist: " + String.valueOf(inputFile), 2);
            }
            try {
                value = Files.readString(inputFile);
            }
            catch (IOException e) {
                throw new CLIException("Error reading GQL from input file: " + String.valueOf(inputFile), (Throwable)e, 1);
            }
        }
        return value;
    }

    @Nullable
    private static String tryReadFromSystemIn() {
        try {
            if (System.in.available() > 0) {
                return new String(System.in.readAllBytes(), StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error reading from system in", (Throwable)e);
            return null;
        }
        return null;
    }
}

