/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.exec.SQLNativeExecutorDescriptor;
import org.jkiss.dbeaver.ui.actions.exec.SQLNativeExecutorRegistry;
import org.jkiss.dbeaver.ui.actions.exec.SQLScriptExecutor;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public class NavigatorHandlerExec
extends AbstractHandler {
    private static final Log log = Log.getLog(NavigatorHandlerExec.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection.isEmpty()) {
            return null;
        }
        DBNNode node = NavigatorUtils.getSelectedNode(selection);
        assert (node instanceof DBNResource);
        IResource resource = ((DBNResource)node).getResource();
        assert (resource instanceof IFile);
        final IFile script = (IFile)resource;
        final DBPDataSourceContainer container = EditorUtils.getFileDataSource((IFile)script);
        if (container == null) {
            return null;
        }
        new AbstractJob("Calling native execution"){

            protected IStatus run(DBRProgressMonitor monitor) {
                RCPProject project = (RCPProject)DBPPlatformDesktop.getInstance().getWorkspace().getProject(script.getProject());
                String resourcePath = project.getResourcePath((IResource)script);
                String catalog = (String)project.getResourceProperty(resourcePath, "default-catalog");
                try {
                    SQLNativeExecutorDescriptor executorDescriptor;
                    Collection children;
                    DBSObject foundCatalog;
                    DBPDataSource dataSource;
                    if (!container.isConnected()) {
                        container.connect(monitor, true, false);
                    }
                    DBPDataSource launchObject = dataSource = container.getDataSource();
                    if (catalog != null && dataSource instanceof DBSObjectContainer && DBSCatalog.class.isAssignableFrom(((DBSObjectContainer)dataSource).getPrimaryChildType(monitor)) && (foundCatalog = (DBSObject)DBUtils.findObject((Collection)(children = ((DBSObjectContainer)dataSource).getChildren(monitor)), (String)catalog)) != null) {
                        launchObject = foundCatalog;
                    }
                    if ((executorDescriptor = SQLNativeExecutorRegistry.getInstance().getExecutorDescriptor(container)) != null && executorDescriptor.getNativeExecutor() != null) {
                        Path file = DBFUtils.resolvePathFromURI((DBRProgressMonitor)monitor, (DBPProject)project, (URI)script.getLocationURI());
                        SQLScriptExecutor<? extends DBSObject> nativeExecutor = executorDescriptor.getNativeExecutor();
                        DBPDataSource finalLaunchObject = launchObject;
                        UIUtils.syncExec(() -> 1.lambda$0(nativeExecutor, (DBSObject)finalLaunchObject, file));
                    }
                }
                catch (Throwable exception) {
                    return Status.error((String)"Error calling native execution", (Throwable)exception);
                }
                return Status.OK_STATUS;
            }

            private static /* synthetic */ void lambda$0(SQLScriptExecutor sQLScriptExecutor, DBSObject dBSObject, Path path) {
                try {
                    sQLScriptExecutor.execute(dBSObject, path);
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
            }
        }.schedule();
        return null;
    }
}

