/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.AbstractLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizerExt;
import org.jkiss.dbeaver.runtime.DBInterruptedException;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.AbstractUIJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class LoadingJob<RESULT>
extends AbstractJob {
    private static final Log log = Log.getLog(LoadingJob.class);
    public static final Object LOADING_FAMILY = new Object();
    private boolean loadFinished;
    private boolean showErrors = true;
    private final ILoadService<RESULT> loadingService;
    private final ILoadVisualizer<RESULT> visualizer;

    public static <RESULT> LoadingJob<RESULT> createService(@NotNull ILoadService<RESULT> loadingService, @NotNull ILoadVisualizer<RESULT> visualizer) {
        return new LoadingJob<RESULT>(loadingService, visualizer);
    }

    public LoadingJob(@NotNull ILoadService<RESULT> loadingService, @NotNull ILoadVisualizer<RESULT> visualizer) {
        super(loadingService.getServiceName());
        this.loadingService = loadingService;
        this.visualizer = visualizer;
        this.setUser(false);
    }

    public ILoadService<RESULT> getLoadingService() {
        return this.loadingService;
    }

    public boolean isForceCancel() {
        return this.loadingService.isForceCancel();
    }

    @NotNull
    public ILoadVisualizer<RESULT> getVisualizer() {
        return this.visualizer;
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public void setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
    }

    @NotNull
    protected IStatus run(@NotNull DBRProgressMonitor monitor) {
        monitor = this.visualizer.overwriteMonitor(monitor);
        ILoadService<RESULT> iLoadService = this.loadingService;
        if (iLoadService instanceof AbstractLoadService) {
            AbstractLoadService als = (AbstractLoadService)iLoadService;
            als.initService(monitor, (AbstractJob)this);
        }
        LoadingUIJob updateUIJob = new LoadingUIJob(this);
        updateUIJob.schedule();
        Throwable error = null;
        Object result = null;
        monitor.beginTask(this.getName(), 1);
        try {
            try {
                result = this.loadingService.evaluate(monitor);
            }
            catch (InvocationTargetException e) {
                error = e.getTargetException();
                this.loadFinished = true;
                UIUtils.asyncExec(new LoadFinisher(result, error));
                monitor.done();
            }
            catch (InterruptedException interruptedException) {
                Status status = new Status(8, "org.jkiss.dbeaver.ui", "Loading interrupted");
                this.loadFinished = true;
                UIUtils.asyncExec(new LoadFinisher(result, error));
                monitor.done();
                return status;
            }
        }
        finally {
            this.loadFinished = true;
            UIUtils.asyncExec(new LoadFinisher(result, error));
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(@NotNull Object family) {
        return family == this.loadingService.getFamily();
    }

    public void syncRun() {
        this.run((DBRProgressMonitor)new VoidProgressMonitor());
    }

    private class LoadFinisher
    implements Runnable {
        private final RESULT innerResult;
        private final Throwable innerError;

        LoadFinisher(@Nullable RESULT innerResult, Throwable innerError) {
            this.innerResult = innerResult;
            this.innerError = innerError;
        }

        @Override
        public void run() {
            ILoadVisualizer iLoadVisualizer;
            try {
                LoadingJob.this.visualizer.completeLoading(this.innerResult);
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
            if (this.innerError != null && !(this.innerError instanceof DBInterruptedException)) {
                if (LoadingJob.this.showErrors) {
                    DBWorkbench.getPlatformUI().showError(LoadingJob.this.getName(), null, this.innerError);
                } else {
                    log.debug((Object)CommonUtils.getAllExceptionMessages((Throwable)this.innerError));
                }
            }
            if ((iLoadVisualizer = LoadingJob.this.visualizer) instanceof ILoadVisualizerExt) {
                ILoadVisualizerExt lve = (ILoadVisualizerExt)iLoadVisualizer;
                lve.finalizeLoading();
            }
        }
    }

    class LoadingUIJob<JOB_RESULT>
    extends AbstractUIJob {
        private static final long DELAY = 100L;
        private final ILoadVisualizer<JOB_RESULT> visualizer;

        LoadingUIJob(LoadingJob<JOB_RESULT> loadingJob2) {
            super(loadingJob2.getName());
            this.visualizer = loadingJob2.getVisualizer();
            this.setSystem(true);
        }

        @Override
        @NotNull
        public IStatus runInUIThread(@NotNull DBRProgressMonitor monitor) {
            if (!this.visualizer.isCompleted() && !LoadingJob.this.loadFinished) {
                this.visualizer.visualizeLoading();
                this.schedule(100L);
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == LOADING_FAMILY;
        }

        protected void canceling() {
            super.canceling();
        }
    }
}

