%%%
%%% Check that the limit imposed on the depth of sharing state value
%%% chains is imposed.
%%%

-module(ss_depth_limit).

-export([f/0]).

-if(false).
%% f/0 is generated by the following program. N should be
%% SS_DEPTH_LIMIT + 1 (from beam_ssa_ss.erl).
do(N) ->
    Data = [
	    "-module(ss_depth_limit).\n\n",
	    "-export([f/0]).\n\n",
	    "f() ->\n",
	    "%ssa% fail () when post_ssa_opt ->\n"
	    "%ssa% ret(X) { unique => [X] }.\n"
	    "  X0 = e:f(),\n",
	    [io_lib:format("  X~p = {X~p,e:f()},~n", [X, X-1])
	     || X<- lists:seq(1, N)],
	    io_lib:format("  X~p.~n", [N])
	   ],
    file:write_file("ss_depth_limit.erl", Data).
-endif.

f() ->
%ssa% fail () when post_ssa_opt ->
%ssa% ret(X) { unique => [X] }.
  X0 = e:f(),
  X1 = {X0,e:f()},
  X2 = {X1,e:f()},
  X3 = {X2,e:f()},
  X4 = {X3,e:f()},
  X5 = {X4,e:f()},
  X6 = {X5,e:f()},
  X7 = {X6,e:f()},
  X8 = {X7,e:f()},
  X9 = {X8,e:f()},
  X10 = {X9,e:f()},
  X11 = {X10,e:f()},
  X12 = {X11,e:f()},
  X13 = {X12,e:f()},
  X14 = {X13,e:f()},
  X15 = {X14,e:f()},
  X16 = {X15,e:f()},
  X17 = {X16,e:f()},
  X18 = {X17,e:f()},
  X19 = {X18,e:f()},
  X20 = {X19,e:f()},
  X21 = {X20,e:f()},
  X22 = {X21,e:f()},
  X23 = {X22,e:f()},
  X24 = {X23,e:f()},
  X25 = {X24,e:f()},
  X26 = {X25,e:f()},
  X27 = {X26,e:f()},
  X28 = {X27,e:f()},
  X29 = {X28,e:f()},
  X30 = {X29,e:f()},
  X31 = {X30,e:f()},
  X31.
